<?php

require_once plugin_dir_path(__FILE__) . '../classes/class.settings.php';

class contact {

	var $aFormSettings = false;
	var $aPostResult = false;
	var $bPostError = false;
	var $aPostErrors = false;

	
	function __construct($sSetting) {
		$this->aFormSettings = $sSetting;
	}


	public function postRentalRequest($aPostData=false) {
		
		if(empty($aPostData)) {
			$this->bPostError = true;
			$this->aPostErrors = array();
			$this->aPostErrors[] = 'no-post-data';
			return;
		}
		
		$sEndpoint = OVIS_DOMAIN_URL . '/search/rentalrequest/';
		$aHeaders = $this->aFormSettings['settings']['authentication_header'];

		$oParams = new stdClass();
		$oParams->presentationId = !empty($aPostData['ovis-contact-object']) ? (int) $aPostData['ovis-contact-object'] : NULL;
		$oParams->name = !empty($aPostData['ovis-contact-name']) ? $aPostData['ovis-contact-name'] : NULL;
		$oParams->gender = NULL;
		$oParams->address = !empty($aPostData['ovis-contact-adres']) ? $aPostData['ovis-contact-adres'] : NULL;
		
		if(!empty($aPostData['ovis-contact-housenumber'])) {
			$oParams->address .= ' '.$aPostData['ovis-contact-housenumber'];
		}
		
		$sMessageStart = false;
		if(!empty($aPostData['ovis-contact-afhaaltijd'])) {
			$sMessageStart .= "Gewenste afhaaltijd: ".$aPostData['ovis-contact-afhaaltijd']."\n";				
		}
		
		if(!empty($aPostData['ovis-contact-periode'])) {
			$sMessageStart .= "Gewenste huurperiode: ".$aPostData['ovis-contact-periode']."\n";				
		}
		
		if(!empty($sMessageStart)) {
			$aPostData['ovis-contact-message'] = $sMessageStart . "\n" . $aPostData['ovis-contact-message'];
		}
		
		$oParams->numberOfPersons = !empty($aPostData['ovis-contact-persons']) ? (int) $aPostData['ovis-contact-persons'] : NULL;
		$oParams->postalCode = !empty($aPostData['ovis-contact-zipcode']) ? $aPostData['ovis-contact-zipcode'] : NULL;
		$oParams->city = !empty($aPostData['ovis-contact-city']) ? $aPostData['ovis-contact-city'] : NULL;
		$oParams->phoneNumber = !empty($aPostData['ovis-contact-phone']) ? $aPostData['ovis-contact-phone'] : NULL;
		$oParams->email = !empty($aPostData['ovis-contact-contactperson']) ? $aPostData['ovis-contact-contactperson'] : NULL;
		$oParams->description = !empty($aPostData['ovis-contact-message']) ? $aPostData['ovis-contact-message'] : NULL;
		$oParams->dateStart = !empty($aPostData['ovis-contact-periodevan']) ? date('Y-m-d',strtotime($aPostData['ovis-contact-periodevan'])) : NULL;
		$oParams->dateEnd = !empty($aPostData['ovis-contact-periodetot']) ? date('Y-m-d',strtotime($aPostData['ovis-contact-periodetot'])) : NULL;
		$oParams->detailURL = !empty($aPostData['ovis-contact-objecturl']) ? $aPostData['ovis-contact-objecturl'] : false;
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);

		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		if(empty($oResult->result) || !empty($oResult->errors)) {
			$this->aPostResult = false;
			$this->bPostError = true;
			$this->aPostErrors = array();
			
			if(!empty($oResult->errors)) {
				foreach($oResult->errors as $sError) {
					$this->aPostErrors[$sError] = true;
				}
			} else {
				$this->aPostErrors['general-error'] = true;
			}
		} else {
			$this->aPostResult = true;
			$this->bPostError = false;
			$this->aPostErrors = false;
		}
		
		return;
	}


	public function postTradeinrequestRequest($aPostData=false) {

		if(empty($aPostData)) {
			$this->bPostError = true;
			$this->aPostErrors = array();
			$this->aPostErrors[] = 'no-post-data';
			return;
		}

		$sEndpoint = OVIS_DOMAIN_URL . '/search/tradeinrequest/';
		$aHeaders = $this->aFormSettings['settings']['authentication_header'];

		$oParams = new stdClass();
		$oParams->presentationId = !empty($aPostData['ovis-contact-object']) ? (int) $aPostData['ovis-contact-object'] : NULL;
		$oParams->licensePlate = !empty($aPostData['ovis-contact-kenteken']) ? $aPostData['ovis-contact-kenteken'] : NULL;
		
		$sCategory = !empty($aPostData['ovis-contact-soort']) ? $aPostData['ovis-contact-soort'] : NULL;
		
		switch($sCategory) {
			case 'caravan':
				$sCategory = 'caravan';
				break;
			case 'kampeerauto';
				$sCategory = 'camper';
				break;
			default:
				$sCategory = 'other';
				break;
		}
		
		$oParams->category = $sCategory;
		$oParams->brand = !empty($aPostData['ovis-contact-merk']) ? $aPostData['ovis-contact-merk'] : NULL;
		$oParams->modelType = !empty($aPostData['ovis-contact-model']) ? $aPostData['ovis-contact-model'] : NULL;
		$oParams->constructionYear = !empty($aPostData['ovis-contact-bouwjaar']) ? (int) str_replace(array(' ','.',',','-','_'),array('','','','',''),$aPostData['ovis-contact-bouwjaar']) : NULL;
		$oParams->mileage = !empty($aPostData['ovis-contact-kilometerstand']) ? (int) str_replace(array(' ','.',',','-','_'),array('','','','',''),$aPostData['ovis-contact-kilometerstand']) : NULL;
		
		if(!empty($aPostData['ovis-contact-conditie']) && $aPostData['ovis-contact-conditie'] != 'nb') {
			$oParams->condition = $aPostData['ovis-contact-conditie'];
		}
		if(!empty($aPostData['ovis-contact-schade']) && $aPostData['ovis-contact-schade'] != 'nb') {
			$oParams->damageFree = strtolower($aPostData['ovis-contact-schade']) == 'ja' ? false : true;
		}
		if(!empty($aPostData['ovis-contact-staatbekleding']) && $aPostData['ovis-contact-staatbekleding'] != 'nb') {
			$oParams->conditionUpholstery = $aPostData['ovis-contact-staatbekleding'];
		}
		if(!empty($aPostData['ovis-contact-staatbanden']) && $aPostData['ovis-contact-staatbanden'] != 'nb') {
			$oParams->conditionTires = $aPostData['ovis-contact-staatbanden'];
		}
		if(!empty($aPostData['ovis-contact-indication']) && $aPostData['ovis-contact-indication'] != 'nb') {
			$oParams->priceIndication = $aPostData['ovis-contact-indication'];
		}
		
		$oParams->name = !empty($aPostData['ovis-contact-name']) ? $aPostData['ovis-contact-name'] : NULL;
		$oParams->gender = NULL;
		$oParams->phoneNumber = !empty($aPostData['ovis-contact-phone']) ? $aPostData['ovis-contact-phone'] : NULL;
		$oParams->email = !empty($aPostData['ovis-contact-contactperson']) ? $aPostData['ovis-contact-contactperson'] : NULL;
		$oParams->description = !empty($aPostData['ovis-contact-message']) ? $aPostData['ovis-contact-message'] : NULL;
		$oParams->detailURL = !empty($aPostData['ovis-contact-objecturl']) ? $aPostData['ovis-contact-objecturl'] : false;
		
		$aInruilImages = array();

		if(!empty($aPostData['ovis-contact-inruil-images'])) {
			foreach($aPostData['ovis-contact-inruil-images'] as $sInruilImage) {
				
				$sImageURL = ABSPATH.'wp-content/cache/ovis/'.$sInruilImage;
				$aInruilImages[] = base64_encode(file_get_contents($sImageURL));
			}
		}

		if(!empty($aInruilImages)) {
			$oParams->images = $aInruilImages;
		}
	
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		if(empty($oResult->result) || !empty($oResult->errors)) {
			$this->aPostResult = false;
			$this->bPostError = true;
			$this->aPostErrors = array();
			
			if(!empty($oResult->errors)) {
				foreach($oResult->errors as $sError) {
					$this->aPostErrors[$sError] = true;
				}
			} else {
				$this->aPostErrors['general-error'] = true;	
			}
		} else {
			
			if(!empty($aPostData['ovis-contact-inruil-images'])) {
				foreach($aPostData['ovis-contact-inruil-images'] as $sInruilImage) {	
					$sImageURL = ABSPATH.'wp-content/cache/ovis/'.$sInruilImage;
					unlink($sImageURL);
				}
			}
			
			$this->aPostResult = true;
			$this->bPostError = false;
			$this->aPostErrors = false;
		}
		
		return;
	}

	
	public function postContactRequest($aPostData=false) {
		
		$sEndpoint = OVIS_DOMAIN_URL . '/search/contactdealer/';
		$aHeaders = $this->aFormSettings['settings']['authentication_header'];

		$oParams = new stdClass();
		$oParams->presentationId = !empty($aPostData['ovis-contact-object']) ? (int) $aPostData['ovis-contact-object'] : NULL;
		
		$oParams->subject = !empty($aPostData['ovis-contact-subject']) ? $aPostData['ovis-contact-subject'] : NULL;
		$oParams->date = !empty($aPostData['ovis-contact-date']) ? $aPostData['ovis-contact-time'] : NULL;
		$oParams->time = !empty($aPostData['ovis-contact-time']) ? $aPostData['ovis-contact-time'] : NULL;			
		
		$oParams->name = !empty($aPostData['ovis-contact-name']) ? $aPostData['ovis-contact-name'] : NULL;
		$oParams->gender = NULL;
		$oParams->phoneNumber = !empty($aPostData['ovis-contact-phone']) ? $aPostData['ovis-contact-phone'] : NULL;
		$oParams->email = !empty($aPostData['ovis-contact-contactperson']) ? $aPostData['ovis-contact-contactperson'] : NULL;
		$oParams->message = !empty($aPostData['ovis-contact-message']) ? $aPostData['ovis-contact-message'] : NULL;
		$oParams->detailURL = !empty($aPostData['ovis-contact-objecturl']) ? $aPostData['ovis-contact-objecturl'] : false;
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);

		if(empty($oResult->result) || !empty($oResult->errors)) {
			$this->aPostResult = false;
			$this->bPostError = true;
			$this->aPostErrors = array();
			
			if(!empty($oResult->errors)) {
				foreach($oResult->errors as $sError) {
					$this->aPostErrors[$sError] = true;
				}
			} else {
				$this->aPostErrors['general-error'] = true;
			}
		} else {
			$this->aPostResult = true;
			$this->bPostError = false;
			$this->aPostErrors = false;
		}
		
		return;
	}

}