<?php

    require_once(plugin_dir_path(__FILE__) . '../classes/class.settings.php');

    class data {
		
		var $oObjectData = false;
		var $oObjectSearchData = false;
		var $oObjectFilters = false;
		var $aObjectMinMaxData = false;
		var $aObjectMinMaxValues = false;
		var $aObjectBrands = false;
		var $aObjectCategory = false;
		var $aObjectCondition = false;
		var $aObjectRental = false;
		var $aObjectCategoryData = false;
		var $aObjectConditionNew = false;
		var $aObjectConditionOccasion = false;
		var $aObjectFilterBlocks = false;
		var $aObjectId = false;
		var $aObjectSettings = false;
		var $aObjectPage = false;
		var $bShowSearchForm = true;
		var $bSearchSorting = false;
		var $sShowSold = false;
		var $sBrandsFixed = false;
		var $sKeywordFixed = false;
		var $sBuildYearFixed = false;
		var $sModelYearFixed = false;
		var $bUserSearched = false;
		var $sUniqueID = false;
		var $aFormSetting = false;
		var $bAllowTranslations = false;
		var $aTranslations = false;
		var $sSessionData = false;
		var $sRealm = false;
		var $sAvailableItems = false;
		var $sFuelsFixed = false;
		var $sStatusFixed = false;
		var $aObjectDivisionsData = false;
		var $aObjectDivisionValues = false;
		private $aObjectSubCategory;
		private $sDeeplink;

		function __construct($aFormSetting, $postdata = false, $page = false, $category = false, $subcategory = false, $condition = 'all', $rental = false, $ovisUrlObjectId = false, $sUniqueID = false, $dealer = false, $sRealm = 'ovis' ) {

			global $wp_session;
			$this->sSessionData = !empty($wp_session['session_data']) ? $wp_session['session_data'] : false;

			$this->aFormSetting = $aFormSetting;
			
			$this->aObjectPage = $page;
			
			$this->sRealm = empty($sRealm) ? 'ovis' : $sRealm;

			if(!empty($sUniqueID)) {
				$this->sUniqueID = $sUniqueID;
			}
			
			if(empty($ovisUrlObjectId)) {
				$aSessionKeys = array($this->sUniqueID,'ovisPage');
				addDataToSession($aSessionKeys,$this->aObjectPage);
			}
			
			/* filters initialiseren */
			$this->oObjectFilters = new stdClass();
			
			if($postdata) {
				$this->oObjectSearchData = $postdata;
			}
			
			if($ovisUrlObjectId) {
				$this->aObjectId = explode('-', $ovisUrlObjectId);

				if(!isset($this->aObjectId[0]) || !is_numeric($this->aObjectId[0])) {
					$this->aObjectId = '0';
				} else {
					$this->aObjectId = $this->aObjectId[0];
				}
			}
			
			$this->aObjectRental = $rental;
			$this->oObjectFilters->ovisUser = false;
			
			if($category) {
				$this->aObjectCategory = $category;
				$this->oObjectFilters->category = $category;
			}

			if($subcategory) {
				$this->aObjectSubCategory = $subcategory;
				$this->oObjectFilters->subCategory = $subcategory;
			}

			if($dealer) {
				$this->aObjectOvisUser = $dealer;
				$this->oObjectFilters->ovisUser = $dealer;
			}
			
			if($condition) {
				$this->aObjectCondition = $condition;
				$this->oObjectFilters->condition = $condition;
			}
		}


		function checkActiveAd() {
			if(empty($this->aObjectId)) {
				return true;
			}
			
			return $this->search_activead();
		}


		public function get_divisions() {
			unset($this->sSessionData['ovis_divisions']);
			$sEndpoint = OVIS_DOMAIN_URL . '/search/divisions';
			$aHeaders = $this->aFormSetting['settings']['authentication_header'];
			$oParams = new stdClass();
			if(!empty($this->oObjectFilters->ovisUser)) {
				$oParams->userId = $this->oObjectFilters->ovisUser;
			}
			$oParams->selection = array('clean','sold','noimage');
			
			$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);	
			
			$oCurl = curl_init();
			curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
			curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
			curl_setopt($oCurl, CURLOPT_HEADER, false);
			
			$sResult = curl_exec($oCurl);
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);
			$oResult = json_decode($sResult);
			
			if((isset($oResult->errors) && !$oResult->errors) && !empty($oResult->data)) {				
				
				$aSessionKeys = array('ovis_divisions','data');
				addDataToSession($aSessionKeys,$oResult->data);
				
				$aSessionKeys = array('ovis_divisions','time');
				addDataToSession($aSessionKeys,(date('U')+600));
				$this->aObjectDivisionsData = $oResult->data;
				
				if(!empty($this->aObjectCategory) && !empty($this->aObjectDivisionsData)) {				
					$this->parse_divisions();				
				}				
			}
		}
		
		private function parse_divisions() {
			
			if(empty($this->aObjectCategory) || empty($this->aObjectDivisionsData)) {
				return false;
			}

			$oDivisions = new stdClass();
			$oDivisions->divisions = array();
						
			$this->aObjectDivisionValues = $this->aObjectDivisionsData;
			
			if(!empty($this->oObjectFilters->category)) {
				$aFilterCategories = explode(',',$this->oObjectFilters->category);	
				
				$oDivisions = new stdClass();
				
				foreach($aFilterCategories as $key=>$value) {
					
					if(isset($this->aObjectDivisionsData->{$value})) {
						$oDivisions->{$value} = $this->aObjectDivisionsData->{$value};
					}					
				}
				
				if(!empty($oDivisions)) {
					$this->aObjectDivisionValues = $oDivisions;	
				}
			}
		}


		/**
		 * Undocumented function
		 *
		 * @param boolean $sRealm
		 * @return void
		 */
		public function translateRealm($sRealm=false) {
			
			$sReturnRealm = $sRealm;
			
			switch($sRealm) {
				case 'boten':
					$sReturnRealm = 'boat';
					break;
			}

			return $sReturnRealm;
		}


		public function get_minmax() {
			
			unset($this->sSessionData['ovis_minmax']);		 
			$sEndpoint = OVIS_DOMAIN_URL . '/search/minmax/client/'.$this->translateRealm($this->sRealm);
			$aHeaders = $this->aFormSetting['settings']['authentication_header'];
			$oParams = new stdClass();
			if(!empty($this->oObjectFilters->ovisUser)) {
				$oParams->userId = $this->oObjectFilters->ovisUser;
			}
			$oParams->selection = array('clean','sold','noimage');
			
			$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);	
			
			$oCurl = curl_init();
			curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
			curl_setopt($oCurl, CURLOPT_POST, true);
			curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
			curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
			curl_setopt($oCurl, CURLOPT_HEADER, false);
			
			$sResult = curl_exec($oCurl);
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);
			$oResult = json_decode($sResult);
					
			if((isset($oResult->errors) && !$oResult->errors) && !empty($oResult->data)) {
				$this->aObjectMinMaxData = $oResult->data;
				
				if(!empty($this->aObjectCategory) && !empty($this->aObjectMinMaxData)) {				
					$this->parse_minmax();				
				}				
			}			
		}		
		
		private function parse_minmax() {				
			
			if(empty($this->aObjectCategory) || empty($this->aObjectMinMaxData)) {
				return false;
			}
			
			$oMinMax = new stdClass();
			$oMinMax->categories = array();
			$oMinMax->subcategory = array();
			$oMinMax->conditions = array();
			$oMinMax->brands = array();
			$oMinMax->fuel = array();
			$oMinMax->euroclass = array();
			$oMinMax->construction = array();
				$oMinMax->construction['from'] = false;
				$oMinMax->construction['to'] = false;
			$oMinMax->price = array();
				$oMinMax->price['from'] = false;
				$oMinMax->price['to'] = false;
			$oMinMax->priceRental = array();
				$oMinMax->priceRental['from'] = false;
				$oMinMax->priceRental['to'] = false;
			$oMinMax->maxweight = array();
				$oMinMax->maxweight['from'] = false;
				$oMinMax->maxweight['to'] = false;
			$oMinMax->sleepingplaces = array();
				$oMinMax->sleepingplaces['from'] = false;
				$oMinMax->sleepingplaces['to'] = false;
			$oMinMax->seatbelts = array();
				$oMinMax->seatbelts['from'] = false;
				$oMinMax->seatbelts['to'] = false;
			$oMinMax->mileage = array();
				$oMinMax->mileage['from'] = false;
				$oMinMax->mileage['to'] = false;
			$oMinMax->engineHorsePower = array();
				$oMinMax->engineHorsePower['from'] = false;
				$oMinMax->engineHorsePower['to'] = false;
			$oMinMax->length = array();
				$oMinMax->length['from'] = false;
				$oMinMax->length['to'] = false;
			
			$aMinMaxCategories = explode(',',str_replace(' ','',$this->oObjectFilters->category));
			$aMinMaxConditions = explode(',',str_replace(' ','',$this->oObjectFilters->condition));
			
			$aMinMaxCategories = explode(',',str_replace(' ','',$this->aObjectCategory));
			$aMinMaxConditions = explode(',',str_replace(' ','',$this->aObjectCondition));
						
			$aCategoriesFromWP = explode(',',$this->aObjectCategory);
			
			$aCategoryIsSearched = false;				
			if(!empty($this->oObjectFilters->category)) {
				$aCategoryIsSearched = explode(',',$this->oObjectFilters->category);
			}
			
			foreach($this->aObjectMinMaxData as $categoryKey => $categoryValue) {				
				
				if(!in_array($categoryKey,$aCategoriesFromWP)) {							
					continue;
				}
				
				$bCategoryIsSearched = false;
				if(!empty($aCategoryIsSearched) && in_array($categoryKey,$aCategoryIsSearched)) {
					$bCategoryIsSearched = true;
				}
				
				if(in_array($categoryKey,$aMinMaxCategories)) {	
				
					foreach($categoryValue as $conditionKey => $conditionValue) {						
						
						
						if(count((array)$conditionValue) > 0) {								
							if(($this->aObjectRental || $categoryKey == 'trailer') && $conditionKey == 'rental') {
								$oMinMax->categories[strtolower(str_replace(' ','',$categoryKey))] = ucfirst($categoryKey);
								
								if(!empty($bCategoryIsSearched)) {								
									if(!empty($conditionValue->specs->subCategory)) {
										foreach($conditionValue->specs->subCategory as $sSubCategory) {
											if(stripos($sSubCategory,'Occasion') === false && (!isset($oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))]) || !in_array($sSubCategory,$oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))])) && strtolower($sSubCategory) != 'camper' ) {
												$oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))][] = $sSubCategory;
											}										
										}
									}
															
									if(!empty($conditionValue->specs->brands)) {
										foreach($conditionValue->specs->brands as $sBrand) {
											$oMinMax->brands[strtolower($sBrand)]['value'] = $sBrand;									
										}
									}
															
									if(!empty($conditionValue->specs->fuel)) {
										foreach($conditionValue->specs->fuel as $sFuel) {
											$oMinMax->fuel[strtolower($sFuel)]['value'] = $sFuel;									
										}
									}
															
									if(!empty($conditionValue->specs->euroclass)) {
										foreach($conditionValue->specs->euroclass as $sEuroclass) {
											$oMinMax->euroclass[strtolower($sEuroclass)]['value'] = $sEuroclass;									
										}
									}
									
									if(isset($conditionValue->specs->constructionYear->min)) {
										$oMinMax->construction['from'] = $oMinMax->construction['from'] === false || $conditionValue->specs->constructionYear->min < $oMinMax->construction['from'] ? $conditionValue->specs->constructionYear->min : $oMinMax->construction['from'];
									}
									if(isset($conditionValue->specs->constructionYear->max)) {
										$oMinMax->construction['to'] = $oMinMax->construction['to'] === false || $conditionValue->specs->constructionYear->max > $oMinMax->construction['to'] ? $conditionValue->specs->constructionYear->max : $oMinMax->construction['to'];
									}
									
									if(isset($conditionValue->specs->price->min)) {
										$iPriceMinLeveled = floor($conditionValue->specs->price->min/OVIS_PRICE_STEP)*OVIS_PRICE_STEP;
										$oMinMax->price['from'] = $oMinMax->price['from'] === false || $iPriceMinLeveled < $oMinMax->price['from'] ? $iPriceMinLeveled : $oMinMax->price['from'];
									}								
									if(isset($conditionValue->specs->price->max)) {
										$iPriceMaxLeveled = ceil($conditionValue->specs->price->max/OVIS_PRICE_STEP)*OVIS_PRICE_STEP;								
										$oMinMax->price['to'] = $oMinMax->price['to'] === false || $iPriceMaxLeveled > $oMinMax->price['to'] ? $iPriceMaxLeveled : $oMinMax->price['to'];
									}
									
									if(isset($conditionValue->specs->priceRental->min)) {
										$iPriceRentalMinLeveled = floor($conditionValue->specs->priceRental->min/OVIS_PRICE_RENTAL_STEP)*OVIS_PRICE_RENTAL_STEP;
										$oMinMax->priceRental['from'] = $oMinMax->priceRental['from'] === false || $iPriceRentalMinLeveled < $oMinMax->priceRental['from'] ? $iPriceRentalMinLeveled : $oMinMax->priceRental['from'];
									}								
									if(isset($conditionValue->specs->priceRental->max)) {
										$iPriceRentalMaxLeveled = ceil($conditionValue->specs->priceRental->max/OVIS_PRICE_RENTAL_STEP)*OVIS_PRICE_RENTAL_STEP;								
										$oMinMax->priceRental['to'] = $oMinMax->priceRental['to'] === false || $iPriceRentalMaxLeveled > $oMinMax->priceRental['to'] ? $iPriceRentalMaxLeveled : $oMinMax->priceRental['to'];
									}
									
									if(isset($conditionValue->specs->weight->min)) {
										$iMaxweightMinLeveled = floor($conditionValue->specs->weight->min/OVIS_WEIGHT_STEP)*OVIS_WEIGHT_STEP;
										$oMinMax->maxweight['from'] = $oMinMax->maxweight['from'] === false || $iMaxweightMinLeveled < $oMinMax->maxweight['from'] ? $iMaxweightMinLeveled : $oMinMax->maxweight['from'];
									}								
									if(isset($conditionValue->specs->weight->max)) {
										$iMaxweightMaxLeveled = ceil($conditionValue->specs->weight->max/OVIS_WEIGHT_STEP)*OVIS_WEIGHT_STEP;									
										$oMinMax->maxweight['to'] = $oMinMax->maxweight['to'] === false || $iMaxweightMaxLeveled > $oMinMax->maxweight['to'] ? $iMaxweightMaxLeveled : $oMinMax->maxweight['to'];
									}
									
									if(isset($conditionValue->specs->numberOfSleepingPlaces->min)) {
										$oMinMax->sleepingplaces['from'] = $oMinMax->sleepingplaces['from'] === false || $conditionValue->specs->numberOfSleepingPlaces->min < $oMinMax->sleepingplaces['from'] ? $conditionValue->specs->numberOfSleepingPlaces->min : $oMinMax->sleepingplaces['from'];
									}
									if(isset($conditionValue->specs->numberOfSleepingPlaces->max)) {
										$oMinMax->sleepingplaces['to'] = $oMinMax->sleepingplaces['to'] === false || $conditionValue->specs->numberOfSleepingPlaces->max > $oMinMax->sleepingplaces['to'] ? $conditionValue->specs->numberOfSleepingPlaces->max : $oMinMax->sleepingplaces['to'];
									}
									
									if(isset($conditionValue->specs->numberOfSeatbelts->min)) {
										$oMinMax->seatbelts['from'] = $oMinMax->seatbelts['from'] === false || $conditionValue->specs->numberOfSeatbelts->min < $oMinMax->seatbelts['from'] ? $conditionValue->specs->numberOfSeatbelts->min : $oMinMax->seatbelts['from'];
									}
									if(isset($conditionValue->specs->numberOfSeatbelts->max)) {
										$oMinMax->seatbelts['to'] = $oMinMax->seatbelts['to'] === false || $conditionValue->specs->numberOfSeatbelts->max > $oMinMax->seatbelts['to'] ? $conditionValue->specs->numberOfSeatbelts->max : $oMinMax->seatbelts['to'];
									}
									
									if(isset($conditionValue->specs->mileage->min)) {
										$oMinMax->mileage['from'] = $oMinMax->mileage['from'] === false || $conditionValue->specs->mileage->min < $oMinMax->mileage['from'] ? $conditionValue->specs->mileage->min : $oMinMax->mileage['from'];
									}
									if(isset($conditionValue->specs->mileage->max)) {
										$oMinMax->mileage['to'] = $oMinMax->mileage['to'] === false || $conditionValue->specs->mileage->max > $oMinMax->mileage['to'] ? $conditionValue->specs->mileage->max : $oMinMax->mileage['to'];
									}
								}
							}
							
							if((in_array('all',$aMinMaxConditions) || in_array('occasion',$aMinMaxConditions)) && $conditionKey == 'occasion' && !$this->aObjectRental) {
							
								$oMinMax->categories[strtolower(str_replace(' ','',$categoryKey))] = ucfirst($categoryKey);
								
								if(!empty($bCategoryIsSearched)) {	
									
									$oMinMax->conditions['occasion'] = 'Occasion';
								
									if(!empty($conditionValue->specs->condition)) {
										foreach($conditionValue->specs->condition as $sCondition) {										
											if($sCondition == 'new') {
												$oMinMax->conditions['new'] = 'Nieuw';											
											} else if($sCondition == 'used') {
												$oMinMax->conditions['occasion'] = 'Occasion';
											}
										}	
									}
									
									if(!empty($conditionValue->specs->subCategory)) {										
										foreach($conditionValue->specs->subCategory as $sSubCategory) {										
											if(stripos($sSubCategory,'Occasion') === false && (!isset($oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))]) || !in_array($sSubCategory,$oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))])) && strtolower($sSubCategory) != 'camper') {										
												$oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))][] = $sSubCategory;	
											}										
										}									
									}
			
									if(!empty($conditionValue->specs->brands)) {
										foreach($conditionValue->specs->brands as $sBrand) {			
											$oMinMax->brands[strtolower($sBrand)]['value'] = $sBrand;	
										}
									}
			
									if(!empty($conditionValue->specs->euroclass)) {
										foreach($conditionValue->specs->euroclass as $sEuroclass) {			
											$oMinMax->euroclass[strtolower($sEuroclass)]['value'] = $sEuroclass;	
										}
									}
			
									if(!empty($conditionValue->specs->fuel)) {
										foreach($conditionValue->specs->fuel as $sFuel) {			
											$oMinMax->fuel[strtolower($sFuel)]['value'] = $sFuel;	
										}
									}
			
									if(isset($conditionValue->specs->constructionYear->min)) {
										$oMinMax->construction['from'] = $oMinMax->construction['from'] === false || $conditionValue->specs->constructionYear->min < $oMinMax->construction['from'] ? $conditionValue->specs->constructionYear->min : $oMinMax->construction['from'];
									}
									if(isset($conditionValue->specs->constructionYear->max)) {
										$oMinMax->construction['to'] = $oMinMax->construction['to'] === false || $conditionValue->specs->constructionYear->max > $oMinMax->construction['to'] ? $conditionValue->specs->constructionYear->max : $oMinMax->construction['to'];
									}
									
									if(isset($conditionValue->specs->price->min)) {
										$iPriceMinLeveled = floor($conditionValue->specs->price->min/OVIS_PRICE_STEP)*OVIS_PRICE_STEP;
										$oMinMax->price['from'] = $oMinMax->price['from'] === false || $iPriceMinLeveled < $oMinMax->price['from'] ? $iPriceMinLeveled : $oMinMax->price['from'];
									}								
									if(isset($conditionValue->specs->price->max)) {
										$iPriceMaxLeveled = ceil($conditionValue->specs->price->max/OVIS_PRICE_STEP)*OVIS_PRICE_STEP;								
										$oMinMax->price['to'] = $oMinMax->price['to'] === false || $iPriceMaxLeveled > $oMinMax->price['to'] ? $iPriceMaxLeveled : $oMinMax->price['to'];
									}
									
									if(isset($conditionValue->specs->weight->min)) {
										$iMaxweightMinLeveled = floor($conditionValue->specs->weight->min/OVIS_WEIGHT_STEP)*OVIS_WEIGHT_STEP;
										$oMinMax->maxweight['from'] = $oMinMax->maxweight['from'] === false || $iMaxweightMinLeveled < $oMinMax->maxweight['from'] ? $iMaxweightMinLeveled : $oMinMax->maxweight['from'];
									}								
									if(isset($conditionValue->specs->weight->max)) {
										$iMaxweightMaxLeveled = ceil($conditionValue->specs->weight->max/OVIS_WEIGHT_STEP)*OVIS_WEIGHT_STEP;									
										$oMinMax->maxweight['to'] = $oMinMax->maxweight['to'] === false || $iMaxweightMaxLeveled > $oMinMax->maxweight['to'] ? $iMaxweightMaxLeveled : $oMinMax->maxweight['to'];
									}
									
									if(isset($conditionValue->specs->numberOfSleepingPlaces->min)) {
										$oMinMax->sleepingplaces['from'] = $oMinMax->sleepingplaces['from'] === false || $conditionValue->specs->numberOfSleepingPlaces->min < $oMinMax->sleepingplaces['from'] ? $conditionValue->specs->numberOfSleepingPlaces->min : $oMinMax->sleepingplaces['from'];
									}
									if(isset($conditionValue->specs->numberOfSleepingPlaces->max)) {
										$oMinMax->sleepingplaces['to'] = $oMinMax->sleepingplaces['to'] === false || $conditionValue->specs->numberOfSleepingPlaces->max > $oMinMax->sleepingplaces['to'] ? $conditionValue->specs->numberOfSleepingPlaces->max : $oMinMax->sleepingplaces['to'];
									}
									
									if(isset($conditionValue->specs->numberOfSeatbelts->min)) {
										$oMinMax->seatbelts['from'] = $oMinMax->seatbelts['from'] === false || $conditionValue->specs->numberOfSeatbelts->min < $oMinMax->seatbelts['from'] ? $conditionValue->specs->numberOfSeatbelts->min : $oMinMax->seatbelts['from'];
									}
									if(isset($conditionValue->specs->numberOfSeatbelts->max)) {
										$oMinMax->seatbelts['to'] = $oMinMax->seatbelts['to'] === false || $conditionValue->specs->numberOfSeatbelts->max > $oMinMax->seatbelts['to'] ? $conditionValue->specs->numberOfSeatbelts->max : $oMinMax->seatbelts['to'];
									}
									
									if(isset($conditionValue->specs->mileage->min)) {
										$oMinMax->mileage['from'] = $oMinMax->mileage['from'] === false || $conditionValue->specs->mileage->min < $oMinMax->mileage['from'] ? $conditionValue->specs->mileage->min : $oMinMax->mileage['from'];
									}
									if(isset($conditionValue->specs->mileage->max)) {
										$oMinMax->mileage['to'] = $oMinMax->mileage['to'] === false || $conditionValue->specs->mileage->max > $oMinMax->mileage['to'] ? $conditionValue->specs->mileage->max : $oMinMax->mileage['to'];
									}
									
									if(isset($conditionValue->specs->engineHorsePower->min)) {
										$iPowerMinLeveled = floor($conditionValue->specs->engineHorsePower->min/OVIS_POWER_STEP)*OVIS_POWER_STEP;
										
										$oMinMax->engineHorsePower['from'] = $oMinMax->engineHorsePower['from'] === false || $iPowerMinLeveled < $oMinMax->engineHorsePower['from'] ? $iPowerMinLeveled : $oMinMax->engineHorsePower['from'];
									}
									if(isset($conditionValue->specs->engineHorsePower->max)) {										
										$iPowerMaxLeveled = ceil($conditionValue->specs->engineHorsePower->max/OVIS_POWER_STEP)*OVIS_POWER_STEP;
										
										$oMinMax->engineHorsePower['to'] = $oMinMax->engineHorsePower['to'] === false || $iPowerMaxLeveled > $oMinMax->engineHorsePower['to'] ? $iPowerMaxLeveled : $oMinMax->engineHorsePower['to'];
									}
									
									if(isset($conditionValue->specs->length->min)) {
										$iLengthMinLeveled = floor($conditionValue->specs->length->min/OVIS_LENGTH_STEP)*OVIS_LENGTH_STEP;
										$oMinMax->length['from'] = $oMinMax->length['from'] === false || $iLengthMinLeveled < $oMinMax->length['from'] ? $iLengthMinLeveled : $oMinMax->length['from'];
									}
									if(isset($conditionValue->specs->length->max)) {
										$iLengthMaxLeveled = ceil($conditionValue->specs->length->max/OVIS_LENGTH_STEP)*OVIS_LENGTH_STEP;
										$oMinMax->length['to'] = $oMinMax->length['to'] === false || $iLengthMaxLeveled > $oMinMax->length['to'] ? $iLengthMaxLeveled : $oMinMax->length['to'];
									}
								}
								
							}
							
							if((in_array('all',$aMinMaxConditions) || in_array('nieuw',$aMinMaxConditions) || in_array('new',$aMinMaxConditions)) && $conditionKey == 'new' && !$this->aObjectRental) {
								$oMinMax->categories[strtolower(str_replace(' ','',$categoryKey))] = ucfirst($categoryKey);
								
								if(!empty($bCategoryIsSearched)) {
									$oMinMax->conditions['new'] = 'Nieuw';
									
									if(!empty($conditionValue->specs->condition)) {
										foreach($conditionValue->specs->condition as $sCondition) {										
											if($sCondition == 'new') {
												$oMinMax->conditions['new'] = 'Nieuw';											
											} else if($sCondition == 'used') {
												$oMinMax->conditions['occasion'] = 'Occasion';
											}
										}	
									}
								
									if(!empty($conditionValue->specs->subCategory)) {
										foreach($conditionValue->specs->subCategory as $sSubCategory) {										
											if(stripos($sSubCategory,'Occasion') === false && (!isset($oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))]) || !in_array($sSubCategory,$oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))])) && strtolower($sSubCategory) != 'camper') {
												$oMinMax->subcategory[strtolower(str_replace(' ','',$categoryKey))][] = $sSubCategory;
											}										
										}
									}
									
									if(!empty($conditionValue->specs->brands)) {
										foreach($conditionValue->specs->brands as $sBrand) {
											$oMinMax->brands[strtolower($sBrand)]['value'] = $sBrand;									
										}
									}
									
									if(!empty($conditionValue->specs->euroclass)) {
										foreach($conditionValue->specs->euroclass as $sEuroclass) {
											$oMinMax->euroclass[strtolower($sEuroclass)]['value'] = $sEuroclass;									
										}
									}
									
									if(!empty($conditionValue->specs->fuel)) {
										foreach($conditionValue->specs->fuel as $sFuel) {
											$oMinMax->fuel[strtolower($sFuel)]['value'] = $sFuel;									
										}
									}
									
									if(isset($conditionValue->specs->constructionYear->min)) {
										$oMinMax->construction['from'] = $oMinMax->construction['from'] === false || $conditionValue->specs->constructionYear->min < $oMinMax->construction['from'] ? $conditionValue->specs->constructionYear->min : $oMinMax->construction['from'];
									}
									if(isset($conditionValue->specs->constructionYear->max)) {
										$oMinMax->construction['to'] = $oMinMax->construction['to'] === false || $conditionValue->specs->constructionYear->max > $oMinMax->construction['to'] ? $conditionValue->specs->constructionYear->max : $oMinMax->construction['to'];
									}
									
									if(isset($conditionValue->specs->price->min)) {
										$iPriceMinLeveled = floor($conditionValue->specs->price->min/OVIS_PRICE_STEP)*OVIS_PRICE_STEP;
										$oMinMax->price['from'] = $oMinMax->price['from'] === false || $iPriceMinLeveled < $oMinMax->price['from'] ? $iPriceMinLeveled : $oMinMax->price['from'];
									}								
									if(isset($conditionValue->specs->price->max)) {
										$iPriceMaxLeveled = ceil($conditionValue->specs->price->max/OVIS_PRICE_STEP)*OVIS_PRICE_STEP;								
										$oMinMax->price['to'] = $oMinMax->price['to'] === false || $iPriceMaxLeveled > $oMinMax->price['to'] ? $iPriceMaxLeveled : $oMinMax->price['to'];
									}
									
									if(isset($conditionValue->specs->weight->min)) {
										$iMaxweightMinLeveled = floor($conditionValue->specs->weight->min/OVIS_WEIGHT_STEP)*OVIS_WEIGHT_STEP;
										$oMinMax->maxweight['from'] = $oMinMax->maxweight['from'] === false || $iMaxweightMinLeveled < $oMinMax->maxweight['from'] ? $iMaxweightMinLeveled : $oMinMax->maxweight['from'];
									}								
									if(isset($conditionValue->specs->weight->max)) {
										$iMaxweightMaxLeveled = ceil($conditionValue->specs->weight->max/OVIS_WEIGHT_STEP)*OVIS_WEIGHT_STEP;									
										$oMinMax->maxweight['to'] = $oMinMax->maxweight['to'] === false || $iMaxweightMaxLeveled > $oMinMax->maxweight['to'] ? $iMaxweightMaxLeveled : $oMinMax->maxweight['to'];
									}
									
									if(isset($conditionValue->specs->numberOfSleepingPlaces->min)) {
										$oMinMax->sleepingplaces['from'] = $oMinMax->sleepingplaces['from'] === false || $conditionValue->specs->numberOfSleepingPlaces->min < $oMinMax->sleepingplaces['from'] ? $conditionValue->specs->numberOfSleepingPlaces->min : $oMinMax->sleepingplaces['from'];
									}
									if(isset($conditionValue->specs->numberOfSleepingPlaces->max)) {
										$oMinMax->sleepingplaces['to'] = $oMinMax->sleepingplaces['to'] === false || $conditionValue->specs->numberOfSleepingPlaces->max > $oMinMax->sleepingplaces['to'] ? $conditionValue->specs->numberOfSleepingPlaces->max : $oMinMax->sleepingplaces['to'];
									}
									
									if(isset($conditionValue->specs->numberOfSeatbelts->min)) {
										$oMinMax->seatbelts['from'] = $oMinMax->seatbelts['from'] === false || $conditionValue->specs->numberOfSeatbelts->min < $oMinMax->seatbelts['from'] ? $conditionValue->specs->numberOfSeatbelts->min : $oMinMax->seatbelts['from'];
									}
									if(isset($conditionValue->specs->numberOfSeatbelts->max)) {
										$oMinMax->seatbelts['to'] = $oMinMax->seatbelts['to'] === false || $conditionValue->specs->numberOfSeatbelts->max > $oMinMax->seatbelts['to'] ? $conditionValue->specs->numberOfSeatbelts->max : $oMinMax->seatbelts['to'];
									}
									
									if(isset($conditionValue->specs->mileage->min)) {
										$oMinMax->mileage['from'] = $oMinMax->mileage['from'] === false || $conditionValue->specs->mileage->min < $oMinMax->mileage['from'] ? $conditionValue->specs->mileage->min : $oMinMax->mileage['from'];
									}
									if(isset($conditionValue->specs->mileage->max)) {
										$oMinMax->mileage['to'] = $oMinMax->mileage['to'] === false || $conditionValue->specs->mileage->max > $oMinMax->mileage['to'] ? $conditionValue->specs->mileage->max : $oMinMax->mileage['to'];
									}
									
									if(isset($conditionValue->specs->engineHorsePower->min)) {
										$iPowerMinLeveled = floor($conditionValue->specs->engineHorsePower->min/OVIS_POWER_STEP)*OVIS_POWER_STEP;
										
										$oMinMax->engineHorsePower['from'] = $oMinMax->engineHorsePower['from'] === false || $iPowerMinLeveled < $oMinMax->engineHorsePower['from'] ? $iPowerMinLeveled : $oMinMax->engineHorsePower['from'];
									}
									if(isset($conditionValue->specs->engineHorsePower->max)) {										
										$iPowerMaxLeveled = ceil($conditionValue->specs->engineHorsePower->max/OVIS_POWER_STEP)*OVIS_POWER_STEP;
										
										$oMinMax->engineHorsePower['to'] = $oMinMax->engineHorsePower['to'] === false || $iPowerMaxLeveled > $oMinMax->engineHorsePower['to'] ? $iPowerMaxLeveled : $oMinMax->engineHorsePower['to'];
									}
									
									if(isset($conditionValue->specs->length->min)) {
										$iLengthMinLeveled = floor($conditionValue->specs->length->min/OVIS_LENGTH_STEP)*OVIS_LENGTH_STEP;
										$oMinMax->length['from'] = $oMinMax->length['from'] === false || $iLengthMinLeveled < $oMinMax->length['from'] ? $iLengthMinLeveled : $oMinMax->length['from'];
									}
									if(isset($conditionValue->specs->length->max)) {
										$iLengthMaxLeveled = ceil($conditionValue->specs->length->max/OVIS_LENGTH_STEP)*OVIS_LENGTH_STEP;
										$oMinMax->length['to'] = $oMinMax->length['to'] === false || $iLengthMaxLeveled > $oMinMax->length['to'] ? $iLengthMaxLeveled : $oMinMax->length['to'];
									}
								}
							}
						}
					}
				}				
			}
			
			if(!empty($oMinMax->categories)) {
				$aSetCategoriesFromMinMax = array();
				foreach($oMinMax->categories as $sCategorieKey => $sCategorieValue) {
					$sSetCategoriesFromMinMax[$sCategorieKey] = $sCategorieKey;					
				}
				
				if(!empty($sSetCategoriesFromMinMax) && !empty($this->oObjectFilters->category)) {
				
					$aCategoriesFromFilters = explode(',',$this->oObjectFilters->category);
					$sComparedCategories = false;
					
					if(!empty($aCategoriesFromFilters) && is_array($aCategoriesFromFilters)) {					
						
						foreach($aCategoriesFromFilters as $aCategoryFromFilters) {														
							if(array_key_exists($aCategoryFromFilters,$sSetCategoriesFromMinMax)) {
								$sComparedCategories .= $aCategoryFromFilters.',';
							}
						}
						
						if(!empty($sComparedCategories)) {
							$this->oObjectFilters->category = substr($sComparedCategories,0,-1);
						}				
					}
				}
			}
			
			if(!empty($oMinMax->conditions)) {
				$aSetConditionsFromMinMax = array();
				foreach($oMinMax->conditions as $sConditionKey => $sConditionValue) {
					$sSetConditionsFromMinMax[$sConditionKey] = $sConditionKey;					
				}
				
				if(!empty($sSetConditionsFromMinMax) && !empty($this->oObjectFilters->condition)) {
				
					$aConditionsFromFilters = explode(',',$this->oObjectFilters->condition);
					$sComparedConditions = false;
					
					if(!empty($aConditionsFromFilters) && is_array($aConditionsFromFilters)) {					
						
						foreach($aConditionsFromFilters as $aConditionFromFilters) {														
							if(array_key_exists($aConditionFromFilters,$sSetConditionsFromMinMax)) {
								$sComparedConditions .= $aConditionFromFilters.',';
							}
						}
						
						if(!empty($sComparedConditions)) {
							$this->oObjectFilters->condition = substr($sComparedConditions,0,-1);
						}				
					}
				}
			}			
		
			$this->aObjectMinMaxValues = $oMinMax;

			return;
		}
		
		
		public function get_brands() {
		
			if(isset($this->sSessionData['ovis_brands']['data']) && $this->sSessionData['ovis_brands']['time'] > date('U') && $this->sSessionData['ovis_brands']['type'] == $this->oObjectFilters->category ) {
				$this->aObjectBrands = $this->sSessionData['ovis_brands']['data'];
				$this->aObjectCategoryData = !empty($this->sSessionData['ovis_brands']['categorydata']) ? $this->sSessionData['ovis_brands']['categorydata'] : false;
			} else {			
				unset($this->sSessionData['ovis_brands']);
				$sEndpoint = OVIS_DOMAIN_URL . '/search/brands/';
				$aHeaders = $this->aFormSetting['settings']['authentication_header'];
				$oCurl = curl_init();
				curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
				curl_setopt($oCurl, CURLOPT_HTTPGET, true);
				curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
				curl_setopt($oCurl, CURLOPT_HEADER, false);

				$sResult = curl_exec($oCurl);
				$sError = curl_errno($oCurl);
				$aResponseInfo = curl_getinfo($oCurl);

				$oResult = json_decode($sResult);
			
				if((isset($oResult->errors) && !$oResult->errors) && !empty($oResult->data)) {
				
					$aTotalBrands = array();
				
					if(!empty($oResult->data->brands)) {	
						foreach($oResult->data->brands as $sBrandKey => $aBrandData) {
							$aTotalBrands[] = $aBrandData->description;					
						}		
					}
				
					$this->aObjectCategoryData = !empty($oResult->data->categories) ? $oResult->data->categories : false;
			
					switch($this->oObjectFilters->category) {
						case 'caravan':						
							$this->aObjectBrands = !empty($oResult->data->categories->caravan->brandsDisplay) ? $oResult->data->categories->caravan->brands : $aTotalBrands;	
							break;
						case 'camper':
							$this->aObjectBrands = !empty($oResult->data->categories->camper->brandsDisplay) ? $oResult->data->categories->camper->brands : $aTotalBrands;
						break;
						case 'mobilehome':
							$this->aObjectBrands = !empty($oResult->data->categories->mobilehome->brandsDisplay) ? $oResult->data->categories->mobilehome->brands : $aTotalBrands;
							break;
						case 'tenttrailer':
							$this->aObjectBrands = !empty($oResult->data->categories->tenttrailer->brandsDisplay) ? $oResult->data->categories->tenttrailer->brands : $aTotalBrands;	
							break;
						case 'trailer':
							$this->aObjectBrands = !empty($oResult->data->categories->trailer->brandsDisplay) ? $oResult->data->categories->trailer->brands : $aTotalBrands;	
							break;
						default:						
							$this->aObjectBrands = $aTotalBrands;	
							break;
					}	

					$aSessionKeys = array('ovis_brands','data');
					addDataToSession($aSessionKeys,$this->aObjectBrands);
					
					$aSessionKeys = array('ovis_brands','type');
					addDataToSession($aSessionKeys,$this->oObjectFilters->category);
					
					$aSessionKeys = array('ovis_brands','categorydata');
					addDataToSession($aSessionKeys,$this->aObjectCategoryData);
					
					$aSessionKeys = array('ovis_brands','time');
					addDataToSession($aSessionKeys,(date('U')+600));			
				}
			}
		}

		private function compareSearchToMinMax() {	
				
			if(isset($this->oObjectSearchData['ovis-clear-all-search']) && $this->oObjectSearchData['ovis-clear-all-search'] == 'yes') {				
				
				
				$this->oObjectFilters = new stdClass();
				
				if(!empty($this->aObjectCategory)) {
					$this->oObjectFilters->category = $this->aObjectCategory;
				}				
				if(!empty($this->aObjectCondition)) {
					$this->oObjectFilters->condition = $this->aObjectCondition;
				}
				if(!empty($this->aObjectSubCategory)) {
					$this->oObjectFilters->subCategory = $this->aObjectSubCategory;
				}
				if(!empty($this->aObjectOvisUser)) {
					$this->oObjectFilters->ovisUser = $this->aObjectOvisUser;					
				}
				
				$this->oObjectFilters->searchUsed = true;
								
			} else {
				
				$clearSecondarySearch = isset($this->oObjectSearchData['ovis-clear-secondary-search']) && $this->oObjectSearchData['ovis-clear-secondary-search'] == 'yes' ? true : false;

				if(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && !empty($this->oObjectFilters->brand) && isset($this->aObjectMinMaxValues->brands)) {
					
					foreach($this->oObjectFilters->brand as $key => $value) {						
						$sValue = htmlentities($value, ENT_QUOTES, 'UTF-8');
						
						if(!array_key_exists(strtolower($sValue), $this->aObjectMinMaxValues->brands)) {							
							unset($this->oObjectFilters->brand[$key]);
						}				
					}
					
					if(empty($this->oObjectFilters->brand)) {	
						
						unset($this->oObjectFilters->brand);
						
					}
					
				}
				if(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && !empty($this->oObjectFilters->fuel) && isset($this->aObjectMinMaxValues->fuel)) {
					
					foreach($this->oObjectFilters->fuel as $key => $value) {						
						$sValue = htmlentities($value, ENT_QUOTES, 'UTF-8');
						
						if(!array_key_exists(strtolower($sValue), $this->aObjectMinMaxValues->fuel)) {							
							unset($this->oObjectFilters->fuel[$key]);
						}				
					}
					
					if(empty($this->oObjectFilters->fuel)) {	
						
						unset($this->oObjectFilters->fuel);
						
					}
					
				}
				
				if(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && !empty($this->oObjectFilters->subCategory) && isset($this->aObjectMinMaxValues->subcategory) && !empty($this->oObjectFilters->category) && isset($this->aObjectMinMaxValues->subcategory->{$this->oObjectFilters->category})) {
					
					foreach($this->oObjectFilters->subCategory as $key=>$value) {						
						if(!array_key_exists(strtolower($value),$this->aObjectMinMaxValues->subcategory->{$this->oObjectFilters->category})) {
							
							unset($this->oObjectFilters->subCategory[$key]);
						}
					}
					
					if(empty($this->oObjectFilters->subCategory)) {		
						unset($this->oObjectFilters->subCategory);
					}
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->maxweightFrom)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->maxweightFrom) && isset($this->aObjectMinMaxValues->maxweight) && 	
				(isset($this->aObjectMinMaxValues->maxweight['from']) || is_null($this->aObjectMinMaxValues->maxweight['from'])) && 
				($this->oObjectFilters->maxweightFrom < 0)
				)
				) {					
					unset($this->oObjectFilters->maxweightFrom);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->maxweightTo)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->maxweightTo) && isset($this->aObjectMinMaxValues->maxweight) && 
				(isset($this->aObjectMinMaxValues->maxweight['to']) || is_null($this->aObjectMinMaxValues->maxweight['to'])) && 
				($this->oObjectFilters->maxweightTo < 0)
				)
				) {					
					unset($this->oObjectFilters->maxweightTo);
				}				
				
				if($clearSecondarySearch ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->constructionFrom) && isset($this->aObjectMinMaxValues->construction) && 
				(isset($this->aObjectMinMaxValues->construction['from']) || is_null($this->aObjectMinMaxValues->construction['from'])) && 
				($this->oObjectFilters->constructionFrom < 0)
				)
				) {	
					unset($this->oObjectFilters->constructionFrom);
				}
				
				if($clearSecondarySearch ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->constructionTo) && isset($this->aObjectMinMaxValues->construction) && 
				(isset($this->aObjectMinMaxValues->construction['to']) || is_null($this->aObjectMinMaxValues->construction['to'])) && 
				($this->oObjectFilters->constructionTo < 0)
				)
				) {					
					unset($this->oObjectFilters->constructionTo);
				}				
								
				if($clearSecondarySearch ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->priceFrom) && isset($this->aObjectMinMaxValues->price) &&
				(isset($this->aObjectMinMaxValues->price['from']) || is_null($this->aObjectMinMaxValues->price['from'])) && 
				($this->oObjectFilters->priceFrom < 0)
				)
				) {					
					unset($this->oObjectFilters->priceFrom);
				}
				
				if($clearSecondarySearch ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->priceTo) && isset($this->aObjectMinMaxValues->price) && 
				(isset($this->aObjectMinMaxValues->price['to']) || is_null($this->aObjectMinMaxValues->price['to'])) && 
				($this->oObjectFilters->priceTo < 0)
				)
				) {					
					unset($this->oObjectFilters->priceTo);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->sleepingplacesFrom)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->sleepingplacesFrom) && isset($this->aObjectMinMaxValues->sleepingplaces) &&
				(isset($this->aObjectMinMaxValues->sleepingplaces['from']) || is_null($this->aObjectMinMaxValues->sleepingplaces['from'])) && 
				($this->oObjectFilters->sleepingplacesFrom < 0)
				)
				) {					
					unset($this->oObjectFilters->sleepingplacesFrom);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->sleepingplacesTo)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->sleepingplacesTo) && isset($this->aObjectMinMaxValues->sleepingplaces) && 
				(isset($this->aObjectMinMaxValues->sleepingplaces['to']) || is_null($this->aObjectMinMaxValues->sleepingplaces['to'])) &&  
				($this->oObjectFilters->sleepingplacesTo < 0)
				)
				) {					
					unset($this->oObjectFilters->sleepingplacesTo);
				}

				if($clearSecondarySearch || (!isset($this->oObjectFilters->mileageFrom)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->mileageFrom) && isset($this->aObjectMinMaxValues->mileage) &&
				(isset($this->aObjectMinMaxValues->mileage['from']) || is_null($this->aObjectMinMaxValues->mileage['from'])) && 
				($this->oObjectFilters->mileageFrom < 0)
				)
				) {					
					unset($this->oObjectFilters->mileageFrom);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->mileageTo)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->mileageTo) && isset($this->aObjectMinMaxValues->mileage) && 
				(isset($this->aObjectMinMaxValues->mileage['to']) || is_null($this->aObjectMinMaxValues->mileage['to'])) &&  
				($this->oObjectFilters->mileageTo < 0)
				)
				) {					
					unset($this->oObjectFilters->mileageTo);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->seatbeltsFrom)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->seatbeltsFrom) && isset($this->aObjectMinMaxValues->seatbelts) &&
				(isset($this->aObjectMinMaxValues->seatbelts['from']) || is_null($this->aObjectMinMaxValues->seatbelts['from'])) && 
				($this->oObjectFilters->seatbeltsFrom < 0)
				)
				) {					
					unset($this->oObjectFilters->seatbeltsFrom);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->seatbeltsTo)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->seatbeltsTo) && isset($this->aObjectMinMaxValues->seatbelts) && 
				(isset($this->aObjectMinMaxValues->seatbelts['to']) || is_null($this->aObjectMinMaxValues->seatbelts['to'])) &&  
				($this->oObjectFilters->seatbeltsTo < 0)
				)
				) {					
					unset($this->oObjectFilters->seatbeltsTo);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->powerFrom)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->powerFrom) && isset($this->aObjectMinMaxValues->engineHorsePower) &&
				(isset($this->aObjectMinMaxValues->engineHorsePower['from']) || is_null($this->aObjectMinMaxValues->engineHorsePower['from'])) && 
				($this->oObjectFilters->powerFrom < 0)
				)
				) {					
					unset($this->oObjectFilters->powerFrom);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->powerTo)) || 
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->powerTo) && isset($this->aObjectMinMaxValues->engineHorsePower) && 
				(isset($this->aObjectMinMaxValues->engineHorsePower['to']) || is_null($this->aObjectMinMaxValues->engineHorsePower['to'])) &&  
				($this->oObjectFilters->powerTo < 0)
				)
				) {					
					unset($this->oObjectFilters->powerTo);
				}	
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->lengthFrom)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->lengthFrom) && isset($this->aObjectMinMaxValues->length) &&
				(isset($this->aObjectMinMaxValues->length['from']) || is_null($this->aObjectMinMaxValues->length['from'])) && 
				($this->oObjectFilters->lengthFrom < 0)
				)
				) {					
					unset($this->oObjectFilters->lengthFrom);
				}
				
				if($clearSecondarySearch || (!isset($this->oObjectFilters->lengthTo)) ||
				(isset($this->oObjectFilters) && isset($this->aObjectMinMaxValues) && isset($this->oObjectFilters->lengthTo) && isset($this->aObjectMinMaxValues->length) && 
				(isset($this->aObjectMinMaxValues->length['to']) || is_null($this->aObjectMinMaxValues->length['to'])) &&  
				($this->oObjectFilters->lengthTo < 0)
				)
				) {					
					unset($this->oObjectFilters->lengthTo);
				}				
			}
		}


		/**
		 * Undocumented function
		 *
		 * @param boolean $iProductID
		 * @return void
		 */
		public function getTranslations($iProductID=false) {	
			$sEndpoint = OVIS_DOMAIN_URL . '/search/translations';
			
			if(!empty($this->aObjectId)) {
				$sEndpoint .= '/'.$this->aObjectId;
			}

			$aHeaders = $this->aFormSetting['settings']['authentication_header'];
			$oCurl = curl_init();
			curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
			curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
			curl_setopt($oCurl, CURLOPT_HEADER, false);
			
			$sResult = curl_exec($oCurl);
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);
			$oResult = json_decode($sResult);
			
			$this->aTranslations = $oResult;
			
			if(!empty($this->aTranslations->data->allowed)) {
				$this->bAllowTranslations = true;
			}
		}


		/**
		 * Undocumented function
		 *
		 * @return void
		 */
		public function search_activead() {
            
			$sEndpoint = OVIS_DOMAIN_URL . '/search/';
			
			$oParams = new stdClass();
			$oParams->realm = $this->translateRealm($this->sRealm);
			$oParams->presentationId = $this->aObjectId;
			$oParams->useCache = false;
			$oParams->page = 1;
			$oParams->itemsPerPage = 1;

			$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
			$aHeaders = $this->aFormSetting['settings']['authentication_header'];
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
            curl_setopt($oCurl, CURLOPT_POST, true);
            curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
            curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
            curl_setopt($oCurl, CURLOPT_HEADER, false);

            $sResult = curl_exec($oCurl);
			
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);
			
            $oResult = json_decode($sResult);
			
			$this->oObjectData = $oResult;

			return;
		}
		
		public function sitemap_object_url($object,$sPageLink) {
			
			$brand = (!empty($object->specifications->brand) ? "-" . $object->specifications->brand : false);
			$model = (!empty($object->specifications->model) ? "-" . $object->specifications->model : false);
			$version = (!empty($object->specifications->version) ? "-" . $object->specifications->version : false);
			$titleSuffix = (!empty($object->specifications->titleSuffix) ? "-" . $object->specifications->titleSuffix : false);
			$titleRaw = !empty($object->specifications->titleManual) ? $object->specifications->titleManual : $object->specifications->title;
			$title = str_replace(array('(',')', '/', ',', '?', '!', '&'), array('', '', '-', '', '', '', ''), $titleRaw);

			$title = preg_replace('!\s+!', ' ', $title);
			$sComposedTitle		= trim(strtolower($brand . ' ' . $model . ' ' . $version . '' . $titleSuffix));
			$sComposedTitle		= preg_replace('!\s+!', ' ', $sComposedTitle);
			$sComposedTitle = str_replace(array('(',')',','), array('','',''), $sComposedTitle);
			if(trim(strtolower($title)) == preg_replace('!\s+!', ' ', $sComposedTitle)) {
				$title =  $brand . ' ' . $model . ' ' . $version;
			} else {
				$title = '-' . $title;
			}
			$title = str_replace('/', '-', $title);
			$sTralingSlash = false;
			$aPermalink = explode('?',$sPageLink);
			$sNewPermalink = '';
			foreach($aPermalink as $sLinkPart) {
				if(empty($sNewPermalink)) {
					$sNewPermalink = $sLinkPart;
				}
			}
			$permaLinkLast = substr($sNewPermalink, -1);
			if($permaLinkLast != '/') {
				$sTralingSlash = '/';
			}
			
			$sURLCategory = trim(strtolower($object->specifications->category));
			
			if($sURLCategory == 'camper') {
				$sURLCategory = 'kampeerauto';
			} elseif($sURLCategory == 'mobilehome') {
				$sURLCategory = 'stacaravan';
			} elseif($sURLCategory == 'tenttrailer') {
				$sURLCategory = 'vouwwagen';
			} elseif($sURLCategory == 'trailer') {
				$sURLCategory = 'aanhangwagen';
			} elseif($sURLCategory == 'boat') {
				$sURLCategory = 'boot';
			} elseif($sURLCategory == 'engine') {
				$sURLCategory = 'motor';
			} elseif($sURLCategory == 'boattrailer') {
				$sURLCategory = 'boottrailer';
			} else {
				$sURLCategory = strtolower($sURLCategory);
			}
			
			$title = strtolower($title);
			
			$searchArray  = array(' ','.',',','!','/','--','\\','\'','"',':','+','|','(',')','@','#','=','*');
			$replaceArray = array('-','-' ,'' ,'' ,'_','-' ,''  ,''  ,'' ,'','' ,'' ,'' ,'' ,'' ,'' ,'','');

			$title = str_replace($searchArray,$replaceArray, $title);

			$title = preg_replace('/p.*ssl/', 'possl', $title);
			$title = preg_replace('/citro.*n/', 'citroen', $title);
			$title = preg_replace('/b.*rstner/', 'burstner', $title);

			$sUrl = strtolower(str_replace(' ', '-', $sPageLink.$sTralingSlash.$this->sDeeplink.'details/' . $sURLCategory . '/' . $object->id . $title . '.html'));

			$sUrl = str_replace(array('--','-.html','-_-','%80'),array('-','.html','-',''),$sUrl);
			$sUrl = preg_replace('/-+/', '-', $sUrl);
			
			return $sUrl;
		}


		public function getSitemap($sPageURL=false, $oParameters=false) {
			
			$sEndpoint = OVIS_DOMAIN_URL . '/search/';
			
			$sItemsPerPage = 12;

			$oParams = new stdClass();
			
			$sRealm = 'ovis';
			
			if(!empty($oParameters->module) && $oParameters->module == 'boten') {
				$sRealm = 'boat';
			}

			$oParams->realm 		= $sRealm;
			$oParams->useCache 		= false;
			$oParams->itemsPerPage	= $sItemsPerPage;
			$oParams->page			= 1;
			
			if($oParams->realm == 'ovis') {
				$oParams->category = array(
					'caravan', 
					'camper', 
					'mobilehome', 
					'tenttrailer', 
					'trailer'
				);
			} elseif($oParams->realm == 'boat') {
				$oParams->category = array(
					'boat', 
					'engine', 
					'boattrailer'
				);
			}
			
			if(!empty($oParameters->categorie)) {
				
				$aNewCategories = array();
				$aCategoriesFromParameter = explode(',', $oParameters->categorie);
				
				if(!empty($aCategoriesFromParameter) && is_array($aCategoriesFromParameter)) {
					foreach($aCategoriesFromParameter as $key => $value) {
						$value = trim($value);

						if($value == 'kampeerauto') {
							$aNewCategories[] = 'camper';
						} elseif($value == 'stacaravan') {
							$aNewCategories[] = 'mobilehome';
						} elseif($value == 'vouwwagen') {
							$aNewCategories[] = 'tenttrailer';
						} elseif($value == 'aanhangwagen') {
							$aNewCategories[] = 'trailer';
						} elseif($value == 'boot') {
							$aNewCategories[] = 'boat';
						} elseif($value == 'motor') {
							$aNewCategories[] = 'engine';
						} elseif($value == 'boottrailer') {
							$aNewCategories[] = 'boattrailer';
						} else {
							$aNewCategories[] = strtolower($value);
						}
					}
				}
				
				if(!empty($aNewCategories)) {
					$oParams->category = $aNewCategories;
				}
			}
			
			if(!empty($oParameters->subcategorie)) {
				
				if($oParams->realm == 'boat') {
					$oParams->subCategory = explode(',', $oParameters->subcategorie);
				}
			}
			
			if(!empty($oParameters->keyword)) {
				$oParams->keyword = $oParameters->keyword;
			}
			
			if(!empty($oParameters->beschikbaar)) {
				
				if($oParameters->beschikbaar == 'inbegrepen' || $oParameters->beschikbaar == 'uitsluiten' || $oParameters->beschikbaar == 'isoleren') {
					$oParams->available = $oParameters->beschikbaar; 
				}
			}
			
			$oParams->new = true;
			$oParams->occasion = true;
			
			if(!empty($oParameters->conditie)) {

				$oParams->new = false;
				$oParams->occasion = false;

				$aConditionsFromParameter = explode(',', $oParameters->conditie);
				
				if(in_array('nieuw', $aConditionsFromParameter)) {
					$oParams->new = true;
				}
				if(in_array('occasion', $aConditionsFromParameter)) {
					$oParams->occasion = true;
				}
			}
			
			if(!empty($oParameters->verhuur) && $oParameters->verhuur == 'ja') {
				$oParams->rental = true;
			}
			
			if(!empty($oParameters->verkocht) && $oParameters->verkocht == 'nee') {
				$oParams->hidesold = true;
			}
			
			if(!empty($oParameters->status)) {
				
				$aStatusFromParameter = explode(',' ,$oParameters->status);
				
				$oParams->status = $aStatusFromParameter;
			}
			
			if(!empty($oParameters->merk)) {
				
				$aBrandsFromParameter = explode(',', $oParameters->merk);
				
			}
			
			if(!empty($oParameters->bouwjaar)) {
				
				$aBuildYearFromParameter = explode(',', $oParameters->bouwjaar);
				
				if(count($aBuildYearFromParameter) == 2) {
					$oParams->constructionYearFrom = trim($aBuildYearFromParameter[0]);
					$oParams->constructionYearTo = trim($aBuildYearFromParameter[1]);
				}
			}
			
			if(!empty($oParameters->modeljaar)) {
				
				$aModelYearFromParameter = explode(',', $oParameters->modeljaar);
				
				if(count($aModelYearFromParameter) == 2) {
					$oParams->modelYearFrom = trim($aModelYearFromParameter[0]);
					$oParams->modelYearTo = trim($aModelYearFromParameter[1]);
				}
			}
			
            $sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
			$aHeaders = $this->aFormSetting['settings']['authentication_header'];
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
            curl_setopt($oCurl, CURLOPT_POST, true);
            curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
            curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
            curl_setopt($oCurl, CURLOPT_HEADER, false);
			
            $sResult = curl_exec($oCurl);
			
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);
		
            $oResult = json_decode($sResult);
			
			$sXMLHtml = '';
			
			$structure = get_option( 'permalink_structure' );
		
			$sTrailingSlash = '';

			if(substr($structure,-1) == '/') {
				$sTrailingSlash = '/';
			}
			
			if(!empty($oResult->data->data)) {
				
				foreach($oResult->data->data as $key => $value) {
					
					$sURL = $this->sitemap_object_url($value->presentation,$sPageURL);
					
					$sXMLHtml .= '<url><loc>'.$sURL. $sTrailingSlash . '</loc><lastmod>'.$value->presentation->updated.'</lastmod><changefreq>daily</changefreq><priority>0.9</priority></url>';
				}
				
				
				if(!empty($oResult->data->totalItems)) {
					
					$iTotalPages = ceil($oResult->data->totalItems/$sItemsPerPage);
					
					if($iTotalPages > 1) {
						
						for($i=2; $i<=$iTotalPages; $i++) {
							
							$oParams->page = $i;
							
							$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
							
							$oCurl = curl_init();
							curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
							curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
							curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
							curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
							curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
							curl_setopt($oCurl, CURLOPT_POST, true);
							curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
							curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
							curl_setopt($oCurl, CURLOPT_HEADER, false);
							
							$sResult = curl_exec($oCurl);
							
							$sError = curl_errno($oCurl);
							$aResponseInfo = curl_getinfo($oCurl);
						
							$oResult = json_decode($sResult);

							if(!empty($oResult->data->data)) {
					
								foreach($oResult->data->data as $key => $value) {
									
									$sURL = $this->sitemap_object_url($value->presentation,$sPageURL);
									
									$sXMLHtml .= '<url><loc>'.$sURL. $sTrailingSlash .'</loc><lastmod>'.$value->presentation->updated.'</lastmod><changefreq>daily</changefreq><priority>0.9</priority></url>';
								}
							}
						}
					}
				}
			}
			
			return $sXMLHtml;
		}


		/**
		 * Undocumented function
		 *
		 * @param boolean $bReturnRaw
		 * @return void
		 */
		public function search_data($bReturnRaw = false) {

			global $wp_session;
			
			if(!empty($wp_session['session_data']['checkdetails'])) {
				if($this->aObjectId !== false) {
					
					$oDetailsDataFromSession = json_decode(base64_decode($wp_session['session_data']['checkdetails']));
					
					if(!empty($oDetailsDataFromSession->data->data)) {
						$aDetailsDataFromSession = $oDetailsDataFromSession->data->data;
						
						if(!empty($aDetailsDataFromSession[0])) {
							$aDetailsFromSession = $aDetailsDataFromSession[0];
							if(!empty($aDetailsFromSession->presentation->id) && $aDetailsFromSession->presentation->id == $this->aObjectId) {							
								$this->oObjectData = $oDetailsDataFromSession;
								return;
							}
						}
					}
				}
			}
			
			$this->compareSearchToMinMax();

			$sSettings  = $this->aFormSetting;

            $sEndpoint = OVIS_DOMAIN_URL . '/search/';
            
            $oParams = new stdClass();
			
			$oParams->realm = $this->translateRealm($this->sRealm);
			
			$oParams->useCache = true;

			if(!$this->bShowSearchForm) {
				$oParams->useCache = false;
			}
			
			if($this->aObjectId !== false) {
				$oParams->presentationId = $this->aObjectId;
			} else {
				$oParams->userId = array();
				
				if(!empty($this->oObjectFilters->ovisUser)) {
					if(is_array($this->oObjectFilters->ovisUser)) {
						$oParams->userId = $this->oObjectFilters->ovisUser;
					} else {
						$oParams->userId = explode(',', str_replace(' ','',$this->oObjectFilters->ovisUser));						
					}					
				} 
			}
			
			$oParams->category = (!empty($this->oObjectFilters->category) ? explode(',', str_replace(' ','',$this->oObjectFilters->category)) : false);
			
			$aSubcatTosearch = false;
			if(isset($this->oObjectFilters->subCategory)) {
				if(is_array($this->oObjectFilters->subCategory)) {
					$aSubcatTosearch = $this->oObjectFilters->subCategory;
				} else {					
					$aSubcatTosearch = explode(',',$this->oObjectFilters->subCategory);
				}
			}
			
			$oParams->subCategory 		= !empty($aSubcatTosearch) ? $aSubcatTosearch : array();
			
			if(isset($this->aObjectRental) && $this->aObjectRental == 1) {
				$oParams->rental 			= $this->aObjectRental;
			} else {
				$oParams->new 				= $this->oObjectFilters->condition == 'all' || $this->oObjectFilters->condition == 'new' ? true : false;
				$oParams->occasion 			= $this->oObjectFilters->condition == 'all' || $this->oObjectFilters->condition == 'occasion' ? true : false;
				$oParams->hidesold 			= empty($this->sShowSold) ? true : false;
				$oParams->rental 			= false;
			}

			/* Search filters */
			$aFixedBrands = array();
			if(!empty($this->sBrandsFixed)) {
				$aFixedBrands = explode(',',strtolower($this->sBrandsFixed));
			}
			
			$aFixedFuels = array();
			if(!empty($this->sFuelsFixed)) {
				$aFixedFuels = explode(',',strtolower($this->sFuelsFixed));						
			}
			
			$aFixedStatus = array();
			if(!empty($this->sStatusFixed)) {
				$aFixedStatus = explode(',',strtolower(str_replace(' ','',$this->sStatusFixed)));						
			}
			
			$aStatus = false;
			
			if(!empty($aFixedStatus)) {
				
				if(in_array('verkocht',$aFixedStatus)) {
					
					if(empty($aStatus)) {
						$aStatus = array();
					}
					
					$aStatus[] = 'sold';
				}
				
				if(in_array('verwacht',$aFixedStatus)) {
					
					if(empty($aStatus)) {
						$aStatus = array();
					}
					
					$aStatus[] = 'expected';
				}
				
				if(in_array('gereserveerd',$aFixedStatus)) {
					
					if(empty($aStatus)) {
						$aStatus = array();
					}
					
					$aStatus[] = 'reserved';
				}				
			}		
			
			$aFixedKeyword = false;
			if(!empty($this->sKeywordFixed)) {
				$aFixedKeyword = $this->sKeywordFixed;						
			}

			$aBrandsTosearch = false;
			if(isset($this->oObjectFilters->brand)) {
				if(is_array($this->oObjectFilters->brand)) {
					$aBrandsTosearch = $this->oObjectFilters->brand;
				} else {
					$aBrandsTosearch = array($this->oObjectFilters->brand);
				}
			}

			$aFuelsTosearch = false;
			if(isset($this->oObjectFilters->fuel)) {
				if(is_array($this->oObjectFilters->fuel)) {
					$aFuelsTosearch = $this->oObjectFilters->fuel;
				} else {
					$aFuelsTosearch = array($this->oObjectFilters->fuel);
				}
			}

			$aEuroclassTosearch = false;
			if(isset($this->oObjectFilters->euroclass)) {
				if(is_array($this->oObjectFilters->euroclass)) {
					$aEuroclassTosearch = $this->oObjectFilters->euroclass;
				} else {
					$aEuroclassTosearch = array($this->oObjectFilters->euroclass);
				}
			}

			$iConstructionFrom = null;			
			if(!empty($this->sBuildYearFixed->from)) {				
				$iConstructionFrom = $this->sBuildYearFixed->from;
			} elseif(isset($this->oObjectFilters->constructionFrom)) {
				$iConstructionFrom = $this->oObjectFilters->constructionFrom;
			}
			
			$iConstructionTo = null;
			if(!empty($this->sBuildYearFixed->till)) {				
				$iConstructionTo = $this->sBuildYearFixed->till;
			} elseif(isset($this->oObjectFilters->constructionTo)) {
				$iConstructionTo = $this->oObjectFilters->constructionTo;
			}
						
			$iModelYearFrom = null;			
			if(!empty($this->sModelYearFixed->from)) {				
				$iModelYearFrom = $this->sModelYearFixed->from;
			} elseif(isset($this->oObjectFilters->modelFrom)) {
				$iModelYearFrom = $this->oObjectFilters->modelFrom;
			}
			
			$iModelYearTo = null;
			if(!empty($this->sModelYearFixed->till)) {				
				$iModelYearTo = $this->sModelYearFixed->till;
			} elseif(isset($this->oObjectFilters->modelTo)) {
				$iModelYearTo = $this->oObjectFilters->modelTo;
			}
			
			if(!empty($this->oObjectFilters->brand)) {
				$oParams->brand = $aBrandsTosearch;
			} elseif(!empty($aFixedBrands)) {
				$oParams->brand = $aFixedBrands;				
			}
			
			if(!empty($this->oObjectFilters->fuel)) {
				$oParams->fuel = $aFuelsTosearch;
			} elseif(!empty($aFixedFuels)) {
				$oParams->fuel = $aFixedFuels;				
			}
			
			if(!empty($this->oObjectFilters->euroclass)) {
				$oParams->euroclass = $aEuroclassTosearch;
			}

			if(!empty($this->oObjectFilters->modelTypeVersion)) {
				$oParams->modelTypeVersion = $this->oObjectFilters->modelTypeVersion;
			}
			
			if(!empty($this->oObjectFilters->keyword)) {
				$oParams->keyword = $this->oObjectFilters->keyword;
			} elseif(!empty($aFixedKeyword)) {
				$oParams->keyword = $aFixedKeyword;
				
			}
			
			if(!empty($aStatus)) {
				$oParams->status = $aStatus;
			}
			
			if(!empty($this->oObjectFilters->rentalDateFrom)) {
				$oParams->rentalDateFrom = date('Y-m-d H:i:s',strtotime($this->oObjectFilters->rentalDateFrom));
			}
			
			if(!empty($this->oObjectFilters->rentalDateTo)) {
				$oParams->rentalDateTo = date('Y-m-d H:i:s',strtotime($this->oObjectFilters->rentalDateTo));
			}
			
			if(!empty($this->oObjectFilters->priceFrom)) {
				$oParams->priceFrom = $this->oObjectFilters->priceFrom;
			}
			
			if(!empty($this->oObjectFilters->priceTo)) {
				$oParams->priceTo = $this->oObjectFilters->priceTo;
			}

			if(!empty($iConstructionFrom)) {
				$oParams->constructionYearFrom = $iConstructionFrom;
			}
			
			if(!empty($iConstructionTo)) {
				$oParams->constructionYearTo = $iConstructionTo;
			}

			if(!empty($iModelYearFrom)) {
				$oParams->modelYearFrom = $iModelYearFrom;
			}
			
			if(!empty($iModelYearTo)) {
				$oParams->modelYearTo = $iModelYearTo;
			}
				
			if(!empty($this->oObjectFilters->maxweightFrom)) {
				$oParams->maxWeightFrom = $this->oObjectFilters->maxweightFrom;
			}
			
			if(!empty($this->oObjectFilters->maxweightTo)) {
				$oParams->maxWeightTo = $this->oObjectFilters->maxweightTo;
			}
			
			if(!empty($this->oObjectFilters->sleepingplacesFrom)) {
				$oParams->sleepingPlacesFrom = $this->oObjectFilters->sleepingplacesFrom;
			}

			if(!empty($this->oObjectFilters->sleepingPlacesTo)) {
				$oParams->sleepingPlacesTo = $this->oObjectFilters->sleepingPlacesTo;
			}
			
			if(!empty($this->oObjectFilters->seatbeltsFrom)) {
				$oParams->seatbeltsFrom = $this->oObjectFilters->seatbeltsFrom;
			}
			
			if(!empty($this->oObjectFilters->seatbeltsTo)) {
				$oParams->seatbeltsTo = $this->oObjectFilters->seatbeltsTo;
			}
			
			if(!empty($this->oObjectFilters->mileageFrom)) {
				$oParams->mileageFrom = $this->oObjectFilters->mileageFrom;
			}
			
			if(!empty($this->oObjectFilters->mileageTo)) {
				$oParams->mileageTo = $this->oObjectFilters->mileageTo;
			}
			
			if(!empty($this->oObjectFilters->lengthFrom)) {
				$oParams->lengthFrom = $this->oObjectFilters->lengthFrom;
			}
			
			if(!empty($this->oObjectFilters->lengthTo)) {
				$oParams->lengthTo = $this->oObjectFilters->lengthTo;
			}
			
			if(!empty($this->oObjectFilters->powerFrom)) {
				$oParams->powerFrom = $this->oObjectFilters->powerFrom;
			}
			
			if(!empty($this->oObjectFilters->powerTo)) {
				$oParams->powerTo = $this->oObjectFilters->powerTo;
			}

			if(!empty($this->oObjectFilters->fastsailing) && $this->oObjectFilters->fastsailing != 'all' ) {
				$oParams->fastSailing = strtolower($this->oObjectFilters->fastsailing) == 'ja' ? true : false;
			}

			if(!empty($this->oObjectFilters->transmission)) {
				$oParams->transmission = $this->oObjectFilters->transmission;
			}

			$aDivisionTosearch = null;
			if(isset($this->oObjectFilters->division)) {
				if(is_array($this->oObjectFilters->division)) {
					$aDivisionTosearch = $this->oObjectFilters->division;
				} else {
					$aDivisionTosearch = array($this->oObjectFilters->division);
				}
			}
			
			if(!empty($aDivisionTosearch)) {
				$oParams->division = $aDivisionTosearch;
			}
			
			$setOrder = (!empty($this->bSearchSorting->order) && $this->bSearchSorting->order == 'desc' ? true : false);					
			$sFilterSortingString = !empty($this->oObjectFilters) && !empty($this->oObjectFilters->sortField) ? $this->oObjectFilters->sortField : (!empty($this->bSearchSorting->field) ? $this->bSearchSorting->field : false);			
			
			$sFilterSorting = 'creationDate';
			
			if(!empty($sFilterSortingString)) {
				
				switch($sFilterSortingString) {
					case 'brand_up':					
						$sFilterSorting = 'brand';
						$setOrder = false;
						break;
					case 'brand_down':					
						$sFilterSorting = 'brand';
						$setOrder = true;
						break;
					case 'price_up':					
						$sFilterSorting = 'price';
						$setOrder = false;
						break;
					case 'price_down':					
						$sFilterSorting = 'price';
						$setOrder = true;
						break;
					case 'constructionYear_up':					
						$sFilterSorting = 'constructionYear';
                        $setOrder = false;
						break;
					case 'constructionYear_down':					
						$sFilterSorting = 'constructionYear';
						$setOrder = true;
						break;
					case 'maxWeight_up':					
						$sFilterSorting = 'maxWeight';
						$setOrder = false;
						break;
					case 'maxWeight_down':					
						$sFilterSorting = 'maxWeight';
						$setOrder = true;
						break;
					case 'sleepingPlaces_up':					
						$sFilterSorting = 'sleepingPlaces';
						$setOrder = false;
						break;
					case 'sleepingPlaces_down':					
						$sFilterSorting = 'sleepingPlaces';
						$setOrder = true;
						break;
					case 'category':					
						$sFilterSorting = 'category';
						$setOrder = true;
						break;
				}
			}
			
			$oOrder = new stdClass();
			$oOrder->field = $sFilterSorting;
			
			$oOrder->descending = $setOrder;	
			
			$oParams->order = array();
			
			if($this->sShowSold === 'last' || $oOrder->field == 'price') {			
				$aSortSoldLast = array('field'=>'sold','descending'=>false);
				$oParams->order[] = $aSortSoldLast;
			}			
			
			$oParams->order[] = $oOrder;

			/* Page filters */
			$oParams->page = $this->aObjectPage;
			
			if(!$this->bShowSearchForm) {			
				$oParams->itemsPerPage = $sSettings['settings']['items_per_page_no_filter'];			
			} else {
				$oParams->itemsPerPage = $sSettings['settings']['items_per_page'];			
			}

            $oParams->available = $this->sAvailableItems; 
			
			$bad_keys = array('sold','reserved','expected');
			
			$statusFiltered = !empty($oParams->status) && is_array($oParams->status) ? array_filter($oParams->status, function($v, $k) {
				return $v == 'sold' || $v == 'reserved' || $v == 'expected';
			}, ARRAY_FILTER_USE_BOTH) : false;
			
			if(!empty($statusFiltered)) {
				$oParams->status = $statusFiltered;			
			}	
			
            $sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);		

			$aHeaders = null;
			$aHeaders = $this->aFormSetting['settings']['authentication_header'];
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
            curl_setopt($oCurl, CURLOPT_POST, true);
            curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
            curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
            curl_setopt($oCurl, CURLOPT_HEADER, false);
			
            $sResult = curl_exec($oCurl);
			
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);	
		
            $oResult = json_decode($sResult);

			if($bReturnRaw) {
				$this->oObjectData = $sResult;
			} else {			
				$this->oObjectData = $oResult;
			}
        } 
		
		public function getBlockedDates($iProductID) {

			if(empty($iProductID)) {
				return false;
			}

			$sEndpoint = OVIS_DOMAIN_URL . '/search/rentalstatus/'.$iProductID;
			$aHeaders = $this->aFormSetting['settings']['authentication_header'];
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
            curl_setopt($oCurl, CURLOPT_POST, false);
            curl_setopt($oCurl, CURLOPT_HTTPHEADER, $aHeaders);
            curl_setopt($oCurl, CURLOPT_HEADER, false);
			
            $sResult = curl_exec($oCurl);
			
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);			

            $oResult = json_decode($sResult);
			
			if(!empty($oResult->data)) {
				return $oResult->data;
			}
			
			return false;			
		}		
    }
	
?>