<?php

require_once plugin_dir_path(__FILE__) . '../classes/class.settings.php';

class forms {

	var $aFormSettings = false;
	
	public function get_settings(){
		
		$_oSettings = new settings();
		$this->aFormSettings = $_oSettings->get_settings();
		
		return;
	}
	
	
	public function form_settings_appearance() {
	
		$bTranslationAllowed = false;
		
		if(!empty($this->aFormSettings['settings']['authentication_key'])){;

			$oData = new data($this->aFormSettings);
			$oData->getTranslations();			
					
			if(!empty($oData->aTranslations->data->allowed)){
				$bTranslationAllowed = true;
			}
				
		}		
		
		$ovis_anchor = !empty($this->aFormSettings['settings']['anchor']) ? $this->aFormSettings['settings']['anchor'] : false;
		
		$ovis_texts = !empty($this->aFormSettings['settings']['texts']) ? $this->aFormSettings['settings']['texts'] : false;
					
		$label_verhuuraanvraag = !empty($ovis_texts['label_verhuuraanvraag']) ? $ovis_texts['label_verhuuraanvraag'] : $this->aFormSettings['settings']['rental_button_default'];
		$label_verhuuropmerking = !empty($ovis_texts['label_verhuuropmerking']) ? $ovis_texts['label_verhuuropmerking'] : $this->aFormSettings['settings']['rental_opmerking_default'];
		$label_koopknop = !empty($ovis_texts['label_koopknop']) ? $ovis_texts['label_koopknop'] : $this->aFormSettings['settings']['koopknop_default'];

		$custom_css = !empty($this->aFormSettings['settings']['custom_css']) ? stripslashes($this->aFormSettings['settings']['custom_css']) : false;
	
		$sHTML = '
		<form class="validation ovis-default s50" id="form_settings" method="post" autocomplete="off">

			<input type="hidden" name="form_action" id="form_action_appearance" value="save-appearance" />
			
			<div class="ovis-seperator"></div>
			
			<h4>Label verhuuraanvraag</h4>

			<div class="contain">                
				<input class="language_flag nl" type="text" name="label_verhuuraanvraag[nl]" maxlength="100" value="' . $label_verhuuraanvraag['nl'] . '" placeholder="" />                    
			</div>
			
			<script>
				
			</script>
			
			';
			
			if(!empty($bTranslationAllowed)){				
				$sHTML .= '
				<div id="translate_verhuuraanvraag" class="contain hidden">
				
					<input class="language_flag en" type="text" name="label_verhuuraanvraag[en]" maxlength="100" value="' . $label_verhuuraanvraag['en'] . '" placeholder="" />
					<input class="language_flag de" type="text" name="label_verhuuraanvraag[de]" maxlength="100" value="' . $label_verhuuraanvraag['de'] . '" placeholder="" />
					<input class="language_flag fr" type="text" name="label_verhuuraanvraag[fr]" maxlength="100" value="' . $label_verhuuraanvraag['fr'] . '" placeholder="" />
					
				</div>
				<div class="translate_label" onclick="jQuery.showTranslation(\'translate_verhuuraanvraag\');">Vertalen</div>
				';
			}
			
			$sHTML .= '<div class="ovis-seperator"></div>
			
			<h4>Placeholder verhuuropmerking</h4>

			<div class="contain">                
				<input class="language_flag nl" type="text" name="label_verhuuropmerking[nl]" maxlength="100" value="' . stripslashes($label_verhuuropmerking['nl']) . '" placeholder="" />                    
			</div>';
			
			if(!empty($bTranslationAllowed)){				
				$sHTML .= '
				<div id="translate_verhuuropmerking" class="contain hidden">
				
					<input class="language_flag en" type="text" name="label_verhuuropmerking[en]" maxlength="100" value="' . $label_verhuuropmerking['en'] . '" placeholder="" />
					<input class="language_flag de" type="text" name="label_verhuuropmerking[de]" maxlength="100" value="' . $label_verhuuropmerking['de'] . '" placeholder="" />
					<input class="language_flag fr" type="text" name="label_verhuuropmerking[fr]" maxlength="100" value="' . $label_verhuuropmerking['fr'] . '" placeholder="" />
					
				</div>
				<div class="translate_label" onclick="jQuery.showTranslation(\'translate_verhuuropmerking\');">Vertalen</div>
				';
			}
			
			$sHTML .= '<div class="ovis-seperator"></div>
			
			<h4>Placeholder Koop knop</h4>

			<div class="contain">                
				<input class="language_flag nl" type="text" name="label_koopknop[nl]" maxlength="100" value="' . stripslashes($label_koopknop['nl']) . '" placeholder="" />                    
			</div>';
			
			if(!empty($bTranslationAllowed)){				
				$sHTML .= '
				<div id="translate_verhuuropmerking" class="contain hidden">
				
					<input class="language_flag en" type="text" name="label_koopknop[en]" maxlength="100" value="' . $label_koopknop['en'] . '" placeholder="" />
					<input class="language_flag de" type="text" name="label_koopknop[de]" maxlength="100" value="' . $label_koopknop['de'] . '" placeholder="" />
					<input class="language_flag fr" type="text" name="label_koopknop[fr]" maxlength="100" value="' . $label_koopknop['fr'] . '" placeholder="" />
					
				</div>
				<div class="translate_label" onclick="jQuery.showTranslation(\'translate_verhuuropmerking\');">Vertalen</div>
				';
			}
							
			
			$sHTML .= '<style>
			.CodeMirror {
				border: 1px solid #ddd;
			}
			</style>
			<div class="ovis-seperator"></div>
			<h4>Custom CSS</h4>
			<p><i>Gebruik dit veld indien de CSS van uw eigen website de vormgeving van de OVIS output aantast.</i></p>
			<div class="contain">                
				<textarea name="custom_css" id="custom-css">' . $custom_css . '</textarea/>                    
			</div>';
			
			$sHTML .= '<div class="ovis-seperator"></div>';
							
			$sHTML .= '				
			<h4>Anchor</h4>
			<p><i>Gebruik dit veld indien u een anchor (#) aan de url\'s wilt toevoegen.</i></p>
			<div class="contain">                
				<input class="" type="text" name="ovis_anchor" maxlength="100" value="' . $ovis_anchor . '" placeholder="" />                    
			</div>';				
			
			$sHTML .= '<div class="ovis-seperator"></div>';
					
			$sHTML .= '<div class="contain-submit">
			
				<input id="submitform" class="submit" type="submit" value="Opslaan" />
				<p class="msg"></p>
				
			</div>
			
			
			

		</form>';

		return $sHTML;
	
	}
		
	public function form_settings_notice() {
		$sHTML = '<p class="ovis-notice">Voor een optimale werking van de OVIS plugin dienen de pagina\'s waar u aanbod wilt tonen te worden uitgesloten van eventuele caching plugins.</p>';
		
		return $sHTML;
	}
	
	public function form_settings_authentication() {
	
		$authenticationKey = $this->aFormSettings['settings']['authentication_key'];
		$items_per_row = $this->aFormSettings['settings']['items_per_row'];
		$items_per_page = $this->aFormSettings['settings']['items_per_page'];
		$items_per_page_no_filter = $this->aFormSettings['settings']['items_per_page_no_filter'];
		$position_video_in_gallery = $this->aFormSettings['settings']['position_video_in_gallery'];

		$sHTML = '
		<form class="validation ovis-default s50" id="form_settings" method="post" autocomplete="off">

			<input type="hidden" name="form_action" value="save" />
			
			<div class="ovis-seperator"></div>
			
			<h4>Authenticatie</h4>

			<div class="contain">
			
				<label>Sleutel
				</label><input type="text" name="authentication_key" maxlength="100" value="' . $authenticationKey . '" placeholder="" />
				
				<p class="ovis-message">Voor dat u gebruik kunt maken van de plugin dient u eenmalig uw huidige permalink instellingen opnieuw te bewaren. Aanpassen is niet noodzakelijk.</p>
				
			</div>
			
			<div class="ovis-seperator"></div>
			
			<h4>Aantal objecten per pagina</h4>
			<p><i>Minimale waarde 1, maximale waarde 100. Standaard waarde 12.</i></p>

			<div class="contain">
			
				<label>Aantal
				</label><input type="text" class="items_per_page validate validate-number" data-min="1" data-max="100" data-default="12" name="items_per_page" maxlength="3" value="' . $items_per_page . '" placeholder="" />	
				
				<span class="extra-message" id="extra-message-items_per_page"></span>
			</div>
			
			<h4>Aantal objecten per pagina, op pagina zonder filters</h4>
			<p><i>Minimale waarde 1, maximale waarde 100. Standaard waarde 12.</i></p>

			<div class="contain">
			
				<label>Aantal
				</label><input type="text" class="items_per_page_no_filter validate validate-number" data-min="1" data-max="100" data-default="12" name="items_per_page_no_filter" maxlength="3" value="' . $items_per_page_no_filter . '" placeholder="" />	
				
				<span class="extra-message" id="extra-message-items_per_page_no_filter"></span>
			</div>
			
			<div class="ovis-seperator"></div>
			
			<h4>Aantal objecten per rij</h4>
			<div class="contain">
			
				<label>Aantal
				</label><select name="items_per_row" />
				
					<option value="2" ' . (($items_per_row && $items_per_row == 2) ? ' selected' : '') . '>2</option>
					<option value="3" ' . (($items_per_row && $items_per_row == 3) ? ' selected' : '') . '>3</option>
					<option value="4" ' . (($items_per_row && $items_per_row == 4) ? ' selected' : '') . '>4</option>
					<option value="5" ' . (($items_per_row && $items_per_row == 5) ? ' selected' : '') . '>5</option>
					
				</select>
				
			</div>
			
			<div class="ovis-seperator"></div>
			
			<h4>Positie taGGle video in gallerij</h4>
			<div class="contain">

				<label for="ovis__position-video--first" class="ovis__position-video__label">Eerste</label>
				<input type="radio" id="ovis__position-video--first" class="ovis__position-video__input" name="position_video_in_gallery" value="first"' . ((!empty($position_video_in_gallery) && $position_video_in_gallery === "first") ? 'checked' : '') . ' />

				<label for="ovis__position-video--second" class="ovis__position-video__label">Tweede</label>
				<input type="radio" id="ovis__position-video--second" class="ovis__position-video__input" name="position_video_in_gallery" value="second"' . ((empty($position_video_in_gallery) || $position_video_in_gallery === "second") ? 'checked' : '') . ' />

				<label for="ovis__position-video--last" class="ovis__position-video__label">Laatste</label>
				<input type="radio" id="ovis__position-video--last" class="ovis__position-video__input" name="position_video_in_gallery" value="last"' . ((!empty($position_video_in_gallery) && $position_video_in_gallery === "last") ? 'checked' : '') . ' />

			</div>
			
			<div class="ovis-seperator"></div>

			<div class="contain-submit">
			
				<input id="submitform" class="submit" type="submit" value="Opslaan" />
				<p class="msg"></p>
				
			</div>

		</form>';

		return $sHTML;
	}


	public function form_clear_cache() {
			
		$sHTML = '
		<form class="validation ovis-default design s50" id="form_clear_cache" method="post">
		
			<input type="hidden" name="form_action" value="flush_ovis_cache" />
		
			<div class="contain-submit">
			
				<input id="submitcacheform" class="submit" type="submit" value="Cache opschonen" />
				<p class="msg"></p>
				
			</div>

		</form>';

		return $sHTML;
	
	}
			
	public function form_design_button_bg_color() {
			
		$sHTML = '
		<form class="validation ovis-default design s50" id="form_settings_button_bg_color" method="post">
		
			<input type="hidden" name="form_action" value="save" />
		
			<div class="contain-submit">
			
				<p class="label">Achtergrondkleur</p>
				<input type="text" name="button_bg_color" data-color="' . $this->aFormSettings['settings']['button_bg_color'] . '" id="cp_button_bg"/>
				<p class="msg"></p>
				
			</div>

		</form>';

		return $sHTML;
	
	}
	
	public function form_design_button_text_color() {
						
		$sHTML = '
		<form class="validation ovis-default design s50" id="form_settings_button_text_color" method="post">
		
			<input type="hidden" name="form_action" value="save" />
		
			<div class="contain-submit">
			
				<p class="label">Tekstkleur</p>
				<input type="text" name="button_text_color" data-color="' . $this->aFormSettings['settings']['button_text_color'] . '" id="cp_button_text"/>
				<p class="msg"></p>

			</div>

		</form>';

		return $sHTML;
	
	}
	
	public function form_design_object_bg_color() {
						
		$sHTML = '
		<form class="validation ovis-default design s50" id="form_settings_object_bg_color" method="post">
		
			<input type="hidden" name="form_action" value="save" />
		
			<div class="contain-submit">
			
				<p class="label">Achtergrondkleur</p>
				<input type="text" name="object_bg_color" data-color="' . $this->aFormSettings['settings']['object_bg_color'] . '" id="cp_object_bg"/>
				<p class="msg"></p>

			</div>

		</form>';

		return $sHTML;
	
	}
	
	public function form_design_object_text_color() {
						
		$sHTML = '
		<form class="validation ovis-default design s50" id="form_settings_object_text_color" method="post">
		
			<input type="hidden" name="form_action" value="save" />
		
			<div class="contain-submit">
			
				<p class="label">Tekstkleur</p>
				<input type="text" name="object_text_color" data-color="' . $this->aFormSettings['settings']['object_text_color'] . '" id="cp_object_text"/>
				<p class="msg"></p>

			</div>

		</form>';

		return $sHTML;
	
	}
	
	public function form_design_bg_color() {
						
		$sHTML = '
		<form class="validation ovis-default design s50" id="form_settings_bg_color" method="post">
		
			<input type="hidden" name="form_action" value="save" />
		
			<div class="contain-submit">
			
				<p class="label">Achtergrondkleur</p>
				<input type="text" name="bg_color" data-color="' . $this->aFormSettings['settings']['bg_color'] . '" id="cp_bg"/>
				<p class="msg"></p>

			</div>

		</form>';

		return $sHTML;
	
	}
	
	public function form_design_text_color() {
						
		$sHTML = '
		<form class="validation ovis-default design s50" id="form_settings_text_color" method="post">
		
			<input type="hidden" name="form_action" value="save" />
		
			<div class="contain-submit">
			
				<p class="label">Tekstkleur</p>
				<input type="text" name="text_color" data-color="' . $this->aFormSettings['settings']['text_color'] . '" id="cp_text"/>
				<p class="msg"></p>

			</div>

		</form>';

		return $sHTML;
	}

}