<?php

require_once plugin_dir_path(__FILE__) . '../classes/class.data.php';

class output {

	const DEFAULT_LISTING_LAYOUT = 'grid';
	const DEFAULT_FILTER_LAYOUT = 'top';
	const DEFAULT_VIDEO_POSITION_INDEX = 2;
	const DEFAULT_LANGUAGE = 'nl_NL';
	const ITEMS_PER_ROW_DEFAULT = 3;
	const ITEMS_PER_ROW_MIN = 2;
	const ITEMS_PER_ROW_MAX = 5;
	const DEFAULT_TRADE_IN_IMAGE = 'optional';

	private $bHasEmail = false;
	private $sPhoneNumber;
	private $bHasTradeInProposalEnabled = false;
	private $sCompanyName;
	var $sUserCity = false;
	var $ovisUrlPageName = false;
	var $bSearchSorting = false;
	private $sSearchSortingRaw;
	private $bExpandSearch = false;
	private $bShowSold = true;
	private $bSoldAtEnd = false;
	var $sBrandsFixed = false;
	var $sFuelsFixed = false;
	var $sStatusFixed = false;
	var $sKeywordFixed = false;
	var $sPageName = false;
	var $bShowCalendar = false;
	var $bRentalActive = false;
	var $bScrollOnLoad = false;
	var $bFilterUsers = false;
	var $sUniqueID = false;
	var $aFormSettings = false;
	var $sDeeplink = false;
	private $sLanguage = self::DEFAULT_LANGUAGE;
	var $aLanguageConfig = 'nl_NL';
	var $sShowPrices = false;
	var $sSessionData = false;
	var $aNumberToWords = false;
	var $sShowShop = false;
	var $sShowAvailable = false;
	var $sCategory = false;
	var $sSubCategory = false;
	var $sCondition = false;
	var $sRealm = false;
	var $sSearchFilters = false;
	var $sAnchor = false;
	var $oBouwjaar = false;
	var $oModeljaar = false;
	var $sDealer = false;
	var $iPerRij = false;
	private $bShowBtwMarge = false;
	private $sLayout = self::DEFAULT_LISTING_LAYOUT;
	private $sFilterLayout = self::DEFAULT_FILTER_LAYOUT;
	private $sTradeInPictures = self::DEFAULT_TRADE_IN_IMAGE;
	private $bIsTradeInImageRequired = false;
	private $bIsTradeInImageDisabled = false;
	private $sVideoPosition = '';
	var $sCallToAction = '';
	var $sShowConditionNewOrOccasion = false;
	var $sShowMoreSpecifications = false;
	var $sShowAllFilters = false;
	private $bShowContactAddress = true;
    private $bShowSocials = true;
	private $bShowDealerFooter = true;
	var $sShowExtraFilters = false;
	var $aSpecificationsOrder = false;
	var $aHideFilters = false;
	var $aLanguages = false;
	var $sKeyword = false;
	var $iPerRijWord = false;
	private $iPageNumber;
	var $aObjectDivisionsData = false;
	var $aObjectDivisionValues = false;
	private $iCountSpecsColor = 0;
	private $aHideSpecs = array();
	private $sCurrentUrl = '';


	public function __construct() {
		$this->sShowConditionNewOrOccasion = 'all';
		$this->sShowMoreSpecifications = 'closed';
		$this->sShowAllFilters = 'closed';
		$this->aNumberToWords = array(2 => 'two',3 => 'three',4 => 'four',5 => 'five');
	}


	/**
	 * Set category from shortcode
	 *
	 * @param boolean $category
	 * @return void
	 */
	public function setCategory($category=false) {
		$this->sCategory = $category;
	}


	/**
	 * Set requirement trade-in pictures
	 * 
	 * Options:
	 * 	* optional (default)
	 * 	* required
	 * 	* disabled
	 * 
	 * @param string [$sTradeInImageState]
	 * @return void
	 */
	public function setTradeInPictures($sTradeInImageState='optional') {
		if(empty($sTradeInImageState)) return;
		if(!is_string($sTradeInImageState)) return;
		$aOptions = array(
			'optioneel', 
			'optional', 
			'verplicht', 
			'vereist', 
			'required', 
			'disabled', 
			'uitgeschakeld', 
			'verborgen', 
			'hidden'
		);
		if(!in_array($sTradeInImageState, $aOptions)) return;

		if(in_array($sTradeInImageState, array('verplicht', 'vereist', 'required'))) {
			$this->bIsTradeInImageRequired = true;
		}

		if(in_array($sTradeInImageState, array('uitgeschakeld', 'disabled', 'hidden', 'verborgen'))) {
			$this->bIsTradeInImageDisabled = true;
		}

		$this->sTradeInPictures = $sTradeInImageState;
	}


	/**
	 * Set requirement trade-in pictures
	 * 
	 * Options:
	 * 	* first
	 * 	* second (default)
	 * 	* last
	 * 
	 * @param string $videoposition
	 * @return void
	 */
	public function setVideoPosition($videoposition='second') {
		$this->sVideoPosition = $videoposition;
	}


	/**
	 * Set layout from shortcode
	 *
	 * @param string $sLayout
	 * @return void
	 */
	public function setLayout($sLayout='grid') {
		if(empty($sLayout)) return;
		$this->sLayout = $sLayout;
	}


	/**
	 * Set filter layout from shortcode
	 *
	 * @param string $sFilterLayout
	 * @return void
	 */
	public function setFilterLayout($sFilterLayout='top') {
		$this->sFilterLayout = $sFilterLayout;
	}


	/**
	 * Set subcategory from shortcode
	 *
	 * @param boolean $subcategory
	 * @return void
	 */
	public function setSubcategory($subcategory=false) {
		$this->sSubCategory = $subcategory;
	}


	/**
	 * Set condition from shortcode
	 *
	 * @param boolean $condition
	 * @return void
	 */
	public function setCondition($condition=false) {
		$this->sCondition = $condition;
	}


	/**
	 * Set realm from shortcode
	 *
	 * @param boolean $realm
	 * @return void
	 */
	public function setRealm($realm=false) {
		$this->sRealm = $realm;
	}


	/**
	 * Set rental from shortcode
	 *
	 * @param boolean $rental
	 * @return void
	 */
	public function setRental($rental=false) {
		$this->bRentalActive = $rental;
	}


	/**
	 * Set scrollonload from shortcode
	 *
	 * @param boolean $scrollonload
	 * @return void
	 */
	public function setScrollonload($scrollonload=false) {
		$this->bScrollOnLoad = $scrollonload;
	}


	/**
	 * Set searchsorting from shortcode
	 *
	 * @param boolean $searchsorting
	 * @return void
	 */
	public function setSearchSorting($searchsorting=false) {
		$this->bSearchSorting = $searchsorting;
	}

	
	/**
	 * Set raw searchsorting from shortcode
	 *
	 * @param string $sSearchSorting
	 * @return void
	 */
	public function setSearchSortingRaw($sSearchSorting) {
		$this->sSearchSortingRaw = $sSearchSorting;
	}


	/**
	 * Set searchfilters from shortcode
	 *
	 * @param boolean $searchFilters
	 * @return void
	 */
	public function setSearchFilters($searchFilters=false) {
		$this->sSearchFilters = $searchFilters;
		$this->bExpandSearch = $searchFilters === 'expanded' ? true : false;
	}


	/**
	 * Set showcalendar from shortcode
	 *
	 * @param boolean $showcalendar
	 * @return void
	 */
	public function setShowCalendar($showcalendar=false) {
		$this->bShowCalendar = $showcalendar;
	}


	/**
	 * Set showsold from shortcode
	 *
	 * @param boolean $showsold
	 * @return void
	 */
	public function setShowSold($showsold=true) {
		$this->bShowSold = $showsold;
	}


	/**
	 * Set `Sold` presentations placement
	 *
	 * @param boolean $bSoldAtEnd
	 * @return void
	 */
	public function setSoldAtEnd($bSoldAtEnd = false) {
		$this->bSoldAtEnd = $bSoldAtEnd;
	}


	/**
	 * Set shop from shortcode
	 *
	 * @param boolean $shop
	 * @return void
	 */
	public function setShop($shop=false) {
		$this->sShowShop = $shop;
	}


	/**
	 * Set brands from shortcode
	 *
	 * @param boolean $brands
	 * @return void
	 */
	public function setBrands($brands=false) {
		$this->sBrandsFixed = $brands;
	}


	/**
	 * Set brandstof from shortcode
	 *
	 * @param boolean $brandstof
	 * @return void
	 */
	public function setBrandstof($brandstof=false) {
		$this->sFuelsFixed = $brandstof;
	}


	/**
	 * Set status from shortcode
	 *
	 * @param boolean $status
	 * @return void
	 */
	public function setStatus($status=false) {
		$this->sStatusFixed = $status;
	}


	/**
	 * Set keyword from shortcode
	 *
	 * @param boolean $keyword
	 * @return void
	 */
	public function setKeyword($keyword=false) {
		$this->sKeywordFixed = $keyword;
		$this->sKeyword = $keyword;
	}


	/**
	 * Set available from shortcode
	 *
	 * @param boolean $available
	 * @return void
	 */
	public function setAvailable($available=false) {
		$this->sShowAvailable = $available;
	}


	/**
	 * Set filterusers from shortcode
	 *
	 * @param boolean $filterusers
	 * @return void
	 */
	public function setFilterusers($filterusers=false) {
		$this->bFilterUsers = $filterusers;
	}


	/**
	 * Set deeplink from shortcode
	 *
	 * @param boolean $deeplink
	 * @return void
	 */
	public function setDeeplink($deeplink=false) {
		$this->sDeeplink = $deeplink;
	}


	/**
	 * Set anchor from shortcode
	 *
	 * @param boolean $anchor
	 * @return void
	 */
	public function setAnchor($anchor=false) {
		$this->sAnchor = $anchor;
	}


	/**
	 * Set bouwjaar from shortcode
	 *
	 * @param boolean $bouwjaar
	 * @return void
	 */
	public function setBouwjaar($bouwjaar=false) {
		$this->oBouwjaar = $bouwjaar;
	}

	
	/**
	 * Set modeljaar from shortcode
	 *
	 * @param boolean $modeljaar
	 * @return void
	 */
	public function setModeljaar($modeljaar=false) {
		$this->oModeljaar = $modeljaar;
	}


	/**
	 * Set dealer from shortcode
	 *
	 * @param boolean $dealer
	 * @return void
	 */
	public function setDealer($dealer=false) {
		$this->sDealer = $dealer;
	}


	/**
	 * Set perrij from shortcode
	 *
	 * @param boolean $perrij
	 * @return void
	 */
	public function setPerrij($perrij=false) {
		if(empty($perrij)) return;
		$this->iPerRij = (int)$perrij;
	}


	/**
	 * Set showbtwmarge from shortcode
	 *
	 * @param boolean $showbtwmarge
	 * @return void
	 */
	public function setShowBtwMarge($showbtwmarge=false) {
		$this->bShowBtwMarge = $showbtwmarge;
	}


	/**
	 * Set calltoaction from shortcode
	 *
	 * @param boolean $calltoaction
	 * @return void
	 */
	public function setCallToAction($calltoaction=false) {
		$calltoactionFiltered = false;
		
		if(!empty($calltoaction)) {
			$aCallToAction = explode(',',$calltoaction);
			$calltoactionFiltered = !empty($aCallToAction) && is_array($aCallToAction) ? array_filter($aCallToAction, function($v, $k) {
				return $v == 'proefrit' || $v == 'bezichtiging' || $v == 'afspraak' || $v == 'mail' || $v == 'verhuuraanvraag' || $v == 'inruilvoorstel';
			}, ARRAY_FILTER_USE_BOTH) : false;
		}
		
		if(empty($calltoactionFiltered)) {
			$calltoactionFiltered = false;
		}

		$this->sCallToAction = $calltoactionFiltered;	
	}


	/**
	 * Show condition new or occasion
	 *
	 * Default is all
	 * 
	 * @param string $sShowConditionNewOrOccasion
	 * @return void
	 */
	public function showConditionNewOrOccasion($sShowConditionNewOrOccasion) {
		$this->sShowConditionNewOrOccasion = $sShowConditionNewOrOccasion;
	}


	/**
	 * Open or close more specifications on the detailpage
	 * 
	 * Default is closed
	 *
	 * @param string $sShowMoreSpecifications
	 * @return void
	 */
	public function showMoreSpecifications($sShowMoreSpecifications) {	
		$this->sShowMoreSpecifications = $sShowMoreSpecifications;	
	}


	/**
	 * Open or close all filters on the frontpage
	 *
	 * @param string $sShowExtraFilters
	 * @return void
	 */
	public function showExtraFilters($sShowExtraFilters) {
		$this->sShowExtraFilters = $sShowExtraFilters;
	}


	/**
	 * Show or hide dealer footer
	 *
	 * Default is true
	 * 
	 * @param string $sShowDealerFooter
	 * @return void
	 */
	public function showDealerFooter($sShowDealerFooter) {
		$this->bShowDealerFooter = $sShowDealerFooter === 'ja' || $sShowDealerFooter === 'yes' ? true : false;
	}


	/**
	 * Show or hide socials on detailpage
	 * 
	 * Default is true
	 * 
	 * @param string $sShowSocials
	 * @return void
	 */
	public function showSocials($sShowSocials) {
		$this->bShowSocials = $sShowSocials === 'ja' || $sShowSocials === 'yes' ? true : false;
	}


	/**
	 * Show or hide the contact address on detailpage
	 * 
	 * Default is true
	 * 
	 * @param string $sShowContactAddress
	 * @return void
	 */
	public function showContactAddress($sShowContactAddress) {
		$this->bShowContactAddress = $sShowContactAddress === 'ja' || $sShowContactAddress === 'yes' ? true : false;
	}


	/**
	 * Hide filters on frontpage
	 * 
	 * Default is show all
	 * 
	 * @param array $aHideFilters
	 * @return void
	 */
	public function hideFilters($aHideFilters) {
		$this->aHideFilters = $aHideFilters;
	}


	/**
	 * Hide specifications on frontpage
	 * 
	 * Default is show all
	 * 
	 * @param array $aHideSpecs
	 * @return void
	 */
	public function hideSpecs($aHideSpecs) {
		$this->aHideSpecs = $aHideSpecs;
	}


	/**
	 * Set specification order
	 * 
	 * @param array $aSpecificationsOrder
	 * @return void
	 */
	public function setSpecificationOrder($aSpecificationsOrder) {
		$this->aSpecificationsOrder = $aSpecificationsOrder;
	}


	/**
	 * Determines whether the WordPress permalink structure ends with a trailing slash.
	 *
	 * @return boolean True if the permalink structure ends with a slash, false otherwise.
	 */
	private function has_trailing_slash() {
		$structure = get_option('permalink_structure');
		return (substr($structure, -1) === '/') ? true : false;
	}


	/**
	 * Build OVIS WordPress plugin settings HTML
	 * 
	 * @return string
	 */
	private function build_plugin_settings_html() {
		$sAuthKey = isset($this->sSessionData['sSettings']['settings']['authentication_key']) ? $this->sSessionData['sSettings']['settings']['authentication_key'] : '';
		$iItemsPerPage = isset($this->sSessionData['sSettings']['settings']['items_per_page']) ? $this->sSessionData['sSettings']['settings']['items_per_page'] : 12;
		$iItemsPerPageNoFilter = isset($this->sSessionData['sSettings']['settings']['items_per_page_no_filter']) ? $this->sSessionData['sSettings']['settings']['items_per_page_no_filter'] : 12;
		$iItemsPerRow = isset($this->sSessionData['sSettings']['settings']['items_per_row']) ? $this->sSessionData['sSettings']['settings']['items_per_row'] : 3;
		$sVideoPosition = isset($this->sSessionData['sSettings']['settings']['position_video_in_gallery']) ? $this->sSessionData['sSettings']['settings']['position_video_in_gallery'] : 'second';
		
		$sHtml = '<div id="ovis-settings-container" style="display:none;" 
			data-ovis-settings_items_per_page="'.$iItemsPerPage.'" 
			data-ovis-settings_items_per_page_no_filters="'.$iItemsPerPageNoFilter.'" 
			data-ovis-settings_items_per_row="'.$iItemsPerRow.'" 
			data-ovis-settings_video_position="'.htmlspecialchars($sVideoPosition).'" 
			data-ovis-settings_gen="'.substr(hash_hmac('sha256', htmlspecialchars($sAuthKey), 'isn-ovis-wp-plugin'), 0, 8).'"
			data-ovis-settings_trailing_slash="'.$this->has_trailing_slash().'">
		</div>';

		return $sHtml;
	}


	/**
	 * Build OVIS WordPress plugin shortcode parameter HTML
	 *
	 * @param string [$sPageType]
	 * @return string
	 */
	private function build_shortcode_param_html($sPageType='listing') {

		$type = strtolower(trim($sPageType));

		$aParameters = [
			'realm' => $this->sRealm,
			'languages' => !empty($this->aLanguages) ? implode(',', $this->aLanguages) : '',
		];
		
		if($type === 'detail') {
			$aParameters = array_merge($aParameters, array(
				'trade_in_images' => $this->sTradeInPictures
			));
		} else {
			$aParameters = array_merge($aParameters, [
				'categories' => $this->sCategory,
				'subcategories' => $this->sSubCategory,
				'keyword' => $this->sKeyword,
				'immediately_available' => $this->sShowAvailable,
				'condition' => $this->sCondition,
				'display_dealers_filter' => $this->bFilterUsers,
				'rental' => $this->bRentalActive,
				'cta' => is_array($this->sCallToAction) ? implode(',', $this->sCallToAction) : $this->sCallToAction,
				'hide_sold' => !$this->bShowSold ? 'yes' : 'no',
				'sold_at_end' => $this->bSoldAtEnd ? 'yes' : 'no',
				'status' => $this->sStatusFixed,
				'deeplink' => $this->sDeeplink,
				'specific_dealer' => $this->sDealer,
				'scroll_on_load' => $this->bScrollOnLoad,
				'brand' => $this->sBrandsFixed,
				'fuel' => $this->sFuelsFixed,
				'construction_year' => $this->oBouwjaar,
				'model_year' => $this->oModeljaar,
				'display_search_filters' => $this->sSearchFilters === false ? 0 : 1,
				'sort' => $this->sSearchSortingRaw,
				'anchor' => $this->sAnchor,
				'items_per_row' => $this->iPerRij,
				'expand_filters' => $this->bExpandSearch,
				'hide_filters' => implode(',', $this->aHideFilters),
				'specifications_order' => implode(',', $this->aSpecificationsOrder),
				'listing_layout' => $this->sLayout,
				'filter_layout' => $this->sFilterLayout,
				'listing_id' => get_the_ID(),
			]);
		}

		$sHtml = '<div id="ovis-shortcode-container" style="display:none;"';
		foreach($aParameters as $key => $value) {
			$sHtml .= ' data-ovis_' . htmlspecialchars($key) . '="' . htmlspecialchars($value) . '"';
		}
		$sHtml .= '></div>';

		return $sHtml;
	}


	/**
	 * Build OVIS WordPress plugin listing page HTML
	 *
	 * @return string
	 */
	private function build_listing_html() {
		ob_start(); ?>

			<div id="l-ovis-presentation-container">

				<?php if($this->sSearchFilters !== false) { ?>
					<div id="ovis-presentation-filter__applied-filters" style="display: none;">
						<div class="ovis-presentation-filter__applied-filter">
							<span class="ovis-presentation-filter__applied-filter__label" aria-hidden="true">Wis alle filters</span>
							<button class="ovis-presentation-filter__applied-filter__button js-ovis-translatable-title js-ovis-translatable-aria-label js-ovis-capitalize-text" 
								type="button" 
								rel="js-ovis-filter__reset-button" 
								title="Wis alle filters" 
								aria-label="Wis alle filters" 
								data-ovis-translation-key="Wis alle filters">
								<svg xmlns="http://www.w3.org/2000/svg" 
									class="ovis-presentation-filter__applied-filter__button-icon" 
									width="14px" 
									height="14px" 
									aria-hidden="true" 
									viewBox="0 -960 960 960" 
									fill="#5f6368">
									<path d="m256-200-56-56 224-224-224-224 56-56 224 224 224-224 56 56-224 224 224 224-56 56-224-224-224 224Z"/>
								</svg>
							</button>
						</div>
					</div>
					
					<div id="l-ovis-presentation-results-layout">

						<p id="ovis-presentations-loading-label">Resultaten worden opgehaald..</p>
						<p id="ovis-presentation-results"><span class="ovis-presentation__there-are-results">Er zijn</span> <span id="ovis-presentation-count"></span> <span class="ovis-presentation__results-found">resultaten gevonden</span></p>
						
						<div id="ovis-presentation-layout">
							
							<button aria-label="Gebruik lijstweergave" title="Gebruik lijstweergave" class="ovis-layout__button ovis-layout__button--list" data-ovis-layout="list">
								<svg fill="#000000" width="32px" height="32px" viewBox="0 0 256 256" id="Flat" xmlns="http://www.w3.org/2000/svg">
									<path d="M228,128.00037a12.00028,12.00028,0,0,1-12,12H40a12,12,0,0,1,0-24H216A12.00028,12.00028,0,0,1,228,128.00037Zm-188-52H216a12,12,0,0,0,0-24H40a12,12,0,1,0,0,24Zm176,104H40a12,12,0,0,0,0,24H216a12,12,0,0,0,0-24Z"/>
								</svg>
							</button>
							
							<button aria-label="Gebruik blokweergave" title="Gebruik blokweergave" class="ovis-layout__button ovis-layout__button--grid" data-ovis-layout="grid">
								<svg width="32px" height="32px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M3.5 3.5H10.5V10.5H3.5V3.5Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M3.5 13.5H10.5V20.5H3.5V13.5Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M13.5 3.5H20.5V10.5H13.5V3.5Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
									<path d="M13.5 13.5H20.5V20.5H13.5V13.5Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
								</svg>
							</button>

						</div>

					</div>


					<nav id="ovis-loading-pagination-wrapper" class="ovis-pagination">
						<ul class="ovis-pagination">
							<span class="ovis-pagination__item" style="visibility:hidden;">_</span>
						</ul>
					</nav>
				<?php } ?>

				<section id="ovis-presentation-container" class="<?php echo $this->sLayout; ?>">

					<section id="ovis-loading-wrapper">
						<?php for($index = 0; $index < 12; $index++) { ?>

							<div class="ovis-presentation ovis-presentation--loading ">
								
								<div class="ovis-presentation__title-container ovis-presentation__title-container--grid">
									<span class="ovis-presentation__title"></span>
									<span class="ovis-presentation__subtitle"></span>
								</div>

								<div class="l-ovis-presentation__img">
									<div class="ovis-presentation__img">

										<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
											viewBox="0 0 640 480" style="enable-background:new 0 0 640 480;" xml:space="preserve">
											<style type="text/css">
												.st0{fill:#EDEDED;}
											</style>
											<g>
												<path class="st0" d="M416.4,160.8H223.5c-1.9,0-3.4,1.5-3.4,3.4v151.6c0,1.9,1.6,3.4,3.4,3.4h193c1.9,0,3.4-1.5,3.4-3.4V164.2
													C419.9,162.3,418.4,160.8,416.4,160.8z M413,312.4H227V167.6h186V312.4z"/>
												<path class="st0" d="M275.1,237.1c10.6,0,19.2-8.6,19.2-19.2c0-10.6-8.6-19.2-19.2-19.2s-19.2,8.6-19.2,19.2
													C255.9,228.5,264.6,237.1,275.1,237.1z M275.1,205.6c6.8,0,12.3,5.5,12.3,12.3s-5.5,12.3-12.3,12.3s-12.3-5.5-12.3-12.3
													C262.9,211.1,268.4,205.6,275.1,205.6z"/>
												<path class="st0" d="M244.2,298.6c0.8,0,1.6-0.3,2.3-0.9l56.2-49.5l35.5,35.5c1.4,1.4,3.5,1.4,4.9,0s1.4-3.5,0-4.9l-16.6-16.6
													l31.6-34.6l38.8,35.6c1.4,1.3,3.6,1.2,4.9-0.2c1.3-1.4,1.2-3.6-0.2-4.9l-41.4-37.9c-0.6-0.6-1.6-0.9-2.5-0.9
													c-0.9,0.1-1.8,0.4-2.4,1.1l-33.8,36.9l-16.4-16.4c-1.3-1.3-3.4-1.4-4.7-0.1l-58.7,51.6c-1.4,1.3-1.6,3.4-0.3,4.9
													C242.2,298.2,243.2,298.6,244.2,298.6z"/>
											</g>
										</svg>
										
									</div>
								</div>

								<div class="ovis-presentation__details">
									<div class="ovis-presentation__specifications"></div>
									<div class="ovis-presentation__price">
										<span class="ovis-presentation__price__label"></span>
										<span class="ovis-presentation__price__value"></span>
									</div>
								</div>

							</div>
						<?php } ?>

					</section>

				</section>

				<div id="ovis-no-image-found-graphic" style="display:none;">

					<div data-ovis-image-placeholder="1" style="display:none;">
						<svg version="1.1" id="Capa_1" 
							xmlns="http://www.w3.org/2000/svg" 
							xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
							viewBox="0 0 640 480" style="enable-background:new 0 0 640 480;" 
							xml:space="preserve">
							<style type="text/css">
								.st0{fill:#EDEDED;}
							</style>
							<g>
								<path class="st0" d="M416.4,160.8H223.5c-1.9,0-3.4,1.5-3.4,3.4v151.6c0,1.9,1.6,3.4,3.4,3.4h193c1.9,0,3.4-1.5,3.4-3.4V164.2
									C419.9,162.3,418.4,160.8,416.4,160.8z M413,312.4H227V167.6h186V312.4z"/>
								<path class="st0" d="M275.1,237.1c10.6,0,19.2-8.6,19.2-19.2c0-10.6-8.6-19.2-19.2-19.2s-19.2,8.6-19.2,19.2
									C255.9,228.5,264.6,237.1,275.1,237.1z M275.1,205.6c6.8,0,12.3,5.5,12.3,12.3s-5.5,12.3-12.3,12.3s-12.3-5.5-12.3-12.3
									C262.9,211.1,268.4,205.6,275.1,205.6z"/>
								<path class="st0" d="M244.2,298.6c0.8,0,1.6-0.3,2.3-0.9l56.2-49.5l35.5,35.5c1.4,1.4,3.5,1.4,4.9,0s1.4-3.5,0-4.9l-16.6-16.6
									l31.6-34.6l38.8,35.6c1.4,1.3,3.6,1.2,4.9-0.2c1.3-1.4,1.2-3.6-0.2-4.9l-41.4-37.9c-0.6-0.6-1.6-0.9-2.5-0.9
									c-0.9,0.1-1.8,0.4-2.4,1.1l-33.8,36.9l-16.4-16.4c-1.3-1.3-3.4-1.4-4.7-0.1l-58.7,51.6c-1.4,1.3-1.6,3.4-0.3,4.9
									C242.2,298.2,243.2,298.6,244.2,298.6z"/>
							</g>
						</svg>
					</div>
					
					<div data-ovis-image-placeholder="2" style="display:none;">
						<svg version="1.1" id="Layer_1" 
							xmlns="http://www.w3.org/2000/svg" 
							xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" 
							viewBox="0 0 500 375" style="enable-background:new 0 0 500 375;" 
							xml:space="preserve">
							<g>
								<path d="M386.3,151.3c-1.1,6-1.6,12.2-3.3,18c-10.7,36.3-34.5,59.2-71.4,67.5c-24.3,5.5-47.3,1-68.7-12c-0.4-0.2-0.8-0.4-1.2-0.6c-0.1-0.1-0.3-0.1-0.8-0.2c-5.9,5.9-11.9,11.9-17.8,18c-0.5,0.5-0.7,1.6-0.7,2.4c-0.5,6.6-2.7,12.5-7.4,17.2c-18.1,18.2-36.2,36.5-54.6,54.5c-10.8,10.6-28,10-38.6-0.6c-10.5-10.6-11-27.6-0.4-38.4c18-18.4,36.3-36.5,54.5-54.6c4.7-4.7,10.6-6.9,17.2-7.4c0.8-0.1,1.9-0.2,2.4-0.7c6.1-5.9,12.1-11.9,17.7-17.4c-3.3-7.5-7-14.3-9.5-21.6c-18.4-53,14.3-110.6,69.2-122c4.2-0.9,8.5-1.4,12.8-2.1c4.4,0,8.9,0,13.3,0c4.4,0.7,9,1.1,13.3,2.2c37.6,9.4,61.5,32.8,71.3,70.2c1.3,4.8,1.8,9.9,2.6,14.8C386.3,142.8,386.3,147.1,386.3,151.3z M369.2,145.2c0-42.4-34.4-76.8-76.7-76.9c-42.5,0-77,34.5-77,76.9c0,42.3,34.6,76.8,76.9,76.8C334.8,222,369.2,187.6,369.2,145.2z M196.3,232.2c-4.8-0.1-7.5,1.4-9.9,3.8c-17.3,17.3-34.6,34.6-51.9,51.9c-0.5,0.5-1,1-1.4,1.6c-4.7,6.2-1.7,15,5.9,16.9c4.2,1.1,7.7-0.3,10.6-3.3c17.4-17.4,34.9-34.8,52.3-52.3c0.7-0.7,1.4-1.6,2-2.5C208.1,241.3,203.1,232.3,196.3,232.2z M224.6,210.1c-4.1,4-7.9,7.8-11.5,11.4c0.9,1,1.8,2.1,2.7,3c3.8-3.8,7.6-7.7,11.4-11.5C226.4,212.2,225.5,211.1,224.6,210.1z"/><path d="M292.5,156.9c-6,6-11.5,11.7-17.1,17.2c-2.8,2.7-6.8,3.2-10.1,1.4c-3.3-1.8-5.1-5.5-4.1-9.2c0.5-1.8,1.6-3.5,2.9-4.9c5.1-5.4,10.5-10.6,15.7-15.9c0.1-0.1,0.1-0.1,0.7-0.8c-1.1-0.9-2.4-1.8-3.4-2.8c-4.5-4.4-8.9-8.9-13.3-13.3c-3.8-3.8-3.8-9.1-0.3-12.5s8.5-3.2,12.3,0.5c5.5,5.4,10.9,10.9,16.5,16.5c4.7-4.7,9.2-9.2,13.7-13.7c1.1-1.1,2.1-2.2,3.2-3.2c3.7-3.4,8.8-3.4,12.1,0c3.3,3.4,3.3,8.4-0.1,11.9c-4.9,5-9.9,9.9-14.8,14.9c-0.6,0.6-1.2,1.3-2,2.1c4.2,4.2,8.3,8.3,12.4,12.4c1.5,1.5,3.1,3,4.5,4.5c3.3,3.6,3.2,8.6-0.1,11.9c-3.3,3.2-8.5,3.3-12-0.1c-5-4.8-9.8-9.7-14.7-14.6C294,158.7,293.4,157.9,292.5,156.9z"/>
							</g>
						</svg>
					</div>

				</div>

			</div>
		<?php
		$sHtml = ob_get_clean();
		return $sHtml;
	}


	/**
	 * Initialize authentication key & token in SESSION
	 *
	 * @param string $sAuthKey
	 * @return string
	 */
	private function init_auth($sAuthKey) {

		if(empty($sAuthKey)) return '';

		if( session_status() !== PHP_SESSION_ACTIVE ) {
			session_start();
		}

		if( empty( $_SESSION['ovis_csrf_token'] ) ) {
			$_SESSION['ovis_csrf_token'] = bin2hex(random_bytes(32));
		}

		$_SESSION['ovis_authentication_key'] = $sAuthKey;

		return $_SESSION['ovis_csrf_token'];
	}


	/**
	 * Build output
	 * 
	 * @return string
	 */
	public function build_output() {
		
		global $wp_session;
		
		$sUniqueID = false;

		/**
		 * Retrieve & store session data
		 */
		$this->sSessionData = !empty($wp_session['session_data']) ? $wp_session['session_data'] : false;
		$oSessionSettings = $wp_session['session_data']['sSettings']['settings'];

		$sOvisCsrfToken = $this->init_auth(isset($oSessionSettings['authentication_key']) ? $oSessionSettings['authentication_key'] : '');

		if(empty($this->iPerRij)) {
			$this->iPerRij = isset($oSessionSettings['items_per_row_default']) ? $oSessionSettings['items_per_row_default'] : self::ITEMS_PER_ROW_DEFAULT;
		}
		// Enforce valid range (floor and cap)
		$this->iPerRij = max(self::ITEMS_PER_ROW_MIN, min((int) $this->iPerRij, self::ITEMS_PER_ROW_MAX));

		
		/**
		 * ? what
		 */
		if($this->sCategory != 'minimal') {			
			$hCategory = md5(serialize($this->sCategory));			
			$hSubcategory = md5(serialize($this->sSubCategory));			
			$hCondition = md5(serialize($this->sCondition));			
			$hModule = md5(serialize($this->sRealm));			
			$hRental = md5(serialize($this->bRentalActive));			
			$hScrollonload = md5(serialize($this->bScrollOnLoad));			
			$hSearchFilters = md5(serialize($this->sSearchFilters));			
			$hShowCalendar = md5(serialize($this->bShowCalendar));			
			$hSorting = md5(serialize($this->bSearchSorting));			
			$hShowSold = md5(serialize($this->bShowSold));			
			$hBrands = md5(serialize($this->sBrandsFixed));			
			$hFuels = md5(serialize($this->sFuelsFixed));			
			$hStatus = md5(serialize($this->sStatusFixed));			
			$hDealer = md5(serialize($this->sDealer));						
			$hPerrij = md5(serialize($this->iPerRij));			
			$hShop = md5(serialize($this->sShowShop));			
			$hAvailable = md5(serialize($this->sShowAvailable));			
			$hKeyword = md5(serialize($this->sKeywordFixed));			
			$sUniqueID = md5($hCategory.$hSubcategory.$hCondition.$hRental.$hScrollonload.$hSearchFilters.$hShowCalendar.$hSorting.$hShowSold.$hBrands.$hFuels.$hDealer.$hPerrij.$hShop.$hAvailable.$hKeyword);
			$this->sUniqueID = $sUniqueID;
		}

		$sActiveTaal = !empty($this->sSessionData['ovisSearchData'][$this->sUniqueID]->languageField) ? $this->sSessionData['ovisSearchData'][$this->sUniqueID]->languageField : $this->aLanguages[0];
		if($sActiveTaal == 'system'){
			$sWPLanguage = get_locale();
			if(!empty($sWPLanguage)){
				$sActiveTaal = $sWPLanguage;
			}
		}
		$this->sLanguage = getOVISTranslation($sActiveTaal);

		if($this->sCategory == 'minimal') {
			$this->sCategory = false;
		}

		/**
		 * Retrieve & store page name
		 */
		$ovisUrlPageName = get_query_var('pagename');

		$ovisUrlPageNumber = false;

		if( get_query_var( 'paged' ) ) {
			$ovisUrlPageNumber = get_query_var( 'paged' );
		}
		elseif( get_query_var( 'page' ) ) {
			$ovisUrlPageNumber = get_query_var( 'page' );
		} 
		elseif(get_query_var( 'caravan_slug' ) == 'page' && is_numeric(get_query_var( 'caravan_id' ))) {
			$ovisUrlPageNumber = get_query_var( 'caravan_id' );
		}

		/**
		 * Retrieve & store the selected OVIS category
		 */
		$ovisUrlCategory = get_query_var('ovis_category');
		
		/**
		 * Retrieve & store the selected OVIS presentation ID
		 */
		$ovisUrlObjectId = get_query_var('ovis_object_id');

		$iPageNumber = 1;

		$this->iPerRijWord = array_key_exists($this->iPerRij, $this->aNumberToWords) ? $this->aNumberToWords[$this->iPerRij] : 'three';

		if(empty($ovisUrlCategory) && empty($ovisUrlObjectId)) {
			if(isset($ovisUrlPageNumber) && is_numeric($ovisUrlPageNumber) && $ovisUrlPageNumber > 0) {
				$iPageNumber = (int)$ovisUrlPageNumber;
			}
		}
		
		$this->iPageNumber = $iPageNumber;
		
		$oData = new data($this->sSessionData['sSettings'], false, $iPageNumber, $this->sCategory, $this->sSubCategory, $this->sCondition, $this->bRentalActive, $ovisUrlObjectId, $sUniqueID, $this->sDealer, $this->sRealm);

		$bExpandedForm = $this->sShowExtraFilters == 'open' ? 1 : 0;
		$setStyle 	 = 'style="display: none;"';
		$setIcon  	 = 'plus';
		
		if($bExpandedForm == 1 || !empty($this->bExpandSearch)) {
			$bExpandedForm = 1;
			$setStyle = 'style="display: grid;"';
			$setIcon  = 'minus';
		}
		
		$aAvailableCats = explode(',', str_replace(' ', '', $oData->aObjectCategory));
		
		$sPermalink = get_permalink();
		$aPermalink = isset($_GET) ? $_GET : [];
		$sQueryString = '';
		
		if (!empty($aPermalink)) {
			$queryArray = [];
			foreach ($aPermalink as $key => $value) {
				$queryArray[] = urlencode($key) . '=' . urlencode($value);
			}
			$sQueryString = '?' . implode('&', $queryArray);
		}
		
		$sAnchor = '';
		if (!empty($this->sAnchor)) {
			$sAnchor = '#' . $this->sAnchor;
		} elseif (!empty($this->sSessionData['sSettings']['settings']['anchor'])) {
			$sAnchor = '#' . $this->sSessionData['sSettings']['settings']['anchor'];
		}
		
		$sNewPermalink = $sPermalink . $sQueryString . $sAnchor;
		
		$languageShort = substr($this->sLanguage, 0, 2);

		$sHTML = '';

		if(!empty($oData->aObjectSettings['settings']['mysql_error'])) {
			return mysqli_query_error_notice();
		} 
		elseif($this->sCategory == 'invalid') {
			$sHTML = '<p>'.$this->getSingleTranslation('ongeldige_categorie').'</p>';
			return $sHTML;
		} 
		else {
			$oData->bShowSearchForm = !$this->sSearchFilters ? false : true;
			$oData->bSearchSorting = $this->bSearchSorting;
			$oData->sShowSold = $this->bShowSold;
			$oData->sBrandsFixed = $this->sBrandsFixed;
			$oData->sFuelsFixed = $this->sFuelsFixed;
			$oData->sKeywordFixed = $this->sKeywordFixed;
			$oData->sBuildYearFixed = $this->oBouwjaar;
			$oData->sModelYearFixed = $this->oModeljaar;
			$oData->sAvailableItems = $this->sShowAvailable;
			$oData->sStatusFixed = $this->sStatusFixed;


			/**
			 * Check for set OVIS category & presentation ID
			 * 
			 * If this is set output should be presentation details
			 * If this is not set output should be the presentations listing
			 */
			if(empty($ovisUrlCategory) && empty($ovisUrlObjectId)) {

				ob_start(); ?>

					<!-- Plugin: <?php echo OVIS_PLUGIN_NAME; ?> - <?php echo OVIS_VERSION; ?> - <?php echo OVIS_RELEASE; ?> -->
					<div id="ovis-container" 
						class="<?php echo ($this->sSearchFilters ? ' has-filters' : ' no-filters') . (!empty($this->bScrollOnLoad) && !empty($oData->bUserSearched) ? ' scrollOnLoad"' : false); ?> <?php echo $this->sFilterLayout === 'side' ? 'valid-side-filters-layout' : ''; ?>" 
						data-filter-layout="<?php echo $this->sFilterLayout; ?>" 
						data-listing-per-row="<?php echo $this->iPerRij; ?>" 
						data-ajax-uri="<?php echo admin_url('admin-ajax.php'); ?>">

						<?php echo $this->build_plugin_settings_html(); ?>

						<?php echo $this->build_shortcode_param_html('listing'); ?>

						<div id="ovis-notification-wrapper" style="display:none;"></div>

						<script>
							<?php if($languageShort == 'en') { ?>
								var ovisdaynames = ['Su','Mu','Tu','We','Th','Fr','Sa'];
								var ovismonthnames = ['January','February','March','April','May','June','July','August','September','October','November','December'];
								var ovismonthnamesshort = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
							<?php } elseif($languageShort == 'de') { ?>
								var ovisdaynames = ['So','Mo','Di','Mi','Do','Fr','Sa'];
								var ovismonthnames = ['Januar','Februar','M&auml;rz','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember'];
								var ovismonthnamesshort = ['Jan','Feb','M&auml;r','Apr','Mai','Jun','Jul','Aug','Sep','Okt','Nov','Dez'];
							<?php } elseif($languageShort == 'fr') { ?>
								var ovisdaynames = ['Di','Lu','Ma','Me','Je','Ve','Sa'];
								var ovismonthnames = ['Janvier','F&eacute;vrier','Mars','Avril','Mai','Juin','Julliet','Ao&ocirc;t','septembre','Octobre','Novembre','D&eacute;cembre'];
								var ovismonthnamesshort = ['Jan','Feb','Maa','Apr','Mei','Jun','Jul','Aug','Sep','Okt','Nov','Dec'];
							<?php } else { ?>
								var ovisdaynames = ['Zo','Ma','Di','Wo','Do','Vr','Za'];
								var ovismonthnames = ['Januari','Februari','Maart','April','Mei','Juni','Juli','Augustus','September','Oktober','November','December'];
								var ovismonthnamesshort = ['Jan','Feb','Maa','Apr','Mei','Jun','Jul','Aug','Sep','Okt','Nov','Dec'];
							<?php } ?>
						</script>

						<input type="hidden" name="ovis_search_nonce" id="ovis_search_nonce" value="<?php echo $sOvisCsrfToken; ?>" />

						<?php if($this->sSearchFilters !== false) { ?>
							<form id="ovis-search" class="ovis-search" method="post" action="<?php echo $sNewPermalink; ?>" autocomplete="off">
								<input type="hidden" name="ovis-used-search" id="ovis-used-search" value="search" />
								<input type="hidden" name="ovis-clear-all-search" id="ovis-clear-all-search" value="no" />
								<input type="hidden" name="ovis-clear-secondary-search" id="ovis-clear-secondary-search" value="no" />
								<input type="hidden" name="ovis-order-direction" id="ovis-order-direction" value="no" />
								<input type="hidden" name="ovis-user" id="ovis-user" value="" />
								<input type="hidden" name="ovis-username" id="ovis-username" value="<?php echo (!empty($oData->oObjectFilters->ovisUsername) ? $oData->oObjectFilters->ovisUsername : false); ?>" />
								<input type="hidden" name="ovis-language" id="ovis-language" value="<?php echo $this->sLanguage; ?>" />
								
								<section id="ovis-filter-loading-wrapper">
									<?php for($index = 0; $index < 8; $index++) { ?>
										<div class="contain-filter">
											<div class="contain-filter__placeholder"></div>
										</div>
									<?php } ?>
								</section>

								<div id="ovis-filters-main-wrapper" class="contain-filters main" style="display:none;">

									<?php if(!in_array('dealer', $this->aHideFilters)) { ?>
										<?php if(empty($this->sDealer) && !empty($this->bFilterUsers)) { ?>

											<!-- Dealer -->
											<div class="contain-filter">
												<select name="provider" id="provider" class="provider">
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>


									<?php if(!in_array('categorie', $this->aHideFilters)) { ?>
										<?php if(!empty($this->sCategory) && count(explode(',', $this->sCategory)) > 1) { ?>

											<!-- Category -->
											<div class="contain-filter">
												<select name="category" id="category" class="category">
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>


									<?php if(!in_array('conditie', $this->aHideFilters)) { ?>
										<?php if($this->sShowConditionNewOrOccasion == 'all') { ?>
											<?php if(empty($this->bRentalActive)) { ?>
											
											<!-- Condition -->
												<div class="contain-filter">
													<select name="condition" id="condition" class="condition">
														<option value=""></option>
													</select>
												</div>
											<?php } ?>
										<?php } ?>
									<?php } ?>


									<?php if(!in_array('merk', $this->aHideFilters)) { ?>
										<?php if(empty($this->sBrandsFixed) || !empty($this->sBrandsFixed) && count(explode(',', mb_strtolower($this->sBrandsFixed, 'UTF-8'))) > 1) { ?>

											<!-- Brand -->
											<div class="contain-filter" id="brand-group" style="position:relative;">
												<select name="brand[]" id="brand" class="brand multipleselection brandmultiple" multiple>
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>


									<?php if(!in_array('model', $this->aHideFilters)) { ?>

										<!-- Model / Type -->
										<div class="contain-filter">
											<input type="text" name="model_type_version" 
												id="model_type_version" class="modelTypeVersion" 
												value="" />
										</div>
									<?php } ?>


									<?php if(!in_array('trefwoord', $this->aHideFilters)) { ?>
										<?php if(empty($this->sKeywordFixed)) { ?>

											<!-- Keyword -->
											<div class="contain-filter">
												<input type="text" name="keyword" id="keyword" class="keyword" value="" />
											</div>
											<?php } ?>
									<?php } ?>


									<?php if(!in_array('subcategorie', $this->aHideFilters)) { ?>
										<?php if(empty($this->sSubCategory)) { ?>

											<!-- Subcategory -->
											<div class="contain-filter" id="subcategory-group" style="position:relative;">
												<select name="sub_category_trailer[]" id="sub_category_trailer" class="sub_category_trailer multipleselection subCategoryMultiple" multiple>
													<option value=""></option>
												</select>
											</div>
											<?php } ?>
									<?php } ?>


									<?php if(!in_array('datum', $this->aHideFilters)) { ?>
										<?php if(!empty($this->bRentalActive) && !empty($this->bShowCalendar)) { ?>

											<!-- Rental dates -->
											<div class="contain-filter">
												<input type="text" name="rental_date_from" id="rental_date_from" class="rentalDateFrom" placeholder="Datum van" />
											</div>
											<div class="contain-filter">
												<input type="text" name="rental_date_to" id="rental_date_to" class="rentalDateTo" placeholder="Datum tot" />
											</div>
										<?php } ?>
									<?php } ?>

									
									<?php if(!in_array('type', $this->aHideFilters)) { ?>
										<?php if(empty($this->sSubCategory)) { ?>

											<!-- Type -->
											<div class="contain-filter" id="subcategory-group" style="position:relative;">
												<select name="subcategory[]" id="subcategory" class="subCategory multipleselection subCategoryMultiple" multiple>
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>

									
									<?php if(!in_array('indeling', $this->aHideFilters)) { ?>
										<?php if(!empty($this->sCategory) && array_intersect(['camper', 'caravan'], explode(',', $this->sCategory))) { ?>

											<!-- Division -->
											<div class="contain-filter" id="division-group" style="position:relative;">
												<select name="division[]" id="division" class="division multipleselection" multiple>
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>


									<?php if($this->sRealm == 'boten') { ?>
										
										<!-- Boat: Fast sailing -->
										<div class="contain-filter">
											<select name="fastsailing" id="fastsailing" class="fastsailing">
												<option value=""></option>
											</select>
										</div>
									<?php } ?>


									<?php if(!in_array('transmissie', $this->aHideFilters)) { ?>
										<?php if(!empty($this->sCategory) && in_array('camper', explode(',', $this->sCategory))) { ?>

											<!-- Transmission -->
											<div class="contain-filter">
												<select name="transmission" id="transmission" class="transmission">
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>

									
									<?php if(!in_array('brandstof', $this->aHideFilters)) { ?>
										<?php if(!empty($this->sCategory) && array_intersect(array('camper', 'engine'), explode(',', $this->sCategory))) { ?>
											<?php if(empty($this->sFuelsFixed) || !empty($this->sFuelsFixed) && count(explode(',', mb_strtolower($this->sFuelsFixed, 'UTF-8'))) > 1) { ?>

												<!-- Fuel -->
												<div class="contain-filter" id="fuel-group" style="position:relative;">
													<select name="fuel[]" id="fuel" class="fuel multipleselection fuelmultiple" multiple>
														<option value=""></option>
													</select>
												</div>
											<?php } ?>
										<?php } ?>
									<?php } ?>


									<?php if(!in_array('euroklasse', $this->aHideFilters)) { ?>
										<?php if(!empty($this->sCategory) && in_array('camper', explode(',', $this->sCategory))) { ?>

											<!-- Euroclass -->
											<div class="contain-filter" id="euroclass-group" style="position:relative;">
												<select name="euroclass[]" id="euroclass" class="euroclass multipleselection euroclassmultiple" multiple>
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>

								</div>


								<div id="ovis-filters-expanded-wrapper" 
									class="contain-filters filtershidden" 
									aria-expanded="false" 
									data-ovis-expanded="<?php echo $bExpandedForm; ?>" 
									<?php echo $setStyle; ?>>

									<?php //if(empty($this->sShowPrices)) { ?>
										<?php //if(!empty($this->bRentalActive)) { ?>


											<!-- Price -->
											<div class="contain-filter">
												<label>Prijs</label>
												<select name="price_from" id="price_from" class="price_from">
													<option value=""></option>
												</select>
												<select name="price_to" id="price_to" class="price_to">
													<option value=""></option>
												</select>
											</div>
										<?php //} ?>
									<?php //} ?>


									<?php if(empty($this->oBouwjaar)) { ?>

										<!-- Construction year -->
										<div class="contain-filter">
											<label>Bouwjaar</label>
											<select name="construction_from" id="construction_from" class="construction_from">
												<option value=""></option>
											</select>
											<select name="construction_to" id="construction_to" class="construction_to">
												<option value=""></option>
											</select>
										</div>
									<?php } ?>


									<?php if($this->sRealm == 'boten') { ?>

										<!-- Power -->
										<div class="contain-filter">
											<label>Vermogen</label>
											<select name="power_from" id="power_from" class="power_from">
												<option value=""></option>
											</select>
											<select name="power_to" id="power_to" class="power_to">
												<option value=""></option>
											</select>
										</div>

										<!-- Length -->
										<div class="contain-filter">
											<label>Lengte</label>
											<select name="length_from" id="length_from" class="length_from">
												<option value=""></option>
											</select>
											<select name="length_to" id="length_to" class="length_to">
												<option value=""></option>
											</select>
										</div>
									<?php } ?>


									<?php if($this->sRealm == 'ovis') { ?>

										<!-- Max weight -->
										<div class="contain-filter">
											<label>Max. toelaatbaar gewicht</label>
											<select name="maxweight_from" id="maxweight_from" class="maxweight_from">
												<option value=""></option>
											</select>
											<select name="maxweight_to" id="maxweight_to" class="maxweight_to">
												<option value=""></option>
											</select>
										</div>


										<?php if(!empty($this->sCategory) && array_intersect(['camper', 'caravan'], explode(',', $this->sCategory))) { ?>

											<!-- Mileage -->
											<div class="contain-filter">
												<label>Kilometerstand</label>
												<select name="mileage_from" id="mileage_from" class="mileage_from">
													<option value=""></option>
												</select>
												<select name="mileage_to" id="mileage_to" class="mileage_to">
													<option value=""></option>
												</select>
											</div>
										<?php } ?>


										<?php if(!empty($this->sCategory) && in_array('camper', explode(',', $this->sCategory))) { ?>

											<!-- Seatbelts -->
											<div class="contain-filter">
												<label>Gordelzitplaatsen</label>
												<select name="seatbelts_from" id="seatbelts_from" class="seatbelts_from">
													<option value=""></option>
												</select>
												<select name="seatbelts_to" id="seatbelts_to" class="seatbelts_to">
													<option value=""></option>
												</select>
											</div>
										<?php } ?>


										<?php if(!array_key_exists('trailer', explode(',', $this->sCategory))) { ?>

											<!-- Sleeping places -->
											<div class="contain-filter">
												<label>Slaapplaatsen</label>
												<select name="sleepingplaces_from" id="sleepingplaces_from" class="sleepingplaces_from">
													<option value=""></option>
												</select>
												<select name="sleepingplaces_to" id="sleepingplaces_to" class="sleepingplaces_to">
													<option value=""></option>
												</select>
											</div>
										<?php } ?>
									<?php } ?>

								</div>


								<div class="contain-buttons">

									<div class="found-container"></div>

									<div class="sorting-container">

										<button type="button" 
											id="ovis-expand-form-button" 
											class="moreFilters" 
											aria-expanded="false" 
											aria-controls="ovis-filters-expanded-wrapper" 
											data-uniqueid="<?php echo $this->sUniqueID; ?>">
											<svg xmlns="http://www.w3.org/2000/svg" 
												width="20px" 
												height="20px" 
												class="ovis-expand-form-button__icon ovis-expand-form-button__icon--plus" 
												aria-hidden="true" 
												viewBox="0 -960 960 960" 
												fill="#1f1f1f">
												<path d="M440-440H200v-80h240v-240h80v240h240v80H520v240h-80v-240Z"/>
											</svg>
											<svg xmlns="http://www.w3.org/2000/svg" 
												width="20px" 
												height="20px" 
												class="ovis-expand-form-button__icon ovis-expand-form-button__icon--minus" 
												aria-hidden="true" 
												style="display:none;" 
												viewBox="0 -960 960 960" 
												fill="#1f1f1f">
												<path d="M200-440v-80h560v80H200Z"/>
											</svg>
											<span class="ovis-expand-form-button__label">Uitgebreid zoeken</span>
										</button>

										<div class="ovis-sort">
											<select name="ovis-sort-field" id="ovis-sort-field">
												<option value="brand_up">Merk (A-Z)</option>
											</select>
										</div>

										<?php echo $this->build_language_picker_html('listing'); ?>

									</div>

								</div>

							</form>
						<?php } ?>

						<?php echo $this->build_listing_html(); ?>

					</div>
				<?php
				$sHTML = ob_get_clean();
			} 
			else {
				$oData->search_activead();
				$oData->getTranslations();

				if(!empty($wp_session['session_data']['ovis-language'])) {
					$this->sLanguage = getOVISTranslation($wp_session['session_data']['ovis-language']);
				}
				if(!empty($oData->aTranslations->data->languages)) {
					if(!empty($oData->aTranslations->data->languages->{$this->sLanguage}) && !empty($oData->bAllowTranslations)) {
						$this->aLanguageConfig = (array)$oData->aTranslations->data->languages->{$this->sLanguage};
					} else {
						$this->aLanguageConfig = (array)$oData->aTranslations->data->languages->nl_NL;
					}
				}

				/**
				 * Output the presentation details
				 */
				$sHTML = $this->output_object($oData, $ovisUrlPageName, $sOvisCsrfToken);
			}
		}

		return $sHTML;
	}


	/**
	 * Generates language picker HTML
	 * 
	 * @param string [$sPageType]
	 * @return string
	 */
	private function build_language_picker_html($sPageType='listing') {
		
		if(count($this->aLanguages) < 2) {
			return '';
		}

		$type = strtolower(trim($sPageType));
		$isDetailPage = ($type === 'detail');

		$sClassList = $isDetailPage ? 'ovis-language-picker--detail' : 'ovis-language-picker--listing';

		ob_start(); ?>
			<div id="ovis-language-picker" class="<?php echo $sClassList; ?>" style="display:none;">
				<?php
					foreach($this->aLanguages as $sLanguage) {
						$isActive = substr($this->sLanguage, 0, 2) == $sLanguage;
						$sClass = $sLanguage . ($isActive ? ' active' : ' inactive');
						?>
						<button type="button" class="ovis-language-button <?php echo $sClass; ?>" data-ovis-language="<?php echo $sLanguage; ?>"></button>
				<?php } ?>
			</div>
		<?php
		return ob_get_clean();
	}


	/**
	 * Generates text links HTML
	 *
	 * @param object $oData
	 * @param object $oUserData
	 * @return string
	 */
	private function build_detail_links_html($oData, $oUserData) {
		
		if(!empty($oData->specifications->rental)) {
			return '';
		}

		$oUserSettings = isset($oUserData->userSettings) ? $oUserData->userSettings : null;
		$oBanners = isset($oData->banners) ? $oData->banners : null;

		if(empty($oUserSettings) || empty($oBanners)) {
			return '';
		}

		$sKampeerKredietLink = !empty($oUserSettings->kampeerkrediet->textLink) && !empty($oBanners->kampeerkrediet) ? $oBanners->kampeerkrediet : null;
		$sFinanplazaLink = !empty($oUserSettings->finanplaza->textLink) && !empty($oBanners->finanplaza) ? $oBanners->finanplaza : null;
		$sAvekoLink = !empty($oUserSettings->aveko->textLink) && !empty($oBanners->aveko->url) ? $oBanners->aveko->url : null;
		$sHtml = '';
		
		if($sKampeerKredietLink) {
			$sHtml .= '<div class="ovis-row">
				<div class="priceTo"><a href="'.$sKampeerKredietLink.'" target="_blank"><span data-ovis-translation-key="Bereken hier uw maandtermijn" class="js-ovis-translatable-text">Bereken hier uw maandtermijn</span></a></div>
			</div>';
		}

		if($sFinanplazaLink) {
			$sLinkLabel = 'Klik hier voor het geadviseerd maandbedrag';
			$sHtml .= '<div class="ovis-row textLinks"><a href="'.$sFinanplazaLink.'" target="_blank"><span data-ovis-translation-key="'.$sLinkLabel.'" class="js-ovis-translatable-text">'.$sLinkLabel.'</span>'.' '.'<span data-ovis-translation-key="'.$oData->specifications->category.'" class="js-ovis-translatable-text js-ovis-lowercase-text">'.$oData->specifications->category.'</span></a></div>';
		}
		
		if($sAvekoLink) {
			$sHtml .= '<div class="ovis-row textLinks">
				<a href="'.$sAvekoLink.'" target="_blank"><span data-ovis-translation-key="Verzeker uw" class="js-ovis-translatable-text">Verzeker uw</span> '.(!empty($oData->specifications->category) ? strtolower($this->translate_category($oData->specifications->category)) : $this->getSingleTranslation('kampeermiddel')).' '.$this->getSingleTranslation('bij').' Aveco Verzekeringen</a>
			</div>';
		}

		return $sHtml;
	}


	private function getSingleTranslation($translationKey=false) {
		
		if(empty($translationKey)) {
			return false;
		}
		
		$sOriginalKey = $translationKey;
		$translationKey = sha1(strtolower(str_replace(array(' ', '/'), array('_', '_'), trim($translationKey))));

		return isset($this->aLanguageConfig[$translationKey]) ? stripcslashes($this->aLanguageConfig[$translationKey]) : $sOriginalKey;
	}


	/**
	 * Output single OVIS presentation
	 * 
	 * @param object $oData
	 * @param $ovisUrlPageName
	 * @param string $sOvisCsrfToken
	 */
	private function output_object($oData, $ovisUrlPageName, $sOvisCsrfToken) {

		$oResponseObject					= isset($oData->oObjectData->data) ? $oData->oObjectData->data : new stdClass();
		$oPresentation 						= isset($oResponseObject->data[0]->presentation)			? $oResponseObject->data[0]->presentation : new stdClass();
		$oUser 								= !empty($oResponseObject->data[0]->user)					? $oResponseObject->data[0]->user : false;

		$id									= !empty($oPresentation->id) ? $oPresentation->id : 0;

		$this->sPageName	 				= !empty($ovisUrlPageName) 									? $ovisUrlPageName : false;
		$this->bHasTradeInProposalEnabled	= !empty($oUser->userSettings->tradeInProposal->enabled) 	? true : false;
		
		$this->bHasEmail 					= !empty($oUser->email) 									? true : false;
		$this->sPhoneNumber 				= !empty($oUser->cellPhone) 								? $oUser->cellPhone : '';
		$this->sCompanyName					= !empty($oUser->companyName) 								? $oUser->companyName : '';
		$this->sUserCity 					= !empty($oUser->city) 										? $oUser->city : false;

		$oPresentation->clientUserCount 	= !empty($oResponseObject->clientUserCount) 				? $oResponseObject->clientUserCount : 0;
		$oMediaInfo							= isset($oPresentation->mediainfo) 							? $oPresentation->mediainfo : null;
		$oImages 							= isset($oPresentation->mediainfo->images) 					? $oPresentation->mediainfo->images : false;
		$oSpecs 							= isset($oPresentation->specifications) 					? $oPresentation->specifications : null;

		$category 	 						= !empty($oSpecs->category) 								? ucfirst($oSpecs->category) : false;
		$brand 	 							= !empty($oSpecs->brand) 									? ucfirst($oSpecs->brand) : false;
		$model								= !empty($oSpecs->modelDisplay) 							? ucfirst($oSpecs->modelDisplay) : false;
		$version							= !empty($oSpecs->version) 									? strtoupper($oSpecs->version) : false;
		$title		 						= !empty($oSpecs->titleManual) 								? ' ' . ucfirst($oSpecs->titleManual) : (!empty($oSpecs->title) ? ' ' . ucfirst($oSpecs->title) : false);
		$titleSuffix 						= !empty($oSpecs->titleSuffix) 								? ' '.ucfirst($oSpecs->titleSuffix) : false;
		
		$bHas360Media 						= !$oMediaInfo || !$oMediaInfo->{360} || !$oMediaInfo->{360}->enabled 	? false : true;
		$bHasVideoMedia 					= !$oMediaInfo || !$oMediaInfo->taGGleVideo 							? false : true;
		$mediaYoutube 						= false;

		if(!empty($this->aLanguageConfig['titlesuffix'])) {
			$titleSuffix = ucfirst($this->aLanguageConfig['titlesuffix']);
			$title =  $brand . ' ' . $model . ' ' . $version . ' ' . $titleSuffix;
		}

		/* Warranty */
		$oWarranty				= isset($oSpecs->warranty) ? $oSpecs->warranty : null;
		$bovag 					= !empty($oWarranty->bovag) ? $oWarranty->bovag : false;
		$bovagEndDate 			= !empty($oWarranty->bovagEndDate) ? $oWarranty->bovagEndDate : false;
		$bovagMonths 			= !empty($oWarranty->bovagMonths) ? $oWarranty->bovagMonths : false;
		$bovagDescription 		= !empty($oWarranty->bovagDescription) ? nl2br($oWarranty->bovagDescription) : false;
		$factory 				= !empty($oWarranty->factory) ? $oWarranty->factory : false;
		$factoryEndDate 		= !empty($oWarranty->factoryEndDate) ? $oWarranty->factoryEndDate : false;
		$factoryMonths 			= !empty($oWarranty->factoryMonths) ? $oWarranty->factoryMonths : false;
		$factoryMileage			= !empty($oWarranty->factoryMileage) ? $oWarranty->factoryMileage : false;
		$factoryDescription 	= !empty($oWarranty->factoryDescription) ? nl2br($oWarranty->factoryDescription) : false;
		$miscWarranty 			= !empty($oWarranty->miscWarranty) ? $oWarranty->miscWarranty : false;
		$miscEndDate 			= !empty($oWarranty->miscEndDate) ? $oWarranty->miscEndDate : false;
		$miscMonths 			= !empty($oWarranty->miscMonths) ? $oWarranty->miscMonths : false;
		$miscMileage 			= !empty($oWarranty->miscMileage) ? $oWarranty->miscMileage : false;
		$miscDescription 		= !empty($oWarranty->miscDescription) ? nl2br($oWarranty->miscDescription) : false;
		$returnURL 				= is_front_page() ? false : get_page_uri();
		$sQueryString 			= !empty( $_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : false;
		$sQueryString 			= str_ireplace('?verhuuraanvraag', '', $sQueryString);
		$sQueryString 			= str_ireplace('?inruilvoorstel', '', $sQueryString);
		$returnURLEnd			= $sQueryString;
		
		if(!empty($this->sAnchor)) {
			$returnURLEnd .= '#'.$this->sAnchor;
		} elseif(!empty($this->sSessionData['sSettings']['settings']['anchor'])) {
			$returnURLEnd .= '#'.$this->sSessionData['sSettings']['settings']['anchor'];
		}

		$aBlockedDates		= false;
		$sHTML 				= '';
		$languageShort 		= substr($this->sLanguage, 0, 2);
		
		$sHTML .= '<script>
			var unavailabledays = ['.(!empty($sBlockedDays) ? substr($sBlockedDays, 0, -1) : '').'];';
			if($languageShort == 'en') {
				$sHTML .= 'var ovisdaynames = [\'Su\',\'Mu\',\'Tu\',\'We\',\'Th\',\'Fr\',\'Sa\'];';
				$sHTML .= 'var ovismonthnames = [\'January\',\'February\',\'March\',\'April\',\'May\',\'June\',\'July\',\'August\',\'September\',\'October\',\'November\',\'December\'];';
				$sHTML .= 'var ovismonthnamesshort = [\'Jan\',\'Feb\',\'Mar\',\'Apr\',\'May\',\'Jun\',\'Jul\',\'Aug\',\'Sep\',\'Oct\',\'Nov\',\'Dec\'];';
			} elseif($languageShort == 'de') {	
				$sHTML .= 'var ovisdaynames = [\'So\',\'Mo\',\'Di\',\'Mi\',\'Do\',\'Fr\',\'Sa\'];';
				$sHTML .= 'var ovismonthnames = [\'Januar\',\'Februar\',\'M&auml;rz\',\'April\',\'Mai\',\'Juni\',\'Juli\',\'August\',\'September\',\'Oktober\',\'November\',\'Dezember\'];';
				$sHTML .= 'var ovismonthnamesshort = [\'Jan\',\'Feb\',\'M&auml;r\',\'Apr\',\'Mai\',\'Jun\',\'Jul\',\'Aug\',\'Sep\',\'Okt\',\'Nov\',\'Dez\'];';
			} elseif($languageShort == 'fr') {	
				$sHTML .= 'var ovisdaynames = [\'Di\',\'Lu\',\'Ma\',\'Me\',\'Je\',\'Ve\',\'Sa\'];';
				$sHTML .= 'var ovismonthnames = [\'Janvier\',\'F&eacute;vrier\',\'Mars\',\'Avril\',\'Mai\',\'Juin\',\'Julliet\',\'Ao&ocirc;t\',\'septembre\',\'Octobre\',\'Novembre\',\'D&eacute;cembre\'];';
				$sHTML .= 'var ovismonthnamesshort = [\'Jan\',\'Feb\',\'Maa\',\'Apr\',\'Mei\',\'Jun\',\'Jul\',\'Aug\',\'Sep\',\'Okt\',\'Nov\',\'Dec\'];';
			} else {
				$sHTML .= 'var ovisdaynames = [\'Zo\',\'Ma\',\'Di\',\'Wo\',\'Do\',\'Vr\',\'Za\'];';
				$sHTML .= 'var ovismonthnames = [\'Januari\',\'Februari\',\'Maart\',\'April\',\'Mei\',\'Juni\',\'Juli\',\'Augustus\',\'September\',\'Oktober\',\'November\',\'December\'];';
				$sHTML .= 'var ovismonthnamesshort = [\'Jan\',\'Feb\',\'Maa\',\'Apr\',\'Mei\',\'Jun\',\'Jul\',\'Aug\',\'Sep\',\'Okt\',\'Nov\',\'Dec\'];';
			}
		$sHTML .= '</script>';
		
		$structure = get_option( 'permalink_structure' );

		$sTrailingSlash = '';
		
		if(substr($structure, -1) == '/') {
			$sTrailingSlash = '/';
		}
		
		$sHTML .= '<!-- Plugin: ' . OVIS_PLUGIN_NAME . ' - ' . OVIS_VERSION . ' - ' . OVIS_RELEASE . '	-->
		<div id="ovis-container"'.(!empty($this->bScrollOnLoad) && !empty($oData->bUserSearched) ? ' class="scrollOnLoad"' : false).' data-ajax-uri="'.admin_url('admin-ajax.php').'">';
		
		$sHTML .= $this->build_plugin_settings_html();

		$sHTML .= $this->build_shortcode_param_html('detail');

		$sHTML .= '<input type="hidden" name="ovis_search_nonce" id="ovis_search_nonce" value="'.$sOvisCsrfToken.'" />';

		$sHTML .= '<a href="' . home_url() . (($returnURL) ? '/' . $returnURL : false) .  (!empty($this->sSessionData[$this->sUniqueID]['ovisPage']) && $this->sSessionData[$this->sUniqueID]['ovisPage'] > 1 ? '/page/' . (INT) $this->sSessionData[$this->sUniqueID]['ovisPage']  : false) . $sTrailingSlash .$returnURLEnd . '" 
			class="ovis-go-back js-ovis-translatable-title" 
			data-ovis-translation-key="Terug naar overzicht" 
			title="Terug naar overzicht"><i class="faovis faovis-arrow-left" aria-hidden="true"></i>
			<span data-ovis-translation-key="Terug naar overzicht" class="js-ovis-translatable-text">Terug naar overzicht</span></a>

		<div class="ovis-detail" id="ovis-detail" data-category="'. (!empty($oPresentation->specifications->category) ? $oPresentation->specifications->category : false) .'" 
			data-proefrit="'.((!empty($oPresentation->specifications->category) && strtolower($oPresentation->specifications->category) == 'mobilehome') || (!empty($this->sCallToAction) && is_array($this->sCallToAction) && !in_array('proefrit',$this->sCallToAction)) ? 'no' : 'yes').'" 
			data-ovis-presentation-id="'.$id.'"
			data-ovis-presentation-is-rental="'. (isset($oSpecs->rental) ? $oSpecs->rental : "0") .'">';
		
		if($oResponseObject->totalItems < 1) {
			$sHTML .= '<p class="noresults"><span data-ovis-translation-key="Presentatie bestaat niet" class="js-ovis-translatable-text">Presentatie bestaat niet</span>...</p>';
			$sHTML .= '</></div>';
			return $sHTML;
		}

		$sPermalink = get_permalink();
		$aPermalink = isset($_GET) ? $_GET : false;
		$sNewPermalink = '';
		
		/**
		 * Check for set GET parameters
		 */
		if(!empty($aPermalink)) {

			/**
			 * Loop through all GET parameters
			 */
			foreach($aPermalink as $key => $value) {

				/**
				 * Check for empty new permalink
				 */
				if(empty($sNewPermalink)) {

					/**
					 * Set a new permalink
					 */
					$sNewPermalink .= '?' . $key . '=' . $value;
				} else {

					/**
					 * Update the new permalink
					 */
					$sNewPermalink .= '&' . $key . '=' . $value;
				}
			}
		}
		
		$objectDetailURL = $sPermalink . $this->clean_object_url($oPresentation, true) . $sTrailingSlash . (!empty($sNewPermalink) ? $sNewPermalink : false );	
		
		$this->sCurrentUrl = get_home_url() . $_SERVER['REQUEST_URI'];

		if(substr($objectDetailURL, -1) == '=' && substr($this->sCurrentUrl, -1) != '=') {
			$objectDetailURL = substr($objectDetailURL, 0, -1);
		}

		if($objectDetailURL != $this->sCurrentUrl) {

			$sHTML .= '<meta http-equiv="refresh" content="0; URL=' . ($objectDetailURL) . '" />';

			return $sHTML;
		}
		
		$sHTML .= '<div class="ovis-detail-top-links" id="object-'.$oPresentation->id.'" data-detailurl="'.$objectDetailURL.'">

			<div class="ovis-detail-top-links__left">

				<a id="print" class="js-ovis-translatable-title" data-ovis-translation-key="Print" onclick="window.print();return false;" href="javascript:void(0);" title="Print"><span data-ovis-translation-key="Print" class="js-ovis-translatable-text">Print</span></a>
			
				<a id="bookmarkme" class="link-bookmark js-ovis-translatable-title" data-ovis-translation-key="Favorieten toevoegen" href="#" rel="sidebar" title="Favorieten toevoegen"><span data-ovis-translation-key="Favorieten toevoegen" class="js-ovis-translatable-text">Favorieten toevoegen</span></a>';
			
				if($oPresentation->mediainfo->pdf) {
					if($oPresentation->mediainfo->pdf->enabled && $oPresentation->mediainfo->pdf->url) {
						$sHTML .= '<a id="ovis-download-attachment" class="js-ovis-translatable-title" target="_blank" rel="nofollow" href="'.$oPresentation->mediainfo->pdf->url.'" title="Download bijlage' . (($oPresentation->mediainfo->pdf->title) ? ': ' . $oPresentation->mediainfo->pdf->title : false) . '">'.(!empty($oPresentation->mediainfo->pdf->title) ? '<span data-ovis-translation-key="Download" class="js-ovis-translatable-text">Download</span> <span data-ovis-translation-key="'.$oPresentation->mediainfo->pdf->title.'" class="js-ovis-translatable-text">'.$oPresentation->mediainfo->pdf->title.'</span>' : '<span data-ovis-translation-key="Download bijlage" class="js-ovis-translatable-text">Download bijlage</span>').'</a>';
					}
				}

			$sHTML .= '</div>';

			$sHTML .= '<div class="ovis-detail-top-links__right">';

				if($this->bShowSocials) {
					$sHTML .= '<div class="social-buttons-c">
						<a href="https://www.facebook.com/sharer/sharer.php?u=' . $objectDetailURL . '" class="social-buttons" target="_blank"><i class="fabovis faovis-facebook"></i></a>
						<a href="https://twitter.com/home?status='.$this->getSingleTranslation('bekijk').' ' . $title .' '.$this->getSingleTranslation('via').' ' . $objectDetailURL . '" class="social-buttons" target="_blank"><i class="fabovis faovis-twitter"></i></a>
						<a href="https://www.linkedin.com/shareArticle?mini=true&url=' . $objectDetailURL . '" class="social-buttons" target="_blank"><i class="fabovis faovis-linkedin"></i></a>
						<a href="mailto:?subject='.$this->getSingleTranslation('bekijk').' ' . $title . '&body='.$this->getSingleTranslation('bekijk').' ' . $title .' '.$this->getSingleTranslation('via').' ' . $objectDetailURL . '" class="social-buttons"><i class="faovis faovis-envelope"></i></a>';
					$sHTML .='</div>';
				}

			$sHTML .= '</div>';

		$sHTML .= '</div>';
		
		$sComposedTitle		= trim(strtolower($brand . ' ' . $model . ' ' . $version . '' . $titleSuffix));
		$sComposedTitle		= preg_replace('!\s+!', ' ', $sComposedTitle);

		if(trim(strtolower($title)) == preg_replace('!\s+!', ' ', $sComposedTitle)) {
			$title =  $brand . ' ' . $model . ' ' . $version . ' ' . $titleSuffix;
		}
		
		$languageHTML = null;
		
		if(!empty($oData->bAllowTranslations)) {
			$languageHTML = $this->build_language_picker_html('detail');
		}

		/**
		 * Check for set trade-in pictures
		 */
		if(isset($_GET['inruilvoorstel'])) {
			if(empty($this->sCallToAction) || (is_array($this->sCallToAction) && in_array('inruilvoorstel',$this->sCallToAction))) {
				$sHTML .= '';
			}
		} 
		elseif(isset($_GET['verhuuraanvraag'])) {
			if(empty($this->sCallToAction) || (is_array($this->sCallToAction) && in_array('verhuuraanvraag', $this->sCallToAction))) {
				$sHTML .= '';
			}
		} 
		else {
			if(empty($this->sCallToAction) || (is_array($this->sCallToAction) && (in_array('mail', $this->sCallToAction) || in_array('proefrit', $this->sCallToAction) || in_array('afspraak', $this->sCallToAction) || in_array('bezichtiging', $this->sCallToAction)))) {
				
				$sContactType = 'mail';
				
				if(!empty($this->sCallToAction)) {
					if(in_array('proefrit', $this->sCallToAction)) {
						$sContactType = 'proefrit';
					} 
					else if(in_array('afspraak', $this->sCallToAction)) {
						$sContactType = 'afspraak';
					} 
					else if(in_array('bezichtiging', $this->sCallToAction)) {
						$sContactType = 'bezichtiging';
					}
				}
			}
		}
		
		$sHTML .= '
		<div class="ovis-detail-title">
			<h1>' . $title . '</h1>';

			if(!empty($languageHTML) ) {
				$sHTML .= '<form id="ovis-set-language" class="ovis-set-language" method="post" action="'.$objectDetailURL.'" autocomplete="off">';
					$sHTML .= '<input type="hidden" name="ovis-language" id="ovis-language" value="' . $this->sLanguage . '" />';
					$sHTML .= $languageHTML;
				$sHTML .= '</form>';
			}

		$sHTML .= '</div>';

		
		/**
		 * Check for existing YouTube video
		 */
		if($oPresentation->mediainfo->youtubeVideo) {
			
			/**
			 * Breakdown YouTube video URL
			 */
			$aParsedUrl = parse_url($oPresentation->mediainfo->youtubeVideo);
			
			if(!empty($aParsedUrl['query'])) {
				
				parse_str($aParsedUrl['query'], $aParsedUrlVariables);

				if(!empty($aParsedUrlVariables['v'])) {
					$mediaYoutube = $aParsedUrlVariables['v'];
				}
			} 
			elseif(!empty($aParsedUrl['path'])) {
				
				$aPath = array_values(array_filter(explode('/',$aParsedUrl['path'])));
				
				if(!empty($aPath[0]) && $aPath[0] != 'embed') {
					$mediaYoutube = $aPath[0];
				}
				elseif(!empty($aPath[0]) && $aPath[0] == 'embed' && !empty($aPath[1])) {
					$mediaYoutube = $aPath[1];
				}
			}
		}

		$sHTML .= '<div class="ovis-contain">
			<div class="ovis-photocontainer">';
				$sHTML .= '<div class="fotorama" data-fit="scaledown" data-nav="thumbs" data-width="700" data-allowfullscreen="true" data-arrows="always" data-ratio="800/600">';					
				
				$iMediaCount = 1;

				/**
				 * Get total media count
				 */
				if($oImages) {
					$iMediaCount = count($oImages);
				}

				/**
				 * Set default video position index
				 * Index 2 equals the option `second` (default option)
				 */
				$iVideoPositionIndex = self::DEFAULT_VIDEO_POSITION_INDEX;
				$sVideoPositionSetting = isset($this->sSessionData['sSettings']['settings']['position_video_in_gallery']) ? $this->sSessionData['sSettings']['settings']['position_video_in_gallery'] : null;
				
				if(!empty($this->sVideoPosition)) {
					$sVideoPosition = $this->sVideoPosition;
				} elseif(!empty($sVideoPositionSetting)) {
					$sVideoPosition = $sVideoPositionSetting;
				} else {
					$sVideoPosition = 'second';
				}

				/**
				 * Check set option and set correct index
				 */
				switch ($sVideoPosition) {
					
					case 'first':
						$iVideoPositionIndex = 1;
						break;

					case 'second':
						$iVideoPositionIndex = 2;
						break;

					case 'last':
						$iVideoPositionIndex = $iMediaCount;
						break;

					default:
						$iVideoPositionIndex = self::DEFAULT_VIDEO_POSITION_INDEX;
				}

				/**
				 * Check for valid media
				 */
				if($oImages) {

					/**
					 * Set counter
					 */
					$countImg = 0;
					
					/**
					 * Loop through all media items
					 */
					foreach($oImages as $media) {
						
						/**
						 * Increment counter
						 */
						$countImg++;
						
						/**
						 * Check for first image
						 */
						if($countImg == 1) {

							/**
							 * Use 'default' image for first image
							 * 
							 * 'default' images contain a banner/label
							 */
							$mediaUrl = $media->traditional->original->default->url;
						} 
						else {
							/**
							 * For all other images use 'clean' images
							 * 
							 * 'clean' images don't contain banners/labels
							 */
							$mediaUrl = $media->traditional->original->clean->url;
						}

						$mediaUrlLarge = str_replace('/large/', '/xlarge/', $mediaUrl);
						$thumbUrl = $media->traditional->default->clean->url;
						
						/**
						 * Video
						 */
						if($iVideoPositionIndex != $iMediaCount) {
							if($countImg == $iVideoPositionIndex) {
								if(!empty($bHasVideoMedia) || !empty($mediaYoutube)) {
									$sHTML .= '<div class="videocontainer" data-thumb="'.plugin_dir_url( __DIR__ ).'/assets/img/video-OVIS_thumb.png" href="'.plugin_dir_url( __DIR__ ).'/assets/img/video-OVIS_thumb.png" alt="' . $title . '">';									
										$sTaggleVideoURL = str_ireplace('default.movieplayer','plugin.movieplayer',$oPresentation->mediainfo->taGGleVideo);										
										$sHTML .= '<iframe id="mediaVideo" class="media video" loading="lazy" data-src="' . $sTaggleVideoURL  . '/default/autoplay-disabled" src="' . $sTaggleVideoURL  . '/default/autoplay-disabled" width="100%" height="" frameborder="0" allowfullscreen></iframe>';
									$sHTML .= '</div>';
								}
								if(!empty($bHas360Media)) {
									$sHTML .= '<div class="videocontainer" data-thumb="'.plugin_dir_url( __DIR__ ).'/assets/img/360-OVIS_thumb.png" href="'.plugin_dir_url( __DIR__ ).'/assets/img/360-OVIS_thumb.png" alt="' . $title . '">';
										$sHTML .= '<iframe id="media360" class="media 360" data-src="' . $oPresentation->mediainfo->{360}->url . '" src="' . $oPresentation->mediainfo->{360}->url . '" width="100%" height="" frameborder="0" allowfullscreen></iframe>';
									$sHTML .= '</div>';
								}
							}
						}

						/**
						 * Image
						 */
						$sHTML .= '<a data-thumb="' . $thumbUrl . '" href="' . $mediaUrlLarge . '" alt="' . $title . '">
							<img class="image" src="' . $mediaUrl . '" alt="' . $title . '" />
						</a>';

						/**
						 * Video
						 */
						if($iVideoPositionIndex == $iMediaCount) {
							if($countImg == $iVideoPositionIndex) {
								if(!empty($bHasVideoMedia) || !empty($mediaYoutube)) {
									$sHTML .= '<div class="videocontainer" data-thumb="'.plugin_dir_url( __DIR__ ).'/assets/img/video-OVIS_thumb.png" href="'.plugin_dir_url( __DIR__ ).'/assets/img/video-OVIS_thumb.png" alt="' . $title . '">';									
										$sTaggleVideoURL = str_ireplace('default.movieplayer','plugin.movieplayer',$oPresentation->mediainfo->taGGleVideo);										
										$sHTML .= '<iframe id="mediaVideo" class="media video" loading="lazy" data-src="' . $sTaggleVideoURL  . '/default/autoplay-disabled" src="' . $sTaggleVideoURL  . '/default/autoplay-disabled" width="100%" height="" frameborder="0" allowfullscreen></iframe>';
									$sHTML .= '</div>';
								}
								if(!empty($bHas360Media)) {
									$sHTML .= '<div class="videocontainer" data-thumb="'.plugin_dir_url( __DIR__ ).'/assets/img/360-OVIS_thumb.png" href="'.plugin_dir_url( __DIR__ ).'/assets/img/360-OVIS_thumb.png" alt="' . $title . '">';
										$sHTML .= '<iframe id="media360" class="media 360" data-src="' . $oPresentation->mediainfo->{360}->url . '" src="' . $oPresentation->mediainfo->{360}->url . '" width="100%" height="" frameborder="0" allowfullscreen></iframe>';
									$sHTML .= '</div>';
								}
							}
						}
					}
				} else {
					/**
					 * No media
					 */
					$sHTML .= '<a href="' . OVIS_NOIMAGE_LARGE . '" alt="'.$this->getSingleTranslation('geen_afbeelding_beschikbaar').'">
						<img class="image" src="' . OVIS_NOIMAGE_LARGE . '" alt="'.$this->getSingleTranslation('geen_afbeelding_beschikbaar').'" />
					</a>';
				}
			$sHTML .= '</div>
			</div>';
			
			$sHTML .= '<div class="ovis-specifications">';
				$sHTML .= $this->build_detail_specifications_html($oPresentation, $oUser);
			$sHTML .= '</div>
		</div>';
		

		/**
		 * Rental availability
		 */
		if(isset($oSpecs->rental) && $oSpecs->rental > 0) {
			
			$aBlockedDates = $oData->getBlockedDates($oPresentation->id);
			$aMonthHistory = array();
			
			/**
			 * Retrieve & store current date, month and year
			 */
			$currentDay = date('d');
			$currentMonth = date('m');
			$currentYear = date('Y');
			
			if($currentDay > 1) {
				$begin = new DateTime( $currentYear.'-'.$currentMonth.'-01');
				$end   = new DateTime( $currentYear.'-'.$currentMonth.'-'.$currentDay );
				for($i = $begin; $i < $end; $i->modify('+1 day')) {
					$aMonthHistory[] = $i->format('d-m-Y');
				}
			}

			$sBlockedDays = '';

			if(!empty($aBlockedDates) && is_array($aBlockedDates)) {
				foreach($aBlockedDates as $aBlockedDate) {
					if($aBlockedDate >= date('Y-m-d')) {
						$sBlockedDays .= '\'' . $aBlockedDate . '\',';
						$sBlockedDay = date('d-m-Y', strtotime($aBlockedDate));
					}
				}
			}
			
			if(!empty($this->bShowCalendar) && !empty($this->bRentalActive)) {
				$sHTML .= '<div class="ovis-detail-section ovis-description">
					<h3><i class="faovis faovis-calendar"></i> <span data-ovis-translation-key="Beschikbaarheid" class="js-ovis-translatable-text">Beschikbaarheid</span></h3>';
					$sHTML .= '<script>
						var unavailabledays = ['.(!empty($sBlockedDays) ? substr($sBlockedDays,0,-1) : '').'];
					</script>
					<div id="availabiltycalendar" data-toggle="calendar" data-month="'.date('m').'" data-year="'.date('Y').'" data-objectid="'.$oPresentation->id.'" data-user="'.$oPresentation->userId.'"></div>';
					$sHTML .= '<button class="do-verhuur" data-ovis-detail-cta-button="openRentalForm"><i class="faovis faovis-retweet" aria-hidden="true"></i> '.(!empty($this->sSessionData['sSettings']['settings']['texts']['label_verhuuraanvraag'][$languageShort]) ? $this->sSessionData['sSettings']['settings']['texts']['label_verhuuraanvraag'][$languageShort] : $this->sSessionData['sSettings']['settings']['rental_button_default'][$languageShort]).'</button>';
				$sHTML .= '</div>';
			}
		}
		
		/**
		 * Retrieve & store 3D presentation
		 */
		$media3D = $oPresentation->mediainfo->{'3D'};
		
		/**
		 * Check for existing 3D presentation
		 */
		if(!empty($media3D)) {
			$sHTML .= '<div class="ovis-detail-section ovis-description">
				<h3><i class="faovis faovis-video"></i> <span data-ovis-translation-key="3D Presentatie" class="js-ovis-translatable-text">3D Presentatie</span></h3>';
				$sHTML .= '<div class="presentatie-3d-container">
					<div class="presentatie-3d-overlay"></div>
					<iframe class="presentatie-3d" src="'.$media3D.'"></iframe>
				</div>';
			$sHTML .= '</div>';
		}


		/**
		 * Description
		 */
		if($oSpecs->description) {
			$sHTML .= '<div class="ovis-detail-section ovis-description">
				<h3><i class="faovis faovis-align-left"></i> <span data-ovis-translation-key="Omschrijving" class="js-ovis-translatable-text">Omschrijving</span></h3>';
				$sHTML .= !empty($this->aLanguageConfig['description']) ? $this->aLanguageConfig['description'] : $oSpecs->description;
			$sHTML .= '</div>';
		}
		

		/**
		 * Accessories
		 */
		if($oSpecs->accessories) {
			
			$sHTML .= '<div class="ovis-detail-section ovis-accessory">
				<h3><i class="faovis faovis-list-ul"></i> <span data-ovis-translation-key="Accessoires" class="js-ovis-translatable-text">Accessoires</span></h3>';
				$aAccessoiresNew = array();

				foreach($oSpecs->accessories as $aAccessoires) {
					if(!in_array($aAccessoires->category, array_keys($aAccessoiresNew))) {
						$aAccessoiresNew[$aAccessoires->category] = (object)array(
							'accessories' => $aAccessoires->description
						);
					} else {
						$aAccessoiresNew[$aAccessoires->category]->accessories .= ', ' . $aAccessoires->description;
					}
				}

				ksort($aAccessoiresNew);

				foreach($aAccessoiresNew as $categoryName => $aAccessories) {

					$sHTML .= '<ul><h4 class="ovis-excerpt-text"><span data-ovis-translation-key="'.ucfirst($categoryName).'" class="js-ovis-translatable-text">'.ucfirst($categoryName).'</span></h4>';
					$aAccessories = explode(',', $aAccessories->accessories);
					
					foreach($aAccessories as $accessory) {
						$sHTML .= '<li><span data-ovis-translation-key="'.ucfirst($accessory).'" class="js-ovis-translatable-text">'.ucfirst($accessory).'</span></li>';
					}

					$sHTML .= '</ul>';

				}
			$sHTML .= '</div>';
		}

		switch(strtolower(trim($category))) {

			case 'caravan':
				$objectSpecs = !empty($oSpecs->specsCaravan->division) ? $oSpecs->specsCaravan->division : false;
				break;

			case 'camper':
				$objectSpecs = !empty($oSpecs->specsCamper->division) ? $oSpecs->specsCamper->division : false;
				break;

			case 'mobilehome':
				$objectSpecs = !empty($oSpecs->specsMobileHome->division) ? $oSpecs->specsMobileHome->division : false;
				break;

			case 'tenttrailer':
				$objectSpecs = !empty($oSpecs->specsTentTrailer->division) ? $oSpecs->specsTentTrailer->division : false;
				break;

			case 'trailer':
				$objectSpecs = !empty($oSpecs->specsTrailer->division) ? $oSpecs->specsTrailer->division : false;
				break;

			default:
				$objectSpecs = false;
				break;
		}


		/**
		 * Divisions
		 */
		if($objectSpecs) {
			$sHTML .= '<div class="ovis-detail-section ovis-division">
				<h3><i class="faovis faovis-th-large"></i> <span data-ovis-translation-key="Indelingen" class="js-ovis-translatable-text">Indelingen</span></h3>';
				
				$aDivisionsNew = array();
				
				foreach($objectSpecs as $aDivisions) {
					if(!in_array($aDivisions->category, array_keys($aDivisionsNew))) {
						$aDivisionsNew[$aDivisions->category] = (object)array(
							'division' => ucfirst($aDivisions->division)
						);
					} else {
						$aDivisionsNew[$aDivisions->category]->division .= ', ' . ucfirst($aDivisions->division);
					}
				}

				ksort($aDivisionsNew);

				foreach($aDivisionsNew as $categoryName => $aDivisions) {
					$sHTML .= '<ul><h4 class="ovis-excerpt-text"><span data-ovis-translation-key="'.ucfirst($categoryName).'" class="js-ovis-translatable-text">'.ucfirst($categoryName).'</span></h4>';
						$aDivisions = explode(',', $aDivisions->division);
						
						foreach ($aDivisions as $division) {
							$sHTML .= '<li><span data-ovis-translation-key="'.ucfirst($division).'" class="js-ovis-translatable-text">'.ucfirst($division).'</span></li>';
						}
					$sHTML .= '</ul>';
				}

			$sHTML .= '</div>';
		}


		/**
		 * Beds
		 */
		$objectBeds = isset($oSpecs->beds) ? $oSpecs->beds : false;

		if(isset($objectBeds->numberOfBeds) && $objectBeds->numberOfBeds > 0) {
			$sHTML .= '<div class="ovis-detail-section ovis-beds">
				<h3><i class="faovis faovis-bed"></i> <span data-ovis-translation-key="Slaapplaatsen" class="js-ovis-translatable-text js-ovis-lowercase-text">Slaapplaatsen</span></h3>';
				
				$textNumberOf  = '';
				$textNumberOf .= ($objectBeds->numberOfSleepingPlaces) ? ($objectBeds->numberOfSleepingPlaces > 1 ? '<span data-ovis-translation-key="Er zijn" class="js-ovis-translatable-text">Er zijn</span>' : '<span data-ovis-translation-key="Er is" class="js-ovis-translatable-text">Er is</span>') . ' ' . '<span data-ovis-translation-key="In totaal" class="js-ovis-translatable-text">In totaal</span>' . ' ' . $objectBeds->numberOfSleepingPlaces . ($objectBeds->numberOfSleepingPlaces > 1 ? ' '.'<span data-ovis-translation-key="slaapplaatsen" class="js-ovis-translatable-text">slaapplaatsen</span>' : ' '.'<span data-ovis-translation-key="slaapplaatsen" class="js-ovis-translatable-text">slaapplaatsen</span>') : false;
				$textNumberOf .= ($objectBeds->numberOfBeds && $objectBeds->numberOfBeds) ? ' ' . '<span data-ovis-translation-key="verdeeld over" class="js-ovis-translatable-text">verdeeld over</span>' . ' ' . $objectBeds->numberOfBeds . ($objectBeds->numberOfBeds > 1 ? ' ' . '<span data-ovis-translation-key="bedden" class="js-ovis-translatable-text">bedden</span>' : ' ' . '<span data-ovis-translation-key="bed" class="js-ovis-translatable-text">bed</span>') : '';
				
				if($textNumberOf) {
					$sHTML .= '<p>' . $textNumberOf . '.</p>';
				}
				
				$aBedsNew = array();
				
				/**
				 * Loop through all bed specifications
				 */
				foreach($objectBeds->bedSpecifications as $aBeds) {
					if((int)$aBeds->length == 0 && (int)$aBeds->width == 0) {
						unset($aBeds);
					} 
					else {
						if(!in_array($aBeds->type, array_keys($aBedsNew))) {
							$aBedsNew[$aBeds->type] = (object)array(
								'length' => $aBeds->length,
								'width' => $aBeds->width
							);
						} 
						else {
							$aBedsNew[$aBeds->type]->length .= ', ' . $aBeds->length;
							$aBedsNew[$aBeds->type]->width .= ', ' . $aBeds->width;
						}
					}
				}

				ksort($aBedsNew);

				foreach($aBedsNew as $bedName => $aBeds) {
					$sHTML .= '<ul>
						<h4 class="ovis-excerpt-text"><span data-ovis-translation-key="'.ucfirst($bedName).'" class="js-ovis-translatable-text">'.ucfirst($bedName).'</span></h4>';
						$bedDimensions = array();
						$aBedsLength = explode(',', $aBeds->length);
						$aBedsWidth = explode(',', $aBeds->width);
						
						$l = 0;
						
						foreach($aBedsLength as $bedLength) {
							$bedDimensions[$l]['dimensions']['length'] = trim($bedLength);
							$l++;
						}

						$w = 0;
						
						foreach($aBedsWidth as $bedWidth) {
							$bedDimensions[$w]['dimensions']['width'] = trim($bedWidth);
							$w++;
						}
						
						foreach($bedDimensions as $keyDimension => $dimensions) {
							$sHTML .= '<li><i class="faovis faovis-bed" aria-hidden="true"></i> ' . $dimensions['dimensions']['length'] . ' cm x ' . $dimensions['dimensions']['width'] . ' cm</li>';
						}
					$sHTML .= '</ul>';
				}
			$sHTML .= '</div>';
		}


		/**
		 * Warranty
		 */
		if($factory || $bovag || $miscWarranty) {

			$sHTML .= '<div class="ovis-detail-section ovis-warranty">';
				$sHTML .= '<h3><i class="faovis faovis-certificate"></i><span data-ovis-translation-key="Garanties" class="js-ovis-translatable-text">Garanties</span></h3>';

				if($factory == true) {
					$sHTML .= $this->build_detail_warranty_html('factory', $factoryEndDate, $factoryMonths, $factoryDescription, $category, $factoryMileage);
				}

				if($bovag == true) {
					$sHTML .= $this->build_detail_warranty_html('bovag', $bovagEndDate, $bovagMonths, $bovagDescription, $category);
				}

				if($miscWarranty == true) {
					$sHTML .= $this->build_detail_warranty_html('misc', $miscEndDate, $miscMonths, $miscDescription, $category, $miscMileage);
				}
			$sHTML .= '</div>';
		}


		/**
		 * User
		 */
		$sHTML .= '<div class="ovis-detail-section ovis-user">';
			
			/**
			 * Address HTML
			 */
			$sAddress = '';
			$sAddress .= '<div class="ovis-user-block">';
				$sAddress .= !empty($oUser->address) ? $oUser->address : false;
				$sAddress .= !empty($oUser->houseNumber) ? ' '.$oUser->houseNumber : false;
				$sAddress .= !empty($oUser->houseNumberExt1) ? ' '.$oUser->houseNumberExt1 : false;
				$sAddress .= !empty($oUser->houseNumberExt2) ? ' '.$oUser->houseNumberExt2 : false;
				$sAddress .= !empty($oUser->postalCode) || !empty($oUser->city) ? '<br>' : false;
				$sAddress .= !empty($oUser->postalCode) ? $oUser->postalCode : false;
				$sAddress .= !empty($oUser->city) ? ' '.$oUser->city : false;
			$sAddress .= '</div>';
			
			/**
			 * Contact
			 */
			$sContact = '';
			$sContact .= '<div class="ovis-user-block last">';
				
				$sWebsite = $oUser->website;
				
				if(!empty($sWebsite) && substr($sWebsite,0,7) != 'http://' && substr($sWebsite,0,8) != 'https://') {
					$sWebsite = 'https://' . $sWebsite;
				}

				$sContact .= !empty($oUser->phone) ? '<a href="tel:'.$oUser->phone.'" class="ovis-contactline ovis-ctabutton"><i class="faovis faovis-phone"></i>'.$oUser->phone.'</a>' : false;
				
				if(empty($this->sCallToAction) || (is_array($this->sCallToAction) && in_array('mail',$this->sCallToAction))) {
					$sContact .= !empty($oUser->email) ? '<button class="ovis-contactline ovis-ctabutton" data-ovis-detail-cta-button="openContactForm"><i class="faovis faovis-envelope"></i><span data-ovis-translation-key="Mail ons" class="js-ovis-translatable-text">Mail ons</span></button>' : false;
				}
				
				if($this->bShowDealerFooter) {
					$sContact .= !empty($sWebsite) ? '<a href="'.$sWebsite.'" target="_blank" class="ovis-contactline ovis-ctabutton"><i class="faovis faovis-globe"></i><span data-ovis-translation-key="Bezoek website" class="js-ovis-translatable-text">Bezoek website</span></a>' : false;
				}
				
				$sGoogleAddress = false;
				$sGoogleAddress .= !empty($oUser->address) ? $oUser->address : false;
				$sGoogleAddress .= !empty($oUser->houseNumber) ? ' '.$oUser->houseNumber : false;
				$sGoogleAddress .= !empty($oUser->houseNumberExt1) ? ' '.$oUser->houseNumberExt1 : false;
				$sGoogleAddress .= !empty($oUser->houseNumberExt2) ? ' '.$oUser->houseNumberExt2 : false;
				$sGoogleAddress .= !empty($oUser->city) ? ' '.$oUser->city : false;
				
				if($this->bShowContactAddress == 'yes' && (!isset($oUser->displaySettings->map) || !empty($oUser->displaySettings->map))) {
					$sContact .= !empty($sGoogleAddress) ? '<a href="https://www.google.nl/maps/place/'.urlencode($sGoogleAddress).'" target="_blank" class="ovis-contactline ovis-ctabutton"><i class="faovis faovis-map-marker"></i><span data-ovis-translation-key="Bekijk op kaart" class="js-ovis-translatable-text">Bekijk op kaart</span></a>' : false;
				}

			$sContact .= '</div>';
			
			
			if($this->bShowDealerFooter) {
				$sHTML .= '<h3><i class="faovis faovis-map-marker"></i><span data-ovis-translation-key="Contactgegevens" class="js-ovis-translatable-text">Contactgegevens</span></h3>';
				
				/**
				 * Company name
				 */
				$sHTML .= '<span class="ovis-detail-companyname">' . $oUser->companyName . '</span>';
				
				/**
				 * Address
				 */
				if($this->bShowContactAddress) {
					$sHTML .= $sAddress;
				}
			}
			
			/**
			 * Contact
			 */
			$sHTML .= $sContact;

			if(!empty($oPresentation->backlink) && !empty($oPresentation->backlink->url) && !empty($oPresentation->backlink->label)) {
				$sHTML .= '<div class="ovis-backlink">Powered by <a href="'.$oPresentation->backlink->url.'">'.$oPresentation->backlink->label.'</a></div>';
			}
		
		$sHTML .= '</div>';
		$sHTML .= '</></div>';
		
		return $sHTML;
	}


	/**
	 * Generate waranty HTML
	 *
	 * @param string $sType
	 * @param string $endDate
	 * @param string $months
	 * @param string $sDescription
	 * @param string $sCategory
	 * @param string [$mileage]
	 * @return string
	 */
	private function build_detail_warranty_html($sType, $endDate, $months, $sDescription, $sCategory, $mileage = null) {
		
		$aTypeMap = array(
			'factory' => 'Fabriek',
			'bovag' => 'BOVAG',
			'misc' => 'Overige'
		);
		$sNormalizedTypeKey = strtolower(trim($sType));
		$sNormalizedTypeLabel = htmlspecialchars($aTypeMap[$sNormalizedTypeKey]) . ($sNormalizedTypeKey === 'factory' ? 's' : ' ');
		$sNormalizedCategory = htmlspecialchars(strtolower(trim($sCategory)));

		ob_start(); ?>
			<div class="ovis-warranty-block">
				<h4 class="ovis-excerpt-text"><span data-ovis-translation-key="<?php echo $sNormalizedTypeLabel; ?>garantie" class="js-ovis-translatable-text"><?php echo $sNormalizedTypeLabel; ?>garantie</span></h4>
				<p><span data-ovis-translation-key="Deze" class="js-ovis-translatable-text js-ovis-capitalize-text">Deze</span> <?php echo $sNormalizedCategory; ?> <span data-ovis-translation-key="is voorzien van <?php echo $sNormalizedTypeLabel; ?>garantie" class="js-ovis-translatable-text">is voorzien van <?php echo $sNormalizedTypeLabel; ?>garantie</span></p>
			
				<?php if(!empty($endDate) && $endDate !== '0000-00-00') { ?>
					<p><span data-ovis-translation-key="Geldig t/m" class="js-ovis-translatable-text">Geldig t/m</span><?php echo htmlspecialchars($endDate); ?></p>
				<?php } ?>
				
				<?php if(!empty($months)) { ?>
					<p><span data-ovis-translation-key="Aantal maanden" class="js-ovis-translatable-text">Aantal maanden</span> <?php echo htmlspecialchars($months); ?></p>
				<?php } ?>

				<?php if(!empty($mileage)) { ?>
					<p><span data-ovis-translation-key="Aantal kilometer" class="js-ovis-translatable-text">Aantal kilometer</span> <?php echo htmlspecialchars($mileage); ?></p>
				<?php } ?>

				<?php if (!empty($bovagDescription)) { ?>
					<p class="ovis-comments"><span><i class="faovis faovis-comments"></i><span data-ovis-translation-key="Opmerkingen" class="js-ovis-translatable-text">Opmerkingen</span></span><span> <?php echo htmlspecialchars($bovagDescription); ?></span></p>
				<?php } ?>
			</div>
		<?php
		return ob_get_clean();
	}


	private function translateMonth($iMonth) {

		if($iMonth == 1) {
			return 'januari';
		} elseif($iMonth == 2) {
			return 'februari';
		} elseif($iMonth == 3) {
			return 'maart';
		} elseif($iMonth == 4) {
			return 'april';
		} elseif($iMonth == 5) {
			return 'mei';
		} elseif($iMonth == 6) {
			return 'juni';
		} elseif($iMonth == 7) {
			return 'juli';
		} elseif($iMonth == 8) {
			return 'augustus';
		} elseif($iMonth == 9) {
			return 'september';
		} elseif($iMonth == 10) {
			return 'oktober';
		} elseif($iMonth == 11) {
			return 'november';
		} elseif($iMonth == 12) {
			return 'december';
		}
		return $iMonth;
	}


	private function build_detail_specifications_html($object, $oUserData) {
		
		$languageShort = substr($this->sLanguage, 0, 2);

		$sHTML = '';
		$oSpecs							= isset($object->specifications) ? $object->specifications : null;
		$condition 						= !empty($oSpecs->new) ? $this->getSingleTranslation('new') : $this->getSingleTranslation('occasion');
		$title		 					= !empty($oSpecs->titleManual) ? ' ' . ucfirst($oSpecs->titleManual) : (!empty($oSpecs->title) ? ' ' . ucfirst($oSpecs->title) : false);
		$titleSuffix 					= !empty($oSpecs->titleSuffix) ? ' '.ucfirst($oSpecs->titleSuffix) : false;
		
		if(!empty($this->aLanguageConfig['titlesuffix'])) {
			$titleSuffix = ucfirst($this->aLanguageConfig['titlesuffix']);
			$title =  $brand . ' ' . $model . ' ' . $version . ' ' . $titleSuffix;
		}

		$category 				= !empty($oSpecs->category) ? $oSpecs->category : false;
		$exRental 				= !empty($oSpecs->exRental) ? 'Ja' : false;
		$damaged 				= !empty($oSpecs->damaged) ? 'Ja' : false;
		$demo 					= !empty($oSpecs->demo) ? 'Ja' : false;
		
		/* Field dates */
		$constructionYear 		= !empty($oSpecs->dates->constructionYear) ? $oSpecs->dates->constructionYear : false;		
		$constructionMonth 		= !empty($oSpecs->dates->constructionMonth) ? $this->translateMonth($oSpecs->dates->constructionMonth) : false;       
		$modelYear 				= !empty($oSpecs->dates->modelYear) ? $oSpecs->dates->modelYear : false;		
		$datePart1a				= !empty($oSpecs->dates->datePart1a) ? $oSpecs->dates->datePart1a : false;
		
		/* Field weightsMeasures */		
		$weightMaximum 			= !empty($oSpecs->weightsMeasures->weightMaximum) ? $oSpecs->weightsMeasures->weightMaximum : false;		
		$lengthConstruction		= !empty($oSpecs->weightsMeasures->lengthConstruction) ? $oSpecs->weightsMeasures->lengthConstruction : false;		
		$lengthTotal			= !empty($oSpecs->weightsMeasures->lengthTotal) ? $oSpecs->weightsMeasures->lengthTotal : false;		
		$width					= !empty($oSpecs->weightsMeasures->width) ? $oSpecs->weightsMeasures->width : false;		
		$height					= !empty($oSpecs->weightsMeasures->height) ? $oSpecs->weightsMeasures->height : false;		
		$headroom				= !empty($oSpecs->weightsMeasures->headroom) ? $oSpecs->weightsMeasures->headroom : false;		
		$weightEmpty			= !empty($oSpecs->weightsMeasures->weightEmpty) ? $oSpecs->weightsMeasures->weightEmpty : false;		
		$weightOperational		= !empty($oSpecs->weightsMeasures->weightOperational) ? $oSpecs->weightsMeasures->weightOperational : false;		
		$capacity				= !empty($oSpecs->weightsMeasures->capacity) ? $oSpecs->weightsMeasures->capacity : false;
		
		/* Field pricesRental */
		$priceHour 				= !empty($oSpecs->pricesRental->priceHour) ? $this->clean_price($oSpecs->pricesRental->priceHour) : false;		
		$price3Hours 			= !empty($oSpecs->pricesRental->price3Hours) ? $this->clean_price($oSpecs->pricesRental->price3Hours) : false;		
		$priceDayPart 			= !empty($oSpecs->pricesRental->priceDayPart) ? $this->clean_price($oSpecs->pricesRental->priceDayPart) : false;		
		$priceDay 				= !empty($oSpecs->pricesRental->priceDay) ? $this->clean_price($oSpecs->pricesRental->priceDay) : false;		
		$priceWeek 				= !empty($oSpecs->pricesRental->priceWeek) ? $this->clean_price($oSpecs->pricesRental->priceWeek) : false;		
		$priceWeekend 			= !empty($oSpecs->pricesRental->priceWeekend) ? $this->clean_price($oSpecs->pricesRental->priceWeekend) : false;		$priceMonth 			= !empty($oSpecs->pricesRental->priceMonth) ? $this->clean_price($oSpecs->pricesRental->priceMonth) : false;		
		$deposit 				= !empty($oSpecs->pricesRental->deposit) ? $this->clean_price($oSpecs->pricesRental->deposit) : false;		
		$noclaim 				= !empty($oSpecs->pricesRental->noclaim) ? $this->clean_price($oSpecs->pricesRental->noclaim) : false;
		
		/* Specs: caravan	 */
		$wallsCaravan			= !empty($oSpecs->specsCaravan->walls) ? $oSpecs->specsCaravan->walls : false;
		$wallsColorCaravan 		= !empty($oSpecs->specsCaravan->wallsColor) ? $oSpecs->specsCaravan->wallsColor : false;
		
		/* Specs: camper */
		$category				= !empty($oSpecs->specsCamper->category) ? $oSpecs->specsCamper->category : false;
		$carBrand				= !empty($oSpecs->specsCamper->carBrand) ? $oSpecs->specsCamper->carBrand : false;
		$mileage				= !empty($oSpecs->specsCamper->mileage) ? $oSpecs->specsCamper->mileage : false;
		$nap					= false; /*!empty($oSpecs->specsCamper->nap) ? true : false;*/
		
		$fuel					= !empty($oSpecs->specsCamper->fuel) ? $oSpecs->specsCamper->fuel : false;
		$transmission			= !empty($oSpecs->specsCamper->transmission) ? $oSpecs->specsCamper->transmission : false;
		$engineHorsePower		= !empty($oSpecs->specsCamper->engineHorsePower) ? $oSpecs->specsCamper->engineHorsePower : false;
		$wallsCamper			= !empty($oSpecs->specsCamper->walls) ? $oSpecs->specsCamper->walls : false;
		$wallsColorCamper	 	= !empty($oSpecs->specsCamper->wallsColor) ? $oSpecs->specsCamper->wallsColor : false;
		$euroclassCamper	 	= !empty($oSpecs->specsCamper->euroclass) ? $oSpecs->specsCamper->euroclass : false;
		$camperSeats			= !empty($oSpecs->specsCamper->seats) ? $oSpecs->specsCamper->seats : false;
		$camperSeatbelts		= !empty($oSpecs->specsCamper->seatbelts) ? $oSpecs->specsCamper->seatbelts : false;
		
		/* Specs: mobilehome */
		$materialMobileHome 	= !empty($oSpecs->specsMobileHome->material) ? $oSpecs->specsMobileHome->material : false;
		
		/* Specs: tenttrailer	 */
		$materialTentTrailer 	= !empty($oSpecs->specsTentTrailer->material) ? $oSpecs->specsTentTrailer->material : false;
		
		/* Specs: boat */
		$boatLength				= !empty($oSpecs->weightsMeasures->length) ? $oSpecs->weightsMeasures->length : false;
		$boatWidth				= !empty($oSpecs->weightsMeasures->width) ? $oSpecs->weightsMeasures->width : false;
		$boatHeadroom			= !empty($oSpecs->weightsMeasures->headroom) ? $oSpecs->weightsMeasures->headroom : false;
		$boatDraft				= !empty($oSpecs->weightsMeasures->draft) ? $oSpecs->weightsMeasures->draft : false;
		$boatLocation			= !empty($oSpecs->specsBoat->berth) ? $oSpecs->specsBoat->berth : false;
		$boatBeds				= !empty($oSpecs->specsBoat->beds->numberOfBeds) ? $oSpecs->specsBoat->beds->numberOfBeds : false;
		$boatSleepingplaces		= !empty($oSpecs->specsBoat->beds->numberOfSleepingPlaces) ? $oSpecs->specsBoat->beds->numberOfSleepingPlaces : false;
		$boatNumberOfSeats		= !empty($oSpecs->specsBoat->numberOfSeats) ? $oSpecs->specsBoat->numberOfSeats : false;
		$boatHullMaterial		= !empty($oSpecs->specsBoat->hullMaterial) ? $oSpecs->specsBoat->hullMaterial : false;
		$boatHullColor			= !empty($oSpecs->specsBoat->hullColor) ? $oSpecs->specsBoat->hullColor : false;
		$boatDeckColor			= !empty($oSpecs->specsBoat->deckColor) ? $oSpecs->specsBoat->deckColor : false;
		$boatTrailerIncluded	= !empty($oSpecs->specsBoat->trailerIncluded) ? $oSpecs->specsBoat->trailerIncluded : false;
		$boatFastSailing		= !empty($oSpecs->specsBoat->fastSailing) ? $oSpecs->specsBoat->fastSailing : false;
		$boatNumberOfEngines	= !empty($oSpecs->specsBoat->numberOfEngines) ? $oSpecs->specsBoat->numberOfEngines : false;
		$boatEngineType			= !empty($oSpecs->specsBoat->engine->type) ? $oSpecs->specsBoat->engine->type : false;
		$boatEngineBrand		= !empty($oSpecs->specsBoat->engine->brand) ? $oSpecs->specsBoat->engine->brand : false;
		$boatEngineModel		= !empty($oSpecs->specsBoat->engine->model) ? $oSpecs->specsBoat->engine->model : false;
		$boatEngineFuel			= !empty($oSpecs->specsBoat->engine->fuel) ? $oSpecs->specsBoat->engine->fuel : false;
		$boatEngineTankCapacity	= !empty($oSpecs->specsBoat->engine->tankCapacity) ? $oSpecs->specsBoat->engine->tankCapacity : false;
		$boatEnginePower		= !empty($oSpecs->specsBoat->engine->power) ? $oSpecs->specsBoat->engine->power : false;
		$boatEngineBattery		= !empty($oSpecs->specsBoat->engine->battery) ? $oSpecs->specsBoat->engine->battery : false;
		$boatEngineRunHours		= !empty($oSpecs->specsBoat->engine->runHours) ? $oSpecs->specsBoat->engine->runHours : false;
		$boatEngineCruisingSpeed= !empty($oSpecs->specsBoat->engine->cruisingSpeed) ? $oSpecs->specsBoat->engine->cruisingSpeed : false;
		
		/* Specs: engine */
		$engineSize				= !empty($oSpecs->specsEngine->engineSize) ? $oSpecs->specsEngine->engineSize : false;
		$engineFuel				= !empty($oSpecs->specsEngine->fuel) ? $oSpecs->specsEngine->fuel : false;
		$engineNumberOfCylinders= !empty($oSpecs->specsEngine->numberOfCylinders) ? $oSpecs->specsEngine->numberOfCylinders : false;
		$enginePower			= !empty($oSpecs->specsEngine->power) ? $oSpecs->specsEngine->power : false;
		$engineStartSystem		= !empty($oSpecs->specsEngine->startSystem) ? $oSpecs->specsEngine->startSystem : false;
		$engineSteering			= !empty($oSpecs->specsEngine->steering) ? $oSpecs->specsEngine->steering : false;
		$engineTailLength		= !empty($oSpecs->specsEngine->tailLength) ? $oSpecs->specsEngine->tailLength : false;
		$engineTank				= !empty($oSpecs->specsEngine->tank) ? $oSpecs->specsEngine->tank : false;
		$engineTankCapacity		= !empty($oSpecs->specsEngine->tankCapacity) ? $oSpecs->specsEngine->tankCapacity : false;
		$engineWeightDry		= !empty($oSpecs->specsEngine->weightDry) ? $oSpecs->specsEngine->weightDry : false;

		/* Specs: trailer */
		$lengthContainer		= !empty($oSpecs->specsTrailer->lengthContainer) ? $oSpecs->specsTrailer->lengthContainer : false;
		$lengthAdz 				= !empty($oSpecs->specsTrailer->lengthAdz) ? $oSpecs->specsTrailer->lengthAdz : false;
		$widthContainer  		= !empty($oSpecs->specsTrailer->widthContainer) ? $oSpecs->specsTrailer->widthContainer : false;
		$heightLoadingPlatform  = !empty($oSpecs->specsTrailer->heightLoadingPlatform) ? $oSpecs->specsTrailer->heightLoadingPlatform : false;
		$heightCoupler  		= !empty($oSpecs->specsTrailer->heightCoupler) ? $oSpecs->specsTrailer->heightCoupler : false;
		$heightLadderRack  		= !empty($oSpecs->specsTrailer->heightLadderRack) ? $oSpecs->specsTrailer->heightLadderRack : false;
		$heightBorders   		= !empty($oSpecs->specsTrailer->heightBorders) ? $oSpecs->specsTrailer->heightBorders : false;
		$heightTotal   			= !empty($oSpecs->specsTrailer->heightTotal) ? $oSpecs->specsTrailer->heightTotal : false;
		$heightBasePlate    	= !empty($oSpecs->specsTrailer->heightBasePlate) ? $oSpecs->specsTrailer->heightBasePlate : false;
		$sizeTires   			= !empty($oSpecs->specsTrailer->sizeTires) ? $oSpecs->specsTrailer->sizeTires : false;
		$volume   				= !empty($oSpecs->specsTrailer->volume) ? $oSpecs->specsTrailer->volume : false;
		$color   				= !empty($oSpecs->specsTrailer->color) ? $oSpecs->specsTrailer->color : false;
		$brakes   				= !empty($oSpecs->specsTrailer->brakes) ? 'Ja' : false;
		$numberOfDoors    		= !empty($oSpecs->specsTrailer->numberOfDoors) ? $oSpecs->specsTrailer->numberOfDoors : false;
		$doorTypes    			= !empty($oSpecs->specsTrailer->doorTypes) ? ucfirst($oSpecs->specsTrailer->doorTypes) : false;
		$plug    				= !empty($oSpecs->specsTrailer->plug) ? $oSpecs->specsTrailer->plug : false;
		$kipAngle    			= !empty($oSpecs->specsTrailer->kipAngle) ? $oSpecs->specsTrailer->kipAngle : false;
		$axles    				= !empty($oSpecs->specsTrailer->axles) ? $oSpecs->specsTrailer->axles : false;
		$materialFloor     		= !empty($oSpecs->specsTrailer->materialFloor) ? $oSpecs->specsTrailer->materialFloor : false;
		$materialBorders     	= !empty($oSpecs->specsTrailer->materialBorders) ? $oSpecs->specsTrailer->materialBorders : false;
		$categoryAanhangwagen	= !empty($oSpecs->specsTrailer->category) ? $oSpecs->specsTrailer->category : false;
		
		/* Beds */
		$numberOfSleepingPlaces = !empty($oSpecs->beds->numberOfSleepingPlaces) ? $oSpecs->beds->numberOfSleepingPlaces : false;
		$numberOfBeds = !empty($oSpecs->beds->numberOfBeds) ? $oSpecs->beds->numberOfBeds : false;
		$rentalSpecs = 0;
		
		if($object->realm == 'boat') {
			$rentalSpecs = 0;
		}

		if(isset($oSpecs->rental) && $oSpecs->rental == true) {
			$rentalSpecs = 6;
			$sHTML .= !empty($priceHour) ? $this->is_value_set($priceHour, $this->getSingleTranslation('prijs_per_uur'), '', ' &euro;') : false;
			$sHTML .= $this->is_value_set($price3Hours, $this->getSingleTranslation('prijs_per_3_uur'),  '', ' &euro;');
			$sHTML .= $this->is_value_set($priceDayPart, $this->getSingleTranslation('prijs_per_dagdeel'),  '', ' &euro;');
			$sHTML .= $this->is_value_set($priceDay, $this->getSingleTranslation('prijs_per_dag'),  '', ' &euro;');
			$sHTML .= $this->is_value_set($priceWeek, $this->getSingleTranslation('prijs_vanaf'),  ' '.$this->getSingleTranslation('per_week').'', ' &euro;');
			$sHTML .= $this->is_value_set($priceWeekend, $this->getSingleTranslation('prijs_per_weekend'), '', ' &euro;');
			$sHTML .= $this->is_value_set($priceMonth, $this->getSingleTranslation('prijs_per_maand'), ' &euro;');
			$sHTML .= $this->is_value_set($deposit, $this->getSingleTranslation('borg'),  '', ' &euro;');
			$sHTML .= $this->is_value_set($noclaim, $this->getSingleTranslation('eigen_risico'),  '', ' &euro;');
		} else {
			$sHTML .= $this->build_detail_price_html($object);
			if(!empty($this->sShowShop) && !empty($object->shop) && !empty($object->shop->articleStatus)) {
				if(!empty($object->shop->articleDeeplink) && !empty($object->shop->articleDeeplink)) {
					$sHTML .= '<a class="ovis-ctabutton ovis-shop-knop" href="'.$object->shop->articleDeeplink.'" target="_blank">'.(!empty($this->sSessionData['sSettings']['settings']['texts']['label_koopknop'][$languageShort]) ? $this->sSessionData['sSettings']['settings']['texts']['label_koopknop'][$languageShort] : $this->sSessionData['sSettings']['settings']['koopknop_default'][$languageShort]).'</a>';
				}
			}
		}

		$sHTML .= $this->build_detail_links_html($object, $oUserData);
		
		if($object->realm == 'boat') {
			$specsArray = array(
				'constructionYear' 			=> array('languagekey'=>'bouwjaar','value' => $constructionYear, 'name' => 'Bouwjaar', 'extension' => '', 'currency' => '', 'type'=>''),
				'constructionMonth' 		=> array('languagekey'=>'bouwmaand','value' => $constructionMonth, 'name' => 'Bouwmaand', 'extension' => '', 'currency' => '', 'type'=>''),
                'condition' 				=> array('languagekey'=>'conditie','value' => $condition, 'name' => 'Conditie', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatLength' 				=> array('languagekey'=>'lengte','value' => $boatLength, 'name' => 'Lengte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'boatWidth' 				=> array('languagekey'=>'breedte','value' => $boatWidth, 'name' => 'Breedte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'boatHeadroom' 				=> array('languagekey'=>'stahoogte','value' => $boatHeadroom, 'name' => 'Stahoogte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'boatDraft' 				=> array('languagekey'=>'diepgang','value' => $boatDraft, 'name' => 'Diepgang', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'boatLocation' 				=> array('languagekey'=>'ligplaats','value' => $boatLocation, 'name' => 'Ligplaats', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatBeds' 					=> array('languagekey'=>'bedden','value' => $boatBeds, 'name' => 'Aantal bedden', 'extension' => ' bed(den)', 'currency' => '', 'type'=>''),
				'boatSleepingplaces' 		=> array('languagekey'=>'slaapplaatsen','value' => $boatSleepingplaces, 'name' => 'Slaapplaatsen', 'extension' => ' plaats(en)', 'currency' => '', 'type'=>''),
				'boatNumberOfSeats' 		=> array('languagekey'=>'zitplaatsen','value' => $boatNumberOfSeats, 'name' => 'Zitplaatsen', 'extension' => ' plaats(en)', 'currency' => '', 'type'=>''),
				'boatHullMaterial' 			=> array('languagekey'=>'romp materiaal','value' => $boatHullMaterial, 'name' => 'Romp materiaal', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatHullColor' 			=> array('languagekey'=>'romp kleur','value' => $boatHullColor, 'name' => 'Romp kleur', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatDeckColor' 			=> array('languagekey'=>'dek kleur','value' => $boatDeckColor, 'name' => 'Romp kleur', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatTrailerIncluded' 		=> array('languagekey'=>'trailer inclusief','value' => $boatTrailerIncluded, 'name' => 'Trailer inclusief', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatFastSailing' 			=> array('languagekey'=>'snelvarend','value' => $boatFastSailing, 'name' => 'Snelvarend', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatNumberOfEngines' 		=> array('languagekey'=>'aantal motoren','value' => $boatNumberOfEngines, 'name' => 'Aantal motoren', 'extension' => ' motor(en)', 'currency' => '', 'type'=>''),
				'boatEngineType' 			=> array('languagekey'=>'type motor','value' => $boatEngineType, 'name' => 'Type motor', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatEngineBrand' 			=> array('languagekey'=>'motor merk','value' => $boatEngineBrand, 'name' => 'Motor merk', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatEngineModel' 			=> array('languagekey'=>'motor model','value' => $boatEngineModel, 'name' => 'Motor model', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatEngineFuel' 			=> array('languagekey'=>'brandstof','value' => $boatEngineFuel, 'name' => 'brandstof', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatEngineTankCapacity' 	=> array('languagekey'=>'tankinhoud','value' => $boatEngineTankCapacity, 'name' => 'tankinhoud', 'extension' => ' liter', 'currency' => '', 'type'=>''),
				'boatEnginePower' 			=> array('languagekey'=>'vermogen','value' => $boatEnginePower, 'name' => 'vermogen', 'extension' => ' pk', 'currency' => '', 'type'=>''),
				'boatEngineBattery' 		=> array('languagekey'=>'accu','value' => $boatEngineBattery, 'name' => 'accu', 'extension' => '', 'currency' => '', 'type'=>''),
				'boatEngineRunHours' 		=> array('languagekey'=>'draaiuren','value' => $boatEngineRunHours, 'name' => 'draaiuren', 'extension' => ' uur', 'currency' => '', 'type'=>''),
				'boatEngineCruisingSpeed' 	=> array('languagekey'=>'kruissnelheid','value' => $boatEngineCruisingSpeed, 'name' => 'kruissnelheid', 'extension' => ' knopen', 'currency' => '', 'type'=>''),

				'engineSize' 				=> array('languagekey'=>'motorgrootte','value' => $engineSize, 'name' => 'motorgrootte', 'extension' => '', 'currency' => '', 'type'=>''),
				'engineFuel'				=> array('languagekey'=>'brandstof','value' => $engineFuel, 'name' => 'brandstof', 'extension' => '', 'currency' => '', 'type'=>''),
				'engineNumberOfCylinders'	=> array('languagekey'=>'cilinders','value' => $engineNumberOfCylinders, 'name' => 'cilinders', 'extension' => '', 'currency' => '', 'type'=>''),
				'enginePower'				=> array('languagekey'=>'vermogen','value' => $enginePower, 'name' => 'vermogen', 'extension' => ' pk', 'currency' => '', 'type'=>''),
				'engineStartSystem'			=> array('languagekey'=>'startsysteem','value' => $engineStartSystem, 'name' => 'startsysteem', 'extension' => '', 'currency' => '', 'type'=>''),
				'engineSteering'			=> array('languagekey'=>'sturen','value' => $engineSteering, 'name' => 'sturen', 'extension' => '', 'currency' => '', 'type'=>''),
				'engineTailLength'			=> array('languagekey'=>'staartlengte','value' => $engineTailLength, 'name' => 'staartlengte', 'extension' => '', 'currency' => '', 'type'=>''),
				'engineTank'				=> array('languagekey'=>'tank','value' => $engineTank, 'name' => 'tank', 'extension' => ' ', 'currency' => '', 'type'=>''),
				'engineTankCapacity'		=> array('languagekey'=>'tankinhoud','value' => $engineTankCapacity, 'name' => 'tankinhoud', 'extension' => ' L', 'currency' => '', 'type'=>''),
				'engineWeightDry'			=> array('languagekey'=>'drooggewicht','value' => $engineWeightDry, 'name' => 'drooggewicht', 'extension' => ' kg', 'currency' => '', 'type'=>''),
			);
		} else {
			$specsArray = array(
				'constructionYear' 		=> array('languagekey'=>'bouwjaar','value' => $constructionYear, 'name' => 'Bouwjaar', 'extension' => '', 'currency' => '', 'type'=>''),
				'constructionMonth' 	=> array('languagekey'=>'bouwmaand','value' => $constructionMonth, 'name' => 'Bouwmaand', 'extension' => '', 'currency' => '', 'type'=>''),
                'mileage' 				=> array('languagekey'=>'kilometerstand','value' => $this->clean_number($mileage), 'name' => 'Kilometerstand', 'extension' => ' km', 'currency' => '', 'type'=>''),
                
				'nap' 					=> array('languagekey'=>'nap','value' => $nap, 'name' => 'nap', 'extension' => '', 'currency' => '', 'type'=>''),
				'condition' 			=> array('languagekey'=>'conditie','value' => $condition, 'name' => 'Conditie', 'extension' => '', 'currency' => '', 'type'=>''),
				'carBrand' 				=> array('languagekey'=>'automerk','value' => $carBrand, 'name' => 'Automerk', 'extension' => '', 'currency' => '', 'type'=>''),
				'transmission' 			=> array('languagekey'=>'transmissie','value' => $transmission, 'name' => 'Transmissie', 'extension' => '', 'currency' => '', 'type'=>''),
				'engineHorsePower' 		=> array('languagekey'=>'vermogen','value' => $engineHorsePower, 'name' => 'Vermogen', 'extension' => ' pk', 'currency' => '', 'type'=>''),
				'datePart1a' 			=> array('languagekey'=>'datum_deel_1a','value' => $datePart1a, 'name' => 'Datum 1e toelating', 'extension' => '', 'currency' => '', 'type'=>'date'),
				'fuel' 					=> array('languagekey'=>'brandstof','value' => $fuel, 'name' => 'Brandstof', 'extension' => '', 'currency' => '', 'type'=>''),
				'weightEmpty' 			=> array('languagekey'=>'leegewicht','value' => $this->clean_number($weightEmpty), 'name' => 'Leeggewicht', 'extension' => ' kg', 'currency' => '', 'type'=>''),
				'weightMaximum' 		=> array('languagekey'=>'max_toelaatbaar_gewicht','value' => $this->clean_number($weightMaximum), 'name' => 'Max. toelaatbaar gewicht', 'extension' => ' kg', 'currency' => '', 'type'=>''),
				'weightOperational' 	=> array('languagekey'=>'rijklaar_gewicht','value' => $this->clean_number($weightOperational), 'name' => 'Rijklaar gewicht', 'extension' => ' kg', 'currency' => '', 'type'=>''),
				'capacity' 				=> array('languagekey'=>'laadvermogen','value' => $this->clean_number($capacity), 'name' => 'Laadvermogen', 'extension' => ' kg', 'currency' => '', 'type'=>''),
				'numberOfSleepingPlaces'=> array('languagekey'=>'aantal_slaapplaatsen','value' => $this->clean_number($numberOfSleepingPlaces), 'name' => 'Aantal slaapplaatsen', 'extension' => '', 'currency' => '', 'type'=>''),
				'numberOfSeats'			=> array('languagekey'=>'zitplaatsen','value' => $this->clean_number($camperSeats), 'name' => 'Zitplaatsen', 'extension' => '', 'currency' => '', 'type'=>''),
				'numberOfSeatbelts'		=> array('languagekey'=>'gordelzitplaatsen','value' => $this->clean_number($camperSeatbelts), 'name' => 'Gordelplaatsen', 'extension' => '', 'currency' => '', 'type'=>''),
				'modelYear' 			=> array('languagekey'=>'modeljaar','value' => $modelYear, 'name' => 'Modeljaar', 'extension' => '', 'currency' => '', 'type'=>''),
				'demo' 					=> array('languagekey'=>'demovoertuig','value' => $demo, 'name' => 'Demovoertuig', 'extension' => '', 'currency' => '', 'type'=>''),
				'damaged' 				=> array('languagekey'=>'schadevoertuig','value' => $damaged, 'name' => 'Schadevoertuig', 'extension' => '', 'currency' => '', 'type'=>''),
				'exRental' 				=> array('languagekey'=>'ex_verhuur','value' => $exRental, 'name' => 'Ex verhuur', 'extension' => '', 'currency' => '', 'type'=>''),
				'lengthConstruction' 	=> array('languagekey'=>'opbouw_lengte','value' => $this->clean_number($lengthConstruction), 'name' => 'Opbouw lengte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'lengthTotal' 			=> array('languagekey'=>'lengte','value' => $this->clean_number($lengthTotal), 'name' => 'Lengte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'width' 				=> array('languagekey'=>'breedte','value' => $this->clean_number($width), 'name' => 'Breedte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'height' 				=> array('languagekey'=>'hoogte','value' => $this->clean_number($height), 'name' => 'Hoogte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'headroom' 				=> array('languagekey'=>'stahoogte','value' => $this->clean_number($headroom), 'name' => 'Stahoogte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'wallsCaravan' 			=> array('languagekey'=>'wanden','value' => $wallsCaravan, 'name' => 'Wanden', 'extension' => '', 'currency' => '', 'type'=>''),
				'wallsColorCaravan' 	=> array('languagekey'=>'kleur_wanden','value' => $wallsColorCaravan, 'name' => 'Kleur wanden', 'extension' => '', 'currency' => '', 'type'=>''),
				'category' 				=> array('languagekey'=>'type','value' => $category, 'name' => 'Type', 'extension' => '', 'currency' => '', 'type'=>''),
				'categoryAanhangwagen'	=> array('languagekey'=>'type','value' => $categoryAanhangwagen, 'name' => 'Type', 'extension' => '', 'currency' => '', 'type'=>''),
				'wallsCamper' 			=> array('languagekey'=>'wanden','value' => $wallsCamper, 'name' => 'Wanden', 'extension' => '', 'currency' => '', 'type'=>''),
				'wallsColorCamper' 		=> array('languagekey'=>'kleur_wanden','value' => $wallsColorCamper, 'name' => 'Kleur wanden', 'extension' => '', 'currency' => '', 'type'=>''),
				'euroclassCamper' 		=> array('languagekey'=>'euro_klasse','value' => $euroclassCamper, 'name' => 'Euro klasse', 'extension' => '', 'currency' => '', 'type'=>''),
				'materialMobileHome' 	=> array('languagekey'=>'materiaal','value' => $materialMobileHome, 'name' => 'Materiaal', 'extension' => '', 'currency' => '', 'type'=>''),
				'materialTentTrailer' 	=> array('languagekey'=>'materiaal','value' => $materialTentTrailer, 'name' => 'Materiaal', 'extension' => '', 'currency' => '', 'type'=>''),
				'lengthContainer' 		=> array('languagekey'=>'lengte_bak','value' => $this->clean_number($lengthContainer), 'name' => 'Lengte bak (binnenwerk)', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'lengthAdz' 			=> array('languagekey'=>'dissel_lengte','value' => $this->clean_number($lengthAdz), 'name' => 'Dissel lengte', 'extension' => '', 'currency' => ' cm', 'type'=>''),
				'widthContainer' 		=> array('languagekey'=>'breedte_bak','value' => $this->clean_number($widthContainer), 'name' => 'Breedte bak (binnenwerk)', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'heightLoadingPlatform' => array('languagekey'=>'laadvloerhoogte','value' => $this->clean_number($heightLoadingPlatform), 'name' => 'Laadvloerhoogte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'heightCoupler' 		=> array('languagekey'=>'koppelingshoogte','value' => $this->clean_number($heightCoupler), 'name' => 'Koppelingshoogte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'heightLadderRack' 		=> array('languagekey'=>'voorrek_hoogte','value' => $this->clean_number($heightLadderRack), 'name' => 'Voorrek hoogte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'heightBorders' 		=> array('languagekey'=>'hoogte_borden_wanden','value' => $this->clean_number($heightBorders), 'name' => 'Hoogte borden/wanden', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'heightTotal' 			=> array('languagekey'=>'totale_hoogte','value' => $this->clean_number($heightTotal), 'name' => 'Totale hoogte (incl. rek)', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'heightBasePlate' 		=> array('languagekey'=>'inwendige_hoogte','value' => $this->clean_number($heightBasePlate), 'name' => 'Inwendige hoogte', 'extension' => ' cm', 'currency' => '', 'type'=>''),
				'sizeTires' 			=> array('languagekey'=>'bandenmaat','value' => $sizeTires, 'name' => 'Bandenmaat', 'extension' => ' in', 'currency' => '', 'type'=>''),
				'volume' 				=> array('languagekey'=>'inhoud','value' => $this->clean_number($volume), 'name' => 'Inhoud', 'extension' => ' m3', 'currency' => '', 'type'=>''),
				'color' 				=> array('languagekey'=>'kleur','value' => $color, 'name' => 'Kleur', 'extension' => '', 'currency' => '', 'type'=>''),
				'brakes' 				=> array('languagekey'=>'geremd','value' => $brakes, 'name' => 'Geremd', 'extension' => '', 'currency' => '', 'type'=>''),
				'numberOfDoors' 		=> array('languagekey'=>'aantal_deuren','value' => $numberOfDoors, 'name' => 'Aantal deuren', 'extension' => '', 'currency' => '', 'type'=>''),
				'doorTypes' 			=> array('languagekey'=>'type_deur','value' => $doorTypes, 'name' => 'Type deur(en)', 'extension' => '', 'currency' => '', 'type'=>''),
				'plug' 					=> array('languagekey'=>'stekker','value' => $plug, 'name' => 'Stekker', 'extension' => '-polig', 'currency' => '', 'type'=>''),
				'kipAngle' 				=> array('languagekey'=>'kip_hoek','value' => $kipAngle, 'name' => 'Kip-hoek', 'extension' => '', 'currency' => '', 'type'=>''),
				'materialFloor' 		=> array('languagekey'=>'materiaal_bodem','value' => $materialFloor, 'name' => 'Materiaal bodem', 'extension' => '', 'currency' => '', 'type'=>'', 'type'=>''),
				'materialBorders' 		=> array('languagekey'=>'materiaal_borden_wanden','value' => $materialBorders, 'name' => 'Materiaal borden/wanden', 'extension' => '', 'currency' => '', 'type'=>'')
			);
		}
		
		$countSpecs = 0;
		
		/*
		 * If parameter specification = open, then we show all the specifications at once
		 */
		$maxSpecs = ($this->sShowMoreSpecifications == 'open' ? 100 : 8 - $rentalSpecs);
		
		foreach($specsArray as $key => $spec) {

			if($spec['value']) {

				if($countSpecs == $maxSpecs) {
					$sHTML .= '<div id="ovis-detail-specifications-expanded-wrapper" 
						class="hidden-specs" 
						data-morespecs="0" 
						aria-expanded="false" 
						data-ovis-expanded="0" 
						style="display: none;">';
				}

				$sName = $spec['name'];
				
				if(strtolower($sName) == 'nap'){
					if(empty($spec['value'])){
						continue;
					}
				}

				if($this->getSingleTranslation($spec['languagekey'])) {
					$sName = $this->getSingleTranslation($spec['languagekey']);
				}

				$oddRow = $this->iCountSpecsColor % 2 == 0 ? true : false; 
				
				$sHTML .= $this->is_value_set($this->translate($spec['value']), $sName, $spec['extension'], $spec['currency'], $spec['type'], $oddRow);
				$countSpecs++;
			}
		}

		if($this->sShowMoreSpecifications === 'closed' && $countSpecs > $maxSpecs) {
			$sHTML .= '</div>

			<button type="button" 
				id="ovis-expand-detail-specs-button" 
				aria-expanded="false" 
				aria-controls="ovis-filters-expanded-wrapper" 
				data-ovis-expand-button="1" 
				data-ovis-detail-cta-button="expandSpecs">
				<svg xmlns="http://www.w3.org/2000/svg" 
					width="20px" 
					height="20px" 
					class="ovis-expand-form-button__icon ovis-expand-form-button__icon--plus" 
					aria-hidden="true" 
					viewBox="0 -960 960 960" 
					fill="#1f1f1f">
					<path d="M440-440H200v-80h240v-240h80v240h240v80H520v240h-80v-240Z"/>
				</svg>
				<svg xmlns="http://www.w3.org/2000/svg" 
					width="20px" 
					height="20px" 
					class="ovis-expand-form-button__icon ovis-expand-form-button__icon--minus" 
					aria-hidden="true" 
					style="display:none;" 
					viewBox="0 -960 960 960" 
					fill="#1f1f1f">
					<path d="M200-440v-80h560v80H200Z"/>
				</svg>
				<span class="ovis-expand-form-button__label"><span data-ovis-translation-key="Meer" class="js-ovis-translatable-text">Meer</span> <span data-ovis-translation-key="specificaties" class="js-ovis-translatable-text">specificaties</span></span>
			</button>';
		}

		if($this->bHasTradeInProposalEnabled || $this->bHasEmail || (!empty($object->userId) && !empty($this->sCompanyName) && !empty($this->sUserCity) && (isset($object->clientUserCount) && $object->clientUserCount > 1)) || ($oSpecs->rental > 0)) {
			$sHTML .= '<div class="ovis-row-extra">';
		}

		$sHTML .= '<script>
			var txtOVISPopupInfo = \''.$this->getSingleTranslation('verhuur_aanvraag_info').'\';	
			var txtOVISVerhuuraanvraag = \''.$this->getSingleTranslation('verhuur_aanvragen').'\';
			var txtOVISUwGegevens = \''.$this->getSingleTranslation('uw_gegevens').'\';	
			var txtOVISGewenstePeriode = \''.$this->getSingleTranslation('gewenste_periode').'\';	
			var txtOVISInruilvoorstel = \''.$this->getSingleTranslation('inruilvoorstel_aanvragen').'\';	
			var txtOVISEmailAdverteerder = \''.$this->getSingleTranslation('email_adverteerder').'\';
			var txtOVISEmailUs = \''.$this->getSingleTranslation('email_ons').'\';
			var txtOVISWatWiltUInruilen = \''.$this->getSingleTranslation('wat_wilt_u_inruilen').'\';	
			var txtOVISCaravan = \''.$this->getSingleTranslation('caravan').'\';	
			var txtOVISKampeerauto = \''.$this->getSingleTranslation('kampeerauto').'\';	
			var txtOVISOverig = \''.$this->getSingleTranslation('overig').'\';	
			var txtOVISMerk = \''.$this->getSingleTranslation('merk').'\';	
			var txtOVISModel = \''.$this->getSingleTranslation('model_type').'\';	
			var txtOVISIndication = \''.$this->getSingleTranslation('prijs_indicatie').'\';	
			var txtOVISBouwjaar = \''.$this->getSingleTranslation('bouwjaar').'\';	
			var txtOVISContitie = \''.$this->getSingleTranslation('conditie').'\';	
			var txtOVISNieuwstaat = \''.$this->getSingleTranslation('nieuwstaat').'\';	
			var txtOVISZeerGoed = \''.$this->getSingleTranslation('zeer_goed').'\';	
			var txtOVISGoed = \''.$this->getSingleTranslation('goed').'\';	
			var txtOVISRedelijk = \''.$this->getSingleTranslation('redelijk').'\';	
			var txtOVISSlecht = \''.$this->getSingleTranslation('slecht').'\';	
			var txtOVISZeerSlecht = \''.$this->getSingleTranslation('zeer_slecht').'\';	
			var txtOVISSchade = \''.$this->getSingleTranslation('schade').'\';	
			var txtOVISSchadevrij = \''.$this->getSingleTranslation('schadevrij').'\';	
			var txtOVISJa = \''.$this->getSingleTranslation('ja').'\';	
			var txtOVISNeeOmschrijving = \''.$this->getSingleTranslation('nee_omschrijving').'\';	
			var txtOVISStaatBanden = \''.$this->getSingleTranslation('staat_banden').'\';	
			var txtOVISStaatBekleding = \''.$this->getSingleTranslation('staat_bekleding').'\';	
			var txtOVISNaam = \''.$this->getSingleTranslation('naam').'\';	
			var txtOVISEmailadres = \''.$this->getSingleTranslation('emailadres').'\';	
			var txtOVISContactPerson = \''.$this->getSingleTranslation('contactpersoon').'\';
			var txtOVISTelefoonnummer = \''.$this->getSingleTranslation('telefoonnummer').'\';	
			var txtOVISDate = \''.$this->getSingleTranslation('gewenste_datum').'\';	
			var txtOVISTime = \''.$this->getSingleTranslation('gewenste_tijd').'\';	
			var txtOVISMeer = \''.$this->getSingleTranslation('meer').'\';	
			var txtOVISMinder = \''.$this->getSingleTranslation('minder').'\';	
			var txtOVISOmschrijving = \''.$this->getSingleTranslation('omschrijving').'\';	
			var txtOVISOmschrijvingVerhuur = \''.(!empty($this->sSessionData['sSettings']['settings']['texts']['label_verhuuropmerking'][$languageShort]) ? $this->sSessionData['sSettings']['settings']['texts']['label_verhuuropmerking'][$languageShort] : $this->sSessionData['sSettings']['settings']['rental_opmerking_default'][$languageShort]).'\';
			var txtOVISBericht = \''.$this->getSingleTranslation('bericht').'\';	
			var txtOVISFoutief = \''.$this->getSingleTranslation('vul_foutief_in').'\';	
			var txtOVISFoutVerzenden = \''.$this->getSingleTranslation('fout_bij_verzenden').'\';	
			var txtOVISAanvraagVerzonden = \''.$this->getSingleTranslation('aanvraag_succesvol_verzonden').'\';	
			var txtOVISBerichtVerzonden = \''.$this->getSingleTranslation('bericht_succesvol_verzonden').'\';	
			var txtOVISSluiten = \''.$this->getSingleTranslation('sluiten').'\';	
			var txtOVISVersturen = \''.$this->getSingleTranslation('versturen').'\';	
			var txtOVISAanvragen = \''.$this->getSingleTranslation('aanvragen').'\';	
			var txtOVISBerichtBedankt = \''.$this->getSingleTranslation('bericht_bedankt').'\';	
			var txtOVISAanvraagBedankt = \''.$this->getSingleTranslation('aanvraag_bedankt').'\';
			var txtOVISAdres = \''.$this->getSingleTranslation('adres').'\';	
			var txtOVISHuisnummer = \''.$this->getSingleTranslation('huisnummer').'\';	
			var txtOVISPostcode = \''.$this->getSingleTranslation('postcode').'\';	
			var txtOVISPlaats = \''.$this->getSingleTranslation('plaats').'\';
			var txtOVISVan = \''.$this->getSingleTranslation('van').'\';	
			var txtOVISTot = \''.$this->getSingleTranslation('tot').'\';	
			var txtOVISPersoon = \''.$this->getSingleTranslation('persoon').'\';	
			var txtOVISPersonen = \''.$this->getSingleTranslation('personen').'\';	
			var txtOVISAfhaaltijd = \''.$this->getSingleTranslation('gewenste afhaaltijd').'\';	
			var txtOVISPeriode = \''.$this->getSingleTranslation('huurperiode').'\';
		</script>';

		if(isset($object->specifications->rental) && $object->specifications->rental > 0 && !empty($this->bRentalActive)) {
			$sHTML .= '<div class="ovis-row cta"><button class="ovis-open-verhuurform ovis-ctabutton" data-ovis-detail-cta-button="openRentalForm"><i class="faovis faovis-retweet" aria-hidden="true"></i> '.(!empty($this->sSessionData['sSettings']['settings']['texts']['label_verhuuraanvraag'][$languageShort]) ? $this->sSessionData['sSettings']['settings']['texts']['label_verhuuraanvraag'][$languageShort] : $this->sSessionData['sSettings']['settings']['rental_button_default'][$languageShort]).'</button></div>';
			$sHTML .= $this->build_detail_rental_form($object->id, 1, $title);
		}

		if($this->bHasTradeInProposalEnabled && ($object->specifications->rental == 0 || empty($this->bRentalActive))) {
			$sHTML .= '<div class="ovis-row cta"><button class="ovis-open-inruilform ovis-ctabutton" data-ovis-detail-cta-button="openTradeInForm" onclick="showOvisInruilvoorstel(\''.$object->id.'\',\''.$object->userId.'\',true); return false"><i class="fasovis faovis-exchange-alt" aria-hidden="true"></i><span data-ovis-translation-key="Inruilvoorstel" class="js-ovis-translatable-text">Inruilvoorstel</span></button></div>';
			$sHTML .= $this->build_detail_trade_in_form($object->id, 1, $title);
		}
		
		if(empty($this->sCallToAction) || (is_array($this->sCallToAction) && in_array('mail',$this->sCallToAction))) {
			if($this->bHasEmail) {
				$sHTML .= '<div class="ovis-row cta"><button class="ovis-open-contactform ovis-ctabutton" data-ovis-detail-cta-button="openContactForm"><i class="faovis faovis-envelope" aria-hidden="true"></i><span data-ovis-translation-key="Mail ons" class="js-ovis-translatable-text">Mail ons</span></button></div>';
				$sHTML .= $this->build_detail_contact_form($object->id, 1, $title);
			}
			if($this->sPhoneNumber) {
				$sHTML .= '<div class="ovis-row cta"><a class="ovis-whatsapp ovis-ctabutton" href="https://wa.me/' . preg_replace('/\D/', '', $this->sPhoneNumber) . '?text=' . urlencode('Ik ben geïnteresseerd in uw aangeboden' . ' \''.trim($title).'\'') . '"><i class="fabovis faovis-whatsapp" aria-hidden="true"></i>WhatsApp</a></div>';
			}
		}

		if($oUserData->phone) {
			$sHTML .= '<div class="ovis-row cta"><a href="tel:'.$oUserData->phone.'" class="ovis-phonenumber ovis-ctabutton"><i class="faovis faovis-phone" aria-hidden="true"></i>'.$oUserData->phone.'</a></div>';
		}
		
		/* stel een vraag */
		if(!empty($object->userId) && !empty($this->sCompanyName) && !empty($this->sUserCity) && (isset($object->clientUserCount) && $object->clientUserCount > 1)) {
			$sCompanyName = $this->sCompanyName;
			$sCompanyName .= !empty($this->sUserCity) ? ' te '.$this->sUserCity : false;
			$sHTML .= '<div class="ovis-row cta"><button class="ovis-show-usercontent ovis-ctabutton" data-ovis-detail-cta-button="showUserListing" data-ovis-attr-user-id="'.$object->userId.'" data-ovis-attr-forward-url="'.home_url().'/'.$this->sPageName.'/'.'"><i class="faovis faovis-th-large" aria-hidden="true"></i><span data-ovis-translation-key="Toon aanbod" class="js-ovis-translatable-text">Toon aanbod</span></button></div>';
		}
		
		if($this->bHasTradeInProposalEnabled || $this->bHasEmail || (!empty($object->userId) && !empty($this->sCompanyName) && !empty($this->sUserCity) && (isset($object->clientUserCount) && $object->clientUserCount > 1))) {
			$sHTML .= '</div>';
		}
		
		if($object->mediainfo->pdf) {
			if($object->mediainfo->pdf->enabled && $object->mediainfo->pdf->url) {
				$sHTML .= '<a class="ovis-download-attachment js-ovis-translatable-title" target="_blank" href="' . $object->mediainfo->pdf->url . '" title="Download PDF' . (($object->mediainfo->pdf->title) ? ': ' . $object->mediainfo->pdf->title : false) . '"><i class="faovis faovis-download" aria-hidden="true"></i>'.(!empty($object->mediainfo->pdf->title) ? '<span data-ovis-translation-key="Download" class="js-ovis-translatable-text">Download</span> <span data-ovis-translation-key="'.$object->mediainfo->pdf->title.'" class="js-ovis-translatable-text">'.$object->mediainfo->pdf->title.'</span>' : '<span data-ovis-translation-key="Download bijlage" class="js-ovis-translatable-text">Download bijlage</span>').'</a>';
			}
		}

		return $sHTML;
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $object
	 * @return string
	 */
	private function build_detail_price_html($object) {

		if(empty($object)) {
			return '';
		}

		$oSpecs = isset($object->specifications) ? $object->specifications : null;

		if(empty($oSpecs)) {
			return '';
		}

		$sHTML = '';
		$bIsArchive = $object->status != 'active' ? true : false;

		if(isset($oSpecs->rental) && $oSpecs->rental == true) {

			$category = !empty($oSpecs->category) ? $oSpecs->category : false;
			
			if($category == 'trailer') {
				$priceRental = !empty($oSpecs->pricesRental->price3Hours) ? $this->clean_price($oSpecs->pricesRental->price3Hours) : false;
				$sPiceLabel = ' <span class="rental-label">(<span data-ovis-translation-key="per 3 uur" class="js-ovis-translatable-text">per 3 uur</span>)</span>';
			} else {
				$priceRental = !empty($oSpecs->pricesRental->priceWeek) ? $this->clean_price($oSpecs->pricesRental->priceWeek) : false;
				$sPiceLabel = ' <span class="rental-label">(<span data-ovis-translation-key="week" class="js-ovis-translatable-text">week</span>)</span>';
			}

			if($priceRental) {
				$sHTML = '<div class="ovis-row price rental">
					<div class="priceTo"><span data-ovis-translation-key="Verhuurprijs" class="js-ovis-translatable-text">Verhuurprijs</span> <span data-ovis-translation-key="vanaf" class="js-ovis-translatable-text">vanaf</span><strong>&euro; ' . $priceRental . '</strong>'.$sPiceLabel.'</div>
				</div>';
			}
		} else {
			$priceFrom 	= !empty($oSpecs->prices->retail) ? $this->clean_price($oSpecs->prices->retail) : false;
			$priceTo 	= !empty($oSpecs->prices->price) ? $this->clean_price($oSpecs->prices->price) : false;			$showPriceAsFrom = false;			
			
			$showPriceAsFrom = false;
			if(!empty($oSpecs->prices->showAsFromPrice)) {
				$showPriceAsFrom = true;
			}
			
			$sVat = isset($oSpecs->prices->vat) ? $oSpecs->prices->vat : null;
			$sBtwMessage = null;

			if(!empty($sVat) && !empty($this->bShowBtwMarge)) {
				switch(strtolower(trim($sVat))) {

					case 'inclusief':
						$sBtwMessage = 'Inclusief btw';
						break;

					case 'exclusief':
						$sBtwMessage = 'Exclusief btw';
						break;

					case 'marge':
						$sBtwMessage = 'Marge';
						break;
				}
			}

			$sBtwMessageHtml = !empty($sBtwMessage) ? ' <span class="btw_message">(<span data-ovis-translation-key="'.$sBtwMessage.'" class="js-ovis-translatable-text">'.$sBtwMessage.'</span>)</span>' : '';

			if(empty($priceTo) && empty($object->specifications->sold)) {
				$object->specifications->prices->display = 'request';
			} elseif(!empty($priceFrom) && !empty($priceTo) && empty($object->specifications->sold) && $object->specifications->prices->display != 'request') {
				$object->specifications->prices->display = 'retail';
			} elseif($object->specifications->sold > 0 && $object->specifications->category == 'trailer') {
				$object->specifications->prices->display = 'sold';
			} elseif($object->specifications->sold > 0) {
				$object->specifications->prices->display = 'soldprice';
			}

			if(!empty($bIsArchive)) {
				$object->specifications->prices->display = 'sold';
			}

			if(!empty($object->translations) && !empty($this->sShowPrices)) {
				$sPriceLanguage = getOVISTranslation($this->sShowPrices);
				if(isset($object->translations->{$sPriceLanguage})) {
					$oTranslatedPrices = $object->translations->{$sPriceLanguage};
					if(!empty($oTranslatedPrices->price_from) && !empty($oTranslatedPrices->price)) {
						$object->specifications->prices->display = 'retail';
						$priceFrom = $oTranslatedPrices->price_from;
						$priceTo = $oTranslatedPrices->price;
					} elseif(!empty($oTranslatedPrices->price)) {
						$object->specifications->prices->display = 'default';
						$priceTo = $oTranslatedPrices->price;
					} else {
						$object->specifications->prices->display = 'request';
					}
				}
			}

			if(!empty($object->specifications->reserved)) {
				$object->specifications->prices->display = 'reserved';
			}
			
			switch($object->specifications->prices->display) {

				case 'retail':
					$sHTML = '<div class="ovis-row price retail">';
						$sHTML .= '<div class="priceFrom"><span data-ovis-translation-key="Van" class="js-ovis-translatable-text">Van</span><strong>&euro; ' . $priceFrom . '</strong></div>';

						$sHTML .= '<div class="priceTo'.(!empty($sBtwMessage) ? ' doublePrice' : false ).'">';
						
						if(!empty($showPriceAsFrom)) {
							$sHTML .= '<span data-ovis-translation-key="Vanaf" class="js-ovis-translatable-text">Vanaf</span>';
						} else {
							$sHTML .= '<span data-ovis-translation-key="Voor" class="js-ovis-translatable-text">Voor</span>';
						}
						
						$sHTML .= '<strong>&euro; ' . $priceTo . $sBtwMessageHtml .'</strong></div>';
					$sHTML .= '</div>';
					break;

				case 'request':
					$sHTML = '<div class="ovis-row price request singlePrice">
						<div class="priceTo"><span>&nbsp;</span><strong><span data-ovis-translation-key="Prijs op aanvraag" class="js-ovis-translatable-text">Prijs op aanvraag</span></strong></div>
					</div>';
					break;

				case 'reserved':
					$sHTML = '<div class="ovis-row price request">
						<div class="priceTo"><span data-ovis-translation-key="Dit item is" class="js-ovis-translatable-text">Dit item is</span> <strong><span data-ovis-translation-key="gereserveerd" class="js-ovis-translatable-text">gereserveerd</span></strong></div>
					</div>';
					break;

				case 'sold':
					$sHTML = '<div class="ovis-row price request singlePrice">
						<div class="priceTo"><span>&nbsp;</span><strong><span data-ovis-translation-key="Verkocht" class="js-ovis-translatable-text">Verkocht</span></strong></div>
					</div>';
					break;

				case 'soldprice':
					$sHTML = '<div class="ovis-row price soldprice singlePrice">
						<div class="priceTo"><span>&nbsp;</span><strong><span data-ovis-translation-key="Verkocht" class="js-ovis-translatable-text">Verkocht</span></strong></div>
					</div>';
					break;

				default:
					$sHTML = '<div class="ovis-row price">
						<div class="priceTo'.(!empty($sBtwMessage) ? ' doublePrice' : false ).'">';
						$sHTML .= '<span data-ovis-translation-key="Verkoopprijs" class="js-ovis-translatable-text">Verkoopprijs</span>';
						if(!empty($showPriceAsFrom)) {
							$sHTML .= ' <span data-ovis-translation-key="Vanaf" class="js-ovis-translatable-text">Vanaf</span>';
						}
						$sHTML .= '<strong>&euro; ' . $priceTo . ',- ' . $sBtwMessageHtml .'</strong></div>
					</div>';
			}
		}

		return $sHTML;
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $presentationId
	 * @return void
	 */
	private function build_detail_contact_form($presentationId, $userId, $title) {
		ob_start(); ?>
			<dialog class="ovis-dialog" data-ovis-form="contact">

                <div class="ovis-dialog__inner">
                    
                    <button class="ovis-dialog__close-button js-ovis-translatable-title js-ovis-translatable-aria-label js-ovis-capitalize-text" 
                        type="button" 
                        title="Sluit formulier" 
                        aria-label="Sluit formulier" 
						data-ovis-translation-key="Sluit formulier" 
						data-ovis-dialog-close="1">
                        <svg xmlns="http://www.w3.org/2000/svg" 
                            class="dialog-close-button__icon" 
                            width="24px" 
                            height="24px" 
                            aria-hidden="true" 
                            viewBox="0 -960 960 960" 
                            fill="#5f6368">
                            <path d="m256-200-56-56 224-224-224-224 56-56 224 224 224-224 56 56-224 224 224 224-56 56-224-224-224 224Z"/>
                        </svg>
                    </button>

                    <h1 class="ovis-dialog__title"><span data-ovis-translation-key="Email ons" class="js-ovis-translatable-text">Email ons</span></h1>

                    <div class="ovis-dialog__body">
						
                        <form action="" method="post" 
							id="ovis-contactform-<?php echo $presentationId; ?>" 
							class="ovis-form ovis-contactform contact-aanbieder" 
							data-ovis-form-action="contactDealer" 
							data-ovis-form-presentation="<?php echo $presentationId; ?>" 
							data-ovis-form-user="<?php echo $userId; ?>" 
							autocomplete="off">

                            <div class="ovis-form__overlay ovis-form__overlay--inactive">
                                <span class="ovis-form__loader"></span>
                            </div>

							<div id="ovis-send-response" class="ovis-send-response ovis-form__result"></div>

                            <input type="hidden" id="form_action" name="form_action" value="contact-aanbieder">
                            <input type="hidden" id="ovis-contact-user" name="ovis-contact-user" value="<?php echo $userId; ?>">
                            <input type="hidden" id="ovis-contact-object" name="ovis-contact-object" value="<?php echo $presentationId; ?>">
                            <input type="hidden" id="ovis-contact-objecturl" name="ovis-contact-objecturl" value="<?php echo $this->sCurrentUrl; ?>">
							<input type="hidden" id="ovis-contact-utm-source" name="ovis-contact-utm-source" value="ovis-wordpress-plugin">
							<input type="hidden" id="ovis-contact-utm-campaign" name="ovis-contact-utm-campaign" value="<?php echo trim($title); ?>">
							<input type="hidden" id="ovis-contact-utm-content" name="ovis-contact-utm-content" value="contact">

							<div class="ovis-form__body">
								<label for="ovis-contact-name"><span data-ovis-translation-key="Naam" class="js-ovis-translatable-text">Naam</span><span class="ovis-form__required-star">*</span></label>
								<input type="text" id="ovis-contact-name" class="ovis-cta-form__input--name inputSmall ovis-contact-name txt-input" maxlength="100" name="ovis-contact-name" value="" placeholder="" autocomplete="off">
								
								<label for="ovis-contact-phone"><span data-ovis-translation-key="Telefoonnummer" class="js-ovis-translatable-text">Telefoonnummer</span><span class="ovis-form__required-star">*</span></label>
								<input type="text" id="ovis-contact-phone" class="ovis-cta-form__input--phone ovis-contact-phone txt-input" name="ovis-contact-phone" maxlength="15" value="" placeholder="" autocomplete="off">
								
								<label for="ovis-contact-sender"><span data-ovis-translation-key="Emailadres" class="js-ovis-translatable-text">Emailadres</span><span class="ovis-form__required-star">*</span></label>
								<input type="text" id="ovis-contact-sender" class="ovis-cta-form__input--email ovis-contact-sender txt-input" name="ovis-contact-email" value="" placeholder="" autocomplete="off">
								
								<label for="ovis-contact-message"><span data-ovis-translation-key="Bericht" class="js-ovis-translatable-text">Bericht</span></label>
								<textarea type="text" id="ovis-contact-message" name="ovis-contact-message" class="ovis-cta-form__input--message" placeholder=""></textarea>
							</div>

                            <div class="ovis-form__cta-buttons">
                                <button type="button" 
									id="ovis-aanvragen-<?php echo $presentationId; ?>" 
									class="ovis-form__cta-button ovis-form__cta-button--submit" 
									data-ovis-form-submit="1"><span data-ovis-translation-key="Aanvragen" class="js-ovis-translatable-text">Aanvragen</span></button>
                                <button type="button" 
									class="ovis-form__cta-button ovis-form__cta-button--cancel js-ovis-translatable-title" 
									title="Sluit formulier" 
									data-ovis-translation-key="Sluit formulier" 
									data-ovis-dialog-close="1"><span data-ovis-translation-key="Sluiten" class="js-ovis-translatable-text">Sluiten</span></button>
                            </div>

                        </form>

                    </div>
                </div>
            </dialog>
		<?php
		return ob_get_clean();
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $presentationId
	 * @return void
	 */
	private function build_detail_trade_in_form($presentationId, $userId, $title) {
		$currentYear = date('Y');
        $startYear = $currentYear - 50;
        $yearOptions = '';
        
        for($index = $currentYear; $index >= $startYear; $index--) {
            $yearOptions .= '<option value="'.$index.'">'.$index.'</option>';
        }

		ob_start(); ?>
			<dialog class="ovis-dialog" data-ovis-form="tradein">

                <div class="ovis-dialog__inner">
                
                    <button class="ovis-dialog__close-button js-ovis-translatable-title js-ovis-translatable-aria-label js-ovis-capitalize-text" 
                        type="button" 
                        title="Sluit formulier" 
                        aria-label="Sluit formulier" 
						data-ovis-translation-key="Sluit formulier" 
						data-ovis-dialog-close="1">
                        <svg xmlns="http://www.w3.org/2000/svg" 
                            class="dialog-close-button__icon" 
                            width="24px" 
                            height="24px" 
                            aria-hidden="true" 
                            viewBox="0 -960 960 960" 
                            fill="#5f6368">
                            <path d="m256-200-56-56 224-224-224-224 56-56 224 224 224-224 56 56-224 224 224 224-56 56-224-224-224 224Z"/>
                        </svg>
                    </button>

                    <h1 class="ovis-dialog__title"><span data-ovis-translation-key="Inruilvoorstel aanvragen" class="js-ovis-translatable-text">Inruilvoorstel aanvragen</span></h1>
                    
                    <div class="ovis-dialog__body">

						<form action="" method="post" 
							id="ovis-contactform-<?php echo $presentationId; ?>" 
							class="ovis-form ovis-contactform inruil-voorstel" 
							data-ovis-form-action="tradeInRequest" 
							data-ovis-form-presentation="<?php echo $presentationId; ?>" 
							data-ovis-form-user="<?php echo $userId; ?>" 
							autocomplete="off">
                            
                            <div class="ovis-form__overlay ovis-form__overlay--inactive">
								<span class="ovis-form__loader"></span>
                            </div>

							<div id="ovis-send-response" class="ovis-send-response ovis-form__result"></div>

                            <input type="hidden" id="form_action" name="form_action" value="inruil-voorstel">
                            <input type="hidden" id="ovis-contact-user" name="ovis-contact-user" value="<?php echo $userId; ?>">
                            <input type="hidden" id="ovis-contact-object" name="ovis-contact-object" value="<?php echo $presentationId; ?>">
                            <input type="hidden" id="ovis-contact-objecturl" name="ovis-contact-objecturl" value="<?php echo $this->sCurrentUrl; ?>">
							<input type="hidden" id="ovis-contact-utm-source" name="ovis-contact-utm-source" value="ovis-wordpress-plugin">
							<input type="hidden" id="ovis-contact-utm-campaign" name="ovis-contact-utm-campaign" value="<?php echo trim($title); ?>">
							<input type="hidden" id="ovis-contact-utm-content" name="ovis-contact-utm-content" value="tradein">

							<div class="ovis-form__body">
								<select id="ovis-contact-soort" class="ovis-cta-form__input--category ovis-contact-soort" name="ovis-contact-soort" onchange="showHideOvisField(this);">
									<option value="nb"><span data-ovis-translation-key="Wat wilt u inruilen" class="js-ovis-translatable-text">Wat wilt u inruilen</span></option>
									<option value="caravan"><span data-ovis-translation-key="Caravan" class="js-ovis-translatable-text">Caravan</span></option>
									<option value="kampeerauto"><span data-ovis-translation-key="Kampeerauto" class="js-ovis-translatable-text">Kampeerauto</span></option>
									<option value="overig"><span data-ovis-translation-key="Overig" class="js-ovis-translatable-text">Overig</span></option>
								</select>
	
								<input type="text" id="ovis-contact-merk" class="ovis-cta-form__input--brand ovis-contact-merk" maxlength="100" name="ovis-contact-merk" value="" maxlength="50" placeholder="Merk">
								<input type="text" id="ovis-contact-model" class="ovis-cta-form__input--model ovis-contact-model" maxlength="100" name="ovis-contact-model" value="" maxlength="50" placeholder="Model type">
	
								<select id="ovis-contact-bouwjaar" class="ovis-cta-form__input--construction-year ovis-contact-bouwjaar" name="ovis-contact-bouwjaar">
									<option value="0"><span data-ovis-translation-key="Bouwjaar" class="js-ovis-translatable-text">Bouwjaar</span></option>
									<?php echo $yearOptions; ?>
								</select>
								
								<select id="ovis-contact-conditie" class="ovis-cta-form__input--condition ovis-contact-conditie" name="ovis-contact-conditie">
									<option value="nb"><span data-ovis-translation-key="Conditie" class="js-ovis-translatable-text">Conditie</span></option>
									<option value="nieuwstaat"><span data-ovis-translation-key="Nieuwstaat" class="js-ovis-translatable-text">Nieuwstaat</span></option>
									<option value="goed"><span data-ovis-translation-key="Goed" class="js-ovis-translatable-text">Goed</span></option>
									<option value="redelijk"><span data-ovis-translation-key="Redelijk" class="js-ovis-translatable-text">Redelijk</span></option>
									<option value="schade"><span data-ovis-translation-key="Schade" class="js-ovis-translatable-text">Schade</span></option>
								</select>
								
								<select id="ovis-contact-schade" class="ovis-cta-form__input--damage ovis-contact-schade" name="ovis-contact-schade">
									<option value="nb"><span data-ovis-translation-key="Schadevrij" class="js-ovis-translatable-text">Schadevrij</span></option>
									<option value="ja"><span data-ovis-translation-key="Ja" class="js-ovis-translatable-text">Ja</span></option>
									<option value="nee"><span data-ovis-translation-key="Nee omschrijving" class="js-ovis-translatable-text">Nee</span></option>
								</select>
	
								<select id="ovis-contact-staatbekleding" class="ovis-cta-form__input--upholstery ovis-contact-staatbekleding" name="ovis-contact-staatbekleding">
									<option value="nb"><span data-ovis-translation-key="Staat bekleding" class="js-ovis-translatable-text">Staat bekleding</span></option>
									<option value="zeer goed">5. <span data-ovis-translation-key="Zeer goed" class="js-ovis-translatable-text">Zeer goed</span></option>
									<option value="goed">4. <span data-ovis-translation-key="Goed" class="js-ovis-translatable-text">Goed</span></option>
									<option value="redelijk">3. <span data-ovis-translation-key="Redelijk" class="js-ovis-translatable-text">Redelijk</span></option>
									<option value="slecht">2. <span data-ovis-translation-key="Slecht" class="js-ovis-translatable-text">Slecht</span></option>
									<option value="zeer slecht">1. <span data-ovis-translation-key="Zeer slecht" class="js-ovis-translatable-text">Zeer slecht</span></option>
								</select>
							
								<select id="ovis-contact-staatbanden" class="ovis-cta-form__input--tires ovis-contact-staatbanden" name="ovis-contact-staatbanden">
									<option value="nb"><span data-ovis-translation-key="Staat banden" class="js-ovis-translatable-text">Staat banden</span></option>
									<option value="zeer goed">5. <span data-ovis-translation-key="Zeer goed" class="js-ovis-translatable-text">Zeer goed</span></option>
									<option value="goed">4. <span data-ovis-translation-key="Goed" class="js-ovis-translatable-text">Goed</span></option>
									<option value="redelijk">3. <span data-ovis-translation-key="Redelijk" class="js-ovis-translatable-text">Redelijk</span></option>
									<option value="slecht">2. <span data-ovis-translation-key="Slecht" class="js-ovis-translatable-text">Slecht</span></option>
									<option value="zeer slecht">1. <span data-ovis-translation-key="Zeer slecht" class="js-ovis-translatable-text">Zeer slecht</span></option>
								</select>
	
								<input type="text" id="ovis-contact-kenteken" class="ovis-cta-form__input--license-plate ovis-contact-kenteken ovis-specific hideInruilInput" maxlength="100" name="ovis-contact-kenteken" value="" maxlength="15" placeholder="Kenteken">
								<input type="text" id="ovis-contact-kilometerstand" class="ovis-cta-form__input--mileage ovis-contact-kilometerstand ovis-specific hideInruilInput" maxlength="10" name="ovis-contact-kilometerstand" value="" placeholder="Kilometerstand">
	
								<?php if(!$this->bIsTradeInImageDisabled) { ?>
									<div id="ovis-image-uploads"></div>
	
									<input type="hidden" name="ovis-required-image" value="<?php echo $this->bIsTradeInImageRequired ? 'yes' : 'no'; ?>">
	
									<div id="ovis-images" class="ovis-cta-form__input--images dropzone dropzone-queue">
	
										<div class="dropzone-panel">
											<a class="dropzone-select"><span data-ovis-translation-key="Afbeeldingen" class="js-ovis-translatable-text">Afbeeldingen</span> <span data-ovis-translation-key="bijvoegen" class="js-ovis-translatable-text">bijvoegen</span></a>
											<a class="dropzone-remove-all"><span data-ovis-translation-key="Verwijder alles" class="js-ovis-translatable-text">Verwijder alles</span></a>
										</div>
	
										<div class="dropzone-items">
	
											<div class="dropzone-item" style="display:none;">
	
												<div class="dropzone-file">
													<div class="dropzone-filename" title="">
														<span data-dz-name></span>
														<strong>(<span data-dz-size></span>)</strong>
													</div>
												</div>
	
												<div class="dropzone-progress">
													<div class="progress">
														<div class="progress-bar"
															role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0" data-dz-uploadprogress>
														</div>
													</div>
												</div>
	
												<div class="dropzone-toolbar">
													<span class="dropzone-delete" data-dz-remove><i class="bi bi-x fs-1"></i></span>
												</div>
	
											</div>
	
										</div>
									</div>
									<span class="ovis-images-notice">Max <span data-ovis-translation-key="bestandsgrootte" class="js-ovis-translatable-text">bestandsgrootte</span> <span data-ovis-translation-key="is" class="js-ovis-translatable-text">is</span> 5MB en max aantal bestanden is 5.</span>
									<span class="ovis-images-notice"><?php echo $this->bIsTradeInImageRequired ? 'Ten minste 1 foto is vereist.' : 'Foto\'s zijn optioneel.'; ?></span>
								<?php } ?>
	
								<div class="ovis-form__group">
									<h4 class="ovis-form-group__title ovis-excerpt-text"><span data-ovis-translation-key="Uw gegevens" class="js-ovis-translatable-text">Uw gegevens</span></h4>
									
									<label for="ovis-contact-name"><span data-ovis-translation-key="Naam" class="js-ovis-translatable-text">Naam</span></label>
									<input type="text" id="ovis-contact-name" class="ovis-cta-form__input--name ovis-contact-name" maxlength="100" name="ovis-contact-name" value="" placeholder="" autocomplete="off">
									
									<label for="ovis-contact-phone"><span data-ovis-translation-key="Telefoonnummer" class="js-ovis-translatable-text">Telefoonnummer</span></label>
									<input type="text" id="ovis-contact-phone" class="ovis-cta-form__input--phone ovis-contact-phone" name="ovis-contact-phone" maxlength="15" value="" placeholder="" autocomplete="off">
									
									<label for="ovis-contact-sender"><span data-ovis-translation-key="Emailadres" class="js-ovis-translatable-text">Emailadres</span></label>
									<input type="text" id="ovis-contact-sender" class="ovis-cta-form__input--email ovis-contact-sender" name="ovis-contact-email" value="" placeholder="" autocomplete="off">

									<label><span data-ovis-translation-key="Omschrijving" class="js-ovis-translatable-text">Omschrijving</span></label>
									<textarea type="text" id="ovis-contact-message" name="ovis-contact-message" class="ovis-cta-form__input--message" placeholder=""></textarea>
								</div>	
							</div>
                        
                            <div class="ovis-form__cta-buttons">
                                <button type="button" 
									id="ovis-aanvragen-<?php echo $presentationId; ?>" 
									class="ovis-form__cta-button ovis-form__cta-button--submit" 
									data-ovis-form-submit="1"><span data-ovis-translation-key="Aanvragen" class="js-ovis-translatable-text">Aanvragen</span></button>
                                <button type="button" 
									class="ovis-form__cta-button ovis-form__cta-button--cancel js-ovis-translatable-title" 
									title="Sluiten" 
									data-ovis-translation-key="Sluit formulier" 
									data-ovis-dialog-close="1"><span data-ovis-translation-key="Sluiten" class="js-ovis-translatable-text">Sluiten</span></button>
                            </div>

                        </form>

                    </div>
                </div>
            </dialog>
		<?php
		return ob_get_clean();
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $presentationId
	 * @return void
	 */
	private function build_detail_rental_form($presentationId, $userId, $title) {
		$languageShort = substr($this->sLanguage, 0, 2);
		ob_start(); ?>
			<dialog class="ovis-dialog" data-ovis-form="rental">

                <div class="ovis-dialog__inner">
                
                    <button class="ovis-dialog__close-button js-ovis-translatable-title js-ovis-translatable-aria-label js-ovis-capitalize-text" 
                        type="button" 
                        title="Sluit formulier" 
                        aria-label="Sluit formulier" 
						data-ovis-translation-key="Sluit formulier" 
						data-ovis-dialog-close="1">
                        <svg xmlns="http://www.w3.org/2000/svg" 
                            class="dialog-close-button__icon" 
                            width="24px" 
                            height="24px" 
                            aria-hidden="true" 
                            viewBox="0 -960 960 960" 
                            fill="#5f6368">
                            <path d="m256-200-56-56 224-224-224-224 56-56 224 224 224-224 56 56-224 224 224 224-56 56-224-224-224 224Z"/>
                        </svg>
                    </button>

                    <h1 class="ovis-dialog__title"><span data-ovis-translation-key="Verhuur aanvragen" class="js-ovis-translatable-text">Verhuur aanvragen</span></h1>
                    
                    <div class="ovis-dialog__body">

						
						<form action="" method="post" 
							id="ovis-contactform-<?php echo $presentationId; ?>" 
							class="ovis-form ovis-contactform verhuur-aanvraag" 
							data-ovis-form-action="rentalRequest" 
							data-ovis-form-presentation="<?php echo $presentationId; ?>" 
							data-ovis-form-user="<?php echo $userId; ?>" 
							autocomplete="off">
							
							<div class="ovis-form__overlay ovis-form__overlay--inactive">
								<span class="ovis-form__loader"></span>
							</div>

							<div id="ovis-send-response" class="ovis-send-response ovis-form__result"></div>

                            <input type="hidden" id="form_action" name="form_action" value="verhuur-aanvraag">
                            <input type="hidden" id="ovis-contact-user" name="ovis-contact-user" value="<?php echo $userId; ?>">
                            <input type="hidden" id="ovis-contact-object" name="ovis-contact-object" value="<?php echo $presentationId; ?>">
                            <input type="hidden" id="ovis-contact-objecturl" name="ovis-contact-objecturl" value="<?php echo $this->sCurrentUrl; ?>">
							<input type="hidden" id="ovis-contact-utm-source" name="ovis-contact-utm-source" value="ovis-wordpress-plugin">
							<input type="hidden" id="ovis-contact-utm-campaign" name="ovis-contact-utm-campaign" value="<?php echo trim($title); ?>">
							<input type="hidden" id="ovis-contact-utm-content" name="ovis-contact-utm-content" value="rental-request">

							<div class="ovis-form__body">
								
								<label><span data-ovis-translation-key="Gewenste periode" class="js-ovis-translatable-text">Gewenste periode</span><span class="ovis-form__required-star">*</span></label>
								<div class="ovis-form__input-group ovis-form__input-group--split">
									<input type="text" autocomplete="off" id="ovis-contact-periode" name="ovis-contact-periode" 
										class="ovis-cta-form__input--date ovis-contact-periode js-ovis-translatable-placeholder" 
										maxlength="100" 
										value="" 
										placeholder="Van / tot" 
										data-ovis-translation-key="Van / tot">
								</div>
								
								<select id="ovis-contact-persons" class="ovis-cta-form__input--persons ovis-contact-persons" name="ovis-contact-persons">
									<option value="nb"><span data-ovis-translation-key="Personen" class="js-ovis-translatable-text">Personen</span></option>
									<option value="1">1 <span data-ovis-translation-key="persoon" class="js-ovis-translatable-text">persoon</span></option>
									<option value="2">2 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="3">3 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="4">4 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="5">5 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="6">6 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="7">7 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="8">8 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="9">9 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
									<option value="10">10 <span data-ovis-translation-key="personen" class="js-ovis-translatable-text">personen</span></option>
								</select>
	
								<div class="ovis-form__group">
									<h4 class="ovis-form-group__title ovis-excerpt-text"><span data-ovis-translation-key="Uw gegevens" class="js-ovis-translatable-text">Uw gegevens</span></h4>
		
									<label><span data-ovis-translation-key="Naam" class="js-ovis-translatable-text">Naam</span></label>
									<input type="text" autocomplete="off" id="ovis-contact-name" class="ovis-cta-form__input--name inputSmall ovis-contact-name txt-input" maxlength="100" name="ovis-contact-name" value="" placeholder="" autocomplete="off">
									
									<label><span data-ovis-translation-key="Adres" class="js-ovis-translatable-text">Adres</span> / <span data-ovis-translation-key="Huisnummer" class="js-ovis-translatable-text">Huisnummer</span><span class="ovis-form__required-star">*</span></label>
									<div class="ovis-form__input-group ovis-form__input-group--75-25">
										<input type="text" autocomplete="off" id="ovis-contact-adres" class="ovis-cta-form__input--address ovis-contact-adres split75 txt-input" name="ovis-contact-adres" maxlength="15" value="" placeholder="" autocomplete="off">
										<input type="text" autocomplete="off" id="ovis-contact-housenumber" class="ovis-cta-form__input--house-number ovis-contact-housenumber split25 txt-input" name="ovis-contact-housenumber" value="" placeholder="" autocomplete="off">
									</div>
									
									<label><span data-ovis-translation-key="Postcode" class="js-ovis-translatable-text">Postcode</span> / <span data-ovis-translation-key="Plaats" class="js-ovis-translatable-text">Plaats</span><span class="ovis-form__required-star">*</span></label>
									<div class="ovis-form__input-group ovis-form__input-group--25-75">
										<input type="text" autocomplete="off" id="ovis-contact-zipcode" class="ovis-cta-form__input--zipcode ovis-contact-zipcode split25 txt-input" name="ovis-contact-zipcode" maxlength="15" value="" placeholder="" autocomplete="off">
										<input type="text" autocomplete="off" id="ovis-contact-city" class="ovis-cta-form__input--city ovis-contact-city split75 txt-input" name="ovis-contact-city" value="" placeholder="">
									</div>
									
									<label><span data-ovis-translation-key="Telefoonnummer" class="js-ovis-translatable-text">Telefoonnummer</span><span class="ovis-form__required-star">*</span></label>
									<input type="text" autocomplete="off" id="ovis-contact-phone" class="ovis-cta-form__input--phone ovis-contact-phone split50 txt-input" name="ovis-contact-phone" maxlength="15" value="" placeholder="" autocomplete="off">
									
									<label><span data-ovis-translation-key="Emailadres" class="js-ovis-translatable-text">Emailadres</span><span class="ovis-form__required-star">*</span></label>
									<input type="text" autocomplete="off" id="ovis-contact-sender" class="ovis-cta-form__input--email ovis-contact-sender split50 txt-input" name="ovis-contact-email" value="" placeholder="" autocomplete="off">

									<label><span data-ovis-translation-key="<?php echo (!empty($this->sSessionData['sSettings']['settings']['texts']['label_verhuuropmerking'][$languageShort]) ? $this->sSessionData['sSettings']['settings']['texts']['label_verhuuropmerking'][$languageShort] : $this->sSessionData['sSettings']['settings']['rental_opmerking_default'][$languageShort]); ?>" class="js-ovis-translatable-text"><?php echo (!empty($this->sSessionData['sSettings']['settings']['texts']['label_verhuuropmerking'][$languageShort]) ? $this->sSessionData['sSettings']['settings']['texts']['label_verhuuropmerking'][$languageShort] : $this->sSessionData['sSettings']['settings']['rental_opmerking_default'][$languageShort]); ?></span></label>
									<textarea type="text" id="ovis-contact-message" name="ovis-contact-message" class="ovis-cta-form__input--message" placeholder=""></textarea>
								</div>
							</div>
                            
                            <div class="ovis-form__cta-buttons">
                                <button id="ovis-aanvragen-<?php echo $presentationId; ?>" 
									class="ovis-form__cta-button ovis-form__cta-button--submit" 
									data-ovis-form-submit="1"><span data-ovis-translation-key="Aanvragen" class="js-ovis-translatable-text">Aanvragen</span></button>
                                <button type="button" 
									class="ovis-form__cta-button ovis-form__cta-button--cancel js-ovis-translatable-title" 
									title="Sluit formulier" 
									data-ovis-translation-key="Sluit formulier" 
									data-ovis-dialog-close="1"><span data-ovis-translation-key="Sluiten" class="js-ovis-translatable-text">Sluiten</span></button>
                            </div>

                        </form>

                    </div>
                </div>
            </dialog>
		<?php
		return ob_get_clean();
	}


	private function translate($value) {
		
		if(!(is_array($this->aLanguageConfig))) return $value;
		
		$searchValue = sha1(strtolower(str_replace(array(' ','/'),array('_','_'),trim($value))));
		
		if(array_key_exists($searchValue, $this->aLanguageConfig)) {
			$value = stripcslashes($this->aLanguageConfig[$searchValue]);
		}

		return $value;
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $category
	 * @param boolean $skipLanguageConfig
	 * @return void
	 */
	private function translate_category($category, $skipLanguageConfig=false) {

		switch($category) {

			case 'camper':
				if(!empty($skipLanguageConfig)) {
					$category = "Kampeerauto";
				} else {
					$category = ucfirst($this->getSingleTranslation('kampeerauto'));
				}
				break;

			case 'mobilehome':
				if(!empty($skipLanguageConfig)) {
					$category = "Stacaravan";
				} else {
					$category = ucfirst($this->getSingleTranslation('stacaravan'));	
				}
				break;

			case 'tenttrailer':
				if(!empty($skipLanguageConfig)) {
					$category = "Vouwwagen";
				} else {
					$category = ucfirst($this->getSingleTranslation('vouwwagen'));
				}
				break;

			case 'engine':
				if(!empty($skipLanguageConfig)) {	
					$category = "Motor";
				} else {
					$category = ucfirst($this->getSingleTranslation('motor'));
				}
				break;

			case 'boat':
				if(!empty($skipLanguageConfig)) {
					$category = "Boot";
				} else {
					$category = ucfirst($this->getSingleTranslation('boot'));
				}
				break;

			case 'boattrailer':
				if(!empty($skipLanguageConfig)) {
					$category = "Boottrailer";
				} else {
					$category = ucfirst($this->getSingleTranslation('boottrailer'));
				}
				break;

			case 'trailer':
				if($this->sRealm == 'boten') {
					if(!empty($skipLanguageConfig)) {
						$category = "Boottrailer";
					} else {
						$category = ucfirst($this->getSingleTranslation('boottrailer'));
					}
				} else {
					if(!empty($skipLanguageConfig)) {
						$category = "Aanhangwagen";
					} else {
						$category = ucfirst($this->getSingleTranslation('aanhangwagen'));
					}
				}
				break;

			default:
				$category = ucfirst($this->getSingleTranslation('caravan'));
		}

		return $category;
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $object
	 * @param boolean $skipLanguageConfig
	 * @return void
	 */
	private function clean_object_url($object, $skipLanguageConfig=false) {

		$brand = (!empty($object->specifications->brand) ? "-" . $object->specifications->brand : false);

		$model = (!empty($object->specifications->model) ? "-" . $object->specifications->model : false);

		$version = (!empty($object->specifications->version) ? "-" . $object->specifications->version : false);

		$titleSuffix = (!empty($object->specifications->titleSuffix) ? "-" . $object->specifications->titleSuffix : false);

		$titleRaw = !empty($object->specifications->titleManual) ? $object->specifications->titleManual : $object->specifications->title;

		$title = str_replace(array('(',')','/',',','?','!','&'), array('','','-','','','',''), $titleRaw);

		$title = preg_replace('!\s+!', ' ', $title);

		$sComposedTitle		= trim(strtolower($brand . ' ' . $model . ' ' . $version . '' . $titleSuffix));

		$sComposedTitle		= preg_replace('!\s+!', ' ', $sComposedTitle);

		$sComposedTitle 	= str_replace(array('(',')',','), array('','',''), $sComposedTitle);

		if(trim(strtolower($title)) == preg_replace('!\s+!', ' ', $sComposedTitle)) {
			$title =  $brand . ' ' . $model . ' ' . $version;
		} else {
			$title = '-' . $title;
		}

		$title = str_replace('/', '-', $title);

		$sTralingSlash = false;

		$sPermalink = get_permalink();

		$aPermalink = explode('?', $sPermalink);

		$sNewPermalink = '';

		foreach($aPermalink as $sLinkPart) {
			if(empty($sNewPermalink)) {
				$sNewPermalink = $sLinkPart;
			}
		}

		$permaLinkLast = substr($sNewPermalink, -1);

		if($permaLinkLast != '/') {
			$sTralingSlash = '/';
		}		

		if(!empty($this->sDeeplink)) {

			$sDeeplinkTralingSlash = false;

			$sDeeplinkLast = substr($this->sDeeplink, -1);

			if($sDeeplinkLast != '/') {
				$this->sDeeplink = $this->sDeeplink.'/';
			}
		}

		$title = strtolower($title);
		
		$searchArray  = array(' ','.',',','!','/','--','\\','\'','"',':','+','|','(',')','@','#','=','*');
		$replaceArray = array('-','-' ,'' ,'' ,'_','-' ,''  ,''  ,'' ,'','' ,'' ,'' ,'' ,'' ,'' ,'','');

		$title = str_replace($searchArray,$replaceArray,$title);

		$title = preg_replace('/p.*ssl/', 'possl', $title);

		$title = preg_replace('/citro.*n/', 'citroen', $title);

		$title = preg_replace('/b.*rstner/', 'burstner', $title);
		
		$sUrl = strtolower(str_replace(' ', '-', $sTralingSlash.$this->sDeeplink.'details/' . $this->translate_category($object->specifications->category,$skipLanguageConfig) . '/' . $object->id . $title . '.html'));

		$sUrl = str_replace(array('--', '-.html', '-_-', '%80'),array('-', '.html', '-', ''), $sUrl);
		$sUrl = preg_replace('/-+/', '-', $sUrl);

		return $sUrl;
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $number
	 * @return void
	 */
	public function clean_number($number) {
		return number_format($number, 0, ",", ".");
	}


	/**
	 * Undocumented function
	 *
	 * @param [type] $price
	 * @return void
	 */
	public function clean_price($price) {
		return number_format((int) $price / 100, 0, ",", ".");
	}


	/**
	 * Check if given value is a date
	 *
	 * @param mixed $value
	 * @return boolean
	 */
	public function check_if_value_is_date($value=false) {
		
		if(empty($value) || is_numeric($value)) {
			return false;
		}

		if(date('Y-m-d', strtotime($value)) == $value) {
			return true;
		}

		return false;
	}


	public function is_value_set($value, $name, $extension, $currency = NULL, $type = false , $oddRow = false) {
		$valueShow = $value;
		$nameShow = $name;
		if(!empty($this->aHideSpecs) && in_array(strtolower($name), $this->aHideSpecs)) {
			return false;
		}
		if($value == '' || ($type == 'date' && $value == '0000-00-00')) {
			
			if($type == 'date') {
				return false;
			}
			
			$value = false;
			$valueShow = false;
		}
		if(strtolower($name) == 'nap'){
			
			$valueShow = '<img alt="NAP" style="width: 50px; display: inline-block; vertical-align: middle; margin-left: 5px;" title="NAP" src="data:image/svg+xml;base64,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" />';
			$valueShow = '';
			$nameShow = '';
			
		} else if(is_bool($value)) {
			$value = $value ? 'Ja' : 'Nee';
		} else if($this->check_if_value_is_date($value)) {
			$value = date('d-m-Y', strtotime($value));
			$valueShow = date('d-m-Y', strtotime($value));
		}
		$this->iCountSpecsColor++;

		
		$sHTML = '<div class="ovis-row'.($type == 'full' ? ' full-width' : false).''.($oddRow  === false ? false : ' oddRow').' ovis-row-spec-wrapper">
			<span class="ovis-row-spec-key"><span data-ovis-translation-key="'.ucfirst($name).'" class="js-ovis-translatable-text">'.ucfirst($nameShow).'</span></span>'.'<span class="ovis-row-spec-value">'.$currency.'<span data-ovis-translation-key="'.ucfirst($value).'" class="js-ovis-translatable-text">'.ucfirst($valueShow).'</span>&nbsp;'.$extension.'</span>
		</div>';
		return (($value) ? $sHTML : false);
	}


	/**
	 * Build sitemap
	 * 
	 * @return string
	 */
	public function build_sitemap($sPageURL=false, $oParameters=false) {
		if(empty($sPageURL)) return;
		
		global $wp_session;
		
		$this->sSessionData = !empty($wp_session['session_data']) ? $wp_session['session_data'] : false;
		
		$oData = new data($this->sSessionData['sSettings']);
		
		return $oData->getSitemap($sPageURL, $oParameters);
	}

}