<?php

/**
 * Determine language setting client
 */
$language = isset( $_SERVER['HTTP_ACCEPT_LANGUAGE'] ) ? substr( $_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2 ) : 'nl';

/**
 * Retrieve & store plugin information
 */
$filedata = get_file_data( plugin_dir_path( __FILE__ ) . '/../index.php', array(
	'plugin_name' => 'Plugin Name',	
	'version' => 'Version',	
	'release' => 'Release'
) );

if ( !defined( 'OVIS_PLUGIN_PATH' ) ) {
	$sPluginPath = plugin_dir_path( __FILE__ );
	define( 'OVIS_PLUGIN_PATH', dirname( $sPluginPath ) . '/' );
}

/**
 * Version of this OVIS plugin
 */
if ( !defined( 'OVIS_VERSION' ) ) define( 'OVIS_VERSION', $filedata['version'] );
if ( !defined( 'OVIS_RELEASE' ) ) define( 'OVIS_RELEASE', $filedata['release'] );

/**
 * Verify the absolute path
 */
defined( 'ABSPATH' ) or die( 'I don\'t like what you\'re doing.' );

/**
 * Initialize database connection
 */
function find_wp_config_path() {

	$dir = dirname( __FILE__ );

	do { 
		if( file_exists( $dir . '/wp-config.php' ) ) {
			return $dir;                    
		}            
	}

	while( $dir = realpath( "$dir/.." ) );
	
	return null;    
}

if ( !function_exists( 'add_action' ) ) { 
	require_once find_wp_config_path() . '/wp-config.php'; 
}

global $wpdb;

/**
 * Define constants: general
 */
if ( !defined('OVIS_PLUGIN_DEV_MODE' ) ) define( 'OVIS_PLUGIN_DEV_MODE', false );
if ( !defined('OVIS_DB_PREFIX' ) ) define( 'OVIS_DB_PREFIX', trim( $wpdb->base_prefix ) );
if ( !defined('OVIS_ALLOWED_CATEGORIES' ) ) define( 'OVIS_ALLOWED_CATEGORIES', 'caravan,kampeerauto,stacaravan,vouwwagen,aanhangwagen' );
if ( !defined('OVIS_ALLOWED_BOATCATEGORIES' ) ) define( 'OVIS_ALLOWED_BOATCATEGORIES', 'boot,motor,boottrailer' );
if ( !defined('OVIS_ALLOWED_LANGUAGES' ) ) define( 'OVIS_ALLOWED_LANGUAGES', 'system,nl,de,en,fr' );
if ( !defined('OVIS_REPOSITORY_URL' ) ) define( 'OVIS_REPOSITORY_URL', 'https://www.ovis.nl' );
if ( !defined('OVIS_DOMAIN_URL' ) ) define( 'OVIS_DOMAIN_URL', 'https://api.ovis.nl' );
if ( !defined('OVIS_PLUGIN_NAME' ) ) define( 'OVIS_PLUGIN_NAME', 'OVIS' );
if ( !defined('OVIS_PLUGIN_SLUG' ) ) define( 'OVIS_PLUGIN_SLUG', 'ovis' );
if ( !defined('OVIS_PRICE_RENTAL_STEP' ) ) define( 'OVIS_PRICE_RENTAL_STEP', 10 );
if ( !defined('OVIS_PRICE_STEP' ) ) define( 'OVIS_PRICE_STEP', 1000 );
if ( !defined('OVIS_WEIGHT_STEP' ) ) define( 'OVIS_WEIGHT_STEP', 100 );
if ( !defined('OVIS_POWER_STEP' ) ) define( 'OVIS_POWER_STEP', 10 );
if ( !defined('OVIS_LENGTH_STEP' ) ) define( 'OVIS_LENGTH_STEP', 100 );

/**
 * Define constants: images
 */
if ( !defined('OVIS_NOIMAGE_LARGE' ) ) define( 'OVIS_NOIMAGE_LARGE', plugin_dir_url( dirname(__FILE__) ) . 'assets/img/no-image-640x480.jpg' );
if ( !defined('OVIS_NOIMAGE_SMALL' ) ) define( 'OVIS_NOIMAGE_SMALL', plugin_dir_url( dirname(__FILE__) ) . 'assets/img/no-image-250x188.jpg' );

/**
 * Define constanst: pages
 */
if ( !defined('OVIS_PAGE_NAME_1' ) ) define( 'OVIS_PAGE_NAME_1', 'Informatie' );
if ( !defined('OVIS_PAGE_SLUG_1' ) ) define( 'OVIS_PAGE_SLUG_1', 'general' );
if ( !defined('OVIS_PAGE_NAME_2' ) ) define( 'OVIS_PAGE_NAME_2', 'Vormgeving' );
if ( !defined('OVIS_PAGE_SLUG_2' ) ) define( 'OVIS_PAGE_SLUG_2', 'design' );
if ( !defined('OVIS_PAGE_NAME_3' ) ) define( 'OVIS_PAGE_NAME_3', 'Integratie' );
if ( !defined('OVIS_PAGE_SLUG_3' ) ) define( 'OVIS_PAGE_SLUG_3', 'integration' );
if ( !defined('OVIS_PAGE_NAME_4' ) ) define( 'OVIS_PAGE_NAME_4', 'Instellingen' );
if ( !defined('OVIS_PAGE_SLUG_4' ) ) define( 'OVIS_PAGE_SLUG_4', 'settings' );
if ( !defined('OVIS_PAGE_NAME_5' ) ) define( 'OVIS_PAGE_NAME_5', 'Weergave' );
if ( !defined('OVIS_PAGE_SLUG_5' ) ) define( 'OVIS_PAGE_SLUG_5', 'appearance' );
if ( !defined('OVIS_PAGE_NAME_6' ) ) define( 'OVIS_PAGE_NAME_6', 'SEO' );
if ( !defined('OVIS_PAGE_SLUG_6' ) ) define( 'OVIS_PAGE_SLUG_6', 'seo' );

if ( !defined( 'OVIS_ROOT_PATH' ) ) define( 'OVIS_ROOT_PATH', plugin_dir_url( dirname(__FILE__) ) );

if ( !defined( 'OVIS_PLUGIN_CACHE_DIR_PATH' ) ) define( 'OVIS_PLUGIN_CACHE_DIR_PATH', path_join( ABSPATH, 'wp-content/cache/ovis/' ) );
if ( !defined( 'OVIS_PLUGIN_DIST_DIR_PATH' ) ) define( 'OVIS_PLUGIN_DIST_DIR_PATH', path_join( plugin_dir_path( dirname( __FILE__ ) ), 'dist' ) );
if ( !defined( 'OVIS_PLUGIN_DIR_PATH' ) ) define( 'OVIS_PLUGIN_DIR_PATH', plugin_dir_path( dirname( __FILE__ ) ) );
if ( !defined( 'OVIS_PLUGIN_DIR_URI' ) ) define( 'OVIS_PLUGIN_DIR_URI', plugin_dir_url( dirname( __FILE__ ) ) );

if ( !defined( 'OVIS_CSS_PATH' ) ) define( 'OVIS_CSS_PATH', OVIS_ROOT_PATH . 'assets/css/' );
if ( !defined( 'OVIS_JS_PATH' ) ) define( 'OVIS_JS_PATH', OVIS_ROOT_PATH . 'assets/js/' );

/**
 * Include necessary classes
 */
require_once plugin_dir_path( __FILE__ ) . '../classes/class.forms.php';
require_once plugin_dir_path( __FILE__ ) . '../classes/class.settings.php';
require_once plugin_dir_path( __FILE__ ) . '../classes/class.data.php';
require_once plugin_dir_path( __FILE__ ) . '../classes/class.output.php';

/**
 * Check for existing OVIS cache directory
 */
if( !file_exists( ABSPATH . 'wp-content/cache/ovis' ) ) {

	/**
	 * Create OVIS cache directory
	 */
	mkdir( ABSPATH . 'wp-content/cache/ovis', 0755, true );
}

/**
 * Initialize classes
 */
$oForms = new forms();
$oOutput = new output();