<?php
/**
 * helper-function for Ovis-plugin
 * 
 */

/**
 * main cron function
 * 
 * @return	void
 * 
 */
function ovis_deeplink_cron_exec(){

	global $wpdb;

	$oConnector = new ovis_deeplink($wpdb);
	$oConnector->parse();

	error_log('ovis_deeplink_cron_exec() was executed at ' . current_time('mysql'));

}

function ovis_deeplink_cron_schedule(){
	
	if (!wp_next_scheduled('ovis_deeplink_cron_hook')){
		
		wp_schedule_event(time(), 'daily', 'ovis_deeplink_cron_hook' );
		
	}
	
}

function ovis_deeplink_cron_unschedule(){
	
	$timestamp = wp_next_scheduled( 'ovis_deeplink_cron_hook');
  
	if ($timestamp){
		
		wp_unschedule_event( $timestamp, 'ovis_deeplink_cron_hook');
		
	}
	
}

function ovis_deeplink_after_update($upgrader_object, $options){

	if ($options['action'] === 'update' && $options['type'] === 'plugin'){

		$plugin = plugin_basename(__FILE__);

		if (isset($options['plugins']) && in_array($plugin, $options['plugins'], true)){

			wp_clear_scheduled_hook('ovis_deeplink_cron_hook');
			
			ovis_deeplink_cron_schedule();

		}
		
	}
	
}

