<?php

require plugin_dir_path(__FILE__) . '../include/inc_header.php';
require plugin_dir_path(__FILE__) . '../include/inc_menu.php';

$oForms->get_settings();

$sHTML = "
<section class='ovis-main integration-container'>

	<article>

		<h2 class='ovis-subtitle'>Integratie</h2>

		<div class='ovis-seperator'></div>

		<h4>Standaard weergave</h4>
		<p>Integreer de OVIS voorraad gemakkelijk door onderstaande shortcode te kopiëren:</p>
		<p class='ovis-shortcode'>[ovis-voorraad]</p>

		<div class='ovis-seperator'></div>

		<h4>Module</h4>
		<p>Bepaal welke module geladen dient te worden:</p>
		<p class='ovis-shortcode'>[ovis-voorraad module='ovis']</p>
		<p>Beschikbare modules zijn 'ovis' (<i>default</i>) en 'boten'.</p>
		
		<div class='ovis-seperator'></div>

		<h4>Categorie</h4>
		<p>Bepaal welke categorieën weergegeven worden in het overzicht:</p>
		<p class='ovis-shortcode'>[ovis-voorraad categorie='caravan, kampeerauto, stacaravan, vouwwagen, aanhangwagen']</p>
		<p>Beschikbaar in module ovis: <i>caravan, kampeerauto, stacaravan, vouwwagen, aanhangwagen</i></p>
		<p>Beschikbaar in module boten: <i>boot, motor, boottrailer</i></p>

		<div class='ovis-seperator'></div>

		<h4>Subcategorie</h4>
		<p>Bepaal welke subcategorieën weergegeven worden in het overzicht:</p>
		<p class='ovis-shortcode'>[ovis-voorraad subcategorie='alkoof, busmodel, dieplader, paardentrailer, sloepen, motorboten']</p>
		<p>De te gebruiken subcategorieën zijn afhankelijk van de beschikbare categorieën</p>
		<p>Beschikbaar in categorie kampeerauto: <i>alkoof, busmodel, half integraal, integraal, opzetunit</i></p>			
		<p>Beschikbaar in categorie aanhangwagen: <i>aanhanger, afschuifwagen, autotransporter, bagagewagen<span class='ovis-settings-show-more' id='button-ovis-more-aanhangwagen' onclick='jQuery.showMoreSettings(\"ovis-more-aanhangwagen\")'>&nbsp;...&nbsp;[toon meer]</span><span id='ovis-more-aanhangwagen' style='display:none;'>, bakwagen, betonmixer, boottrailer, bouwtrailer, brommobiel transport, compressor aanhanger, dieplader, dieplader bouwtransport, drankenopbouw, fietsaanhangwagen, gereedschapswagen, gesloten opbouw, glasaanhanger, glasresteelwagen, hondentrailer, hoogwerker, hout transport, huifwagen, jetskitrailer, kipper, kipper achterwaarts, kipper afrol, kipper afzet, kipper driezijdig, koeltransport, koetstrailer, machinetransporter, mega, motoraanhanger, multi transporter, paardentrailer, plateauwagen, platformtrailer, ponytrailer, reclameaanhanger, schaftwagen, schamelwagen, scootwagen, silo, speciale voertuigen, standaard, steigerwagen, tankopbouw, trilplaatwagen, veetrailer, verkoopaanhanger, wisselsysteem</span></i></p>
		<p>Beschikbaar in categorie boot: <i>catamaran, consoleboot, grachtenbootje, houseboat, jetski, kajuitboot<span class='ovis-settings-show-more' id='button-ovis-more-boot' onclick='jQuery.showMoreSettings(\"ovis-more-boot\")'>&nbsp;...&nbsp;[toon meer]</span><span id='ovis-more-boot' style='display:none;'>, klassieke motorboot, klassieke zeilboot, kruiser, motorboot, motorsailer, open zeilboot, platbodem, ponton, rib, rubberboot, skiboot, sloep, speedboot, sport cruiser, sportboot, tender, visboot, waterscooter, zeiljacht, zeilplatbodem, overig</span></i></p>
		<p>Beschikbaar in categorie motor: <i>binnenboord, buitenboord</i></p>
		<p>Beschikbaar in categorie boottrailer: <i>catamarantrailer, jetskitrailer, kielboottrailer, sloepentrailer<span class='ovis-settings-show-more' id='button-ovis-more-boottrailer' onclick='jQuery.showMoreSettings(\"ovis-more-boottrailer\")'>&nbsp;...&nbsp;[toon meer]</span><span id='ovis-more-boottrailer' style='display:none;'>, strandtrailer, zeilboottrailer, overige</span></i></p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Keyword</h4>
		<p>Bepaal selectie op basis van een keyword:</p>
		<p class='ovis-shortcode'>[ovis-voorraad keyword='keyword']</p>
		<p>Er zal worden gezocht in de volgende OVIS invoervelden: titel, omschrijving, bedrijfnaam, postcode en plaatsnaam</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Direct leverbaar</h4>
		<p>Bepaal of direct leverbare objecten getoond moeten worden (<i>default: inbegrepen</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad beschikbaar='inbegrepen, uitsluiten, isoleren']</p>
		<p><i>'inbegrepen'</i> -> toon in normale listing<br>
		<i>'uitsluiten'</i> -> verberg in normale listing<br>
		<i>'isoleren'</i> -> toon enkel de direct leverbare items</p>

		<div class='ovis-seperator'></div>

		<h4>Conditie</h4>
		<p>Bepaal welke condities weergegeven worden in het overzicht:</p>
		<p class='ovis-shortcode'>[ovis-voorraad conditie='nieuw, occasion']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Verhuur</h4>
		<p>Bepaal of het om een verhuur output gaat (<i>default: nee</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad verhuur='ja']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Call to action</h4>
		<p>Bepaal welke call to action knoppen getoond moeten worden:</p>
		<p class='ovis-shortcode'>[ovis-voorraad calltoaction='proefrit,bezichtiging,afspraak']</p>
		<p>Opties voor veld: <i>'proefrit', 'bezichtiging', 'afspraak,mail', 'verhuuraanvraag', 'inruilvoorstel'</i></p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Verkocht</h4>
		<p>Toon wel of geen verkochte items (<i>default: ja</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad verkocht='nee']</p>
		<p>Opties voor veld: wilt u de verkochte items als laatste tonen, gebruikt dan de waarde 'einde'</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Status</h4>
		<p>Bepaal welke status objecten er getoond moeten worden:</p>
		<p class='ovis-shortcode'>[ovis-voorraad status='verwacht,gereserveerd']</p>
		<p>Opties voor veld: <i>'verwacht', 'gereserveerd', 'verkocht'</i></p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Socialmedia</h4>
		<p>Toon wel of geen socialmedia knoppen op de detailpagina (<i>default: ja</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad socialmedia='nee']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Dealer footer</h4>
		<p>Toon wel of geen footer met dealergegevens op de detailpagina (<i>default: ja</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad dealerfooter='nee']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Deeplink</h4>
		<p>Voeg een extra pad toe aan de detail url (<i>default: false</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad deeplink='deeplink']</p>
		<p>Deze functie kunt u gebruiken als de plugin bijvoorbeeld op uw homepage integreert</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Inruilvoorstel foto's</h4>
		<p>Bepaal of foto's verplicht zijn bij het aanvragen van een inruilvoorstel (<i>default: optioneel</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad inruilfotos='verplicht']</p>
		<p>Opties voor veld: <i>'optioneel', 'verplicht', 'uitgeschakeld'</i></p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Filter aanbieders</h4>
		<p>Toon wel of geen filter voor aanbieders (<i>default: nee</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad aanbieders='ja']</p>			
		
		<div class='ovis-seperator'></div>
		
		<h4>Specifieke aanbieder</h4>
		<p>Laat het aanbod zien van een specifieke aanbieder:</p>
		<p class='ovis-shortcode'>[ovis-voorraad dealer='0']</p>			
		<p>Vul hier het OVIS ID in voor de gewenste gebruiker</p>	
		
		<div class='ovis-seperator'></div>
		
		<h4>Scroll naar occasions bij laden pagina</h4>
		<p>Scroll naar de producten bij het laden van de pagina (<i>default: nee</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad scrollonload='ja']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Merk</h4>
		<p>Toon enkel de opgegeven merken:</p>
		<p class='ovis-shortcode'>[ovis-voorraad merk='Adria,Knaus']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Brandstof</h4>
		<p>Toon enkel de opgegeven brandstoffen:</p>
		<p class='ovis-shortcode'>[ovis-voorraad brandstof='diesel,benzine']</p>
		<p>Opties voor veld: <i>'benzine', 'diesel', 'lpg', 'elektrisch of hybride'</i></p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Bouwjaar</h4>
		<p>Toon enkel de opgegeven bouwjaar selectie:</p>
		<p class='ovis-shortcode'>[ovis-voorraad bouwjaar='2000-2001']</p>
		<p>Het bouwjaar moet altijd 2 jaartallen bevatten, waarbij het tweede jaartal gelijk of groter moet zijn dan het eerste.</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Modeljaar</h4>
		<p>Toon enkel de opgegeven modeljaar selectie:</p>
		<p class='ovis-shortcode'>[ovis-voorraad modeljaar='2000-2001']</p>
		<p>Het modeljaar moet altijd 2 jaartallen bevatten, waarbij het tweede jaartal gelijk of groter moet zijn dan het eerste.</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Zoekfilters</h4>
		<p>Toon wel of geen zoekfilters (<i>default: ja</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad filters='nee']</p>
		<p>Opties voor veld: wilt u de zoekfilters altijd tonen, gebruikt dan de waarde 'open'</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Kalender</h4>
		<p>Toon wel of geen kalender bij een verhuur output (<i>default: ja</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad kalender='nee']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Sorteer veld + volgorde</h4>
		<p>Bepaal wat de standaard sorteer volgorde is (<i>default: merk A-Z</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad sorteren='veld richting']</p>
		<p>Opties voor veld: <i>'merk', 'prijs', 'bouwjaar', 'gewicht', 'slaapplaatsen', 'categorie', 'aanmaakdatum', 'willekeurig'</i></p><p>Opties voor richting: <i>'oplopend', 'aflopend'</i></p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Anchor</h4>
		<p>Bepaal of er een 'anchor' moet worden toegevoegd aan de pagination URL voor een specifieke weergave van de plugin:</p>
		<p class='ovis-shortcode'>[ovis-voorraad anchor='anchor']</p>
		<p>Een anchor word gebruikt om te kunnen springen binnen de content op een pagina</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Items per rij</h4>
		<p>Overrule het standaard ingestelde aantal items per rij (<i>default: zoals opgegeven bij instellingen</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad perrij='3']</p>
		<p>Opties: <i>2 t/m 5</i></p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Specificaties</h4>
		<p>Toon meteen alle specificaties op de detailpagina zonder een 'meer specificaties' knop:</p>
		<p class='ovis-shortcode'>[ovis-voorraad specificaties='open']</p>
		<p>Standaard zijn de specificaties niet zichtbaar</p>
		
		<div class='ovis-seperator'></div>

		<h4>Extra filters</h4>
		<p>Toon extra filters op de voorraadlijst meteen:</p>
		<p class='ovis-shortcode'>[ovis-voorraad extrafilters='open']</p>
		<p>Standaard zijn de extra filters niet zichtbaar</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>NAW gegevens</h4>
		<p>Verberg NAW gegevens op detailpagina:</p>
		<p class='ovis-shortcode'>[ovis-voorraad toonnaw='nee']</p>
		<p>Standaard zijn de NAW gegevens zichtbaar</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Verberg filters</h4>
		<p>Verberg filters op de voorraadlijst:</p>
		<p class='ovis-shortcode'>[ovis-voorraad verbergfilters='dealer, categorie, conditie, merk, model, trefwoord, subcategorie, datum, type, indeling, transmissie, branstof, euroklasse']</p>
		<p>Standaard tonen wij alle filters</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Verberg specificaties</h4>
		<p>Verberg specificaties op de detailpagina:</p>
		<p class='ovis-shortcode'>[ovis-voorraad verbergspecificaties='conditie, opbouw lengte']</p>
		<p>Vul hier het label van de specificatie op de detailpagina in. Standaard tonen wij alle specificaties welke zijn ingevuld</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Shop knop</h4>
		<p>Toon een 'Direct kopen' knop op de detailpagina (<i>default: nee</i>):</p>
		<p class='ovis-shortcode'>[ovis-voorraad shopknop='ja']</p>
		
		<div class='ovis-seperator'></div>
		
		<h4>Bepaal volgorde specificaties voorraadlijst</h4>
		<p>Bepaal volgorde specificaties voorraadlijst:</p>
		<p class='ovis-shortcode'>[ovis-voorraad volgordespecificaties='bouwjaar, slaapplaatsen, kilometerstand']</p>
		<p>Standaard hanteren wij de volgende volgorde:<br>
		Kampeermiddelen: subcategorie, bouwjaar, gewicht, laadvermogen, slaapplaatsen, kilometerstand, transmissie, gordels, lengte, breedte<br>
		Boten: subcategorie, bouwjaar, vermogen, snelvarend, lengte, breedte, romp, slaapplaatsen
		</p>";

		$bTranslationAllowed = false;
		
		if(!empty($oForms->aFormSettings['settings']['authentication_key'])) {
			
			$oThisData = new data($oForms->aFormSettings);
			$oThisData->getTranslations();

			if(!empty($oThisData->aTranslations->data->allowed)) {
				$bTranslationAllowed = true;
			}
		}
		
		if(!empty($bTranslationAllowed)) {
		
			$sHTML .= "<div class='ovis-seperator'></div>
			
			<h4>Taal</h4>
			<p>Bepaal welke taalkeuze er in de plugin moet worden weergegeven (<i>default: Nederlands</i>):</p>
			<p class='ovis-shortcode'>[ovis-voorraad taal='NL,DE']</p>
			<p>Mogelijke talen: Nederlands: NL, Duits: DE, Engels: EN, Frans: FR.<br>Stel 'systeem' in als eerste om de taal van de Wordpress installatie over te nemen.</p>";
			
			$sHTML .= "<div class='ovis-seperator'></div>
			
			<h4>Prijzen</h4>
			<p>Bepaal welke prijzen en in de plugin getoond moeten worden (<i>default: Nederlands</i>):</p>
			<p class='ovis-shortcode'>[ovis-voorraad prijzen='NL']</p>
			<p>Mogelijke prijzen: Duits: DE, Engels: EN, Frans: FR</p>";
		}

	$sHTML .= "</article>

</section>";

echo $sHTML;

require plugin_dir_path(__FILE__) . '../include/inc_footer.php';