<?php 

global $wp;

$sPageURL = $wp->request;

if(empty($sPageURL)) {
	header("HTTP/1.0 404 Not Found");
	exit;
}

$sPageURL = str_ireplace('/ovissitemap', '', $sPageURL);

$page = get_page_by_path( $sPageURL );

if(empty($page)) {
	header("HTTP/1.0 404 Not Found");
	exit;
}

$str = $page->post_content;

$pattern = "#(\[ovis-voorraad)(.+)(\])#i";

preg_match($pattern, $str, $match);

if(empty($match[0]) || $match[0] == '[ovis-voorraad ]') {
	$match[0] = '[ovis-voorraad module=\'ovis\']';
}

$sXML = '<?xml version="1.0" encoding="utf-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

if(!empty($match[0])) {
	
	$sMatchValue = trim($match[0]);
	
	if(substr($sMatchValue, 0, 1) == '[') {
		$sMatchValue = substr($sMatchValue, 1);
	}
	
	if(substr($sMatchValue, -1) == ']') {
		$sMatchValue = substr($sMatchValue, 0, -1);
	}
	
	$sMatchValue = str_replace('ovis-voorraad', '', $sMatchValue);
	
	$sMatchValue = trim($sMatchValue);
	
	$sMatchValue = str_replace('\'', '"|', $sMatchValue);
	$sMatchValue = str_replace('="|', '="', $sMatchValue);
	$sMatchValue = str_replace('"', '', $sMatchValue);
	
	$aMatchValues = explode('|', $sMatchValue);
	$oParameters = new stdClass();

	$sPageURL = get_permalink($page->ID);
	
		if(!empty($aMatchValues)) {
			
			foreach($aMatchValues as $key=>$value) {
				
				if(!empty($value)) {
					$aValue = explode('=', trim($value));
					$oParameters->{$aValue[0]} = $aValue[1];
				}
			}
		}
	
	global $oOutput;
	$sXML .= $oOutput->build_sitemap($sPageURL, $oParameters);
}

$sXML .= '</urlset>';

header("Content-type: text/xml");
echo $sXML;