<?php

/**
 * Plugin Name: OVIS Wordpress Plugin
 * Description: De OVIS Wordpress plugin maakt het mogelijk om uw OVIS-aanbod simpel en snel in een Wordpress website weer te geven.
 * Version: 3.0.4
 * Release: 20251208
 * Author: Internet Service Nederland B.V.
 */
require plugin_dir_path(__FILE__) . 'include/inc_helpers.php';
require plugin_dir_path(__FILE__) . 'include/inc_config.php';
require plugin_dir_path(__FILE__) . 'include/inc_functions.php';
require plugin_dir_path(__FILE__) . 'classes/rest_client/class.restapi_client.php';
require plugin_dir_path(__FILE__) . 'classes/class.ovis_deeplink.php';

/**
 *
 * Register hook that installs necessary database tables on activation
 *
 */
register_activation_hook(__FILE__, 'ovis_db_install');
register_activation_hook(__FILE__, 'ovis_data_install');

/**
 *
 * Register hook that uninstalls database tables on uninstall
 *
 */
register_uninstall_hook(__FILE__, 'ovis_db_uninstall');

if(OVIS_PLUGIN_DEV_MODE) {
    register_deactivation_hook(__FILE__, 'ovis_db_uninstall');
}

/**
 *
 * Add action to register plugin menu
 *
 */
add_action('admin_menu', 'register_menu');

/**
 * add cron-functions
 */
register_activation_hook(__FILE__, 'ovis_deeplink_cron_schedule');

register_deactivation_hook(__FILE__, 'ovis_deeplink_cron_unschedule');

add_action('ovis_deeplink_cron_hook', 'ovis_deeplink_cron_exec');

add_action('upgrader_process_complete', 'ovis_deeplink_after_update', 10, 2);