<?php 

namespace Mijn;

use Mijn\realmapi;

class mijnovis extends realmapi {
	
	var $_oArticles = false;
	var $_aAPIHeader = false;
	var $_aAPIHeaderSearch = false;
	var $_bAPIIsActive = false;
	var $_bAPISearchIsActive = false;
	var $_oAPIResult = false;
	var $_oUserData = false;
	var $_bInvalidArticle = false;
	var $_bInvalidPage = false;
	var $_oDetailsData = false;
	
	public function __construct() {
		
		parent::__construct();
		
		if(!empty(AUTHENTICATION_KEY_OVIS)){
			$this->_aAPIHeader = array('Content-Type: application/json; charset=utf-8','Authentication: '.AUTHENTICATION_KEY_OVIS);
			$this->_bAPIIsActive = true;
		}
		if(!empty(AUTHENTICATION_KEY_OVIS_SEARCH)){
			$this->_aAPIHeaderSearch = array('Content-Type: application/json; charset=utf-8','Authentication: '.AUTHENTICATION_KEY_OVIS_SEARCH);
			$this->_bAPISearchIsActive = true;
		}
		
    }

	function parseDescriptionGeneration($iUserId,$sAction=false){
		
		if(empty($iUserId)){
			
			$oReturn = new \stdClass();
			$oReturn->result = false;
			$oReturn->errors = 'no-user-set';
			
			$this->_oAPIResult = $oReturn;
			
			return false;
		}
		
		
				
		$oReturn = new \stdClass();
		$oReturn->result = false;		
		$oReturn->errors = false;
				
		$sRealm = 'ovis';
		
		if(!empty($this->_oUserData->realm)){
			$sRealm = $this->_oUserData->realm;			
		}
				
		switch($sAction){
			case 'getDescription':
				
				if(empty($_POST) || empty($_POST['acticleData'])){
					
					$oReturn = new \stdClass();
					$oReturn->result = false;
					$oReturn->errors = 'no-article-data';
					
					$this->_oAPIResult = $oReturn;
					
					return false;
				}
				
				$oPostData = json_decode($_POST['acticleData']);
				
				$iProduct = !empty($oPostData->articleId) ? $oPostData->articleId : false;
				$iProductIsTemp = !empty($oPostData->externalId) ? $oPostData->externalId : false;
				
				$sMainCategory = false;
				$sSubCategory = false;
				$sLicensePlate = false;
				$sBrand = false;
				$sModel = false;
				$sType = false;
				$sChassisNumber = false;
				
				$bIsNew = false;
				$bSold = false;
				$bExpected = false;
				$bStock = false;
				$bReserved = false;				
				$sStatus = false;
				$bBovag = false;				
				
				$iBuildYear = false;
				$iModelYear = false;
				$iLengthConstruction = false;
				$iLengthTotal = false;
				$iWidth = false;
				$iHeight = false;
				$iHeadroom = false;
				$iDepth = false;
				$iWeightEmpty = false;
				$iWeightOperational = false;
				$iWeightMaximum = false;
				$iCapacity = false;
				$iMilage = false;
				$iEngineHorsePower = false;
				$iNumberOfBeds = false;
				$iNumberOfSleepingPlaces = false;
				
				$sCarBrand = false;
				$sFuel = false;
				$sTransmission = false;
				$sMaterial = false;
				$sWalls = false;
				$sWallsColor = false;
				
				$sBoatColor = false;
				$sBoatMaterial = false;
				
				$oDivision = false;
				$oBedSpecifications = false;
				$oDates = false;
				$oWeightsMeasures = false;
				$oSpecs = false;
				$oBeds = false;
				$oAccessoires = false;
				
				if(!empty($oPostData->category)){
					$sMainCategory = $oPostData->category;
					
					if($sMainCategory == 'stacaravan'){
						$sMainCategory = 'mobilehome';					
					} else if($sMainCategory == 'vouwwagen'){
						$sMainCategory = 'tenttrailer';					
					} else if($sMainCategory == 'boot'){
						$sMainCategory = 'boat';					
					}
				}
				
				if(!empty($oPostData->subcategory)){
					$sSubCategory = $oPostData->subcategory;
				}
				
				if(!empty($oPostData->brand)){
					$sBrand = $oPostData->brand;
				}
				
				if(!empty($oPostData->model)){
					$sModel = $oPostData->model;
				}
				
				if(!empty($oPostData->type)){
					$sType = $oPostData->type;
				}
				
				if(!empty($oPostData->license)){
					$sLicensePlate = $oPostData->license;
				}
				
				if(!empty($oPostData->chassisnummer)){
					$sChassisNumber = $oPostData->chassisnummer;
				}
				
				if(!empty($oPostData->condition)){					
					if($oPostData->condition == 'nieuw'){						
						$bIsNew = true;
					}					
				}
				if(!empty($oPostData->status)){		
					if($oPostData->status == 'verkoop'){
						$bStock = true;						
					}
					
					if($oPostData->status == 'verwacht'){
						$bExpected = true;						
					}
					
					if($oPostData->status == 'gereserveerd'){
						$bReserved = true;						
					}
					
					if($oPostData->status == 'verkocht'){
						$bSold = true;						
					}
					
					$sStatus = $oPostData->status;
				}

				if(!empty($oPostData->constructionYear)){					
					$iBuildYear = $oPostData->constructionYear;	
				}

				if(!empty($oPostData->modelYear)){					
					$iModelYear = $oPostData->modelYear;	
				}

				if(!empty($oPostData->constructionLength)){					
					$iLengthConstruction = $oPostData->constructionLength;	
				}

				if(!empty($oPostData->totalLength)){					
					$iLengthTotal = $oPostData->totalLength;	
				}

				if(!empty($oPostData->width)){					
					$iWidth = $oPostData->width;	
				}

				if(!empty($oPostData->height)){					
					$iHeight = $oPostData->height;	
				}

				if(!empty($oPostData->headroom)){					
					$iHeadroom = $oPostData->headroom;	
				}

				if(!empty($oPostData->depth)){					
					$iDepth = $oPostData->depth;	
				}

				if(!empty($oPostData->emptyWeight)){					
					$iWeightEmpty = $oPostData->emptyWeight;	
				}

				if(!empty($oPostData->roadworthyWeight)){					
					$iWeightOperational = $oPostData->roadworthyWeight;	
				}

				if(!empty($oPostData->maxWeight)){					
					$iWeightMaximum = $oPostData->maxWeight;	
				}

				if(!empty($oPostData->capacity)){					
					$iCapacity = $oPostData->capacity;	
				}

				if(!empty($oPostData->mileage)){					
					$iMilage = $oPostData->mileage;	
				}

				if(!empty($oPostData->power)){					
					$iEngineHorsePower = $oPostData->power;	
				}

				if(!empty($oPostData->beds)){					
					$iNumberOfBeds = $oPostData->beds;	
				}

				if(!empty($oPostData->sleepingplaces)){					
					$iNumberOfSleepingPlaces = $oPostData->sleepingplaces;	
				}

				if(!empty($oPostData->carBrand)){					
					$sCarBrand = $oPostData->carBrand;	
				}

				if(!empty($oPostData->fuel)){					
					$sFuel = $oPostData->fuel;	
				}

				if(!empty($oPostData->transmission)){					
					$sTransmission = $oPostData->transmission;	
				}

				if(!empty($oPostData->wallMaterial)){					
					$sMaterial = $oPostData->wallMaterial;	
				}

				if(!empty($oPostData->walltype)){					
					$sWalls = $oPostData->walltype;	
				}

				if(!empty($oPostData->color)){					
					$sWallsColor = $oPostData->color;	
				}

				if(!empty($oPostData->boatColor)){					
					$sBoatColor = $oPostData->boatColor;	
				}

				if(!empty($oPostData->boatMaterial)){					
					$sBoatMaterial = $oPostData->boatMaterial;	
				}
				
				$oWeightsMeasures = new \stdClass();
				$oWeightsMeasures->lengthConstruction = (int) str_replace('.','',$iLengthConstruction);
				$oWeightsMeasures->lengthTotal = (int) str_replace('.','',$iLengthTotal);
				$oWeightsMeasures->width = (int) str_replace('.','',$iWidth);
				$oWeightsMeasures->height = (int) str_replace('.','',$iHeight);
				$oWeightsMeasures->headroom = (int) str_replace('.','',$iHeadroom);
				$oWeightsMeasures->weightEmpty = (int) str_replace('.','',$iWeightEmpty);
				$oWeightsMeasures->weightOperational = (int) str_replace('.','',$iWeightOperational);
				$oWeightsMeasures->weightMaximum = (int) str_replace('.','',$iWeightMaximum);
				$oWeightsMeasures->capacity = (int) str_replace('.','',$iCapacity);
				$oWeightsMeasures->depth = (int) str_replace('.','',$iDepth);
								
				$aDivisions = array();
				
				if(!empty($oPostData->divisions) && is_array($oPostData->divisions)){
					foreach($oPostData->divisions as $oDivision){
						
						$sCategory = $oDivision->category;
						
						if($sCategory == 'zitten'){
							$sCategory = 'zit';
						} elseif($sCategory == 'slapen'){
							$sCategory = 'bed';							
						}
						
						$oDivisionItem = new \stdClass();
						$oDivisionItem->category = $sCategory;
						$oDivisionItem->description = $oDivision->value;

						$aDivisions[] =$oDivisionItem;						
						
					}
				}
				
				if(!empty($aDivisions)){
					$oDivision = $aDivisions;					
				}
				
				$oSpecs = false;
				
				if(strtolower($sMainCategory) == 'camper'){
					$oSpecs = new \stdClass();
					$oSpecs->category = $sSubCategory;
					$oSpecs->carBrand = $sCarBrand;
					$oSpecs->milage = str_replace('.','',$iMilage);
					$oSpecs->fuel = $sFuel;
					$oSpecs->transmission = $sTransmission;
					$oSpecs->engineHorsePower = $iEngineHorsePower;
					$oSpecs->walls = $sWalls;
					$oSpecs->wallsColor = $sWallsColor;
					if(!empty($oDivision)){
						$oSpecs->division = $oDivision;	
					}
				} elseif(strtolower($sMainCategory) == 'caravan'){
					$oSpecs = new \stdClass();
					$oSpecs->walls = $sWalls;
					$oSpecs->wallsColor = $sWallsColor;
					if(!empty($oDivision)){
						$oSpecs->division = $oDivision;	
					}
				} elseif(strtolower($sMainCategory) == 'mobilehome'){
					$oSpecs = new \stdClass();
					$oSpecs->material = $sMaterial;
				} elseif(strtolower($sMainCategory) == 'tenttrailer'){
					$oSpecs = new \stdClass();
					$oSpecs->material = $sMaterial;
				} elseif(strtolower($sMainCategory) == 'boat'){
					$oSpecs = new \stdClass();
					$oSpecs->category = $sSubCategory;
					$oSpecs->color = $sBoatColor;
					$oSpecs->material = $sBoatMaterial;
				}					
								
				$aBedSpecifications = array();
				
				if(!empty($oPostData->beddata)){
					
					for($i=1; $i<=$iNumberOfBeds; $i++){
						
						if(!empty($oPostData->beddata->{'bed_'.$i})){
							
							$oBedData = $oPostData->beddata->{'bed_'.$i};
							
							$oAddBed = new \stdClass();
							$oAddBed->width = !empty($oBedData->width) ? (int) $oBedData->width : false;
							$oAddBed->length = !empty($oBedData->length) ? (int) $oBedData->length : false;
							$oAddBed->type = !empty($oBedData->type) ? $oBedData->type : false;
							
							$aBedSpecifications[] = $oAddBed;
							
						}						
					}					
				}	
				
				$oBeds = new \stdClass();
				$oBeds->numberOfBeds = (int) $iNumberOfBeds;
				$oBeds->numberOfSleepingPlaces = (int) $iNumberOfSleepingPlaces;
				$oBeds->bedSpecifications = !empty($aBedSpecifications) ? $aBedSpecifications : false;
				
				$oDates = new \stdClass();
				$oDates->buildYear = (int) $iBuildYear;
				$oDates->modelYear = (int) $iModelYear;
								
				$aAccessoires  = array();
				$aAccessoiresGrouped  = array();
							
				if(!empty($oPostData->accessoiries) && is_array($oPostData->accessoiries)){
					foreach($oPostData->accessoiries as $oAccessoiry){
						
						$sGroupHash = md5($oAccessoiry->category);
						
						if(!array_key_exists($sGroupHash,$aAccessoiresGrouped)){
							$aAccessoiresGrouped[$sGroupHash] = array();
							$aAccessoiresGrouped[$sGroupHash]['group'] = $oAccessoiry->category;
							$aAccessoiresGrouped[$sGroupHash]['items'] = array();
						}
						
						$aAccessoiresGrouped[$sGroupHash]['items'][] = $oAccessoiry->value;
																		
						$oAccessoiryItem = new \stdClass();
						$oAccessoiryItem->description = $oAccessoiry->value;

						$aAccessoires[] = $oAccessoiryItem;						
						
					}
				}
				
				if(!empty($aAccessoires)){
					$oAccessoires = (array) $aAccessoires;					
				}
				
				$oParams = new \stdClass();
				
				$oParams->externalAdId = $iProduct;
				$oParams->externalUserId = $iUserId;
				$oParams->locale = "nl_NL";
				$oParams->externalMode = 1;
				$oParams->supplier = "OVIS";	
				$oParams->status = "active";
				
				$oParams->specifications = new \stdClass();
				$oParams->specifications->category = $sMainCategory;
				$oParams->specifications->licensePlate = $sLicensePlate;
				$oParams->specifications->brand = $sBrand;
				$oParams->specifications->model = $sModel;
				$oParams->specifications->type = $sType;
				$oParams->specifications->chassisNumber = $sChassisNumber;
				$oParams->specifications->new = $bIsNew;
				$oParams->specifications->sold = $bSold;
				$oParams->specifications->expected = $bExpected;
				$oParams->specifications->stock = $bStock;
				$oParams->specifications->reserved = $bReserved;
				if(!empty($oAccessoires)){
					$oParams->specifications->accessories = $oAccessoires;
					$oParams->specifications->accessoriesGrouped = $aAccessoiresGrouped;
				}
				$oParams->specifications->dates = $oDates;
				$oParams->specifications->weightsMeasures = $oWeightsMeasures;
				$oParams->specifications->beds = $oBeds;
				
				if(!empty($oSpecs)){
					if(strtolower($sMainCategory) == 'camper'){
						$oParams->specifications->specsCamper = $oSpecs;					
					} elseif(strtolower($sMainCategory) == 'caravan'){
						$oParams->specifications->specsCaravan = $oSpecs;					
					} elseif(strtolower($sMainCategory) == 'mobilehome'){
						$oParams->specifications->specsMobilehome = $oSpecs;					
					} elseif(strtolower($sMainCategory) == 'tenttrailer'){
						$oParams->specifications->specsTenttrailer = $oSpecs;	
					} elseif(strtolower($sMainCategory) == 'boat'){
						$oParams->specifications->specsBoat = $oSpecs;	
					}
				}
				
				$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);

				$sEndpoint = API_ENDPOINT_OVIS . '/'.$sRealm.'/description/'.$iUserId.'/create';
				
				$oCurl = curl_init();
				curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($oCurl, CURLOPT_TIMEOUT, 360);
				curl_setopt($oCurl, CURLOPT_POST, true);
				curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
				curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
				curl_setopt($oCurl, CURLOPT_HEADER, false);
				
				$sResult = curl_exec($oCurl);
				$sError = curl_errno($oCurl);
				$aResponseInfo = curl_getinfo($oCurl);
								
				$oResult = json_decode($sResult);
								
				if(!empty($oResult->result)){
				
					$oReturn->result = true;
					$oReturn->data = $oResult->data;
				
				} else {
					
					$oReturn->errors = $oResult->errors;
					
				}
				
				break;
			default:
			
				$sEndpoint = API_ENDPOINT_OVIS . '/'.$sRealm.'/description/'.$iUserId;
								
				//$oParams->id = $oPostData->articleId;
				//$oParams->updatePeriod = true;
				
				//$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
				$oCurl = curl_init();
				curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
				curl_setopt($oCurl, CURLOPT_POST, false);
				//curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
				curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
				curl_setopt($oCurl, CURLOPT_HEADER, false);
				
				$sResult = curl_exec($oCurl);
				$sError = curl_errno($oCurl);
				$aResponseInfo = curl_getinfo($oCurl);
				
				$oResult = json_decode($sResult);
				
				if(!empty($oResult->result)){
				
					$oReturn->result = true;
					$oReturn->data = $oResult->data;
				
				} else {
					$oReturn->errors = $oResult->errors;					
				}
			
				break;
		}
		
		$this->_oAPIResult = $oReturn;
	}	
	
	function cleanUpList($currentvalue){

		if(!empty($currentvalue)){
			$currentvalue = preg_replace('~[\r\n]+~', '', $currentvalue);
			//$currentvalue = preg_replace('#(<br */? >\s*)+#i', '<br />', $currentvalue);
			$currentvalue = str_replace(array("<br /><br /><br /><br /><br /><br /><ul>","<br /><br /><br /><br /><br /><ul>","<br /><br /><br /><br /><ul>","<br /><br /><br /><ul>","<br /><br /><br /><ul>","<br /><br /><ul>"), "<br /><ul>", $currentvalue);
			$currentvalue = str_replace(array("</ul><br /><br /><br /><br /><br /><br />","</ul><br /><br /><br /><br /><br />","</ul><br /><br /><br /><br />","</ul><br /><br /><br />","</ul><br /><br /><br />"), "</ul><br />", $currentvalue);
			$currentvalue = str_replace(array("<ul><br />","<br /></ul>","</ul><br /><ul>","</li><br /><li>"), array("<ul>","</ul>","</ul><ul>","</li><li>"), $currentvalue);

			$currentvalue = str_replace(array("</ul></ul></ul></ul></ul></ul><ul><ul><ul><ul><ul><ul>","</ul></ul></ul></ul></ul><ul><ul><ul><ul><ul>","</ul></ul></ul></ul><ul><ul><ul><ul>","</ul></ul></ul><ul><ul><ul>","</ul></ul><ul><ul>","</ul><ul>"), array(""), $currentvalue);
			$currentvalue = str_replace(array("<ul><ul><ul><ul><ul><ul>","<ul><ul><ul><ul><ul>","<ul><ul><ul><ul>","<ul><ul><ul>","<ul><ul>"), "<ul>", $currentvalue);
			$currentvalue = str_replace(array("</ul></ul></ul></ul></ul></ul>","</ul></ul></ul></ul></ul>","</ul></ul></ul></ul>","</ul></ul></ul>","</ul></ul>"), "</ul>", $currentvalue);

			$currentvalue = str_replace(array("&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;ul&gt;","&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;ul&gt;","&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;ul&gt;","&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;ul&gt;","&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;ul&gt;","&lt;br /&gt;&lt;br /&gt;&lt;ul&gt;"), "&lt;br /&gt;&lt;ul&gt;", $currentvalue);
			$currentvalue = str_replace(array("&lt;/ul&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;","&lt;/ul&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;","&lt;/ul&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;","&lt;/ul&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;","&lt;/ul&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;"), "&lt;/ul&gt;&lt;br /&gt;", $currentvalue);
			$currentvalue = str_replace(array("&lt;ul&gt;&lt;br /&gt;","&lt;br /&gt;&lt;/ul&gt;","&lt;/ul&gt;&lt;br /&gt;&lt;ul&gt;","&lt;/li&gt;&lt;br /&gt;&lt;li&gt;"), array("&lt;ul&gt;","&lt;/ul&gt;","&lt;/ul&gt;&lt;ul&gt;","&lt;/li&gt;&lt;li&gt;"), $currentvalue);

			$currentvalue = str_replace(array("&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;/ul&gt;&lt;/ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;/ul&gt;&lt;ul&gt;"), array(""), $currentvalue);
			$currentvalue = str_replace(array("&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;ul&gt;&lt;ul&gt;&lt;ul&gt;","&lt;ul&gt;&lt;ul&gt;"), "&lt;ul&gt;", $currentvalue);
			$currentvalue = str_replace(array("&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;","&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;","&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;","&lt;/ul&gt;&lt;/ul&gt;&lt;/ul&gt;","&lt;/ul&gt;&lt;/ul&gt;"), "&lt;/ul&gt;", $currentvalue);
		}

		return $currentvalue;
	}
	
	function translateCategory($sCategory=false){
		
		$aTranslateCategory = array();
		//$aTranslateCategory['mobilehome'] = 'stacaravan';
		//$aTranslateCategory['trailer'] = 'aanhangwagen';
		//$aTranslateCategory['tenttrailer'] = 'vouwwagen';
		//$aTranslateCategory['boat'] = 'boot';
		//$aTranslateCategory['boattrailer'] = 'boottrailer';
		//$aTranslateCategory['engine'] = 'motor';
		$aTranslateCategory['stacaravan'] = 'mobilehome';
		$aTranslateCategory['aanhangwagen'] = 'trailer';
		$aTranslateCategory['vouwwagen'] = 'tenttrailer';
		$aTranslateCategory['boot'] = 'boat';
		$aTranslateCategory['boottrailer'] = 'boattrailer';
		$aTranslateCategory['motor'] = 'engine';
										
		$sReturnCategory =  !empty($aTranslateCategory[$sCategory]) ? ucfirst($aTranslateCategory[$sCategory]) : ucfirst($sCategory);
		
		
		return $sReturnCategory;
		
	}
	
	function parseSaveArticle(){
		
		if(empty($_POST)){
			
			$oReturn = new \stdClass();
			$oReturn->result = false;
			$oReturn->errors = 'no-post-data';
			
			$this->_oAPIResult = $oReturn;
			
			return false;
		}		
				
		$sRealm = 'ovis';
		$oPostData = json_decode($_POST['acticleData']);		
		
		if(empty($oPostData)){
			$oReturn = new \stdClass();
			$oReturn->result = false;
			$oReturn->errors = 'invalid-post-data';
		} else {
			
			$oReturn = new \stdClass();
			$oReturn->result = true;
			$oReturn->errors = false;
			
			if(!empty($oPostData->category)){
				if($this->_oUserData->realm == 'boat'){
					$sRealm = 'boat';					
				}
			}			
			
			$oParams = new \stdClass();			
			$oParams->userId = $this->_oUserData->id;
			$oParams->externalAdId = empty($oPostData->externalId) || $oPostData->externalId == 'new' ? date('U').sprintf('%05d', $this->_oUserData->id) : $oPostData->externalId;
			$oParams->realm = $sRealm;
			$oParams->locale = 'nl_NL';
			$oParams->specifications = new \stdClass();
			$oParams->specifications->category = !empty($oPostData->category) ? strtolower($this->translateCategory($oPostData->category)) : false;
			$oParams->specifications->licensePlate = !empty($oPostData->license) ? $oPostData->license : '';
			$oParams->specifications->brand = !empty($oPostData->brand) ? $oPostData->brand : false;
			$oParams->specifications->model = !empty($oPostData->model) ? $oPostData->model : (!empty($oPostData->boatModel) ? $oPostData->boatModel : '');
			$oParams->specifications->version = !empty($oPostData->type) ? $oPostData->type : '';
			
			$oParams->specifications->titleSuffix = !empty($oPostData->suffix) ? htmlentities(html_entity_decode($oPostData->suffix)) : '';			
						
			$oParams->specifications->chassisNumber = !empty($oPostData->chassisnummer) ? $oPostData->chassisnummer : '';
			
			$sDescription = !empty($oPostData->description) ? strip_tags($oPostData->description, '<ul><ol><li><br><b><strong><u><i><em><p>') : false;
			$sComments = !empty($oPostData->comment) ? strip_tags($oPostData->comment, '<ul><ol><li><br><b><strong><u><i><em><p>') : false;
			$sMemo = !empty($oPostData->memo) ? strip_tags($oPostData->memo, '<ul><ol><li><br><b><strong><u><i><em><p>') : false;
			
			$oParams->specifications->uniqueDescription = !empty(trim($sDescription)) && trim($sDescription) != '<br>' ? $sDescription : '';
			$oParams->specifications->description = !empty(trim($sComments)) && trim($sComments) != '<br>'  ? $sComments : '';
			
			if(!empty(trim($sMemo)) && trim($sMemo) != '<br>'){
				$oParams->specifications->memo = $sMemo;
			}
			
			$oParams->specifications->new = !empty($oPostData->condition) && strtolower($oPostData->condition) == 'nieuw' ? true : false;
			$oParams->specifications->damaged = !empty($oPostData->damaged) ? true : false;
			$oParams->specifications->demo = !empty($oPostData->demo) ? true : false;
			$oParams->specifications->sold = !empty($oPostData->status) && strtolower($oPostData->status) == 'verkocht' ? true : false;
			$oParams->specifications->expected = !empty($oPostData->status) && strtolower($oPostData->status) == 'verwacht' ? true : false;
			$oParams->specifications->stock = !empty($oPostData->online) && strtolower($oPostData->online) == 'online' ? true : false;
			$oParams->specifications->reserved = !empty($oPostData->status) && strtolower($oPostData->status) == 'gereserveerd' ? true : false;
			$oParams->specifications->rental = !empty($oPostData->exRental) ? true : false;
			
			if($oParams->specifications->category == 'caravan'){
				$oParams->specifications->specsCaravan = new \stdClass();
				$oParams->specifications->specsCaravan->walls = !empty($oPostData->walltype) ? $oPostData->walltype : false;
				$oParams->specifications->specsCaravan->wallsColor = !empty($oPostData->color) ? $oPostData->color : false;
				
				if(!empty($oPostData->divisions) && is_array($oPostData->divisions)){
					$oParams->specifications->specsCaravan->division = array();
					
					foreach($oPostData->divisions as $value){
						
						$oDivision = new \stdClass();
						$oDivision->description = $value->value;
						
						$sDivisionCategory = strtolower($value->category);
						$oDivision->category = str_ireplace(array('zitten','slapen'),array('zit','bed'),$sDivisionCategory);
						
						$oParams->specifications->specsCaravan->division[] = $oDivision;					
						
					}				
				}
			}
			
			if($oParams->specifications->category == 'vouwwagen' || $oParams->specifications->category == 'tenttrailer'){
				$oParams->specifications->specsTentTrailer = new \stdClass();
				
				if(!empty($oPostData->materialTentTrailer)){
					$oParams->specifications->specsTentTrailer->material = !empty($oPostData->materialTentTrailer) ? $oPostData->materialTentTrailer : false;	
				}					
			}
			
			if($oParams->specifications->category == 'stacaravan' || $oParams->specifications->category == 'mobilehome'){
				$oParams->specifications->specsMobileHome = new \stdClass();
				
				if(!empty($oPostData->subcategory)){
					$oParams->specifications->specsMobileHome->category = !empty($oPostData->subcategory) ? $oPostData->subcategory : false;
				}
				if(!empty($oPostData->material)){
					$oParams->specifications->specsMobileHome->material = !empty($oPostData->material) ? $oPostData->material : false;	
				}					
			}
			
			if($oParams->specifications->category == 'aanhangwagen'  || $oParams->specifications->category == 'trailer'){
				$oParams->specifications->specsTrailer = new \stdClass();
				if(!empty($oPostData->subcategory)){
					$oParams->specifications->specsTrailer->category = !empty($oPostData->subcategory) ? $oPostData->subcategory : false;
				}
				if(!empty($oPostData->containerLength)){
					$oParams->specifications->specsTrailer->lengthContainer = !empty($oPostData->containerLength) ? (int) str_replace('.','',$oPostData->containerLength) : false;
				}
				if(!empty($oPostData->totalLength)){
					$oParams->specifications->specsTrailer->lengthTotal = !empty($oPostData->totalLength) ? (int) str_replace('.','',$oPostData->totalLength) : false;
				}
				if(!empty($oPostData->drawbarLength)){
					$oParams->specifications->specsTrailer->lengthAdz = !empty($oPostData->drawbarLength) ? (int) str_replace('.','',$oPostData->drawbarLength) : false;
				}
				if(!empty($oPostData->containerWidth)){
					$oParams->specifications->specsTrailer->widthContainer = !empty($oPostData->containerWidth) ? (int) str_replace('.','',$oPostData->containerWidth) : false;
				}
				if(!empty($oPostData->totalWidth)){					
					$oParams->specifications->specsTrailer->widthTotal = !empty($oPostData->totalWidth) ? (int) str_replace('.','',$oPostData->totalWidth) : false;
				}
				if(!empty($oPostData->loadingPlatformHeight)){
					$oParams->specifications->specsTrailer->heightLoadingPlatform = !empty($oPostData->loadingPlatformHeight) ? (int) str_replace('.','',$oPostData->loadingPlatformHeight) : false;
				}
				if(!empty($oPostData->couplerHeight)){
					$oParams->specifications->specsTrailer->heightCoupler = !empty($oPostData->couplerHeight) ? (int) str_replace('.','',$oPostData->couplerHeight) : false;
				}
				if(!empty($oPostData->ladderRackHeight)){
					$oParams->specifications->specsTrailer->heightLadderRack = !empty($oPostData->ladderRackHeight) ? (int) str_replace('.','',$oPostData->ladderRackHeight) : false;
				}
				if(!empty($oPostData->bordersHeight)){
					$oParams->specifications->specsTrailer->heightBorders = !empty($oPostData->bordersHeight) ? (int) str_replace('.','',$oPostData->bordersHeight) : false;
				}
				if(!empty($oPostData->totalHeight)){
					$oParams->specifications->specsTrailer->heightTotal = !empty($oPostData->totalHeight) ? (int) str_replace('.','',$oPostData->totalHeight) : false;
				}
				if(!empty($oPostData->basePlateHeight)){
					$oParams->specifications->specsTrailer->heightBasePlate = !empty($oPostData->basePlateHeight) ? (int) str_replace('.','',$oPostData->basePlateHeight) : false;
				}
				if(!empty($oPostData->tireSize)){
					$oParams->specifications->specsTrailer->sizeTires = !empty($oPostData->tireSize) ? (int) str_replace('.','',$oPostData->tireSize) : false;
				}
				if(!empty($oPostData->volume)){
					$oParams->specifications->specsTrailer->volume = !empty($oPostData->volume) ? (int) str_replace('.','',$oPostData->volume) : false;
				}
				
				if(!empty($oPostData->color)){
					$oParams->specifications->specsTrailer->color = !empty($oPostData->color) ? $oPostData->color : false;
				}
				if(!empty($oPostData->brakes)){
					$oParams->specifications->specsTrailer->brakes = !empty($oPostData->brakes) ? $oPostData->brakes : false;
				}
				if(!empty($oPostData->numberOfDoors)){
					$oParams->specifications->specsTrailer->numberOfDoors = !empty($oPostData->numberOfDoors) ? (int) str_replace('.','',$oPostData->numberOfDoors) : false;
				}
				if(!empty($oPostData->doorTypes)){
					$oParams->specifications->specsTrailer->doorTypes = !empty($oPostData->doorTypes) ? $oPostData->doorTypes : false;
				}
				if(!empty($oPostData->plug)){
					$oParams->specifications->specsTrailer->plug = !empty($oPostData->plug) ? $oPostData->plug : false;
				}
				if(!empty($oPostData->kipAngle)){
					$oParams->specifications->specsTrailer->kipAngle = !empty($oPostData->kipAngle) ? (int) str_replace('.','',$oPostData->kipAngle) : false;
				}
				if(!empty($oPostData->axles)){
					$oParams->specifications->specsTrailer->axles = !empty($oPostData->axles) ? (int) str_replace('.','',$oPostData->axles) : false;
				}
				if(!empty($oPostData->floorMaterial)){
					$oParams->specifications->specsTrailer->materialFloor = !empty($oPostData->floorMaterial) ? $oPostData->floorMaterial : false;
				}
				if(!empty($oPostData->wallMaterial)){
					$oParams->specifications->specsTrailer->materialBorders = !empty($oPostData->wallMaterial) ? $oPostData->wallMaterial : false;
				}					
			}
			
			if($oParams->specifications->category == 'kampeerauto' || $oParams->specifications->category == 'camper'){
				$oParams->specifications->specsCamper = new \stdClass();
				if(!empty($oPostData->subcategory)){
					$oParams->specifications->specsCamper->category = !empty($oPostData->subcategory) ? $oPostData->subcategory : false;
				}
				if(!empty($oPostData->carBrand)){
					$oParams->specifications->specsCamper->carBrand = !empty($oPostData->carBrand) ? $oPostData->carBrand : false;
				}
				if(!empty($oPostData->mileage)){
					$oParams->specifications->specsCamper->mileage = !empty($oPostData->mileage) ? (int) str_replace('.','',$oPostData->mileage) : false;
				}
				if(!empty($oPostData->nap)){
					$oParams->specifications->specsCamper->nap = !empty($oPostData->nap) ? true : false;
				}
				if(!empty($oPostData->euroClass)){
					$oParams->specifications->specsCamper->euroclass = !empty($oPostData->euroClass) ? $oPostData->euroClass : false;
				}
				if(!empty($oPostData->seats)){
					$oParams->specifications->specsCamper->seats = !empty($oPostData->seats) ? (int) $oPostData->seats : false;
				}
				if(!empty($oPostData->seatbelts)){
					$oParams->specifications->specsCamper->seatbelts = !empty($oPostData->seatbelts) ? (int) $oPostData->seatbelts : false;
				}
				if(!empty($oPostData->fuel)){
					$oParams->specifications->specsCamper->fuel = !empty($oPostData->fuel) ? $oPostData->fuel : false;
				}
				if(!empty($oPostData->transmission)){
					$oParams->specifications->specsCamper->transmission = !empty($oPostData->transmission) ? $oPostData->transmission : false;
				}
				if(!empty($oPostData->power)){
					$oParams->specifications->specsCamper->engineHorsePower = !empty($oPostData->power) ? (int) str_replace('.','',$oPostData->power) : false;
				}
				if(!empty($oPostData->walltype)){
					$oParams->specifications->specsCamper->walls = !empty($oPostData->walltype) ? $oPostData->walltype : false;
				}
				if(!empty($oPostData->color)){
					$oParams->specifications->specsCamper->wallsColor = !empty($oPostData->color) ? $oPostData->color : false;
				}
								
				if(!empty($oPostData->divisions) && is_array($oPostData->divisions)){
					$oParams->specifications->specsCamper->division = array();
					
					foreach($oPostData->divisions as $value){
						
						$oDivision = new \stdClass();
						$oDivision->description = $value->value;
						
						$sDivisionCategory = strtolower($value->category);
						$oDivision->category = str_ireplace(array('zitten','slapen'),array('zit','bed'),$sDivisionCategory);
						
						$oParams->specifications->specsCamper->division[] = $oDivision;					
						
					}				
				}			
			}

			if($oParams->specifications->category == 'motor'  || $oParams->specifications->category == 'engine'){
				$oParams->specifications->specsEngine = new \stdClass();
				if(!empty($oPostData->engineFuel)){
					$oParams->specifications->specsEngine->fuel = !empty($oPostData->engineFuel) ? $oPostData->engineFuel : false;
				}
				if(!empty($oPostData->boattrailerKantelbaar)){
					//$oParams->specifications->specsEngine->tank = !empty($oPostData->boattrailerKantelbaar) ? $oPostData->boattrailerKantelbaar : false;
				}
				if(!empty($oPostData->engineTankCapacity)){
					$oParams->specifications->specsEngine->tankCapacity = !empty($oPostData->engineTankCapacity) ? str_replace('.','',$oPostData->engineTankCapacity) : false;
				}
				if(!empty($oPostData->engineTailLength)){
					$oParams->specifications->specsEngine->tailLength = !empty($oPostData->engineTailLength) ? $oPostData->engineTailLength : false;
				}
				if(!empty($oPostData->engineSteering)){
					$oParams->specifications->specsEngine->steering = !empty($oPostData->engineSteering) ? $oPostData->engineSteering : false;
				}
				if(!empty($oPostData->engineStartsystem)){
					$oParams->specifications->specsEngine->startSystem = !empty($oPostData->engineStartsystem) ? $oPostData->engineStartsystem : false;
				}
				if(!empty($oPostData->enginePower)){
					$oParams->specifications->specsEngine->power = !empty($oPostData->enginePower) ? $oPostData->enginePower : false;
				}
				if(!empty($oPostData->engineCylinders)){
					$oParams->specifications->specsEngine->numberOfCylinders = !empty($oPostData->engineCylinders) ? (int) str_replace('.','',$oPostData->engineCylinders) : false;
				}
				if(!empty($oPostData->engineSize)){
					$oParams->specifications->specsEngine->engineSize = !empty($oPostData->engineSize) ? (int) str_replace('.','',$oPostData->engineSize) : false;
				}
				if(!empty($oPostData->engineDryWeight)){
					$oParams->specifications->specsEngine->weightDry = !empty($oPostData->engineDryWeight) ? (int) str_replace('.','',$oPostData->engineDryWeight) : false;
				}
			}

			if($oParams->specifications->category == 'boottrailer' || $oParams->specifications->category == 'boattrailer'){
				$oParams->specifications->specsBoatTrailer = new \stdClass();
				if(!empty($oPostData->boattrailerAxles)){
					$oParams->specifications->specsBoatTrailer->numberOfAxes = !empty($oPostData->boattrailerAxles) ? (int) str_replace('.','',$oPostData->boattrailerAxles) : false;
				}
				if(!empty($oPostData->boattrailerKantelbaar)){
					$oParams->specifications->specsBoatTrailer->tilt = !empty($oPostData->boattrailerKantelbaar) ? $oPostData->boattrailerKantelbaar : false;
				}
				if(!empty($oPostData->boattrailerBraked)){
					$oParams->specifications->specsBoatTrailer->braked = !empty($oPostData->boattrailerBraked) ? $oPostData->boattrailerBraked : false;
				}
				if(!empty($oPostData->emptyWeight)){
					$oParams->specifications->specsBoatTrailer->weightEmpty = !empty($oPostData->emptyWeight) ? (int) str_replace('.','',$oPostData->emptyWeight) : false;
				}
				if(!empty($oPostData->maxWeight)){
					$oParams->specifications->specsBoatTrailer->weightMax = !empty($oPostData->maxWeight) ? (int) str_replace('.','',$oPostData->maxWeight) : false;
				}
				if(!empty($oPostData->capacity)){
					$oParams->specifications->specsBoatTrailer->weightCapacity = !empty($oPostData->capacity) ? (int) str_replace('.','',$oPostData->capacity) : false;
				}
				if(!empty($oPostData->boatTrailerPlug)){
					$oParams->specifications->specsBoatTrailer->plug = !empty($oPostData->boatTrailerPlug) ? $oPostData->boatTrailerPlug : false;
				}
				if(!empty($oPostData->boattrailerSizeBoat)){
					$oParams->specifications->specsBoatTrailer->suitableBoat = !empty($oPostData->boattrailerSizeBoat) ? $oPostData->boattrailerSizeBoat : false;
				}
			}
			
			if($oParams->specifications->category == 'boot' || $oParams->specifications->category == 'boat'){
				$oParams->specifications->specsBoat = new \stdClass();
				
				if(!empty($oPostData->subcategory)){
					$oParams->specifications->subCategory = !empty($oPostData->subcategory) ? $oPostData->subcategory : false;
				}
				if(!empty($oPostData->materialTentTrailer)){
					//$oParams->specifications->specsBoat->name = !empty($oPostData->materialTentTrailer) ? $oPostData->materialTentTrailer : false;
				}
				if(!empty($oPostData->boatLigplaats)){
					$oParams->specifications->specsBoat->berth = !empty($oPostData->boatLigplaats) ? $oPostData->boatLigplaats : false;
				}
				if(!empty($oPostData->boatBeds)){
					$oParams->specifications->specsBoat->beds = !empty($oPostData->boatBeds) ? $oPostData->boatBeds : false;
				}
				if(!empty($oPostData->boatMaterial)){
					$oParams->specifications->specsBoat->hullMaterial = !empty($oPostData->boatMaterial) ? $oPostData->boatMaterial : false;
				}
				if(!empty($oPostData->boatColor)){
					$oParams->specifications->specsBoat->hullColor = !empty($oPostData->boatColor) ? $oPostData->boatColor : false;
				}
				if(!empty($oPostData->boatDeck)){
					$oParams->specifications->specsBoat->deckColor = !empty($oPostData->boatDeck) ? $oPostData->boatDeck : false;
				}
				if(!empty($oPostData->boatInclusiefTrailer)){
					$oParams->specifications->specsBoat->trailerIncluded = !empty($oPostData->boatInclusiefTrailer) ? $oPostData->boatInclusiefTrailer : false;
				}
				if(!empty($oPostData->boatEngineFastSailing)){
					$oParams->specifications->specsBoat->fastSailing = !empty($oPostData->boatEngineFastSailing) ? true : false;
				}
				if(!empty($oPostData->boatPersons)){
					$oParams->specifications->specsBoat->numberOfSeats = !empty($oPostData->boatPersons) ? (int) str_replace('.','',$oPostData->boatPersons) : false;
				}
				if(!empty($oPostData->boatEngines)){
					$oParams->specifications->specsBoat->numberOfEngines = !empty($oPostData->boatEngines) ? (int) str_replace('.','',$oPostData->boatEngines) : false;
				}
				
				$oParams->specifications->specsBoat->engine =  new \stdClass();
				
				if(!empty($oPostData->boatEngineHasEngine)){
					$oParams->specifications->specsBoat->engine->hasEngine = !empty($oPostData->boatEngineHasEngine) ? true : false;

					if(!empty($oPostData->boatEngineType)){
						$oParams->specifications->specsBoat->engine->type = !empty($oPostData->boatEngineType) ? $oPostData->boatEngineType : false;
					}
					if(!empty($oPostData->boatEngineBrand)){
						$oParams->specifications->specsBoat->engine->brand = !empty($oPostData->boatEngineBrand) ? $oPostData->boatEngineBrand : false;
					}
					if(!empty($oPostData->boatEngineModel)){
						$oParams->specifications->specsBoat->engine->model = !empty($oPostData->boatEngineModel) ? $oPostData->boatEngineModel : false;
					}
					if(!empty($oPostData->boatEngineFuel)){
						$oParams->specifications->specsBoat->engine->fuel = !empty($oPostData->boatEngineFuel) ? $oPostData->boatEngineFuel : false;
					}
					if(!empty($oPostData->boatEngineTankCapacity)){
						$oParams->specifications->specsBoat->engine->tankCapacity = !empty($oPostData->boatEngineTankCapacity) ? str_replace('.','',$oPostData->boatEngineTankCapacity) : false;
					}
					if(!empty($oPostData->boatEnginePower)){
						$oParams->specifications->specsBoat->engine->power = !empty($oPostData->boatEnginePower) ? str_replace('.','',$oPostData->boatEnginePower) : false;
					}
					if(!empty($oPostData->boatEngineHours)){
						$oParams->specifications->specsBoat->engine->runHours = !empty($oPostData->boatEngineHours) ? (int) str_replace('.','',$oPostData->boatEngineHours) : false;
					}
					if(!empty($oPostData->boatEngineAccu)){
						$oParams->specifications->specsBoat->engine->battery = !empty($oPostData->boatEngineAccu) ? $oPostData->boatEngineAccu : false;
					}
					if(!empty($oPostData->boatEngineCruisingSpeed)){
						$oParams->specifications->specsBoat->engine->cruisingSpeed = !empty($oPostData->boatEngineCruisingSpeed) ? (int) str_replace('.','',$oPostData->boatEngineCruisingSpeed) : false;
					}
					if(!empty($oPostData->boatMaxSpeed)){
					//$oParams->specifications->specsBoat->engine->maxSpeed = !empty($oPostData->boatMaxSpeed) ? $oPostData->boatMaxSpeed : false;
					}
				
				} else {
					
					$oParams->specifications->specsBoat->numberOfEngines = (int) '0';
					$oParams->specifications->specsBoat->engine->type = false;
					$oParams->specifications->specsBoat->engine->brand = '';
					$oParams->specifications->specsBoat->engine->model = '';
					$oParams->specifications->specsBoat->engine->fuel = '';
					$oParams->specifications->specsBoat->engine->tankCapacity = '';
					$oParams->specifications->specsBoat->engine->power = '';
					$oParams->specifications->specsBoat->engine->runHours = '';
					$oParams->specifications->specsBoat->engine->battery = '';
					$oParams->specifications->specsBoat->engine->cruisingSpeed = '';
					$oParams->specifications->specsBoat->fastSailing = false;
				}
				
			}
			
			if(!empty($oPostData->accessoiries) && is_array($oPostData->accessoiries)){
				$oParams->specifications->accessories = array();
				
				foreach($oPostData->accessoiries as $value){
					
					$oAccessory = new \stdClass();
					$oAccessory->description = $value->value;
					
					$oParams->specifications->accessories[] = $oAccessory;					
					
				}				
			}			
			
			if(!empty($oPostData->constructionYear)){
				$oParams->specifications->dates = new \stdClass();
					if(!empty($oPostData->constructionYear)){
						$oParams->specifications->dates->constructionYear = !empty($oPostData->constructionYear) ? (int) $oPostData->constructionYear : false;
					}
					if(!empty($oPostData->constructionMonth)){
						$oParams->specifications->dates->constructionMonth = !empty($oPostData->constructionMonth) ? (int) $oPostData->constructionMonth : false;
					}
					if(!empty($oPostData->modelYear)){
						$oParams->specifications->dates->modelYear = !empty($oPostData->modelYear) ? (int) $oPostData->modelYear : false;
					}
					if(!empty($oPostData->datePartA)){
						$oParams->specifications->dates->datePart1a = !empty($oPostData->datePartA) ? date('Y-m-d',strtotime($oPostData->datePartA)) : false;
					}
					if(!empty($oPostData->dateFirstNL)){
						$oParams->specifications->dates->dateArrival = !empty($oPostData->dateFirstNL) ? date('Y-m-d',strtotime($oPostData->dateFirstNL)) : false;
					}
			}
			
			$oParams->specifications->weightsMeasures = new \stdClass();
				if(!empty($oPostData->constructionLength)){
					$oParams->specifications->weightsMeasures->lengthConstruction = !empty($oPostData->constructionLength) ? (int) str_replace('.','',$oPostData->constructionLength) : false;
				}
				if(!empty($oPostData->totalLength)){
					$oParams->specifications->weightsMeasures->lengthTotal = !empty($oPostData->totalLength) ? (int) str_replace('.','',$oPostData->totalLength) : false;
				}
				if(!empty($oPostData->width)){
					$oParams->specifications->weightsMeasures->width = !empty($oPostData->width) ? (int) str_replace('.','',$oPostData->width) : false;
				}
				if(!empty($oPostData->height)){
					$oParams->specifications->weightsMeasures->height = !empty($oPostData->height) ? (int) str_replace('.','',$oPostData->height) : false;
				}
				if(!empty($oPostData->headroom)){
					$oParams->specifications->weightsMeasures->headroom = !empty($oPostData->headroom) ? (int) str_replace('.','',$oPostData->headroom) : false;
				}
				if(!empty($oPostData->emptyWeight)){
					$oParams->specifications->weightsMeasures->weightEmpty = !empty($oPostData->emptyWeight) ? (int) str_replace('.','',$oPostData->emptyWeight) : false;
				}
				if(!empty($oPostData->roadworthyWeight)){
					$oParams->specifications->weightsMeasures->weightOperational = !empty($oPostData->roadworthyWeight) ? (int) str_replace('.','',$oPostData->roadworthyWeight) : false;
				}
				if(!empty($oPostData->maxWeight)){
					$oParams->specifications->weightsMeasures->weightMaximum = !empty($oPostData->maxWeight) ? (int) str_replace('.','',$oPostData->maxWeight) : false;
				}
				if(!empty($oPostData->capacity)){
					$oParams->specifications->weightsMeasures->capacity = !empty($oPostData->capacity) ? (int) str_replace('.','',$oPostData->capacity) : false;
				}
				if(!empty($oPostData->circulationsize)){
					$oParams->specifications->weightsMeasures->circulationSize = !empty($oPostData->circulationsize) ? str_replace('.','',$oPostData->circulationsize) : false;
				}
				
				// for boats
				if(!empty($oPostData->length)){
					$oParams->specifications->weightsMeasures->length = !empty($oPostData->length) ? (int) str_replace('.','',$oPostData->length) : false;
				}
				if(!empty($oPostData->verticalclearance)){
					$oParams->specifications->weightsMeasures->verticalClearance = !empty($oPostData->verticalclearance) ? (int) str_replace('.','',$oPostData->verticalclearance) : false;
				}			
				if(!empty($oPostData->headroom)){
					$oParams->specifications->weightsMeasures->headroom = !empty($oPostData->headroom) ? (int) str_replace('.','',$oPostData->headroom) : false;
				}
				if(!empty($oPostData->depth)){
					$oParams->specifications->weightsMeasures->draft = !empty($oPostData->depth) ? (int) str_replace('.','',$oPostData->depth) : false;
				}
			
			$oParams->specifications->specsMarktplaats = new \stdClass();
				$oParams->specifications->specsMarktplaats->priceModel = !empty($oPostData->marktplaatsPriceType) ? $oPostData->marktplaatsPriceType : 'fixed';
				
				if(!empty($oParams->specifications->specsMarktplaats->priceModel)){
					switch(strtolower($oParams->specifications->specsMarktplaats->priceModel)){
						case 'bieden':
							$oParams->specifications->specsMarktplaats->priceModel = 'bidding';
							break;
						case 'nader overeen te komen':
							$oParams->specifications->specsMarktplaats->priceModel = 'to be discussed';
							break;
						case 'prijs op aanvraag':
							$oParams->specifications->specsMarktplaats->priceModel = 'by request';
							break;
						case 'ruilen':
							$oParams->specifications->specsMarktplaats->priceModel = 'trade';
							break;
						case 'gereserveerd':
							$oParams->specifications->specsMarktplaats->priceModel = 'reserved';
							break;
						default:
							$oParams->specifications->specsMarktplaats->priceModel = 'fixed';
							break;						
					}
				}				
				
				$oParams->specifications->specsMarktplaats->title = !empty($oPostData->marktplaatsTitle) ? htmlentities(html_entity_decode($oPostData->marktplaatsTitle)) : false;
				
				$oParams->specifications->specsMarktplaats->price = $oParams->specifications->specsMarktplaats->priceModel != 'bidding' && !empty($oPostData->marktplaatsPrice) ? (int) str_replace('.','',$oPostData->marktplaatsPrice)*100 : false;
				
				$sMarktplaatsDescription = !empty($oPostData->marktplaatsDescription) ? strip_tags($oPostData->marktplaatsDescription, '<ul><ol><li><br><b><strong><u><i><em><p>') : false;
				
				$oParams->specifications->specsMarktplaats->description = !empty(trim($sMarktplaatsDescription)) && trim($sMarktplaatsDescription) != '<br>' ? $sMarktplaatsDescription : false;
				
				$oParams->specifications->specsMarktplaats->bidPrice = $oParams->specifications->specsMarktplaats->priceModel == 'bidding' && !empty($oPostData->marktplaatsBidPrice) ? (int) str_replace('.','',$oPostData->marktplaatsBidPrice)*100 : false;
				$oParams->specifications->specsMarktplaats->minimalBid = $oParams->specifications->specsMarktplaats->priceModel == 'bidding' && !empty($oPostData->marktplaatsMinimalBidPrice) ? (int) str_replace('.','',$oPostData->marktplaatsMinimalBidPrice)*100 : false;
			
			$oParams->specifications->beds = new \stdClass();
				if(!empty($oPostData->beds)){
					$oParams->specifications->beds->numberOfBeds = !empty($oPostData->beds) ? (int) str_replace('.','',$oPostData->beds) : false;
				}
				if(!empty($oPostData->sleepingplaces)){
					$oParams->specifications->beds->numberOfSleepingPlaces = !empty($oPostData->sleepingplaces) ? (int) str_replace('.','',$oPostData->sleepingplaces) : false;
				}
				if(!empty($oPostData->bedrooms)){
					$oParams->specifications->beds->bedrooms = !empty($oPostData->bedrooms) ? (int) str_replace('.','',$oPostData->bedrooms) : false;
				}
				
				$oParams->specifications->beds->bedSpecifications = array();
				
				if(!empty($oPostData->beddata)){
					for($i=1; $i<=10; $i++){
						
						if(!empty($oPostData->beddata->{'bed_'.$i})){
							
							if(!empty($oPostData->beddata->{'bed_'.$i}->length) || !empty($oPostData->beddata->{'bed_'.$i}->width) || !empty($oPostData->beddata->{'bed_'.$i}->type)){
								
								$oBedSpecs = new \stdClass();
								$oBedSpecs->length = !empty($oPostData->beddata->{'bed_'.$i}->length) ? (int) str_replace('.','',$oPostData->beddata->{'bed_'.$i}->length) : 0;
								$oBedSpecs->width = !empty($oPostData->beddata->{'bed_'.$i}->width) ? (int) str_replace('.','',$oPostData->beddata->{'bed_'.$i}->width) : 0;
								$oBedSpecs->type = !empty($oPostData->beddata->{'bed_'.$i}->type) ? $oPostData->beddata->{'bed_'.$i}->type : false;
								
								$oParams->specifications->beds->bedSpecifications[] = $oBedSpecs;
								
							}							
						}
					}
				}
			
			if(!empty($oPostData->price)){
			
				$oParams->specifications->prices = new \stdClass();
					$oParams->specifications->prices->price = !empty($oPostData->price) ? (int) str_replace('.','',$oPostData->price)*100 : false;
					if(!empty($oPostData->fromPrice)){
						$oParams->specifications->prices->retail = !empty($oPostData->fromPrice) ? (int) str_replace('.','',$oPostData->fromPrice)*100 : false;
					}
					if(!empty($oPostData->vat)){
						$oParams->specifications->prices->vat = !empty($oPostData->vat) ? $oPostData->vat : false;

						if(strtolower($oParams->specifications->prices->vat) == 'inclusief btw'){
							$oParams->specifications->prices->vat = 'inclusief';
						} elseif(strtolower($oParams->specifications->prices->vat) == 'exclusief btw'){
							$oParams->specifications->prices->vat = 'exclusief';
						}
					}					
			}
					
			if(!empty($oPostData->articleId)){
				// update article
				$sEndpoint = API_ENDPOINT_OVIS . '/'.$sRealm.'/presentations/'.$this->_oUserData->id;
								
				$oParams->id = $oPostData->articleId;
				$oParams->updatePeriod = true;
				
				$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
								
				$oCurl = curl_init();
				curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
				curl_setopt($oCurl, CURLOPT_POST, true);
				curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
				curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
				curl_setopt($oCurl, CURLOPT_HEADER, false);
				
				$sResult = curl_exec($oCurl);
				$sError = curl_errno($oCurl);
				$aResponseInfo = curl_getinfo($oCurl);
												
				$oResult = json_decode($sResult);	
				
				if(!empty($oResult->errors)){
					$oReturn->result = false;
					$oReturn->errors = $oResult->errors;
										
				} else if(empty($oResult->data)){
					$oReturn->result = false;
					$oReturn->errors = 'missing-data-object';
				} else {
					
					$sOnlineStatus = !empty($oPostData->online) ? $oPostData->online : false;
					
					$this->setOnlineStatus($oResult->data->id,$sOnlineStatus);
					
					if(!empty($oPostData->images)){
						$this->parseImages($oResult->data->id,$oPostData->images);						
					}
					
					$oReturn->result = true;
					$oReturn->errors = false;
					$oReturn->article = $oResult->data->id;
				}				
				
			} else {
				// create article
				$sEndpoint = API_ENDPOINT_OVIS . '/'.$sRealm.'/presentations/'.$this->_oUserData->id;
								
				$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
				$oCurl = curl_init();
				curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
				curl_setopt($oCurl, CURLOPT_POST, true);
				curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
				curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
				curl_setopt($oCurl, CURLOPT_HEADER, false);
				
				$sResult = curl_exec($oCurl);
				$sError = curl_errno($oCurl);
				$aResponseInfo = curl_getinfo($oCurl);
								
				$oResult = json_decode($sResult);
				
				if(!empty($oResult->errors)){
					$oReturn->result = false;
					$oReturn->errors = $oResult->errors;
										
				} else if(empty($oResult->data->id)){
					$oReturn->result = false;
					$oReturn->errors = 'missing-data-object';
				} else {
					
					$sOnlineStatus = !empty($oPostData->online) ? $oPostData->online : false;
					
					$this->setOnlineStatus($oResult->data->id,$sOnlineStatus);
					
					if(!empty($oPostData->images)){
						$this->parseImages($oResult->data->id,$oPostData->images);						
					}
					
					$oReturn->result = true;
					$oReturn->errors = false;
					$oReturn->article = $oResult->data->id;
				}				
			}			
		}
		
		$this->_oAPIResult = $oReturn;
	}
	
	function parseImages($iArticleID=false, $aImages=false){
				
		if(empty($iArticleID) || empty($aImages) || !is_array($aImages)){
			return;
		}		
		
		// get current images		
		$sEndpoint = API_ENDPOINT_OVIS . '/presentation/'.$iArticleID.'/images';
								
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);
		
		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		$aActiveImages = false;
		
		if(!empty($oResult->images) && is_array($oResult->images)){
			foreach($oResult->images as $image){
				$sURLPath = array_values(array_filter(explode('/',$image->url)));
				$sURLPathKey = str_ireplace('.jpg','',$sURLPath[2]);
				
				$aActiveImages[] = $sURLPathKey;
			}
		}	
				
		$iImageOrder = 1;		
		
		foreach($aImages as $sImage){
			
			$sURLPath = array_values(array_filter(explode('/',$sImage)));
			$sURLPathKey = !empty($sURLPath[2]) ? str_ireplace('.jpg','',$sURLPath[2]) : false;
			
			if(!empty($sURLPathKey) && in_array($sURLPathKey,$aActiveImages)){
				
				if (($key = array_search($sURLPathKey, $aActiveImages)) !== false) {
					unset($aActiveImages[$key]);
				}
				
				$this->updateImageOrder($this->_oUserData->id,$iArticleID,$sURLPathKey,$iImageOrder);
				
			} else {
				
				$this->addImage($this->_oUserData->id,$iArticleID,$sImage,$iImageOrder);
				
			}

			$iImageOrder++;			
		}
		
		if(!empty($aActiveImages) && is_array($aActiveImages)){
			foreach($aActiveImages as $sImage){
				
				$this->removeImage($this->_oUserData->id,$iArticleID,$sImage);	
			}
		}		
	}
	
	function removeImage($sUserId=false, $iArticleID=false, $sImage=false){
		
		if(empty($sUserId) || empty($iArticleID) || empty($sImage)){
			return;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/presentation/'.$iArticleID.'/images/delete';
				
		$oParams = new \stdClass();
		$oParams->userId = $sUserId;
		$oParams->image = $sImage.'.jpg';
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);
				
		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		
		$oResult = json_decode($sResult);
	}
	
	function addImage($sUserId=false, $iArticleID=false, $sImage=false, $iImageOrder=false){
				
		if(empty($sUserId) || empty($iArticleID) || empty($sImage) || empty($iImageOrder)){
			return;
		}
				
		$sEndpoint = API_ENDPOINT_OVIS . '/presentation/'.$iArticleID.'/images/addRaw';
		
		$aImageParts = explode('?',$sImage);
		if(count($aImageParts) > 1){
			array_pop($aImageParts);
		}

		$sImage = implode('?',$aImageParts);
				
		$sImageURL = $_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$sUserId.'/original_'.str_ireplace('/afbeelding/','',$sImage).'.jpg';							
		$sImageURLThumb = $_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$sUserId.'/thumb_'.str_ireplace('/afbeelding/','',$sImage).'.jpg';							
		$sImageData = base64_encode(file_get_contents($sImageURL));
				
		$oParams = new \stdClass();
		$oParams->userId = $sUserId;
		$oParams->order = $iImageOrder;
		$oParams->image = $sImageData;
		
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);
				
		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		
		$oResult = json_decode($sResult);
		
		if(!empty($oResult->result)){
			unlink($sImageURL);
			unlink($sImageURLThumb);
		}
		
		return;
		
	}
	
	function updateImageOrder($sUserId=false, $iArticleID=false, $sImageKey=false, $iImageOrder=false){
		if(empty($sUserId) || empty($iArticleID) || empty($sImageKey) || empty($iImageOrder)){
			return;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/presentation/'.$iArticleID.'/images/order';
				
		$oParams = new \stdClass();
		$oParams->userId = $sUserId;
		$oParams->image = $sImageKey.'.jpg';
		$oParams->order = $iImageOrder;
			
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);
				
		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		
		$oResult = json_decode($sResult);
		
		return;	
		
	}
	
	
	function setOnlineStatus($iArticleID=false, $sValue=false){
		
		if(empty($iArticleID) || empty($sValue)){
			return;
		}
		
		if(strtolower($sValue) != 'online' && strtolower($sValue) != 'offline'){
			return;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/presentationmodules/'.$iArticleID;
				
		$oParams = new \stdClass();
		$oParams->data = array();
		
		$oParamsOnline = new \stdClass();
		$oParamsOnline->module = 'online';
		$oParamsOnline->enabled = strtolower($sValue) == 'online' ? true : false;
		
		$oParams->data[] = $oParamsOnline;		
	
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);
				
		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		return;		
		
	}
	
	function parseRotateImage($iUserId=false,$iArticleId=false,$sImage=false,$sImageUrl=false,$sUnique=false){
		
		if(empty($sImage) || empty($sImageUrl) || empty($iUserId) || empty($iArticleId)){
			$oReturn = new \stdClass();
			$oReturn->result = false;
			$oReturn->errors = 'invalid-image';
			
			$this->_oAPIResult = $oReturn;
			
			return false;
		}
				
		$sEndpoint = API_ENDPOINT_OVIS . '/presentation/'.$iArticleId.'/photorotation/';
		
		$oParams = new \stdClass();			
		$oParams->imageID = $sImage.'.jpg'.(!empty($sUnique) ? '?'.$sUnique : false);
		$oParams->userID = $iUserId;
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		$this->_oAPIResult = $oResult;
		
		return;
		
		
	}
	
	function createImage($sSourceFile, $sDestinationFile, $sImagesPath){

		$arr_image_details = getimagesize($sImagesPath . $sSourceFile); // pass id to thumb name
		$original_width = $arr_image_details[0];
		$original_height = $arr_image_details[1];
		$new_width = $original_width;
		$new_height = $original_height;

		$dest_x = 0;
		$dest_y = 0;
		

		if ($arr_image_details[2] == IMAGETYPE_GIF){
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromGIF";
		}
		if ($arr_image_details[2] == IMAGETYPE_JPEG){
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromJPEG";
		}
		if ($arr_image_details[2] == IMAGETYPE_PNG){
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromPNG";
		}
		if ($imgt){
			$old_image = $imgcreatefrom($sImagesPath . $sSourceFile);
			$new_image = imagecreatetruecolor($new_width, $new_height);
			imagecopyresized($new_image, $old_image, $dest_x, $dest_y, 0, 0, $new_width, $new_height, $original_width, $original_height);
			$imgt($new_image, $sImagesPath . $sDestinationFile);
			
			chmod($sImagesPath . $sDestinationFile, 0777);
		}
		
		return true;

	}
	
	function createThumb($sSourceFile, $sDestinationFile, $sImagesPath){
		$thumbnail_width = 250;
		$thumbnail_height = 188;
		$thumb_beforeword = "thumb_";
		$arr_image_details = getimagesize($sImagesPath . $sSourceFile); // pass id to thumb name
		$original_width = $arr_image_details[0];
		$original_height = $arr_image_details[1];
		if ($original_width > $original_height){
			$new_width = $thumbnail_width;
			$new_height = intval($original_height * $new_width / $original_width);
		} else{
			$new_height = $thumbnail_height;
			$new_width = intval($original_width * $new_height / $original_height);
		}
		$dest_x = 0;
		$dest_y = 0;
		if ($arr_image_details[2] == IMAGETYPE_GIF){
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromGIF";
		}
		if ($arr_image_details[2] == IMAGETYPE_JPEG){
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromJPEG";
		}
		if ($arr_image_details[2] == IMAGETYPE_PNG){
			$imgt = "ImageJPEG";
			$imgcreatefrom = "ImageCreateFromPNG";
		}
		if ($imgt){
			$old_image = $imgcreatefrom($sImagesPath . $sSourceFile);
			$new_image = imagecreatetruecolor($new_width, $new_height);
			imagecopyresized($new_image, $old_image, $dest_x, $dest_y, 0, 0, $new_width, $new_height, $original_width, $original_height);
			$imgt($new_image, $sImagesPath . $sDestinationFile);
			
			chmod($sImagesPath . $sDestinationFile, 0777);
		}
		
		return true;
	}
	
	function parseTemplateDataSet($oDataset=false){
		
		if(empty($oDataset)){
			return false;
		}
		
		$oReturn = new \stdClass();
		
		if(!empty($oDataset->weightsMeasures->circulationSize)){
			$oReturn->circulationSize = $oDataset->weightsMeasures->circulationSize;
		}
		
		if(!empty($oDataset->weightsMeasures->headroom)){
			$oReturn->headroom = $oDataset->weightsMeasures->headroom;
		}
		
		if(!empty($oDataset->weightsMeasures->height)){
			$oReturn->height = $oDataset->weightsMeasures->height;
		}
		
		if(!empty($oDataset->weightsMeasures->width)){
			$oReturn->width = $oDataset->weightsMeasures->width;
		}
		
		if(!empty($oDataset->weightsMeasures->lengthConstruction)){
			$oReturn->lengthConstruction = $oDataset->weightsMeasures->lengthConstruction;
		}
		
		if(!empty($oDataset->weightsMeasures->lengthTotal)){
			$oReturn->lengthConstruction = $oDataset->weightsMeasures->lengthTotal;
		}
		
		if(!empty($oDataset->weightsMeasures->weightEmpty)){
			$oReturn->weightEmpty = $oDataset->weightsMeasures->weightEmpty;
		}
		
		if(!empty($oDataset->specsCamper->carBrand)){
			$oReturn->carBrand = $oDataset->specsCamper->carBrand;
		}	
		
		if(!empty($oDataset->specsCamper->engineHorsePower)){
			$oReturn->engineHorsePower = $oDataset->specsCamper->engineHorsePower;
		}	
		
		if(!empty($oDataset->specsCamper->fuel)){
			$oReturn->fuel = $oDataset->specsCamper->fuel;
		}	
		
		if(!empty($oDataset->specsCamper->euroclass)){
			$oReturn->euroClass = $oDataset->specsCamper->euroclass;
		}	
		
		if(!empty($oDataset->specsCamper->seatbelts)){
			$oReturn->seatbelts = $oDataset->specsCamper->seatbelts;
		}	
		
		if(!empty($oDataset->specsCamper->seats)){
			$oReturn->seats = $oDataset->specsCamper->seats;
		}	
		
		if(!empty($oDataset->specsCamper->tilt)){
			$oReturn->tilt = $oDataset->specsCamper->tilt;
		}	
		
		if(!empty($oDataset->specsCamper->numberOfAxes)){
			$oReturn->numberOfAxes = $oDataset->specsCamper->numberOfAxes;
		}
		
		if(!empty($oDataset->beds->numberOfSleepingPlaces)){
			$oReturn->sleepingplaces = $oDataset->beds->numberOfSleepingPlaces;
		}
		
		if(!empty($oDataset->beds->numberOfBeds)){
			$oReturn->beds = $oDataset->beds->numberOfBeds;
		}
		
		if(!empty($oDataset->accessories)){
			
			$oReturn->accessoriesList = array();
			
			foreach($oDataset->accessories as $accessoryGroup){			
				foreach($accessoryGroup as $accessory){			
					$oReturn->accessoriesList[] = strtolower($accessory);
				}
			}
		}
						
		if(!empty($oDataset->divisions)){
			
			$oReturn->divisionsList = array();
			
			foreach($oDataset->divisions as $divisionGroup){			
				foreach($divisionGroup as $division){			
					$oReturn->divisionsList[] = strtolower($division);
				}
			}
		}
		

		if(empty($oReturn)){
			return false;
		}	
		
		return $oReturn;
		
	}
	
	function parseDataSet($bFromLicenseplate=false){
		
		$oReturn = new \stdClass();
		$oReturn->language = empty($this->_oUserData->language) ? 'nl' : $this->_oUserData->language;
		$oReturn->id = empty($this->_oDetailsData->id) ? false : $this->_oDetailsData->id;
		$oReturn->externalId = empty($this->_oDetailsData->externalAdId) ? false : $this->_oDetailsData->externalAdId;
		
		if(empty($bFromLicenseplate)){
			
			$oReturn->afloopdatum = !empty($this->_oDetailsData->specifications->afloopDatum) && $this->_oDetailsData->specifications->afloopDatum != '0000-00-00' ? date('Y-m-d',strtotime($this->_oDetailsData->specifications->afloopDatum)) : false;
			$oReturn->online = !empty($this->_oDetailsData->specifications->stock) ? 'online' : (isset($this->_oDetailsData->specifications->stock) ? 'offline' : false);
			
			$oReturn->status = false;
			$oReturn->status = !empty($this->_oDetailsData->specifications->stock) ? 'verkoop' : $oReturn->status;
			$oReturn->status = !empty($this->_oDetailsData->specifications->expected) ? 'verwacht' : $oReturn->status;
			$oReturn->status = !empty($this->_oDetailsData->specifications->reserved) ? 'gereserveerd' : $oReturn->status;
			$oReturn->status = !empty($this->_oDetailsData->specifications->sold) ? 'verkocht' : $oReturn->status;
			
			$sStatusShow = $oReturn->status;
			
			if($sStatusShow == 'verkoop'){
				$sStatusShow = 'in verkoop';
			}			
					
			$oReturn->statusSynopsis = '';
			
			$oReturn->images = empty($this->_oDetailsData->mediainfo->images) ? false : $this->_oDetailsData->mediainfo->images;
		}
		
		$oReturn->photolabel = empty($this->_oDetailsData->mediainfo->images_label) ? false : strtolower($this->_oDetailsData->mediainfo->images_label);
		
		// main fields
		
		$oReturn->category = empty($this->_oDetailsData->specifications->category) ? false : $this->_oDetailsData->specifications->category;
		
		if(!empty($this->_oDetailsData->realm) && $this->_oDetailsData->realm == 'boat'){			
			$oReturn->brand = empty($this->_oDetailsData->specifications->brand) ? false : $this->_oDetailsData->specifications->brand;			
		} else {
			$oReturn->brand = empty($this->_oDetailsData->specifications->brandDisplay) ? false : $this->_oDetailsData->specifications->brandDisplay;
		}
		
		$oReturn->model = empty($this->_oDetailsData->specifications->modelDisplay) ? false : $this->_oDetailsData->specifications->modelDisplay;
		
		if(!empty($this->_oDetailsData->realm) && $this->_oDetailsData->realm == 'boat'){			
			$oReturn->license = empty($this->_oDetailsData->specifications->licensePlate) ? false : $this->_oDetailsData->specifications->licensePlate;
		} else {
			$oReturn->license = empty($this->_oDetailsData->specifications->licensePlateFull) ? (!empty($this->_oDetailsData->specifications->licensePlate) ? $this->_oDetailsData->specifications->licensePlate : false) : $this->_oDetailsData->specifications->licensePlateFull;
		}		
		
		$oReturn->titleSuffix = !empty($this->_oDetailsData->specifications->titleSuffix) ? $this->_oDetailsData->specifications->titleSuffix : false;
		
		if(!empty($oReturn->titleSuffix)){
			$sEuroISO = chr(128);
			$sSpaceISO = chr(194);
			$oReturn->titleSuffix = str_replace($sEuroISO, '&euro;', (trim($oReturn->titleSuffix)));
			$oReturn->titleSuffix = str_replace($sSpaceISO, '', (trim($oReturn->titleSuffix)));
		}
		
		$oReturn->version = !empty($this->_oDetailsData->specifications->version) ? $this->_oDetailsData->specifications->version : false;
		
		// type fields
		
		$oReturn->subcategory = false;
		
		if(!empty($this->_oDetailsData->specifications->specsCamper)){		
			$oReturn->subcategory = empty($this->_oDetailsData->specifications->specsCamper->category) ? false : $this->_oDetailsData->specifications->specsCamper->category;
		}
		
		if(!empty($this->_oDetailsData->specifications->specsBoat) || !empty($this->_oDetailsData->specifications->specsEngine) || !empty($this->_oDetailsData->specifications->specsBoatTrailer)){		
			$oReturn->subcategory = empty($this->_oDetailsData->specifications->subCategory) ? false : $this->_oDetailsData->specifications->subCategory;
		}
				
		$oReturn->condition = !empty($this->_oDetailsData->specifications->new) ? 'new' : (isset($this->_oDetailsData->specifications->new) ? 'used' : false);
		$oReturn->title = !empty($this->_oDetailsData->specifications->title) ? $this->_oDetailsData->specifications->title : false;
		
		$oReturn->chassisNumber = !empty($this->_oDetailsData->specifications->chassisNumber) ? $this->_oDetailsData->specifications->chassisNumber : false;
		
		$oReturn->mileage = !empty($this->_oDetailsData->specifications->specsCamper->mileage) ? $this->_oDetailsData->specifications->specsCamper->mileage : false;
		$oReturn->carBrand = !empty($this->_oDetailsData->specifications->specsCamper->carBrand) ? $this->_oDetailsData->specifications->specsCamper->carBrand : false;
		$oReturn->NAP = !empty($this->_oDetailsData->specifications->specsCamper->nap) ? true : false;
		
		if(!empty($this->_oDetailsData->realm) && $this->_oDetailsData->realm == 'boat'){
			$oReturn->fuel = !empty($this->_oDetailsData->specifications->specsBoat->engine->fuel) ? $this->_oDetailsData->specifications->specsBoat->engine->fuel : false;
		} else {
			$oReturn->fuel = !empty($this->_oDetailsData->specifications->specsCamper->fuel) ? $this->_oDetailsData->specifications->specsCamper->fuel : false;
		}
		
		$oReturn->transmission = !empty($this->_oDetailsData->specifications->specsCamper->transmission) ? $this->_oDetailsData->specifications->specsCamper->transmission : false;
		$oReturn->euroClass = !empty($this->_oDetailsData->specifications->specsCamper->euroclass) ? $this->_oDetailsData->specifications->specsCamper->euroclass : false;
		$oReturn->engineHorsePower = !empty($this->_oDetailsData->specifications->specsCamper->engineHorsePower) ? number_format($this->_oDetailsData->specifications->specsCamper->engineHorsePower,0,'','.') : false;
		$oReturn->walls = !empty($this->_oDetailsData->specifications->specsCamper->walls) ? $this->_oDetailsData->specifications->specsCamper->walls : false;
		$oReturn->wallscolor = !empty($this->_oDetailsData->specifications->specsCamper->wallsColor) ? $this->_oDetailsData->specifications->specsCamper->wallsColor : false;
		
		$oReturn->colorTrailer = !empty($this->_oDetailsData->specifications->specsTrailer->color) ? $this->_oDetailsData->specifications->specsTrailer->color : false;
				
		$oReturn->seats = !empty($this->_oDetailsData->specifications->specsCamper->seats) ? $this->_oDetailsData->specifications->specsCamper->seats : false;
		$oReturn->seatbelts = !empty($this->_oDetailsData->specifications->specsCamper->seatbelts) ? $this->_oDetailsData->specifications->specsCamper->seatbelts : false;
		$oReturn->metallic = !empty($this->_oDetailsData->specifications->specsCamper->metallic) ? $this->_oDetailsData->specifications->specsCamper->metallic : false;
		$oReturn->particulateFilter = !empty($this->_oDetailsData->specifications->specsCamper->particulateFilter) ? $this->_oDetailsData->specifications->specsCamper->particulateFilter : false;
		
		$oReturn->damaged = !empty($this->_oDetailsData->specifications->damaged) ? $this->_oDetailsData->specifications->damaged : false;
		$oReturn->demo = !empty($this->_oDetailsData->specifications->demo) ? $this->_oDetailsData->specifications->demo : false;
		$oReturn->exRental = !empty($this->_oDetailsData->specifications->exRental) ? $this->_oDetailsData->specifications->exRental : false;
		$oReturn->possibleRental = !empty($this->_oDetailsData->specifications->rental) ? $this->_oDetailsData->specifications->rental : false;
		$oReturn->hailDamage = !empty($this->_oDetailsData->specifications->hailDamage) ? $this->_oDetailsData->specifications->hailDamage : false;
		$oReturn->maintenanceBooklets = !empty($this->_oDetailsData->specifications->maintenanceBooklets) ? $this->_oDetailsData->specifications->maintenanceBooklets : false;
		$oReturn->suitableForDisabledPeople = !empty($this->_oDetailsData->specifications->suitableForDisabledPeople) ? $this->_oDetailsData->specifications->suitableForDisabledPeople : false;
		$oReturn->owners = !empty($this->_oDetailsData->specifications->owners) ? $this->_oDetailsData->specifications->owners : false;
		
		$oReturn->material = empty($this->_oDetailsData->specifications->specsMobileHome->material) ? false : $this->_oDetailsData->specifications->specsMobileHome->material;
		$oReturn->materialTentTrailer = empty($this->_oDetailsData->specifications->specsTentTrailer->material) ? false : $this->_oDetailsData->specifications->specsTentTrailer->material;	
		
		$oReturn->brakes = !empty($this->_oDetailsData->specifications->specsTrailer->brakes) ? ($this->_oDetailsData->specifications->specsTrailer->brakes == 'geremd' ? true : false ) : false;
		
		$oReturn->numberOfDoors = !empty($this->_oDetailsData->specifications->specsTrailer->numberOfDoors) ? $this->_oDetailsData->specifications->specsTrailer->numberOfDoors : false;
		$oReturn->doorTypes = !empty($this->_oDetailsData->specifications->specsTrailer->doorTypes) ? $this->_oDetailsData->specifications->specsTrailer->doorTypes : false;
		$oReturn->plug = !empty($this->_oDetailsData->specifications->specsTrailer->plug) ? $this->_oDetailsData->specifications->specsTrailer->plug : false;
		$oReturn->kipAngle = !empty($this->_oDetailsData->specifications->specsTrailer->kipAngle) ? $this->_oDetailsData->specifications->specsTrailer->kipAngle : false;
		$oReturn->axles = !empty($this->_oDetailsData->specifications->specsTrailer->axles) ? $this->_oDetailsData->specifications->specsTrailer->axles : false;
		$oReturn->floorMaterial = !empty($this->_oDetailsData->specifications->specsTrailer->materialFloor) ? $this->_oDetailsData->specifications->specsTrailer->materialFloor : false;
		$oReturn->wallMaterial = !empty($this->_oDetailsData->specifications->specsTrailer->materialBorders) ? $this->_oDetailsData->specifications->specsTrailer->materialBorders : false;
		
		$oReturn->modelBoat = !empty($this->_oDetailsData->specifications->modelVersion) ? $this->_oDetailsData->specifications->modelVersion : false;
		$oReturn->titleBoat = !empty($this->_oDetailsData->specifications->titleManual) ? $this->_oDetailsData->specifications->titleManual : false;
		$oReturn->ligplaatsBoat = !empty($this->_oDetailsData->specifications->specsBoat->berth) ? $this->_oDetailsData->specifications->specsBoat->berth : false;
		$oReturn->trailerBoat = !empty($this->_oDetailsData->specifications->specsBoat->trailerIncluded) ? $this->_oDetailsData->specifications->specsBoat->trailerIncluded : false;
		$oReturn->personsBoat = !empty($this->_oDetailsData->specifications->specsBoat->numberOfSeats) ? $this->_oDetailsData->specifications->specsBoat->numberOfSeats : false;
		$oReturn->materialBoat = !empty($this->_oDetailsData->specifications->specsBoat->hullMaterial) ? $this->_oDetailsData->specifications->specsBoat->hullMaterial : false;
		$oReturn->colorBoat = !empty($this->_oDetailsData->specifications->specsBoat->hullColor) ? $this->_oDetailsData->specifications->specsBoat->hullColor : false;
		$oReturn->deckBoat = !empty($this->_oDetailsData->specifications->specsBoat->deckColor) ? $this->_oDetailsData->specifications->specsBoat->deckColor : false;
		
		$oReturn->sizeBoat = !empty($this->_oDetailsData->specifications->specsBoatTrailer->suitableBoats) ? $this->_oDetailsData->specifications->specsBoatTrailer->suitableBoats : false;
		$oReturn->kantelbaar = !empty($this->_oDetailsData->specifications->specsBoatTrailer->tilt) ? $this->_oDetailsData->specifications->specsBoatTrailer->tilt : false;
		$oReturn->braked = !empty($this->_oDetailsData->specifications->specsBoatTrailer->breaked) ? true : false;
		$oReturn->numberOfAxes = !empty($this->_oDetailsData->specifications->specsBoatTrailer->numberOfAxes) ? $this->_oDetailsData->specifications->specsBoatTrailer->numberOfAxes : false;
		$oReturn->boatTrailerPlug = !empty($this->_oDetailsData->specifications->specsBoatTrailer->plug) ? $this->_oDetailsData->specifications->specsBoatTrailer->plug : false;
		$oReturn->boatTrailerAxles = !empty($this->_oDetailsData->specifications->specsBoatTrailer->numberOfAxes) ? $this->_oDetailsData->specifications->specsBoatTrailer->numberOfAxes : false;
		
		$oReturn->numberOfEngines = !empty($this->_oDetailsData->specifications->specsBoat->numberOfEngines) ? $this->_oDetailsData->specifications->specsBoat->numberOfEngines : false;
		$oReturn->boatEngineHasEngine = !empty($this->_oDetailsData->specifications->specsBoat->engine->hasEngine) ? true : false;
		$oReturn->boatEngineType = !empty($this->_oDetailsData->specifications->specsBoat->engine->type) ? $this->_oDetailsData->specifications->specsBoat->engine->type : false;
		$oReturn->boatEngineStartsystem = !empty($this->_oDetailsData->specifications->specsBoat->engine->startSystem) ? $this->_oDetailsData->specifications->specsBoat->engine->startSystem : false;
		$oReturn->boatEngineFuel = !empty($this->_oDetailsData->specifications->specsBoat->engine->fuel) ? $this->_oDetailsData->specifications->specsBoat->engine->fuel : false;
		$oReturn->boatEngineBrand = !empty($this->_oDetailsData->specifications->specsBoat->engine->brand) ? $this->_oDetailsData->specifications->specsBoat->engine->brand : false;
		$oReturn->boatEngineModel = !empty($this->_oDetailsData->specifications->specsBoat->engine->model) ? $this->_oDetailsData->specifications->specsBoat->engine->model : false;
		$oReturn->boatEnginePower = !empty($this->_oDetailsData->specifications->specsBoat->engine->power) ? $this->_oDetailsData->specifications->specsBoat->engine->power : false;
		$oReturn->boatEngineHours = !empty($this->_oDetailsData->specifications->specsBoat->engine->runHours) ? number_format($this->_oDetailsData->specifications->specsBoat->engine->runHours,0,'','.') : false;
		$oReturn->boatEngineAccu = !empty($this->_oDetailsData->specifications->specsBoat->engine->runHours) ? number_format($this->_oDetailsData->specifications->specsBoat->engine->runHours,0,'','.') : false;
		//$oReturn->boatEngineCruisingSpeed = !empty($this->_oDetailsData->specifications->specsBoat->engine->cruisingSpeed) ? number_format($this->_oDetailsData->specifications->specsBoat->engine->cruisingSpeed,0,'','.') : false;
		$oReturn->boatEngineFastSailing = !empty($this->_oDetailsData->specifications->specsBoat->fastSailing) ? true : false;
		$oReturn->boatEngineTankCapacity = !empty($this->_oDetailsData->specifications->specsBoat->engine->tankCapacity) ? number_format($this->_oDetailsData->specifications->specsBoat->engine->tankCapacity,0,'','.') : false;
				
		$oReturn->typeSynopsis = '';
		
		if(!empty($oReturn->subcategory) || !empty($oReturn->condition) || !empty($oReturn->title) || !empty($oReturn->chassisNumber) || !empty($oReturn->mileage) || !empty($oReturn->carBrand) || !empty($oReturn->NAP) || !empty($oReturn->fuel) || !empty($oReturn->transmission) || !empty($oReturn->euroClass) || !empty($oReturn->engineHorsePower) || !empty($oReturn->walls) || !empty($oReturn->wallscolor) || !empty($oReturn->colorTrailer) || !empty($oReturn->seats) || !empty($oReturn->seatbelts) || !empty($oReturn->metallic) || !empty($oReturn->particulateFilter) || !empty($oReturn->damaged) || !empty($oReturn->demo) || !empty($oReturn->exRental) || !empty($oReturn->possibleRental) || !empty($oReturn->hailDamage) || !empty($oReturn->maintenanceBooklets) || !empty($oReturn->suitableForDisabledPeople) || !empty($oReturn->owner) || !empty($oReturn->material) || !empty($oReturn->materialTentTrailer) || !empty($oReturn->brakes) || !empty($oReturn->numberOfDoors) || !empty($oReturn->doorTypes) || !empty($oReturn->plug) || !empty($oReturn->kipAngle) || !empty($oReturn->axles) || !empty($oReturn->floorMaterial) || !empty($oReturn->wallMaterial) || !empty($oReturn->modelBoat) || !empty($oReturn->titleBoat) || !empty($oReturn->ligplaatsBoat) || !empty($oReturn->trailerBoat) || !empty($oReturn->personsBoat) || !empty($oReturn->materialBoat) || !empty($oReturn->colorBoat) || !empty($oReturn->deckBoat) || !empty($oReturn->sizeBoat) || !empty($oReturn->kantelbaar) || !empty($oReturn->braked) || !empty($oReturn->numberOfAxes) || !empty($oReturn->boatTrailerPlug) || !empty($oReturn->boatTrailerAxles) || !empty($oReturn->numberOfEngines) || !empty($oReturn->boatEngineHasEngine) || !empty($oReturn->boatEngineType) || !empty($oReturn->boatEngineStartsystem) || !empty($oReturn->boatEngineFuel) || !empty($oReturn->boatEngineBrand) || !empty($oReturn->boatEngineModel) || !empty($oReturn->boatEnginePowe) || !empty($oReturn->boatEngineHours) || !empty($oReturn->boatEngineAccu) || !empty($oReturn->boatEngineCruisingSpeed) || !empty($oReturn->boatEngineFastSailing) || !empty($oReturn->boatEngineTankCapacity)){
			//$oReturn->typeSynopsis = '1';
		}
		
		$oReturn->engineFuel = !empty($this->_oDetailsData->specifications->specsEngine->fuel) ? $this->_oDetailsData->specifications->specsEngine->fuel : false;
		$oReturn->engineSteering = !empty($this->_oDetailsData->specifications->specsEngine->steering) ? $this->_oDetailsData->specifications->specsEngine->steering : false;
		$oReturn->engineStartsystem = !empty($this->_oDetailsData->specifications->specsEngine->startSystem) ? $this->_oDetailsData->specifications->specsEngine->startSystem : false;
		$oReturn->enginePower = !empty($this->_oDetailsData->specifications->specsEngine->power) ? $this->_oDetailsData->specifications->specsEngine->power : false;
		$oReturn->engineTailLength = !empty($this->_oDetailsData->specifications->specsEngine->tailLength) ? $this->_oDetailsData->specifications->specsEngine->tailLength : false;
		$oReturn->engineTankCapacity = !empty($this->_oDetailsData->specifications->specsEngine->tankCapacity) ? number_format($this->_oDetailsData->specifications->specsEngine->tankCapacity,0,'','.') : false;
		$oReturn->engineCylinders = !empty($this->_oDetailsData->specifications->specsEngine->numberOfCylinders) ? $this->_oDetailsData->specifications->specsEngine->numberOfCylinders : false;
		$oReturn->engineSize = !empty($this->_oDetailsData->specifications->specsEngine->engineSize) ? number_format($this->_oDetailsData->specifications->specsEngine->engineSize,0,'','.') : false;
		$oReturn->engineDryWeight = !empty($this->_oDetailsData->specifications->specsEngine->weightDry) ? number_format($this->_oDetailsData->specifications->specsEngine->weightDry,0,'','.') : false;
			
		$oReturn->enginesSynopsis = '';
		
		if(!empty($oReturn->engineFuel) || !empty($oReturn->engineSteering) || !empty($oReturn->engineStartsystem) || !empty($oReturn->enginePower) || !empty($oReturn->engineTailLength) || !empty($oReturn->engineTankCapacity) || !empty($oReturn->engineCylinders) || !empty($oReturn->engineSize) || !empty($oReturn->engineDryWeight)){
			//$oReturn->enginesSynopsis = '1';
		}		
		
		$oReturn->accessoriesSynopsis = '';
		$oReturn->accessoriesList = array();
		
		if(!empty($this->_oDetailsData->specifications->accessories) && is_array($this->_oDetailsData->specifications->accessories)){
			foreach($this->_oDetailsData->specifications->accessories as $accessory){			
				//$oReturn->accessoriesSynopsis = '1';
				$oReturn->accessoriesList[] = strtolower($accessory->description);
			}
		}
		
		$oReturn->divisionsSynopsis = '';
		$oReturn->divisionsList = array();
		$oReturn->divisions = false;
		
		if(!empty($this->_oDetailsData->specifications->specsCaravan->division)){
			$oReturn->divisions = $this->_oDetailsData->specifications->specsCaravan->division;		
		} elseif(!empty($this->_oDetailsData->specifications->specsCamper->division)){
			$oReturn->divisions = $this->_oDetailsData->specifications->specsCamper->division;		
		}	
		
		if(!empty($oReturn->divisions) && is_array($oReturn->divisions)){
			foreach($oReturn->divisions as $division){			
				//$oReturn->divisionsSynopsis = '1';
				$oReturn->divisionsList[] = strtolower($division->division);
			}
		}
		
		$oReturn->constructionYear = !empty($this->_oDetailsData->specifications->dates->constructionYear) ? $this->_oDetailsData->specifications->dates->constructionYear : false;
		$oReturn->constructionMonth = !empty($this->_oDetailsData->specifications->dates->constructionMonth) ? $this->_oDetailsData->specifications->dates->constructionMonth : false;
		$oReturn->modelYear = !empty($this->_oDetailsData->specifications->dates->modelYear) ? $this->_oDetailsData->specifications->dates->modelYear : false;
		$oReturn->dateArrival = !empty($this->_oDetailsData->specifications->dates->dateArrival) && $this->_oDetailsData->specifications->dates->dateArrival != '0000-00-00' ? date('d-m-Y',strtotime($this->_oDetailsData->specifications->dates->dateArrival)) : false;
		$oReturn->datePart1a = !empty($this->_oDetailsData->specifications->dates->datePart1a) && $this->_oDetailsData->specifications->dates->datePart1a != '0000-00-00' ? date('d-m-Y',strtotime($this->_oDetailsData->specifications->dates->datePart1a)) : false;
		
		$oReturn->datesSynopsis = '';
		
		if(!empty($oReturn->constructionYear) || !empty($oReturn->constructionMonth) || !empty($oReturn->modelYear) || !empty($oReturn->dateArrival) || !empty($oReturn->datePart1a)){
			//$oReturn->datesSynopsis = '1';
		}		
				
		$oReturn->length = !empty($this->_oDetailsData->specifications->weightsMeasures->length) ? number_format($this->_oDetailsData->specifications->weightsMeasures->length,0,'','.') : false;
		$oReturn->lengthConstruction = !empty($this->_oDetailsData->specifications->weightsMeasures->lengthConstruction) ? number_format($this->_oDetailsData->specifications->weightsMeasures->lengthConstruction,0,'','.') : false;
		$oReturn->lengthTotal = !empty($this->_oDetailsData->specifications->weightsMeasures->lengthTotal) ? number_format($this->_oDetailsData->specifications->weightsMeasures->lengthTotal,0,'','.') : false;
		$oReturn->width = !empty($this->_oDetailsData->specifications->weightsMeasures->width) ? number_format($this->_oDetailsData->specifications->weightsMeasures->width,0,'','.') : false;
		$oReturn->height = !empty($this->_oDetailsData->specifications->weightsMeasures->height) ? number_format($this->_oDetailsData->specifications->weightsMeasures->height,0,'','.') : false;
		$oReturn->headroom = !empty($this->_oDetailsData->specifications->weightsMeasures->headroom) ? number_format($this->_oDetailsData->specifications->weightsMeasures->headroom,0,'','.') : false;	
		$oReturn->weightEmpty = !empty($this->_oDetailsData->specifications->weightsMeasures->weightEmpty) ? number_format($this->_oDetailsData->specifications->weightsMeasures->weightEmpty,0,'','.') : false;
		$oReturn->weightMaximum = !empty($this->_oDetailsData->specifications->weightsMeasures->weightMaximum) ? number_format($this->_oDetailsData->specifications->weightsMeasures->weightMaximum,0,'','.') : false;
		$oReturn->capacity = !empty($this->_oDetailsData->specifications->weightsMeasures->capacity) ? number_format($this->_oDetailsData->specifications->weightsMeasures->capacity,0,'','.') : false;	
		$oReturn->weightOperational = !empty($this->_oDetailsData->specifications->weightsMeasures->weightOperational) ? number_format($this->_oDetailsData->specifications->weightsMeasures->weightOperational,0,'','.') : false;
		$oReturn->circulationSize = !empty($this->_oDetailsData->specifications->weightsMeasures->circulationSize) ? $this->_oDetailsData->specifications->weightsMeasures->circulationSize : false;				
		$oReturn->lengthContainer = !empty($this->_oDetailsData->specifications->specsTrailer->lengthContainer) ? number_format($this->_oDetailsData->specifications->specsTrailer->lengthContainer,0,'','.') : false;		
		$oReturn->lengthTotalTrailer = !empty($this->_oDetailsData->specifications->specsTrailer->lengthTotal) ? number_format($this->_oDetailsData->specifications->specsTrailer->lengthTotal,0,'','.') : false;
		$oReturn->lengthDrawbar = !empty($this->_oDetailsData->specifications->specsTrailer->lengthAdz) ? number_format($this->_oDetailsData->specifications->specsTrailer->lengthAdz,0,'','.') : false;
		$oReturn->widthTotal = !empty($this->_oDetailsData->specifications->specsTrailer->widthTotal) ? number_format($this->_oDetailsData->specifications->specsTrailer->widthTotal,0,'','.') : false;
		$oReturn->widthContainer = !empty($this->_oDetailsData->specifications->specsTrailer->widthContainer) ? number_format($this->_oDetailsData->specifications->specsTrailer->widthContainer,0,'','.') : false;
		$oReturn->heightLoadingPlatform = !empty($this->_oDetailsData->specifications->specsTrailer->heightLoadingPlatform) ? number_format($this->_oDetailsData->specifications->specsTrailer->heightLoadingPlatform,0,'','.') : false;
		$oReturn->heightCoupler = !empty($this->_oDetailsData->specifications->specsTrailer->heightCoupler) ? number_format($this->_oDetailsData->specifications->specsTrailer->heightCoupler,0,'','.') : false;
		$oReturn->heightLadderRack = !empty($this->_oDetailsData->specifications->specsTrailer->heightLadderRack) ? number_format($this->_oDetailsData->specifications->specsTrailer->heightLadderRack,0,'','.') : false;
		$oReturn->heightBorders = !empty($this->_oDetailsData->specifications->specsTrailer->heightBorders) ? number_format($this->_oDetailsData->specifications->specsTrailer->heightBorders,0,'','.') : false;
		$oReturn->heightTotal = !empty($this->_oDetailsData->specifications->specsTrailer->heightTotal) ? number_format($this->_oDetailsData->specifications->specsTrailer->heightTotal,0,'','.') : false;
		$oReturn->heightBasePlate = !empty($this->_oDetailsData->specifications->specsTrailer->heightBasePlate) ? number_format($this->_oDetailsData->specifications->specsTrailer->heightBasePlate,0,'','.') : false;
		$oReturn->heightInternal = !empty($this->_oDetailsData->specifications->specsTrailer->heightInternal) ? number_format($this->_oDetailsData->specifications->specsTrailer->heightInternal,0,'','.') : false;
		$oReturn->tireSize = !empty($this->_oDetailsData->specifications->specsTrailer->sizeTires) ? number_format($this->_oDetailsData->specifications->specsTrailer->sizeTires,0,'','.') : false;		
		$oReturn->volume = !empty($this->_oDetailsData->specifications->specsTrailer->volume) ? number_format($this->_oDetailsData->specifications->specsTrailer->volume,0,'','.') : false;		
		$oReturn->depth = !empty($this->_oDetailsData->specifications->weightsMeasures->draft) ? number_format($this->_oDetailsData->specifications->weightsMeasures->draft,0,'','.') : false;
		$oReturn->verticalclearance = !empty($this->_oDetailsData->specifications->weightsMeasures->verticalClearance) ? number_format($this->_oDetailsData->specifications->weightsMeasures->verticalClearance,0,'','.') : false;
		
		$oReturn->sizesSynopsis = '';
		
		if(!empty($oReturn->length) || !empty($oReturn->lengthConstruction) || !empty($oReturn->lengthTotal) || !empty($oReturn->width) || !empty($oReturn->height) || !empty($oReturn->headroom) || !empty($oReturn->weightEmpty) || !empty($oReturn->weightMaximum) || !empty($oReturn->capacity) || !empty($oReturn->weightOperational) || !empty($oReturn->circulationSize) || !empty($oReturn->lengthContainer) || !empty($oReturn->lengthTotalTrailer) || !empty($oReturn->lengthDrawbar) || !empty($oReturn->widthTotal) || !empty($oReturn->widthContainer) || !empty($oReturn->heightLoadingPlatform) || !empty($oReturn->heightCoupler) || !empty($oReturn->heightLadderRack) || !empty($oReturn->heightBorders) || !empty($oReturn->heightTotal) || !empty($oReturn->heightBasePlate) || !empty($oReturn->heightInternal) || !empty($oReturn->tireSize) || !empty($oReturn->volume) || !empty($oReturn->depth) || !empty($oReturn->verticalclearance)){
			//$oReturn->sizesSynopsis = '1';
		}
					
		if(!empty($this->_oDetailsData->realm) && $this->_oDetailsData->realm == 'boat'){
			$oReturn->sleepingplaces = !empty($this->_oDetailsData->specifications->specsBoat->beds->numberOfSleepingPlaces) ? $this->_oDetailsData->specifications->specsBoat->beds->numberOfSleepingPlaces : false;	
		} else {		
			$oReturn->sleepingplaces = !empty($this->_oDetailsData->specifications->beds->numberOfSleepingPlaces) ? $this->_oDetailsData->specifications->beds->numberOfSleepingPlaces : false;	
		}		
		
		$oReturn->bedsBoat = !empty($this->_oDetailsData->specifications->specsBoat->beds->numberOfBeds) ? $this->_oDetailsData->specifications->specsBoat->beds->numberOfBeds : false;
		$oReturn->beds = !empty($this->_oDetailsData->specifications->beds->numberOfBeds) ? $this->_oDetailsData->specifications->beds->numberOfBeds : false;
		$oReturn->bedrooms = !empty($this->_oDetailsData->specifications->beds->bedrooms) ? $this->_oDetailsData->specifications->beds->bedrooms : false;
		$oReturn->bedspecifications = !empty($this->_oDetailsData->specifications->beds->bedSpecifications) ? $this->_oDetailsData->specifications->beds->bedSpecifications : false;
		
		$oReturn->bedsSynopsis = '';
		
		if(!empty($oReturn->bedsBoat) || !empty($oReturn->beds) || !empty($oReturn->bedrooms) || !empty($oReturn->bedspecifications) ){
			//$oReturn->bedsSynopsis = '1';
		}
		
		$oReturn->featuresSynopsis = '';
				
		if(empty($bFromLicenseplate)){
		
			$oReturn->reference = !empty($this->_oDetailsData->specifications->memo) ? nl2br($this->cleanUpList($this->_oDetailsData->specifications->memo)) : false;
			
			$oReturn->memo = !empty($this->_oDetailsData->specifications->descriptionClean) ? nl2br($this->cleanUpList($this->_oDetailsData->specifications->descriptionClean)) : (!empty($this->_oUserData->defaultDescription) ? nl2br($this->cleanUpList($this->_oUserData->defaultDescription)) : false);
			$oReturn->description = !empty($this->_oDetailsData->specifications->descriptionEngine) ? nl2br($this->cleanUpList($this->_oDetailsData->specifications->descriptionEngine)) : false;
			
			$oReturn->memoSynopsis = false;
			
			$oReturn->price = !empty($this->_oDetailsData->specifications->prices->price) ? $this->_oDetailsData->specifications->prices->price/100 : false;
			$oReturn->priceFrom = !empty($this->_oDetailsData->specifications->prices->retail) ? $this->_oDetailsData->specifications->prices->retail/100 : false;
			$oReturn->vat = !empty($this->_oDetailsData->specifications->prices->vat) ? $this->_oDetailsData->specifications->prices->vat : false;
			
			if($oReturn->vat != 'marge'){
				
				if(strtolower($oReturn->vat) == 'btw'){
					$oReturn->vat = 'Inclusief BTW';
				}				
			}
			
			$oReturn->pricesSynopsis = false;
			
			if(isset($this->_oDetailsData->specifications->specsMarktplaats)){
				$oReturn->marktplaatsTitle = !empty($this->_oDetailsData->specifications->specsMarktplaats->title) ? $this->_oDetailsData->specifications->specsMarktplaats->title : false;
				$oReturn->marktplaatsPriceModel = !empty($this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_PriceModel) ? $this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_PriceModel : false;
				$oReturn->marktplaatsPriceModelToShow = !empty($this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_PriceModel) ? $this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_PriceModel : false;
				
				if(!empty($oReturn->marktplaatsPriceModel)){
					switch($oReturn->marktplaatsPriceModel){
						case 'bidding':
							$oReturn->marktplaatsPriceModel = 'Bieden';
							break;
						case 'to be discussed':
							$oReturn->marktplaatsPriceModel = 'Nader overeen te komen';
							break;
						case 'by request':
							$oReturn->marktplaatsPriceModel = 'Prijs op aanvraag';
							break;
						case 'trade':
							$oReturn->marktplaatsPriceModel = 'Ruilen';
							break;
						case 'reserved':
							$oReturn->marktplaatsPriceModel = 'Gereserveerd';
							break;
						default:
							$oReturn->marktplaatsPriceModel = 'Vaste prijs';
							break;
						
					}
				}
				
				$oReturn->marktplaatsPrice = !empty($this->_oDetailsData->specifications->specsMarktplaats->price) ? $this->_oDetailsData->specifications->specsMarktplaats->price/100 : false;
				$oReturn->marktplaatsBidPrice = !empty($this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_BidAskingPrice) ? $this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_BidAskingPrice/100 : false;
				$oReturn->marktplaatsBidMinimalPrice = !empty($this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_MinimalBid) ? $this->_oDetailsData->specifications->specsMarktplaats->priceType->APM_MinimalBid/100 : false;
				
				$oReturn->marktplaatsDescription = !empty($this->_oDetailsData->specifications->specsMarktplaats->description) ? nl2br($this->cleanUpList($this->_oDetailsData->specifications->specsMarktplaats->description)) : false;
				
				$oReturn->marktplaatsSynopsis = '';
			} else {			
				
				$oReturn->marktplaatsTitle = !empty($this->_oDetailsData->specifications->marktplaats->title) ? $this->_oDetailsData->specifications->marktplaats->title : false;
				$oReturn->marktplaatsPriceModel = !empty($this->_oDetailsData->specifications->marktplaats->priceType->APM_PriceModel) ? $this->_oDetailsData->specifications->marktplaats->priceType->APM_PriceModel : false;
				$oReturn->marktplaatsPriceModelToShow = !empty($this->_oDetailsData->specifications->marktplaats->priceType->APM_PriceModel) ? $this->_oDetailsData->specifications->marktplaats->priceType->APM_PriceModel : false;
				
				if(!empty($oReturn->marktplaatsPriceModel)){
					switch($oReturn->marktplaatsPriceModel){
						case 'bidding':
							$oReturn->marktplaatsPriceModel = 'Bieden';
							break;
						case 'to be discussed':
							$oReturn->marktplaatsPriceModel = 'Nader overeen te komen';
							break;
						case 'by request':
							$oReturn->marktplaatsPriceModel = 'Prijs op aanvraag';
							break;
						case 'trade':
							$oReturn->marktplaatsPriceModel = 'Ruilen';
							break;
						case 'reserved':
							$oReturn->marktplaatsPriceModel = 'Gereserveerd';
							break;
						default:
							$oReturn->marktplaatsPriceModel = 'Vaste prijs';
							break;
						
					}
				}
				
				$oReturn->marktplaatsPrice = !empty($this->_oDetailsData->specifications->marktplaats->price) ? $this->_oDetailsData->specifications->marktplaats->price/100 : false;
				$oReturn->marktplaatsBidPrice = !empty($this->_oDetailsData->specifications->marktplaats->priceType->APM_BidAskingPrice) ? $this->_oDetailsData->specifications->marktplaats->priceType->APM_BidAskingPrice/100 : false;
				$oReturn->marktplaatsBidMinimalPrice = !empty($this->_oDetailsData->specifications->marktplaats->priceType->APM_MinimalBid) ? $this->_oDetailsData->specifications->marktplaats->priceType->APM_MinimalBid/100 : false;
				
				$oReturn->marktplaatsDescription = !empty($this->_oDetailsData->specifications->marktplaats->description) ? nl2br($this->cleanUpList($this->_oDetailsData->specifications->marktplaats->description)) : false;
				
				$oReturn->marktplaatsSynopsis = '';
			}
		}
		
		$this->parsedDetails = $oReturn;
		
		return;
		
	}
	
	function parseAutofillTemplate($sTemplateId=false){
		if(empty($sTemplateId)){
			return false;
		}	

		$sEndpoint = API_ENDPOINT_OVIS . '/autofillmodel/';
		
		$oParams = new \stdClass();
		$oParams->modelId = $sTemplateId;
		$oParams->minPrct = 0;
		$oParams->minItems = 1;
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);

		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
				
		$oParsedTemplateData = false;
		
		if(!empty($oResult->result)){
			if(!empty($oResult->data)){
				$oParsedTemplateData = $this->parseTemplateDataSet($oResult->data);
			}
		}
		
		$oReturn = new \stdClass();
		$oReturn->result = true;
		$oReturn->data = !empty($oParsedTemplateData) ? $oParsedTemplateData :'no-data';
		
		$this->_oAPIResult = $oReturn;
		
	}
	
	function parseAutofillArticle($sCategory=false,$sLicense=false){
		
		if(empty($sCategory) || empty($sLicense)){
			return false;
		}
				
		$sLicense = str_replace(' ','',$sLicense);
		
		$sEndpoint = API_ENDPOINT_OVIS . '/autofillvehicle/'.strtolower($sCategory).'/'.strtoupper($sLicense);
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		if(!empty($oResult->data)){
			$this->_oDetailsData = $oResult->data;
			
			$this->parseDataSet(true);
		}
		
		$oReturn = new \stdClass();
		$oReturn->license = $sLicense;
		$oReturn->result = true;
		$oReturn->data = !empty($this->parsedDetails) ? $this->parsedDetails : 'no-data';
		
		$this->_oAPIResult = $oReturn;
		
		return;
	}
	
	function getDetails($iUserId=false,$sArticleId=false){
		
		if(empty($iUserId) || empty($sArticleId) || !is_numeric($sArticleId)){
			return false;
		}
		
		$iArticleId = (int) $sArticleId;
		
		$sEndpoint = API_ENDPOINT_OVIS . '/presentation/'.$iArticleId;
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
				
		if(!empty($oResult->result) && empty($oResult->errors) && !empty($oResult->data)){
			$this->_oDetailsData = $oResult->data;
		}
		
		return;	
		
	}
	
	function parseGetAccessories($iUserId=false,$sDepartment='sale'){
		
		$sEndpoint = API_ENDPOINT_OVIS . '/' . $this->_oUserData->realm . '/accessories/'.$iUserId;
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		$aAccessories = false;
		
		if(empty($oReturn->errors)){
			$aAccessories = array();
			
			if(!empty($oResult->data)){
			
				foreach($oResult->data as $sAccessoriesCategoryKey => $sAccessoryCategory){
					
					if(!empty($sAccessoryCategory) && is_array($sAccessoryCategory)){
					
						if(!array_key_exists($sAccessoriesCategoryKey,$aAccessories)){
							$aAccessories[$sAccessoriesCategoryKey] = array();
						}
						
						foreach($sAccessoryCategory as $oAccessory){
							if(!empty($oAccessory->accessoryCategory) && !empty($oAccessory->description)){
							
								if(!array_key_exists($oAccessory->accessoryCategoryId,$aAccessories[$sAccessoriesCategoryKey])){
									$aAccessories[$sAccessoriesCategoryKey][$oAccessory->accessoryCategoryId] = array();
									$aAccessories[$sAccessoriesCategoryKey][$oAccessory->accessoryCategoryId]['title'] = $oAccessory->accessoryCategory;
									$aAccessories[$sAccessoriesCategoryKey][$oAccessory->accessoryCategoryId]['accessories'] = array();								
								}
								
								if(!in_array($oAccessory->description,$aAccessories[$sAccessoriesCategoryKey][$oAccessory->accessoryCategoryId]['accessories'])){
									$aAccessories[$sAccessoriesCategoryKey][$oAccessory->accessoryCategoryId]['accessories'][] = $oAccessory->description;								
								}
							}							
						}
					}
				}			
			}				
		}
		
		if(!empty($aAccessories)){			
			
			$sAccessoriesTosave = array();
			
			foreach($aAccessories as $key=>$value){				
				ksort($value);

				foreach($value as $aValueKey=>$aValueData){					
					
					if(!array_key_exists($key,$sAccessoriesTosave)){
						$sAccessoriesTosave[$key] = array();						
					}
					
					if(!array_key_exists($aValueKey,$sAccessoriesTosave[$key])){
						$sAccessoriesTosave[$key][$aValueKey] = array();						
					}

					$sAccessoriesTosave[$key][$aValueKey]['title'] = $aValueData['title'];

					if(!empty($aValueData['accessories'])){
						
						sort($aValueData['accessories']);
						
						$sAccessoriesTosave[$key][$aValueKey]['accessories'] = $aValueData['accessories'];
					}					
				}		
			}
			
			$this->_oAPIResult = $sAccessoriesTosave;
		} else {
			$this->_oAPIResult = 'no-accessories';
		}
				
		return;		
	}	
	
	function parseGetDivisions($iUserId=false,$sDepartment='sale'){
		
		$sEndpoint = API_ENDPOINT_OVIS . '/divisions/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
				
		$aDivisions = false;
		
		if(empty($oReturn->errors)){
			$aDivisions = array();
			
			if(!empty($oResult->data)){
				
			
				foreach($oResult->data as $sDivisionCategoryKey => $sDivisionCategory){
					
					if($sDivisionCategoryKey == 'bed'){
						$sDivisionCategoryKey = 'slapen';							
					} else if($sDivisionCategoryKey == 'zit'){
						$sDivisionCategoryKey = 'zitten';							
					}
					
					if(!empty($sDivisionCategory) && is_array($sDivisionCategory)){
					
						if(!array_key_exists($sDivisionCategoryKey,$aDivisions)){
							$aDivisions[$sDivisionCategoryKey] = array();
						}
						
						asort($sDivisionCategory);
						
						$bSingleMode = false;
						if($sDivisionCategoryKey == 'keuken' || $sDivisionCategoryKey == 'sanitair'){
							$bSingleMode = true;
						}
						
						$sDivisionGroupTitle = ucfirst($sDivisionCategoryKey);
						
						$aDivisions[$sDivisionCategoryKey]['title'] = $sDivisionGroupTitle; 
						$aDivisions[$sDivisionCategoryKey]['single_mode'] = $bSingleMode; 
						$aDivisions[$sDivisionCategoryKey]['divisions'] = $sDivisionCategory; 
					}
				}				
			}			
		}		
		
		if(!empty($aDivisions)){

			ksort($aDivisions);
			
			$sDivisionsTosave = array();
			
			foreach($aDivisions as $key=>$value){							
				
				if(!array_key_exists($key,$sDivisionsTosave)){
					$sDivisionsTosave[$key] = array();						
				}

				$sDivisionsTosave[$key]['title'] = $value['title'];
				$sDivisionsTosave[$key]['single_mode'] = $value['single_mode'];

				if(!empty($value['divisions'])){
					
					asort($value['divisions']);
					
					$sDivisionsTosave[$key]['divisions'] = $value['divisions'];
				}				
			}
			
			$this->_oAPIResult = $sDivisionsTosave;
		} else {
			$this->_oAPIResult = 'no-divisions';
		}
		
		return;
		
	}
	
	function parseGetCategories($iUserId=false,$sDepartment='sale'){		
		
		$sEndpoint = API_ENDPOINT_OVIS . '/' . $this->_oUserData->realm . '/categories/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		$aCategories = false;
		
		if(empty($oReturn->errors)){
			$aCategories = array();
			
			if(!empty($oResult->data)){
			
				foreach($oResult->data as $sCategoryKey => $sCategory){
					
					if(!array_key_exists($sCategoryKey,$aCategories)){
						$aCategories[$sCategoryKey] = array();
					}
						
					$oCategory = new \stdClass();
					
					$aTranslateCategory = array();
					$aTranslateCategory['mobilehome'] = 'stacaravan';
					$aTranslateCategory['trailer'] = 'aanhangwagen';
					$aTranslateCategory['tenttrailer'] = 'vouwwagen';
					$aTranslateCategory['boat'] = 'boot';
					$aTranslateCategory['boattrailer'] = 'boottrailer';
					$aTranslateCategory['engine'] = 'motor';
										
					$oCategory->category =  !empty($aTranslateCategory[$sCategoryKey]) ? ucfirst($aTranslateCategory[$sCategoryKey]) : ucfirst($sCategoryKey);	
					if(!empty($sCategory)){
						$oCategory->subs = $sCategory;
					}					
					
					$aCategories[$sCategoryKey] = $oCategory;
				}			
			}			
		}
		
		if(!empty($aCategories)){			
			
			$sCategoriesTosave = array();
			foreach($aCategories as $key=>$value){				
				$sCategoriesTosave[$key] = $value;				
			}
			
			$this->_oAPIResult = $sCategoriesTosave;
		} else {
			$this->_oAPIResult = 'no-categories';
		}
				
		return;
		
	}
	
	function parseGetVersions($iUserId=false,$sDepartment='sale',$sVersionsCategory=false,$sVersionsBrand=false,$sVersionsModel=false){
		
		$oReturn = new \stdClass();
		$oReturn->category = $sVersionsCategory;
		$oReturn->brand = $sVersionsBrand;
		$oReturn->model = $sVersionsModel;
		$oReturn->versions = '';
		
		if(!empty($sVersionsCategory) && !empty($sVersionsBrand) && !empty($sVersionsModel)){
						
			$sEndpoint = API_ENDPOINT_OVIS . '/autofillmodel/';
					
			$oParams = new \stdClass();
			$oParams->realm = trim($this->_oUserData->realm);
			$oParams->category = trim($sVersionsCategory);
			$oParams->keyword = trim($sVersionsBrand).' '.trim($sVersionsModel);
			
			$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);

			$oCurl = curl_init();
			curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
			curl_setopt($oCurl, CURLOPT_POST, true);
			curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
			curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
			curl_setopt($oCurl, CURLOPT_HEADER, false);

			$sResult = curl_exec($oCurl);
			$sError = curl_errno($oCurl);
			$aResponseInfo = curl_getinfo($oCurl);

			$oResult = json_decode($sResult);
			
			$aFoundVersions = array();
			
			if(!empty($oResult->data) && is_array($oResult->data)){			
				
				foreach($oResult->data as $oFoundVersion){
					$aFoundVersions[$oFoundVersion->id] = $oFoundVersion->version;
				}
			}
			
			if(!empty($aFoundVersions)){
				
				asort($aFoundVersions);
				
				$aFoundVersionsSorted = array();
				
				foreach($aFoundVersions as $iKey => $sValue){
					
					$aThisVerions = array();
					$aThisVerions['id'] = $iKey;
					$aThisVerions['version'] = $sValue;
					
					$aFoundVersionsSorted[] = $aThisVerions;
					
				}
				
				
				$oReturn->versions = $aFoundVersionsSorted;
			}
		}
		
		
		
		
		$this->_oAPIResult = $oReturn;
		
		
		
		
		
		
		
	}
	
	function parseGetPhotoLabels($iUserId=false,$sDepartment='sale'){
		
		$sEndpoint = API_ENDPOINT_OVIS . '/' . $this->_oUserData->realm . '/photolabels/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		$this->_oAPIResult = $oResult;	
	
	}	
	
	function parseGetBrands($iUserId=false,$sDepartment='sale'){
		
		$sEndpoint = API_ENDPOINT_OVIS . '/' . $this->_oUserData->realm . '/brands/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		$aBrands = false;
		
		if(empty($oReturn->errors)){
			$aBrands = array();
			
			if(!empty($oResult->data)){
			
				foreach($oResult->data as $sBrandCategoryKey => $sBrandCategory){
					
					if(!array_key_exists($sBrandCategoryKey,$aBrands)){
						$aBrands[$sBrandCategoryKey] = array();
					}
					
					foreach($sBrandCategory as $sBrand){
						
						$oBrand = new \stdClass();
						$oBrand->brand = html_entity_decode($sBrand->descriptionOriginal);
						$oBrand->search = jsonPrepare($sBrand->descriptionOriginal);
						
						$sBrandDescription = html_entity_decode($sBrand->description);
						
						$aModels = !empty($sBrand->modelOriginal) ? array_filter($sBrand->modelOriginal) : '';
						
						if(!empty($aModels)){
							
							$sModelToSave = array();
							
							foreach($aModels as $aModel){
							
								$sNewModel = new \stdClass();
								$sNewModel->model = $aModel;								
								$sNewModel->search = jsonPrepare($aModel);
								
								$sModelToSave[] = $sNewModel;
							
							}							
							
							$oBrand->models = $sModelToSave;						
						}
						
						$aBrands[$sBrandCategoryKey][$sBrandDescription] = $oBrand;
						
					}
				}			
			}			
		}		
		
		if(!empty($aBrands)){			
			
			$sBrandsTosave = array();
			
			foreach($aBrands as $key=>$value){				
				ksort($value);				
				$sBrandsTosave[$key] = $value;				
			}
			
			$this->_oAPIResult = $sBrandsTosave;
		} else {
			$this->_oAPIResult = 'no-brands';
		}
				
		return;
		
	}	
	
	function parseGetArticles($iUserId=false,$sDepartment='sale'){
		
		if(empty($iUserId)){
			return false;
		}

		if($sDepartment == 'verkoop'){
			$sDepartment = 'sale';
		} elseif($sDepartment == 'verhuur'){
			$sDepartment = 'rent';
		}		
		
		$sEndpoint = API_ENDPOINT_OVIS . '/presentations/'.$iUserId.'/management';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 60);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		$oReturn = new \stdClass();
		$oReturn->result = !empty($oResult->result) ? true : false;
		$oReturn->errors = !empty($oResult->errors) ? $oResult->errors : false;
				
		if(empty($oReturn->errors)){
			
			$aArticles = array();
			
			if(!empty($oResult->data)){
			
				foreach($oResult->data as $oArticleData){
					
					$oArticle = new \stdClass();
					$oArticle->id = $oArticleData->id;
					$oArticle->created = $oArticleData->created;
					$oArticle->updated = $oArticleData->updated;
					$oArticle->afloopdatum = !empty($oArticleData->specifications->afloopDatum) ? date('d-m-Y',strtotime($oArticleData->specifications->afloopDatum)) : false;
					$oArticle->verlopen = !empty($oArticleData->specifications->afloopDatum) ? ($oArticleData->specifications->afloopDatum < date('Y-m-d') ? true : false ) : false;
					$oArticle->timestampCreate = date('U', strtotime($oArticleData->created));
					$oArticle->timestampEdit = date('U', strtotime($oArticleData->updated));
					$oArticle->category = ucfirst($oArticleData->specifications->category);
					$oArticle->title = $oArticleData->specifications->title;
					$oArticle->constructionYear = $oArticleData->specifications->dates->constructionYear;
					$oArticle->price = !empty($oArticleData->specifications->prices->price) ? ($oArticleData->specifications->prices->price/100) : false;
					$oArticle->priceFrom = !empty($oArticleData->specifications->prices->retail) ? ($oArticleData->specifications->prices->retail/100) : false;
					
					$oArticle->chassisnumber = !empty($oArticleData->specifications->chassisNumber) ? ($oArticleData->specifications->chassisNumber) : false;
					
					$sLicenseChecked = !empty($oArticleData->specifications->licensePlate) ? $this->validateKenteken($oArticleData->specifications->licensePlate) : false;
					
					$oArticle->licensePlate = !empty($sLicenseChecked) && $sLicenseChecked != 'invalid' ? $sLicenseChecked : false;
					$oArticle->licensePlateRaw = !empty($oArticleData->specifications->licensePlate) ? $oArticleData->specifications->licensePlate : false;
					$oArticle->sold = !empty($oArticleData->specifications->sold) ? true : false;
					$oArticle->expected = !empty($oArticleData->specifications->expected) ? true : false;
					$oArticle->reserved = !empty($oArticleData->specifications->reserved) ? true : false;
					$oArticle->rental = !empty($oArticleData->specifications->rental) ? true : false;
					$oArticle->stock = !empty($oArticleData->specifications->stock) ? true : false;
					$oArticle->brand = !empty($oArticleData->specifications->brandDisplay) ? html_entity_decode($oArticleData->specifications->brandDisplay) : false;
					$oArticle->model = !empty($oArticleData->specifications->modelDisplay) ? $oArticleData->specifications->modelDisplay : false;
					$oArticle->image = !empty($oArticleData->mediainfo->images[0]->traditional->default->default->url) ? $oArticleData->mediainfo->images[0]->traditional->default->default->url : false;
					
					if(isset($oArticleData->specifications->specsMarktplaats)){					
						$oArticle->marktplaatStatus = !empty($oArticleData->specifications->specsMarktplaats->status->pendingadd) ? 'pending' : ( !empty($oArticleData->specifications->specsMarktplaats->status->adactive) ? 'active' : 'inactive');					
					} else {
						$oArticle->marktplaatStatus = !empty($oArticleData->specifications->marktplaats->status->pendingadd) ? 'pending' : ( !empty($oArticleData->specifications->marktplaats->status->adactive) ? 'active' : 'inactive');
					}
					
					if($sDepartment == 'sale' && !$oArticle->rental){					
						$aArticles[] = $oArticle;
					} elseif($sDepartment == 'rent' && $oArticle->rental){												
						$aArticles[] = $oArticle;						
					}
				}
			}
			
			$oReturn->total = !empty($aArticles) ? count($aArticles) : 0;
			$oReturn->data = !empty($aArticles) ? $aArticles : false;
		}	
		
		$this->_oAPIResult = $oReturn;	
		
		return;		
		
	}
	
	function validateKenteken($kenteken){
		$kentekenType = '';
		$kentekenNew = '';

		if($kenteken != ''){
			$kentekenNew = 'invalid';
		}

		$kenteken = str_replace('-', '', $kenteken);
		$kenteken = str_replace(' ', '', $kenteken);
		$kenteken = strtoupper($kenteken);

		if(strlen($kenteken) == 6){
			if (preg_match('/[A-Z]{2}[0-9]{2}[0-9]{2}/', $kenteken)){
				$kentekenType = 'AA-00-00';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,2).'-'.substr($kenteken,4,2);
			} elseif (preg_match('/[0-9]{2}[A-Z]{2}[0-9]{2}/', $kenteken)){
				$kentekenType = '00-AA-00';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,2).'-'.substr($kenteken,4,2);
			} elseif (preg_match('/[A-Z]{2}[0-9]{2}[A-Z]{2}/', $kenteken)){
				$kentekenType = 'AA-00-BB';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,2).'-'.substr($kenteken,4,2);		
			} elseif (preg_match('/[A-Z]{3}[0-9]{2}[A-Z]{1}/', $kenteken)){
				$kentekenType = 'AAA-00-B';
				$kentekenNew = substr($kenteken,0,3).'-'.substr($kenteken,3,2).'-'.substr($kenteken,5,1);			
			} elseif (preg_match('/[A-Z]{2}[A-Z]{2}[0-9]{2}/', $kenteken)){
				$kentekenType = 'AA-BB-00';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,2).'-'.substr($kenteken,4,2);
			} elseif (preg_match('/[0-9]{2}[A-Z]{2}[A-Z]{2}/', $kenteken)){
				$kentekenType = '00-AA-BB';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,2).'-'.substr($kenteken,4,2);
			} elseif (preg_match('/[0-9]{2}[A-Z]{3}[0-9]{1}/', $kenteken)){
				$kentekenType = '00-AAA-0';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,3).'-'.substr($kenteken,5,1);
			} elseif (preg_match('/[0-9]{1}[A-Z]{3}[0-9]{2}/', $kenteken)){
				$kentekenType = '0-AAA-00';
				$kentekenNew = substr($kenteken,0,1).'-'.substr($kenteken,1,3).'-'.substr($kenteken,4,2);
			} elseif (preg_match('/[A-Z]{2}[0-9]{3}[A-Z]{1}/', $kenteken)){
				$kentekenType = 'AA-000-B';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,3).'-'.substr($kenteken,5,1);
			} elseif (preg_match('/[A-Z]{1}[0-9]{3}[A-Z]{2}/', $kenteken)){
				$kentekenType = 'A-000-BB';
				$kentekenNew = substr($kenteken,0,1).'-'.substr($kenteken,1,3).'-'.substr($kenteken,4,2);
			} elseif (preg_match('/[0-9]{2}[0-9]{2}[A-Z]{2}/', $kenteken)){
				$kentekenType = '00-00-AA';
				$kentekenNew = substr($kenteken,0,2).'-'.substr($kenteken,2,2).'-'.substr($kenteken,4,2);
			}
		}
		return $kentekenNew;
	}
	
	/*
	 * Get userdata
	 * 
	 * @return object
	 */
	
	public function getUserLimits($iUserId=false) {
		if(empty($iUserId)){
			return false;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/user/'.$iUserId.'/limits/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
	
		if(empty($oReturn->errors)){
			
			if(!empty($oResult->data)){
			
				$this->_oUserLimits = $oResult->data;	
				
			}
		}
		
		return;
	}
	
	public function checkLimits($iUserId=false) {
				
		if($this->_oUserLimits->grandTotal->available == 'unlimited' || $this->_oUserLimits->grandTotal->available > 0){
			
			$aLimits = array();
			
			foreach($this->_oUserLimits as $key=>$value){
				if($key != 'grandTotal'){	

					if(strtolower($value->category) == 'kampeerauto'){
						$value->category = 'camper';
					} elseif(strtolower($value->category) == 'stacaravan/chalet'){
						$value->category = 'stacaravan';						
					} elseif(strtolower($value->category) == 'aanhanger'){
						$value->category = 'aanhangwagen';						
					}				
					
					if($value->condition == 'used' || $value->condition == 'new'){						
						
						if(!array_key_exists($value->category,$aLimits)){
							$aLimits[$value->category] = array();
						}
					
						$aLimits[$value->category]['general'] = 'decide';						
						
						if($value->condition == 'used'){
							$aLimits[$value->category]['used'] = $value->available > 0 || $value->available == 'unlimited' ? true : false;
						}
						
						if($value->condition == 'new'){
							$aLimits[$value->category]['new'] = $value->available > 0 || $value->available == 'unlimited' ? true : false;
						}
						
					} else if($value->condition == 'combined'){
						if(!array_key_exists($value->category,$aLimits)){
							$aLimits[$value->category] = array();
						}
						
						$aLimits[$value->category]['general'] = $value->available > 0 || $value->available == 'unlimited' ? true : false;
					} else if($value->condition == 'rental'){
						if(!array_key_exists('rental_'.$value->category,$aLimits)){
							$aLimits['rental_'.$value->category] = array();
						}
						
						$aLimits['rental_'.$value->category]['general'] = $value->available > 0 || $value->available == 'unlimited' ? true : false;
					}					
				}
			}			
			
			foreach($aLimits as $key=>$value){
				if($value['general'] == 'decide'){
					if(!empty($aLimits[$key]['used']) || !empty($aLimits[$key]['new'])){
						$aLimits[$key]['general'] = true;
					} else {
						if(isset($aLimits[$key]['used']) || isset($aLimits[$key]['new'])){
							$aLimits[$key]['general'] = false;
						}						
					}
				}
			}
			
			return $aLimits;			
		}		
		
		return false;
	}
	
	/*
	 * Get userdata
	 * 
	 * @return object
	 */
	
	public function getUserData($iUserId=false) {
		if(empty($iUserId)){
			return false;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/user/'.$iUserId.'/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		if(empty($oReturn->errors)){
			
			if(!empty($oResult->data)){
			
				$this->_oUserData = $oResult->data;	
				
			}
		}
		
		return;	
	
	}
	
	
	function createPaymentOVISSaldo($iUserId=false,$iAmount=false,$sAgreement=false){
	
		if(empty($iUserId)){
			return false;
		}
		
		if(empty($iAmount)){
			return false;			
		}
		
		if(empty($sAgreement) || strtolower($sAgreement) != 'accepted'){
			return false;			
		}		
		
		$oParams = new \stdClass();
		$oParams->amount = $iAmount;
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
		
		$sEndpoint = API_ENDPOINT_OVIS . '/ovissaldo/'.$iUserId.'/create';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);

		if(empty($oReturn->errors)){
			
			if(!empty($oResult->data)){
				
				$this->_oAPIResult = $oResult->data;
				
			}
		}
		
		return;
	}
	
	function getOVISSaldoOrderStatus($iUserId=false, $iOrderId=false){
		if(empty($iUserId)){
			return false;
		}
		
		if(empty($iOrderId)){
			return false;			
		}
		
		
		$oParams = new \stdClass();
		$oParams->order = $iOrderId;
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
		
		$sEndpoint = API_ENDPOINT_OVIS . '/ovissaldo/'.$iUserId.'/status';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		if(empty($oReturn->errors)){
			
			if(!empty($oResult->data)){
				
				$this->_oAPIResult = $oResult->data;
				
			}
		}
		
		return;
		
		
	}
	
	function getOVISSaldo($iUserId){
		
		if(empty($iUserId)){
			$oReturn = new \stdClass();
			$oReturn->saldoStatus = 'insufficient';
			$oReturn->saldo = 0;
				
			$this->_oAPIResult = $oReturn;
			
			return false;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/ovissaldo/'.$iUserId.'/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);

		$sError = curl_errno($oCurl);

		$aResponseInfo = curl_getinfo($oCurl);

		$oResult = json_decode($sResult);
		
		if(empty($oReturn->errors)){
			
			if(!empty($oResult->data)){
				
				$oReturn = new \stdClass();
				$oReturn->saldoStatus = !empty($oResult->data->netto) ? ($oResult->data->netto > 0 ? 'sufficient' : 'debt') : 'insufficient';
				$oReturn->saldo = !empty($oResult->data->netto) ? number_format($oResult->data->netto,2,',','.') : 0;
				
				$this->_oAPIResult = $oReturn;	
				
			}
		}
		
		return;	
		
	}
	
	function getOVISMarktplaatsArticleStatus($iUserId,$iArticle){
		if(empty($iUserId)){
			$oReturn = new \stdClass();
			$oReturn->errors = 'invalid-user';
				
			$this->_oAPIResult = 'invalid-user';
			
			return;
		}
		
		if(empty($iArticle)){
			$oReturn = new \stdClass();
			$oReturn->errors = 'invalid-article';
				
			$this->_oAPIResult = 'invalid-article';
			
			return;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/marktplaats/'.$iUserId.'/'.$iArticle;
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		$oResult = json_decode($sResult);
						
		if(empty($oResult->errors)){
			
			if(!empty($oResult->data)){
									
				$this->_oAPIResult = $oResult->data;
				
				return;
			}
		}
		
		$this->_oAPIResult = 'marktplaats-article-inactive';
		
		return;
		
	}
	
	function getOVISMarktplaatsStatus($iUserId){
		
		if(empty($iUserId)){
			$oReturn = new \stdClass();
			$oReturn->errors = 'invalid-user';
				
			$this->_oAPIResult = 'invalid-user';
			
			return;
		}		
		
		$sEndpoint = API_ENDPOINT_OVIS . '/marktplaats/'.$iUserId.'/';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 60);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		$oResult = json_decode($sResult);
		
		if(empty($oReturn->errors)){
			
			if(!empty($oResult->data)){
				
				if($oResult->data == 'marktplaats-user-authorized'){
				
					$this->_oAPIResult = 'marktplaats-active';
				
					return;
				}				
			}
		}
		
		$this->_oAPIResult = 'marktplaats-inactive';
		
		return;
		
	}
	
	function deleteOVISMarktplaatsArticle($iUserId,$iArticle){
		
		if(empty($iUserId)){
			$oReturn = new \stdClass();
			$oReturn->errors = 'invalid-user';
				
			$this->_oAPIResult = 'invalid-user';
			
			return;
		}
		
		if(empty($iArticle)){
			$oReturn = new \stdClass();
			$oReturn->errors = 'invalid-article';
				
			$this->_oAPIResult = 'invalid-article';
			
			return;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/marktplaats/'.$iUserId.'/'.$iArticle.'/delete';
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		$oResult = json_decode($sResult);
				
		if(empty($oReturn->errors)){
			
			if(!empty($oResult->data)){
				
				$this->_oAPIResult = 'marktplaats-delete-succes';
				
			}
		}
		
		return;
		
	}
	
	function featureOVISMarktplaatsArticle($iUserId,$iArticle,$sFeature){
		
		if(empty($iUserId)){
			$this->_oAPIResult = 'invalid-user';
			
			return;
		}
		
		if(empty($iArticle)){
			$this->_oAPIResult = 'invalid-article';
			
			return;
		}
		
		if(empty($sFeature)){
			$this->_oAPIResult = 'invalid-feature';
			
			return;
		}
		
		$aAllowedFeatures = array('up');
		
		if(!in_array($sFeature,$aAllowedFeatures)){
			$this->_oAPIResult = 'invalid-feature-set';
			
			return;
		}		
		
		$sEndpoint = API_ENDPOINT_OVIS . '/marktplaats/'.$iUserId.'/'.$iArticle.'/'.$sFeature;
		
		
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POST, false);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		$oResult = json_decode($sResult);

		if(empty($oResult->error)){
			
			if(!empty($oResult->data)){
				
				$this->_oAPIResult = 'marktplaats-feature-succes';
				
			}
		} else {
			//if($oResult->error == 'insufficient-saldo'){
			//	$this->_oAPIResult = 'marktplaats-add-error-saldo';				
			//}			
		}
		
		return;
		
		
		
	}
	
	
	function addOVISMarktplaatsArticle($iUserId,$iArticle,$bAutoreplace){
		
		if(empty($iUserId)){
			$this->_oAPIResult = 'invalid-user';
			
			return;
		}
		
		if(empty($iArticle)){
			$this->_oAPIResult = 'invalid-article';
			
			return;
		}
		
		$sEndpoint = API_ENDPOINT_OVIS . '/marktplaats/'.$iUserId.'/'.$iArticle.'/add';
		
		$oParams = new \stdClass();
		$oParams->autoreplace = $bAutoreplace;
		
		$sParams = json_encode($oParams, JSON_UNESCAPED_SLASHES);
				
		$oCurl = curl_init();
		curl_setopt($oCurl, CURLOPT_URL, $sEndpoint);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($oCurl, CURLOPT_TIMEOUT, 10);
		curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sParams);
		curl_setopt($oCurl, CURLOPT_POST, true);
		curl_setopt($oCurl, CURLOPT_HTTPHEADER, $this->_aAPIHeader);
		curl_setopt($oCurl, CURLOPT_HEADER, false);

		$sResult = curl_exec($oCurl);
		$sError = curl_errno($oCurl);
		$aResponseInfo = curl_getinfo($oCurl);
		$oResult = json_decode($sResult);
				
		if(empty($oResult->error)){
			
			if(!empty($oResult->data)){
				
				$this->_oAPIResult = 'marktplaats-add-succes';
				
			}
		} else {
			if($oResult->error == 'insufficient-saldo'){
				$this->_oAPIResult = 'marktplaats-add-error-saldo';				
			}			
		}
		
		return;
		
	}

}