/* global baseHref() directory_uri $ window document uppy */

/*
 * Base URL
 * 
 * @returns {.document@call;getElementsByTagName.baseURI}
 */

function baseHref() {

   var oBase = document.getElementsByTagName('base');

   if (oBase.length > 0) {

	   return oBase[0].baseURI;

   }

   return null;

}

function sortObj(obj) {
  return Object.keys(obj).sort().reduce(function (result, key) {
    result[key] = obj[key];
    return result;
  }, {});
}

function decodeHTMLEntities(text) {
	return $("<textarea/>")
	.html(text)
	.text();
}

function encodeHTMLEntities(text) {
	return $("<textarea/>")
	.text(text)
	.html();
}

/*
 * Capitalize first letter of string
 *  
 * @returns {undefined}
 */

function capitalizeFirstLetterOfString(string) {
	
	if(typeof string == 'undefined'){
		return string;
	}
	
	return string.charAt(0).toUpperCase() + string.slice(1);
}

/*
 * Lazy load
 *  
 * @returns {undefined}
 */

function lazyLoad() {
	
	var oLazy = $('.lazy');
	
	if(oLazy.length === 0) {
		
		return;
		
	}

	oLazy.Lazy({

		threshold: 0,
		effect: 'fadeIn',
		effectTime: 200,
		delay: 0,
		placeholder: '/assets/img/icons/icon-no-image.svg',
		visibleOnly: false

	});

}

/*
 * Show/hide extra input fields based on the selection
 *  
 * @returns {undefined}
 */

function showRadioSelectionInput() {
	
	/*
	 * Allowed radio inputs
	 * @type Array
	 */
	
	var aRadioInputs = ['shipping_private', 'shipping_company', 'invoice_private', 'invoice_company', 'user_type'];
	
	/*
	 * Show or hide the input
	 */	 
	
	var oRadioInput = $('input[type=radio]');

	oRadioInput.on('click', function() {

		var oThis = $(this);
				
		oThis.closest('div.contain').next('div.contain.hide').hide();
		
		if($.inArray(oThis.attr('id'), aRadioInputs) !== -1 && oThis.hasClass('show')) {

			oThis.closest('div.contain').next('div.contain.hide').show();

		}
		
	});

}

/*
 * Show/hide extra input fields based on the selection
 *  
 * @returns {undefined}
 */

function showCheckboxSelectionInput() {
	
	/*
	 * Allowed checkbox inputs
	 * @type Array
	 */
	
	var aCheckboxInputs = ['invoice-deviating-billing-information'];
	
	/*
	 * Show or hide the input
	 */
	
	var oCheckboxInput = $('input[type=checkbox]');

	oCheckboxInput.on('click', function() {

		var oThis = $(this),
            oContain = oThis.parents('#' + oThis.attr('id') + '-label').next('#' + oThis.attr('id') + '-contain');
            		          
		if($.inArray(oThis.attr('id'), aCheckboxInputs) !== -1 && oContain.css('display') === 'none') {

			oContain.show();

		} else {
            
            oContain.hide();
            
        }
		
	});

}

/*
 * Notify user with a message
 * 
 * @param {type} oData
 * @returns {undefined}
 */
		
function notifyMessage(oData, sType = 'save', iId = 0) {
	
	var oNotifyDiv			= $('<div id="notify"></div>'),
		oNotifyId			= $('#notify'),
		oNotifyOverlay		= $('<div id="notify-overlay"></div>'),
		oNotifyOverlayId	= $('#notify-overlay');	

	/*
	 * Set message
	 */
	
	var sMessageFailed = '',
		sMessageSuccess = '';
	
	switch(sType) {
		
		case 'invalid':
			
			sMessageFailed = 'Pas foutieve velden aan';
			
			break;
		case 'save-article':
		case 'edit-article':
			
			sMessageFailed = 'Opslaan mislukt';
			sMessageSuccess = 'Artikel opgeslagen';
			
			break;
		case 'save-option':
		case 'edit-option':
			
			sMessageFailed = 'Opslaan mislukt';
			sMessageSuccess = 'Optie opgeslagen';
			
			break;
		
		case 'delete-option':
			
			sMessageFailed = 'Verwijderen mislukt';
			sMessageSuccess = 'Optie verwijderd';
			
			break;
		
		case 'delete-article':
			
			sMessageFailed = 'Verwijderen mislukt';
			sMessageSuccess = 'Artikel verwijderd';
			
			break;
		
		case 'delete-image':
		
			sMessageFailed = 'Verwijderen mislukt';
			sMessageSuccess = 'Afbeelding verwijderd';
			
			break;		
			
		case 'save-settings':
		
			sMessageFailed = 'Opslaan mislukt';
			sMessageSuccess = 'Instellingen opgeslagen';
			
			break;
			
		case 'form-helpdesk':
		
			sMessageFailed = 'Formulier versturen mislukt';
			sMessageSuccess = 'Formulier verzonden';
			
			break;	
			
		default:
			
			sMessageFailed = 'Opslaan mislukt';
			sMessageSuccess = 'Informatie opgeslagen';
			
			break;
		
	}
	
	/*
	 * Setup notify element
	 */
	
	oNotifyDiv.removeClass('failed');
	oNotifyId.removeClass('failed');

	(oNotifyOverlayId.length === 0 
		? (oData === false ? oNotifyDiv.addClass('failed').text(sMessageFailed) : oNotifyDiv.addClass('success').text(sMessageSuccess)) 
		: (oData === false ? oNotifyId.addClass('failed').text(sMessageFailed) : oNotifyId.addClass('success').text(sMessageSuccess))); 

	/*
	 * Append notify overlay element to DOM
	 */

	(oNotifyOverlayId.length === 0 ? oNotifyOverlay.appendTo('body').hide().fadeIn(100).delay(800).fadeOut(100) : oNotifyOverlayId.fadeIn(100));
	
	/*
	 * Append notify element to notify overlay
	 */

	(oNotifyOverlayId.length === 0 ? oNotifyDiv.appendTo(oNotifyOverlay) : '');

	/*
	 * Fade out and redirect
	 * 
	 * Also possible to stay on the page with window.location.replace(baseHref() + 'beheer/artikelen/artikel-wijzigen/' + iId);
	 * 
	 * But for someone reason someone finds it more logical to jump to the listing again
	 */
	
	setTimeout(function() {
		
		if(sType === 'delete-option') {
			
			if(oData === true){			
				window.location.replace(baseHref() + 'opties' + (sType === 'save-option' ? '/'+iId+'/' : ''));
			}
			
			return;
		}
		
		if(sType === 'save-option') {
			
			window.location.replace(baseHref() + '/opties/optie-wijzigen' + '/'+iId+'/');

			return;
			
		}
		
		if(sType === 'delete-article') {
			
			if(oData === true){			
				window.location.replace(baseHref() + '' + (sType === 'save-article' ? '/'+iId+'/' : ''));
			}
			
			return;
		}

		if(sType === 'save-article') {
			
			window.location.replace(baseHref() + 'artikel-wijzigen' + '/'+iId+'/');

			return;
			
		}

		oNotifyOverlayId.fadeOut(100);

	}, 1500);

}

/*
 * Scroll to top of page
 * 
 * @returns {undefined}
 */

function scrollToTop() {
		
	var oScroll = $(".scroll-top");
	
	if(oScroll.length === 0) {
		
		return;
		
	}

	$(window).scroll(function () {

		if ($(this).scrollTop() > 100 && $(window).width() > 320) {

			oScroll.fadeIn(200);
			
		} else {
			
			oScroll.fadeOut(200);
			
		}

	});
	
	oScroll.click(function () {

		$('body, html').animate({
			
			scrollTop: 0
			
		}, 400);

		return false;
		
	});
	
}

function formChangeTab(tab) {
	
	$('.activetab').removeClass('activetab');
	$('#tab-'+tab).addClass('activetab');
		
	$('.tab-content').addClass('hiddenTabContent');
	$('#tab-content-'+tab).removeClass('hiddenTabContent');
	
}


/*
 * Form error handling
 * 
 * @returns {undefined}
 */

function formErrorHandling() {
	
	var oSubmitForm = $("form.helpdesk input[name=submit]");
	
	oSubmitForm.on('click', function(e) {
		
		e.preventDefault();
		
		var oForm = $(this).parents('form');
		
		oSubmitForm.addClass('disabled');
		
		oForm.css('opacity', 0.5);
		
		$.post(baseHref() + 'form', { 
					
			module: 'formPost',
			postdata: oForm.serialize()

		}, function(data) {

			var oData = $.parseJSON(data),
				oNotice = $('div.notice'),
				sErrors = '';
		
			$('form.helpdesk input').removeClass('error');
		
			if(oData === 'succesfully-send') {
				
				oNotice.removeClass('error').addClass('success').css('display', 'inline-block').html('<p>Formulier succesvol verzonden</p>');
				
				oForm.css('opacity', 1);
				
				$('form.helpdesk input[type=text], form.helpdesk input[type=email], form.helpdesk input[type=tel], form.helpdesk textarea').val('');
				
				oSubmitForm.removeClass('disabled');

				return;

			}
			
			if(oData === 'send-failed') {
				
				oNotice.addClass('error').css('display', 'inline-block').html('<p>Er is een fout opgetreden bij het versturen</p>');
				
				oForm.css('opacity', 1);
				
				oSubmitForm.removeClass('disabled');

				return;

			}

			$.each(oData, function(key, error) {

				sErrors += 
				'<p>' + error.description + '</p>';

				$('form.helpdesk input[name=input_' + error.error).addClass('error');
				$('form.helpdesk textarea[name=input_' + error.error).addClass('error');

			});
			
			oNotice.addClass('error').css('display', 'inline-block').html(sErrors);

			oSubmitForm.removeClass('disabled');
			
			oForm.css('opacity', 1);

		});
		
	});
	
}

function tinyMCE() {
	
	var aAllowedInputs = ['#article_description','#article_comment','#article_reference','#marktplaats_description'];
	
	$.each(aAllowedInputs, function(index, input) {
		
		var iHeight = 300;
					
		if($(input).length > 0) {
			
			if(input === '#article_description' || input === '#article_comment' || input === '#article_reference') {				
				
				var iEditorHeight = $('.add-edit-group.description').height()-90;
				
				iHeight = iEditorHeight;			
				
			} else if(input === '#marktplaats_description') {	
				
				var iEditorHeight = $('.add-edit-group.marktplaats').height();					
				
				iHeight = iEditorHeight;
			}
			
			var sId = input.replace('#','editor_');
			
			jQuery(input).richText({
				height: iHeight,
				id: sId,
				leftAlign: false,
				centerAlign: false,
				rightAlign: false,
				justify: false,
				heading: false,
				fonts: false,
				fontColor: false,
				backgroundColor: false,
				fontSize: false,
				imageUpload: false,
				fileUpload: false,
				videoEmbed: false,
				urls: false,
				table: false,
				removeStyles: false,
				code: false
			});
			
			/*tinymce.init({
		
				selector: input,
				branding: false,
				language: 'nl',
				height: iHeight,
				menubar: false,
				toolbar: 'undo redo | bold italic underline | bullist numlist',
				plugins: 'lists'

			});*/
			
		}
		
	});
	
	return;
	
}

jQuery(document).on("keyup","#editor_article_description .richText-editor",function(e) {
	
	var sReturnArticleDescription = jQuery('#editor_article_description .richText-editor').trigger('getContent', function (event, content) {
		return content;
	});
	
	if(typeof sReturnArticleDescription[0].innerHTML != 'undefined' && sReturnArticleDescription[0].innerHTML != ''){
		
		if(sReturnArticleDescription[0].innerHTML == '<div><br></div>'){
			sessionStorage.removeItem('current_description');		
		} else {
			sessionStorage['current_description'] = sReturnArticleDescription[0].innerHTML;			
		}
	} else {
		sessionStorage.removeItem('current_description');
	}
});

jQuery(document).on("keyup","#editor_article_comment .richText-editor",function(e) {
    var sReturnArticleComment = jQuery('#editor_article_comment .richText-editor').trigger('getContent', function (event, content) {
		return content;
	});
		
	if(typeof sReturnArticleComment[0].innerHTML != 'undefined' && sReturnArticleComment[0].innerHTML != ''){
		
		if(sReturnArticleComment[0].innerHTML == '<div><br></div>'){
			sessionStorage.removeItem('current_commment');
		} else {
			sessionStorage['current_commment'] = sReturnArticleComment[0].innerHTML;			
		}
		
	} else {
		sessionStorage.removeItem('current_commment');
	}
});

jQuery(document).on("keyup","#editor_article_reference .richText-editor",function(e) {
    var sReturnArticleReference = jQuery('#editor_article_reference .richText-editor').trigger('getContent', function (event, content) {
		return content;
	});
		
	if(typeof sReturnArticleReference[0].innerHTML != 'undefined' && sReturnArticleReference[0].innerHTML != ''){
		
		if(sReturnArticleReference[0].innerHTML == '<div><br></div>'){
			sessionStorage.removeItem('current_reference');
		} else {
			sessionStorage['current_reference'] = sReturnArticleReference[0].innerHTML;			
		}
		
	} else {
		sessionStorage.removeItem('current_commment');
	}
});

jQuery(document).on("keyup","#editor_marktplaats_description .richText-editor",function(e) {
    var sReturnMarktplaatsDescription = jQuery('#editor_marktplaats_description .richText-editor').trigger('getContent', function (event, content) {
		return content;
	});
	
	if(typeof sReturnMarktplaatsDescription[0].innerHTML != 'undefined' && sReturnMarktplaatsDescription[0].innerHTML != ''){
		
		if(sReturnMarktplaatsDescription[0].innerHTML == '<div><br></div>'){
			sessionStorage.removeItem('current_marktplaats_description');		
		} else {
			sessionStorage['current_marktplaats_description'] = sReturnMarktplaatsDescription[0].innerHTML;			
		}
		
	} else {
		sessionStorage.removeItem('current_marktplaats_description');
	}
});

function nl2br (str, is_xhtml) {   
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';    
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'$2');
}

var resizeId;
$(window).resize(function() {
    clearTimeout(resizeId);
    resizeId = setTimeout(doneResizing, 500);
});

function doneResizing(){
		
	var aAllowedInputs = ['#article_description','#article_comment','#article_reference','#marktplaats_description'];
	
	$.each(aAllowedInputs, function(index, input) {
		
		var iHeight = 300;
					
		if($(input).length > 0) {
			
			if(input === '#article_description' || input === '#article_comment' || input === '#article_reference') {			
				
				var iEditorHeight = $('.add-edit-group.description').height()-90;				
				
				iHeight = iEditorHeight;
								
				//$('.description-container .tox-tinymce').css({'height':iEditorHeight});
				
			} else if(input === '#marktplaats_description') {	
				
				var iEditorHeight = $('.add-edit-group.marktplaatsdescription').height();				
				
				iHeight = iEditorHeight;
								
				//$('.marktplaatsdescription-container .tox-tinymce').css({'height':iEditorHeight});	
			}				
		}
		
	});	
}

/*
 * Amount of results found
 * 
 * @returns {undefined}
 */

function setResultsFound(iTotalItems) {

	var oResults		= $('div.list-found'),
		oResultsAmount	= $('div.list-found span.amount'),
		oResultsText	= $('div.list-found span.results');

	oResults.show();

	if(iTotalItems === 0) {

		oResults.hide();

		return;

	}

	oResultsAmount.html(getNumberWithCommas(iTotalItems));

	oResultsText.html((iTotalItems === '1' ? 'resultaat' : 'resultaten'));

}

/*
 * Add points to number
 * 
 * @returns {string}
 */

function getNumberWithCommas(iNumber) {

	return iNumber.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");

}

/*
 * Loading overlay
 * 
 * @returns {undefined}
 */

function setLoadingOverlay(sMode) {
	
	var oListLoading = $('div.list-loading');

	(sMode === 'fadein' ? oListLoading.css('opacity', .5).fadeIn(10) : oListLoading.fadeOut(10));
	
}

/*
 * Init functions
 * 
 */	

$(function() {
	
	"use strict";
	
	/*
	 * Scroll to top
	 */
		
	scrollToTop();
		
	/*
	 * Lazy loading
	 */
	
	lazyLoad();

	/*
	 * Form error handling
	 */
	
	formErrorHandling();

	/*
	 * Hide or show input field based op radio selection
	 */
	
	showRadioSelectionInput();
    
    /*
     * Hide or show input field based op checkbox selection
     */
    
    showCheckboxSelectionInput();
	
	/*
	 * tinyMCE editor
	 */
	
	tinyMCE();
	
	/*
	 * Menu button
	 */
	
	var oMobileButton = $('#mobile-button');

	oMobileButton.on('click', function(e) {

		$('body').removeClass('filters-active');
		$('body').removeClass('add-new-active');
		$('body').removeClass('status-active');
		$('body').toggleClass('menu-active');

	});
	
	/*
	 * Show filters button
	 */
	
	var oFiltersButton = $('#filters');

	oFiltersButton.on('click', function(e) {
		
		$('.griditem').removeClass('active');

		$('body').removeClass('menu-active');
		$('body').removeClass('add-new-active');
		$('body').removeClass('status-active');
		$('body').toggleClass('filters-active');

	});
	
	/*
	 * Close filters button
	 */
	
	var oCloseFiltersButton = $('#close-filters');

	oCloseFiltersButton.on('click', function(e) {

		$('body').removeClass('filters-active');

	});
	
	/*
	 * Set status of individual article
	 */
	
	$(document).on("click",".set-status",function(e) {
		
		var currentOnlineStatus = $(this).data('online');
		var currentStockStatus =  $(this).data('status');
		var currentAticleId =  $(this).data('article');
		
		$('#set-status-item-id').val(currentAticleId);
		
		if(currentOnlineStatus == 'online'){
			jQuery('#set-online').prop('checked', true);
		} else {		
			jQuery('#set-offline').prop('checked', true);
		}
		
		jQuery('.online-radio').button( "refresh" );
				
		if(currentStockStatus == 'stock'){
			jQuery('#set-stock').prop('checked', true);
		} else if(currentStockStatus == 'expected'){
			jQuery('#set-expected').prop('checked', true);
		} else if(currentStockStatus == 'reserved'){
			jQuery('#set-reserved').prop('checked', true);
		} else {		
			jQuery('#set-sold').prop('checked', true);
		}		
		
		jQuery('.status-radio').button( "refresh" );
		
		$('body').removeClass('menu-active');
		$('body').removeClass('add-new-active');
		$('body').removeClass('filters-active');
		$('body').toggleClass('status-active');
		
	});	
	
	$(document).on("click",".step-back",function(e) {
		
		if($('#set-status-item-id').length){		
			$('#set-status-item-id').val('0');
		}	

		if($('body').hasClass('photos-active')){
			
			if(window.location.pathname.indexOf("/edit/") >= 0){				
				jQuery('#title-container').html('Advertentie bewerken');
			} else {
				jQuery('#title-container').html('Advertentie aanmaken');
			}
			
		}
		
		$('body').removeClass('photos-active');
		$('body').removeClass('category-active');
		$('body').removeClass('features-active');
		$('body').removeClass('description-active');
		$('body').removeClass('prices-active');
		$('body').removeClass('status-active');
		$('body').removeClass('filters-active');
		$('body').removeClass('menu-active');
		
	});		
	
	//$('input[type=tel]').keypress(function (e) {    
	$(document).on("keypress","input[type=tel]",function (e) {    
    
		var charCode = (e.which) ? e.which : event.keyCode    

		if (String.fromCharCode(charCode).match(/[^0-9]/g))    

			return false;                        

	});	
	
	$('input[name=set-power]').keypress(function (e) {    
    
		var charCode = (e.which) ? e.which : event.keyCode    

		if (String.fromCharCode(charCode).match(/[^0-9.,]/g))    

			return false;                        

	});
	
	jQuery.proceedLogOut = function(action){		
		jQuery.clearConcept();
			
		sessionStorage.removeItem('categories_set');
		sessionStorage.removeItem('divisions_set');
		sessionStorage.removeItem('brand_set');
		sessionStorage.removeItem('accessories_set');
		sessionStorage.removeItem('article_set');
		
		sessionStorage.removeItem('active_sub_sub_group');
		sessionStorage.removeItem('active_sub_group');				
		sessionStorage.removeItem('active_group');
		sessionStorage.removeItem('active_article');
			
		window.location.replace('https://www.ovis.nl/content/V3/logout.php');					
	}
	
	var oLightboxLoadConceptArticle = false; 
	
	jQuery(document).on("click",".to-main",function(e) {
		
		var currentDataFound = 'not-found';
		
		var aSessionStorageKeys = Object.keys(sessionStorage);
		
		if(jQuery('body').hasClass('saldo-active')){			
			
			jQuery.cancelAddSaldo();
			
		} else {
			if (aSessionStorageKeys.length === 0 || aSessionStorageKeys == ''){
			
			} else {
				
				jQuery.each( aSessionStorageKeys, function( key, value ) {
					
					if(value.substring(0,8) == 'current_'){
						currentDataFound = 'found'; 
						return;				
					}
				});
			}
			
			if(currentDataFound == 'found'){
				
				var popupLoadConceptContent = '<div class="concept-confirmation" id="concept-confirmation">';
					popupLoadConceptContent += '<h2 id="concept-confirmation-title">Actieve advertentie</h2>';
					popupLoadConceptContent += '<span class="title">U heeft niet-opgeslagen aanpassingen gemaakt. Als u deze pagina verlaat gaan deze gegevens verloren.<br>Wilt u deze pagina verlaten?</span>';					
					popupLoadConceptContent += '<span class="sure" onclick="jQuery.cancelConcept(\'resume\');"></span>';
					popupLoadConceptContent += '<span class="not-sure" onclick="jQuery.cancelConcept(\'cancel\');"></span>';
				popupLoadConceptContent += '</div>"';
		
				oLightboxLoadConceptArticle = SimpleLightbox.open({
					closeOnOverlayClick: false,
					closeOnEscapeKey: false,
					content: popupLoadConceptContent,
					beforeClose: function(){
						setLoadingOverlay('fadeout');						
					}
				});

				
			} else {		
			
				if(jQuery('body').hasClass('content-page')){
				} else {		
					jQuery.clearConcept();
				}		
				
				sessionStorage.removeItem('active_sub_sub_group');
				sessionStorage.removeItem('active_sub_group');				
				sessionStorage.removeItem('active_group');
				sessionStorage.removeItem('active_article');
				
				window.location.replace('/');
			}
		}
		
	});
	
	var oLightboxBeta = false;
	
	jQuery(document).on("click",".beta-container",function(e) {
		var popupBetaContent = '<div class="concept-confirmation" id="concept-confirmation">';
			popupBetaContent += '<h2 id="concept-confirmation-title">B&Egrave;TA versie</h2>';
			popupBetaContent += '<span class="title">OVIS mobiel is een b&egrave;ta-versie. Niet alle desktop-functies zijn ook hier beschikbaar.<br><br>We kijken uit naar uw feedback en zullen de mobiele omgeving blijven verbeteren en optimaliseren.</span>';					
			
			popupBetaContent += '<span class="continue" onclick="jQuery.acceptBeta();">Begrepen</span>';
		popupBetaContent += '</div>"';

		oLightboxBeta = SimpleLightbox.open({
			closeOnOverlayClick: false,
			closeOnEscapeKey: false,
			content: popupBetaContent,
			beforeClose: function(){
				setLoadingOverlay('fadeout');						
			}
		});
	});
	
	jQuery.acceptBeta = function(){	
		oLightboxBeta.close();
	}
	
	
	jQuery.cancelConcept = function(action){		
		if(action == 'resume'){			
			jQuery.clearConcept();
			
			sessionStorage.removeItem('active_sub_sub_group');
			sessionStorage.removeItem('active_sub_group');				
			sessionStorage.removeItem('active_group');
			sessionStorage.removeItem('active_article');
			
			window.location.replace('/');			
		} else if(action == 'cancel') {
			oLightboxLoadConceptArticle.close();
		}		
	}
});

/*
 * Select2 inputs
 * 
 * Doesn't have to wait before the dom complete loads
 */
	
$('select[name=user_province]').select2({

	placeholder: 'Kies provincie',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[id=user_country]').select2({

	placeholder: 'Kies land',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[id=shipping_country]').select2({

	placeholder: 'Kies land',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[id=invoice_country]').select2({

	placeholder: 'Kies land',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[name=article_group]').select2({

	placeholder: 'Filter groep',
	language: "nl"

});

$('select[name=article_category]').select2({

	placeholder: 'Filter categorie',
	language: "nl"

});

$('select[name=article_sort]').select2({

	placeholder: 'Filter',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[name=article_deliverytime]').select2({

	placeholder: 'Levertijd',
	language: "nl",
	minimumResultsForSearch: -1

});


$('select[name=article_assemblyfree]').select2({

	placeholder: 'Maak keuze',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[name=user_paymentmethods]').select2({

	placeholder: 'Betaalmethodes',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[name=user_shippingcosts]').select2({

	tags: true,
	placeholder: 'Verzendkosten',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[name=article_shippingcosts]').select2({

	placeholder: 'Verzendkosten',
	language: "nl",
	minimumResultsForSearch: -1

});

$('select[name=order_status]').select2({

	language: "nl",
	minimumResultsForSearch: -1

});

$('select[name=category_parent]').select2({

	placeholder: 'Geen',
	language: "nl",
	minimumResultsForSearch: -1

});

jQuery.clearConcept = function(action){
	
	var aSessionStorageKeys = Object.keys(sessionStorage);
	
	if (aSessionStorageKeys.length === 0 || aSessionStorageKeys == ''){
		// geen clear mogelijk		
	} else {
		
		jQuery.each( aSessionStorageKeys, function( key, value ) {
			
			if(value.substring(0,8) == 'current_'){					
				sessionStorage.removeItem(value);				
			} else if(value.substring(0,14) == 'edit_indicator'){
				jQuery('.article-input-subgroup.type').removeClass('active'); 
				jQuery('.article-input-subgroup.accessories').removeClass('active'); 
				jQuery('.article-input-subgroup.divisions').removeClass('active'); 
				jQuery('.article-input-subgroup.engines').removeClass('active'); 
				jQuery('.article-input-subgroup.dates').removeClass('active'); 
				jQuery('.article-input-subgroup.sizes').removeClass('active'); 
				jQuery('.article-input-subgroup.sleep').removeClass('active'); 
				
				sessionStorage.removeItem('edit_indicator');
			}
		});
	}
	
	
	if(typeof articleCategory == 'undefined' || articleCategory == ''){
				
		if(jQuery('body').hasClass('isn-debug')){			
			jQuery('body').attr('class', 'add-or-edit isn-debug');
		} else {		
			jQuery('body').attr('class', 'add-or-edit');
		}
		
		sessionStorage.removeItem('active_sub_sub_group');
		sessionStorage.removeItem('active_sub_group');				
		sessionStorage.removeItem('active_group');
		sessionStorage.removeItem('temp_article');
		
	}
}

jQuery.acceptDesktop = function(){	
	oLightboxDesktopItem.close();
}

jQuery(document).on("click",".desktop-item",function(e) {
	var popupDesktopItemContent = '<div class="concept-confirmation" id="concept-confirmation">';
		popupDesktopItemContent += '<h2 id="concept-confirmation-title">Desktop</h2>';
		popupDesktopItemContent += '<span class="title">Dit onderdeel in OVIS is momenteel niet beschikbaar op een mobiel apparaat.</span>';					
		popupDesktopItemContent += '<span class="continue" onclick="jQuery.acceptDesktop();">Begrepen</span>';
	popupDesktopItemContent += '</div>"';

	oLightboxDesktopItem = SimpleLightbox.open({
		closeOnOverlayClick: false,
		closeOnEscapeKey: false,
		content: popupDesktopItemContent,
		beforeClose: function(){
			setLoadingOverlay('fadeout');						
		}
	});	
});

