$(function() {
	
	setLoadingOverlay('fadein');
		
	var oLightboxLoadConceptArticle = false;
	
	jQuery(document).on("focus",".text-input",function(e) {
		jQuery('.input-active').removeClass('input-active');
		jQuery(this).closest('div').addClass('input-active');
	});
	
	jQuery(document).on("focus",".price-input",function(e) {
		jQuery('.input-active').removeClass('input-active');
		jQuery(this).closest('div').addClass('input-active');
	});
	
	jQuery(document).on("focusout",".text-input",function(e) {
		//$('#set-license').prop("disabled", true);
		//jQuery(this).closest('div').removeClass('input-active');
	});
	
	jQuery(document).on("click","#license-container",function(e) {
		$('#set-license').prop("disabled", false).focus();
	});
	
	jQuery(document).on("click","#type-container",function(e) {
		$('#set-type').prop("disabled", false).focus();
	});
	
	jQuery(document).on("click","#toevoeging-container",function(e) {
		$('#set-toevoeging').prop("disabled", false).focus();
	});
	
	jQuery(document).on("click","#set-license",function(e) {		
		$('#set-license').prop("disabled", false).focus();
	});
		
	jQuery.acceptErrors = function(){	
		oLightboxSaveErrorArticle.close();		
		setLoadingOverlay('fadeout');	
	}
	
	jQuery.acceptMessage = function(){	
		oLightboxNotEditableArticle.close();		
		setLoadingOverlay('fadeout');	
	}
	
	jQuery.resumeConcept = function(action){		
		var sCurrentGroup = sessionStorage.getItem('active_group') !== null ? sessionStorage['active_group'] : '';
		
		if(action == 'resume'){	
			oLightboxLoadConceptArticle.close();			
			jQuery.parseConceptData();	
		} else if(action == 'cancel') {
			jQuery.clearConcept();
			oLightboxLoadConceptArticle.close();		
			setLoadingOverlay('fadeout');			
		}		
		
		parsePreview(sCurrentGroup);
	}
	
	jQuery.closeMarktplaatsMessage = function(){			
		oLightboxMarktplaatsNoPrice.close();
	}
	
	jQuery.initAddEdit = function () {	
		var sActiveSucces = sessionStorage.getItem('active_succes') !== null ? sessionStorage['active_succes'] : '';
		
		var iTempArticle = sessionStorage.getItem('temp_article') !== null ? sessionStorage['temp_article'] : externalID;
		var sCurrentArticle = sessionStorage.getItem('active_article') !== null ? sessionStorage['active_article'] : '';
		var sCurrentArticleFromURL = typeof articleID != 'undefined' && articleID != '' ? articleID : '';
		var sCurrentGroup = sessionStorage.getItem('active_group') !== null ? sessionStorage['active_group'] : '';
		var sCurrentCategory = sessionStorage.getItem('current_category') !== null ? sessionStorage['current_category'] : '';
		var sCurrentSubCategory = sessionStorage.getItem('current_subcategory') !== null ? sessionStorage['current_subcategory'] : '';
		var sReturnPage = sessionStorage.getItem('return_page') !== null ? sessionStorage['return_page'] : '';
		var aSessionStorageKeys = Object.keys(sessionStorage);
		var currentDataFound = 'not-found';
		
		if(sCurrentArticle == ''){		
			sessionStorage['temp_article'] = iTempArticle;		
			externalID = iTempArticle;
		}
		
		if(sActiveSucces != '' && sActiveSucces == sCurrentArticleFromURL){
			jQuery('#save-edit-succes').animate({top: '0px'},400);
		} else {
			sessionStorage.removeItem('active_succes');
		}
		
		if (aSessionStorageKeys != '' && aSessionStorageKeys.length > 0){
			
			jQuery.each( aSessionStorageKeys, function( key, value ) {
				
				if(value.substring(0,8) == 'current_'){
					currentDataFound = 'found'; 
					return;				
				}
			});
		}		
		
		if(sCurrentCategory == '' && typeof articleCategory != 'undefined' && articleCategory != '' ){	
			sCurrentCategory = articleCategory;		
		}
		
		jQuery.parseLocationData();
					
		if(jQuery('#open-sub-subcategory').length == 0){
			getCategories();
		}
				
		if(typeof articleID != 'undefined' && articleID != ''){			
			if(sCurrentArticle != '' && articleID != sCurrentArticle){
				jQuery.clearConcept();
				sessionStorage.removeItem('active_article');				
				sessionStorage['active_article'] = articleID;
			} else {
				sessionStorage['active_article'] = articleID;			
			}
			
			getCategories();
			getBrands();
			
			getModels();
			getVersions();
			getAccessories();
			getDivisions();
			//parseSubCategories();
			
		} else {
			if(typeof pageType != 'undefined' && pageType == 'add' && sCurrentArticle != ''){
				jQuery.clearConcept();
				sessionStorage.removeItem('active_article');
			}				
		}		
		
		var aSessionStorageKeys = Object.keys(sessionStorage);
		
		if (aSessionStorageKeys.length === 0 || aSessionStorageKeys == ''){
			setLoadingOverlay('fadeout');			
			parsePreview(sCurrentGroup);
		} else {			
			if(currentDataFound == 'found'){				
				if(sReturnPage == 'return'){
					sessionStorage.removeItem('return_page');
					jQuery.parseConceptData();
					parsePreview(sCurrentGroup);
				} else {	
					if(sCurrentArticle != ''){
						if(articleID  != '' && articleID != sCurrentArticle){
							jQuery.clearConcept();
							setLoadingOverlay('fadeout');						
							return;
						}
					}					
					
					var popupLoadConceptContent = '<div class="concept-confirmation" id="concept-confirmation">';
						popupLoadConceptContent += '<h2 id="concept-confirmation-title">Autosave gevonden</h2>';
						popupLoadConceptContent += '<span class="title">Er is een autosave van deze presentatie dat recenter is, wil je deze inladen?</span>';					
						popupLoadConceptContent += '<span class="sure" onclick="jQuery.resumeConcept(\'resume\');"></span>';
						popupLoadConceptContent += '<span class="not-sure" onclick="jQuery.resumeConcept(\'cancel\');"></span>';
					popupLoadConceptContent += '</div>"';
			
					oLightboxLoadConceptArticle = SimpleLightbox.open({
						closeOnOverlayClick: false,
						closeOnEscapeKey: false,
						content: popupLoadConceptContent,
						beforeClose: function(){
							setLoadingOverlay('fadeout');						
						}
					});	
				}
			} else {
				setLoadingOverlay('fadeout');
				parsePreview(sCurrentGroup);
			}
			
			setTimeout(function() {
				jQuery('#save-edit-succes').animate({top: '-60px'},400);
				sessionStorage.removeItem('active_succes');
			}, 3000);
			
		}
	}	
	
	jQuery.parseLocationData = function () {		
		var sCurrentArticle = sessionStorage.getItem('active_article') !== null ? sessionStorage['active_article'] : '';
		var sCurrentGroup = sessionStorage.getItem('active_group') !== null ? sessionStorage['active_group'] : '';
		var sCurrentSubGroup = sessionStorage.getItem('active_sub_group') !== null ? sessionStorage['active_sub_group'] : '';
		var sCurrentSubSubGroup = sessionStorage.getItem('active_sub_sub_group') !== null ? sessionStorage['active_sub_sub_group'] : '';
		var sGroupName = '';
		
		if(sCurrentGroup != ''){
			jQuery('body').addClass(sCurrentGroup);
			jQuery('body').addClass('group-active');
			
			if(sCurrentGroup == 'category-active'){
				jQuery('#title-container').html('Categorie');
				getCategories();
			}
			
			if(sCurrentGroup == 'features-active'){
				jQuery('#title-container').html('Kenmerken');
				loadFeatures();
				parseCategories();				
			}
			
			if(sCurrentGroup == 'description-active'){
				jQuery('#title-container').html('Beschrijving');
			}
			
			if(sCurrentGroup == 'prices-active'){
				jQuery('#title-container').html('Prijzen');
			}
			
			if(sCurrentGroup == 'marktplaats-active'){
				jQuery('#title-container').html('Marktplaats');
			}
			
			if(sCurrentGroup == 'preview-active'){
				jQuery('#title-container').html('Preview');
			}
		} else if(sCurrentArticle != ''){
			getCategories();		
		}
		
		if(sCurrentSubGroup != ''){
			jQuery('body').addClass('has-active-sub');
			jQuery('body').addClass(sCurrentSubGroup);
			
			if(sCurrentSubGroup == 'omschrijving-active'){	
				jQuery('#title-container').html('Omschrijving');
			}
			if(sCurrentSubGroup == 'comments-active'){	
				jQuery('#title-container').html('Opmerkingen');
			}
			if(sCurrentSubGroup == 'reference-active'){	
				jQuery('#title-container').html('Referentie');
			}			
			if(sCurrentSubGroup == 'license-active'){	
				jQuery('#title-container').html('Kenteken');
			}			
			if(sCurrentSubGroup == 'type-active'){	
				jQuery('#title-container').html('Specificaties');
			}			
			if(sCurrentSubGroup == 'accessories-active'){	
				jQuery('#title-container').html('Accessoires');				
				getAccessories();
			}
			if(sCurrentSubGroup == 'divisions-active'){	
				jQuery('#title-container').html('Indelingen');				
				getDivisions();
			}
			if(sCurrentSubGroup == 'dates-active'){	
				jQuery('#title-container').html('Data en jaartallen');
			}
			if(sCurrentSubGroup == 'sizes-active'){	
				jQuery('#title-container').html('Maten en gewichten');
			}
			if(sCurrentSubGroup == 'sleep-active'){	
				jQuery('#title-container').html('Slapen');
			}
			if(sCurrentSubGroup == 'brand-active'){	
				jQuery('#title-container').html('Merk');
				getBrands();
			}				
			if(sCurrentSubGroup == 'model-active'){
				jQuery('#title-container').html('Model');
				getModels();
			}
			if(sCurrentSubGroup == 'version-active'){	
				jQuery('#title-container').html('Version');				
				getVersions();	
			}
			if(sCurrentSubGroup == 'version-active'){
				jQuery('#title-container').html('Version');
				//getModels();
			}
			if(sCurrentSubGroup == 'engines-active'){
				jQuery('#title-container').html('Motoren');
			}	
			if(sCurrentSubGroup == 'marktplaats-active'){
				jQuery('#title-container').html('Marktplaats');
			}	
			if(sCurrentSubGroup == 'preview-active'){
				jQuery('#title-container').html('Preview');
			}				
		}
		
		if(sCurrentSubSubGroup != ''){
			jQuery('body').addClass('sub-active');
			jQuery('#'+sCurrentSubSubGroup+'-container').addClass('active-sub-container');
			jQuery('#sub-'+sCurrentSubSubGroup).addClass('active');
			
			if(sCurrentSubSubGroup == 'period'){				
				jQuery('#title-container').html('Looptijd');				
				jQuery('.status-group').addClass('hidden');				
			}
			if(sCurrentSubSubGroup == 'fuel'){
				jQuery('#title-container').html('Brandstof');
			}
			if(sCurrentSubSubGroup == 'engine-fuel'){
				jQuery('#title-container').html('Brandstof');
			}
			if(sCurrentSubSubGroup == 'boat-engine-fuel'){
				jQuery('#title-container').html('Brandstof');
			}
			if(sCurrentSubSubGroup == 'subcategory'){
				jQuery('#title-container').html('Soort');
			}	
			if(sCurrentSubSubGroup == 'condition'){
				jQuery('#title-container').html('Conditie');			
			}	
			if(sCurrentSubSubGroup == 'transmission'){
				jQuery('#title-container').html('Transmissie');
			}	
			if(sCurrentSubSubGroup == 'euro-class'){
				jQuery('#title-container').html('Euroklasse');
			}	
			if(sCurrentSubSubGroup == 'persons-boat'){
				jQuery('#title-container').html('Personen');
			}	
			if(sCurrentSubSubGroup == 'seats'){
				jQuery('#title-container').html('Zitplaatsen');
			}
			if(sCurrentSubSubGroup == 'seatbels'){
				jQuery('#title-container').html('Gordelplaatsen');
			}	
			if(sCurrentSubSubGroup == 'owners'){
				jQuery('#title-container').html('Eigenaren');
			}	
			if(sCurrentSubSubGroup == 'number-of-doors'){
				jQuery('#title-container').html('Aantal deuren');
			}	
			if(sCurrentSubSubGroup == 'floor-material'){
				jQuery('#title-container').html('Vloer');
			}	
			if(sCurrentSubSubGroup == 'size-boat'){
				jQuery('#title-container').html('Bootafmeting');
			}	
			if(sCurrentSubSubGroup == 'material-boat'){
				jQuery('#title-container').html('Materiaal');
			}	
			if(sCurrentSubSubGroup == 'wall-material'){
				jQuery('#title-container').html('Wanden/borden');
			}	
			if(sCurrentSubSubGroup == 'plug'){
				jQuery('#title-container').html('Stekker');
			}	
			if(sCurrentSubSubGroup == 'boottailer-plug'){
				jQuery('#title-container').html('Stekker');
			}	
			if(sCurrentSubSubGroup == 'boattrailer-axles'){
				jQuery('#title-container').html('Assen');
			}	
			if(sCurrentSubSubGroup == 'axles'){
				jQuery('#title-container').html('Assen');
			}	
			if(sCurrentSubSubGroup == 'door-types'){
				jQuery('#title-container').html('Type deuren');
			}	
			if(sCurrentSubSubGroup == 'bedrooms'){
				jQuery('#title-container').html('Slaapkamers');
			}	
			if(sCurrentSubSubGroup == 'boat-bed'){
				jQuery('#title-container').html('Bedden');
			}	
			if(sCurrentSubSubGroup == 'walltype'){
				jQuery('#title-container').html('Wanden');
			}	
			if(sCurrentSubSubGroup == 'material'){
				jQuery('#title-container').html('Materiaal');
			}	
			if(sCurrentSubSubGroup == 'material-tenttrailer'){
				jQuery('#title-container').html('Materiaal');
			}		
			if(sCurrentSubSubGroup == 'color'){
				jQuery('#title-container').html('Kleur');
			}		
			if(sCurrentSubSubGroup == 'color-trailer'){
				jQuery('#title-container').html('Kleur');
			}		
			if(sCurrentSubSubGroup == 'constructionmonth'){
				jQuery('#title-container').html('Bouwmaand');
			}		
			if(sCurrentSubSubGroup == 'engine-type'){
				jQuery('#title-container').html('Motortype');
			}		
			if(sCurrentSubSubGroup == 'engine-startsystem'){
				jQuery('#title-container').html('Startsysteem');
			}	
			if(sCurrentSubSubGroup == 'boat-engine-startsystem'){
				jQuery('#title-container').html('Startsysteem');
			}		
			if(sCurrentSubSubGroup == 'engine-steering'){
				jQuery('#title-container').html('Besturing');
			}		
			if(sCurrentSubSubGroup == 'engine-tail-length'){
				jQuery('#title-container').html('Staartlengte');
			}			
			
			if(sCurrentSubSubGroup == 'status' || sCurrentSubSubGroup == 'period' || sCurrentSubSubGroup == 'vat' || sCurrentSubSubGroup == 'marktplaats-pricetype'){
				sGroupName = jQuery('#'+sCurrentSubSubGroup+'-container').closest('.add-edit-group').data('groupname');				
			} else {
				sGroupName = jQuery('#'+sCurrentSubSubGroup+'-container').closest('.add-edit-subgroup').data('groupname');
			}
							
			if(typeof sGroupName != 'undefined' && sGroupName != ''){
				jQuery('.' + sGroupName+'-container').not('.active-sub-container').addClass('has-open-sub');	
			}		
		}	
	}
	
	jQuery.checkConditionAvailability = function(sCurrentCategory){
		if(typeof sCurrentCategory != 'undefined' && sCurrentCategory != ''){	
			jQuery( ".condition-radio" ).checkboxradio( "destroy" );
			
			jQuery('#label-set-condition-new').html( "Nieuw" );
			jQuery('#label-set-condition-used').html( "Gebruikt" );
						
			if(typeof userLimits != 'undefined'){							
				if(typeof userLimits[sCurrentCategory.toLowerCase()] != 'undefined'){						
					if(typeof userLimits[sCurrentCategory.toLowerCase()]["general"] != 'undefined'){						
						
						if(userLimits[sCurrentCategory.toLowerCase()]["used"] === false){							
							jQuery('#set-condition-used').prop('disabled', 'disabled');
							jQuery('#label-set-condition-used').html( "Gebruikt - <i>limiet bereikt</i>" );
						}

						if(userLimits[sCurrentCategory.toLowerCase()]["new"] === false){
							jQuery('#set-condition-new').prop('disabled', 'disabled');
							jQuery('#label-set-condition-new').html( "Nieuw - <i>limiet bereikt</i>" );
						}
					}						
				}						
			}
			
			jQuery( ".condition-radio" ).checkboxradio({
			  icon: false
			});
		}
	}
	
	jQuery.parseConceptData = function () {			
		var sCurrentArticle = sessionStorage.getItem('active_article') !== null ? sessionStorage['active_article'] : '';
		
		var sCurrentImages = sessionStorage.getItem('current_images') !== null ? sessionStorage['current_images'] : '';
		
		var sCurrentStatus = sessionStorage.getItem('current_status') !== null ? sessionStorage['current_status'] : '';
		var sCurrentCategory = sessionStorage.getItem('current_category') !== null ? sessionStorage['current_category'] : '';
				
		var sCurrentSubCategory = sessionStorage.getItem('current_subcategory') !== null ? sessionStorage['current_subcategory'] : '';
		var sCurrentBrand = sessionStorage.getItem('current_brand') !== null ? sessionStorage['current_brand'] : '';
		var sCurrentModel = sessionStorage.getItem('current_model') !== null ? sessionStorage['current_model'] : '';
		var sCurrentVersion = sessionStorage.getItem('current_version') !== null ? sessionStorage['current_version'] : '';
		var sCurrentLicense = sessionStorage.getItem('current_license') !== null ? sessionStorage['current_license'] : '';
		
		var sCurrentDescription = sessionStorage.getItem('current_description') !== null ? sessionStorage['current_description'] : '';
		var sCurrentComment = sessionStorage.getItem('current_comment') !== null ? sessionStorage['current_comment'] : '';
		var sCurrentReference = sessionStorage.getItem('current_reference') !== null ? sessionStorage['current_reference'] : '';
		
		var sCurrentCondition = sessionStorage.getItem('current_condition') !== null ? sessionStorage['current_condition'] : '';
		
		var sCurrentAccessories = sessionStorage.getItem('current_accessories') !== null ? sessionStorage['current_accessories'] : '';
		var sCurrentDivisions = sessionStorage.getItem('current_divisions') !== null ? sessionStorage['current_divisions'] : '';
		
		var sCurrentFuel = sessionStorage.getItem('current_fuel') !== null ? sessionStorage['current_fuel'] : '';
		var sCurrentTransmission = sessionStorage.getItem('current_transmission') !== null ? sessionStorage['current_transmission'] : '';
		var sCurrentEuroClass = sessionStorage.getItem('current_euro-class') !== null ? sessionStorage['current_euro-class'] : '';
		var sCurrentSeats = sessionStorage.getItem('current_seats') !== null ? sessionStorage['current_seats'] : '';
		var sCurrentSeatbelts = sessionStorage.getItem('current_seatbelts') !== null ? sessionStorage['current_seatbelts'] : '';
		var sCurrentOwners = sessionStorage.getItem('current_owners') !== null ? sessionStorage['current_owners'] : '';
		var sCurrentBedrooms = sessionStorage.getItem('current_bedrooms') !== null ? sessionStorage['current_bedrooms'] : '';
		var sCurrentWalltype = sessionStorage.getItem('current_walltype') !== null ? sessionStorage['current_walltype'] : '';
		var sCurrentMaterial = sessionStorage.getItem('current_material') !== null ? sessionStorage['current_material'] : '';
		var sCurrentMaterialTentTrailer = sessionStorage.getItem('current_material-tenttrailer') !== null ? sessionStorage['current_material-tenttrailer'] : '';
		var sCurrentColor = sessionStorage.getItem('current_color') !== null ? sessionStorage['current_color'] : '';
		var sCurrentColorTrailer = sessionStorage.getItem('current_color-trailer') !== null ? sessionStorage['current_color-trailer'] : '';
		
		var sCurrentNap = sessionStorage.getItem('current_nap') !== null ? sessionStorage['current_nap'] : '';
		var sCurrentMetallic = sessionStorage.getItem('current_metallic') !== null ? sessionStorage['current_metallic'] : '';
		var sCurrentParticulateFilter = sessionStorage.getItem('current_particulateFilter') !== null ? sessionStorage['current_particulateFilter'] : '';
		var sCurrentDamaged = sessionStorage.getItem('current_damaged') !== null ? sessionStorage['current_damaged'] : '';
		var sCurrentHailDamage = sessionStorage.getItem('current_hailDamage') !== null ? sessionStorage['current_hailDamage'] : '';
		var sCurrentDemo = sessionStorage.getItem('current_demo') !== null ? sessionStorage['current_demo'] : '';
		var sCurrentExRental = sessionStorage.getItem('current_exRental') !== null ? sessionStorage['current_exRental'] : '';
		var sCurrentPossibleRental = sessionStorage.getItem('current_possibleRental') !== null ? sessionStorage['current_possibleRental'] : '';
		var sCurrentMaintenanceBooklets = sessionStorage.getItem('current_maintenanceBooklets') !== null ? sessionStorage['current_maintenanceBooklets'] : '';
		var sCurrentSuitableForDisabledPeople = sessionStorage.getItem('current_suitableForDisabledPeople') !== null ? sessionStorage['current_suitableForDisabledPeople'] : '';
		
		var sCurrentType = sessionStorage.getItem('current_type') !== null ? sessionStorage['current_type'] : '';
		var sCurrentChassisnummer = sessionStorage.getItem('current_chassisnummer') !== null ? sessionStorage['current_chassisnummer'] : '';
		var sCurrentToevoeging = sessionStorage.getItem('current_toevoeging') !== null ? sessionStorage['current_toevoeging'] : '';
		var sCurrentMileage = sessionStorage.getItem('current_mileage') !== null ? sessionStorage['current_mileage'] : '';
		var sCurrentCarBrand = sessionStorage.getItem('current_carbrand') !== null ? sessionStorage['current_carbrand'] : '';
		var sCurrentPower = sessionStorage.getItem('current_power') !== null ? sessionStorage['current_power'] : '';
		
		var sCurrentConstructionmonth = sessionStorage.getItem('current_constructionmonth') !== null ? sessionStorage['current_constructionmonth'] : '';
		var sCurrentConstructionyear = sessionStorage.getItem('current_constructionyear') !== null ? sessionStorage['current_constructionyear'] : '';
		var sCurrentModelyear = sessionStorage.getItem('current_modelyear') !== null ? sessionStorage['current_modelyear'] : '';
		var sCurrentPartA = sessionStorage.getItem('current_part-a') !== null ? sessionStorage['current_part-a'] : '';
		var sCurrentFirstNL = sessionStorage.getItem('current_first-nl') !== null ? sessionStorage['current_first-nl'] : '';
				
		var sCurrentConstructionLength = sessionStorage.getItem('current_construction-length') !== null ? sessionStorage['current_construction-length'] : '';
		var sCurrentContainerLength = sessionStorage.getItem('current_container-length') !== null ? sessionStorage['current_container-length'] : '';
		var sCurrentTotalLength = sessionStorage.getItem('current_total-length') !== null ? sessionStorage['current_total-length'] : '';
		var sCurrentLength = sessionStorage.getItem('current_length') !== null ? sessionStorage['current_length'] : '';
		var sCurrentTrailerTotalLength = sessionStorage.getItem('current_trailer-total-length') !== null ? sessionStorage['current_trailer-total-length'] : '';
		var sCurrentDrawbarLength = sessionStorage.getItem('current_drawbar-length') !== null ? sessionStorage['current_drawbar-length'] : '';
		var sCurrentContainerWidth = sessionStorage.getItem('current_container-width') !== null ? sessionStorage['current_container-width'] : '';
		var sCurrentWidth = sessionStorage.getItem('current_width') !== null ? sessionStorage['current_width'] : '';
		var sCurrentTotalWidth = sessionStorage.getItem('current_total-width') !== null ? sessionStorage['current_total-width'] : '';
		var sCurrentHeight = sessionStorage.getItem('current_height') !== null ? sessionStorage['current_height'] : '';
		var sCurrentHeadroom = sessionStorage.getItem('current_headroom') !== null ? sessionStorage['current_headroom'] : '';
		var sCurrentCirculationsize = sessionStorage.getItem('current_circulationsize') !== null ? sessionStorage['current_circulationsize'] : '';
		var sCurrentLoadingPlatformHeight = sessionStorage.getItem('current_loading-platform-height') !== null ? sessionStorage['current_loading-platform-height'] : '';
		var sCurrentCouplerHeight = sessionStorage.getItem('current_coupler-height') !== null ? sessionStorage['current_coupler-height'] : '';
		var sCurrentBordersHeight = sessionStorage.getItem('current_borders-height') !== null ? sessionStorage['current_borders-height'] : '';
		var sCurrentLadderRackHeight = sessionStorage.getItem('current_ladder-rack-height') !== null ? sessionStorage['current_ladder-rack-height'] : '';
		var sCurrentTotalHeight = sessionStorage.getItem('current_total-height') !== null ? sessionStorage['current_total-height'] : '';
		var sCurrentInternalHeight = sessionStorage.getItem('current_internal-height') !== null ? sessionStorage['current_internal-height'] : '';
		var sCurrentBasePlateHeight = sessionStorage.getItem('current_internal-height') !== null ? sessionStorage['current_internal-height'] : '';
		var sCurrentTireSize = sessionStorage.getItem('current_tire-size') !== null ? sessionStorage['current_tire-size'] : '';
		var sCurrentVolume = sessionStorage.getItem('current_volume') !== null ? sessionStorage['current_volume'] : '';
		var sCurrentEmptyWeight = sessionStorage.getItem('current_empty-weight') !== null ? sessionStorage['current_empty-weight'] : '';
		var sCurrentRoadworthyWeight = sessionStorage.getItem('current_roadworthy-weight') !== null ? sessionStorage['current_roadworthy-weight'] : '';
		var sCurrentMaxWeight = sessionStorage.getItem('current_max-weight') !== null ? sessionStorage['current_max-weight'] : '';
		var sCurrentCapacity = sessionStorage.getItem('current_capacity') !== null ? sessionStorage['current_capacity'] : '';
		var sCurrentNumberOfDoors = sessionStorage.getItem('current_number-of-doors') !== null ? sessionStorage['current_number-of-doors'] : '';
		var sCurrentDoorTypes = sessionStorage.getItem('current_door-types') !== null ? sessionStorage['current_door-types'] : '';
		var sCurrentPlug = sessionStorage.getItem('current_plug') !== null ? sessionStorage['current_plug'] : '';
		var sCurrentKipAngle = sessionStorage.getItem('current_kip-angle') !== null ? sessionStorage['current_kip-angle'] : '';
		var sCurrentAxles = sessionStorage.getItem('current_axles') !== null ? sessionStorage['current_axles'] : '';
		var sCurrentFloorMaterial = sessionStorage.getItem('current_floor-material') !== null ? sessionStorage['current_floor-material'] : '';
		var sCurrentWallMaterial = sessionStorage.getItem('current_wall-material') !== null ? sessionStorage['current_wall-material'] : '';
		
		var sCurrentBoatTrailerPlug = sessionStorage.getItem('current_boattrailer-plug') !== null ? sessionStorage['current_boattrailer-plug'] : '';
		var sCurrentBoatTrailerAxles = sessionStorage.getItem('current_boattrailer-axles') !== null ? sessionStorage['current_boattrailer-axles'] : '';
		
		var sCurrentSleepingplaces = sessionStorage.getItem('current_sleepingplaces') !== null ? sessionStorage['current_sleepingplaces'] : '';
		var sCurrentBeds = sessionStorage.getItem('current_beds') !== null ? sessionStorage['current_beds'] : '';
		
		var sCurrentModelBoat = sessionStorage.getItem('current_model-boat') !== null ? sessionStorage['current_model-boat'] : '';
		var sCurrentTitleBoat = sessionStorage.getItem('current_title-boat') !== null ? sessionStorage['current_title-boat'] : '';
		var sCurrentLigplaatsBoat = sessionStorage.getItem('current_ligplaats-boat') !== null ? sessionStorage['current_ligplaats-boat'] : '';
		var sCurrentTrailerBoat = sessionStorage.getItem('current_trailer-boat') !== null ? sessionStorage['current_trailer-boat'] : '';
		var sCurrentPersonsBoat = sessionStorage.getItem('current_persons-boat') !== null ? sessionStorage['current_persons-boat'] : '';
		var sCurrentMaterialBoat = sessionStorage.getItem('current_material-boat') !== null ? sessionStorage['current_material-boat'] : '';
		var sCurrentSizeBoat = sessionStorage.getItem('current_size-boat') !== null ? sessionStorage['current_size-boat'] : '';
		var sCurrentColorBoat = sessionStorage.getItem('current_color-boat') !== null ? sessionStorage['current_color-boat'] : '';
		var sCurrentDeckBoat = sessionStorage.getItem('current_deck-boat') !== null ? sessionStorage['current_deck-boat'] : '';
		var sCurrentBedsBoat = sessionStorage.getItem('current_beds-boat') !== null ? sessionStorage['current_beds-boat'] : '';
		
		var sCurrentDepth = sessionStorage.getItem('current_depth') !== null ? sessionStorage['current_depth'] : '';
		var sCurrentVerticalclearance = sessionStorage.getItem('current_verticalclearance') !== null ? sessionStorage['current_verticalclearance'] : '';
		
		var sCurrentEngineFuel = sessionStorage.getItem('current_engine-fuel') !== null ? sessionStorage['current_engine-fuel'] : '';
		var sCurrentEngineTailLength = sessionStorage.getItem('current_engine-tail-length') !== null ? sessionStorage['current_engine-tail-length'] : '';
		var sCurrentEngineStartsystem = sessionStorage.getItem('current_engine-startsystem') !== null ? sessionStorage['current_engine-startsystem'] : '';
		var sCurrentEngineSteering = sessionStorage.getItem('current_engine-steering') !== null ? sessionStorage['current_engine-steering'] : '';
		var sCurrentEngineTankCapacity = sessionStorage.getItem('current_engine-tank-capacity') !== null ? sessionStorage['current_engine-tank-capacity'] : '';
		var sCurrentEnginePower = sessionStorage.getItem('current_engine-power') !== null ? sessionStorage['current_engine-power'] : '';
		var sCurrentEngineCylinders = sessionStorage.getItem('current_engine-cylinders') !== null ? sessionStorage['current_engine-cylinders'] : '';
		var sCurrentEngineSize = sessionStorage.getItem('current_engine-size') !== null ? sessionStorage['current_engine-size'] : '';
		var sCurrentEngineDryWeight = sessionStorage.getItem('current_engine-dry-weight') !== null ? sessionStorage['current_engine-dry-weight'] : '';
		
		var sCurrentEngineNumber = sessionStorage.getItem('current_engines-boat') !== null ? sessionStorage['current_engines-boat'] : '';
		var sCurrentBoatEngineHasEngine = sessionStorage.getItem('current_boat-engine-has-engine') !== null ? sessionStorage['current_boat-engine-has-engine'] : '';
		var sCurrentBoatEngineType = sessionStorage.getItem('current_boat-engine-type') !== null ? sessionStorage['current_boat-engine-type'] : '';
		var sCurrentBoatEngineStartsystem = sessionStorage.getItem('current_boat-engine-startsystem') !== null ? sessionStorage['current_boat-engine-startsystem'] : '';
		var sCurrentBoatEngineFuel = sessionStorage.getItem('current_boat-engine-fuel') !== null ? sessionStorage['current_boat-engine-fuel'] : '';
		var sCurrentBoatEngineBrand = sessionStorage.getItem('current_boat-engine-brand') !== null ? sessionStorage['current_boat-engine-brand'] : '';
		var sCurrentBoatEngineModel = sessionStorage.getItem('current_boat-engine-model') !== null ? sessionStorage['current_boat-engine-model'] : '';
		var sCurrentBoatEnginePower = sessionStorage.getItem('current_boat-engine-power') !== null ? sessionStorage['current_boat-engine-power'] : '';
		var sCurrentBoatEngineAccu = sessionStorage.getItem('current_boat-engine-accu') !== null ? sessionStorage['current_boat-engine-accu'] : '';
		var sCurrentBoatEngineHours = sessionStorage.getItem('current_boat-engine-hours') !== null ? sessionStorage['current_boat-engine-hours'] : '';
		var sCurrentBoatEngineCruisingSpeed = sessionStorage.getItem('current_boat-engine-cruising-speed') !== null ? sessionStorage['current_boat-engine-cruising-speed'] : '';
		var sCurrentBoatEngineTankCapacity = sessionStorage.getItem('current_boat-engine-tank-capacity') !== null ? sessionStorage['current_boat-engine-tank-capacity'] : '';
		var sCurrentBoatEngineFastsailing = sessionStorage.getItem('current_boat-engine-fastsailing') !== null ? sessionStorage['current_boat-engine-fastsailing'] : '';
		
		var sCurrentBoatEngineCylinders = sessionStorage.getItem('current_boat-engine-cylinders') !== null ? sessionStorage['current_boat-engine-cylinders'] : '';
		var sCurrentBoatEngineSize = sessionStorage.getItem('current_boat-engine-size') !== null ? sessionStorage['current_boat-engine-size'] : '';
		var sCurrentBoatEngineDryWeight = sessionStorage.getItem('current_boat-engine-dry-weight') !== null ? sessionStorage['current_boat-engine-dry-weight'] : '';
		
		var sCurrentBoatTrailerBraked = sessionStorage.getItem('current_boattrailer-braked') !== null ? sessionStorage['current_boattrailer-braked'] : '';
		var sCurrentBoatTrailerAxles = sessionStorage.getItem('current_boattrailer-axles') !== null ? sessionStorage['current_boattrailer-axles'] : '';
		var sCurrentBoatTrailerKantelbaar = sessionStorage.getItem('current_boattrailer-kantelbaar') !== null ? sessionStorage['current_boattrailer-kantelbaar'] : '';
		var sCurrentBoatTrailerPlug = sessionStorage.getItem('current_boattrailer-plug') !== null ? sessionStorage['current_boattrailer-plug'] : '';
		
		var sCurrentSalePrice = sessionStorage.getItem('current_sale-price') !== null ? sessionStorage['current_sale-price'] : '';
		var sCurrentFromPrice = sessionStorage.getItem('current_from-price') !== null ? sessionStorage['current_from-price'] : '';
		var sCurrentVat = sessionStorage.getItem('current_vat') !== null ? sessionStorage['current_vat'] : '';
		
		var sCurrentPeriod = sessionStorage.getItem('current_period') !== null ? sessionStorage['current_period'] : '';
		
		var sCurrentMarktplaatsTitle = sessionStorage.getItem('current_marktplaats-title') !== null ? sessionStorage['current_marktplaats-title'] : '';
		var sCurrentMarktplaatsPricetype = sessionStorage.getItem('current_marktplaats-pricetype') !== null ? sessionStorage['current_marktplaats-pricetype'] : '';
		var sCurrentMarktplaatsPrice = sessionStorage.getItem('current_marktplaats-price') !== null ? sessionStorage['current_marktplaats-price'] : '';
		var sCurrentMarktplaatsBidPrice = sessionStorage.getItem('current_marktplaats-bidprice') !== null ? sessionStorage['current_marktplaats-bidprice'] : '';
		var sCurrentMarktplaatsMinimalBidPrice = sessionStorage.getItem('current_marktplaats-minimalbidprice') !== null ? sessionStorage['current_marktplaats-minimalbidprice'] : '';
		var sCurrentMarktplaatsDescription = sessionStorage.getItem('current_marktplaats_description') !== null ? sessionStorage['current_marktplaats_description'] : '';
		
		var sCurrentGroup = sessionStorage.getItem('active_group') !== null ? sessionStorage['active_group'] : '';
		var sCurrentSubGroup = sessionStorage.getItem('active_sub_group') !== null ? sessionStorage['active_sub_group'] : '';
		var sCurrentSubSubGroup = sessionStorage.getItem('active_sub_sub_group') !== null ? sessionStorage['active_sub_sub_group'] : '';
		
		if(sCurrentImages != ''){			
			var aImages = $.parseJSON(sCurrentImages);
			
			if(typeof aImages == 'object'){
				
				var iImages = 1;
				
				jQuery('.image-container').remove();					
				jQuery('.picture-block').removeClass('add-picture').removeClass('add-new-image').removeAttr("style");
				
				jQuery.each(aImages, $.proxy(function(index, item) {
					
					jQuery('#picture-'+iImages).css({'background-image' : 'url('+item+')' });
					jQuery('#picture-'+iImages).removeClass('add-picture').removeClass('add-new-image');
					
					var sImageID = item.replace('/afbeelding/', '');					
					sImageID = sImageID.replace('https://images-develop.ovis.nl', '');
					sImageID = sImageID.replace('.jpg', '');
					
					aImage = sImageID.split("/");					
					
					aImage = aImage.filter(function (el) {
						return el != null && el != "";
					});						
					
					if(typeof aImage[0] != 'undefined'){	
						//if(jQuery('#'+aImage[0]).length < 1){					
						
							var newImage = "<div class=\"image-container\" id=\"" + aImage[0] + "\" data-imgurl=\"" + item + "\" data-phototype=\"productimage\"><div class=\"image-content\" style=\"background-image:url(" + item + ");\" onclick=\"jQuery.editImage(\'" + aImage[0] + "\', \'productImage\');\"></div><span class=\"sort-image\"></span></div>";
												
							jQuery('#images').append(newImage); 
												
						//}
						
						iImages++;
					}
					
				}, this));	
				
				if(jQuery('#picture-'+iImages).length){
					
					//iImages++;
					jQuery('#picture-'+iImages).addClass('add-picture').addClass('add-new-image').addClass('test-add-picture-2');
				}
				
				jQuery('.no-sorting').remove();
				jQuery("#images").append('<div class="image-container no-sorting ui-sortable-handle" id="add-new"><div class="image-content add-picture add-new-image"></div></div>');

			}
		}
		
		if(sCurrentAccessories != ''){
			
			var oAccessoriesData = $.parseJSON(sCurrentAccessories);
			
			if(oAccessoriesData != ''){
				
				jQuery('.accessory-radio').prop("checked",false).button("refresh");
				
				jQuery.each(oAccessoriesData, $.proxy(function(index, item) {						
					jQuery('.accessory-radio[value="'+item+'"]').prop("checked",true).button("refresh");
				}, this));
			}			
		}
		
		if(sCurrentDivisions != ''){
			
			var oDivisionsData = $.parseJSON(sCurrentDivisions);
			
			if(oDivisionsData != ''){
				
				jQuery('.division-radio').prop("checked",false).button("refresh");
				
				jQuery.each(oDivisionsData, $.proxy(function(index, item) {	
					jQuery('.division-radio[value="'+item+'"]').prop("checked",true).button("refresh");
				}, this));
			}			
		}
				
		if(sCurrentCategory != '' || sCurrentStatus != '' || sCurrentArticle != '' || sCurrentPeriod != ''){			
			if(sCurrentStatus != ''){				
				jQuery('#status-container').addClass('active');
				jQuery('#status-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentStatus));
				jQuery(".status-radio[value='" + sCurrentStatus.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
			
			if(sCurrentPeriod != '' && jQuery('#period-container').length){			
				jQuery('#period-container').addClass('active');
				jQuery('#period-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentPeriod) + (sCurrentPeriod == '1' ? ' maand' : ' maanden'));
				jQuery(".period-radio[value='" + sCurrentPeriod.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
			
			if(sCurrentCategory == ''){
				sCurrentCategory = articleCategory;
			}
			
			
			if(sCurrentCategory != ''){
				jQuery('body').addClass('category-'+sCurrentCategory);
				jQuery('body').addClass('category-set');
				
				jQuery('.article-input-group.category').addClass('active');
				
				sCurrentCategoryName = sCurrentCategory;
				
				if(sCurrentCategoryName == 'tenttrailer'){
					sCurrentCategoryName = 'vouwwagen';
				} else if(sCurrentCategoryName == 'mobilehome'){
					sCurrentCategoryName = 'stacaravan';				
				} else if(sCurrentCategoryName == 'boat'){
					sCurrentCategoryName = 'boot';				
				} else if(sCurrentCategoryName == 'boattrailer'){
					sCurrentCategoryName = 'boottrailer';				
				} else if(sCurrentCategoryName == 'engine'){
					sCurrentCategoryName = 'motor';				
				} else if(sCurrentCategoryName == 'trailer'){
					sCurrentCategoryName = 'aanhangwagen';				
				}
				
				jQuery('#category-set-value').html(capitalizeFirstLetterOfString(sCurrentCategoryName));
				
				articleCategory = sCurrentCategory;
				
				jQuery(".category-radio[value='" + sCurrentCategoryName.toLowerCase() + "']").prop('checked', true).button("refresh");	
				
				loadFeatures();
				
				var sCurrentSubGroup = sessionStorage.getItem('active_sub_group') !== null ? sessionStorage['active_sub_group'] : '';
				
				if(sCurrentSubGroup == 'brand-active'){
					getBrands();
				} else if(sCurrentSubGroup == 'model-active'){
					getModels();
				} else if(sCurrentSubGroup == 'version-active'){
					getVersions();
				}
				
			}
				
			if(sCurrentLicense != ''){
				articleLicense  = sCurrentLicense;
				
				jQuery('.article-input-subgroup.license').addClass('active');
				jQuery('#license-set-value').html(capitalizeFirstLetterOfString(articleLicense));
				jQuery('#set-license').val(articleLicense);
			}
			
			if(sCurrentSubCategory != ''){				
				jQuery('#subcategory-container').addClass('active');
				jQuery('#subcategory-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentSubCategory));
				jQuery(".subcategory-radio[value='" + sCurrentSubCategory.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBrand != ''){
				articleBrand  = sCurrentBrand;
				
				jQuery('.article-input-subgroup.brand').addClass('active');
				jQuery('#brand-set-value').html(capitalizeFirstLetterOfString(articleBrand));
				
				getBrands();
			}
				
			if(sCurrentVersion != ''){
				articleVersion  = sCurrentVersion;
				
				jQuery('.article-input-subgroup.version').addClass('active');
				jQuery('#version-set-value').html(capitalizeFirstLetterOfString(articleVersion));

				getVersions();
			}
			
			if(sCurrentDescription != ''){				
				var sCurrentDescriptionClean = (sCurrentDescription);
				
				jQuery('.article-input-subgroup.descriptiontext').addClass('active');
				
				//var ContentSet = tinymce.get("article_description").setContent(sCurrentDescriptionClean);	
				jQuery('#editor_article_description .richText-editor').trigger('setContent', '<div>'+nl2br(sCurrentDescriptionClean)+'</div>');
				//jQuery('#editor_article_description .richText-editor').trigger('setContent', sCurrentDescriptionClean);
			}
				
			if(sCurrentComment != ''){				
				var sCurrentCommentClean = (sCurrentComment);
				
				jQuery('.article-input-subgroup.commenttext').addClass('active');
				
				//var ContentSet = tinymce.get("article_comment").setContent(sCurrentCommentClean);				
				jQuery('#editor_article_comment .richText-editor').trigger('setContent', '<div>'+nl2br(sCurrentCommentClean)+'</div>');
				//jQuery('#editor_article_comment .richText-editor').trigger('setContent', sCurrentCommentClean);
			}
				
			if(sCurrentReference != ''){				
				var sCurrentReferenceClean = (sCurrentReference);
				
				jQuery('.article-input-subgroup.referencetext').addClass('active');
				
				//var ContentSet = tinymce.get("article_reference").setContent(sCurrentReferenceClean);				
				jQuery('#editor_article_reference .richText-editor').trigger('setContent', '<div>'+nl2br(sCurrentReferenceClean)+'</div>');
				//jQuery('#editor_article_reference .richText-editor').trigger('setContent', sCurrentReferenceClean);
			}
				
			if(sCurrentMarktplaatsDescription != ''){				
				var sCurrentMarktplaatsDescriptionClean = (sCurrentMarktplaatsDescription);
				
				jQuery('.article-input-subgroup.description').addClass('active');
				
				//var ContentSet = tinymce.get("marktplaats_description").setContent(sCurrentMarktplaatsDescriptionClean);	
				jQuery('#editor_marktplaats_description .richText-editor').trigger('setContent', '<div>'+nl2br(sCurrentMarktplaatsDescriptionClean)+'</div>');
				//jQuery('#editor_marktplaats_description .richText-editor').trigger('setContent', sCurrentMarktplaatsDescriptionClean);
				
			}
				
			if(sCurrentType != ''){	jQuery("#set-type").val(sCurrentType); }				
			if(sCurrentSleepingplaces != ''){ jQuery("#set-sleepingplaces").val(sCurrentSleepingplaces); }				
			if(sCurrentModelyear != ''){ jQuery("#set-modelyear").val(sCurrentModelyear); }				
			if(sCurrentPartA != ''){ jQuery("#set-part-a").val(sCurrentPartA); }				
			if(sCurrentConstructionyear != ''){	 jQuery("#set-constructionyear").val(sCurrentConstructionyear); }				
			if(sCurrentFirstNL != ''){ jQuery("#set-first-nl").val(sCurrentFirstNL); }				
			if(sCurrentChassisnummer != ''){ jQuery("#set-chassisnummer").val(sCurrentChassisnummer); }				
			if(sCurrentModelBoat != ''){ jQuery("#set-model-boat").val(sCurrentModelBoat); }				
			if(sCurrentLigplaatsBoat != ''){ jQuery("#set-ligplaats-boat").val(sCurrentLigplaatsBoat); }				
			if(sCurrentTitleBoat != ''){ jQuery("#set-title-boat").val(sCurrentTitleBoat); }
			if(sCurrentKipAngle != ''){	jQuery("#set-kip-angle").val(sCurrentKipAngle);	}			
			if(sCurrentConstructionLength != ''){ jQuery("#set-construction-length").val(sCurrentConstructionLength); }
			if(sCurrentContainerLength != ''){ jQuery("#set-container-length").val(sCurrentContainerLength); }
			if(sCurrentTotalLength != ''){ jQuery("#set-total-length").val(sCurrentTotalLength); }
			if(sCurrentTrailerTotalLength != ''){ jQuery("#set-trailer-total-length").val(sCurrentTrailerTotalLength); }
			if(sCurrentDrawbarLength != ''){ jQuery("#set-drawbar-length").val(sCurrentDrawbarLength); }
			if(sCurrentContainerWidth != ''){ jQuery("#set-container-width").val(sCurrentContainerWidth); }
			if(sCurrentWidth != ''){ jQuery("#set-width").val(sCurrentWidth); }
			if(sCurrentTotalWidth != ''){ jQuery("#set-total-width").val(sCurrentTotalWidth); }
			if(sCurrentHeight != ''){ jQuery("#set-height").val(sCurrentHeight); }
			if(sCurrentHeadroom != ''){ jQuery("#set-headroom").val(sCurrentHeadroom); }
			if(sCurrentCirculationsize != ''){ jQuery("#set-circulationsize").val(sCurrentCirculationsize); }
			if(sCurrentLoadingPlatformHeight != ''){ jQuery("#set-loading-platform-height").val(sCurrentLoadingPlatformHeight); }
			if(sCurrentCouplerHeight != ''){ jQuery("#set-coupler-height").val(sCurrentCouplerHeight); }
			if(sCurrentBordersHeight != ''){ jQuery("#set-borders-height").val(sCurrentBordersHeight); }
			if(sCurrentLadderRackHeight != ''){ jQuery("#set-ladder-rack-height").val(sCurrentLadderRackHeight); }
			if(sCurrentTotalHeight != ''){ jQuery("#set-total-height").val(sCurrentTotalHeight); }
			if(sCurrentInternalHeight != ''){ jQuery("#set-internal-height").val(sCurrentInternalHeight); }
			if(sCurrentBasePlateHeight != ''){ jQuery("#set-base-plate-height").val(sCurrentBasePlateHeight); }
			if(sCurrentTireSize != ''){ jQuery("#set-tire-size").val(sCurrentTireSize); }
			if(sCurrentVolume != ''){ jQuery("#set-volume").val(sCurrentVolume); }
			if(sCurrentDepth != ''){ jQuery("#set-depth").val(sCurrentDepth); }
			if(sCurrentVerticalclearance != ''){ jQuery("#set-verticalclearance").val(sCurrentVerticalclearance); }
			if(sCurrentEmptyWeight != ''){ jQuery("#set-empty-weight").val(sCurrentEmptyWeight); }
			if(sCurrentRoadworthyWeight != ''){ jQuery("#set-roadworthy-weight").val(sCurrentRoadworthyWeight); }
			if(sCurrentMaxWeight != ''){ jQuery("#set-max-weight").val(sCurrentMaxWeight); }
			if(sCurrentCapacity != ''){ jQuery("#set-capacity").val(sCurrentCapacity); }				
			if(sCurrentToevoeging != ''){ jQuery("#set-toevoeging").val(sCurrentToevoeging); }	
			if(sCurrentMileage != ''){ jQuery("#set-mileage").val(sCurrentMileage); }
			if(sCurrentCarBrand != ''){ jQuery("#set-car-brand").val(sCurrentCarBrand);	}
			if(sCurrentPower != ''){ jQuery("#set-power").val(sCurrentPower); }		
			
			if(sCurrentColorBoat != ''){ jQuery("#set-color-boat").val(sCurrentColorBoat); }		
			if(sCurrentDeckBoat != ''){ jQuery("#set-deck-boat").val(sCurrentDeckBoat); }		
			if(sCurrentLength != ''){ jQuery("#set-length").val(sCurrentLength); }		
			
			if(sCurrentSalePrice != ''){ jQuery("#sale-price").val(sCurrentSalePrice); }		
			if(sCurrentFromPrice != ''){ jQuery("#from-price").val(sCurrentFromPrice); }			
			
			if(sCurrentMarktplaatsTitle != ''){ jQuery("#marktplaats-title").val(sCurrentMarktplaatsTitle); }	
			if(sCurrentMarktplaatsPrice != ''){ jQuery("#marktplaats-price").val(sCurrentMarktplaatsPrice); }	
			if(sCurrentMarktplaatsBidPrice != ''){ jQuery("#marktplaats-bidprice").val(sCurrentMarktplaatsBidPrice); }	
			if(sCurrentMarktplaatsMinimalBidPrice != ''){ jQuery("#marktplaats-minimalbidprice").val(sCurrentMarktplaatsMinimalBidPrice); }	
			
			//if(sCurrentBoatEngineBrand != ''){ jQuery("#set-boat-engine-brand").val(sCurrentBoatEngineBrand); }		
			if(sCurrentBoatEngineModel != ''){ jQuery("#set-boat-engine-model").val(sCurrentBoatEngineModel); }		
			if(sCurrentBoatEnginePower != ''){ jQuery("#set-boat-engine-power").val(sCurrentBoatEnginePower); }		
			if(sCurrentBoatEngineAccu != ''){ jQuery("#set-boat-engine-accu").val(sCurrentBoatEngineAccu); }		
			if(sCurrentBoatEngineHours != ''){ jQuery("#set-boat-engine-hours").val(sCurrentBoatEngineHours); }		
			if(sCurrentBoatEngineCruisingSpeed != ''){ jQuery("#set-boat-engine-cruising-speed").val(sCurrentBoatEngineCruisingSpeed); }		
			if(sCurrentBoatEngineTankCapacity != ''){ jQuery("#set-boat-engine-tank-capacity").val(sCurrentBoatEngineTankCapacity); }		
			if(sCurrentBoatEngineCylinders != ''){ jQuery("#set-boat-engine-cylinders").val(sCurrentBoatEngineCylinders); }		
			if(sCurrentBoatEngineSize != ''){ jQuery("#set-boat-engine-size").val(sCurrentBoatEngineSize); }		
			if(sCurrentBoatEngineDryWeight != ''){ jQuery("#set-boat-engine-dry-weight").val(sCurrentBoatEnginedryWeight); }	
						
			if(sCurrentEngineTankCapacity != ''){ jQuery("#set-engine-tank-capacity").val(sCurrentEngineTankCapacity); }	
			if(sCurrentEnginePower != ''){ jQuery("#set-engine-power").val(sCurrentEnginePower); }	
			if(sCurrentEngineCylinders != ''){ jQuery("#set-engine-cylinders").val(sCurrentEngineCylinders); }	
			if(sCurrentEngineSize != ''){ jQuery("#set-engine-size").val(sCurrentEngineSize); }	
			if(sCurrentEngineDryWeight != ''){ jQuery("#set-engine-dry-weight").val(sCurrentEngineDryWeight); }	
			
			jQuery.checkConditionAvailability(sCurrentCategory);
				
			if(sCurrentMarktplaatsPricetype != ''){				
				jQuery('#marktplaats-pricetype-container').addClass('active');
				jQuery('#marktplaats-pricetype-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentMarktplaatsPricetype));
				jQuery(".marktplaats-pricetype-radio[value='" + sCurrentMarktplaatsPricetype.toLowerCase() + "']").prop('checked', true).button("refresh");	


				jQuery('.marktplaats-container.price').addClass('hidden-price');			
				jQuery('.marktplaats-container.bidprice').addClass('hidden-price');			
				jQuery('.marktplaats-container.minimalbidprice').addClass('hidden-price');	

				if(sCurrentMarktplaatsPricetype == 'bieden'){
					jQuery('.marktplaats-container.bidprice').removeClass('hidden-price');			
					jQuery('.marktplaats-container.minimalbidprice').removeClass('hidden-price');

				} else if(sCurrentMarktplaatsPricetype == 'vaste prijs'){			
					jQuery('.marktplaats-container.price').removeClass('hidden-price');
				}
			}
			
			if(sCurrentVat != ''){				
				jQuery('#vat-container').addClass('active');
				jQuery('#vat-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentVat));
				jQuery(".vat-radio[value='" + sCurrentVat.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
			
			if(sCurrentCondition != ''){				
				jQuery('#condition-container').addClass('active');
				jQuery('#condition-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentCondition));
				jQuery(".condition-radio[value='" + sCurrentCondition.toLowerCase() + "']").prop('checked', true).button("refresh");
			}
				
			if(sCurrentEngineNumber != ''){				
				jQuery('#engines-boat-container').addClass('active');
				jQuery('#engines-boat-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentEngineNumber) + (sCurrentEngineNumber == '1' ? ' motor' : ' motoren'));
				jQuery(".engines-boat-radio[value='" + sCurrentEngineNumber.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBoatEngineType != ''){				
				jQuery('#boat-engine-type-container').addClass('active');
				jQuery('#boat-engine-type-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBoatEngineType));
				jQuery(".boat-engine-type-radio[value='" + sCurrentBoatEngineType.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBoatEngineStartsystem != ''){				
				jQuery('#boat-engine-startsystem-container').addClass('active');
				jQuery('#boat-engine-startsystem-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBoatEngineStartsystem));
				jQuery(".boat-engine-startsystem-radio[value='" + sCurrentBoatEngineStartsystem.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentEngineStartsystem != ''){				
				jQuery('#engine-startsystem-container').addClass('active');
				jQuery('#engine-startsystem-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentEngineStartsystem));
				jQuery(".engine-startsystem-radio[value='" + sCurrentEngineStartsystem.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentEngineFuel != ''){				
				jQuery('#engine-fuel-container').addClass('active');
				jQuery('#engine-fuel-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentEngineFuel));
				jQuery(".engine-fuel-radio[value='" + sCurrentEngineFuel.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
								
			if(sCurrentEngineTailLength != ''){				
				jQuery('#engine-tail-length-container').addClass('active');
				jQuery('#engine-tail-length-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentEngineTailLength));
				jQuery(".engine-tail-length-radio[value='" + sCurrentEngineTailLength.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
								
			if(sCurrentEngineSteering != ''){				
				jQuery('#engine-steering-container').addClass('active');
				jQuery('#engine-steering-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentEngineSteering));
				jQuery(".engine-steering-radio[value='" + sCurrentEngineSteering.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBoatEngineFuel != ''){				
				jQuery('#boat-engine-fuel-container').addClass('active');
				jQuery('#boat-engine-fuel-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBoatEngineFuel));
				jQuery(".boat-engine-fuel-radio[value='" + sCurrentBoatEngineFuel.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBoatEngineBrand != ''){				
				jQuery('#boat-engine-brand-container').addClass('active');
				jQuery('#boat-engine-brand-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBoatEngineBrand));
				jQuery(".boat-engine-brand-radio[value='" + sCurrentBoatEngineBrand.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentFuel != ''){				
				jQuery('#fuel-container').addClass('active');
				jQuery('#fuel-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentFuel));
				jQuery(".fuel-radio[value='" + sCurrentFuel.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentConstructionmonth != ''){				
				jQuery('#constructionmonth-container').addClass('active');
				jQuery('#constructionmonth-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentConstructionmonth));
				jQuery(".constructionmonth-radio[value='" + sCurrentConstructionmonth.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentTransmission != ''){				
				jQuery('#transmission-container').addClass('active');
				jQuery('#transmission-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentTransmission));
				jQuery(".transmission-radio[value='" + sCurrentTransmission.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentEuroClass != ''){				
				jQuery('#euro-class-container').addClass('active');
				jQuery('#euro-class-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentEuroClass));
				jQuery(".euro-class-radio[value='" + sCurrentEuroClass.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentSeats != ''){				
				jQuery('#seats-container').addClass('active');
				jQuery('#seats-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentSeats) + (sCurrentSeats == '1' ? ' zitplaats' : ' zitplaatsen'));
				jQuery(".seats-radio[value='" + sCurrentSeats.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentPersonsBoat != ''){				
				jQuery('#persons-boat-container').addClass('active');
				jQuery('#persons-boat-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentPersonsBoat) + (sCurrentPersonsBoat == '1' ? ' persoon' : ' personen'));
				jQuery(".persons-boat-radio[value='" + sCurrentPersonsBoat.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentSeatbelts != ''){				
				jQuery('#seatbelts-container').addClass('active');
				jQuery('#seatbelts-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentSeatbelts) + (sCurrentSeatbelts == '1' ? ' gordel' : ' gordels'));
				jQuery(".seatbelts-radio[value='" + sCurrentSeatbelts.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentNumberOfDoors != ''){				
				jQuery('#number-of-doors-container').addClass('active');
				jQuery('#number-of-doors-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentNumberOfDoors) + (sCurrentNumberOfDoors == '1' ? ' deur' : ' deuren'));
				jQuery(".number-of-doors-radio[value='" + sCurrentNumberOfDoors.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentPlug != ''){				
				jQuery('#plug-container').addClass('active');
				jQuery('#plug-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentPlug));
				jQuery(".plug-radio[value='" + sCurrentPlug.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBoatTrailerPlug != ''){				
				jQuery('#boattrailer-plug-container').addClass('active');
				jQuery('#boattrailer-plug-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBoatTrailerPlug));
				jQuery(".boattrailer-plug-radio[value='" + sCurrentBoatTrailerPlug.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentFloorMaterial != ''){				
				jQuery('#floor-material-container').addClass('active');
				jQuery('#floor-material-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentFloorMaterial));
				jQuery(".floor-material-radio[value='" + sCurrentFloorMaterial.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentMaterialBoat != ''){				
				jQuery('#material-boat-container').addClass('active');
				jQuery('#material-boat-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentMaterialBoat));
				jQuery(".material-boat-radio[value='" + sCurrentMaterialBoat.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentSizeBoat != ''){				
				jQuery('#size-boat-container').addClass('active');
				jQuery('#size-boat-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentSizeBoat));
				jQuery(".size-boat-radio[value='" + sCurrentSizeBoat.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentWallMaterial != ''){				
				jQuery('#wall-material-container').addClass('active');
				jQuery('#wall-material-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentWallMaterial));
				jQuery(".wall-material-radio[value='" + sCurrentWallMaterial.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentAxles != ''){				
				jQuery('#axles-container').addClass('active');
				jQuery('#axles-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentAxles) + (sCurrentAxles == '1' ? ' as' : ' assen'));
				jQuery(".axles-radio[value='" + sCurrentAxles.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentDoorTypes != ''){				
				jQuery('#door-types-container').addClass('active');
				jQuery('#door-types-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentDoorTypes));
				jQuery(".door-types-radio[value='" + sCurrentDoorTypes.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentOwners != ''){				
				jQuery('#owners-container').addClass('active');
				jQuery('#owners-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentOwners) + (sCurrentOwners == '1' ? ' eigenaar' : ' eigenaren'));
				jQuery(".owners-radio[value='" + sCurrentOwners.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBedrooms != ''){				
				jQuery('#bedrooms-container').addClass('active');
				jQuery('#bedrooms-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBedrooms) + (sCurrentBedrooms == '1' ? ' slaapkamer' : ' slaapkamers'));
				jQuery(".bedrooms-radio[value='" + sCurrentBedrooms.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBedsBoat != ''){				
				jQuery('#beds-boat-container').addClass('active');
				jQuery('#beds-boat-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBedsBoat) + (sCurrentBedsBoat == '1' ? ' bed' : ' bedden'));
				jQuery(".beds-boat-radio[value='" + sCurrentBedsBoat.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentWalltype != ''){				
				jQuery('#walltype-container').addClass('active');
				jQuery('#walltype-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentWalltype));
				jQuery(".walltype-radio[value='" + sCurrentWalltype.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentMaterial != ''){				
				jQuery('#material-container').addClass('active');
				jQuery('#material-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentMaterial));
				jQuery(".material-radio[value='" + sCurrentMaterial.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentMaterialTentTrailer != ''){				
				jQuery('#-tenttrailer-container').addClass('active');
				jQuery('#-tenttrailer-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentMaterialTentTrailer));
				jQuery(".-tenttrailer-radio[value='" + sCurrentMaterialTentTrailer.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentColor != ''){				
				jQuery('#color-container').addClass('active');
				jQuery('#color-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentColor));
				jQuery(".color-radio[value='" + sCurrentColor.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentColorTrailer != ''){				
				jQuery('#color-trailer-container').addClass('active');
				jQuery('#color-trailer-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentColorTrailer));
				jQuery(".color-trailer-radio[value='" + sCurrentColorTrailer.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBoatTrailerAxles != ''){				
				jQuery('#boattrailer-axles-container').addClass('active');
				jQuery('#boattrailer-axles-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBoatTrailerAxles) + (sCurrentBoatTrailerAxles == '1' ? ' as' : ' assen'));
				jQuery(".boattrailer-axles-radio[value='" + sCurrentBoatTrailerAxles.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
				
			if(sCurrentBoatTrailerPlug != ''){				
				jQuery('#boattrailer-plug-container').addClass('active');
				jQuery('#boattrailer-plug-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(sCurrentBoatTrailerPlug));
				jQuery(".boattrailer-plug-radio[value='" + sCurrentBoatTrailerPlug.toLowerCase() + "']").prop('checked', true).button("refresh");				
			}
			
			if(sCurrentModel != ''){
				articleModel = sCurrentModel;
				
				jQuery('.article-input-subgroup.model').addClass('active');
				jQuery('#model-set-value').html(capitalizeFirstLetterOfString(articleModel));

				getModels();					
				getVersions();					
			}
			
			if(sCurrentBoatEngineFastsailing != ''){				
				if(sCurrentBoatEngineFastsailing == 'boat-engine-fastsailing'){				
					jQuery('#set-boat-engine-fastsailing').prop('checked',true);
				}				
			}
			
			if(sCurrentBoatEngineHasEngine != ''){				
				if(sCurrentBoatEngineHasEngine == 'boat-engine-has-engine'){				
					jQuery('#set-boat-engine-has-engine').prop('checked',true);
				}				
			}
			
			if(sCurrentNap != ''){				
				if(sCurrentNap == 'nap'){				
					jQuery('#set-nap').prop('checked',true);
				}				
			}
			
			if(sCurrentTrailerBoat != ''){				
				if(sCurrentTrailerBoat == 'trailer-boat'){				
					jQuery('#set-trailer-boat').prop('checked',true);
				}				
			}
			
			if(sCurrentMetallic != ''){				
				if(sCurrentMetallic == 'metallic'){				
					jQuery('#set-metallic').prop('checked',true);
				}				
			}
			
			if(sCurrentParticulateFilter != ''){				
				if(sCurrentParticulateFilter == 'particulateFilter'){				
					jQuery('#set-particulateFilter').prop('checked',true);
				}				
			}
			
			if(sCurrentDamaged != ''){				
				if(sCurrentDamaged == 'damaged'){				
					jQuery('#set-damaged').prop('checked',true);
				}				
			}
			
			if(sCurrentHailDamage != ''){				
				if(sCurrentHailDamage == 'hailDamage'){				
					jQuery('#set-hailDamage').prop('checked',true);
				}				
			}
			
			if(sCurrentDemo != ''){				
				if(sCurrentDemo == 'demo'){				
					jQuery('#set-demo').prop('checked',true);
				}				
			}
			
			if(sCurrentExRental != ''){				
				if(sCurrentExRental == 'exRental'){				
					jQuery('#set-exRental').prop('checked',true);
				}				
			}			
			
			if(sCurrentPossibleRental != ''){				
				if(sCurrentPossibleRental == 'possibleRental'){				
					jQuery('#set-possibleRental').prop('checked',true);
				}				
			}
			
			if(sCurrentBoatTrailerKantelbaar != ''){				
				if(sCurrentBoatTrailerKantelbaar == 'boattrailer-kantelbaar'){				
					jQuery('#set-boattrailer-kantelbaar').prop('checked',true);
				}				
			}
			
			if(sCurrentBoatTrailerBraked != ''){				
				if(sCurrentBoatTrailerBraked == 'boattrailer-braked'){				
					jQuery('#set-boattrailer-braked').prop('checked',true);
				}				
			}
			
			if(sCurrentMaintenanceBooklets != ''){				
				if(sCurrentMaintenanceBooklets == 'maintenanceBooklets'){				
					jQuery('#set-maintenanceBooklets').prop('checked',true);
				}				
			}
			
			if(sCurrentSuitableForDisabledPeople != ''){				
				if(sCurrentSuitableForDisabledPeople == 'suitableForDisabledPeople'){				
					jQuery('#set-suitableForDisabledPeople').prop('checked',true);
				}				
			}			
			
			if(sCurrentBeds != ''){
				
				if(sCurrentBeds > 0){
					jQuery('.sleep-container-bed').remove();
				}
				
				for (let i = 1; i <= sCurrentBeds; i++) {
					var iSendBedLength = sessionStorage.getItem('current_bed-length-' + i) !== null ? sessionStorage['current_bed-length-' + i] : '';
					var iSendWidth = sessionStorage.getItem('current_bed-width-' + i) !== null ? sessionStorage['current_bed-width-' + i] : '';
					var iSendType = sessionStorage.getItem('current_bed-type-' + i) !== null ? sessionStorage['current_bed-type-' + i] : '';
					
					var bedHTML = createBedType(i,iSendBedLength,iSendWidth,iSendType);
															
					jQuery('#beds-container').append(bedHTML);
					
					jQuery('#set-bed-type-' + i).select2({
						allowClear: true,
						minimumResultsForSearch: -1,
						width: '100%',
						placeholder: 'Kies bedtype',
						language: "nl",
						dropdownParent: jQuery('#sale-beds-select-container-' + i)
					});
					
					jQuery('#set-bed-type-' + i).on('select2:select', function (e) {
						if(typeof e.params.data.id != 'undefined'  ){
							sessionStorage['current_bed-type-'+i] = e.params.data.id;
						}
					});
					
					jQuery('#set-bed-type-' + i).on('select2:clear', function (e) {			
						jQuery(this).data('unselecting', true);
						sessionStorage.removeItem('current_bed-type-'+i);
					});	

					jQuery('#set-bed-type-' + i).on('select2:opening', function (e) {
						
						 if (jQuery(this).data('unselecting')) {
							jQuery(this).removeData('unselecting');
							e.preventDefault();
						}
					});				 
				}
			}
			
			buildTypeSynopsis();
			buildEnginesSynopsis();
			buildDatesSynopsis();
			buildSizesSynopsis();
			buildSleepSynopsis();			
			
			buildStatusSynopsis();
			buildFeaturesSynopsis();
			buildDescriptionSynopsis();
		} else {		
			sessionStorage.removeItem('current_category');
			sessionStorage.removeItem('active_group');
			sessionStorage.removeItem('active_sub_group');
			sessionStorage.removeItem('active_sub_sub_group');		
		}
		
		getCategories();
		
		setLoadingOverlay('fadeout');
		
	}
	
	setTimeout(function() {
		jQuery.initAddEdit ();
		//do something special
	}, 1000);	
		
	if(jQuery("#set-part-a").length == 1){
		jQuery('#set-part-a').mask('00/00/0000', {placeholder: "__/__/____"});	
	}
	
	if(jQuery("#set-first-nl").length == 1){
		jQuery('#set-first-nl').mask('00/00/0000', {placeholder: "__/__/____"});	
	}	
	
	jQuery.deleteImageQuestion = function (state) {
		if(state == 'open'){			
			jQuery('#popup-confirmation').addClass('question');
			jQuery('#popup-confirmation-title').html('Foto verwijderen');
		} else if(state == 'close'){	
			jQuery('#popup-confirmation').removeClass('question');
			jQuery('#popup-confirmation-title').html('Foto bewerken');
		}
	}	
	
	var doneTypingInterval = 1000;  //time in ms (2 seconds)
	
	var setTypeTimer;	
	jQuery(document).on("keyup blur",".auto-save",function(e) {		
		clearTimeout(setTypeTimer);
		
		var currentName = jQuery(this).attr("name");
		var currentKey = currentName.replace("set-", "");
		var currentValue = jQuery(this).val();
		
		var sEditIndicator = jQuery(this).closest('.add-edit-subgroup').data('groupname');
		sessionStorage['edit_indicator'] = sEditIndicator;	
		
		if (jQuery('#' + currentName).val()) {			
			// bepaal range voor bouwjaar
			if(currentName == 'set-constructionyear'){					
				var inTwoYears = new Date().getFullYear()+2;
				var sinceSeventyYears = new Date().getFullYear()-70;
				
				if(jQuery('#' + currentName).val() > inTwoYears){
					jQuery('#' + currentName).val(inTwoYears);					
				} else if(jQuery('#' + currentName).val().length == 4 && jQuery('#' + currentName).val() < sinceSeventyYears){
					jQuery('#' + currentName).val(sinceSeventyYears);	
				}
			}
			
			// bepaal range voor modeljaar
			if(currentName == 'set-modelyear'){					
				var inTwoYears = new Date().getFullYear()+2;
				var sinceSeventyYears = new Date().getFullYear()-70;
				
				if(jQuery('#' + currentName).val() > inTwoYears){
					jQuery('#' + currentName).val(inTwoYears);					
				} else if(jQuery('#' + currentName).val().length == 4 && jQuery('#' + currentName).val() < sinceSeventyYears){
					jQuery('#' + currentName).val(sinceSeventyYears);	
				}
			}
			
			
			
			if(arguments[0].handleObj.type == 'focusout'){				
				sessionStorage['current_' + currentKey] = $('#' + currentName).val();					
			} else {			
				setTypeTimer = setTimeout(function(){
					sessionStorage['current_' + currentKey] = $('#' + currentName).val();					
				}, doneTypingInterval);
			}
		} else {
			sessionStorage.removeItem('current_' + currentKey);
		}
	});
		
	var oLightboxAddArticle = false;
	
	jQuery.rotateImage = function (imageName) {
		setLoadingOverlay('fadein');		
		oLightboxAddArticle.close();
		
		var sImageUrl = jQuery('#'+imageName).data('imgurl');
		
		$.post(baseHref() + 'article', { 

			module: 'rotateImage',
			image: imageName,
			imageUrl: sImageUrl,
			articleId: articleID
			
		}, function(data) {
			
			var oData = $.parseJSON(data);
			
			if(oData.errors == 'no-rotation-possible'){				
				// doe niks
			} else{
				jQuery('#'+imageName).find('.image-content').css("background-image", "url("+oData.image+")");
				jQuery('#'+imageName).data('imgurl', oData.image);
				
				var sorted = $( "#images" ).sortable( "toArray" );
				
				jQuery('.picture-block.sub-picture').not('.add-picture').css("background-image", "none");

				if(sorted.length){
					var sortedImageID = 1;
					
					$.each( sorted, function( key, value ) {
						
						var sImageUrl = jQuery('#'+value).data('imgurl');
						
						if(typeof sImageUrl != 'undefined'){						
							jQuery('#picture-'+sortedImageID).css("background-image", "url(" + sImageUrl + ")");
						}
						
						sortedImageID++;
						
					});
				}				
			}			
			
			setLoadingOverlay('fadeout');
		});
	}
	
	jQuery.deleteImage = function (imageName) {
	
		setLoadingOverlay('fadein');		
		oLightboxAddArticle.close();
		
		jQuery('#'+imageName).remove();		
		
		var aImageArray = '';
					
		if(jQuery('.image-container').length){
			
			jQuery.each(jQuery('.image-container'), $.proxy(function(index, item) {						
				
				if(typeof jQuery(item).data('imgurl') != 'undefined' && jQuery(item).data('imgurl') != ''){
					
					if(aImageArray == ''){								
						aImageArray = [];
					}
					
					var sImageURLToSave = jQuery(item).data('imgurl');
												
					if(sImageURLToSave.substring(0, 12) == '/afbeelding/'){
						aImageRaw = sImageURLToSave.split("?");
			
						aImageRaw = aImageRaw.filter(function (el) {
							return el != null && el != "";
						});									
						
						if(typeof aImageRaw[0] != 'undefined'){
							sImageURLToSave = aImageRaw[0];
						}							
					}
					
					aImageArray.push(sImageURLToSave);
					
				}							
			}, this));
		} 
		
		if(aImageArray == ''){
			sessionStorage.removeItem('current_images');
		} else {
			
			var icountImage = 1;
			
			jQuery('.picture-block').removeClass('add-new-image').removeClass('add-picture').removeAttr('style');
			
			jQuery.each(aImageArray, $.proxy(function(index, item) {	
			
				jQuery('#picture-'+icountImage).css({'background-image' : 'url(' + item + ')' });
					
				icountImage++;
				
			}, this));

			jQuery('#picture-'+icountImage).addClass('add-new-image').addClass('add-picture').addClass('test-add-picture-1');
			
			sessionStorage['current_images'] = JSON.stringify(aImageArray);					
		}

		var iImagesSet = jQuery('.image-container').length;
				
		if(iImagesSet < 24 && jQuery('.image-container.no-sorting').length == 0){				
			jQuery("#images").append('<div class="image-container no-sorting ui-sortable-handle" id="add-new"><div class="image-content add-picture add-new-image"></div></div>');	
		}
		
		setLoadingOverlay('fadeout');
	}
	
	jQuery.editImage = function (imageName,imageType) {
		
		if(jQuery('#sort-images-status').hasClass('active')){
			return;
		}
		
		var popupcontent = '<div class="popup-confirmation" id="popup-confirmation">';
			popupcontent += '<h2 id="popup-confirmation-title">Foto bewerken</h2>';
			popupcontent += '<span class="title">Weet u het zeker?</span>';
			popupcontent += '<span class="rotate" onclick="jQuery.rotateImage(\''+imageName+'\');">Roteer 90&deg;</span>';
			popupcontent += '<span class="delete" onclick="jQuery.deleteImageQuestion(\'open\');">Verwijder</span>';
			popupcontent += '<span class="sure" onclick="jQuery.deleteImage(\''+imageName+'\');"></span>';
			popupcontent += '<span class="not-sure" onclick="jQuery.deleteImageQuestion(\'close\');"></span>';
		popupcontent += '</div>"';
		
		oLightboxAddArticle = SimpleLightbox.open({

			closeOnOverlayClick: true,
			closeOnEscapeKey: false,
			content: popupcontent

		});
		
	}
	
	jQuery(document).on("click",".open-sub",function(e) {	
		var groupToOpen = jQuery(this).data('group');
		var fieldToOpen = jQuery(this).data('field');
		var titleToOpen = capitalizeFirstLetterOfString(jQuery(this).data('title'));
		
		if(fieldToOpen == 'condition'){
			var currentCategory = jQuery('input[name="set-category"]:checked').val();			
			
			jQuery.checkConditionAvailability(currentCategory);
		}
		
		jQuery('#title-container').html(titleToOpen);		
		jQuery('.'+groupToOpen+'-container').addClass('has-open-sub');			
		jQuery(this).closest('.'+groupToOpen+'-container').removeClass('has-open-sub').addClass('active-sub-container');		
		jQuery('#sub-'+fieldToOpen).addClass('active');				
		jQuery('body').addClass('sub-active');
		
		if(fieldToOpen == 'period'){
			jQuery('.status-group').addClass('hidden');
		}
		
		sessionStorage['active_sub_sub_group'] = fieldToOpen;
		
	});
	
	jQuery(document).on("click",".direct-to",function(e) {		
				
		if(jQuery(this).hasClass('category')){
			
			jQuery('body').removeClass('brand-active');
			jQuery('body').removeClass('accessories-active');
			jQuery('body').removeClass('features-active');
			jQuery('body').removeClass('has-active-sub');
			jQuery('body').addClass('category-active');
			
			sessionStorage['active_sub_group'] = 'category-active';
			
			var sTitleToSet = 'Categorie';		

			jQuery('#title-container').html(sTitleToSet);			
			
			jQuery('.notice-container').remove();
			
			setLoadingOverlay('fadein');
			
			getCategories();
			
		} else if(jQuery(this).hasClass('brand')){
			
			jQuery('body').removeClass('model-active');
			jQuery('body').removeClass('version-active');
			jQuery('body').addClass('features-active');
			jQuery('body').addClass('has-active-sub');
			jQuery('body').addClass('brand-active');
			sessionStorage['active_sub_group'] = 'brand-active';
			
			var sTitleToSet = 'Merk';		

			jQuery('#title-container').html(sTitleToSet);	

			jQuery('.notice-container').remove();
			
			setLoadingOverlay('fadein');
			
			getBrands();
			
		} else if(jQuery(this).hasClass('model')){
			
			jQuery('body').removeClass('model-active');
			jQuery('body').removeClass('version-active');
			jQuery('body').addClass('features-active');
			jQuery('body').addClass('has-active-sub');
			jQuery('body').addClass('model-active');
			sessionStorage['active_sub_group'] = 'model-active';
			
			var sTitleToSet = 'Model';		

			jQuery('#title-container').html(sTitleToSet);

			jQuery('.notice-container').remove();
			
			setLoadingOverlay('fadein');
			
			getModels();
			
		}	
	});	
	
	function loadFeatures(){
		
		if(jQuery('body').hasClass('category-set')){
			if(jQuery('#feature-category-missing').length){
				jQuery('#feature-category-missing').remove();
			}
			
			var aArticleEnginesSynopsis = !articleEnginesSynopsis ? '' : articleEnginesSynopsis;				
			var aArticleBrand = !articleBrand ? '' : articleBrand;				
			var aArticleModel = !articleModel ? '' : articleModel;
			var aArticleVersion = !articleVersion ? '' : articleVersion;
			var aArticleTypeSynopsis = !articleTypeSynopsis ? '' : articleTypeSynopsis;
			var aArticleAccessoriesSynopsis = !articleAccessoriesSynopsis ? '' : articleAccessoriesSynopsis;
			var aArticleDivisionsSynopsis = !articleDivisionsSynopsis ? '' : articleDivisionsSynopsis;
			var aArticleDatesSynopsis = !articleDatesSynopsis ? '' : articleDatesSynopsis;
			var aArticleBedsSynopsis = !articleBedsSynopsis ? '' : articleBedsSynopsis;
			var aArticleSizesSynopsis = !articleSizesSynopsis ? '' : articleSizesSynopsis;
			var aArticleLicense = !articleLicense ? '' : articleLicense;
			var aArticleType = !articleType ? '' : articleType;
			var aArticleSuffix = !articleSuffix ? '' : articleSuffix;
			
			var verifyLicense = '';
			var verifyType = '';
			var verifySuffix = '';
			var verifyBrand = '';
			var verifyModel = '';
			var verifyVersion = '';
			var verifyEngines = '';
			var verifyType = '';
			var verifyAccessories = '';
			var verifyDivisions = '';
			var verifyDates = '';
			var verifySizes = '';
			var verifyBeds = '';
			
			if(articleLicenseCheck != ''){
				aArticleLicense = articleLicenseCheck;				
				verifyLicense = ' verify';
			}
			if(articleTypeCheck != ''){
				aArticleType = articleTypeCheck;				
				verifyType = ' verify';
			}
			if(articleSuffixCheck != ''){
				aArticleSuffix = articleSuffixCheck;				
				verifySuffix = ' verify';
			}
			if(articleBrandCheck != ''){
				aArticleBrand = articleBrandCheck;				
				verifyBrand = ' verify';
			}
			if(articleModelCheck != ''){
				aArticleModel = articleModelCheck;
				verifyModel = ' verify';
			}
			if(articleVersionCheck != ''){
				aArticleVersion = articleVersionCheck;
				verifyVersion = ' verify';
			}
			if(articleTypeCheck != ''){
				aArticleTypeSynopsis = articleTypeCheck;
				verifyType = ' verify';
			}
			if(articleAccessoriesCheck != ''){
				aArticleAccessoriesSynopsis = articleAccessoriesCheck;
				verifyAccessories = ' verify';
			}
			if(articleDivisionsCheck != ''){
				aArticleDivisionsSynopsis = articleDivisionsCheck;
				verifyDivisions = ' verify';
			}
			if(articleDatesCheck != ''){
				aArticleDatesSynopsis = articleDatesCheck;
				verifyDates = ' verify';
			}
			if(articleSizesCheck != ''){
				aArticleSizesSynopsis = articleSizesCheck;
				verifySizes = ' verify';
			}	
			if(articleBedsCheck != ''){
				aArticleBedsSynopsis = articleBedsCheck;
				verifyBeds = ' verify';
			}			
			
			var sFeaturesHTML = '';	

			//sFeaturesHTML += '<div class="article-input-subgroup license' + (aArticleLicense != '' ? ' active' : '') + '" data-group="license">Kenteken<span id="license-set-value" class="set-value' + verifyLicense + '">' + (aArticleLicense != '' ? aArticleLicense : '') + '</span></div>';
			

			if(aArticleLicense == ''){
				aArticleLicense = sessionStorage.getItem('current_license') !== null ? sessionStorage['current_license'] : '';
			}
			
			if(aArticleType == ''){
				aArticleType = sessionStorage.getItem('current_type') !== null ? sessionStorage['current_type'] : '';
			}
			
			if(aArticleSuffix == ''){
				aArticleSuffix = sessionStorage.getItem('current_toevoeging') !== null ? sessionStorage['current_toevoeging'] : '';
			}
						
			sFeaturesHTML += '<section class="add-edit-subgroup license' + (aArticleLicense != '' ? ' active' : '') + '" data-group="license">';
				sFeaturesHTML += '<div class="article-form">';			
					sFeaturesHTML += '<div class="license-container" id="license-container">';			
						sFeaturesHTML += '<div class="license" id="set-license-container">';
							sFeaturesHTML += '<label>Kenteken</label>';
							sFeaturesHTML += '<input autocomplete="false" class="text-input auto-save" type="text" name="set-license" size="10" maxlength="10" id="set-license" value="'+ aArticleLicense +'">';	
						sFeaturesHTML += '</div>';
						sFeaturesHTML += '<div class="get-license-container" id="get-license-container">';
							sFeaturesHTML += '<button class="load-license-data" data-currentlicense="' + aArticleLicense + '" id="load-license-data">' + (articleRealm == 'boat' ? 'Data ophalen' : 'Kentekendata ophalen') + '</button>';			
						sFeaturesHTML += '</div>';
						sFeaturesHTML += '<div class="autofill-response-container" id="autofill-response-container"></div>';
					sFeaturesHTML += '</div>';
				sFeaturesHTML += '</div>';
			sFeaturesHTML += '</section>';	
			
			sFeaturesHTML += '<div class="article-input-subgroup brand' + (aArticleBrand != '' ? ' active' : '') + '" data-group="brand">Merk<span id="brand-set-value" class="set-value' + verifyBrand + '">' + (aArticleBrand != '' ? aArticleBrand : '') + '</span></div>';				
			sFeaturesHTML += '<div class="article-input-subgroup model' + (aArticleModel != '' ? ' active' : '') + '" data-group="model">Model<span id="model-set-value" class="set-value' + verifyModel + '">' + (aArticleModel != '' ? aArticleModel : '') + '</span></div>';
			
			if(jQuery('body').hasClass('isn-debug')){
				sFeaturesHTML += '<div class="article-input-subgroup version' + (aArticleVersion != '' ? ' active' : '') + '" data-group="version">Uitvoering<span id="version-set-value" class="set-value' + verifyVersion + '">' + (aArticleVersion != '' ? aArticleVersion : '') + '</span></div>';
			} else {
						
				sFeaturesHTML += '<section class="add-edit-subgroup type no-margin' + (aArticleType != '' ? ' active' : '') + '" data-group="type">';
					sFeaturesHTML += '<div class="article-form">';			
						sFeaturesHTML += '<div class="type-container" id="type-container">';			
							sFeaturesHTML += '<div class="type" id="set-type-container">';
								sFeaturesHTML += '<label>Uitvoering</label>';
								sFeaturesHTML += '<input autocomplete="false" class="text-input auto-save" type="text" name="set-type" size="10" maxlength="10" id="set-type" value="'+ aArticleType +'">';	
							sFeaturesHTML += '</div>';						
						sFeaturesHTML += '</div>';
					sFeaturesHTML += '</div>';
				sFeaturesHTML += '</section>';
				
			}			
			
			sFeaturesHTML += '<section class="add-edit-subgroup toevoeging no-margin' + (aArticleSuffix != '' ? ' active' : '') + '" data-group="toevoeging">';
				sFeaturesHTML += '<div class="article-form">';			
					sFeaturesHTML += '<div class="toevoeging-container" id="toevoeging-container">';			
						sFeaturesHTML += '<div class="toevoeging" id="set-toevoeging-container">';
							sFeaturesHTML += '<label>Titel toevoeging</label>';
							sFeaturesHTML += '<input autocomplete="false" class="text-input auto-save" type="text" name="set-toevoeging" size="10" maxlength="25" id="set-toevoeging" value="'+ aArticleSuffix +'">';	
						sFeaturesHTML += '</div>';						
					sFeaturesHTML += '</div>';
				sFeaturesHTML += '</div>';
			sFeaturesHTML += '</section>';	

			sReturnActiveElement = sessionStorage.getItem('edit_indicator') !== null ? sessionStorage['edit_indicator'] : '';
			
			var iInitalType = sReturnActiveElement == 'type' ? ' active' : ''; //sessionStorage.getItem('edit_indicator_type') !== null ? '' : ' initial';
			var iInitalAccessories = sReturnActiveElement == 'accessories' ? ' active' : ''; //sessionStorage.getItem('edit_indicator_accessories') !== null ? '' : ' initial'; 
			var iInitalDivisions = sReturnActiveElement == 'divisions' ? ' active' : ''; //sessionStorage.getItem('edit_indicator_divisions') !== null ? '' : ' initial';
			var iInitalEngines = sReturnActiveElement == 'engines' ? ' active' : ''; //sessionStorage.getItem('edit_indicator_engines') !== null ? '' : ' initial';
			var iInitalDates = sReturnActiveElement == 'dates' ? ' active' : ''; //sessionStorage.getItem('edit_indicator_dates') !== null ? '' : ' initial';
			var iInitalSizes = sReturnActiveElement == 'sizes' ? ' active' : ''; //sessionStorage.getItem('edit_indicator_sizes') !== null ? '' : ' initial';
			var iInitalSleep = sReturnActiveElement == 'sleep' ? ' active' : ''; //sessionStorage.getItem('edit_indicator_sleep') !== null ? '' : ' initial';
			
			sFeaturesHTML += '<div class="article-input-subgroup type' + (aArticleTypeSynopsis != '' || iInitalType != '' ? ' active' : '') + '" data-group="type"><span class="active-indicator"></span>Specificaties<span id="type-set-value" class="set-value' + verifyType + '"></span></div>';
			sFeaturesHTML += '<div class="article-input-subgroup engines' + (aArticleEnginesSynopsis != '' || iInitalEngines != '' ? ' active' : '') + '" data-group="engines"><span class="active-indicator"></span>Motoren<span id="engines-set-value" class="set-value' + verifyEngines + '"></span></div>';
			sFeaturesHTML += '<div class="article-input-subgroup accessories' + (aArticleAccessoriesSynopsis != '' || iInitalAccessories != '' ? ' active' : '') + '" data-group="accessories"><span class="active-indicator"></span>Accessoires<span id="accessories-set-value" class="set-value' + verifyAccessories + '"></span></div>';
			sFeaturesHTML += '<div class="article-input-subgroup divisions' + (aArticleDivisionsSynopsis != '' || iInitalDivisions != '' ? ' active' : '') + '" data-group="divisions"><span class="active-indicator"></span>Indelingen<span id="divisions-set-value" class="set-value' + verifyDivisions + '"></span></div>';
			sFeaturesHTML += '<div class="article-input-subgroup dates' + (aArticleDatesSynopsis != '' || iInitalDates != '' ? ' active' : '') + '" data-group="dates"><span class="active-indicator"></span>Data en jaartallen<span id="dates-set-value" class="set-value' + verifyDates + '"></span></div>';
			sFeaturesHTML += '<div class="article-input-subgroup sizes' + (aArticleSizesSynopsis != '' || iInitalSizes != '' ? ' active' : '') + '" data-group="sizes"><span class="active-indicator"></span>Maten en gewichten<span id="sizes-set-value" class="set-value' + verifySizes + '"></span></div>';			
			sFeaturesHTML += '<div class="article-input-subgroup sleep' + (aArticleBedsSynopsis != '' || iInitalSleep != '' ? ' active' : '') + '" data-group="sleep"><span class="active-indicator"></span>Slapen<span id="sleep-set-value" class="set-value' + verifyBeds + '"></span></div>';
			
			jQuery('.add-edit-group.features .article-form').html(sFeaturesHTML);
			
			parseSubCategories();
			
		} else { 			
			
			jQuery('.add-edit-group.features .article-form').html('<div class="notice-container" id="feature-category-missing"><div class="notice">Kies eerst een categorie om vervolgens kenmerken te kunnen invoeren.</div><div class="direct-to category">Klik hier om een categorie te selecteren</div></div>');
		}
		
	}
	
	jQuery(document).on("click",".article-input-group-fixed",function(e) {
		var popupNotEditableContent = '<div class="concept-confirmation" id="concept-confirmation">';
			popupNotEditableContent += '<h2 id="concept-confirmation-title">Categorie niet aanpasbaar</h2>';
			popupNotEditableContent += '<span class="title">U kunt de categorie niet aanpassen voor een reeds ingevoerde advertentie.</span>';					
			popupNotEditableContent += '<span class="continue" onclick="jQuery.acceptMessage();">Ga verder</span>';
		popupNotEditableContent += '</div>"';

		oLightboxNotEditableArticle = SimpleLightbox.open({
			closeOnOverlayClick: false,
			closeOnEscapeKey: false,
			content: popupNotEditableContent,
			beforeClose: function(){
				setLoadingOverlay('fadeout');						
			}
		});	
	});
	
	jQuery(document).on("click",".open-sub-fixed",function(e) {
		var popupNotEditableContent = '<div class="concept-confirmation" id="concept-confirmation">';
			popupNotEditableContent += '<h2 id="concept-confirmation-title">Conditie niet aanpasbaar</h2>';
			popupNotEditableContent += '<span class="title">U kunt de conditie niet aanpassen voor een reeds ingevoerde advertentie.</span>';					
			popupNotEditableContent += '<span class="continue" onclick="jQuery.acceptMessage();">Ga verder</span>';
		popupNotEditableContent += '</div>"';

		oLightboxNotEditableArticle = SimpleLightbox.open({
			closeOnOverlayClick: false,
			closeOnEscapeKey: false,
			content: popupNotEditableContent,
			beforeClose: function(){
				setLoadingOverlay('fadeout');						
			}
		});	
	});
	
	jQuery(document).on("click",".article-input-group",function(e) {
		
		var elementToOpen = jQuery(this).data('group');
		
		jQuery('body').removeClass('photos-active');
		jQuery('body').removeClass('category-active');
		jQuery('body').removeClass('features-active');
		jQuery('body').removeClass('description-active');
		jQuery('body').removeClass('prices-active');
		jQuery('body').removeClass('status-active');
		jQuery('body').removeClass('marktplaats-active');
		
		var sTitleToSet = 'Advertentie aanmaken';
		
		if(articleID != ''){			
			sTitleToSet = 'Advertentie bewerken';
		}		
		
		if(elementToOpen == 'photos'){			
			sTitleToSet = 'Foto\'s';			
		} else if(elementToOpen == 'category'){
			sTitleToSet = 'Categorie';
		} else if(elementToOpen == 'features'){
			sTitleToSet = 'Kenmerken';
		} else if(elementToOpen == 'description'){
			sTitleToSet = 'Beschrijving';
		} else if(elementToOpen == 'prices'){
			sTitleToSet = 'Prijzen';
		} else if(elementToOpen == 'status'){
			sTitleToSet = 'Status';
		} else if(elementToOpen == 'marktplaats'){
			sTitleToSet = 'Marktplaats';
		} else if(elementToOpen == 'preview'){
			sTitleToSet = 'Preview';
			
			parsePreview('preview-active');
			
		}

		if(elementToOpen == 'category'){
			
			getCategories();
			
		} else if(elementToOpen == 'features'){
			
			loadFeatures();				
						
		}

		jQuery('#title-container').html(sTitleToSet);
				
		if(elementToOpen != '' && elementToOpen != 'undefined'){
			jQuery('body').addClass(elementToOpen + '-active');	
			jQuery('body').addClass('group-active');	
			
			sessionStorage['active_group'] = elementToOpen + '-active';
			
		}

		jQuery('body, html').animate({
			
			scrollTop: 0
			
		}, 1);
		
	});	
	
	jQuery.updateBedCache = function(){
		
		var iBedId = 1;

		for (let i = 1; i <= 10; i++) {
			sessionStorage.removeItem('current_bed-length-' + i);
			sessionStorage.removeItem('current_bed-width-' + i);
			sessionStorage.removeItem('current_bed-type-' + i);
		}
		
		jQuery.each(jQuery('.sleep-container-bed'), $.proxy(function(index, item) {			
			
			var iCurrentBedId = jQuery(item).data('bedid');
			var sCurrentBedLength = jQuery('#set-bed-length-'+iCurrentBedId).val() != '' ? jQuery('#set-bed-length-'+iCurrentBedId).val() : '';
			var sCurrentBedWidth = jQuery('#set-bed-width-'+iCurrentBedId).val() != '' ? jQuery('#set-bed-width-'+iCurrentBedId).val() : '';
			var sCurrentBedType = jQuery('#set-bed-type-'+iCurrentBedId).val() != '' ? jQuery('#set-bed-type-'+iCurrentBedId).val() : '';
			
			sessionStorage['current_bed-width-'+iBedId] = sCurrentBedWidth;
			sessionStorage['current_bed-length-'+iBedId] = sCurrentBedLength;
			sessionStorage['current_bed-type-'+iBedId] = sCurrentBedType;			

			iBedId++;
			
		}, this));
		
		var sCurrentBeds = sessionStorage.getItem('current_beds') !== null ? sessionStorage['current_beds'] : '';
		
		if(sCurrentBeds != ''){
			
			if(sCurrentBeds > 0){
				jQuery('.sleep-container-bed').remove();
			}
			
			for (let i = 1; i <= sCurrentBeds; i++) {
				var iSendBedLength = sessionStorage.getItem('current_bed-length-' + i) !== null ? sessionStorage['current_bed-length-' + i] : '';
				var iSendWidth = sessionStorage.getItem('current_bed-width-' + i) !== null ? sessionStorage['current_bed-width-' + i] : '';
				var iSendType = sessionStorage.getItem('current_bed-type-' + i) !== null ? sessionStorage['current_bed-type-' + i] : '';
				
				var bedHTML = createBedType(i,iSendBedLength,iSendWidth,iSendType);
														
				jQuery('#beds-container').append(bedHTML);
				
				
				
				jQuery('#set-bed-type-' + i).select2({
					allowClear: true,
					minimumResultsForSearch: -1,
					width: '100%',
					placeholder: 'Kies bedtype',
					language: "nl",
					dropdownParent: jQuery('#sale-beds-select-container-' + i)
				});
				
				jQuery('#set-bed-type-' + i).on('select2:select', function (e) {
					if(typeof e.params.data.id != 'undefined'  ){
						sessionStorage['current_bed-type-'+i] = e.params.data.id;
					}
				});
				
				jQuery('#set-bed-type-' + i).on('select2:clear', function (e) {			
					jQuery(this).data('unselecting', true);
					sessionStorage.removeItem('current_bed-type-'+i);
				});	

				jQuery('#set-bed-type-' + i).on('select2:opening', function (e) {
					
					 if (jQuery(this).data('unselecting')) {
						jQuery(this).removeData('unselecting');
						e.preventDefault();
					}
				});				 
			}
		}		
	}	
	
	jQuery.removeBed = function(removeBed, iBedId){	
	
		if(removeBed == 'remove'){
			if(typeof iBedId != 'undefined' && iBedId > 0){
				sessionStorage.removeItem('current_bed-length-' + iBedId);
				sessionStorage.removeItem('current_bed-width-' + iBedId);
				sessionStorage.removeItem('current_bed-type-' + iBedId);
					
				jQuery('.sleep-container-' + iBedId).remove();
				
				var iNumberOfBeds = jQuery('.sleep-container-bed').length;
				
				if(iNumberOfBeds > 0){
					sessionStorage['current_beds'] = iNumberOfBeds;
				} else {
					sessionStorage.removeItem('current_beds');
				}
				
				jQuery.updateBedCache();
			}
			
			oLightboxRemoveBedArticle.close();
			
		} else {
			
			oLightboxRemoveBedArticle.close();
			
		}
	}	
	
	jQuery(document).on("click",".remove-bed",function(e) {		
		
		var iBedId = jQuery(this).data('bedid');
		
		if(typeof iBedId != 'undefined' && iBedId > 0){			
			
			var popupRemoveBedContent = '<div class="concept-confirmation" id="concept-confirmation">';
				popupRemoveBedContent += '<h2 id="concept-confirmation-title">Bed verwijderen</h2>';
				popupRemoveBedContent += '<span class="title">Weet u zeker dat u dit bed wilt verwijderen?</span>';					
				popupRemoveBedContent += '<span class="sure" onclick="jQuery.removeBed(\'remove\',\''+iBedId+'\');"></span>';
				popupRemoveBedContent += '<span class="not-sure" onclick="jQuery.removeBed(\'cancel\');"></span>';
			popupRemoveBedContent += '</div>"';
	
			oLightboxRemoveBedArticle = SimpleLightbox.open({
				closeOnOverlayClick: false,
				closeOnEscapeKey: false,
				content: popupRemoveBedContent,
				beforeClose: function(){
					setLoadingOverlay('fadeout');						
				}
			});			
		}
	});
	
	jQuery(document).on("click",".article-input-subgroup",function(e) {
		
		var elementToOpen = jQuery(this).data('group');
		
		jQuery('body').removeClass('license-active');
		jQuery('body').removeClass('brand-active');
		jQuery('body').removeClass('model-active');
		jQuery('body').removeClass('version-active');
		jQuery('body').removeClass('type-active');
		jQuery('body').removeClass('size-active');
		jQuery('body').removeClass('accessories-active');
		jQuery('body').removeClass('divisions-active');
		jQuery('body').removeClass('dates-active');
		jQuery('body').removeClass('sizes-active');
		jQuery('body').removeClass('sleep-active');
		jQuery('body').removeClass('marktplaatsdescription-active');
		
		var sTitleToSet = 'Advertentie aanmaken';
		
		if(articleID != ''){			
			sTitleToSet = 'Advertentie bewerken';
		}
		
		if(elementToOpen == 'license'){			
			sTitleToSet = 'Kenteken';
		} else if(elementToOpen == 'brand'){			
			sTitleToSet = 'Merk';
		} else if(elementToOpen == 'engines'){			
			sTitleToSet = 'Motoren';
		} else if(elementToOpen == 'model'){
			sTitleToSet = 'Model';
		} else if(elementToOpen == 'version'){
			sTitleToSet = 'Version';
		} else if(elementToOpen == 'type'){
			sTitleToSet = 'Specificaties';
		} else if(elementToOpen == 'size'){
			sTitleToSet = 'Afmetingen';
		} else if(elementToOpen == 'accessories'){
			sTitleToSet = 'Accessoires';
		} else if(elementToOpen == 'divisions'){
			sTitleToSet = 'Indelingen';
		} else if(elementToOpen == 'dates'){
			sTitleToSet = 'Data en jaartallen';
		} else if(elementToOpen == 'sizes'){
			sTitleToSet = 'Maten en gewichten';
		} else if(elementToOpen == 'sleep'){
			sTitleToSet = 'Slapen';
		} else if(elementToOpen == 'marktplaatsdescription'){
			sTitleToSet = 'Marktplaats omschrijving';
		} else if(elementToOpen == 'omschrijving'){
			sTitleToSet = 'Omschrijving';
		} else if(elementToOpen == 'comments'){
			sTitleToSet = 'Opmerkingen';
		} else if(elementToOpen == 'reference'){
			sTitleToSet = 'Referentie';
		}	

		jQuery('#title-container').html(sTitleToSet);
		
		if(elementToOpen == 'brand'){	
			
			setLoadingOverlay('fadein');
			getBrands();
		}		
		
		if(elementToOpen == 'model'){	
			
			setLoadingOverlay('fadein');
			
			getModels();
		}		
		
		if(elementToOpen == 'version'){	
			
			setLoadingOverlay('fadein');
			
			getVersions();
		}		
		
		if(elementToOpen == 'accessories'){	
			
			setLoadingOverlay('fadein');
			
			getAccessories();
		}		
		
		if(elementToOpen == 'divisions'){	
			
			setLoadingOverlay('fadein');
			
			getDivisions();
		}		
				
		if(elementToOpen != '' && elementToOpen != 'undefined'){
			jQuery('body').addClass(elementToOpen + '-active');	
			jQuery('body').addClass('has-active-sub');	
			
			sessionStorage['active_sub_group'] = elementToOpen + '-active';
		} else {
			
			sessionStorage.removeItem('active_sub_group');
			
		}

		jQuery('body, html').animate({
			
			scrollTop: 0
			
		}, 1);
		
	});	
	
	jQuery(document).on("click",".pictures-container",function(e) {
		
		var elementToOpen = 'photos';
		
		jQuery('body').removeClass('photos-active');
		jQuery('body').removeClass('category-active');
		jQuery('body').removeClass('features-active');
		jQuery('body').removeClass('description-active');
		jQuery('body').removeClass('prices-active');
		jQuery('body').removeClass('marktplaats-active');
		jQuery('body').removeClass('status-active');
		
		var sTitleToSet = 'Foto\'s';
		
		jQuery('#title-container').html(sTitleToSet);

		getPhotoLabels();
		
		if(elementToOpen != '' && elementToOpen != 'undefined'){
			jQuery('body').addClass(elementToOpen + '-active');	
		}
	});		
	
	jQuery( "input.category-radio" ).checkboxradio({
      icon: false
    });	
	
	jQuery(document).on("change","input.division-radio",function(e) {
				
		if(jQuery(this).hasClass('single-mode')){
			
			var dataIdentifier = jQuery(this).data('single');
			var currentId = jQuery(this).prop('id');
			var currentStatus = jQuery(this).prop('checked');
						
			if(dataIdentifier != '' && dataIdentifier != 'undefined'){
			
				jQuery.each(jQuery('.single-' + dataIdentifier), $.proxy(function(index, item) {
					jQuery(item).prop('checked', false).button( "refresh" );												
				}, this));			
			}
			
			if(!currentStatus){	
				jQuery('#'+currentId).prop('checked', false).button( "refresh" );	
			} else {
				jQuery('#'+currentId).prop('checked', true).button( "refresh" );	
			}
			
		}
		
		jQuery('.notice-container').remove();
	});
	
	jQuery(document).on("change","input.category-radio",function(e) {
		
		var sReturnCategory = jQuery('input[name="set-category"]:checked').val();
		
		if(sReturnCategory == ''){
			sReturnCategory = jQuery('input[name="set-category"]:checked').val();			
		}
		
		articleCategory = sReturnCategory;
		
		jQuery('.notice-container').remove();
		
		jQuery('.add-edit-subgroup.brand .article-form').html('');
		jQuery('.add-edit-subgroup.model .article-form').html('');
		jQuery('.add-edit-subgroup.version .article-form').html('');
		jQuery('.add-edit-subgroup.accessories .article-form').html('');
		
		if(jQuery('.article-input-group.features').hasClass('active')){
			jQuery('#features-set-value').html('Controleren, categorie wijziging').addClass('verify');			
		}
		
		if(jQuery('.article-input-subgroup.brand').hasClass('active')){
			articleBrand = '';	
			articleBrandCheck = 'Controleren';	
			jQuery('#brand-set-value').html('');
			sessionStorage.removeItem('current_brand');	
		}		
		
		if(jQuery('.article-input-subgroup.model').hasClass('active')){
			articleModel = '';		
			articleModelCheck = 'Controleren';		
			jQuery('#model-set-value').html('Controleren');
			sessionStorage.removeItem('current_model');	
		}		
		
		if(jQuery('.article-input-subgroup.version').hasClass('active')){
			articleVersion = '';		
			articleVersionCheck = 'Controleren';		
			jQuery('#version-set-value').html('Controleren');
			sessionStorage.removeItem('current_version');	
		}
		
		if(jQuery('.article-input-subgroup.accessories').hasClass('active')){
			articleAccessoriesSynopsis = '';		
			articleAccessoriesCheck = 'Controleren';		
			jQuery('#accessories-set-value').html('Controleren');
			sessionStorage.removeItem('current_accessories');	
		}				
		
		if(jQuery('.article-input-subgroup.divisions').hasClass('active')){
			articleDivisionsSynopsis = '';
			articleDivisionsCheck = 'Controleren';			
			jQuery('#divisions-set-value').html('Controleren');
			sessionStorage.removeItem('current_accessories');	
		}				
		
		if(jQuery('.article-input-subgroup.type').hasClass('active')){
			articleTypeSynopsis = '';
			articleTypeCheck = 'Controleren';			
			jQuery('#type-set-value').html('Controleren');
		}				
		
		if(sReturnCategory != ''){	

			jQuery('body').removeClass('category-caravan');
			jQuery('body').removeClass('category-camper');
			jQuery('body').removeClass('category-tenttrailer');
			jQuery('body').removeClass('category-mobilehome');
			jQuery('body').removeClass('category-boat');
			jQuery('body').removeClass('category-boattrailer');
			jQuery('body').removeClass('category-engine');
			jQuery('body').removeClass('category-trailer');
			jQuery('body').removeClass('category-set');
			
			var categoryClassToAdd = sReturnCategory.toLowerCase();
			
			if(categoryClassToAdd == 'vouwwagen'){
				categoryClassToAdd = 'tenttrailer';
			} else if(categoryClassToAdd == 'stacaravan'){
				categoryClassToAdd = 'mobilehome';				
			} else if(categoryClassToAdd == 'boot'){
				categoryClassToAdd = 'boat';				
			} else if(categoryClassToAdd == 'boottrailer'){
				categoryClassToAdd = 'boattrailer';				
			} else if(categoryClassToAdd == 'motor'){
				categoryClassToAdd = 'engine';				
			} else if(categoryClassToAdd == 'aanhangwagen'){
				categoryClassToAdd = 'trailer';				
			}			
			
			jQuery('body').addClass('category-' + categoryClassToAdd);
			jQuery('body').addClass('category-set');
		
			jQuery('.article-input-group.category').addClass('active');
			jQuery('#category-set-value').html(capitalizeFirstLetterOfString(sReturnCategory));
			
			sessionStorage['current_category'] = categoryClassToAdd;
			
			
		} else {
			jQuery('.article-input-group.category').removeClass('active');
			jQuery('#category-set-value').html('');
			
			sessionStorage.removeItem('current_category');

			jQuery('body').removeClass('category-caravan');
			jQuery('body').removeClass('category-camper');
			jQuery('body').removeClass('category-tenttrailer');
			jQuery('body').removeClass('category-mobilehome');
			jQuery('body').removeClass('category-boat');
			jQuery('body').removeClass('category-boattrailer');
			jQuery('body').removeClass('category-engine');
			jQuery('body').removeClass('category-trailer');
			jQuery('body').removeClass('category-set');
		}
		
		var sTitleToSet = 'Advertentie aanmaken';
				
		if(articleID != ''){			
			sTitleToSet = 'Advertentie bewerken';
		}
		
		jQuery('#title-container').html(sTitleToSet);
		
		parseCategories();
		
		setLoadingOverlay('fadeout');
		
		jQuery('body').removeClass('category-active');
		
	});	
	
	jQuery(document).on("keyup","#set-license",function(e) {
				
		var sInitVal = jQuery('#load-license-data').data('currentlicense');
		var sCurrentVal = jQuery(this).val().toUpperCase();
		var not = sCurrentVal.match(/[^a-zA-Z0-9-]+/g);

		jQuery('#load-license-data').removeClass('active');
		jQuery('#autofill-response-container').removeClass('error').removeClass('succes');
		
		if (not) {
			not.forEach(function(text) {
				sCurrentVal = sCurrentVal.replace(text, "");
			});			
		}
		
		jQuery('#set-license').val(sCurrentVal);
		
		var sLicenseToCheck = sCurrentVal.replace(/\-/g, ' ');
		
		if(sLicenseToCheck.length >= 6){
			if(sInitVal != sLicenseToCheck){
				jQuery('#get-license-container').addClass('active');			
				jQuery('#load-license-data').addClass('active');			
			}
		}		
	});	
	
	function createBedType(iBedCount,iBedLength,iBedWidth,iBedType){
		
		if(typeof iBedLength == 'undefined'){
			iBedLength = '';
		}
		
		if(typeof iBedWidth == 'undefined'){
			iBedWidth = '';
		}
		
		if(typeof iBedType == 'undefined'){
			iBedType = '';
		}
		
		var bedHTML = '<div class="sleep-container sleep-container-bed sleep-container-' + iBedCount + '" data-bedid="' + iBedCount + '" id="sleep-container">'+			
			'<div class="sleep bed-container" id="sale-beds-container">'+
				'<label class="bed-title">Bed specificaties<span class="remove-bed" data-bedid="' + iBedCount + '">Verwijder</span></label>'+
				'<div class="bed-line">'+
				'<label for="set-bed-length-' + iBedCount + '">Lengte (cm)</label>'+
				'<input autocomplete="false" class="text-input bed-length auto-save" type="tel" name="set-bed-length-' + iBedCount + '" inputmode="numeric" maxlength="3" id="set-bed-length-' + iBedCount + '" value="'+iBedLength+'">'+
				'</div>'+
				'<div class="bed-line">'+
				'<label for="set-bed-width-' + iBedCount + '">Breedte (cm)</label>'+
				'<input autocomplete="false" class="text-input bed-width auto-save" type="tel" name="set-bed-width-' + iBedCount + '" inputmode="numeric" maxlength="3" id="set-bed-width-' + iBedCount + '" value="'+iBedWidth+'">'+
				'</div>'+
				//'<label>Bed type</label>'+
				'<div class="bed-select-container" id="sale-beds-select-container-' + iBedCount + '">'+
					'<select class="set-bed-type bed-length" name="set-bed-type-' + iBedCount + '" id="set-bed-type-' + iBedCount + '">'+		
						'<option value="">Kies een bedtype</option>'+		
						'<option' + (iBedType == '1-persoonsbed' ? ' selected="selected"' : '') + ' value="1-persoonsbed">Eenpersoonsbed</option>'+		
						'<option' + (iBedType == '2-persoonsbed' ? ' selected="selected"' : '') + ' value="2-persoonsbed">Tweepersoonsbed</option>'+		
						'<option' + (iBedType == 'losse bedden' ? ' selected="selected"' : '') + ' value="losse bedden">Losse bedden</option>'+		
						'<option' + (iBedType == 'stapelbed' ? ' selected="selected"' : '') + ' value="stapelbed">Stapelbed</option>'+		
						'<option' + (iBedType == 'frans bed' ? ' selected="selected"' : '') + ' value="frans bed">Frans bed</option>'+		
					'</select>'+		
				'</div>'+
			'</div>'+
		'</div>';
		
		return bedHTML;
	}
	
	jQuery.resumeData = function(action){		
		if(action == 'resume'){			
			jQuery('#get-license-container').removeClass('active');
			jQuery('#load-license-data').removeClass('active');
			
			sessionStorage['licensedata_loaded'] = true;
			
			oLightboxLoadContentArticle.close();			
			jQuery.loadData();			
		} else if(action == 'cancel') {
			
			sessionStorage.removeItem('licensedata_loaded');
			
			jQuery('#load-license-data').removeClass('active');
			oLightboxLoadContentArticle.close();		
			setLoadingOverlay('fadeout');			
		}		
	}
	
	jQuery(document).on("click","#load-license-data",function(e) {
		
		var popupLoadDataContent = '<div class="concept-confirmation" id="concept-confirmation">';
			popupLoadDataContent += '<h2 id="concept-confirmation-title">Data ophalen</h2>';
			popupLoadDataContent += '<span class="title">Wilt u data ophalen?<br>Gevonden data zal de reeds ingevoerde gegevens overschrijven.</span>';					
			popupLoadDataContent += '<span class="sure" onclick="jQuery.resumeData(\'resume\');"></span>';
			popupLoadDataContent += '<span class="not-sure" onclick="jQuery.resumeData(\'cancel\');"></span>';
		popupLoadDataContent += '</div>"';

		oLightboxLoadContentArticle = SimpleLightbox.open({
			closeOnOverlayClick: false,
			closeOnEscapeKey: false,
			content: popupLoadDataContent,
			beforeClose: function(){
				setLoadingOverlay('fadeout');						
			}
		});
		
	});	
	
	jQuery.parsePrefilledData = function (oData,bTemplate) {	
	
		// Parse all synopsis fields			
		articleLicense = oData.license;
		if(typeof articleLicense != 'undefined' && articleLicense != ''){		
			jQuery('.article-input-subgroup.license').addClass('active');
			jQuery('#license-set-value').html(articleLicense);
		} else {
			if(bTemplate == false){	
				jQuery('.article-input-group.license').removeClass('active');
				jQuery('#license-set-value').html('');	
			}			
		}
		
		articleBrand = oData.brand;
		if(typeof articleBrand != 'undefined' && articleBrand != ''){		
			jQuery('.article-input-subgroup.brand').addClass('active');
			jQuery('#brand-set-value').html(capitalizeFirstLetterOfString(articleBrand));
		} else {
			
			if(bTemplate == false){			
				jQuery('.article-input-subgroup.brand').removeClass('active');
				jQuery('#brand-set-value').html('');
			}			
		}
		
		articleModel = oData.model;
		if(typeof articleModel != 'undefined' && articleModel != ''){		
			jQuery('.article-input-subgroup.model').addClass('active');
			jQuery('#model-set-value').html(capitalizeFirstLetterOfString(articleModel));
		} else {
			if(bTemplate == false){	
				jQuery('.article-input-group.model').removeClass('active');
				jQuery('#model-set-value').html('');	
			}			
		}
					
		articleVersion = oData.version;
		if(typeof articleVersion != 'undefined' && articleVersion != ''){		
			jQuery('.article-input-subgroup.version').addClass('active');
			jQuery('#version-set-value').html(capitalizeFirstLetterOfString(articleVersion));
		} else {
			if(bTemplate == false){	
				jQuery('.article-input-group.version').removeClass('active');
				jQuery('#version-set-value').html('');
			}			
		}
		
		articleTypeSynopsis = oData.typeSynopsis;
		if(typeof articleTypeSynopsis != 'undefined' && articleTypeSynopsis != ''){		
			jQuery('.article-input-subgroup.type').addClass('active');
			//jQuery('#type-set-value').html(capitalizeFirstLetterOfString(articleTypeSynopsis));
		} else {
			jQuery('.article-input-group.type').removeClass('active');
			//jQuery('#type-set-value').html('');			
		}			
	
		articleAccessoriesSynopsis = oData.accessoriesSynopsis;
		if(typeof articleAccessoriesSynopsis != 'undefined' && articleAccessoriesSynopsis != ''){		
			jQuery('.article-input-subgroup.accessories').addClass('active');
			//jQuery('#accessories-set-value').html(capitalizeFirstLetterOfString(articleAccessoriesSynopsis));
		} else {
			jQuery('.article-input-group.accessories').removeClass('active');
			//jQuery('#accessories-set-value').html('');			
		}
		
		articleDivisionsSynopsis = oData.divisionsSynopsis;
		if(typeof articleDivisionsSynopsis != 'undefined' && articleDivisionsSynopsis != ''){		
			jQuery('.article-input-subgroup.divisions').addClass('active');
			//jQuery('#divisions-set-value').html(capitalizeFirstLetterOfString(articleDivisionsSynopsis));
		} else {
			jQuery('.article-input-group.divisions').removeClass('active');
			//jQuery('#divisions-set-value').html('');			
		}
		
		articleDatesSynopsis = oData.datesSynopsis;
		if(typeof articleDatesSynopsis != 'undefined' && articleDatesSynopsis != ''){		
			jQuery('.article-input-subgroup.dates').addClass('active');
			//jQuery('#dates-set-value').html(capitalizeFirstLetterOfString(articleDatesSynopsis));
		} else {
			jQuery('.article-input-group.dates').removeClass('active');
			//jQuery('#dates-set-value').html('');			
		}
		
		articleSizesSynopsis = oData.sizesSynopsis;
		if(typeof articleSizesSynopsis != 'undefined' && articleSizesSynopsis != ''){		
			jQuery('.article-input-subgroup.sizes').addClass('active');
			//jQuery('#sizes-set-value').html(capitalizeFirstLetterOfString(articleSizesSynopsis));
		} else {
			jQuery('.article-input-group.sizes').removeClass('active');
			//jQuery('#sizes-set-value').html('');			
		}
		
		articleBedsSynopsis = oData.bedsSynopsis;
		if(typeof articleBedsSynopsis != 'undefined' && articleBedsSynopsis != ''){		
			jQuery('.article-input-subgroup.sleep').addClass('active');
			//jQuery('#sleep-set-value').html(capitalizeFirstLetterOfString(articleBedsSynopsis));
		} else {
			jQuery('.article-input-group.sleep').removeClass('active');
			//jQuery('#sleep-set-value').html('');			
		}
		
		articleAccessories = oData.accessoriesList;
		articleDivisions = oData.divisionsList;
		
		// parse all article fields
		
		if(typeof oData.version != 'undefined' && oData.version != false && oData.version != 'false'){			
			
			if(jQuery('#set-type').length > 0){					
				jQuery('#set-type').val(oData.version);					
			}
		} else {
			if(jQuery('#set-type').length > 0){	
				jQuery('#set-type').val('');
			}
		}
		
		if(typeof oData.titleSuffix != 'undefined' && oData.titleSuffix != false && oData.titleSuffix != 'false'){			
			jQuery('#set-toevoeging').val(oData.titleSuffix);
		} else {
			jQuery('#set-toevoeging').val('');
		}
		
		if(typeof oData.ligplaatsBoat != 'undefined' && oData.ligplaatsBoat != false && oData.ligplaatsBoat != 'false'){			
			jQuery('#set-ligplaats-boat').val(oData.ligplaatsBoat);
		} else {
			jQuery('#set-ligplaats-boat').val('');
		}
		
		if(typeof oData.modelBoat != 'undefined' && oData.modelBoat != false && oData.modelBoat != 'false'){			
			jQuery('#set-model-boat').val(oData.modelBoat);
		} else {
			jQuery('#set-model-boat').val('');
		}
		
		if(typeof oData.titleBoat != 'undefined' && oData.titleBoat != false && oData.titleBoat != 'false'){			
			jQuery('#set-title-boat').val(oData.titleBoat);
		} else {
			jQuery('#set-title-boat').val('');
		}
		
		if(typeof oData.chassisNumber != 'undefined' && oData.chassisNumber != false && oData.chassisNumber != 'false'){			
			jQuery('#set-chassisnummer').val(oData.chassisNumber);
		} else {
			jQuery('#set-chassisnummer').val('');
		}
		
		if(typeof oData.kipAngle != 'undefined' && oData.kipAngle != false && oData.kipAngle != 'false'){			
			jQuery('#set-kip-angle').val(oData.kipAngle);
		} else {
			jQuery('#set-kip-angle').val('');
		}				
		
		if(typeof oData.mileage != 'undefined' && oData.mileage != false && oData.mileage != 'false'){			
			jQuery('#set-mileage').val(oData.mileage);
		} else {
			jQuery('#set-mileage').val('');
		}
		
		if(typeof oData.carBrand != 'undefined' && oData.carBrand != false && oData.carBrand != 'false'){			
			jQuery('#set-car-brand').val(oData.carBrand);
		} else {
			jQuery('#set-car-brand').val('');
		}
		
		//if(typeof oData.boatEngineBrand != 'undefined' && oData.boatEngineBrand != false && oData.boatEngineBrand != 'false'){			
		//	jQuery('#set-boat-engine-brand').val(oData.boatEngineBrand);
		//} else {
		//	jQuery('#set-boat-engine-brand').val('');
		//}
		
		if(typeof oData.boatEngineModel != 'undefined' && oData.boatEngineModel != false && oData.boatEngineModel != 'false'){			
			jQuery('#set-boat-engine-model').val(oData.boatEngineModel);
		} else {
			jQuery('#set-boat-engine-model').val('');
		}
		
		if(typeof oData.boatEnginePower != 'undefined' && oData.boatEnginePower != false && oData.boatEnginePower != 'false'){			
			jQuery('#set-boat-engine-power').val(oData.boatEnginePower);
		} else {
			jQuery('#set-boat-engine-power').val('');
		}
		
		if(typeof oData.boatEngineDryWeight != 'undefined' && oData.boatEngineDryWeight != false && oData.boatEngineDryWeight != 'false'){			
			jQuery('#set-boat-engine-dry-weight').val(oData.boatEngineDryWeight);
		} else {
			jQuery('#set-boat-engine-dry-weight').val('');
		}
		
		if(typeof oData.boatEngineSize != 'undefined' && oData.boatEngineSize != false && oData.boatEngineSize != 'false'){			
			jQuery('#set-boat-engine-size').val(oData.boatEngineSize);
		} else {
			jQuery('#set-boat-engine-size').val('');
		}
		
		if(typeof oData.boatEngineCylinders != 'undefined' && oData.boatEngineCylinders != false && oData.boatEngineCylinders != 'false'){			
			jQuery('#set-boat-engine-cylinders').val(oData.boatEngineCylinders);
		} else {
			jQuery('#set-boat-engine-cylinders').val('');
		}
		
		if(typeof oData.boatEngineAccu != 'undefined' && oData.boatEngineAccu != false && oData.boatEngineAccu != 'false'){			
			jQuery('#set-boat-engine-accu').val(oData.boatEngineAccu);
		} else {
			jQuery('#set-boat-engine-accu').val('');
		}
		
		if(typeof oData.boatEngineHours != 'undefined' && oData.boatEngineHours != false && oData.boatEngineHours != 'false'){			
			jQuery('#set-boat-engine-hours').val(oData.boatEngineHours);
		} else {
			jQuery('#set-boat-engine-hours').val('');
		}
		
		if(typeof oData.boatEngineCruisingSpeed != 'undefined' && oData.boatEngineCruisingSpeed != false && oData.boatEngineCruisingSpeed != 'false'){			
			jQuery('#set-boat-engine-cruising-speed').val(oData.boatEngineCruisingSpeed);
		} else {
			jQuery('#set-boat-engine-cruising-speed').val('');
		}
		
		if(typeof oData.boatEngineTankCapacity != 'undefined' && oData.boatEngineTankCapacity != false && oData.boatEngineTankCapacity != 'false'){			
			jQuery('#set-boat-engine-tank-capacity').val(oData.boatEngineTankCapacity);
		} else {
			jQuery('#set-boat-engine-tank-capacity').val('');
		}
		
		if(typeof oData.engineHorsePower != 'undefined' && oData.engineHorsePower != false && oData.engineHorsePower != 'false'){			
			jQuery('#set-power').val(oData.engineHorsePower);
		} else {
			jQuery('#set-power').val('');
		}
		
		if(typeof oData.modelyear != 'undefined' && oData.modelyear != false && oData.modelyear != 'false'){			
			jQuery('#set-modelyear').val(oData.modelyear);
		} else {
			jQuery('#set-modelyear').val('');
		}
		
		if(typeof oData.datePart1a != 'undefined' && oData.datePart1a != false && oData.datePart1a != 'false'){			
			jQuery('#set-part-a').val(oData.datePart1a);
		} else {
			jQuery('#set-part-a').val('');
		}
		
		if(typeof oData.dateArrival != 'undefined' && oData.dateArrival != false && oData.dateArrival != 'false'){			
			jQuery('#set-first-nl').val(oData.dateArrival);
		} else {
			jQuery('#set-first-nl').val('');
		}
		
		
		if(typeof oData.lengthConstruction != 'undefined' && oData.lengthConstruction != false && oData.lengthConstruction != 'false'){			
			jQuery('#set-construction-length').val(oData.lengthConstruction);
		} else {
			jQuery('#set-construction-length').val('');
		}
				
		if(typeof oData.lengthTotalTrailer != 'undefined' && oData.lengthTotalTrailer != false && oData.lengthTotalTrailer != 'false'){			
			jQuery('#set-trailer-total-length').val(oData.lengthTotalTrailer);
		} else {
			jQuery('#set-trailer-total-length').val('');
		}
				
		if(typeof oData.lengthTotal != 'undefined' && oData.lengthTotal != false && oData.lengthTotal != 'false'){			
			jQuery('#set-total-length').val(oData.lengthTotal);
		} else {
			jQuery('#set-total-length').val('');
		}
		
		if(typeof oData.width != 'undefined' && oData.width != false && oData.width != 'false'){			
			jQuery('#set-width').val(oData.width);
		} else {
			jQuery('#set-width').val('');
		}
		
		if(typeof oData.height != 'undefined' && oData.height != false && oData.height != 'false'){			
			jQuery('#set-height').val(oData.height);
		} else {
			jQuery('#set-height').val('');
		}
		
		if(typeof oData.headroom != 'undefined' && oData.headroom != false && oData.headroom != 'false'){			
			jQuery('#set-headroom').val(oData.headroom);
		} else {
			jQuery('#set-headroom').val('');
		}
		
		if(typeof oData.circulationSize != 'undefined' && oData.circulationSize != false && oData.circulationSize != 'false'){			
			jQuery('#set-circulationsize').val(oData.circulationSize);
		} else {
			jQuery('#set-circulationsize').val('');
		}
		
		if(typeof oData.weightEmpty != 'undefined' && oData.weightEmpty != false && oData.weightEmpty != 'false'){			
			jQuery('#set-empty-weight').val(oData.weightEmpty);
		} else {
			jQuery('#set-empty-weight').val('');
		}
		
		if(typeof oData.weightOperational != 'undefined' && oData.weightOperational != false && oData.weightOperational != 'false'){			
			jQuery('#set-roadworthy-weight').val(oData.weightOperational);
		} else {
			jQuery('#set-roadworthy-weight').val('');
		}
		
		if(typeof oData.weightMaximum != 'undefined' && oData.weightMaximum != false && oData.weightMaximum != 'false'){			
			jQuery('#set-max-weight').val(oData.weightMaximum);
		} else {
			jQuery('#set-max-weight').val('');
		}
		
		if(typeof oData.capacity != 'undefined' && oData.capacity != false && oData.capacity != 'false'){			
			jQuery('#set-capacity').val(oData.capacity);
		} else {
			jQuery('#set-capacity').val('');
		}
		
		if(typeof oData.lengthContainer != 'undefined' && oData.lengthContainer != false && oData.lengthContainer != 'false'){			
			jQuery('#set-container-length').val(oData.lengthContainer);
		} else {
			jQuery('#set-container-length').val('');
		}
		
		if(typeof oData.lengthDrawbar != 'undefined' && oData.lengthDrawbar != false && oData.lengthDrawbar != 'false'){			
			jQuery('#set-drawbar-length').val(oData.lengthDrawbar);
		} else {
			jQuery('#set-drawbar-length').val('');
		}
		
		if(typeof oData.widthTotal != 'undefined' && oData.widthTotal != false && oData.widthTotal != 'false'){			
			jQuery('#set-total-width').val(oData.widthTotal);
		} else {
			jQuery('#set-total-width').val('');
		}
		
		if(typeof oData.widthContainer != 'undefined' && oData.widthContainer != false && oData.widthContainer != 'false'){			
			jQuery('#set-container-width').val(oData.widthContainer);
		} else {
			jQuery('#set-container-width').val('');
		}
		
		if(typeof oData.heightLoadingPlatform != 'undefined' && oData.heightLoadingPlatform != false && oData.heightLoadingPlatform != 'false'){			
			jQuery('#set-loading-platform-height').val(oData.heightLoadingPlatform);
		} else {
			jQuery('#set-loading-platform-height').val('');
		}
		
		if(typeof oData.heightCoupler != 'undefined' && oData.heightCoupler != false && oData.heightCoupler != 'false'){			
			jQuery('#set-coupler-height').val(oData.heightCoupler);
		} else {
			jQuery('#set-coupler-height').val('');
		}
		
		if(typeof oData.heightLadderRack != 'undefined' && oData.heightLadderRack != false && oData.heightLadderRack != 'false'){			
			jQuery('#set-ladder-rack-height').val(oData.heightLadderRack);
		} else {
			jQuery('#set-ladder-rack-height').val('');
		}
		
		if(typeof oData.heightBorders != 'undefined' && oData.heightBorders != false && oData.heightBorders != 'false'){			
			jQuery('#set-borders-height').val(oData.heightBorders);
		} else {
			jQuery('#set-borders-height').val('');
		}
		
		if(typeof oData.heightTotal != 'undefined' && oData.heightTotal != false && oData.heightTotal != 'false'){			
			jQuery('#set-total-height').val(oData.heightTotal);
		} else {
			jQuery('#set-total-height').val('');
		}
		
		if(typeof oData.heightBasePlate != 'undefined' && oData.heightBasePlate != false && oData.heightBasePlate != 'false'){			
			jQuery('#set-base-plate-height').val(oData.heightBasePlate);
		} else {
			jQuery('#set-base-plate-height').val('');
		}
		
		if(typeof oData.heightInternal != 'undefined' && oData.heightInternal != false && oData.heightInternal != 'false'){			
			jQuery('#set-internal-height').val(oData.heightInternal);
		} else {
			jQuery('#set-internal-height').val('');
		}
		
		if(typeof oData.tireSize != 'undefined' && oData.tireSize != false && oData.tireSize != 'false'){			
			jQuery('#set-tire-size').val(oData.tireSize);
		} else {
			jQuery('#set-tire-size').val('');
		}
		
		if(typeof oData.volume != 'undefined' && oData.volume != false && oData.volume != 'false'){			
			jQuery('#set-volume').val(oData.volume);
		} else {
			jQuery('#set-volume').val('');
		}
		
		if(typeof oData.depth != 'undefined' && oData.depth != false && oData.depth != 'false'){			
			jQuery('#set-depth').val(oData.depth);
		} else {
			jQuery('#set-depth').val('');
		}
		
		if(typeof oData.verticalclearance != 'undefined' && oData.verticalclearance != false && oData.verticalclearance != 'false'){			
			jQuery('#set-verticalclearance').val(oData.verticalclearance);
		} else {
			jQuery('#set-verticalclearance').val('');
		}
		
		if(typeof oData.NAP != 'undefined' && oData.NAP != false && oData.NAP != 'false'){		
			jQuery('#set-nap').prop('checked', true);			
		} else {
			jQuery('#set-nap').prop('checked', false);	
		}
		
		if(typeof oData.trailerBoat != 'undefined' && oData.trailerBoat != false && oData.trailerBoat != 'false'){		
			jQuery('#set-trailer-boat').prop('checked', true);			
		} else {
			jQuery('#set-trailer-boat').prop('checked', false);	
		}
		
		if(typeof oData.particulateFilter != 'undefined' && oData.particulateFilter != false && oData.particulateFilter != 'false'){		
			jQuery('#set-particulateFilter').prop('checked', true);			
		} else {
			jQuery('#set-particulateFilter').prop('checked', false);	
		}
		
		if(typeof oData.hailDamage != 'undefined' && oData.hailDamage != false && oData.hailDamage != 'false'){		
			jQuery('#set-hailDamage').prop('checked', true);			
		} else {
			jQuery('#set-hailDamage').prop('checked', false);	
		}
		
		if(typeof oData.damage != 'undefined' && oData.damage != false && oData.damage != 'false'){		
			jQuery('#set-damage').prop('checked', true);			
		} else {
			jQuery('#set-damage').prop('checked', false);	
		}
		
		if(typeof oData.demo != 'undefined' && oData.demo != false && oData.demo != 'false'){		
			jQuery('#set-demo').prop('checked', true);			
		} else {
			jQuery('#set-demo').prop('checked', false);	
		}
		
		if(typeof oData.exRental != 'undefined' && oData.exRental != false && oData.exRental != 'false'){		
			jQuery('#set-exRental').prop('checked', true);			
		} else {
			jQuery('#set-exRental').prop('checked', false);	
		}
	
		if(typeof oData.possibbleRental != 'undefined' && oData.possibbleRental != false && oData.possibleRental != 'false'){		
			jQuery('#set-possibleRental').prop('checked', true);			
		} else {
			jQuery('#set-possibleRental').prop('checked', false);	
		}
		
		if(typeof oData.suitableForDisabledPeople != 'undefined' && oData.suitableForDisabledPeople != false && oData.suitableForDisabledPeople != 'false'){		
			jQuery('#set-suitableForDisabledPeople').prop('checked', true);			
		} else {
			jQuery('#set-suitableForDisabledPeople').prop('checked', false);	
		}
		
		if(typeof oData.maintenanceBooklets != 'undefined' && oData.maintenanceBooklets != false && oData.maintenanceBooklets != 'false'){		
			jQuery('#set-maintenanceBooklets').prop('checked', true);			
		} else {
			jQuery('#set-maintenanceBooklets').prop('checked', false);	
		}
		
		if(typeof oData.metallic != 'undefined' && oData.metallic != false && oData.metallic != 'false'){		
			jQuery('#set-metallic').prop('checked', true);			
		} else {
			jQuery('#set-metallic').prop('checked', false);	
		}
		
		if(typeof oData.boatEngineFastSailing != 'undefined' && oData.boatEngineFastSailing != false && oData.boatEngineFastSailing != 'false'){		
			jQuery('#set-boat-engine-fastsailing').prop('checked', true);			
		} else {
			jQuery('#set-boat-engine-fastsailing').prop('checked', false);	
		}
		
		if(typeof oData.boatEngineHasEngine != 'undefined' && oData.boatEngineHasEngine != false && oData.boatEngineHasEngine != 'false'){		
			jQuery('#set-boat-engine-has-engine').prop('checked', true);			
		} else {
			jQuery('#set-boat-engine-has-engine').prop('checked', false);	
		}
		
		if(typeof oData.boatEngineFuel != 'undefined' && oData.boatEngineFuel != false && oData.boatEngineFuel != 'false'){		
			jQuery('#open-sub-boat-engine-fuel').addClass('active');			
			jQuery('#open-sub-boat-engine-fuel').html(oData.boatEngineFuel);			
			
			jQuery('.boat-engine-fuel-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-boat-engine-fuel-'+oData.boatEngineFuel.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-boat-engine-fuel').removeClass('active');			
			jQuery('#open-sub-boat-engine-fuel').html(jQuery('#open-sub-boat-engine-fuel').data('default'));			
			jQuery('.boat-engine-fuel-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.boatEngineBrand != 'undefined' && oData.boatEngineBrand != false && oData.boatEngineBrand != 'false'){		
			jQuery('#open-sub-boat-engine-brand').addClass('active');			
			jQuery('#open-sub-boat-engine-brand').html(oData.boatEngineBrand);			
			
			jQuery('.boat-engine-brand-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-boat-engine-brand-'+oData.boatEngineBrand.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-boat-engine-brand').removeClass('active');			
			jQuery('#open-sub-boat-engine-brand').html(jQuery('#open-sub-boat-engine-brand').data('default'));			
			jQuery('.boat-engine-brand-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.engineFuel != 'undefined' && oData.engineFuel != false && oData.engineFuel != 'false'){		
			jQuery('#open-sub-engine-fuel').addClass('active');			
			jQuery('#open-sub-engine-fuel').html(oData.engineFuel);			
			
			jQuery('.engine-fuel-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-engine-fuel-'+oData.engineFuel.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-engine-fuel').removeClass('active');			
			jQuery('#open-sub-engine-fuel').html(jQuery('#open-sub-engine-fuel').data('default'));			
			jQuery('.engine-fuel-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.fuel != 'undefined' && oData.fuel != false && oData.fuel != 'false'){		
			jQuery('#open-sub-fuel').addClass('active');			
			jQuery('#open-sub-fuel').html(oData.fuel);			
			
			jQuery('.fuel-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-fuel-'+oData.fuel.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-fuel').removeClass('active');			
			jQuery('#open-sub-fuel').html(jQuery('#open-sub-fuel').data('default'));			
			jQuery('.fuel-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.numberOfEngines != 'undefined' && oData.numberOfEngines != false && oData.numberOfEngines != 'false'){		
			jQuery('#open-sub-engines-boat').addClass('active');			
			jQuery('#open-sub-engines-boat').html(oData.numberOfEngines);			
			
			jQuery('.engines-boat-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-engines-boat-'+oData.numberOfEngines.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-engines-boat').removeClass('active');			
			jQuery('#open-sub-engines-boat').html(jQuery('#open-sub-engines-boat').data('default'));			
			jQuery('.engines-boat-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.boatEngineType != 'undefined' && oData.boatEngineType != false && oData.boatEngineType != 'false'){		
			jQuery('#open-sub-boat-engine-type').addClass('active');			
			jQuery('#open-sub-boat-engine-type').html(oData.boatEngineType);			
			
			jQuery('.boat-engine-type-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-boat-engine-type-'+oData.boatEngineType.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-boat-engine-type').removeClass('active');			
			jQuery('#open-sub-boat-engine-type').html(jQuery('#open-sub-boat-engine-type').data('default'));			
			jQuery('.boat-engine-type-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.boatEngineStartsystem != 'undefined' && oData.boatEngineStartsystem != false && oData.boatEngineStartsystem != 'false'){		
			jQuery('#open-sub-boat-engine-startsystem').addClass('active');			
			jQuery('#open-sub-boat-engine-startsystem').html(oData.boatEngineStartsystem);			
			
			jQuery('.boat-engine-startsystem-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-boat-engine-startsystem-'+oData.boatEngineStartsystem.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-boat-engine-startsystem').removeClass('active');			
			jQuery('#open-sub-boat-engine-startsystem').html(jQuery('#open-sub-boat-engine-startsystem').data('default'));			
			jQuery('.boat-engine-startsystem-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.engineStartsystem != 'undefined' && oData.engineStartsystem != false && oData.engineStartsystem != 'false'){		
			jQuery('#open-sub-engine-startsystem').addClass('active');			
			jQuery('#open-sub-engine-startsystem').html(oData.engineStartsystem);			
			
			jQuery('.engine-startsystem-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-engine-startsystem-'+oData.engineStartsystem.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-engine-startsystem').removeClass('active');			
			jQuery('#open-sub-engine-startsystem').html(jQuery('#open-sub-engine-startsystem').data('default'));			
			jQuery('.engine-startsystem-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.transmission != 'undefined' && oData.transmission != false && oData.transmission != 'false'){		
			jQuery('#open-sub-transmission').addClass('active');			
			jQuery('#open-sub-transmission').html(oData.transmission);			
			
			jQuery('.transmission-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-transmission-'+oData.transmission.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-transmission').removeClass('active');			
			jQuery('#open-sub-transmission').html(jQuery('#open-sub-transmission').data('default'));			
			jQuery('.transmission-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.euroClass != 'undefined' && oData.euroClass != false && oData.euroClass != 'false'){		
			jQuery('#open-sub-euro-class').addClass('active');			
			jQuery('#open-sub-euro-class').html(oData.euroClass);			
			
			jQuery('.euro-class-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-euro-class-'+oData.euroClass.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-euro-class').removeClass('active');			
			jQuery('#open-sub-euro-class').html(jQuery('#open-sub-euro-class').data('default'));			
			jQuery('.euro-class-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.seatbelts != 'undefined' && oData.seatbelts != false && oData.seatbelts != 'false'){		
			jQuery('#open-sub-seatbelts').addClass('active');			
			
			var sSeatbelts = oData.seatbelts + (oData.seatbelts == 1 ? ' gordel' : ' gordels');					
			
			jQuery('#open-sub-seatbelts').html(sSeatbelts);			
			
			jQuery('.euro-seatbelts').prop('checked', false).button( "refresh" );
			jQuery('#set-seatbelts-'+oData.seatbelts.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-seatbelts').removeClass('active');			
			jQuery('#open-sub-seatbelts').html(jQuery('#open-sub-seatbelts').data('default'));			
			jQuery('.euro-seatbelts').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.owners != 'undefined' && oData.owners != false && oData.owners != 'false'){		
			jQuery('#open-sub-owners').addClass('active');	

			var sOwners = oData.owners + (oData.owners == 1 ? ' gordel' : ' gordels');					
			
			jQuery('#open-sub-owners').html(sOwners);			
			
			jQuery('.owners-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-owners-'+oData.owners.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-owners').removeClass('active');			
			jQuery('#open-sub-owners').html(jQuery('#open-sub-owners').data('default'));			
			jQuery('.owners-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.numberOfDoors != 'undefined' && oData.numberOfDoors != false && oData.numberOfDoors != 'false'){		
			jQuery('#open-sub-number-of-doors').addClass('active');	

			var sNumberOfDoors = oData.numberOfDoors + (oData.numberOfDoors == 1 ? ' deur' : ' deuren');					
			
			jQuery('#open-sub-number-of-doors').html(sNumberOfDoors);			
			
			jQuery('.number-of-doors-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-number-of-doors-'+oData.numberOfDoors.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-number-of-doors').removeClass('active');			
			jQuery('#open-sub-number-of-doors').html(jQuery('#open-sub-number-of-doors').data('default'));			
			jQuery('.number-of-doors-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.boatTrailerPlug != 'undefined' && oData.boatTrailerPlug != false && oData.boatTrailerPlug != 'false'){		
			jQuery('#open-sub-boattrailer-plug').addClass('active');	

			var sBoatTrailerPlug = oData.boatTrailerPlug;					
			
			jQuery('#open-sub-boattrailer-plug').html(sBoatTrailerPlug);			
			
			jQuery('.boattrailer-plug-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-boattrailer-plug-'+oData.boatTrailerPlug.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-boattrailer-plug').removeClass('active');			
			jQuery('#open-sub-boattrailer-plug').html(jQuery('#open-sub-boattrailer-plug').data('default'));			
			jQuery('.boattrailer-plug-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.plug != 'undefined' && oData.plug != false && oData.plug != 'false'){		
			jQuery('#open-sub-plug').addClass('active');	

			var sPlug = oData.plug;					
			
			jQuery('#open-sub-plug').html(sPlug);			
			
			jQuery('.plug-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-plug-'+oData.plug.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-plug').removeClass('active');			
			jQuery('#open-sub-plug').html(jQuery('#open-sub-plug').data('default'));			
			jQuery('.plug-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.materialBoat != 'undefined' && oData.materialBoat != false && oData.materialBoat != 'false'){		
			jQuery('#open-sub-material-boat').addClass('active');	

			var sMaterialBoat = oData.materialBoat;					
			
			jQuery('#open-sub-material-boat').html(sMaterialBoat);			
			
			jQuery('.material-boat-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-material-boat-'+oData.materialBoat.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-material-boat').removeClass('active');			
			jQuery('#open-sub-material-boat').html(jQuery('#open-sub-material-boat').data('default'));			
			jQuery('.material-boat-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.sizeBoat != 'undefined' && oData.sizeBoat != false && oData.sizeBoat != 'false'){		
			jQuery('#open-sub-size-boat').addClass('active');	

			var sSizeBoat = oData.sizeBoat;					
			
			jQuery('#open-sub-size-boat').html(sSizeBoat);			
			
			jQuery('.size-boat-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-size-boat-'+oData.sizeBoat.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-size-boat').removeClass('active');			
			jQuery('#open-sub-size-boat').html(jQuery('#open-sub-size-boat').data('default'));			
			jQuery('.size-boat-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.floorMaterial != 'undefined' && oData.floorMaterial != false && oData.floorMaterial != 'false'){		
			jQuery('#open-sub-floor-material').addClass('active');	

			var sFloorMaterial = oData.floorMaterial;					
			
			jQuery('#open-sub-floor-material').html(sFloorMaterial);			
			
			jQuery('.floor-material-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-floor-material-'+oData.floorMaterial.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-floor-material').removeClass('active');			
			jQuery('#open-sub-floor-material').html(jQuery('#open-sub-floor-material').data('default'));			
			jQuery('.floor-material-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.wallMaterial != 'undefined' && oData.wallMaterial != false && oData.wallMaterial != 'false'){		
			jQuery('#open-sub-wall-material').addClass('active');	

			var sWallMaterial = oData.wallMaterial;					
			
			jQuery('#open-sub-wall-material').html(sWallMaterial);			
			
			jQuery('.wall-material-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-wall-material-'+oData.wallMaterial.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-wall-material').removeClass('active');			
			jQuery('#open-sub-wall-material').html(jQuery('#open-sub-wall-material').data('default'));			
			jQuery('.wall-material-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.axles != 'undefined' && oData.axles != false && oData.axles != 'false'){		
			jQuery('#open-sub-axles').addClass('active');	

			var sAxles = oData.axles;					
			
			jQuery('#open-sub-axles').html(sAxles);			
			
			jQuery('.axles-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-axles-'+oData.axles.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-axles').removeClass('active');			
			jQuery('#open-sub-axles').html(jQuery('#open-sub-axles').data('default'));			
			jQuery('.axles-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.boatTrailerAxles != 'undefined' && oData.boatTrailerAxles != false && oData.boatTrailerAxles != 'false'){		
			jQuery('#open-sub-boattrailer-axles').addClass('active');	

			var sBoatTrailerAxles = oData.boatTrailerAxles;					
			
			jQuery('#open-sub-boattrailer-axles').html(sBoatTrailerAxles);			
			
			jQuery('.boattrailer-axles-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-boattrailer-axles-'+oData.boatTrailerAxles.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-boattrailer-axles').removeClass('active');			
			jQuery('#open-sub-boattrailer-axles').html(jQuery('#open-sub-boattrailer-axles').data('default'));			
			jQuery('.boattrailer-axles-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.doorTypes != 'undefined' && oData.doorTypes != false && oData.doorTypes != 'false'){		
			jQuery('#open-sub-door-types').addClass('active');	

			var sDoorTypes = oData.doorTypes;					
			
			jQuery('#open-sub-door-types').html(sDoorTypes);			
			
			jQuery('.door-types-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-door-types-'+oData.doorTypes.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-door-types').removeClass('active');			
			jQuery('#open-sub-door-types').html(jQuery('#open-sub-door-types').data('default'));			
			jQuery('.door-types-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.bedrooms != 'undefined' && oData.bedrooms != false && oData.bedrooms != 'false'){		
			jQuery('#open-sub-bedrooms').addClass('active');	

			var sBedrooms = oData.bedrooms + (oData.bedrooms == 1 ? ' slaapkamer' : ' slaapkamers');					
			
			jQuery('#open-sub-bedrooms').html(sBedrooms);			
			
			jQuery('.bedrooms-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-bedrooms-'+oData.bedrooms.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-bedrooms').removeClass('active');			
			jQuery('#open-sub-bedrooms').html(jQuery('#open-sub-bedrooms').data('default'));			
			jQuery('.bedrooms-radio').prop('checked', false).button( "refresh" );
		}				
		
		if(typeof oData.bedsBoat != 'undefined' && oData.bedsBoat != false && oData.bedsBoat != 'false'){		
			jQuery('#open-sub-beds-boat').addClass('active');	

			var sBedsBoat = oData.bedsBoat + (oData.bedsBoat == 1 ? ' bed' : ' bedden');					
			
			jQuery('#open-sub-beds-boat').html(sBedsBoat);			
			
			jQuery('.beds-boat-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-beds-boat-'+oData.bedsBoat.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-beds-boat').removeClass('active');			
			jQuery('#open-sub-beds-boat').html(jQuery('#open-sub-beds-boat').data('default'));			
			jQuery('.beds-boat-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.seats != 'undefined' && oData.seats != false && oData.seats != 'false'){		
			jQuery('#open-sub-seats').addClass('active');			
			
			var sSeats = oData.seats + (oData.seats == 1 ? ' zitplaats' : ' zitplaatsen');					
			
			jQuery('#open-sub-seats').html(sSeats);			
			
			jQuery('.seats-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-seats-'+oData.seats.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-seats').removeClass('active');			
			jQuery('#open-seats').html(jQuery('#open-sub-seats').data('default'));			
			jQuery('.seats-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.personsBoat != 'undefined' && oData.personsBoat != false && oData.personsBoat != 'false'){		
			jQuery('#open-sub-persons-boat').addClass('active');			
			
			var sPersonsBoat = oData.personsBoat + (oData.personsBoat == 1 ? ' persoon' : ' personen');					
			
			jQuery('#open-sub-persons-boat').html(sPersonsBoat);			
			
			jQuery('.persons-boat-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-persons-boat-'+oData.personsBoat.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-persons-boat').removeClass('active');			
			jQuery('#open-persons-boat').html(jQuery('#open-sub-persons-boat').data('default'));			
			jQuery('.persons-boat-radio').prop('checked', false).button( "refresh" );
		}
		
		
		if(typeof oData.walls != 'undefined' && oData.walls != false && oData.walls != 'false'){		
			jQuery('#open-sub-walltype').addClass('active');			
			jQuery('#open-sub-walltype').html(oData.walls);			
			jQuery('.walltype-radio').prop('checked', false).button( "refresh" );
			jQuery('#walltype-'+oData.walls.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-walltype').removeClass('active');			
			jQuery('#open-sub-walltype').html(jQuery('#open-sub-walltype').data('default'));			
			jQuery('.walltype-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.material != 'undefined' && oData.material != false && oData.material != 'false'){		
			jQuery('#open-sub-material').addClass('active');			
			jQuery('#open-sub-material').html(oData.material);			
			
			jQuery('.material-radio').prop('checked', false).button( "refresh" );
			jQuery('#material-'+oData.material.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-material').removeClass('active');			
			jQuery('#open-sub-material').html(jQuery('#open-sub-material').data('default'));			
			jQuery('.material-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.materialTentTrailer != 'undefined' && oData.materialTentTrailer != false && oData.materialTentTrailer != 'false'){		
			jQuery('#open-sub-material-tenttrailer').addClass('active');			
			jQuery('#open-sub-material-tenttrailer').html(oData.materialTentTrailer);			
			
			jQuery('.material-radio-tenttrailer').prop('checked', false).button( "refresh" );
			jQuery('#set-material-tenttrailer-'+oData.material.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-material-tenttrailer').removeClass('active');			
			jQuery('#open-sub-material-tenttrailer').html(jQuery('#open-sub-material-tenttrailer').data('default'));			
			jQuery('.material-radio-tenttrailer').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.wallscolor != 'undefined' && oData.wallscolor != false && oData.wallscolor != 'false'){		
			jQuery('#open-sub-color').addClass('active');			
			jQuery('#open-sub-color').html(oData.wallscolor);			
			
			jQuery('.color-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-color-'+oData.wallscolor.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-color').removeClass('active');			
			jQuery('#open-sub-color').html(jQuery('#open-sub-color').data('default'));			
			jQuery('.color-radio').prop('checked', false).button( "refresh" );
		}
		
		if(typeof oData.colorTrailer != 'undefined' && oData.colorTrailer != false && oData.colorTrailer != 'false'){		
			jQuery('#open-sub-color-trailer').addClass('active');			
			jQuery('#open-sub-color-trailer').html(oData.colorTrailer);			
			
			jQuery('.color-trailer-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-color-trailer-'+oData.colorTrailer.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-color-trailer').removeClass('active');			
			jQuery('#open-sub-color-trailer').html(jQuery('#open-sub-color-trailer').data('default'));			
			jQuery('.color-trailer-radio').prop('checked', false).button( "refresh" );
		}				
		
		if(oData.constructionYear != false && oData.constructionYear != 'false'){			
			jQuery('#set-constructionyear').val(oData.constructionYear);
		} else {
			jQuery('#set-constructionyear').val('');
		}
		
		if(typeof oData.constructionMonth != 'undefined' && oData.constructionMonth != false && oData.constructionMonth != 'false'){		
			jQuery('#open-sub-constructionmonth').addClass('active');			
			jQuery('#open-sub-constructionmonth').html(oData.constructionMonth);			
			
			jQuery('.constructionmonth-radio').prop('checked', false).button( "refresh" );
			jQuery('#set-constructionmonth-'+oData.constructionMonth.toLowerCase()).prop('checked', true).button( "refresh" );			
		} else {
			jQuery('#open-sub-constructionmonth').removeClass('active');			
			jQuery('#open-sub-constructionmonth').html(jQuery('#open-sub-constructionmonth').data('default'));			
			jQuery('.constructionmonth-radio').prop('checked', false).button( "refresh" );
		}
				
		if(typeof oData.sleepingplaces != 'undefined' && oData.sleepingplaces != false && oData.sleepingplaces != 'false'){			
			jQuery('#set-sleepingplaces').val(oData.sleepingplaces);
			
			jQuery('#beds-container').html('');
			
			if(oData.bedspecifications != false && oData.bedspecifications != 'false'){				
				
				jQuery.each(oData.bedspecifications, $.proxy(function(index, item) {
					
					var iBedCount = index+1;
					var iBedWidth = item.width != '' && item.width > 0 ? item.width : '';
					var iBedLength = item.length != '' && item.length > 0 ? item.length : '';
					var iBedType = item.type != '' ? item.type : '';
										
					var bedHTML = createBedType(iBedCount,iBedWidth,iBedLength,iBedType);						
					
					jQuery('#beds-container').prepend(bedHTML);
					
					jQuery('#set-bed-type-' + iBedCount).select2({
						allowClear: true,
						minimumResultsForSearch: -1,
						width: '100%',
						placeholder: 'Kies bedtype',
						language: "nl",
						dropdownParent: jQuery('#sale-beds-select-container-' + iBedCount)
					});
					
					jQuery('#set-bed-type-' + iBedCount).on('select2:select', function (e) {	
						if(typeof e.params.data.id != 'undefined'  ){
							sessionStorage['current_bed-type-'+iBedCount] = e.params.data.id;
						}
					});
					
					jQuery('#set-bed-type-' + iBedCount).on('select2:clear', function (e) {			
						jQuery(this).data('unselecting', true);
						
						sessionStorage.removeItem('current_bed-type-'+iBedCount);
						
					});	

					jQuery('#set-bed-type-' + iBedCount).on('select2:opening', function (e) {
						
						 if (jQuery(this).data('unselecting')) {
							jQuery(this).removeData('unselecting');
							e.preventDefault();
						}
					});
				}));
			}
			
		} else {
			jQuery('#set-sleepingplaces').val('');
			jQuery('#beds-container').html('');
		}
		
		setLoadingOverlay('fadeout');
	}	
	
		
	
	jQuery.loadData = function () {		
		
		setLoadingOverlay('fadein');
		
		var sCurrentVal = jQuery('#set-license').val();
		
		$.post(baseHref() + 'article', { 

			module: 'autofillArticle',
			category: articleCategory,
			license: sCurrentVal
			
		}, function(data) {
			
			var oData = $.parseJSON(data);
			
			jQuery('#autofill-response-container').removeClass('active').removeClass('succes').removeClass('error').html('');
			
			if(oData.data == 'no-data'){
				
				jQuery('#autofill-response-container').addClass('active').addClass('error').html('Voertuig gegevens niet gevonden');
				
				setLoadingOverlay('fadeout');
				
			} else {
								
				jQuery('#autofill-response-container').addClass('active').addClass('succes').html('Voertuig gegevens succesvol opgehaald');
				
				jQuery.parsePrefilledData(oData.data,false);
								
			}
			
		});
		
	}
	
	jQuery(document).on("keyup","#set-sleepingplaces",function(e) {
		
		var sCurrentVal = jQuery(this).val();
		
		if(sCurrentVal < 1 ){
			sCurrentVal = '';
		} else if(sCurrentVal > 10 ){
			sCurrentVal = 10;
		}
		
		jQuery(this).val(sCurrentVal);
	});
	
	jQuery(document).on("click","#add-bed",function(e) {
	
		var iCurrentBeds = jQuery('.sleep-container-bed').length;
		
		jQuery('#too-many-beds').removeClass('active');
						
		if(iCurrentBeds == 10){			
			jQuery('#too-many-beds').addClass('active');
		} else {
						
			var iNextBeds = iCurrentBeds+1;			
			var bedHTML = createBedType(iNextBeds);

			jQuery('#beds-container').append(bedHTML);
						
			$('html, body').scrollTop(jQuery('.sleep-container-' + iNextBeds).offset().top);
			
			jQuery('#set-bed-type-' + iNextBeds).select2({
				allowClear: true,
				minimumResultsForSearch: -1,
				width: '100%',
				placeholder: 'Kies bedtype',
				language: "nl",
				dropdownParent: jQuery('#sale-beds-select-container-' + iNextBeds)
			});
			
			jQuery('#set-bed-type-' + iNextBeds).on('select2:select', function (e) {
				if(typeof e.params.data.id != 'undefined'  ){
					sessionStorage['current_bed-type-'+iNextBeds] = e.params.data.id;
				}
			});
			
			jQuery('#set-bed-type-' + iNextBeds).on('select2:clear', function (e) {			
				jQuery(this).data('unselecting', true);
				sessionStorage.removeItem('current_bed-type-'+iNextBeds);
			});	

			jQuery('#set-bed-type-' + iNextBeds).on('select2:opening', function (e) {
				
				 if (jQuery(this).data('unselecting')) {
					jQuery(this).removeData('unselecting');
					e.preventDefault();
				}
			});
		
		}

		var iNumberOfBeds = jQuery('.sleep-container-bed').length;
		
		if(iNumberOfBeds > 0){
			sessionStorage['current_beds'] = iNumberOfBeds;
		} else {
			sessionStorage.removeItem('current_beds');
		}
	});
	
	jQuery(document).on("change","input.version-radio",function(e) {
		
		if(pageType == 'add'){
			
			var iTemplateId = typeof jQuery(this).data('templateid') != 'undefined' ? jQuery(this).data('templateid') : 0;
			
			sessionStorage['template_id'] = parseInt(iTemplateId);
						
			var popupLoadTemplateContent = '<div class="concept-confirmation" id="concept-confirmation">';
				popupLoadTemplateContent += '<h2 id="concept-confirmation-title">Template data laden</h2>';
				popupLoadTemplateContent += '<span class="title">Wilt u alle gegevens die wij weten van dit model inladen? De reeds ingevoerde data zal worden overschreven.</span>';					
				popupLoadTemplateContent += '<span class="sure" onclick="jQuery.loadTemplateData(\'resume\');"></span>';
				popupLoadTemplateContent += '<span class="not-sure" onclick="jQuery.loadTemplateData(\'cancel\');"></span>';
			popupLoadTemplateContent += '</div>"';

			oLightboxLoadTemplateArticle = SimpleLightbox.open({
				closeOnOverlayClick: false,
				closeOnEscapeKey: false,
				content: popupLoadTemplateContent,
				beforeClose: function(){
					setLoadingOverlay('fadeout');						
				}
			});	
		}		
	});
	
	jQuery.loadTemplateData = function(action){
		
		if(action == 'resume') {
			
			setLoadingOverlay('fadein');
		
			var templateModelID = sessionStorage.getItem('template_id') !== null ? sessionStorage['template_id'] : 0;
			
			if(templateModelID < 1){
				return;
			}
			
			$.post(baseHref() + 'article', { 

				module: 'autofillTemplate',
				templateId: templateModelID
				
			}, function(data) {
				
				var oData = $.parseJSON(data);
				
				if(oData.data == 'no-data'){
					
					setLoadingOverlay('fadeout');
					
				} else {
									
					jQuery('#template-succes').animate({top: '0px'},400);
					
					jQuery.parsePrefilledData(oData.data,true);
					
					setLoadingOverlay('fadeout');
									
					setTimeout(function() {
						jQuery('#template-succes').animate({top: '-60px'},400);
					}, 3000);
				}
				
			});
						
			sessionStorage.removeItem('template_id');
			
			oLightboxLoadTemplateArticle.close();
		} else if(action == 'cancel') {
			
			sessionStorage.removeItem('template_id');
			
			oLightboxLoadTemplateArticle.close();
		}
	
	}
	
	jQuery(document).on("change","input.brand-radio",function(e) {
		
		//if(articleBrand == ''){
		articleBrand = jQuery('input[name="set-brand"]:checked').val();
		//}
		
		var sReturnBrand = articleBrand;		
		
		var sTitleToSet = 'Kenmerken';		
		jQuery('#title-container').html(sTitleToSet);
		
		jQuery('.notice-container').remove();

		if(sReturnBrand != ''){				
			jQuery('.article-input-subgroup.brand').addClass('active');
			jQuery('#brand-set-value').html(capitalizeFirstLetterOfString(sReturnBrand));
			
			sessionStorage['current_brand'] = sReturnBrand;
			
		} else {
			jQuery('.article-input-subgroup.brand').removeClass('active');
			jQuery('#brand-set-value').html('');
			
			sessionStorage.removeItem('current_brand');
		}
		
		if(jQuery('#models-container').length){
			jQuery('#models-container').remove();
			sessionStorage.removeItem('current_model');
			
			parseModels();
		}
		
		sessionStorage.removeItem('active_sub_group');
		
		jQuery('.article-input-subgroup.model').removeClass('active');						
		jQuery('#model-set-value').html('');
		
		jQuery('body').removeClass('brand-active');
		jQuery('body').removeClass('has-active-sub');
		
	});	
	
	jQuery(document).on("change","input.model-radio",function(e) {
		
		articleModel = jQuery('input[name="set-model"]:checked').val();
		jQuery('#versions-container').remove();
		jQuery('#version-set-value').html('');
		
		articleVersion = '';
		sessionStorage.removeItem('current_version');
		
		var sReturnModel = articleModel;
		
		var sTitleToSet = 'Kenmerken';		
		jQuery('#title-container').html(sTitleToSet);
		
		jQuery('.notice-container').remove();

		if(sReturnModel != ''){		
			jQuery('.article-input-subgroup.model').addClass('active');
			jQuery('#model-set-value').html(capitalizeFirstLetterOfString(sReturnModel));
			
			sessionStorage['current_model'] = sReturnModel;	
		} else {
			jQuery('.article-input-group.model').removeClass('active');
			jQuery('#model-set-value').html('');

			sessionStorage.removeItem('current_model');			
		}
		
		sessionStorage.removeItem('active_sub_group');
		
		jQuery('body').removeClass('model-active');
		jQuery('body').removeClass('has-active-sub');
		
	});		
	
	jQuery(document).on("change","input.version-radio",function(e) {
		
		articleVersion = jQuery('input[name="set-version"]:checked').val();
		
		var sReturnVersion = articleVersion;
		
		var sTitleToSet = 'Kenmerken';		
		jQuery('#title-container').html(sTitleToSet);
		
		jQuery('.notice-container').remove();

		if(sReturnVersion != ''){		
			jQuery('.article-input-subgroup.version').addClass('active');
			jQuery('#version-set-value').html(capitalizeFirstLetterOfString(sReturnVersion));
			
			sessionStorage['current_version'] = sReturnVersion;	
		} else {
			jQuery('.article-input-group.version').removeClass('active');
			jQuery('#version-set-value').html('');

			sessionStorage.removeItem('current_version');			
		}
		
		sessionStorage.removeItem('active_sub_group');
		
		jQuery('body').removeClass('version-active');
		jQuery('body').removeClass('has-active-sub');
		
	});	
	
	jQuery(document).on("blur",".price-input",function(e) {
		var sReturnPrice = jQuery(this).val();
			
		jQuery(this).val(sReturnPrice);
		
	});	
	
	jQuery(document).on("keyup",".number-input",function(e) {
		if(event.which >= 37 && event.which <= 40) return;

		// format number
		jQuery(this).val(function(index, value) {
			return value
			.replace(/\D/g, "")
			.replace(/\B(?=(\d{3})+(?!\d))/g, ".")
			;
		});
		
	});
	
	buildStatusSynopsis = function () {
		
		var statusContent = '';
				
		var sReturnStatusOnline = jQuery('#set-online').prop('checked') ? 'Online' : 'Offline';			
		var sReturnStockStatus = jQuery('input[name="set-status"]:checked').val();
		var sReturnPeriod = jQuery('select[name="set-period"]').val();
					
		if(sReturnStatusOnline != '' && typeof sReturnStatusOnline != 'undefined' && sReturnStatusOnline != 'undefined'){
			statusContent = '1';					
		}
		
		if(sReturnStockStatus != '' && typeof sReturnStockStatus != 'undefined' && sReturnStockStatus != 'undefined'){			
			statusContent = '1';					
		}
		
		if(sReturnPeriod != '' && typeof sReturnPeriod != 'undefined' && sReturnPeriod != 'undefined'){
			statusContent = '1';					
		}			
			
		if(statusContent != ''){
			
			statusContent = '';
				
			jQuery('.article-input-group.status').addClass('active');
			jQuery('#status-set-value').html(capitalizeFirstLetterOfString(statusContent));			
		} else {
			jQuery('.article-input-group.status').removeClass('active');
			jQuery('#status-set-value').html('');	
		}
	}
	
	function buildMarktplaatsSynopsis() {
		var sReturnMarktplaatsTitle = jQuery('#sale-marktplaats-title').val();
		var sReturnMarktplaatsPrice = jQuery('#sale-marktplaats-price').val();
		
		var sReturnMarktplaatsPriceType = jQuery('#set-marktplaats-pricetype').val();				
		
		var sReturnMarktplaatsMinimalBidPrice = jQuery('#sale-marktplaats-minimalbidprice').val();
		var sReturnMarktplaatsBidPrice = jQuery('#sale-marktplaats-bidprice').val();
		
		//var sReturnMarktplaatsDescription = tinymce.get("marktplaats_description").getContent();		
		var sReturnMarktplaatsDescription = jQuery('#editor_marktplaats_description .richText-editor').trigger('getContent', function (event, content) {
			return content;
		});
		
		if(typeof sReturnMarktplaatsDescription[0].innerHTML != 'undefined' && sReturnMarktplaatsDescription[0].innerHTML != ''){
			sReturnMarktplaatsDescription = sReturnMarktplaatsDescription[0].innerHTML;
		}
		
		var sReturnMarktplaatsContent = '';
		
		if(sReturnMarktplaatsTitle != '' && typeof sReturnMarktplaatsTitle != 'undefined' && sReturnMarktplaatsTitle != 'undefined'){
			if(sReturnMarktplaatsContent == ''){
				sReturnMarktplaatsContent += sReturnMarktplaatsTitle;
			} else {
				sReturnMarktplaatsContent += ', ' + sReturnMarktplaatsTitle;
			}					
		}
		
		if(sReturnMarktplaatsPriceType != '' && typeof sReturnMarktplaatsPriceType != 'undefined' && sReturnMarktplaatsPriceType != 'undefined'){
			if(sReturnMarktplaatsContent == ''){
				sReturnMarktplaatsContent += sReturnMarktplaatsPriceType;
			} else {
				sReturnMarktplaatsContent += ', ' + sReturnMarktplaatsPriceType;
			}					
		}
		
		if(sReturnMarktplaatsPrice != '' && typeof sReturnMarktplaatsPrice != 'undefined' && sReturnMarktplaatsPrice != 'undefined' && sReturnMarktplaatsPrice > 0){
			if(sReturnMarktplaatsContent == ''){
				sReturnMarktplaatsContent += '&euro; ' + accounting.formatNumber(sReturnMarktplaatsPrice,0,".", ",");
			} else {
				sReturnMarktplaatsContent += ', &euro; ' + accounting.formatNumber(sReturnMarktplaatsPrice,0,".", ",");
			}					
		}
		
		if(sReturnMarktplaatsMinimalBidPrice != '' && typeof sReturnMarktplaatsMinimalBidPrice != 'undefined' && sReturnMarktplaatsMinimalBidPrice != 'undefined' && sReturnMarktplaatsMinimalBidPrice > 0){
			if(sReturnMarktplaatsContent == ''){
				sReturnMarktplaatsContent += '&euro; ' + accounting.formatNumber(sReturnMarktplaatsMinimalBidPrice,0,".", ",");
			} else {
				sReturnMarktplaatsContent += ', &euro; ' + accounting.formatNumber(sReturnMarktplaatsMinimalBidPrice,0,".", ",");
			}					
		}
		
		if(sReturnMarktplaatsBidPrice != '' && typeof sReturnMarktplaatsBidPrice != 'undefined' && sReturnMarktplaatsBidPrice != 'undefined' && sReturnMarktplaatsBidPrice > 0){
			if(sReturnMarktplaatsContent == ''){
				sReturnMarktplaatsContent += '&euro; ' + accounting.formatNumber(sReturnMarktplaatsBidPrice,0,".", ",");
			} else {
				sReturnMarktplaatsContent += ', &euro; ' + accounting.formatNumber(sReturnMarktplaatsBidPrice,0,".", ",");
			}					
		}

		if(sReturnMarktplaatsDescription != '' && typeof sReturnMarktplaatsDescription != 'undefined' && sReturnMarktplaatsDescription != 'undefined' ){
			sReturnMarktplaatsDescription = sReturnMarktplaatsDescription.replace(/(<([^>]+)>)/gi, "");
			sReturnMarktplaatsDescription = sReturnMarktplaatsDescription.replace(/&nbsp;/g,' ');
			sReturnMarktplaatsDescription = sReturnMarktplaatsDescription.replace(/  +/g, ' ');
			sReturnMarktplaatsDescription = sReturnMarktplaatsDescription.trim();
			
			if(sReturnMarktplaatsDescription.length > 100){
				sReturnMarktplaatsDescription = sReturnMarktplaatsDescription.substring(0, 100) + '...';
			}
			
			if(sReturnMarktplaatsContent == ''){
				sReturnMarktplaatsContent += sReturnMarktplaatsDescription;
			} else {
				sReturnMarktplaatsContent += ', ' + sReturnMarktplaatsDescription;
			}
			
			featuresContent = '';	
		}		
			
		if(sReturnMarktplaatsContent != ''){		
			if(sReturnMarktplaatsContent.length > 100){
				sReturnMarktplaatsContent = sReturnMarktplaatsContent.substring(0, 100);
			}
			
			sReturnMarktplaatsContent = '';
			
			jQuery('.article-input-group.marktplaats').addClass('active');
			jQuery('#marktplaats-set-value').html(capitalizeFirstLetterOfString(sReturnMarktplaatsContent));
		} else {
			jQuery('.article-input-group.marktplaats').removeClass('active');
			jQuery('#marktplaats-set-value').html('');			
		}
	}
	
	function buildPricesSynopsis() {
		var sReturnSalePrice = jQuery('#sale-price').val();
		var sReturnFromPrice = jQuery('#from-price').val();
		var sReturnFromVat = jQuery('input[name="set-vat"]:checked').val();
		var sReturnPrices = '';
		
		if(sReturnSalePrice != '' && typeof sReturnSalePrice != 'undefined' && sReturnSalePrice != 'undefined'){
			sReturnPrices = '1';
		}
		if(sReturnFromPrice != '' && typeof sReturnFromPrice != 'undefined' && sReturnFromPrice != 'undefined'){
			sReturnPrices = '1';
		}
		if(sReturnFromVat != '' && typeof sReturnFromVat != 'undefined' && sReturnFromVat != 'undefined'){
			sReturnPrices = '1';
		}
		
		if(sReturnPrices != ''){		
			
			if(sReturnPrices.length > 100){
				sReturnPrices = sReturnPrices.substring(0, 100);
			}

			sReturnPrices = '';
			
			articlePriceSynopsis = sReturnPrices;
			
			jQuery('.article-input-group.price').addClass('active');
			jQuery('#price-set-value').html(capitalizeFirstLetterOfString(sReturnPrices));
		} else {				
			jQuery('.article-input-group.price').removeClass('active');
			jQuery('#price-set-value').html('');
		}
	}
	
	function cleanTextareaContent(content) {
		
		sReturnContent = content.replace(/(<([^>]+)>)/gi, "");
		sReturnContent = sReturnContent.replace(/&nbsp;/g,' ');
		sReturnContent = sReturnContent.replace(/  +/g, ' ');
		sReturnContent = sReturnContent.trim();
		
		if(sReturnContent.length > 100){
			sReturnContent = sReturnContent.substring(0, 100) + '...';
		}
		
		return sReturnContent;
	}
	
	
	function buildDescriptionSynopsis() {
	
		//var descriptionContent = tinymce.get("article_description").getContent();
		var descriptionContent = jQuery('#editor_article_description .richText-editor').trigger('getContent', function (event, content) {
			return content;
		});
		
		if(typeof descriptionContent[0].innerHTML != 'undefined' && descriptionContent[0].innerHTML != ''){
			descriptionContent = descriptionContent[0].innerHTML;
		}
		
		//var commentContent = tinymce.get("article_comment").getContent();
		var commentContent = jQuery('#editor_article_comment .richText-editor').trigger('getContent', function (event, content) {
			return content;
		});
		
		if(typeof commentContent[0].innerHTML != 'undefined' && commentContent[0].innerHTML != ''){
			commentContent = commentContent[0].innerHTML;
		}
		
		var referenceContent = '';
		
		if(jQuery('#editor_article_reference').length){
			//var referenceContent = tinymce.get("article_reference").getContent();
			var referenceContent = jQuery('#editor_article_reference .richText-editor').trigger('getContent', function (event, content) {
				return content;
			});
			
			if(typeof referenceContent[0].innerHTML != 'undefined' && referenceContent[0].innerHTML != ''){
				referenceContent = referenceContent[0].innerHTML;
			}
		}
		
		jQuery('.article-input-group.description').removeClass('active');
		jQuery('#description-set-value').html('');	
				
		if((descriptionContent != '' && typeof descriptionContent != 'undefined' && descriptionContent != 'undefined')){			
			// doe niks
		} else {			
			sessionStorage.removeItem('current_description');
		}
		
		if((commentContent != '' && typeof commentContent != 'undefined' && commentContent != 'undefined')){			
			// doe niks
		} else {			
			sessionStorage.removeItem('current_comment');
		}	
		
		if((referenceContent != '' && typeof referenceContent != 'undefined' && referenceContent != 'undefined')){			
			// doe niks
		} else {			
			sessionStorage.removeItem('current_reference');
		}	
	}
	
	function parsePreview(currentActiveSection) {
				
		if(currentActiveSection == 'preview-active'){
		
			setLoadingOverlay('fadein');
			
			var sHTML = '';
			var sArticleData = jQuery.getArticleData();
			
			jQuery('#preview-container').html('');
			
			if(sArticleData == ''){
				sHTML = '<div class="no-preview">Er zijn niet voldoende gegevens beschikbaar om een preview te genereren.</div>';
			} else {
				oArticleData = jQuery.parseJSON(sArticleData);
				
				var sTitle = '';
				var sImage = '/assets/img/icons/icon-no-image.svg';
				var sImagePlaceholder = ' placeholder';
				var sSynopsis = '';
				var sPrices = '';
				var sOverview = '';
				var sDescription = '';
				var sSpecs = '';
				var sDivisions = '';
				var sAccessories = '';
				
				sHTML += '<div class="article-preview">';				
				
				// article title
				if(typeof oArticleData.brand != 'undefined' && oArticleData.brand != ''){
					sTitle += oArticleData.brand + ' ';
				}
				
				if(typeof oArticleData.model != 'undefined' && oArticleData.model != ''){
					sTitle += oArticleData.model + ' ';
				}
				
				if(typeof oArticleData.version != 'undefined' && oArticleData.version != ''){
					sTitle += oArticleData.version + ' ';
				}
				
				if(typeof oArticleData.type != 'undefined' && oArticleData.type != ''){
					sTitle += oArticleData.type + ' ';
				} else if(typeof articleType != 'undefined' && articleType != ''){
					sTitle += articleType + ' ';					
				}
				
				if(typeof oArticleData.suffix != 'undefined' && oArticleData.suffix != ''){
					sTitle += oArticleData.suffix + ' ';
				} else if(typeof articleSuffix != 'undefined' && articleSuffix != ''){
					sTitle += articleSuffix + ' ';					
				}				
				
				if(sTitle != ''){
					sHTML += '<div class="preview-title">' + sTitle + '</div>';
				}	

				
				// article synopsis				
				if(typeof oArticleData.constructionYear != 'undefined' && oArticleData.constructionYear != ''){
					sSynopsis += oArticleData.constructionYear + ' | ';
				}
				
				if(typeof oArticleData.condition != 'undefined' && oArticleData.condition != ''){
					sSynopsis += oArticleData.condition + ' | ';
				}
				
				if(typeof oArticleData.subcategory != 'undefined' && oArticleData.subcategory != ''){
					sSynopsis += oArticleData.subcategory + ' | ';
				}
				
				if(typeof oArticleData.fuel != 'undefined' && oArticleData.fuel != ''){
					sSynopsis += oArticleData.fuel + ' | ';
				}
				
				if(typeof oArticleData.transmission != 'undefined' && oArticleData.transmission != ''){
					sSynopsis += oArticleData.transmission + ' | ';
				}
				
				if(typeof oArticleData.mileage != 'undefined' && oArticleData.mileage != ''){
					sSynopsis += oArticleData.mileage + ' km. | ';
				}
				
				if(typeof oArticleData.power != 'undefined' && oArticleData.power != ''){
					sSynopsis += oArticleData.power + ' pk. | ';
				}
				
				if(typeof oArticleData.sleepingplaces != 'undefined' && oArticleData.sleepingplaces != ''){
					sSynopsis += oArticleData.sleepingplaces + ' slaapplaatsen | ';
				}
				
				if(sSynopsis != ''){
					sHTML += '<div class="preview-synopsis">' + capitalizeFirstLetterOfString(sSynopsis.slice(0,-3)) + '</div>';
				}
				
				
				// article image
				if(typeof oArticleData.images != 'undefined' && oArticleData.images != ''){
					if(typeof oArticleData.images[0] != 'undefined' && oArticleData.images[0] != ''){
						sImage = oArticleData.images[0];
						sImagePlaceholder = '';
					}
				}
				
				if(sImage != ''){
					sHTML += '<div class="preview-image-wrapper"><div class="preview-image" style="background-image:url(' + sImage + ');"></div></div>';
				}				
				
				// article prices				
				if(typeof oArticleData.status != 'undefined' && oArticleData.status == 'verwacht'){					
					sPrices = '<div class="preview-price">Verwacht</div>';
				} else if(typeof oArticleData.status != 'undefined' && oArticleData.status == 'verkocht'){				
					sPrices = '<div class="preview-price">Verkocht</div>';
				} else if(typeof oArticleData.status != 'undefined' && oArticleData.status == 'gereserveerd'){
					sPrices = '<div class="preview-price">Gereserveerd</div>';
				} else {				
					if(typeof oArticleData.fromPrice != 'undefined' && oArticleData.fromPrice != ''){
						sPrices = '<div class="preview-from-price">&euro; ' + oArticleData.fromPrice + '</div>';
					}
					
					if(typeof oArticleData.price != 'undefined' && oArticleData.imafromPriceges != ''){
						sPrices = '<div class="preview-price">&euro; ' + oArticleData.price + '</div>';
					}				
				}
				
				if(sPrices != ''){
					sHTML += '<div class="preview-prices">' + sPrices + '</div>';
				}
				
				
				// article specs
				
				// article specs general				
				var sSpecsGeneral = '';
				
				if(typeof oArticleData.brand != 'undefined' && oArticleData.brand != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Merk</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.brand) + '</div></div>';
				}
				
				if(typeof oArticleData.model != 'undefined' && oArticleData.model != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Model</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.model);
					
					if(typeof oArticleData.type != 'undefined' && oArticleData.type != ''){
						sSpecsGeneral += ' ' + oArticleData.type;
					} else if(typeof articleType != 'undefined' && articleType != ''){
						sSpecsGeneral += ' ' + articleType;					
					}
					
					if(typeof oArticleData.version != 'undefined' && oArticleData.version != ''){
						sSpecsGeneral += ' ' + oArticleData.version;
					} else if(typeof articleVersion != 'undefined' && articleVersion != ''){
						sSpecsGeneral += ' ' + articleVersion;					
					}
					
					if(typeof oArticleData.suffix != 'undefined' && oArticleData.suffix != ''){
						sSpecsGeneral += ' ' + oArticleData.suffix;
					} else if(typeof articleSuffix != 'undefined' && articleSuffix != ''){
						sSpecsGeneral += ' ' + articleSuffix;					
					}

					sSpecsGeneral += '</div></div>';
				}
				
				if(typeof oArticleData.constructionYear != 'undefined' && oArticleData.constructionYear != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Bouwjaar</div><div class="preview-spec-value">' + oArticleData.constructionYear + '</div></div>';
				}
				
				if(typeof oArticleData.modelYear != 'undefined' && oArticleData.modelYear != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Modeljaar</div><div class="preview-spec-value">' + oArticleData.modelYear + '</div></div>';
				}
				
				if(typeof oArticleData.condition != 'undefined' && oArticleData.condition != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Conditie</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.condition) + '</div></div>';
				}
				
				if(typeof oArticleData.subcategory != 'undefined' && oArticleData.subcategory != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Soort</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.subcategory) + '</div></div>';
				}
				
				if(typeof oArticleData.mileage != 'undefined' && oArticleData.mileage != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">KM-stand</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.mileage) + ' km.</div></div>';
				}
				
				if(typeof oArticleData.fuel != 'undefined' && oArticleData.fuel != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Brandstof</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.fuel) + '</div></div>';
				}
				
				if(typeof oArticleData.transmission != 'undefined' && oArticleData.transmission != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Transmissie</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.transmission) + '</div></div>';
				}
				
				if(typeof oArticleData.power != 'undefined' && oArticleData.power != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Vermogen</div><div class="preview-spec-value">' + capitalizeFirstLetterOfString(oArticleData.power) + ' pk.</div></div>';
				}
				
				if(typeof oArticleData.euroClass != 'undefined' && oArticleData.euroClass != ''){
					sSpecsGeneral += '<div class="preview-spec-line"><div class="preview-spec-label">Euroklasse</div><div class="preview-spec-value">Klasse ' + capitalizeFirstLetterOfString(oArticleData.euroClass) + '</div></div>';
				}
				
				if(sSpecsGeneral != ''){
					sSpecs += '<h3>Algemeen</h3>' + sSpecsGeneral;
				}	

				// article specs measures				
				var sSpecsMeasures = '';
				
				if(typeof oArticleData.constructionLength != 'undefined' && oArticleData.constructionLength != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Opbouwlengte</div><div class="preview-spec-value">' + (oArticleData.constructionLength) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.totalLength != 'undefined' && oArticleData.totalLength != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Totale lengte</div><div class="preview-spec-value">' + (oArticleData.totalLength) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.containerLength != 'undefined' && oArticleData.containerLength != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Lengte bak</div><div class="preview-spec-value">' + (oArticleData.containerLength) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.length != 'undefined' && oArticleData.length != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Lengte</div><div class="preview-spec-value">' + (oArticleData.length) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.drawbarLength != 'undefined' && oArticleData.drawbarLength != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Lengte dissel</div><div class="preview-spec-value">' + (oArticleData.drawbarLength) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.width != 'undefined' && oArticleData.width != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Breedte</div><div class="preview-spec-value">' + (oArticleData.width) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.containerWidth != 'undefined' && oArticleData.containerWidth != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Breedte bak</div><div class="preview-spec-value">' + (oArticleData.containerWidth) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.totalWidth != 'undefined' && oArticleData.totalWidth != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Totale breedte</div><div class="preview-spec-value">' + (oArticleData.totalWidth) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.height != 'undefined' && oArticleData.height != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Hoogte</div><div class="preview-spec-value">' + (oArticleData.height) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.totalHeight != 'undefined' && oArticleData.totalHeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Totale hoogte</div><div class="preview-spec-value">' + (oArticleData.totalHeight) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.headroom != 'undefined' && oArticleData.headroom != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Stahoogte</div><div class="preview-spec-value">' + (oArticleData.headroom) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.loadingPlatformHeight != 'undefined' && oArticleData.loadingPlatformHeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Laadvloer hoogte</div><div class="preview-spec-value">' + (oArticleData.loadingPlatformHeight) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.couplerHeight != 'undefined' && oArticleData.couplerHeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Koppelingshoogte</div><div class="preview-spec-value">' + (oArticleData.couplerHeight) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.bordersHeight != 'undefined' && oArticleData.bordersHeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Hoogte borden</div><div class="preview-spec-value">' + (oArticleData.bordersHeight) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.bordersHeight != 'undefined' && oArticleData.bordersHeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Voorrek hoogte</div><div class="preview-spec-value">' + (oArticleData.bordersHeight) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.internalHeight != 'undefined' && oArticleData.internalHeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Inwendige hoogte</div><div class="preview-spec-value">' + (oArticleData.internalHeight) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.basePlateHeight != 'undefined' && oArticleData.basePlateHeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Dikte grondplaat</div><div class="preview-spec-value">' + (oArticleData.basePlateHeight) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.tireSize != 'undefined' && oArticleData.tireSize != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Bandenmaat</div><div class="preview-spec-value">' + (oArticleData.tireSize) + ' inch</div></div>';
				}
				
				if(typeof oArticleData.volume != 'undefined' && oArticleData.volume != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Inhoud</div><div class="preview-spec-value">' + (oArticleData.volume) + ' m3</div></div>';
				}
				
				if(typeof oArticleData.depth != 'undefined' && oArticleData.depth != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Diepgang</div><div class="preview-spec-value">' + (oArticleData.depth) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.verticalclearance != 'undefined' && oArticleData.verticalclearance != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Doorvaarhoogte</div><div class="preview-spec-value">' + (oArticleData.verticalclearance) + ' cm.</div></div>';
				}				
				
				if(typeof oArticleData.circulationsize != 'undefined' && oArticleData.circulationsize != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Omloopmaat</div><div class="preview-spec-value">' + (oArticleData.circulationsize) + ' cm.</div></div>';
				}
				
				if(typeof oArticleData.emptyWeight != 'undefined' && oArticleData.emptyWeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Leeggewicht</div><div class="preview-spec-value">' + (oArticleData.emptyWeight) + ' kg.</div></div>';
				}
				
				if(typeof oArticleData.roadworthyWeight != 'undefined' && oArticleData.roadworthyWeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Rijklaar gewicht</div><div class="preview-spec-value">' + (oArticleData.roadworthyWeight) + ' kg.</div></div>';
				}
				
				if(typeof oArticleData.maxWeight != 'undefined' && oArticleData.maxWeight != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Max toelaatbaar gewicht</div><div class="preview-spec-value">' + (oArticleData.maxWeight) + ' kg.</div></div>';
				}
				
				if(typeof oArticleData.capacity != 'undefined' && oArticleData.capacity != ''){
					sSpecsMeasures += '<div class="preview-spec-line"><div class="preview-spec-label">Laadvermogen</div><div class="preview-spec-value">' + (oArticleData.capacity) + ' kg.</div></div>';
				}
				
				if(sSpecsMeasures != ''){
					sSpecs += '<h3>Maten en gewichten</h3>' + sSpecsMeasures;
				}
				
				
				// article specs beds
				var sSpecsSleeping = '';
								
				if(typeof oArticleData.bedrooms != 'undefined' && oArticleData.bedrooms != ''){
					sSpecsSleeping += '<div class="preview-spec-line"><div class="preview-spec-label">Aantal slaapkamers</div><div class="preview-spec-value">' + (oArticleData.bedrooms) + (oArticleData.bedrooms == '1' ? ' slaapkamer' : ' slaapkamers') + '</div></div>';
				}				
				
				if(typeof oArticleData.sleepingplaces != 'undefined' && oArticleData.sleepingplaces != ''){
					sSpecsSleeping += '<div class="preview-spec-line"><div class="preview-spec-label">Aantal slaapplaatsen</div><div class="preview-spec-value">' + (oArticleData.sleepingplaces) + (oArticleData.sSpecsSleeping == '1' ? ' slaapplaats' : ' slaapplaatsen') + '</div></div>';
				}
				
				if(typeof oArticleData.beds != 'undefined' && oArticleData.beds != ''){
					sSpecsSleeping += '<div class="preview-spec-line"><div class="preview-spec-label">Aantal bedden</div><div class="preview-spec-value">' + (oArticleData.beds) + (oArticleData.beds == '1' ? ' bed' : ' bedden') + '</div></div>';
					
					if(typeof oArticleData.beddata != 'undefined' && oArticleData.beddata != ''){
						
						jQuery.each(oArticleData.beddata, $.proxy(function(index, item) {
							
							if(typeof item.type != 'undefined' || typeof item.length != 'undefined'  || typeof item.width != 'undefined' ){
					
								sSpecsSleeping += '<div class="preview-spec-line"><div class="preview-spec-label">' + (typeof item.type != 'undefined' && item.type != '' ? item.type + ' (lxb)' : 'Bed (lxb)') + '</div><div class="preview-spec-value">' + (typeof item.length != 'undefined' && item.length != '' ? item.length + ' x ' : '? x ') + (typeof item.width != 'undefined' && item.width != '' ? item.width : '? ') + ' cm.</div></div>';
							}							
							
						}, this));						
					}					
				}
				
				// article specs sanitair
				var sSpecsSanitair = '';
				
				// article specs kitchen
				var sSpecsKitchen = '';
				
				// article specs media
				var sSpecsMedia = '';
				
				// article specs heating
				var sSpecsHeating = '';
				
				// article specs heating
				var sSpecsExterior = '';
				
				// article specs heating
				var sSpecsTechnic = '';
				
				// article specs heating
				var sSpecsCabin = '';
				
				// article specs heating
				var sSpecsSeats = '';
				
				
				// parse divisions / accessoiries
				if(typeof oArticleData.divisions != 'undefined' && oArticleData.divisions != ''){
					
					var sSleepDivisions = '';
					var sSanitairDivisions = '';
					var sKitchenDivisions = '';
					var sMediaDivisions = '';
					var sHeatingDivisions = '';
					var sExteriorDivisions = '';
					var sTechnicDivisions = '';
					var sCabinDivisions = '';
					var sSeatsDivisions = '';
					
					jQuery.each(oArticleData.divisions, $.proxy(function(index, item) {
						
						if(item.category == 'slapen'){
							sSleepDivisions += item.value + ', ';
						} else if(item.category == 'sanitair'){
							sSanitairDivisions += item.value + ', ';
						} else if(item.category == 'keuken'){
							sKitchenDivisions += item.value + ', ';
						} else if(item.category == 'radio/tv'){
							sMediaDivisions += item.value + ', ';
						} else if(item.category == 'verwarming'){
							sHeatingDivisions += item.value + ', ';
						} else if(item.category == 'exterieur/interieur'){
							sExteriorDivisions += item.value + ', ';
						} else if(item.category == 'techniek en veiligheid'){
							sTechnicDivisions += item.value + ', ';
						} else if(item.category == 'onderstel/cabine'){
							sCabinDivisions += item.value + ', ';
						} else if(item.category == 'zitten'){
							sSeatsDivisions += item.value + ', ';
						} 						
					}, this));
					
					if(sSleepDivisions != ''){
						sSpecsSleeping += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sSleepDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sSanitairDivisions != ''){
						sSpecsSanitair += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sSanitairDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sKitchenDivisions != ''){
						sSpecsKitchen += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sKitchenDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sMediaDivisions != ''){
						sSpecsMedia += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sMediaDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sHeatingDivisions != ''){
						sSpecsHeating += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sHeatingDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sExteriorDivisions != ''){
						sSpecsExterior += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sExteriorDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sTechnicDivisions != ''){
						sSpecsTechnic += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sTechnicDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sCabinDivisions != ''){
						sSpecsCabin += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sCabinDivisions.slice(0,-2) + '</div></div>';
					}
					
					if(sSeatsDivisions != ''){
						sSpecsSeats += '<div class="preview-spec-line"><div class="preview-spec-label">Indelingen</div><div class="preview-spec-value">' + sSeatsDivisions.slice(0,-2) + '</div></div>';
					}
				}
				
				if(typeof oArticleData.accessoiries != 'undefined' && oArticleData.accessoiries != ''){
					
					var sSleepAccessoiries = '';
					var sSanitairAccessoiries = '';
					var sKitchenAccessoiries = '';
					var sMediaAccessoiries = '';
					
					var sHeatingAccessoiries = '';
					var sExteriorAccessoiries = '';
					var sTechnicAccessoiries = '';
					var sCabinAccessoiries = '';
					
					jQuery.each(oArticleData.accessoiries, $.proxy(function(index, item) {
						
						if(item.category == 'slaapcomfort'){
							sSleepAccessoiries += item.value + ', ';
						} else if(item.category == 'sanitair'){
							sSanitairAccessoiries += item.value + ', ';
						}  else if(item.category == 'keuken'){
							sKitchenAccessoiries += item.value + ', ';
						}  else if(item.category == 'radio/tv'){
							sMediaAccessoiries += item.value + ', ';
						} else if(item.category == 'verwarming'){
							sHeatingAccessoiries += item.value + ', ';
						} else if(item.category == 'exterieur/interieur'){
							sExteriorAccessoiries += item.value + ', ';
						} else if(item.category == 'techniek en veiligheid'){
							sTechnicAccessoiries += item.value + ', ';
						} else if(item.category == 'onderstel/cabine'){
							sCabinAccessoiries += item.value + ', ';
						} 							
					}, this));
					
					if(sSleepAccessoiries != ''){
						sSpecsSleeping += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sSleepAccessoiries.slice(0,-2) + '</div></div>';
					}
					
					if(sSanitairAccessoiries != ''){
						sSpecsSanitair += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sSanitairAccessoiries.slice(0,-2) + '</div></div>';
					}
					
					if(sKitchenAccessoiries != ''){
						sSpecsKitchen += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sKitchenAccessoiries.slice(0,-2) + '</div></div>';
					}
					
					if(sMediaAccessoiries != ''){
						sSpecsMedia += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sMediaAccessoiries.slice(0,-2) + '</div></div>';
					}

					if(sHeatingAccessoiries != ''){
						sSpecsHeating += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sHeatingAccessoiries.slice(0,-2) + '</div></div>';
					}
					
					if(sExteriorAccessoiries != ''){
						sSpecsExterior += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sExteriorAccessoiries.slice(0,-2) + '</div></div>';
					}
					
					if(sTechnicAccessoiries != ''){
						sSpecsTechnic += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sTechnicAccessoiries.slice(0,-2) + '</div></div>';
					}
					
					if(sCabinAccessoiries != ''){
						sSpecsCabin += '<div class="preview-spec-line"><div class="preview-spec-label">Accessoires</div><div class="preview-spec-value">' + sCabinAccessoiries.slice(0,-2) + '</div></div>';
					}
				}
				
				if(sSpecsSleeping != ''){
					sSpecs += '<h3>Slaapcomfort</h3>' + sSpecsSleeping;
				}				
				
				if(sSpecsSeats != ''){
					sSpecs += '<h3>Zitten</h3>' + sSpecsSeats;
				}				
				
				if(sSpecsSanitair != ''){
					sSpecs += '<h3>Sanitair</h3>' + sSpecsSanitair;
				}				
				
				if(sSpecsKitchen != ''){
					sSpecs += '<h3>Keuken</h3>' + sSpecsKitchen;
				}				
				
				if(sSpecsMedia != ''){
					sSpecs += '<h3>Radio/TV</h3>' + sSpecsMedia;
				}			
				
				if(sSpecsHeating != ''){
					sSpecs += '<h3>Verwarming</h3>' + sSpecsHeating;
				}				
				
				if(sSpecsExterior != ''){
					sSpecs += '<h3>Exterieur/interieur</h3>' + sSpecsExterior;
				}			
				
				if(sSpecsTechnic != ''){
					sSpecs += '<h3>Techniek en veiligheid</h3>' + sSpecsTechnic;
				}		
				
				if(sSpecsCabin != ''){
					sSpecs += '<h3>Onderstel/cabine</h3>' + sSpecsCabin;
				}			
				
				
				if(sSpecs != ''){
					sHTML += '<div class="preview-specs"><h2>Specificaties</h2>' + sSpecs + '</div>';
				}				
				
				// article specs description				
				if(typeof oArticleData.description != 'undefined' && oArticleData.description != '' && oArticleData.description != '<div><br></div>'){
					sDescription += oArticleData.description;
				}
				
				if(typeof oArticleData.comment != 'undefined' && oArticleData.comment != '' && oArticleData.comment != '<div><br></div>'){
					
					if(sDescription != ''){
						sDescription += '<br><br>';						
					}
					
					sDescription += oArticleData.comment;
				}
				
				if(sDescription != ''){
					sHTML += '<div class="preview-description"><h2>Omschrijving</h2><div class="preview-description-content">' + sDescription + '</div></div>';
				}

				sHTML += '</div>';
				
				jQuery('#preview-content').html(sHTML);
				
				setLoadingOverlay('fadeout');
			}
			
		}		
	
	}
	
	function buildFeaturesSynopsis() {
		
		jQuery('#features-set-value').removeClass('verify');
			
		var featuresContent = '';
		var sReturnFeaturesLicense = jQuery('#license-set-value').html();
		var sReturnFeaturesBrand = jQuery('#brand-set-value').html();
		var sReturnFeaturesEngines = jQuery('#engines-set-value').html();
		var sReturnFeaturesModel = jQuery('#model-set-value').html();
		var sReturnFeaturesVersion = jQuery('#version-set-value').html();
		var sReturnFeaturesType = jQuery('#type-set-value').html();
		var sReturnFeaturesAccessoires = jQuery('#accessories-set-value').html();
		var sReturnFeaturesDivisions = jQuery('#divisions-set-value').html();
		var sReturnFeaturesDates = jQuery('#dates-set-value').html();
		var sReturnFeaturesSizes = jQuery('#sizes-set-value').html();
		var sReturnFeaturesSleep = jQuery('#sleep-set-value').html();
		
		if(sReturnFeaturesLicense != '' && typeof sReturnFeaturesLicense != 'undefined' && sReturnFeaturesLicense != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesLicense;
			} else {
				featuresContent += ', ' + sReturnFeaturesLicense;
			}					
		}
		
		if(sReturnFeaturesBrand != '' && typeof sReturnFeaturesBrand != 'undefined' && sReturnFeaturesBrand != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesBrand;
			} else {
				featuresContent += ', ' + sReturnFeaturesBrand;
			}					
		}
		
		if(sReturnFeaturesModel != '' && typeof sReturnFeaturesModel != 'undefined' && sReturnFeaturesModel != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesModel;
			} else {
				featuresContent += ', ' + sReturnFeaturesModel;
			}					
		}
		
		if(sReturnFeaturesVersion != '' && typeof sReturnFeaturesVersion != 'undefined' && sReturnFeaturesVersion != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesVersion;
			} else {
				featuresContent += ', ' + sReturnFeaturesVersion;
			}					
		}
		
		if(sReturnFeaturesEngines != '' && typeof sReturnFeaturesEngines != 'undefined' && sReturnFeaturesEngines != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesEngines;
			} else {
				featuresContent += ', ' + sReturnFeaturesEngines;
			}					
		}
		
		if(sReturnFeaturesType != '' && typeof sReturnFeaturesType != 'undefined' && sReturnFeaturesType != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesType;
			} else {
				featuresContent += ', ' + sReturnFeaturesType;
			}					
		}
		
		if(sReturnFeaturesAccessoires != '' && typeof sReturnFeaturesAccessoires != 'undefined' && sReturnFeaturesAccessoires != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesAccessoires;
			} else {
				featuresContent += ', ' + sReturnFeaturesAccessoires;
			}					
		}
		
		if(sReturnFeaturesDivisions != '' && typeof sReturnFeaturesDivisions != 'undefined' && sReturnFeaturesDivisions != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesDivisions;
			} else {
				featuresContent += ', ' + sReturnFeaturesDivisions;
			}					
		}
		
		if(sReturnFeaturesDates != '' && typeof sReturnFeaturesDates != 'undefined' && sReturnFeaturesDates != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesDates;
			} else {
				featuresContent += ', ' + sReturnFeaturesDates;
			}					
		}	
		
		if(sReturnFeaturesSizes != '' && typeof sReturnFeaturesSizes != 'undefined' && sReturnFeaturesSizes != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesSizes;
			} else {
				featuresContent += ', ' + sReturnFeaturesSizes;
			}					
		}	
		
		if(sReturnFeaturesSleep != '' && typeof sReturnFeaturesSleep != 'undefined' && sReturnFeaturesSleep != 'undefined'){
			if(featuresContent == ''){
				featuresContent += sReturnFeaturesSleep;
			} else {
				featuresContent += ', ' + sReturnFeaturesSleep;
			}					
		}				
			
		if(featuresContent != ''){				
			
			if(featuresContent.length > 100){
				featuresContent = featuresContent.substring(0, 100);
			}
			
			featuresContent = '';
						
			jQuery('.article-input-group.features').addClass('active');
			jQuery('#features-set-value').html(capitalizeFirstLetterOfString(featuresContent));
		} else {
			jQuery('.article-input-group.features').removeClass('active');
			jQuery('#features-set-value').html('');	
		}	
	}
	
	function buildAccessoriesSynopsis(){
		/*
		var sReturnAccessories = '';
					
		jQuery.each(jQuery('input[name="set-accessory"]:checked'), $.proxy(function(index, item) {					
								
			if(sReturnAccessories == ''){
				sReturnAccessories = '1';
			} else {
				return;
			}
			
		}, this));
		*/
		
		sReturnAccessories = sessionStorage.getItem('edit_indicator') !== null && sessionStorage.getItem('edit_indicator') == 'accessories' ? sessionStorage['edit_indicator'] : '';
		
		if(sReturnAccessories == '' && jQuery('.article-input-subgroup.accessories').hasClass('initial')){
			sReturnAccessories = 'filled-no-edit'
		}

		//jQuery('.notice-container').remove();

		if(sReturnAccessories != '' && typeof sReturnAccessories != 'undefined' && sReturnAccessories != 'undefined'){		
			
			//if(sReturnAccessories.length > 100){
			//	sReturnAccessories = sReturnAccessories.substring(0, 100);
			//}
			
			//sReturnAccessories = '';
			
			if(sReturnAccessories == 'filled-no-edit'){
				jQuery('.article-input-subgroup.accessories').addClass('initial').addClass('active');
			} else {			
				articleAccessoriesSynopsis = sReturnAccessories;
				
				jQuery('.article-input-subgroup.accessories').removeClass('initial').addClass('active');
				//jQuery('#accessories-set-value').html(capitalizeFirstLetterOfString(sReturnAccessories));
			}
		} else {				
			jQuery('.article-input-subgroup.accessories').removeClass('initial').removeClass('active');
			//jQuery('#accessories-set-value').html('');
		}
	}
	
	function buildDivisionsSynopsis(){
		/*
		var sReturnDivisions = '';
					
		jQuery.each(jQuery('input[name="set-division"]:checked'), $.proxy(function(index, item) {					
								
			if(sReturnDivisions == '' && typeof sReturnDivisions != 'undefined' && sReturnDivisions != 'undefined'){
				sReturnDivisions = '1';
			} else {
				return;
			}
			
		}, this));
		*/
		
		sReturnDivisions = sessionStorage.getItem('edit_indicator') !== null && sessionStorage.getItem('edit_indicator') == 'divisions' ? sessionStorage['edit_indicator'] : '';
		
		if(sReturnDivisions == '' && jQuery('.article-input-subgroup.divisions').hasClass('initial')){
			sReturnDivisions = 'filled-no-edit'
		}

		//jQuery('.notice-container').remove();

		if(sReturnDivisions != ''){		
			
			//if(sReturnDivisions.length > 100){
			//	sReturnDivisions = sReturnDivisions.substring(0, 100);
			//}
			
			//sReturnDivisions = '';
			
			if(sReturnDivisions == 'filled-no-edit'){
				jQuery('.article-input-subgroup.divisions').addClass('initial').addClass('active');
			} else  {
						
				articleDivisionsSynopsis = sReturnDivisions;
				
				jQuery('.article-input-subgroup.divisions').removeClass('initial').addClass('active');
				//jQuery('#divisions-set-value').html(capitalizeFirstLetterOfString(sReturnDivisions));
			}
		} else {				
			jQuery('.article-input-subgroup.divisions').removeClass('initial').removeClass('active');
			//jQuery('#divisions-set-value').html('');
		}		
	}
	
	function buildDatesSynopsis() {

		/*
		var sReturnDates = '';								
		var sReturnDatesConstructionyear = jQuery('#set-constructionyear').val();
		var sReturnDatesConstructionmonth = jQuery('input[name="set-constructionmonth"]:checked').val();
		var sReturnDatesModelyear = jQuery('#set-modelyear').val();
		var sReturnDatesPartA = jQuery('#set-part-a').val();
		var sReturnDatesFirstNL = jQuery('#set-first-nl').val();
							
		if(sReturnDatesConstructionyear != '' && typeof sReturnDatesConstructionyear != 'undefined' && sReturnDatesConstructionyear != 'undefined'){
			sReturnDates = '1';
		}
		if(sReturnDatesConstructionmonth != '' && typeof sReturnDatesConstructionmonth != 'undefined' && sReturnDatesConstructionmonth != 'undefined'){
			sReturnDates = '1';
		}
		if(sReturnDatesModelyear != '' && typeof sReturnDatesModelyear != 'undefined' && sReturnDatesModelyear != 'undefined'){
			sReturnDates = '1';
		}
		if(sReturnDatesPartA != '' && typeof sReturnDatesPartA != 'undefined' && sReturnDatesPartA != 'undefined'){
			sReturnDates = '1';
		}
		if(sReturnDatesFirstNL != '' && typeof sReturnDatesFirstNL != 'undefined' && sReturnDatesFirstNL != 'undefined'){
			sReturnDates = '1';
		}
		*/		
		//jQuery('.notice-container').remove();
		
		sReturnDates = sessionStorage.getItem('edit_indicator') !== null && sessionStorage.getItem('edit_indicator') == 'dates' ? sessionStorage['edit_indicator'] : '';
		
		if(sReturnDates == '' && jQuery('.article-input-subgroup.dates').hasClass('initial')){
			sReturnDates = 'filled-no-edit'
		}

		if(sReturnDates != ''){		
			
			//if(sReturnDates.length > 100){
			//	sReturnDates = sReturnDates.substring(0, 100);
			//}

			//sReturnDates = '';
			
			if(sReturnDates == 'filled-no-edit'){
				jQuery('.article-input-subgroup.dates').addClass('initial').addClass('active');
			} else {
				
				articleDatesSynopsis = sReturnDates;
						
				jQuery('.article-input-subgroup.dates').removeClass('initial').addClass('active');
				//jQuery('#dates-set-value').html(capitalizeFirstLetterOfString(sReturnDates));
			}
		} else {				
			jQuery('.article-input-subgroup.dates').removeClass('initial').removeClass('active');
			//jQuery('#dates-set-value').html('');
		}
	}
	
	function buildEnginesSynopsis(){
		/*
		var sReturnEngine = '';								
		var sReturnEngineBoatNumberOfEngines = jQuery('input[name="set-engines-boat"]:checked').val();	
		var sReturnEngineBoatEngineFuel = jQuery('input[name="set-boat-engine-fuel"]:checked').val();	
		var sReturnEngineBoatEngineType = jQuery('#set-boat-engine-type').val();
		var sReturnEngineBoatEngineStartsystem = jQuery('input[name="set-boat-engine-startsystem"]:checked').val();	
		var sReturnEngineBoatEngineBrand = jQuery('#set-boat-engine-brand').val();
		var sReturnEngineBoatEngineModel = jQuery('#set-boat-engine-model').val();	
		var sReturnEngineBoatEnginePower = jQuery('#set-boat-engine-power').val();	
		var sReturnEngineBoatEngineAccu = jQuery('#set-boat-engine-accu').val();	
		var sReturnEngineBoatEngineHours = jQuery('#set-boat-engine-hours').val();
		var sReturnEngineBoatEngineCruisingSpeed = jQuery('#set-boat-engine-cruising-speed').val();	
		var sReturnEngineBoatEngineTankCapacity = jQuery('#set-boat-engine-tank-capacity').val();
		var sReturnEngineBoatEngineCyliners = jQuery('#set-boat-engine-cylinders').val();
		var sReturnEngineBoatEngineSize = jQuery('#set-boat-engine-size').val();
		var sReturnEngineBoatEngineDryWeight = jQuery('#set-boat-engine-dry-weight').val();
		
		if(sReturnEngineBoatEngineDryWeight != '' && typeof sReturnEngineBoatEngineDryWeight != 'undefined' && sReturnEngineBoatEngineDryWeight != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineSize != '' && typeof sReturnEngineBoatEngineSize != 'undefined' && sReturnEngineBoatEngineSize != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineCyliners != '' && typeof sReturnEngineBoatEngineCyliners != 'undefined' && sReturnEngineBoatEngineCyliners != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineTankCapacity != '' && typeof sReturnEngineBoatEngineTankCapacity != 'undefined' && sReturnEngineBoatEngineTankCapacity != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineCruisingSpeed != '' && typeof sReturnEngineBoatEngineCruisingSpeed != 'undefined' && sReturnEngineBoatEngineCruisingSpeed != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineHours != '' && typeof sReturnEngineBoatEngineHours != 'undefined' && sReturnEngineBoatEngineHours != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineAccu != '' && typeof sReturnEngineBoatEngineAccu != 'undefined' && sReturnEngineBoatEngineAccu != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEnginePower != '' && typeof sReturnEngineBoatEnginePower != 'undefined' && sReturnEngineBoatEnginePower != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineModel != '' && typeof sReturnEngineBoatEngineModel != 'undefined' && sReturnEngineBoatEngineModel != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineBrand != '' && typeof sReturnEngineBoatEngineBrand != 'undefined' && sReturnEngineBoatEngineBrand != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineStartsystem != '' && typeof sReturnEngineBoatEngineStartsystem != 'undefined' && sReturnEngineBoatEngineStartsystem != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineType != '' && typeof sReturnEngineBoatEngineType != 'undefined' && sReturnEngineBoatEngineType != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatEngineFuel != '' && typeof sReturnEngineBoatEngineFuel != 'undefined' && sReturnEngineBoatEngineFuel != 'undefined'){
			sReturnEngine = '1';
		}
		if(sReturnEngineBoatNumberOfEngines != '' && typeof sReturnEngineBoatNumberOfEngines != 'undefined' && sReturnEngineBoatNumberOfEngines != 'undefined'){
			sReturnEngine = '1';
		}
		*/
		
		sReturnEngine = sessionStorage.getItem('edit_indicator') !== null && sessionStorage.getItem('edit_indicator') == 'engines' ? sessionStorage['edit_indicator'] : '';
		
		if(sReturnEngine == '' && jQuery('.article-input-subgroup.engines').hasClass('initial')){
			sReturnEngine = 'filled-no-edit'
		}
		
		//jQuery('.notice-container').remove();

		if(sReturnEngine != ''){		
			
			//if(sReturnEngine.length > 100){
			//	sReturnEngine = sReturnEngine.substring(0, 100);
			//}

			//sReturnEngine = '';
			
			if(sReturnEngine == 'filled-no-edit'){
				jQuery('.article-input-subgroup.engines').addClass('initial').addClass('active');
			} else {
						
				articleEnginesSynopsis = sReturnEngine;
				
				jQuery('.article-input-subgroup.engines').removeClass('initial').addClass('active');
				//jQuery('#engines-set-value').html(capitalizeFirstLetterOfString(sReturnEngine));
			}
		} else {				
			jQuery('.article-input-subgroup.engines').removeClass('initial').removeClass('active');
			//jQuery('#engines-set-value').html('');
		}

	}
	
	function buildTypeSynopsis(){				
				
		/*
		var sReturnType = '';								
		var sReturnTypeType = jQuery('#set-type').val();
		var sReturnTypeToevoeging = jQuery('#set-toevoeging').val();
		var sReturnTypeChassisnummer = jQuery('#set-chassisnummer').val();
		var sReturnTypeMileage = jQuery('#set-mileage').val();				
		var sReturnTypeSubcategory = jQuery('input[name="set-subcategory"]:checked').val();					
		var sReturnTypeCondition = jQuery('input[name="set-condition"]:checked').val();					
		var sReturnTypeNAP = jQuery('#set-nap').prop('checked') ? 'NAP' : false;
		var sReturnTypeMetallic = jQuery('#set-metallic').prop('checked') ? 'metallic lak' : false;
		var sReturnTypeSuitableForDisabledPeople = jQuery('#set-suitableForDisabledPeople').prop('checked') ? 'toegankelijk mindervaliden' : false;
		var sReturnTypeDamage = jQuery('#set-damage').prop('checked') ? 'schadevoertuig' : false;
		var sReturnTypeDemo = jQuery('#set-demo').prop('checked') ? 'demovoertuig' : false;
		var sReturnTypeExRental = jQuery('#set-exRental').prop('checked') ? 'ex verhuur' : false;
		var sReturnTypePossibleRental = jQuery('#set-possibleRental').prop('checked') ? 'verhuur mogelijk' : false;
		var sReturnTypeHailDamage = jQuery('#set-hailDamage').prop('checked') ? 'hagelschade' : false;
		var sReturnTypeMaintenanceBooklets = jQuery('#set-maintenanceBooklets').prop('checked') ? 'hagelschade' : false;
		var sReturnTypeParticulateFilter = jQuery('#set-particulateFilter').prop('checked') ? 'roetfilter' : false;
		var sReturnTypeCarBrand = jQuery('#set-car-brand').val();
		var sReturnTypeFuel = jQuery('input[name="set-fuel"]:checked').val();	
		var sReturnTypeTransmission = jQuery('input[name="set-transmission"]:checked').val();	
		var sReturnTypeEuroClass = jQuery('input[name="set-euro-class"]:checked').val();					
		var sReturnTypeSeats = jQuery('input[name="set-seats"]:checked').val();					
		var sReturnTypeSeatbelts = jQuery('input[name="set-seatbelts"]:checked').val();					
		var sReturnTypeOwners = jQuery('input[name="set-owners"]:checked').val();					
		var sReturnTypePower = jQuery('#set-power').val();
		var sReturnTypeWalltype = jQuery('input[name="set-walltype"]:checked').val();					
		var sReturnTypeMaterial = jQuery('input[name="set-material"]:checked').val();					
		var sReturnTypeMaterialTentTrailer = jQuery('input[name="set-material-tenttrailer"]:checked').val();					
		var sReturnTypeColor = jQuery('input[name="set-color"]:checked').val();					
		var sReturnTypeNumberOfDoors = jQuery('input[name="set-number-of-doors"]:checked').val();					
		var sReturnTypeDoorTypes = jQuery('input[name="set-door-types"]:checked').val();					
		var sReturnTypePlug = jQuery('input[name="set-plug"]:checked').val();					
		var sReturnTypeKipAngle = jQuery('#set-kip-angle').val();					
		var sReturnTypeFloorMaterial = jQuery('#set-floor-material').val();					
		var sReturnTypeWallMaterial = jQuery('#set-wall-material').val();					
		var sReturnTypeAxles = jQuery('input[name="set-axles"]:checked').val();					
		
		var sReturnTypeBoatTrailerPlug = jQuery('input[name="set-boattrailer-plug"]:checked').val();					
		var sReturnTypeBoatTrailerAxles = jQuery('input[name="set-boattrailer-axles"]:checked').val();					
		
		var sReturnTypeTrailerBoat = jQuery('#set-trailer-boat').prop('checked') ? 'Trailer inclusief' : false;
		var sReturnTypeModelBoat = jQuery('#set-model-boat').val();
		var sReturnTypeTitleBoat = jQuery('#set-title-boat').val();
		var sReturnTypeLigplaatsBoat = jQuery('#set-ligplaats-boat').val();
		var sReturnTypePersonsBoat = jQuery('input[name="set-persons-boat"]:checked').val();
		var sReturnTypeMaterialBoat = jQuery('input[name="set-material-boat"]:checked').val();
		var sReturnTypeSizeBoat = jQuery('input[name="set-size-boat"]:checked').val();
		
		var sReturnTypeEngineFuel = jQuery('input[name="set-engine-fuel"]:checked').val();	
		var sReturnTypeEngineTailLength = jQuery('input[name="set-engine-tail-length"]:checked').val();	
		var sReturnTypeEngineSteering = jQuery('input[name="set-engine-steering"]:checked').val();	
		var sReturnTypeEngineStartsystem = jQuery('input[name="set-engine-startsystem"]:checked').val();	
		
		if(sReturnTypeType != '' && typeof sReturnTypeType != 'undefined' && sReturnTypeType != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeCondition != '' && typeof sReturnTypeCondition != 'undefined' && sReturnTypeCondition != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeSubcategory != '' && typeof sReturnTypeSubcategory != 'undefined' && sReturnTypeSubcategory != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeToevoeging != '' && typeof sReturnTypeToevoeging != 'undefined' && sReturnTypeToevoeging != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeChassisnummer != '' && typeof sReturnTypeChassisnummer != 'undefined' && sReturnTypeChassisnummer != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeLigplaatsBoat != '' && typeof sReturnTypeLigplaatsBoat != 'undefined' && sReturnTypeLigplaatsBoat != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeModelBoat != '' && typeof sReturnTypeModelBoat != 'undefined' && sReturnTypeModelBoat != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeTitleBoat != '' && typeof sReturnTypeTitleBoat != 'undefined' && sReturnTypeTitleBoat != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeKipAngle != '' && typeof sReturnTypeKipAngle != 'undefined' && sReturnTypeKipAngle != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeMileage != '' && typeof sReturnTypeMileage != 'undefined' && sReturnTypeMileage != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeNAP != '' && typeof sReturnTypeNAP != 'undefined' && sReturnTypeNAP != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeTrailerBoat != '' && typeof sReturnTypeTrailerBoat != 'undefined' && sReturnTypeTrailerBoat != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeParticulateFilter != '' && typeof sReturnTypeParticulateFilter != 'undefined' && sReturnTypeParticulateFilter != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeHailDamage != '' && typeof sReturnTypeHailDamage != 'undefined' && sReturnTypeHailDamage != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeDamage != '' && typeof sReturnTypeDamage != 'undefined' && sReturnTypeDamage != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeDemo != '' && typeof sReturnTypeDemo != 'undefined' && sReturnTypeDemo != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeExRental != '' && typeof sReturnTypeExRental != 'undefined' && sReturnTypeExRental != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypePossibleRental != '' && typeof sReturnTypePossibleRental != 'undefined' && sReturnTypePossibleRental != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeSuitableForDisabledPeople != '' && typeof sReturnTypeSuitableForDisabledPeople != 'undefined' && sReturnTypeSuitableForDisabledPeople != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeMaintenanceBooklets != '' && typeof sReturnTypeMaintenanceBooklets != 'undefined' && sReturnTypeMaintenanceBooklets != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeMetallic != '' && typeof sReturnTypeMetallic != 'undefined' && sReturnTypeMetallic != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeCarBrand != '' && typeof sReturnTypeCarBrand != 'undefined' && sReturnTypeCarBrand != 'undefined'){
			sReturnType = '1';
		}			
		if(sReturnTypeFuel != '' && typeof sReturnTypeFuel != 'undefined' && sReturnTypeFuel != 'undefined'){
			sReturnType = '1';
		}				
		if(sReturnTypeEngineFuel != '' && typeof sReturnTypeEngineFuel != 'undefined' && sReturnTypeEngineFuel != 'undefined'){
			sReturnType = '1';
		}				
		if(sReturnTypeTransmission != '' && typeof sReturnTypeTransmission != 'undefined' && sReturnTypeTransmission != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeEuroClass != '' && typeof sReturnTypeEuroClass != 'undefined' && sReturnTypeEuroClass != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeSeats != '' && typeof sReturnTypeSeats != 'undefined' && sReturnTypeSeats != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypePersonsBoat != '' && typeof sReturnTypePersonsBoat != 'undefined' && sReturnTypePersonsBoat != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeSeatbelts != '' && typeof sReturnTypeSeatbelts != 'undefined' && sReturnTypeSeatbelts != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeOwners != '' && typeof sReturnTypeOwners != 'undefined' && sReturnTypeOwners != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypePower != '' && typeof sReturnTypePower != 'undefined' && sReturnTypePower != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeWalltype != '' && typeof sReturnTypeWalltype != 'undefined' && sReturnTypeWalltype != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeMaterialBoat != '' && typeof sReturnTypeMaterialBoat != 'undefined' && sReturnTypeMaterialBoat != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeSizeBoat != '' && typeof sReturnTypeSizeBoat != 'undefined' && sReturnTypeSizeBoat != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeMaterial != '' && typeof sReturnTypeMaterial != 'undefined' && sReturnTypeMaterial != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeColor != '' && typeof sReturnTypeColor != 'undefined' && sReturnTypeColor != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeNumberOfDoors != '' && typeof sReturnTypeNumberOfDoors != 'undefined' && sReturnTypeNumberOfDoors != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypePlug != '' && typeof sReturnTypePlug != 'undefined' && sReturnTypePlug != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeFloorMaterial != '' && typeof sReturnTypeFloorMaterial != 'undefined' && sReturnTypeFloorMaterial != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeWallMaterial != '' && typeof sReturnTypeWallMaterial != 'undefined' && sReturnTypeWallMaterial != 'undefined'){
			sReturnType = '1';
		}
		if(sReturnTypeDoorTypes != '' && typeof sReturnTypeDoorTypes != 'undefined' && sReturnTypeDoorTypes != 'undefined'){
			sReturnType = '1';
		}
		*/
		
		sReturnType = sessionStorage.getItem('edit_indicator') !== null && sessionStorage.getItem('edit_indicator') == 'type' ? sessionStorage['edit_indicator'] : '';
		
		if(sReturnType == '' && jQuery('.article-input-subgroup.type').hasClass('initial')){
			sReturnType = 'filled-no-edit'
		}	

		//jQuery('.notice-container').remove();

		if(sReturnType != ''){		
			
			//if(sReturnType.length > 100){
				//sReturnType = sReturnType.substring(0, 100);
			//}

			//sReturnType = '';
			
			if(sReturnType == 'filled-no-edit'){
				jQuery('.article-input-subgroup.type').addClass('initial').addClass('active');
			} else {
			
				//articleTypeSynopsis = sReturnType;
				
				jQuery('.article-input-subgroup.type').removeClass('initial').addClass('active');
				//jQuery('#type-set-value').html(capitalizeFirstLetterOfString(sReturnType));
			}
		} else {				
			jQuery('.article-input-subgroup.type').removeClass('initial').removeClass('active');
			//jQuery('#type-set-value').html('');
		}
	}
	
	function buildSleepSynopsis(){
		/*
		var sReturnSleep = '';
		var sReturnSleepSleepingPlaces = jQuery('#set-sleepingplaces').val();
		var sReturnSleepBedrooms = jQuery('input[name="set-bedrooms"]:checked').val();
		var sReturnSleepBedsBoat = jQuery('input[name="set-beds-boat"]:checked').val();
		
		var sReturnSleepBeds = 0;
				
		jQuery.each(jQuery('.sleep-container-bed'), $.proxy(function(index, item) {	
								
			var thisWidth = jQuery(item).find('.bed-width').val();
			var thisLength = jQuery(item).find('.bed-length').val();
			var thisType = jQuery(item).find('.bed-type').val();
			
			if((typeof thisWidth != 'undefined' && thisWidth != '') || (typeof thisHeight != 'undefined' && thisHeight != '') || (typeof thisType != 'undefined' && thisType != '')){
				sReturnSleepBeds++;
			}
										
		}, this));	
		
		
		if(sReturnSleepSleepingPlaces != '' && typeof sReturnSleepSleepingPlaces != 'undefined' && sReturnSleepSleepingPlaces != 'undefined'){
			 sReturnSleep = '1';		
		}
		if(sReturnSleepBedrooms != '' && typeof sReturnSleepBedrooms != 'undefined' && sReturnSleepBedrooms != 'undefined'){
			sReturnSleep = '1';		
		}
		if(sReturnSleepBedsBoat != '' && typeof sReturnSleepBedsBoat != 'undefined' && sReturnSleepBedsBoat != 'undefined'){
			sReturnSleep = '1';		
		}
		
		if(sReturnSleepBeds != '' && sReturnSleepBeds > 0 && typeof sReturnSleepBeds != 'undefined' && sReturnSleepBeds != 'undefined'){
			sReturnSleep = '1';		
		}
		*/

		sReturnSleep = sessionStorage.getItem('edit_indicator') !== null && sessionStorage.getItem('edit_indicator') == 'sleep' ? sessionStorage['edit_indicator'] : '';
		
		if(sReturnSleep == '' && jQuery('.article-input-subgroup.sleep').hasClass('initial')){
			sReturnSleep = 'filled-no-edit'
		}


		//jQuery('.notice-container').remove();

		if(sReturnSleep != ''){		
			
			//if(sReturnSleep.length > 100){
			//	sReturnSleep = sReturnSleep.substring(0, 100);
			//}
			
			//sReturnSleep = '';			
			
			if(sReturnSleep == 'filled-no-edit'){
				jQuery('.article-input-subgroup.sleep').addClass('initial').addClass('active');
			} else {						
				
				articleBedsSynopsis = sReturnSleep;
				
				jQuery('.article-input-subgroup.sleep').removeClass('initial').addClass('active');
				//jQuery('#sleep-set-value').html(capitalizeFirstLetterOfString(sReturnSleep));
			}
		} else {				
			jQuery('.article-input-subgroup.sleep').removeClass('initial').removeClass('active');
			//jQuery('#sleep-set-value').html('');
		}
	}
	
	function buildSizesSynopsis(){									
		/*
		var sReturnSizes = '';								
		var sReturnSizesConstructionLength = jQuery('#set-construction-length').val();
		var sReturnSizesTotalLength = jQuery('#set-total-length').val();
		var sReturnSizesTrailerTotalLength = jQuery('#set-trailer-total-length').val();
		var sReturnSizesWidth = jQuery('#set-width').val();
		var sReturnSizesHeight = jQuery('#set-height').val();
		var sReturnSizesHeadroom = jQuery('#set-headroom').val();
		var sReturnSizesEmptyWeight = jQuery('#set-empty-weight').val();
		var sReturnSizesRoadworthyWeight = jQuery('#set-roadworthy-weight').val();
		var sReturnSizesMaxWeight = jQuery('#set-max-weight').val();
		var sReturnSizesCapacity = jQuery('#set-capacity').val();
		
		var sReturnSizesLengthContainer = jQuery('#set-container-length').val();
		var sReturnSizesLengthDrawbar = jQuery('#set-drawbar-length').val();
		var sReturnSizesLengthContainer = jQuery('#set-container-length').val();
		var sReturnSizesWidthTotal = jQuery('#set-total-width').val();
		var sReturnSizesWidthContainer = jQuery('#set-container-width').val();
		var sReturnSizesLoadingPlatformHeight = jQuery('#set-loading-platform-height').val();
		var sReturnSizesCouplerHeight = jQuery('#set-coupler-height').val();
		var sReturnSizesLadderRackHeight = jQuery('#set-ladder-rack-height').val();
		var sReturnSizesBordersHeight = jQuery('#set-borders-height').val();
		var sReturnSizesTotalHeight = jQuery('#set-total-height').val();
		var sReturnSizesBasePlateHeight = jQuery('#set-base-plate-height').val();
		var sReturnSizesInternalHeight = jQuery('#set-internal-height').val();
		var sReturnSizesTireSize = jQuery('#set-tire-size').val();
		var sReturnSizesVolume= jQuery('#set-volume').val();
		var sReturnSizesDepth= jQuery('#set-depth').val();
		var sReturnSizesVerticalclearance= jQuery('#set-verticalclearance').val();
				
		if(sReturnSizesConstructionLength != '' && typeof sReturnSizesConstructionLength != 'undefined' && sReturnSizesConstructionLength != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesTotalLength != '' && typeof sReturnSizesTotalLength != 'undefined' && sReturnSizesTotalLength != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesWidth != '' && typeof sReturnSizesWidth != 'undefined' && sReturnSizesWidth != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesHeight != '' && typeof sReturnSizesHeight != 'undefined' && sReturnSizesHeight != 'undefined'){
			sReturnSizes = '1';
		}				
		if(sReturnSizesHeadroom != '' && typeof sReturnSizesHeadroom != 'undefined' && sReturnSizesHeadroom != 'undefined'){
			sReturnSizes = '1';
		}				
		if(sReturnSizesEmptyWeight != '' && typeof sReturnSizesEmptyWeight != 'undefined' && sReturnSizesEmptyWeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesRoadworthyWeight != '' && typeof sReturnSizesRoadworthyWeight != 'undefined' && sReturnSizesRoadworthyWeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesMaxWeight != '' && typeof sReturnSizesMaxWeight != 'undefined' && sReturnSizesMaxWeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesCapacity != '' && typeof sReturnSizesCapacity != 'undefined' && sReturnSizesCapacity != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesLengthContainer != '' && typeof sReturnSizesLengthContainer != 'undefined' && sReturnSizesLengthContainer != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesLengthDrawbar != '' && typeof sReturnSizesLengthDrawbar != 'undefined' && sReturnSizesLengthDrawbar != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesLengthContainer != '' && typeof sReturnSizesLengthContainer != 'undefined' && sReturnSizesLengthContainer != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesWidthTotal != '' && typeof sReturnSizesWidthTotal != 'undefined' && sReturnSizesWidthTotal != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesWidthContainer != '' && typeof sReturnSizesWidthContainer != 'undefined' && sReturnSizesWidthContainer != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesLoadingPlatformHeight != '' && typeof sReturnSizesLoadingPlatformHeight != 'undefined' && sReturnSizesLoadingPlatformHeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesCouplerHeight != '' && typeof sReturnSizesCouplerHeight != 'undefined' && sReturnSizesCouplerHeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesLadderRackHeight != '' && typeof sReturnSizesLadderRackHeight != 'undefined' && sReturnSizesLadderRackHeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesBordersHeight != '' && typeof sReturnSizesBordersHeight != 'undefined' && sReturnSizesBordersHeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesTotalHeight != '' && typeof sReturnSizesTotalHeight != 'undefined' && sReturnSizesTotalHeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesBasePlateHeight != '' && typeof sReturnSizesBasePlateHeight != 'undefined' && sReturnSizesBasePlateHeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesInternalHeight != '' && typeof sReturnSizesInternalHeight != 'undefined' && sReturnSizesInternalHeight != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesTireSize != '' && typeof sReturnSizesTireSize != 'undefined' && sReturnSizesTireSize != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesVolume != '' && typeof sReturnSizesVolume != 'undefined' && sReturnSizesVolume != 'undefined'){
			sReturnSizes = '1';
		}
		if(sReturnSizesDepth != '' && typeof sReturnSizesDepth != 'undefined' && sReturnSizesDepth != 'undefined'){
			sReturnSizes = '1';
		}	
		if(sReturnSizesVerticalclearance != '' && typeof sReturnSizesVerticalclearance != 'undefined' && sReturnSizesVerticalclearance != 'undefined'){
			sReturnSizes = '1';
		}
		*/

		sReturnSizes = sessionStorage.getItem('edit_indicator') !== null && sessionStorage.getItem('edit_indicator') == 'sizes' ? sessionStorage['edit_indicator'] : '';
		
		if(sReturnSizes == '' && jQuery('.article-input-subgroup.sizes').hasClass('initial')){
			sReturnSizes = 'filled-no-edit'
		}

		//jQuery('.notice-container').remove();

		if(sReturnSizes != ''){		
			
			//if(sReturnSizes.length > 100){
			//	sReturnSizes = sReturnSizes.substring(0, 100);
			//}
			
			//sReturnSizes = '';
			
			if(sReturnSizes == 'filled-no-edit'){
				jQuery('.article-input-subgroup.accessories').addClass('initial').addClass('active');
			} else {
				
				articleSizesSynopsis = sReturnSizes;
						
				jQuery('.article-input-subgroup.sizes').removeClass('initial').addClass('active');
				//jQuery('#sizes-set-value').html(capitalizeFirstLetterOfString(sReturnSizes));
			}
		} else {				
			jQuery('.article-input-subgroup.sizes').removeClass('initial').removeClass('active');
			//jQuery('#sizes-set-value').html('');
		}
	}
	
	function buildLicenseSynopsis(){
					
		var sReturnLicense = '';								
		var sReturnLicenseplate = jQuery('#set-license').val();
		
		if(sReturnLicenseplate != '' && typeof sReturnLicenseplate != 'undefined' && sReturnLicenseplate != 'undefined'){
			
			sessionStorage['current_license'] = sReturnLicenseplate;
			
			sReturnLicense = '1';
		} else {
			sessionStorage.removeItem('current_license');
		}
		
		//jQuery('.notice-container').remove();

		if(sReturnLicense != ''){		
			
			if(sReturnLicense.length > 100){
				sReturnLicense = sReturnLicense.substring(0, 100);
			}
			
			sReturnLicense = '';
			
			jQuery('.article-input-subgroup.license').addClass('active');
			jQuery('#license-set-value').html(capitalizeFirstLetterOfString(sReturnLicense));
		} else {				
			jQuery('.article-input-subgroup.license').removeClass('active');
			jQuery('#license-set-value').html('');
		}
	}
	
	jQuery(document).on("click",".to-ad",function(e) {
		
		jQuery('body').removeClass('has-active-sub');				
		jQuery('body').removeClass('license-active');
		jQuery('body').removeClass('engines-active');
		jQuery('body').removeClass('brand-active');
		jQuery('body').removeClass('model-active');
		jQuery('body').removeClass('version-active');
		jQuery('body').removeClass('type-active');
		jQuery('body').removeClass('accessories-active');
		jQuery('body').removeClass('divisions-active');
		jQuery('body').removeClass('dates-active');
		jQuery('body').removeClass('sizes-active');
		jQuery('body').removeClass('sleep-active');
		jQuery('body').removeClass('marktplaatsdescription-active');
		jQuery('body').removeClass('has-active-sub');
		jQuery('body').removeClass('status-active');
		jQuery('body').removeClass('photos-active');
		jQuery('body').removeClass('category-active');
		jQuery('body').removeClass('features-active');
		jQuery('body').removeClass('description-active');
		jQuery('body').removeClass('prices-active');
		jQuery('body').removeClass('marktplaats-active');
		
		jQuery('.input-active').removeClass('input-active');
		
		sessionStorage.removeItem('active_group');
		sessionStorage.removeItem('active_sub_group');
		sessionStorage.removeItem('active_sub_sub_group');
		
		var sTitleToSet = 'Advertentie aanmaken';
				
		if(articleID != ''){			
			sTitleToSet = 'Advertentie bewerken';
		}
		
		jQuery('#title-container').html(sTitleToSet);
		
	});	
	
	jQuery(document).on("click",".save-item",function(e) {
		
		setLoadingOverlay('fadein');
		
		$.post(baseHref() + 'article', { 

			module: 'saveArticle',
			acticleData: jQuery.getArticleData()
			
		}, function(data) {			
			
			var oSaveData = $.parseJSON(data);
			
			if(oSaveData.errors != ''){
				
				var sErrors = '';
				
				jQuery.each(oSaveData.errors, $.proxy(function(index, item) {
					
					if(item == 'missing-prices'){						
						item = 'Prijzen niet ingevuld';
					} else if(item == 'missing-brand'){
						item = 'Merk niet ingevuld';
					} else if(item == 'missing-category'){						
						item = 'Categorie niet ingevuld';
					} else if(item == 'missing-specsboat-engine-type'){						
						item = 'Type motor niet ingevuld';
					} else if(item == 'missing-specsboat-engine-brand'){						
						item = 'Merk motor niet ingevuld';
					} else if(item == 'missing-specsboat-engine-fuel'){						
						item = 'Brandstof niet ingevuld';
					}					
					
					sErrors += '- ' + item + '<br>';
					
				}, this));
				
				var popupSaveErrorContent = '<div class="concept-confirmation" id="concept-confirmation">';
					popupSaveErrorContent += '<h2 id="concept-confirmation-title">Fouten bij opslaan</h2>';
					popupSaveErrorContent += '<span class="title">Wij hebben de volgende fouten geconstateerd bij het opslaan van dit artikel. Herstel deze fouten en bewaar nogmaals.<br><br>' + sErrors + '</span>';
					popupSaveErrorContent += '<span class="continue" onclick="jQuery.acceptErrors();">Ga verder</span>';
				popupSaveErrorContent += '</div>"';
		
				oLightboxSaveErrorArticle = SimpleLightbox.open({
					closeOnOverlayClick: false,
					closeOnEscapeKey: false,
					content: popupSaveErrorContent,
					beforeClose: function(){
						setLoadingOverlay('fadeout');						
					}
				});
			} else {
				
				jQuery.clearConcept();
								
				sessionStorage.removeItem('active_sub_sub_group');
				sessionStorage.removeItem('active_sub_group');				
				sessionStorage.removeItem('active_group');
				sessionStorage.removeItem('active_article');
				sessionStorage.removeItem('article_set');
				sessionStorage.removeItem('active_succes');
				
				if(typeof oSaveData.article != 'undefined' && oSaveData.article != ''){	
					sessionStorage['active_succes'] = oSaveData.article;
					sessionStorage.removeItem('temp_article');
					window.location.replace('/edit/' + oSaveData.article);
				} else {
					sessionStorage.removeItem('temp_article');
					window.location.replace('/');					
				}								
			}		
		});
		
		
	});
	
	
	jQuery(document).on("click",".sort-images-status",function(e) {
		if(jQuery('.sort-images-status').hasClass('active')){
			jQuery('.sort-images-status').removeClass('active');
			jQuery('#sort-images-status-message').html('Foto\'s sorteren?');
			
			if(jQuery("#images").length){		
				jQuery( "#images" ).sortable( "option", "disabled", true );
			}				
		} else {
			jQuery('.sort-images-status').addClass('active');
			jQuery('#sort-images-status-message').html('Sorteerbaar');			

			if(jQuery("#images").length){		
				jQuery( "#images" ).sortable( "option", "disabled", false );
			}
		}
	});
	
	jQuery(document).on("click",".generate-description",function(e) {
		
		setLoadingOverlay('fadein');
		
		$.post(baseHref() + 'article', { 

			module: 'initDescriptionGeneration'
			
		}, function(data) {
			
			var oSaveData = $.parseJSON(data);
			
			if(oSaveData.errors != false){
				
				var popupSaveErrorContent = '<div class="concept-confirmation" id="concept-confirmation">';
					popupSaveErrorContent += '<h2 id="concept-confirmation-title">Omschrijving genereren</h2>';
					
					if(oSaveData.errors == 'insufficient'){						
						popupSaveErrorContent += '<span class="title">U heeft onvoldoende budget om een omschrijving te kunnen genereren.</span>';						
					} else {
						popupSaveErrorContent += '<span class="title">Fout bij het genereren van een omschrijving.</span>';						
					}
					
					popupSaveErrorContent += '<span class="continue" onclick="jQuery.acceptErrors();">Ga verder</span>';
				popupSaveErrorContent += '</div>"';
		
				oLightboxSaveErrorArticle = SimpleLightbox.open({
					closeOnOverlayClick: false,
					closeOnEscapeKey: false,
					content: popupSaveErrorContent,
					beforeClose: function(){
						setLoadingOverlay('fadeout');						
					}
				});
			} else {
								
				var sGenerateDescriptionMessage = 'Er is iets mis gegaan bij het ophalen de omschrijving.<br>Probeert u het later nogmaals, of neem contact op met ons op telefoonnummer 079 342 94 99.<br><br>Onze excuses voor het ongemak.<div class="auto-description-footer">Er zijn geen kosten in rekening gebracht.';
				
				if(oSaveData.data.reason == 'credits'){
					if(oSaveData.data.allowedCredits == 'abo'){
						
						sGenerateDescriptionMessage = 'U betaalt omschrijvingen in abonnementsvorm. Wij brengen geen kosten per omschrijving in rekening.<br><br>Nu een omschrijvingstekst genereren?';
						
						if(oSaveData.data.realm == 'boat'){
							sGenerateDescriptionMessage += '<br><br>Let op: deze actie kan tot 2 minuten duren!';
						}
						
					} else if(oSaveData.data.allowedCredits == 'onbeperkt'){							
						
						sGenerateDescriptionMessage = 'U heeft onbeperkt omschrijvingen gratis van OVIS<br><br>Nu een omschrijvingstekst genereren?';
												
					} else {

						sGenerateDescriptionMessage = 'Ter introductie krijgt u ' + oSaveData.data.allowedCredits + ' omschrijvingen gratis van OVIS<br>Normaal tarief &euro;' + oSaveData.data.cost + ' per omschrijving<br><br>U heeft nog ' + oSaveData.data.payment + ' gratis omschrijvingen tegoed.<br><br>Nu een omschrijvingstekst genereren?';
					}
				} else {
					
					sGenerateDescriptionMessage = 'Tarief &euro;' + oSaveData.data.cost + ' per omschrijving<br>Dit bedrag zal worden afgeschreven<br>van uw OVIS saldo.<br><br>Nu een omschrijvingstekst genereren?</div>';
				}
								
				var popupGenerateDescriptionContent = '<div class="description-confirmation" id="description-confirmation">';
					
					popupGenerateDescriptionContent += '<div id="description-content" class="description-content">';					
						
						popupGenerateDescriptionContent += '<h2 id="description-confirmation-title">Omschrijving genereren</h2>';
						popupGenerateDescriptionContent += '<span class="title">' + sGenerateDescriptionMessage + '</span>';						
											
						popupGenerateDescriptionContent += '<span class="sure" onclick="jQuery.loadGenerateDescription(\'generate\');"></span>';
						popupGenerateDescriptionContent += '<span class="not-sure" onclick="jQuery.loadGenerateDescription(\'cancel\');"></span>';
						popupGenerateDescriptionContent += '<span class="processing">verwerken...</span>';
						
					popupGenerateDescriptionContent += '</div>';
					
					popupGenerateDescriptionContent += '<div id="description-result" class="description-content inactive">';					
						
						popupGenerateDescriptionContent += '<h2 id="description-confirmation-title">Omschrijving genereren</h2>';
						popupGenerateDescriptionContent += '<span id="description-message" class="description-message"></span>';
												
						popupGenerateDescriptionContent += '<span class="continue" onclick="jQuery.loadGenerateDescription(\'confirm\');">Ga verder</span>';
					
					popupGenerateDescriptionContent += '</div>';
					
				popupGenerateDescriptionContent += '</div>"';
		
				oLightboxGenerateDescription = SimpleLightbox.open({
					closeOnOverlayClick: false,
					closeOnEscapeKey: false,
					content: popupGenerateDescriptionContent,
					beforeClose: function(){
						setLoadingOverlay('fadeout');						
					}
				});
				
				
				
				
				//setLoadingOverlay('fadeout');						
				
				/*
				jQuery.clearConcept();
								
				sessionStorage.removeItem('active_sub_sub_group');
				sessionStorage.removeItem('active_sub_group');				
				sessionStorage.removeItem('active_group');
				sessionStorage.removeItem('active_article');
				sessionStorage.removeItem('article_set');
				sessionStorage.removeItem('active_succes');
				
				if(typeof oSaveData.article != 'undefined' && oSaveData.article != ''){	
					sessionStorage['active_succes'] = oSaveData.article;
					sessionStorage.removeItem('temp_article');
					window.location.replace('/edit/' + oSaveData.article);
				} else {
					sessionStorage.removeItem('temp_article');
					window.location.replace('/');					
				}
				*/				
			}		
		});
		
		
	});
	
	jQuery.getArticleData = function () {
		
		var postData = {};
		
		postData.articleId = articleID != '' ? articleID : undefined;
		postData.externalId = externalID != '' ? externalID : 'new';
		postData.online = jQuery('#set-online').prop('checked') ? 'Online' : 'Offline';
		postData.status = jQuery('input[name="set-status"]:checked').val();
		postData.period = jQuery('input[name="set-period"]:checked').val();
		
		postData.category = jQuery('input[name="set-category"]:checked').val();
		postData.subcategory = jQuery('input[name="set-subcategory"]:checked').val();
		
		
		var conditionInputType = jQuery('input[name="set-condition"]').attr('type');
		
		if(conditionInputType == 'hidden'){			
			postData.condition = jQuery('input[name="set-condition"]').val();			
		} else {
			postData.condition = jQuery('input[name="set-condition"]:checked').val();			
		}
		
		// License
		var licenseToSend = typeof jQuery('#set-license').val() != 'undefined' && jQuery('#set-license').val() != '' ? jQuery('#set-license').val() : '';		
		
		if(licenseToSend == ''){			
			if(articleLicense != ''){			
				licenseToSend = articleLicense;			
			}			
		}
		
		postData.license = licenseToSend != '' ? licenseToSend : undefined;
		postData.brand = jQuery('input[name="set-brand"]:checked').val();
		postData.model = jQuery('input[name="set-model"]:checked').val();

		if(typeof jQuery('input[name="set-version"]') != 'undefined' && jQuery('input[name="set-version"]').length > 0){
			
			postData.type = jQuery('input[name="set-version"]:checked').val();
			
		} else {
		
			// type		
			var typeToSend = typeof jQuery('#set-type').val() != 'undefined' && jQuery('#set-type').val() != '' ? jQuery('#set-type').val() : '';		
			
			if(typeToSend == ''){			
				if(articleType != ''){			
					typeToSend = articleType;			
				}			
			}
			
			postData.type = typeToSend != '' ? typeToSend : undefined;
		}
		
		postData.chassisnummer = jQuery('#set-chassisnummer').val() != '' ? jQuery('#set-chassisnummer').val() : undefined;
		
		// Suffix
		var suffixToSend = typeof jQuery('#set-toevoeging').val() != 'undefined' && jQuery('#set-toevoeging').val() != '' ? jQuery('#set-toevoeging').val() : '';		
				
		if(suffixToSend == ''){			
			if(articleSuffix != ''){			
				suffixToSend = articleSuffix;			
			}			
		}
		
		postData.suffix = suffixToSend != '' ? suffixToSend : undefined;
		
		postData.mileage = jQuery('#set-mileage').val() != '' ? jQuery('#set-mileage').val() : undefined;
		postData.nap = jQuery('#set-nap').prop('checked') ? true : undefined;
		postData.carBrand = jQuery('#set-car-brand').val() != '' ? jQuery('#set-car-brand').val() : undefined;
		postData.fuel = jQuery('input[name="set-fuel"]:checked').val();
		postData.transmission = jQuery('input[name="set-transmission"]:checked').val();
		postData.euroClass = jQuery('input[name="set-euro-class"]:checked').val();
		postData.seats = jQuery('input[name="set-seats"]:checked').val();
		postData.seatbelts = jQuery('input[name="set-seatbelts"]:checked').val();
		postData.power = jQuery('#set-power').val() != '' ? jQuery('#set-power').val() : undefined;
		postData.owners = jQuery('input[name="set-owners"]:checked').val();
		postData.walltype = jQuery('input[name="set-walltype"]:checked').val();
		postData.color = jQuery('input[name="set-color"]:checked').val();
		postData.colorTrailer = jQuery('input[name="set-color-trailer"]:checked').val();
		postData.metallic = jQuery('#set-metallic').prop('checked') ? true : undefined;
		postData.particulateFilter = jQuery('#set-particulateFilter').prop('checked') ? true : undefined;
		postData.damaged = jQuery('#set-damaged').prop('checked') ? true : undefined;
		postData.hailDamage = jQuery('#set-hailDamage').prop('checked') ? true : undefined;
		postData.demo = jQuery('#set-demo').prop('checked') ? true : undefined;
		postData.exRental = jQuery('#set-exRental').prop('checked') ? true : undefined;
		postData.possibleRental = jQuery('#set-possibleRental').prop('checked') ? true : undefined;
		postData.maintenanceBooklets = jQuery('#set-maintenanceBooklets').prop('checked') ? true : undefined;
		postData.suitableForDisabledPeople = jQuery('#set-suitableForDisabledPeople').prop('checked') ? true : undefined;
		postData.brakes = jQuery('#set-brakes').prop('checked') ? true : undefined;
		postData.numberOfDoors = jQuery('input[name="set-number-of-doors"]:checked').val();
		postData.doorTypes = jQuery('input[name="set-door-types"]:checked').val();
		postData.plug = jQuery('input[name="set-plug"]:checked').val();
		postData.axles = jQuery('input[name="set-axles"]:checked').val();
		postData.floorMaterial = jQuery('input[name="set-floor-material"]:checked').val();
		postData.wallMaterial = jQuery('input[name="set-wall-material"]:checked').val();
		postData.kipAngle = jQuery('#set-kip-angle').val() != '' ? jQuery('#set-kip-angle').val() : undefined;
		postData.material = jQuery('input[name="set-material"]:checked').val();
		postData.materialTentTrailer = jQuery('input[name="set-material-tenttrailer"]:checked').val();
		
		// type trailer specific
		postData.trailerTotalLength = jQuery('#set-trailer-total-length').val() != '' ? jQuery('#set-trailer-total-length').val() : undefined;
		
		// type boat specific
		postData.boatModel = jQuery('#set-model-boat').val() != '' ? jQuery('#set-model-boat').val() : undefined;
		postData.boatTitle = jQuery('#set-title-boat').val() != '' ? jQuery('#set-title-boat').val() : undefined;
		postData.boatLigplaats = jQuery('#set-ligplaats-boat').val() != '' ? jQuery('#set-ligplaats-boat').val() : undefined;
		postData.boatInclusiefTrailer = jQuery('#set-trailer-boat').prop('checked') ? true : undefined;
		postData.boatPersons = jQuery('input[name="set-persons-boat"]:checked').val();
		postData.boatMaterial = jQuery('input[name="set-material-boat"]:checked').val();
		postData.boatColor = jQuery('#set-color-boat').val() != '' ? jQuery('#set-color-boat').val() : undefined;
		postData.boatDeck = jQuery('#set-deck-boat').val() != '' ? jQuery('#set-deck-boat').val() : undefined;
		postData.boatBeds = jQuery('input[name="set-beds-boat"]:checked').val();
		postData.boatEngines = jQuery('input[name="set-engines-boat"]:checked').val();
		
		postData.boatEngineHasEngine = jQuery('input[name="set-boat-engine-has-engine"]:checked').val();
		postData.boatEngineFastSailing = jQuery('input[name="set-boat-engine-fastsailing"]:checked').val();
		postData.boatEngineTankCapacity =  jQuery('input[name="set-boat-engine-tank-capacity"]').val();
		postData.boatEngineCruisingSpeed =  jQuery('input[name="set-boat-engine-cruising-speed"]').val();
		postData.boatEngineHours =  jQuery('input[name="set-boat-engine-hours"]').val();
		postData.boatEngineAccu =  jQuery('input[name="set-boat-engine-accu"]').val();
		postData.boatEnginePower =  jQuery('input[name="set-boat-engine-power"]').val();
		postData.boatEngineModel =  jQuery('input[name="set-boat-engine-model"]').val();
		postData.boatEngineBrand =  jQuery('input[name="set-boat-engine-brand"]:checked').val();
		postData.boatEngineStartsystem =  jQuery('input[name="set-boat-engine-startsystem"]:checked').val();
		postData.boatEngineType =  jQuery('input[name="set-boat-engine-type"]:checked').val();
		postData.boatEngineFuel =  jQuery('input[name="set-boat-engine-fuel"]:checked').val();
		
		// type boattrailer specific
		postData.boatTrailerPlug = jQuery('input[name="set-boattrailer-plug"]:checked').val();
		postData.boatTrailerAxles = jQuery('input[name="set-boattrailer-axles"]:checked').val();
		postData.boatTrailerBraked = jQuery('#set-boattrailer-braked').prop('checked') ? true : undefined;
		postData.boatTrailerKantelbaar = jQuery('#set-boattrailer-kantelbaar').prop('checked') ? true : undefined;
		postData.boatTrailerSizeBoat = jQuery('input[name="set-size-boat"]:checked').val();
		
		// type boatengine specific
		postData.engineFuel = jQuery('input[name="set-engine-fuel"]:checked').val();
		postData.engineTankCapacity = jQuery('#set-engine-tank-capacity').val();
		postData.enginePower = jQuery('#set-engine-power').val() != '' ? jQuery('#from-engine-power').val() : undefined;
		postData.engineTailLength = jQuery('input[name="set-engine-tail-length"]:checked').val();
		postData.engineStartsystem = jQuery('input[name="engine-startsystem"]:checked').val();
		postData.engineSteering = jQuery('input[name="set-engine-steering"]:checked').val();
		postData.engineCylinders = jQuery('#set-engine-cylinders').val() != '' ? jQuery('#from-engine-cylinders').val() : undefined;
		postData.engineSize = jQuery('#set-engine-size').val() != '' ? jQuery('#from-engine-size').val() : undefined;
		postData.engineDryWeight = jQuery('#set-engine-dry-weight').val() != '' ? jQuery('#set-engine-dry-weight').val() : undefined;
				
		// dates
		postData.constructionYear = jQuery('#set-constructionyear').val() != '' ? jQuery('#set-constructionyear').val() : undefined;
		postData.constructionMonth = jQuery('input[name="set-constructionmonth"]:checked').val();
		postData.modelYear = jQuery('#set-modelyear').val() != '' ? jQuery('#set-modelyear').val() : undefined;
		postData.datePartA = jQuery('#set-part-a').val() != '' ? jQuery('#set-part-a').val() : undefined;
		postData.dateFirstNL = jQuery('#set-first-nl').val() != '' ? jQuery('#set-first-nl').val() : undefined;
			
		// sizes
		postData.constructionLength = jQuery('#set-construction-length').val() != '' ? jQuery('#set-construction-length').val() : undefined;
		postData.containerLength = jQuery('#set-container-length').val() != '' ? jQuery('#set-container-length').val() : undefined;
		postData.totalLength = jQuery('#set-total-length').val() != '' ? jQuery('#set-total-length').val() : undefined;
		postData.length = jQuery('#set-length').val() != '' ? jQuery('#set-length').val() : undefined;
		postData.drawbarLength = jQuery('#set-drawbar-length').val() != '' ? jQuery('#set-drawbar-length').val() : undefined;
		postData.containerWidth = jQuery('#set-container-width').val() != '' ? jQuery('#set-container-width').val() : undefined;
		postData.totalWidth = jQuery('#set-total-width').val() != '' ? jQuery('#set-total-width').val() : undefined;
		postData.width = jQuery('#set-width').val() != '' ? jQuery('#set-width').val() : undefined;
		postData.height = jQuery('#set-height').val() != '' ? jQuery('#set-height').val() : undefined;
		postData.headroom = jQuery('#set-headroom').val() != '' ? jQuery('#set-headroom').val() : undefined;
		postData.circulationsize = jQuery('#set-circulationsize').val() != '' ? jQuery('#set-circulationsize').val() : undefined;
		postData.loadingPlatformHeight = jQuery('#set-loading-platform-height').val() != '' ? jQuery('#set-loading-platform-height').val() : undefined;
		postData.couplerHeight = jQuery('#set-coupler-height').val() != '' ? jQuery('#set-coupler-height').val() : undefined;
		postData.bordersHeight = jQuery('#set-borders-height').val() != '' ? jQuery('#set-borders-height').val() : undefined;
		postData.ladderRackHeight = jQuery('#set-ladder-rack-height').val() != '' ? jQuery('#set-ladder-rack-height').val() : undefined;
		postData.totalHeight = jQuery('#set-total-height').val() != '' ? jQuery('#set-total-height').val() : undefined;
		postData.internalHeight = jQuery('#set-internal-height').val() != '' ? jQuery('#set-internal-height').val() : undefined;
		postData.basePlateHeight = jQuery('#set-base-plate-height').val() != '' ? jQuery('#set-base-plate-height').val() : undefined;
		postData.tireSize = jQuery('#set-tire-size').val() != '' ? jQuery('#set-tire-size').val() : undefined;
		postData.volume = jQuery('#set-volume').val() != '' ? jQuery('#set-volume').val() : undefined;
		postData.depth = jQuery('#set-depth').val() != '' ? jQuery('#set-depth').val() : undefined;
		postData.verticalclearance = jQuery('#set-verticalclearance').val() != '' ? jQuery('#set-verticalclearance').val() : undefined;
		postData.emptyWeight = jQuery('#set-empty-weight').val() != '' ? jQuery('#set-empty-weight').val() : undefined;
		postData.roadworthyWeight = jQuery('#set-roadworthy-weight').val() != '' ? jQuery('#set-roadworthy-weight').val() : undefined;
		postData.maxWeight = jQuery('#set-max-weight').val() != '' ? jQuery('#set-max-weight').val() : undefined;
		postData.capacity = jQuery('#set-capacity').val() != '' ? jQuery('#set-capacity').val() : undefined;
				
		// description
		//var sDescription = tinymce.get("article_description").getContent();
		var sDescription = jQuery('#editor_article_description .richText-editor').trigger('getContent', function (event, content) {			
			return content;
		});
		
		var sDescriptionText = '';
		
		if(typeof sDescription[0].innerHTML != 'undefined' && sDescription[0].innerHTML != ''){
			sDescriptionText = sDescription[0].innerHTML;
		}		
		
		postData.description = sDescriptionText != '' ? sDescriptionText : undefined;
		
		// comment
		//var sComment = tinymce.get("article_comment").getContent();
		var sComment = jQuery('#editor_article_comment .richText-editor').trigger('getContent', function (event, content) {
			return content;
		});
		
		var sCommentText = '';
		
		if(typeof sComment[0].innerHTML != 'undefined' && sComment[0].innerHTML != ''){
			sCommentText = sComment[0].innerHTML;
		}
		
		postData.comment = sCommentText != '' ? sCommentText : undefined;
				
		
		// reference
		//var sComment = tinymce.get("article_comment").getContent();
		
		
		if(jQuery('#editor_article_reference').length){
			if(typeof jQuery('#editor_article_reference') != 'undefined'){
				var sReference = jQuery('#editor_article_reference .richText-editor').trigger('getContent', function (event, content) {
					return content;
				});
				
				var sReferenceText = '';
				
				if(typeof sReference[0].innerHTML != 'undefined' && sReference[0].innerHTML != ''){
					sReferenceText = sReference[0].innerHTML;
				}
				
				postData.memo = sReferenceText != '' ? sReferenceText : undefined;
			}
		}
		
		// beds
		postData.beds = jQuery('.sleep-container-bed').length;
		
		postData.sleepingplaces = jQuery('#set-sleepingplaces').val() != '' ? jQuery('#set-sleepingplaces').val() : undefined;
		postData.bedrooms = jQuery('input[name="set-bedrooms"]:checked').val();
		
		var postDataBeds = {};
			postDataBeds.bed_1 = {};		
				postDataBeds.bed_1.length = jQuery('#set-bed-length-1').val() != '' ? jQuery('#set-bed-length-1').val() : undefined;
				postDataBeds.bed_1.width = jQuery('#set-bed-width-1').val() != '' ? jQuery('#set-bed-width-1').val() : undefined;
				postDataBeds.bed_1.type = jQuery('#set-bed-type-1').val() != '' ? jQuery('#set-bed-type-1').val() : undefined;
			postDataBeds.bed_2 = {};		
				postDataBeds.bed_2.length = jQuery('#set-bed-length-2').val() != '' ? jQuery('#set-bed-length-2').val() : undefined;
				postDataBeds.bed_2.width = jQuery('#set-bed-width-2').val() != '' ? jQuery('#set-bed-width-2').val() : undefined;
				postDataBeds.bed_2.type = jQuery('#set-bed-type-2').val() != '' ? jQuery('#set-bed-type-2').val() : undefined;
			postDataBeds.bed_3 = {};		
				postDataBeds.bed_3.length = jQuery('#set-bed-length-3').val() != '' ? jQuery('#set-bed-length-3').val() : undefined;
				postDataBeds.bed_3.width = jQuery('#set-bed-width-3').val() != '' ? jQuery('#set-bed-width-3').val() : undefined;
				postDataBeds.bed_3.type = jQuery('#set-bed-type-3').val() != '' ? jQuery('#set-bed-type-3').val() : undefined;
			postDataBeds.bed_4 = {};		
				postDataBeds.bed_4.length = jQuery('#set-bed-length-4').val() != '' ? jQuery('#set-bed-length-4').val() : undefined;
				postDataBeds.bed_4.width = jQuery('#set-bed-width-4').val() != '' ? jQuery('#set-bed-width-4').val() : undefined;
				postDataBeds.bed_4.type = jQuery('#set-bed-type-4').val() != '' ? jQuery('#set-bed-type-4').val() : undefined;
			postDataBeds.bed_5 = {};		
				postDataBeds.bed_5.length = jQuery('#set-bed-length-5').val() != '' ? jQuery('#set-bed-length-5').val() : undefined;
				postDataBeds.bed_5.width = jQuery('#set-bed-width-5').val() != '' ? jQuery('#set-bed-width-5').val() : undefined;
				postDataBeds.bed_5.type = jQuery('#set-bed-type-5').val() != '' ? jQuery('#set-bed-type-5').val() : undefined;
			postDataBeds.bed_6 = {};		
				postDataBeds.bed_6.length = jQuery('#set-bed-length-6').val() != '' ? jQuery('#set-bed-length-6').val() : undefined;
				postDataBeds.bed_6.width = jQuery('#set-bed-width-6').val() != '' ? jQuery('#set-bed-width-6').val() : undefined;
				postDataBeds.bed_6.type = jQuery('#set-bed-type-6').val() != '' ? jQuery('#set-bed-type-6').val() : undefined;
			postDataBeds.bed_7 = {};		
				postDataBeds.bed_7.length = jQuery('#set-bed-length-7').val() != '' ? jQuery('#set-bed-length-7').val() : undefined;
				postDataBeds.bed_7.width = jQuery('#set-bed-width-7').val() != '' ? jQuery('#set-bed-width-7').val() : undefined;
				postDataBeds.bed_7.type = jQuery('#set-bed-type-7').val() != '' ? jQuery('#set-bed-type-7').val() : undefined;
			postDataBeds.bed_8 = {};		
				postDataBeds.bed_8.length = jQuery('#set-bed-length-8').val() != '' ? jQuery('#set-bed-length-8').val() : undefined;
				postDataBeds.bed_8.width = jQuery('#set-bed-width-8').val() != '' ? jQuery('#set-bed-width-8').val() : undefined;
				postDataBeds.bed_8.type = jQuery('#set-bed-type-8').val() != '' ? jQuery('#set-bed-type-8').val() : undefined;
			postDataBeds.bed_9 = {};		
				postDataBeds.bed_9.length = jQuery('#set-bed-length-9').val() != '' ? jQuery('#set-bed-length-9').val() : undefined;
				postDataBeds.bed_9.width = jQuery('#set-bed-width-9').val() != '' ? jQuery('#set-bed-width-9').val() : undefined;
				postDataBeds.bed_9.type = jQuery('#set-bed-type-9').val() != '' ? jQuery('#set-bed-type-9').val() : undefined;
			postDataBeds.bed_10 = {};		
				postDataBeds.bed_10.length = jQuery('#set-bed-length-10').val() != '' ? jQuery('#set-bed-length-10').val() : undefined;
				postDataBeds.bed_10.width = jQuery('#set-bed-width-10').val() != '' ? jQuery('#set-bed-width-10').val() : undefined;
				postDataBeds.bed_10.type = jQuery('#set-bed-type-10').val() != '' ? jQuery('#set-bed-type-10').val() : undefined;
		
		postData.beddata = postDataBeds;
					
		// accessoiries
		var postDataAccessoiries = [];
		
		jQuery.each(jQuery('input[name="set-accessory"]:checked'), $.proxy(function(index, item) {
			
			var sAccessoiryValue = jQuery(item).val();
			
			if(typeof sAccessoiryValue != 'undefined' && sAccessoiryValue != ''){				
						
				var sAccessoiryCategory = jQuery(item).data('group').replace(/'/g, '');
				var postDataAccessoiry = {};
				
				postDataAccessoiry.value = sAccessoiryValue;
				postDataAccessoiry.category = sAccessoiryCategory;
				
				postDataAccessoiries.push(postDataAccessoiry);
			}										
		}, this));	

		postData.accessoiries = postDataAccessoiries;
		
		// divisions
		var postDataDivisions = [];
		
		jQuery.each(jQuery('input[name="set-division"]:checked'), $.proxy(function(index, item) {
			
			var sDivisionValue = jQuery(item).val();
						
			if(typeof sDivisionValue != 'undefined' && sDivisionValue != ''){				
				
				var sDivisionCategory = jQuery(item).data('group');
				var postDataDivision = {};
				
				postDataDivision.value = sDivisionValue;
				postDataDivision.category = sDivisionCategory;
				
				postDataDivisions.push(postDataDivision);
			}										
		}, this));	

		postData.divisions = postDataDivisions;
		
		// prices
		postData.price = jQuery('#sale-price').val() != '' ? jQuery('#sale-price').val() : undefined;
		postData.fromPrice = jQuery('#from-price').val() != '' ? jQuery('#from-price').val() : undefined;
		postData.vat = jQuery('input[name="set-vat"]:checked').val();
		
		// marktplaats
		postData.marktplaatsTitle = jQuery('#marktplaats-title').val() != '' ? jQuery('#marktplaats-title').val() : undefined;
		postData.marktplaatsPriceType = jQuery('input[name="set-marktplaats-pricetype"]:checked').val();
		postData.marktplaatsPrice = jQuery('#marktplaats-price').val() != '' ? jQuery('#marktplaats-price').val() : undefined;
		postData.marktplaatsBidPrice = jQuery('#marktplaats-bidprice').val() != '' ? jQuery('#marktplaats-bidprice').val() : undefined;
		postData.marktplaatsMinimalBidPrice = jQuery('#marktplaats-minimalbidprice').val() != '' ? jQuery('#marktplaats-minimalbidprice').val() : undefined;

		//var sMarktplaatsDescription = tinymce.get("marktplaats_description").getContent();
		var sMarktplaatsDescription = jQuery('#editor_marktplaats_description .richText-editor').trigger('getContent', function (event, content) {
			return content;
		});
		
		var sMarktplaatsDescriptionText = '';
		
		if(typeof sMarktplaatsDescription[0].innerHTML != 'undefined' && sMarktplaatsDescription[0].innerHTML != ''){
			sMarktplaatsDescriptionText = sMarktplaatsDescription[0].innerHTML;
		}
		
		postData.marktplaatsDescription = sMarktplaatsDescriptionText != '' ? sMarktplaatsDescriptionText : undefined;
		
		// images
		var postDataImages = [];
				
		if(jQuery('.image-container').length){
		
			jQuery.each(jQuery('.image-container'), $.proxy(function(index, item) {
			
				var sImageValue = jQuery(item).data('imgurl');
				
				if(typeof sImageValue != 'undefined' && sImageValue != ''){
					postDataImages.push(sImageValue);
				}
				
			}, this));			
		
		}
		
		postData.images = postDataImages;
		
		return JSON.stringify(postData);		
			
	}
	
	jQuery.loadGenerateDescription = function(action){	
		if(action == 'generate'){
					
			jQuery('#description-content').addClass('processing');
						

			$.post(baseHref() + 'article', { 

				module: 'startDescriptionGeneration',
				acticleData: jQuery.getArticleData()
				
			}, function(data) {
				
				var oData = $.parseJSON(data);		
				
				if(typeof oData.data != 'undefined' && typeof oData.data.description != 'undefined'){					
					if(typeof oData.data.realm != 'undefined'){						
						if(oData.data.realm == 'boat'){
							var currentArticleDescriptionContent = jQuery('#editor_article_description .richText-editor').trigger('getContent', function (event, content) {
								return content;
							});;
							
							if(typeof currentArticleDescriptionContent[0].innerHTML != 'undefined' && currentArticleDescriptionContent[0].innerHTML != ''){							
								currentArticleDescriptionContent =  oData.data.description + '<br><br>' +  currentArticleDescriptionContent[0].innerHTML;
							} else {								
								currentArticleDescriptionContent =  oData.data.description;
							}
							
							jQuery('#editor_article_description .richText-editor').trigger('setContent', '<div>'+nl2br(currentArticleDescriptionContent)+'</div>');
							
							sessionStorage['current_description'] = nl2br(currentArticleDescriptionContent);
							
						} else {
							
							jQuery('#editor_article_description .richText-editor').trigger('setContent', '<div>'+nl2br(oData.data.description)+'</div>');
							
							sessionStorage['current_description'] = nl2br(oData.data.description);
						}						
					}  
					
					oLightboxGenerateDescription.close();
				} else {
					jQuery('#default-description-content').addClass('inactive');
					jQuery('#description-content').addClass('inactive');
					jQuery('#description-result').removeClass('inactive');
					
					var sErrorMessage = 'Fout bij het genereren van een omschrijving.';
					
					if(typeof oData.errors != 'undefined'){
						if(oData.errors == 'less-data'){
							sErrorMessage = 'Er zijn te weinig gegevens ingevoerd om een omschrijving te kunnen genereren.';						
						} else if(oData.errors == 'empty-description'){
							sErrorMessage = 'Wij hebben geen omschrijving kunnen genereren.';
						}
					}					
					
					jQuery('#description-message').addClass('error').html(sErrorMessage);
				}
				
			});
			
					
		} else if(action == 'confirm'){
						
			jQuery('#default-description-content').removeClass('inactive');
			jQuery('#description-content').addClass('inactive');
			jQuery('#description-result').addClass('inactive');
			
			jQuery('#description-message').removeClass('succes').removeClass('error').html('');
			
			oLightboxGenerateDescription.close();
		} else if(action == 'cancel') {
			oLightboxGenerateDescription.close();
		}	
	}	
	
	jQuery.loadMarktplaatsDescription = function(action){		
		if(action == 'resume'){	

			var sArticleData = jQuery.getArticleData();
			
			setLoadingOverlay('fadein');
			
			if(sArticleData != ''){
				
				var sNewMarktplaatsDescription = '';
				var sMarktplaatsDescriptionAlgemeen = '';
				var sMarktplaatsDescriptionMeasures = '';
				var sMarktplaatsDescriptionSleep = '';
				var sMarktplaatsDescriptionAccessoiries = '';
				var sMarktplaatsDescriptionDivisions = '';
				var sMarktplaatsDescriptionDescription = '';
				
				oArticleData = $.parseJSON(sArticleData);
				
				if(typeof oArticleData.constructionYear != 'undefined' && oArticleData.constructionYear != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Bouwjaar: ';					
				}
				
				if(typeof oArticleData.constructionMonth != 'undefined' && oArticleData.constructionMonth != '' ){
					sMarktplaatsDescriptionAlgemeen += oArticleData.constructionMonth + ' ';					
				}
				
				if(typeof oArticleData.constructionYear != 'undefined' && oArticleData.constructionYear != '' ){
					sMarktplaatsDescriptionAlgemeen += oArticleData.constructionYear + '<br>';					
				}
				
				if(typeof oArticleData.modelYear != 'undefined' && oArticleData.modelYear != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Modeljaar: ' + oArticleData.modelYear + '<br>';					
				}
				
				if(oArticleData.category == 'boot' || oArticleData.category == 'boat'){
					if(typeof oArticleData.condition  != 'undefined' && oArticleData.condition != '' ){
						sMarktplaatsDescriptionAlgemeen += 'Conditie: ' + oArticleData.condition + '<br>';					
					}
				}
				
				if(typeof oArticleData.fuel != 'undefined' && oArticleData.fuel != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Brandstof: ' + oArticleData.fuel + '<br>';					
				}
				
				if(typeof oArticleData.transmission != 'undefined' && oArticleData.transmission != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Transmissie: ' + oArticleData.transmission + '<br>';					
				}
				
				if(typeof oArticleData.euroClass != 'undefined' && oArticleData.euroClass != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Euroklasse: klasse ' + oArticleData.euroClass + '<br>';					
				}
				
				if(typeof oArticleData.carBrand != 'undefined' && oArticleData.carBrand != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Chassis: ' + oArticleData.carBrand + '<br>';					
				}
				
				if(typeof oArticleData.mileage != 'undefined' && oArticleData.mileage != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Kilometerstand: ' + oArticleData.mileage + ' km';	

					if(typeof oArticleData.nap != 'undefined' && oArticleData.nap != '' ){
						sMarktplaatsDescriptionAlgemeen += ' (NAP)';					
					}					
					sMarktplaatsDescriptionAlgemeen += '<br>';	
				}
				
				if(typeof oArticleData.seats != 'undefined' && oArticleData.seats != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Zitplaatsen: ' + oArticleData.seats + '<br>';					
				}
				
				if(typeof oArticleData.seatbelts != 'undefined' && oArticleData.seatbelts != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Gordels: ' + oArticleData.seatbelts + '<br>';					
				}
				
				if(typeof oArticleData.power != 'undefined' && oArticleData.power != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Vermogen: ' + oArticleData.power + 'pk<br>';					
				}
				
				if(typeof oArticleData.walltype != 'undefined' && oArticleData.walltype != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Wanden: ' + oArticleData.walltype + '<br>';					
				}
				
				if(typeof oArticleData.color != 'undefined' && oArticleData.color != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Kleur: ' + oArticleData.color;					
					
					if(typeof oArticleData.metallic != 'undefined' && oArticleData.metallic != '' ){
						sMarktplaatsDescriptionAlgemeen += ' (metallic lak)';					
					}
					sMarktplaatsDescriptionAlgemeen += '<br>';					
				}
				
				if(typeof oArticleData.colorTrailer != 'undefined' && oArticleData.colorTrailer != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Kleur: ' + oArticleData.colorTrailer;					
					
					if(typeof oArticleData.metallic != 'undefined' && oArticleData.metallic != '' ){
						sMarktplaatsDescriptionAlgemeen += ' (metallic lak)';					
					}
					sMarktplaatsDescriptionAlgemeen += '<br>';					
				}
				
				if(typeof oArticleData.particulateFilter != 'undefined' && oArticleData.particulateFilter != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Roetfilter: ja<br>';					
				}
				
				if(typeof oArticleData.hailDamage != 'undefined' && oArticleData.hailDamage != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Hagelschade: ja<br>';					
				}
				
				if(typeof oArticleData.maintenanceBooklets != 'undefined' && oArticleData.maintenanceBooklets != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Onderhoudsboekjes aanwezig: ja<br>';					
				}
				
				if(typeof oArticleData.suitableForDisabledPeople != 'undefined' && oArticleData.suitableForDisabledPeople != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Geschikt voor mindervaliden: ja<br>';					
				}
				
				if(typeof oArticleData.brakes != 'undefined' && oArticleData.brakes != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Geremd: ja<br>';					
				}
				
				if(typeof oArticleData.numberOfDoors != 'undefined' && oArticleData.numberOfDoors != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Aantal deuren: ' + oArticleData.numberOfDoors + '<br>';					
				}
				
				if(typeof oArticleData.doorTypes != 'undefined' && oArticleData.doorTypes != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Type deuren: ' + oArticleData.doorTypes + '<br>';					
				}
				
				if(typeof oArticleData.plug != 'undefined' && oArticleData.plug != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Stekker: ' + oArticleData.plug + '<br>';					
				}
				
				if(typeof oArticleData.axles != 'undefined' && oArticleData.axles != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Aantal assen: ' + oArticleData.axles + '<br>';					
				}
				
				if(typeof oArticleData.floorMaterial != 'undefined' && oArticleData.floorMaterial != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Materiaal vloer: ' + oArticleData.floorMaterial + '<br>';					
				}
				
				if(typeof oArticleData.wallMaterial != 'undefined' && oArticleData.wallMaterial != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Materiaal wanden: ' + oArticleData.wallMaterial + '<br>';					
				}
				
				if(typeof oArticleData.kipAngle != 'undefined' && oArticleData.kipAngle != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Kiphoek: ' + oArticleData.kipAngle + '<br>';					
				}
				
				if(typeof oArticleData.material != 'undefined' && oArticleData.material != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Materiaal: ' + oArticleData.material + '<br>';					
				}
				
				if(typeof oArticleData.materialTentTrailer != 'undefined' && oArticleData.materialTentTrailer != '' ){
					sMarktplaatsDescriptionAlgemeen += 'Materiaal: ' + oArticleData.materialTentTrailer + '<br>';					
				}
				
				if(sMarktplaatsDescriptionAlgemeen != ''){
					sNewMarktplaatsDescription += '<b>Algemeen</b><br>' + sMarktplaatsDescriptionAlgemeen;					
				}				
				
				if(typeof oArticleData.constructionLength != 'undefined' && oArticleData.constructionLength != '' ){
					sMarktplaatsDescriptionMeasures += 'Opbouwlengte: ' + oArticleData.constructionLength + ' cm<br>';					
				}
				
				if(typeof oArticleData.containerLength != 'undefined' && oArticleData.containerLength != '' ){
					sMarktplaatsDescriptionMeasures += 'Lengte bak: ' + oArticleData.containerLength + ' cm<br>';					
				}
				
				if(typeof oArticleData.totalLength != 'undefined' && oArticleData.totalLength != '' ){
					sMarktplaatsDescriptionMeasures += 'Lengte totaal: ' + oArticleData.totalLength + ' cm<br>';					
				}
				
				if(typeof oArticleData.length != 'undefined' && oArticleData.length != '' ){
					sMarktplaatsDescriptionMeasures += 'Lengte: ' + oArticleData.length + ' cm<br>';					
				}
				
				if(typeof oArticleData.drawbarLength != 'undefined' && oArticleData.drawbarLength != '' ){
					sMarktplaatsDescriptionMeasures += 'Lengte dissel: ' + oArticleData.drawbarLength + ' cm<br>';					
				}
				
				if(typeof oArticleData.containerWidth != 'undefined' && oArticleData.containerWidth != '' ){
					sMarktplaatsDescriptionMeasures += 'Breedte bak: ' + oArticleData.containerWidth + ' cm<br>';					
				}
				
				if(typeof oArticleData.totalWidth != 'undefined' && oArticleData.totalWidth != '' ){
					sMarktplaatsDescriptionMeasures += 'Breedte totaal: ' + oArticleData.totalWidth + ' cm<br>';					
				}
				
				if(typeof oArticleData.width != 'undefined' && oArticleData.width != '' ){
					sMarktplaatsDescriptionMeasures += 'Breedte: ' + oArticleData.width + ' cm<br>';					
				}
				
				if(typeof oArticleData.height != 'undefined' && oArticleData.height != '' ){
					sMarktplaatsDescriptionMeasures += 'Hoogte: ' + oArticleData.height + ' cm<br>';					
				}
				
				if(typeof oArticleData.totalHeight != 'undefined' && oArticleData.totalHeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Hoogte totaal: ' + oArticleData.totalHeight + ' cm<br>';					
				}
				
				if(typeof oArticleData.internalHeight != 'undefined' && oArticleData.internalHeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Inwendige hoogte: ' + oArticleData.internalHeight + ' cm<br>';					
				}
				
				if(typeof oArticleData.headroom != 'undefined' && oArticleData.headroom != '' ){
					sMarktplaatsDescriptionMeasures += 'Stahoogte: ' + oArticleData.headroom + ' cm<br>';					
				}
				
				if(typeof oArticleData.basePlateHeight != 'undefined' && oArticleData.basePlateHeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Dikte grondplaat: ' + oArticleData.basePlateHeight + ' mm<br>';					
				}
				
				if(typeof oArticleData.loadingPlatformHeight != 'undefined' && oArticleData.loadingPlatformHeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Laadvloerhoogte: ' + oArticleData.loadingPlatformHeight + ' cm<br>';					
				}
				
				if(typeof oArticleData.couplerHeight != 'undefined' && oArticleData.couplerHeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Koppelingshoogte: ' + oArticleData.couplerHeight + ' cm<br>';					
				}
				
				if(typeof oArticleData.bordersHeight != 'undefined' && oArticleData.bordersHeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Borderhoogte: ' + oArticleData.bordersHeight + ' cm<br>';					
				}
				
				if(typeof oArticleData.ladderRackHeight != 'undefined' && oArticleData.ladderRackHeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Voorrekhoogte: ' + oArticleData.ladderRackHeight + ' cm<br>';					
				}
				
				if(typeof oArticleData.tireSize != 'undefined' && oArticleData.tireSize != '' ){
					sMarktplaatsDescriptionMeasures += 'Bandenmaat: ' + oArticleData.tireSize + ' inch<br>';					
				}
				
				if(typeof oArticleData.circulationsize != 'undefined' && oArticleData.circulationsize != '' ){
					sMarktplaatsDescriptionMeasures += 'Omloopmaat: ' + oArticleData.circulationsize + ' cm<br>';					
				}
				
				if(typeof oArticleData.volume != 'undefined' && oArticleData.volume != '' ){
					sMarktplaatsDescriptionMeasures += 'Inhoud: ' + oArticleData.volume + ' m3<br>';					
				}
				
				if(typeof oArticleData.depth != 'undefined' && oArticleData.depth != '' ){
					sMarktplaatsDescriptionMeasures += 'Diepgang: ' + oArticleData.depth + ' cm<br>';					
				}
				
				if(typeof oArticleData.verticalclearance != 'undefined' && oArticleData.verticalclearance != '' ){
					sMarktplaatsDescriptionMeasures += 'Doorvaarhoogte: ' + oArticleData.verticalclearance + ' cm<br>';					
				}
				
				if(typeof oArticleData.emptyWeight != 'undefined' && oArticleData.emptyWeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Leeggewicht: ' + oArticleData.emptyWeight + ' kg<br>';					
				}
				
				if(typeof oArticleData.emptyWeight != 'undefined' && oArticleData.emptyWeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Leeggewicht: ' + oArticleData.emptyWeight + ' kg<br>';					
				}
				
				if(typeof oArticleData.roadworthyWeight != 'undefined' && oArticleData.roadworthyWeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Rijklaargewicht: ' + oArticleData.roadworthyWeight + ' kg<br>';					
				}
				
				if(typeof oArticleData.maxWeight != 'undefined' && oArticleData.maxWeight != '' ){
					sMarktplaatsDescriptionMeasures += 'Maximaal toelaatbaar gewicht: ' + oArticleData.maxWeight + ' kg<br>';					
				}
				
				if(typeof oArticleData.capacity != 'undefined' && oArticleData.capacity != '' ){
					sMarktplaatsDescriptionMeasures += 'Laadvermogen: ' + oArticleData.capacity + ' kg<br>';					
				}
				
				if(sMarktplaatsDescriptionMeasures != ''){
					
					if(sNewMarktplaatsDescription != ''){
						sNewMarktplaatsDescription += '<br>';
					}
					
					sNewMarktplaatsDescription += '<b>Maten en gewichten</b><br>' + sMarktplaatsDescriptionMeasures;					
				}
				
				
				if(typeof oArticleData.sleepingplaces != 'undefined' && oArticleData.sleepingplaces != '' ){
					sMarktplaatsDescriptionSleep += 'Aantal slaapplaatsen: ' + oArticleData.sleepingplaces + '<br>';					
				}
				
				if(typeof oArticleData.bedrooms != 'undefined' && oArticleData.bedrooms != '' ){
					sMarktplaatsDescriptionSleep += 'Aantal slaapkamers: ' + oArticleData.bedrooms + '<br>';					
				}
				
				if(typeof oArticleData.beds != 'undefined' && oArticleData.beds != '' ){
					sMarktplaatsDescriptionSleep += 'Aantal bedden: ' + oArticleData.beds + '<br>';					
				}
				
				if(typeof oArticleData.beddata != 'undefined' && oArticleData.beddata != '' ){
					
					jQuery.each(oArticleData.beddata, $.proxy(function(index, item) {
						
						if(typeof item.type != 'undefined' && item.type != '' ){
							sMarktplaatsDescriptionSleep += '- ' + item.type;					
							
							if(typeof item.length != 'undefined' && item.length != '' && typeof item.width != 'undefined' && item.width != ''){
								sMarktplaatsDescriptionSleep += ': ' + item.length + ' x ' + item.width + ' cm';	
							}							
							
							sMarktplaatsDescriptionSleep += '<br>';	
						}
						
					}, this));
				}				
				
				if(sMarktplaatsDescriptionSleep != ''){
					
					if(sNewMarktplaatsDescription != ''){
						sNewMarktplaatsDescription += '<br>';
					}
					
					sNewMarktplaatsDescription += '<b>Slapen</b><br>' + sMarktplaatsDescriptionSleep;					
				}
				
				if(typeof oArticleData.divisions != 'undefined' && oArticleData.divisions != '' ){
					
					var sDivisionKeuken = '';
					var sDivisionSanitair = '';
					var sDivisionZitten = '';
					var sDivisionSlapen = '';
					
					jQuery.each(oArticleData.divisions, $.proxy(function(index, item) {
						
						if(typeof item.category != 'undefined' && item.category != '' && typeof item.value != 'undefined' && item.value != ''){
							
							if(item.category == 'keuken'){
								sDivisionKeuken += '<li>' + item.value + '</li>';
							} else if(item.category == 'sanitair'){
								sDivisionSanitair += '<li>' + item.value + '</li>';							
							} else if(item.category == 'zitten'){
								sDivisionZitten += '<li>' + item.value + '</li>';								
							} else if(item.category == 'slapen'){
								sDivisionSlapen += '<li>' + item.value + '</li>';								
							}						
						}
						
					}, this));					
					
					if(sDivisionKeuken != '' || sDivisionSanitair != '' || sDivisionZitten != '' || sDivisionSlapen != ''){
						
						sMarktplaatsDescriptionDivisions += '<ul>';
						
							if(sDivisionKeuken != ''){
								sMarktplaatsDescriptionDivisions += '<li><b>Keuken</b></li>';
								sMarktplaatsDescriptionDivisions += sDivisionKeuken;							
							}
							
							if(sDivisionSanitair != ''){
								sMarktplaatsDescriptionDivisions += '<li><b>Sainitair</b></li>';
								sMarktplaatsDescriptionDivisions += sDivisionSanitair;
							}
							
							if(sDivisionZitten != ''){
								sMarktplaatsDescriptionDivisions += '<li><b>Zitplaatsen</b></li>';
								sMarktplaatsDescriptionDivisions += sDivisionZitten;
							}
							
							if(sDivisionSlapen != ''){
								sMarktplaatsDescriptionDivisions += '<li><b>Slapen</b></li>';
								sMarktplaatsDescriptionDivisions += sDivisionSlapen;
							}
						
						sMarktplaatsDescriptionDivisions += '</ul>';
					}					
				}

				if(sMarktplaatsDescriptionDivisions != ''){					
					
					if(sNewMarktplaatsDescription != ''){
						sNewMarktplaatsDescription += '<br>';
					}
					
					sNewMarktplaatsDescription += '<b>Indeling</b><br>' + sMarktplaatsDescriptionDivisions;					
				}
				
				if(typeof oArticleData.accessoiries != 'undefined' && oArticleData.accessoiries != '' ){
					
					var sAccessoiryKeuken = '';
					var sAccessoirySanitair = '';
					var sAccessoiryRadioTv = '';
					var sAccessoiryVerwarming = '';
					var sAccessoiryExterieurInterieur = '';
					var sAccessoirySlaapcomfort = '';
					var sAccessoiryTechniekEnVeiligheid = '';
					var sAccessoiryOnderstelCabine = '';
					var sAccessoiryAssenEnChassis = '';
					var sAccessoiryOpbouwEnUitrusting = '';
					var sAccessoiryPaardenTrailer = '';
					var sAccessoiryBoottrailer = '';
					var sAccessoiryExtras = '';
					var sAccessoiryElectronica = '';
					var sAccessoiryUitrustingBinnen = '';
					var sAccessoiryUitrustingBuiten = '';
					var sAccessoiryOverig = '';
					
					jQuery.each(oArticleData.accessoiries, $.proxy(function(index, item) {
						
						if(typeof item.category != 'undefined' && item.category != '' && typeof item.value != 'undefined' && item.value != ''){
							
							if(item.category == 'keuken'){
								sAccessoiryKeuken += '<li>' + item.value + '</li>';
							} else if(item.category == 'sanitair'){
								sAccessoirySanitair += '<li>' + item.value + '</li>';							
							} else if(item.category == 'radio/tv'){
								sAccessoiryRadioTv += '<li>' + item.value + '</li>';								
							} else if(item.category == 'verwarming'){
								sAccessoiryVerwarming += '<li>' + item.value + '</li>';								
							} else if(item.category == 'exterieur/interieur'){
								sAccessoiryExterieurInterieur += '<li>' + item.value + '</li>';								
							} else if(item.category == 'slaapcomfort'){
								sAccessoirySlaapcomfort += '<li>' + item.value + '</li>';								
							} else if(item.category == 'techniek en veiligheid'){
								sAccessoiryTechniekEnVeiligheid += '<li>' + item.value + '</li>';								
							} else if(item.category == 'onderstel/cabine'){
								sAccessoiryOnderstelCabine += '<li>' + item.value + '</li>';								
							} else if(item.category == 'assen en chassis'){
								sAccessoiryAssenEnChassis += '<li>' + item.value + '</li>';								
							} else if(item.category == 'opbouw en uitrusting'){
								sAccessoiryOpbouwEnUitrusting += '<li>' + item.value + '</li>';								
							} else if(item.category == 'paarden trailer'){
								sAccessoiryPaardenTrailer += '<li>' + item.value + '</li>';								
							} else if(item.category == 'boottrailer'){
								sAccessoiryBoottrailer += '<li>' + item.value + '</li>';								
							} else if(item.category == 'extras'){
								sAccessoiryExtras += '<li>' + item.value + '</li>';								
							} else if(item.category == 'electronica'){
								sAccessoiryElectronica += '<li>' + item.value + '</li>';								
							} else if(item.category == 'uitrusting binnen'){
								sAccessoiryUitrustingBinnen += '<li>' + item.value + '</li>';								
							} else if(item.category == 'uitrusting buiten'){
								sAccessoiryUitrustingBuiten += '<li>' + item.value + '</li>';								
							} else if(item.category == 'overige'){
								sAccessoirySlapen += '<li>' + item.value + '</li>';								
							}						
						}
						
					}, this));
					
					if(sAccessoiryKeuken != '' || sAccessoirySanitair != '' || sAccessoiryRadioTv != '' || sAccessoiryVerwarming != '' || sAccessoiryExterieurInterieur != '' || sAccessoirySlaapcomfort != '' || sAccessoiryTechniekEnVeiligheid != '' || sAccessoiryOnderstelCabine != '' || sAccessoiryAssenEnChassis != '' || sAccessoiryOpbouwEnUitrusting != '' || sAccessoiryPaardenTrailer != '' || sAccessoiryBoottrailer != '' || sAccessoiryExtras != '' || sAccessoiryElectronica != '' || sAccessoiryUitrustingBinnen != '' || sAccessoiryUitrustingBuiten != '' || sAccessoiryOverig != ''){
						
						sMarktplaatsDescriptionAccessoiries += '<ul>';
						
							if(sAccessoiryKeuken != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Keuken</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryKeuken;							
							}
							
							if(sAccessoirySanitair != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Sainitair</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoirySanitair;
							}
							
							if(sAccessoiryRadioTv != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Radio/TV</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryRadioTv;
							}
							
							if(sAccessoiryVerwarming != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Verwarming</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryVerwarming;
							}
							
							if(sAccessoiryExterieurInterieur != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Exterieur/interieur</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryExterieurInterieur;
							}
							
							if(sAccessoirySlaapcomfort != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Slaapcomfort</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoirySlaapcomfort;
							}
							
							if(sAccessoiryTechniekEnVeiligheid != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Techniek en veiligheid</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryTechniekEnVeiligheid;
							}
							
							if(sAccessoiryOnderstelCabine != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Onderstel/cabine</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryOnderstelCabine;
							}
							
							if(sAccessoiryAssenEnChassis != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Assen en chassis</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryAssenEnChassis;
							}
							
							if(sAccessoiryOpbouwEnUitrusting != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Opbouw en uitrusting</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryOpbouwEnUitrusting;
							}
							
							if(sAccessoiryPaardenTrailer != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Paardentrailer</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryPaardenTrailer;
							}
							
							if(sAccessoiryBoottrailer != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Boottrailer</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryBoottrailer;
							}
							
							if(sAccessoiryExtras != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Extras</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryExtras;
							}
							
							if(sAccessoiryElectronica != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Electronica</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryElectronica;
							}
							
							if(sAccessoiryUitrustingBinnen != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Uitrusting binnen</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryUitrustingBinnen;
							}
							
							if(sAccessoiryUitrustingBuiten != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Uitrusting buiten</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryUitrustingBuiten;
							}
							
							if(sAccessoiryOverig != ''){
								sMarktplaatsDescriptionAccessoiries += '<li><b>Overig</b></li>';
								sMarktplaatsDescriptionAccessoiries += sAccessoiryOverig;
							}
						
						sMarktplaatsDescriptionAccessoiries += '</ul>';
					}					
				}

				if(sMarktplaatsDescriptionAccessoiries != ''){
					
					if(sNewMarktplaatsDescription != ''){
						sNewMarktplaatsDescription += '<br>';
					}
					
					sNewMarktplaatsDescription += '<b>Accessoires</b><br>' + sMarktplaatsDescriptionAccessoiries;					
				}
				
				if(typeof oArticleData.description != 'undefined' && oArticleData.description != '' ){
					sMarktplaatsDescriptionDescription += oArticleData.description;					
				}

				if(sMarktplaatsDescriptionDescription != ''){
					
					if(sNewMarktplaatsDescription != ''){
						sNewMarktplaatsDescription += '<br>';
					}
					
					sNewMarktplaatsDescription += '<b>Bijzonderheden</b><br>' + sMarktplaatsDescriptionDescription;	

					var sUserNaw = '';

					if(jQuery('#userNaw').length){
						
						sUserNaw = jQuery('#userNaw').html();
						
						if(sUserNaw != ''){
							sNewMarktplaatsDescription += '<br><b>Dit product is verkrijgbaar bij:</b><br>' + sUserNaw;	
						}						
					}					
				}
			
				var sNewMarktplaatsDescriptionClean = sNewMarktplaatsDescription;
				
				//var ContentSet = tinymce.get("marktplaats_description").setContent(sNewMarktplaatsDescriptionClean);
				jQuery('#editor_marktplaats_description .richText-editor').trigger('setContent', '<div>'+nl2br(sNewMarktplaatsDescriptionClean)+'</div>');
				//jQuery('#editor_marktplaats_description .richText-editor').trigger('setContent', sNewMarktplaatsDescriptionClean);
				
				sessionStorage['current_marktplaats_description'] = sNewMarktplaatsDescriptionClean;
				
			}
			
			setLoadingOverlay('fadeout');
						
			oLightboxLoadMarktplaatsDescriptionArticle.close();
		} else if(action == 'cancel') {
			oLightboxLoadMarktplaatsDescriptionArticle.close();
		}		
	}
	
	jQuery(document).on("click","#generate-marktplaats-description",function(e) {
		
		var popupLoadMarktplaatsDescriptionContent = '<div class="concept-confirmation" id="concept-confirmation">';
			popupLoadMarktplaatsDescriptionContent += '<h2 id="concept-confirmation-title">Omschrijving samenstellen</h2>';
			popupLoadMarktplaatsDescriptionContent += '<span class="title">Wilt u de Marktplaats omschrijving (opnieuw) samenstellen? De bestaande omschrijving zal worden overschreven.</span>';					
			popupLoadMarktplaatsDescriptionContent += '<span class="sure" onclick="jQuery.loadMarktplaatsDescription(\'resume\');"></span>';
			popupLoadMarktplaatsDescriptionContent += '<span class="not-sure" onclick="jQuery.loadMarktplaatsDescription(\'cancel\');"></span>';
		popupLoadMarktplaatsDescriptionContent += '</div>"';

		oLightboxLoadMarktplaatsDescriptionArticle = SimpleLightbox.open({
			closeOnOverlayClick: false,
			closeOnEscapeKey: false,
			content: popupLoadMarktplaatsDescriptionContent,
			beforeClose: function(){
				setLoadingOverlay('fadeout');						
			}
		});
	});
	
	jQuery(document).on("click",".confirm-item",function(e) {
		
		jQuery('.input-active').removeClass('input-active');
		
		jQuery('.autofill-response-container').removeClass('active');
		jQuery('.get-license-container').removeClass('active');
		jQuery('.load-license-data').removeClass('active');
			
		if(jQuery('body').hasClass('sub-active')){
			
			
			var sTitleToSet = 'Kenmerken';	
			var sCurrentSubSubGroup = sessionStorage.getItem('active_sub_sub_group') !== null ? sessionStorage['active_sub_sub_group'] : '';
			
			if(sCurrentSubSubGroup == 'vat'){
				sTitleToSet = 'Prijzen';
			}
			
			sessionStorage.removeItem('active_sub_sub_group');
			
			var sElementToScrollTo = jQuery('.active-sub-container').find('.type').attr('id');
						
			jQuery('#title-container').html(sTitleToSet);
			
			jQuery('.has-open-sub').removeClass('has-open-sub');		
			jQuery('.sub-container').removeClass('active');	
			jQuery('.active-sub-container').removeClass('active-sub-container');	
			jQuery('body').removeClass('sub-active');
			jQuery('.status-group').removeClass('hidden');
			
			$('html, body').scrollTop($("#"+sElementToScrollTo).offset().top-90);
		
		} else {

			jQuery('.article-input-subgroup.type').removeClass('active'); 
			jQuery('.article-input-subgroup.accessories').removeClass('active'); 
			jQuery('.article-input-subgroup.divisions').removeClass('active'); 
			jQuery('.article-input-subgroup.engines').removeClass('active'); 
			jQuery('.article-input-subgroup.dates').removeClass('active'); 
			jQuery('.article-input-subgroup.sizes').removeClass('active'); 
			jQuery('.article-input-subgroup.sleep').removeClass('active'); 
			
			if(jQuery('body').hasClass('photos-active')){
				
				jQuery('.sort-images-status').removeClass('active');
				jQuery('#sort-images-status-message').html('Foto\'s sorteren?');
			
				if(jQuery("#images").length){		
					jQuery( "#images" ).sortable( "option", "disabled", true );
				}
				
			} else if(jQuery('body').hasClass('status-active')){
				
				buildStatusSynopsis();
			
			} else if(jQuery('body').hasClass('marktplaats-active')){
								
				var checkCurrentPriceType = jQuery('input[name="set-marktplaats-pricetype"]:checked').val();
				var checkCurrentPrice = jQuery('input[name="marktplaats-price"]').val();
				var checkCurrentBidPrice = jQuery('input[name="marktplaats-bidprice"]').val();
				var checkCurrentMinimalBidPrice = jQuery('input[name="marktplaats-minimalbidprice"]').val();
				
				if(checkCurrentPriceType == 'vaste prijs'){
					
					if(checkCurrentPrice == ''){
						var popupMarktplaatsNoPriceContent = '<div class="concept-confirmation" id="concept-confirmation">';
							popupMarktplaatsNoPriceContent += '<h2 id="concept-confirmation-title">Prijs ontbreekt</h2>';
							popupMarktplaatsNoPriceContent += '<span class="title">U heeft geen vraagprijs ingevoerd.</span>';					
							popupMarktplaatsNoPriceContent += '<span class="continue" onclick="jQuery.closeMarktplaatsMessage();">Ga verder</span>';
						popupMarktplaatsNoPriceContent += '</div>"';

						oLightboxMarktplaatsNoPrice = SimpleLightbox.open({
							closeOnOverlayClick: false,
							closeOnEscapeKey: false,
							content: popupMarktplaatsNoPriceContent,
							beforeClose: function(){
								setLoadingOverlay('fadeout');						
							}
						});	
						
						return;
					}					
					
				} else if(checkCurrentPriceType == 'bieden' ){
					
					checkCurrentBidPrice = checkCurrentBidPrice.replace('.', '');
					checkCurrentMinimalBidPrice = checkCurrentMinimalBidPrice.replace('.', '');
					
					if(checkCurrentBidPrice == '' || checkCurrentMinimalBidPrice == ''){
						var popupMarktplaatsNoPriceContent = '<div class="concept-confirmation" id="concept-confirmation">';
							popupMarktplaatsNoPriceContent += '<h2 id="concept-confirmation-title">Prijs ontbreekt</h2>';
							popupMarktplaatsNoPriceContent += '<span class="title">U heeft geen vraagprijs en/of bieden vanaf prijs ingevoerd.</span>';					
							popupMarktplaatsNoPriceContent += '<span class="continue" onclick="jQuery.closeMarktplaatsMessage();">Ga verder</span>';
						popupMarktplaatsNoPriceContent += '</div>"';

						oLightboxMarktplaatsNoPrice = SimpleLightbox.open({
							closeOnOverlayClick: false,
							closeOnEscapeKey: false,
							content: popupMarktplaatsNoPriceContent,
							beforeClose: function(){
								setLoadingOverlay('fadeout');						
							}
						});	
						
						return;
					} else if(checkCurrentBidPrice < checkCurrentMinimalBidPrice){
						var popupMarktplaatsNoPriceContent = '<div class="concept-confirmation" id="concept-confirmation">';
							popupMarktplaatsNoPriceContent += '<h2 id="concept-confirmation-title">Prijs onjuist</h2>';
							popupMarktplaatsNoPriceContent += '<span class="title">Bij biedingen moet de \'vraagprijs\' gelijk aan<br>of hoger dan de \'bieden vanaf\' prijs zijn.</span>';					
							popupMarktplaatsNoPriceContent += '<span class="continue" onclick="jQuery.closeMarktplaatsMessage();">Ga verder</span>';
						popupMarktplaatsNoPriceContent += '</div>"';

						oLightboxMarktplaatsNoPrice = SimpleLightbox.open({
							closeOnOverlayClick: false,
							closeOnEscapeKey: false,
							content: popupMarktplaatsNoPriceContent,
							beforeClose: function(){
								setLoadingOverlay('fadeout');						
							}
						});	
						
						return;
					}
				}				
				
				//var currentMarktplastsDescriptionContent = tinymce.get("marktplaats_description").getContent();
				var currentMarktplastsDescriptionContent = jQuery('#editor_marktplaats_description .richText-editor').trigger('getContent', function (event, content) {
					return content;
				});
				
				//if(typeof currentMarktplastsDescriptionContent[0].innerHTML != 'undefined' && currentMarktplastsDescriptionContent[0].innerHTML != ''){				
				//	sessionStorage['current_marktplaats_description'] = currentMarktplastsDescriptionContent[0].innerHTML;
				//} else {
				//	sessionStorage.removeItem('current_marktplaats_description');		
				//}
				
				buildMarktplaatsSynopsis();				
				
			} else if(jQuery('body').hasClass('prices-active')){
				
				buildPricesSynopsis();				
				
			} else if(jQuery('body').hasClass('description-active')){				
				
				if(jQuery('body').hasClass('omschrijving-active')){
					//var currentDescriptionContent = tinymce.get("article_description").getContent();
					var currentDescriptionContent = jQuery('#editor_article_description .richText-editor').trigger('getContent', function (event, content) {
						return content;
					});
					
					//if(typeof currentDescriptionContent[0].innerHTML != 'undefined' && currentDescriptionContent[0].innerHTML != ''){					
					//	sessionStorage['current_description'] = currentDescriptionContent[0].innerHTML;
					//} else {
					//	sessionStorage.removeItem('current_description');		
					//}					
				} else if(jQuery('body').hasClass('comments-active')){
					//var currentCommentContent = tinymce.get("article_comment").getContent();
					var currentCommentContent = jQuery('#editor_article_comment .richText-editor').trigger('getContent', function (event, content) {
						return content;
					});					
					
					//if(typeof currentCommentContent[0].innerHTML != 'undefined' && currentCommentContent[0].innerHTML != ''){				
					//	sessionStorage['current_comment'] = currentCommentContent[0].innerHTML;
					//} else {
					//	sessionStorage.removeItem('current_comment');		
					//}
				} else if(jQuery('body').hasClass('reference-active')){
					//var currentReferenceContent = tinymce.get("article_reference").getContent();
					var currentReferenceContent = jQuery('#editor_article_reference .richText-editor').trigger('getContent', function (event, content) {
						return content;
					});					
					
					//if(typeof currentReferenceContent[0].innerHTML != 'undefined' && currentReferenceContent[0].innerHTML != ''){				
					//	sessionStorage['current_reference'] = currentReferenceContent[0].innerHTML;
					//} else {
					//	sessionStorage.removeItem('current_reference');		
					//}
				}				

				buildDescriptionSynopsis();
				
			} else if(jQuery('body').hasClass('features-active')){
				
				buildFeaturesSynopsis();	
				
			}
			
			if(jQuery('body').hasClass('has-active-sub')){
				
				sessionStorage.removeItem('active_sub_group');
				
				if(jQuery('body').hasClass('license-active') || jQuery('body').hasClass('brand-active') || jQuery('body').hasClass('model-active') || jQuery('body').hasClass('version-active') || jQuery('body').hasClass('type-active') || jQuery('body').hasClass('accessories-active') || jQuery('body').hasClass('divisions-active') || jQuery('body').hasClass('dates-active') || jQuery('body').hasClass('sizes-active') || jQuery('body').hasClass('sleep-active') || jQuery('body').hasClass('engines-active')){			
					sTitleToSet = 'Kenmerken';
				}
				
				
				
				if(jQuery('body').hasClass('omschrijving-active') || jQuery('body').hasClass('comments-active') || jQuery('body').hasClass('reference-active')){			
					sTitleToSet = 'Beschrijving';
				}
				
				if(jQuery('body').hasClass('brand-active')){
					if(articleBrandCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.brand').removeClass('active');
						jQuery('#brand-set-value').removeClass('verify');
						jQuery('#brand-set-value').html('');
						
						sessionStorage.removeItem('current_brand');
					}					
				}
				
				if(jQuery('body').hasClass('license-active')){

						articleLicense = jQuery('#set-license').val();
					
				}
				
				if(jQuery('body').hasClass('model-active')){
					if(articleModelCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.model').removeClass('active');
						jQuery('#model-set-value').removeClass('verify');
						jQuery('#model-set-value').html('');
						
						sessionStorage.removeItem('current_model');
					}					
				}
				
				if(jQuery('body').hasClass('version-active')){
					if(articleVersionCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.version').removeClass('active');
						jQuery('#version-set-value').removeClass('verify');
						jQuery('#version-set-value').html('');
						
						sessionStorage.removeItem('current_version');
					}					
				}
				
				if(jQuery('body').hasClass('type-active')){
					if(articleTypeCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.type').removeClass('active');
						jQuery('#type-set-value').removeClass('verify');
						jQuery('#type-set-value').html('');
						
						sessionStorage.removeItem('current_accessoiries');
					}					
				}
				
				if(jQuery('body').hasClass('accessoiries-active')){
					if(articleAccessoriesCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.accessoiries').removeClass('active');
						jQuery('#accessoiries-set-value').removeClass('verify');
						jQuery('#accessoiries-set-value').html('');
						
						sessionStorage.removeItem('current_accessoiries');
					}					
				}
				
				if(jQuery('body').hasClass('divisions-active')){
					if(articleDivisionsCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.divisions').removeClass('active');
						jQuery('#divisions-set-value').removeClass('verify');
						jQuery('#divisions-set-value').html('');
						
						sessionStorage.removeItem('current_divisions');
					}					
				}
				
				if(jQuery('body').hasClass('dates-active')){
					if(articleDatesCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.dates').removeClass('active');
						jQuery('#dates-set-value').removeClass('verify');
						jQuery('#dates-set-value').html('');
					}					
				}
				
				if(jQuery('body').hasClass('sizes-active')){
					if(articleSizesCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.sizes').removeClass('active');
						jQuery('#sizes-set-value').removeClass('verify');
						jQuery('#sizes-set-value').html('');
					}					
				}
				
				if(jQuery('body').hasClass('sleep-active')){
					if(articleBedsCheck == 'Controleren' ){
						jQuery('.article-input-subgroup.sleep').removeClass('active');
						jQuery('#sleep-set-value').removeClass('verify');
						jQuery('#sleep-set-value').html('');
					}					
				}				
				
				if(jQuery('body').hasClass('accessories-active')){	

					buildAccessoriesSynopsis();
					
				}				
				
				if(jQuery('body').hasClass('divisions-active')){

					buildDivisionsSynopsis();
					
				}
				
				if(jQuery('body').hasClass('dates-active')){

					buildDatesSynopsis();
					
				}
				
				if(jQuery('body').hasClass('type-active')){	
				
					buildTypeSynopsis();
					
				}
				
				if(jQuery('body').hasClass('engines-active')){	
				
					buildEnginesSynopsis();
					
				}
				
				if(jQuery('body').hasClass('sleep-active')){
					
					buildSleepSynopsis();
					
				}
				
				if(jQuery('body').hasClass('sizes-active')){

					buildSizesSynopsis();
					
				}

				if(jQuery('body').hasClass('license-active')){	
				
					buildLicenseSynopsis();
					
				}

				jQuery('#title-container').html(sTitleToSet);			
				
				jQuery('body').removeClass('has-active-sub');
				
				jQuery('body').removeClass('license-active');
				jQuery('body').removeClass('engines-active');
				jQuery('body').removeClass('brand-active');
				jQuery('body').removeClass('model-active');
				jQuery('body').removeClass('version-active');
				jQuery('body').removeClass('type-active');
				jQuery('body').removeClass('accessories-active');
				jQuery('body').removeClass('divisions-active');
				jQuery('body').removeClass('dates-active');
				jQuery('body').removeClass('sizes-active');
				jQuery('body').removeClass('sleep-active');
				jQuery('body').removeClass('marktplaatsdescription-active');
				
				jQuery('body').removeClass('omschrijving-active');
				jQuery('body').removeClass('comments-active');
				jQuery('body').removeClass('reference-active');
				
			} else {	

				sessionStorage.removeItem('active_group');
			
				jQuery('body').removeClass('has-active-sub');
				
				jQuery('body').removeClass('status-active');
				jQuery('body').removeClass('photos-active');
				jQuery('body').removeClass('category-active');
				jQuery('body').removeClass('features-active');
				jQuery('body').removeClass('description-active');
				jQuery('body').removeClass('prices-active');
				jQuery('body').removeClass('preview-active');
				jQuery('body').removeClass('marktplaats-active');
				
				jQuery('body').removeClass('group-active');
				
				var sTitleToSet = 'Advertentie aanmaken';
				
				if(articleID != ''){			
					sTitleToSet = 'Advertentie bewerken';
				}
				
				jQuery('#title-container').html(sTitleToSet);
			}
		}		
	});		
	
	function parseAccessories() {	
		
		var sReturnCategory = articleCategory; //jQuery('input[name="set-category"]:checked').val();
		
		if(jQuery('#set-accessories-container').length > 0){
			if(jQuery('input.accessory-radio:checked').length){
				jQuery('input.accessory-radio:checked').button( "refresh" );
			}
		} else if(sReturnCategory == '' || typeof sReturnCategory == 'undefined' || sReturnCategory == 'undefined'){
			
			jQuery('.add-edit-subgroup.accessories .article-form').html('<div class="notice-container"><div class="notice">Kies eerst een categorie om vervolgens accessoires te kunnen selecteren.</div><div class="direct-to category">Klik hier om een categorie te selecteren</div></div>');
			
		} else {
			
			sReturnCategory = sReturnCategory.toLowerCase();
			
			if(sReturnCategory == 'vouwwagen'){
				sReturnCategory = 'tenttrailer';
			} else if(sReturnCategory == 'stacaravan'){
				sReturnCategory = 'mobilehome';				
			} else if(sReturnCategory == 'boot'){
				sReturnCategory = 'boat';				
			} else if(sReturnCategory == 'boottrailer'){
				sReturnCategory = 'boattrailer';				
			} else if(sReturnCategory == 'motor'){
				sReturnCategory = 'engine';				
			} else if(sReturnCategory == 'aanhangwagen'){
				sReturnCategory = 'trailer';				
			}
			
			if(typeof oAccessoriesSet[sReturnCategory] != 'undefined'){	
				
				var accessoriesList = '<div class="accessories-container" id="accessories-container">'+			
					'<div class="accessory" id="set-accessories-container">';
											
						var aArticleAccessoriesList = !articleAccessories ? false : articleAccessories;
						
						accessoriesList += '<div id="accessories-search" class="accessory-search"><input autocomplete="false" type="text" name="accessory-search-input" id="accessory-search-input" value="" placeholder="Zoek in accessoires" /></div>';
						
						jQuery.each(oAccessoriesSet[sReturnCategory], $.proxy(function(index, item) {
														
							if(typeof item.accessories != 'undefined' && item.accessories != ''){
								
								var accessoiriesGroupTitle = item.title.toLowerCase();
								
								accessoriesList += '<span class="accessories-group">' + item.title + '</span>';
								
								jQuery.each(item.accessories, $.proxy(function(indexAccessory, itemAccessory) {
									accessoriesList += '<label class="accessory-label" for="set-accessoiry-' + index + '-' + indexAccessory + '">' + itemAccessory + '</label>';
									accessoriesList += '<input class="accessory-radio" type="checkbox" name="set-accessory" data-group="' + accessoiriesGroupTitle + '" id="set-accessoiry-' + index + '-' + indexAccessory + '" value="' + itemAccessory + '"';
									
									if(aArticleAccessoriesList != false){
										
										var accToCheck = itemAccessory;
										
										accessoriesList += aArticleAccessoriesList.includes(accToCheck.toLowerCase()) ? ' checked="checked"' : '';
									}
									
									accessoriesList += '>';
								}, this));								
							}
														
						}, this));
						
					accessoriesList += '</div>'+
				'</div>';
				
				jQuery('.add-edit-subgroup.accessories .article-form').append(accessoriesList);
								
				jQuery( "input.accessory-radio" ).checkboxradio({
				  icon: false
				});
				
				jQuery(document).on("change","input.accessory-radio",function(e) {
					var sEditIndicator = jQuery(this).closest('.add-edit-subgroup').data('groupname');
					
					var aCurrentAccessories = [];
					
					jQuery.each(jQuery('.accessory-radio'), $.proxy(function(index, item) {
					
						var sAccessoiryState = jQuery(item).prop('checked');
						var sAccessoiryValue = jQuery(item).val();
						
						if(sAccessoiryState === false){
						} else {
							aCurrentAccessories.push(sAccessoiryValue);
						}
					
					}, this));
					
					
					/*
					var sAccessoiryValue = jQuery(this).val();
					var sAccessoiryState = jQuery(this).prop('checked');
					
					var sCurrentAccessories = sessionStorage.getItem('current_accessories') !== null ? sessionStorage['current_accessories'] : '';
					
					var aCurrentAccessories = [];
					
					if(sCurrentAccessories != ''){
						aCurrentAccessories = $.parseJSON(sCurrentAccessories);
					}
					
					if(sAccessoiryState === false){
						if(jQuery.inArray(sAccessoiryValue, aCurrentAccessories) !== -1){
							// is in array							
							aCurrentAccessories = jQuery.grep(aCurrentAccessories, function(value) {
							  return value != sAccessoiryValue;
							});							
						}	
					} else {
						if(jQuery.inArray(sAccessoiryValue, aCurrentAccessories) !== -1){
							// is in array
						} else {
							aCurrentAccessories.push(sAccessoiryValue);
						}
					}
					*/
					
					if(aCurrentAccessories.length > 0){
						sessionStorage['current_accessories'] = JSON.stringify(aCurrentAccessories);
					} else {
						sessionStorage.removeItem('current_accessories');
					}
					
					sessionStorage['edit_indicator'] = sEditIndicator;	
					
				});
				
			} else {
				jQuery('.add-edit-subgroup.accessories .article-form').html('<div class="notice-container"><div class="notice">Voor de gekozen categorie zijn geen accessoires beschikbaar.</div></div>');
			}			
		}		

		setLoadingOverlay('fadeout');
	}
	
	function parseDivisions() {		
		
		var sReturnCategory = articleCategory; //jQuery('input[name="set-category"]:checked').val();
		
		if(jQuery('#set-divisions-container').length > 0){
			if(jQuery('input.division-radio:checked').length){
				jQuery('input.division-radio:checked').button( "refresh" );
			}
		} else {
			
			if(typeof oDivisionsSet != 'no-divisions'){	
				
				var divisionsList = '<div class="divisions-container" id="divisions-container">'+			
					'<div class="division" id="set-divisions-container">';

						var aArticleDivisionsList = !articleDivisions ? false : articleDivisions;
						
						divisionsList += '<div id="divisions-search" class="division-search"><input autocomplete="false" type="text" name="division-search-input" id="division-search-input" value="" placeholder="Zoek in indelingen" /></div>';
						
						jQuery.each(oDivisionsSet, $.proxy(function(index, item) {
														
							if(typeof item.divisions != 'undefined' && item.divisions != ''){
								divisionsList += '<span class="divisions-group">' + item.title + '</span>';
									
								jQuery.each(item.divisions, $.proxy(function(indexDivision, itemDivision) {
									divisionsList += '<label class="division-label" for="set-division-' + index + '-' + indexDivision + '">' + capitalizeFirstLetterOfString(itemDivision) + '</label>';
									divisionsList += '<input class="division-radio ' + (!item.single_mode ? 'multiple-mode' : 'single-mode single-' + item.title.toLowerCase() + '" data-single="' + item.title.toLowerCase()) + '" data-group="' + item.title.toLowerCase() + '" type="checkbox" name="set-division" id="set-division-' + index + '-' + indexDivision + '" value="' + capitalizeFirstLetterOfString(itemDivision) + '"';
									
									if(aArticleDivisionsList != false){
										
										var divToCheck = itemDivision;
										
										divisionsList += aArticleDivisionsList.includes(divToCheck.toLowerCase()) ? ' checked="checked"' : '';
									}
									
									divisionsList += '>';
								}, this));								
							}
						
						}, this));
						
					divisionsList += '</div>'+
				'</div>';
				
				jQuery('.add-edit-subgroup.divisions .article-form').append(divisionsList);
				
				jQuery( "input.division-radio" ).checkboxradio({
				  icon: false
				});
				
				jQuery(document).on("change","input.division-radio",function(e) {
					var sEditIndicator = jQuery(this).closest('.add-edit-subgroup').data('groupname');
					
					var aCurrentDivisions = [];
					
					jQuery.each(jQuery('.division-radio'), $.proxy(function(index, item) {
					
						var sDivisionState = jQuery(item).prop('checked');
						var sDivisionValue = jQuery(item).val();
						
						if(sDivisionState === false){
						} else {
							aCurrentDivisions.push(sDivisionValue);
						}
					
					}, this));
					
					/*
					var sDivisionValue = jQuery(this).val();
					var sDivisionState = jQuery(this).prop('checked');
					var bIsSingle = jQuery(this).hasClass('single-mode') ? true : false;
										
					var sCurrentDivisions = sessionStorage.getItem('current_divisions') !== null ? sessionStorage['current_divisions'] : '';
					
					var aCurrentDivisions = [];
					
					if(sCurrentDivisions != ''){
						aCurrentDivisions = $.parseJSON(sCurrentDivisions);
					}
					
					if(sDivisionState === false){
						if(jQuery.inArray(sDivisionValue, aCurrentDivisions) !== -1){
							// is in array							
							aCurrentDivisions = jQuery.grep(aCurrentDivisions, function(value) {
							  return value != sDivisionValue;
							});							
						}	
					} else {
						if(jQuery.inArray(sDivisionValue, aCurrentDivisions) !== -1){
							// is in array
						} else {
							if(bIsSingle != false){
								
								var sSingleGroup = jQuery(this).data('single');
								
								if(typeof sSingleGroup != 'undefined' && sSingleGroup != ''){
									jQuery.each(jQuery('.division-radio[data-single="' + sSingleGroup + '"]'), $.proxy(function(index, item) {
					
										var sValToClear = jQuery(item).val();
										
										aCurrentDivisions = jQuery.grep(aCurrentDivisions, function(value) {
											return value != sValToClear;
										});	

										//jQuery(item).prop('checked',false).button('refresh');
									
									}, this));
								}
							}							
							
							aCurrentDivisions.push(sDivisionValue);
						}
					}
					*/
					
					if(aCurrentDivisions.length > 0){
						sessionStorage['current_divisions'] = JSON.stringify(aCurrentDivisions);
					} else {
						sessionStorage.removeItem('current_divisions');
					}
					
					sessionStorage['edit_indicator'] = sEditIndicator;	
					
				});
				
			} else {
				jQuery('.add-edit-subgroup.divisions .article-form').html('<div class="notice-container"><div class="notice">Voor de gekozen categorie zijn geen indelingen beschikbaar.</div></div>');
			}			
		}		

		setLoadingOverlay('fadeout');
	}
	
	function parseSubCategories() {	
	
		oSavedCategoriesSet = sessionStorage.getItem('categories_set') !== null ? sessionStorage['categories_set'] : '';
		
		if(oSavedCategoriesSet != ''){	
			
			var oData = $.parseJSON(oSavedCategoriesSet);			
			
			oCategoriesSet = (oData === false ? false : oData);
			
			//var currentCategory = typeof jQuery('#article-category') != 'undefined' ? jQuery('#article-category').val() : false;
			var currentCategory = typeof articleCategory == 'undefined' || !articleCategory ? false : articleCategory.toLowerCase();
			var sCurrentCategory = sessionStorage.getItem('current_category') !== null ? sessionStorage['current_category'] : '';
			
			if(!currentCategory){
				if(sCurrentCategory != false){
					currentCategory = sCurrentCategory
				}
			}
			
			if(currentCategory == 'vouwwagen'){
				currentCategory = 'tenttrailer';
			} else if(currentCategory == 'stacaravan'){
				currentCategory = 'mobilehome';				
			} else if(currentCategory == 'boot'){
				currentCategory = 'boat';				
			} else if(currentCategory == 'boottrailer'){
				currentCategory = 'boattrailer';				
			}  else if(currentCategory == 'motor'){
				currentCategory = 'engine';				
			} else if(currentCategory == 'aanhangwagen'){
				currentCategory = 'trailer';				
			}
			
			var currentSubCategory = typeof articleSubCategory == 'undefined' || !articleSubCategory ? (sessionStorage.getItem('current_subcategory') !== null ? sessionStorage['current_subcategory'] : false) : articleSubCategory.toLowerCase();
			var subcategoryList = '';
			
			jQuery.each(oCategoriesSet, $.proxy(function(index, item) {
				
				if(currentCategory == index){
					
					if(typeof item.subs != 'undefined'){
						
						subcategoryList = '<label class="label-sub">Soort</label>';
						
						subcategoryList += '<span class="open-sub' + (articleSubCategory != '' ? ' active' : '') + '" id="open-sub-subcategory" data-group="type" data-field="subcategory" data-title="soort" data-default="Soort">' + (articleSubCategory != '' ? capitalizeFirstLetterOfString(articleSubCategory) : 'Soort') + '</span><div class="sub-container" id="sub-subcategory">';

								jQuery.each(item.subs, $.proxy(function(indexSub, itemSub) {
									
									var itemSubDescription = itemSub; // itemSub.replace(' ', '-');
									
									subcategoryList += '<label for="set-soort-' + itemSubDescription + '">' + capitalizeFirstLetterOfString(itemSub) + '</label>';
									subcategoryList += '<input class="subcategory-radio" type="radio" name="set-subcategory" id="set-soort-' + itemSubDescription + '" value="' + itemSubDescription.toLowerCase() + '"';
									subcategoryList += (currentSubCategory == itemSub ? ' checked="checked"' : '');
									subcategoryList += '>';
																
								}, this));
						
						subcategoryList += '</div>';			
						
					}					
				}				
				
			}, this));
			
			if(subcategoryList == ''){
				jQuery('#sale-subcategory-container').html(subcategoryList);
				jQuery('#subcategory-container').addClass('not-loaded-yet');
				jQuery('#subcategory-container').removeClass('active');
				jQuery('#subcategory-container').find('.open-sub').removeClass('active');
			} else {				
				jQuery('#sale-subcategory-container').html(subcategoryList);
				jQuery('#subcategory-container').removeClass('not-loaded-yet');
				
				if(currentSubCategory != ''){
					jQuery('#subcategory-container').addClass('active');
					jQuery('#subcategory-container').find('.open-sub').addClass('active').html(capitalizeFirstLetterOfString(currentSubCategory));
				}
				
				jQuery( "input.subcategory-radio" ).checkboxradio({
				  icon: false
				});
			}	
		}	
	}
	
	jQuery(document).on("change","input.subcategory-radio",function(e) {
		
		var sReturnSubcategory= jQuery('input[name="set-subcategory"]:checked').val();
		var defaultLabel = jQuery("#open-sub-subcategory").data('default');		
		var sTitleToSet = 'Kenmerken';		
		jQuery('#title-container').html(sTitleToSet);
		
		jQuery('.notice-container').remove();

		if(sReturnSubcategory != ''){		
			jQuery('#open-sub-subcategory').addClass('active');
			jQuery('#open-sub-subcategory').closest('.type-container').addClass('active');
			jQuery('#open-sub-subcategory').html(capitalizeFirstLetterOfString(sReturnSubcategory));
			
			sessionStorage['current_subcategory'] = sReturnSubcategory;	
		} else {
			jQuery('#open-sub-subcategory').removeClass('active');
			jQuery('#open-sub-subcategory').closest('.type-container').removeClass('active');
			jQuery('#open-sub-subcategory').html(defaultLabel);	

			sessionStorage.removeItem('current_subcategory');	
		}
		
		jQuery('.has-open-sub').removeClass('has-open-sub');		
		jQuery('#sub-subcategory').removeClass('active');	
		jQuery('.active-sub-container').removeClass('active-sub-container');	
		jQuery('body').removeClass('sub-active');
		
		sessionStorage.removeItem('active_sub_sub_group');

		jQuery('html, body').scrollTop($("#sale-subcategory-container").offset().top-90);	
		
	});	
	
	function parseCategories() {
		
		if(jQuery('#set-category-container').length > 0){
			if(jQuery('input.category-radio:checked').length){
				jQuery('input.category-radio:checked').button( "refresh" );
			}
			
			jQuery('#category-missing').remove();
			
		} else if(typeof oCategoriesSet != 'undefined'){
				
			//var currentCategory = typeof jQuery('#article-category') != 'undefined' ? jQuery('#article-category').val() : false;
			var currentCategory = typeof articleCategory == 'undefined' || !articleCategory ? false : articleCategory;

			var categoryList = '<div class="category-container" id="category-container">'+			
				'<div class="category" id="set-category-container">';

					jQuery.each(oCategoriesSet, $.proxy(function(index, item) {
						
						var sDisabled = '';
						
						if(typeof userLimits != 'undefined'){							
							if(typeof userLimits[item.category.toLowerCase()] != 'undefined'){						
								if(typeof userLimits[item.category.toLowerCase()]["general"] != 'undefined'){						
									
									if(userLimits[item.category.toLowerCase()]["general"] === false){
										sDisabled = ' disabled="disabled"';										
									}									
								}						
							}						
						}
						
						categoryList += '<label for="set-category-' + index + '">' + item.category + (sDisabled != '' ? ' - <i>limiet bereikt</i>' : '') + '</label>';
						categoryList += '<input class="category-radio" type="radio" name="set-category" id="set-category-' + index + '" value="' + item.category.toLowerCase() + '"';
						categoryList += (currentCategory == index ? ' checked="checked"' : '');
						
						categoryList += sDisabled;
						
						categoryList += '>';
													
					}, this));
					
				categoryList += '</div>'+
			'</div>';
			
			jQuery('.add-edit-group.category .article-form').append(categoryList);
			
			jQuery( "input.category-radio" ).checkboxradio({
			  icon: false
			});
			
			jQuery('#category-missing').remove();
			
		} else {
			jQuery('.add-edit-group.category .article-form').html('<div class="notice-container" id="category-missing"><div class="notice">Er zijn geen categorieen beschikbaar.</div></div>');
		}
		
		setLoadingOverlay('fadeout');
	}
	
	function parsePhotoLabels() {
		
		var sReturnCategory = articleCategory;
		var oLabels = '';
		
		if(jQuery('#photo-container').length > 0){
			
			setLoadingOverlay('fadeout');
			
			return;
		}
				
		if(typeof oPhotoLabels.data != 'undefined'){			
			if(accountLanguage == 'nl'){
				if(typeof oPhotoLabels.data.nl != 'undefined'){
					oLabels = oPhotoLabels.data.nl;
				}
			} else if(accountLanguage == 'de'){
				if(typeof oPhotoLabels.data.de != 'undefined'){
					oLabels = oPhotoLabels.data.de;
				}
			} else if(accountLanguage == 'en'){
				if(typeof oPhotoLabels.data.en != 'undefined'){
					oLabels = oPhotoLabels.data.en;
				}
			} else if(accountLanguage == 'fr'){
				if(typeof oPhotoLabels.data.fr != 'undefined'){
					oLabels = oPhotoLabels.data.fr;
				}
			}
			articlePhotoLabel
			if(oLabels != ''){
				
				var labelsList = '<div class="photo-container' + (articlePhotoLabel != '' ? ' active' : '') + '" id="photo-container">'+			
					'<div class="photo" id="sale-photolabel-container">'+
						'<label class="label-sub">Fotolabel</label>'+
						'<span class="open-sub' + (articlePhotoLabel != '' ? ' active' : '') + '" id="open-sub-photolabel" data-group="photo" data-field="photolabel" data-title="fotolabel" data-default="Fotolabel">' + (articlePhotoLabel != '' ? capitalizeFirstLetterOfString(articlePhotoLabel) : 'Fotolabel') + '</span>'+ 
							'<div class="sub-container" id="sub-photolabel">';
							
								labelsList += '<label for="set-no-photolabel">Geen fotolabel</label><input class="photolabel-radio" type="radio" name="set-photolabel" id="set-no-photolabel" value="no-photolabel">';
												
								//var aArticleAccessoriesList = !articleAccessories ? false : articleAccessories;
								
								jQuery.each(oLabels, $.proxy(function(index, item) {
																
									if(typeof item.title != 'undefined' && item.title != ''){
										
										var sTitleGroup = item.title;
										
										if(sTitleGroup == 'general'){											
											sTitleGroup = 'algemeen';
										} else if(sTitleGroup == 'specific'){											
											sTitleGroup = 'specifiek';
										} else if(sTitleGroup == 'theme'){
											sTitleGroup = 'thema';											
										}										
										
										labelsList += '<span class="photolabel-group">' + capitalizeFirstLetterOfString(sTitleGroup) + '</span>';
										
										jQuery.each(item.labels, $.proxy(function(indexLabel, itemLabel) {
											labelsList += '<label for="set-photolabel-' + index + '-' + indexLabel + '">' + capitalizeFirstLetterOfString(itemLabel.text) + '</label>';
											labelsList += '<input class="photolabel-radio" type="radio" name="set-photolabel" id="set-photolabel-' + index + '-' + indexLabel + '" value="' + itemLabel.text + '"';
											
											if(articlePhotoLabel != ''){
												labelsList += articlePhotoLabel == itemLabel.text ? ' checked="checked"' : '';
											}
											
											labelsList += '>';
										}, this));								
									}
																
								}, this));
							
							labelsList += '</div>'+
						'</div>'+
					'</div>'+
				'</div>';
				
				jQuery('.add-edit-group.photos').prepend(labelsList);
				
				jQuery('.not-loaded-yet').removeClass('not-loaded-yet');
				
				jQuery( "input.photolabel-radio" ).checkboxradio({
				  icon: false
				});
				
				jQuery(document).on("change","input.photolabel-radio",function(e) {
			
					var sReturnCondition = jQuery('input[name="set-photolabel"]:checked').val();
					var defaultLabel = jQuery("#open-sub-photolabel").data('default');		
					var sTitleToSet = 'foto\'s';		
					jQuery('#title-container').html(sTitleToSet);
					
					jQuery('.notice-container').remove();
					
					if(sReturnCondition == 'no-photolabel'){
						sReturnCondition = '';
					}

					if(sReturnCondition != ''){		
						jQuery('#open-sub-photolabel').addClass('active');
						jQuery('#open-sub-photolabel').closest('.photo-container').addClass('active');
						jQuery('#open-sub-photolabel').html(capitalizeFirstLetterOfString(sReturnCondition));
					} else {
						jQuery('#open-sub-photolabel').removeClass('active');
						jQuery('#open-sub-photolabel').closest('.photo-container').removeClass('active');
						jQuery('#open-sub-photolabel').html(defaultLabel);			
					}
					
					jQuery('.has-open-sub').removeClass('has-open-sub');		
					jQuery('#sub-photolabel').removeClass('active');	
					jQuery('.active-sub-container').removeClass('active-sub-container');	
					jQuery('body').removeClass('sub-active');
					
					sessionStorage.removeItem('active_sub_sub_group');

					jQuery('html, body').scrollTop($("#sale-photolabel-container").offset().top-90);			
					
				});
			}			
		}		
		
		setLoadingOverlay('fadeout');
	}
	
	function parseVersions() {	

		oSavedVersionSet = sessionStorage.getItem('version_set') !== null ? sessionStorage['version_set'] : '';
		
		var articleCategoryFromEdit = articleCategory;
		
		if(articleCategoryFromEdit == ''){
			if(sessionStorage.getItem('current_category') !== null){
				articleCategoryFromEdit = sessionStorage['current_category'];
			}
		}
		
		var articleBrandFromEdit = articleBrand;
		
		if(articleBrandFromEdit == ''){
			if(sessionStorage.getItem('current_brand') !== null){
				articleBrandFromEdit = sessionStorage['current_brand'];
			}
		}
		
		var articleModelFromEdit = articleModel;
		
		if(articleModelFromEdit == ''){
			if(sessionStorage.getItem('current_model') !== null){
				articleModelFromEdit = sessionStorage['current_model'];
			}
		}
			
		if(articleBrandFromEdit == ''){
			
			jQuery('.notice-container').remove();
			
			jQuery('.add-edit-subgroup.version .article-form').html('<div class="notice-container"><div class="notice">Kies eerst een merk om vervolgens een model te selecteren.</div><div class="direct-to model">Klik hier om een model te selecteren</div></div>');
			
			setLoadingOverlay('fadeout');
			
		} else if(articleModelFromEdit == ''){
			
			jQuery('.notice-container').remove();
			
			jQuery('.add-edit-subgroup.version .article-form').html('<div class="notice-container"><div class="notice">Kies eerst een model om vervolgens een versie te selecteren.</div><div class="direct-to model">Klik hier om een model te selecteren</div></div>');
			
			setLoadingOverlay('fadeout');
				
		} else {
			
			if(oSavedVersionSet == ''){
				jQuery('.add-edit-subgroup.version .article-form').html('<div class="notice-container"><div class="notice">Voor de gekozen combinatie merk/model zijn geen versies beschikbaar.</div></div>');
			} else {
				
				var oData = $.parseJSON(oSavedVersionSet);
								
				if(typeof oData.versions == 'undefined' ||  oData.versions == ''){
					
					jQuery('.add-edit-subgroup.version .article-form').html('<div class="notice-container"><div class="notice">Voor de gekozen combinatie merk/model zijn geen versies beschikbaar..</div></div>');
					
				} else {

					jQuery('.add-edit-subgroup.version .article-form').html('');				
				
					var versionsList = '<div class="versions-container" id="versions-container">'+			
						'<div class="version" id="set-versions-container">';					
							
							versionsList += '<div id="version-search" class="version-search"><input autocomplete="false" type="text" name="version-search-input" id="version-search-input" value="" placeholder="Zoek in merken" /></div>';
							
							var aArticleVersion = !articleVersion ? false : articleVersion;

							jQuery.each(oData.versions, $.proxy(function(index, item) {
															
								var sVersionSearch = item.version;
											
								versionsList += '<label class="version-label" for="set-version-' + index + '">' + item.version + '</label>';
								versionsList += '<input class="version-radio" data-templateid="'+item.id+'" type="radio" name="set-version" id="set-version-' + index + '" value="' + item.version + '"';
								versionsList += sVersionSearch == aArticleVersion ? ' checked="checked"' : '';
								versionsList += '>';
															
							}, this));
							
						versionsList += '</div>'+
					'</div>';
					
					jQuery('.add-edit-subgroup.version .article-form').append(versionsList);
					
					jQuery( "input.version-radio" ).checkboxradio({
					  icon: false
					});
					
					var sCurrentSubGroup = sessionStorage.getItem('active_sub_group') !== null ? sessionStorage['active_sub_group'] : '';
				
				}				
			}
		}
		
		setLoadingOverlay('fadeout');		
	}
	
	function parseBrands() {
		
		var sReturnCategory = articleCategory; //jQuery('input[name="set-category"]:checked').val();
			
		if(jQuery('#set-brands-container').length > 0){
			
			jQuery('.notice-container').remove();
			
			if(jQuery('input.brand-radio:checked').length){
				jQuery('input.brand-radio:checked').button( "refresh" );
			}
		} else if(sReturnCategory == '' || typeof sReturnCategory == 'undefined' || sReturnCategory == 'undefined'){
			
			jQuery('.add-edit-subgroup.brand .article-form').html('<div class="notice-container"><div class="notice">Kies eerst een categorie om vervolgens een merk te selecteren.</div><div class="direct-to category">Klik hier om een categorie te selecteren</div></div>');
			
		} else {
			
			jQuery('.notice-container').remove();
			
			sReturnCategory = sReturnCategory.toLowerCase();
			
			if(sReturnCategory == 'vouwwagen'){
				sReturnCategory = 'tenttrailer';
			} else if(sReturnCategory == 'stacaravan'){
				sReturnCategory = 'mobilehome';				
			} else if(sReturnCategory == 'boot'){
				sReturnCategory = 'boat';				
			} else if(sReturnCategory == 'boottrailer'){
				sReturnCategory = 'boattrailer';				
			} else if(sReturnCategory == 'motor'){
				sReturnCategory = 'engine';				
			} else if(sReturnCategory == 'aanhangwagen'){
				sReturnCategory = 'trailer';				
			}
			
			if(typeof oBrandSet[sReturnCategory] != 'undefined'){				
				
				var brandList = '<div class="brands-container" id="brands-container">'+			
					'<div class="brand" id="set-brands-container">';					
						
						brandList += '<div id="brand-search" class="brand-search"><input autocomplete="false" type="text" name="brand-search-input" id="brand-search-input" value="" placeholder="Zoek in merken" /></div>';
					
						//var oArticleBrand = jQuery('#article-brand');
						//var aArticleBrand = '';
						
						//if(oArticleBrand != '' && typeof oArticleBrand != 'undefined'){
						//	aArticleBrand = oArticleBrand.val();
						//}
						
						var aArticleBrand = !articleBrand ? false : articleBrand;

						jQuery.each(oBrandSet[sReturnCategory], $.proxy(function(index, item) {
														
							//var sBrandSearch = $.parseJSON(item.search);
							var sBrandSearch = item.brand;
										
							brandList += '<label class="brand-label" for="set-brand-' + index + '">' + item.brand + '</label>';
							brandList += '<input class="brand-radio" type="radio" name="set-brand" id="set-brand-' + index + '" value="' + item.brand + '"';
							brandList += sBrandSearch == aArticleBrand ? ' checked="checked"' : '';
							brandList += '>';
														
						}, this));
						
					brandList += '</div>'+
				'</div>';
				
				jQuery('.add-edit-subgroup.brand .article-form').append(brandList);
				
				jQuery( "input.brand-radio" ).checkboxradio({
				  icon: false
				});
				
				var sCurrentSubGroup = sessionStorage.getItem('active_sub_group') !== null ? sessionStorage['active_sub_group'] : '';
				
				if(articleID != '' || sCurrentSubGroup == 'model-active' || sCurrentSubGroup == 'version-active'){
					
					if(articleID != ''){					
						parseModels();
						parseVersions();					
					} else if(sCurrentSubGroup == 'model-active'){						
						parseModels();
					} else if(sCurrentSubGroup == 'version-active'){
						parseVersions();
					}
				}
				
			} else {
				jQuery('.add-edit-subgroup.brand .article-form').html('<div class="notice-container"><div class="notice">Voor de gekozen categorie zijn geen merken beschikbaar.</div></div>');
			}			
		}
		
		
		setLoadingOverlay('fadeout');		
	}
	
	jQuery(document).on("keyup blur","#division-search-input",function(e) {
		
		var sDivisionSearchInputValue = jQuery('#division-search-input').val();
		
		if(sDivisionSearchInputValue.length > 1){		
			
			jQuery.each(jQuery('.division-label'), $.proxy(function(index, item) {						
				
				var sLabelValue = jQuery(item).text();
				
				if(sLabelValue.indexOf(capitalizeFirstLetterOfString(sDivisionSearchInputValue)) === -1 && sLabelValue.indexOf((sDivisionSearchInputValue)) === -1){
					jQuery(item).addClass('search-not-found');
				} else {
					jQuery(item).removeClass('search-not-found');
				}			
										
			}, this));
			
		} else {
			jQuery('.division-label').removeClass('search-not-found');
		}
		
		
	});
	
	jQuery(document).on("keyup blur","#accessory-search-input",function(e) {
		
		var sAccessorySearchInputValue = jQuery('#accessory-search-input').val();
		
		if(sAccessorySearchInputValue.length > 1){		
			
			jQuery.each(jQuery('.accessory-label'), $.proxy(function(index, item) {						
				
				var sLabelValue = jQuery(item).text();
				
				if(sLabelValue.indexOf(capitalizeFirstLetterOfString(sAccessorySearchInputValue)) === -1 && sLabelValue.indexOf((sAccessorySearchInputValue)) === -1){
					jQuery(item).addClass('search-not-found');
				} else {
					jQuery(item).removeClass('search-not-found');
				}			
										
			}, this));
			
		} else {
			jQuery('.accessory-label').removeClass('search-not-found');
		}
		
		
	});
	
	jQuery(document).on("keyup blur","#brand-search-input",function(e) {
		
		var sBrandSearchInputValue = jQuery('#brand-search-input').val();
		
		if(sBrandSearchInputValue.length > 1){				
			
			jQuery.each(jQuery('.brand-label'), $.proxy(function(index, item) {						
				
				var sLabelValue = jQuery(item).text();
				
				if(sLabelValue.indexOf(capitalizeFirstLetterOfString(sBrandSearchInputValue)) === -1 && sLabelValue.indexOf((sBrandSearchInputValue)) === -1){
					jQuery(item).addClass('search-not-found');
				} else {
					jQuery(item).removeClass('search-not-found');
				}			
										
			}, this));
			
		} else {
			jQuery('.brand-label').removeClass('search-not-found');
		}
		
		
	});
	
	jQuery(document).on("keyup blur","#version-search-input",function(e) {
		
		var sVersionSearchInputValue = jQuery('#version-search-input').val();
		
		if(sVersionSearchInputValue.length > 1){				
			
			jQuery.each(jQuery('.version-label'), $.proxy(function(index, item) {						
				
				var sLabelValue = jQuery(item).text();
				
				if(sLabelValue.indexOf(capitalizeFirstLetterOfString(sVersionSearchInputValue)) === -1 && sLabelValue.indexOf((sVersionSearchInputValue)) === -1){
					jQuery(item).addClass('search-not-found');
				} else {
					jQuery(item).removeClass('search-not-found');
				}			
										
			}, this));
			
		} else {
			jQuery('.version-label').removeClass('search-not-found');
		}
		
		
	});
	
	jQuery(document).on("keyup blur","#engine-brand-search-input",function(e) {
		
		var sBrandSearchInputValue = jQuery('#engine-brand-search-input').val();
		
		if(sBrandSearchInputValue.length > 1){		
		
			
			jQuery.each(jQuery('.engine-brand-label'), $.proxy(function(index, item) {						
				
				var sLabelValue = jQuery(item).text();
				
				if(sLabelValue.indexOf(capitalizeFirstLetterOfString(sBrandSearchInputValue)) === -1 && sLabelValue.indexOf((sBrandSearchInputValue)) === -1){
					jQuery(item).addClass('search-not-found');
				} else {
					jQuery(item).removeClass('search-not-found');
				}			
										
			}, this));
			
		} else {
			jQuery('.engine-brand-label').removeClass('search-not-found');
		}
		
		
	});
	
	jQuery(document).on("keyup blur","#model-search-input",function(e) {
		
		var sModelSearchInputValue = jQuery('#model-search-input').val();
		
		if(sModelSearchInputValue.length > 1){		
			
			jQuery.each(jQuery('.model-label'), $.proxy(function(index, item) {						
				
				var sLabelValue = jQuery(item).text();
				
				if(sLabelValue.indexOf(capitalizeFirstLetterOfString(sModelSearchInputValue)) === -1 && sLabelValue.indexOf((sModelSearchInputValue)) === -1){
					jQuery(item).addClass('search-not-found');
				} else {
					jQuery(item).removeClass('search-not-found');
				}			
										
			}, this));
			
		} else {
			jQuery('.model-label').removeClass('search-not-found');
		}
		
		
	});

	function parseModels() {
		
		var sReturnCategory = articleCategory; //jQuery('input[name="set-category"]:checked').val();
		var sReturnBrand = articleBrand; //jQuery('input[name="set-brand"]:checked').val();
		
		//if(sReturnBrand == '' || typeof sReturnBrand == 'undefined' || sReturnBrand == 'undefined'){
			//sReturnBrand = jQuery('#article-brand').val();
		//}
					
		if(jQuery('#set-models-container').length > 0){
		
			if(jQuery('input.model-radio:checked').length){
				jQuery('input.model-radio:checked').button( "refresh" );
			}
			
			jQuery('.notice-container').remove();
			
		} else if(sReturnBrand == '' || typeof sReturnBrand == 'undefined' || sReturnBrand == 'undefined'){
			
			jQuery('.add-edit-subgroup.model .article-form').html('<div class="notice-container"><div class="notice">Kies eerst een merk om vervolgens een model te kunnen selecteren.</div><div class="direct-to brand">Klik hier om een merk te selecteren</div></div>');
			
		} else {
			
			jQuery('.notice-container').remove();
			
			sReturnBrand = sReturnBrand.toLowerCase();
			sReturnCategory = sReturnCategory.toLowerCase();
			
			if(sReturnCategory == 'vouwwagen'){
				sReturnCategory = 'tenttrailer';
			} else if(sReturnCategory == 'stacaravan'){
				sReturnCategory = 'mobilehome';				
			} else if(sReturnCategory == 'boot'){
				sReturnCategory = 'boat';				
			} else if(sReturnCategory == 'boottrailer'){
				sReturnCategory = 'boattrailer';				
			} else if(sReturnCategory == 'motor'){
				sReturnCategory = 'engine';				
			} else if(sReturnCategory == 'aanhangwagen'){
				sReturnCategory = 'trailer';				
			}
			
			if(typeof oBrandSet[sReturnCategory][sReturnBrand]['models'] != 'undefined'){	
				
				var modelList = '';
				
				modelList += '<div id="model-search" class="model-search"><input autocomplete="false" type="text" name="model-search-input" id="model-search-input" value="" placeholder="Zoek in modellen" /></div>';
				
				var aArticleModel = !articleModel ? false : articleModel;			

				jQuery.each(oBrandSet[sReturnCategory][sReturnBrand]['models'], $.proxy(function(index, item) {
	
					var sModelSearch = $.parseJSON(item.search);
	
					modelList += '<label class="model-label" for="set-model-' + index + '">' + item.model + '</label>';
					modelList += '<input class="model-radio" type="radio" name="set-model" id="set-model-' + index + '" value="' + item.model + '"';
					modelList += sModelSearch == aArticleModel ? ' checked="checked"' : '';
					modelList += '>';
												
				}, this));
				
				var modelListHTML = '<div class="models-container" id="models-container">'+			
					'<div class="model" id="set-models-container">' + modelList + '</div>'+
				'</div>';
			
			
				jQuery('.add-edit-subgroup.model .article-form').append(modelListHTML);
				
				jQuery( "input.model-radio" ).checkboxradio({
					icon: false
				});
				
			} else {
				jQuery('.add-edit-subgroup.model .article-form').html('<div class="notice-container"><div class="notice">Voor het gekozen merk zijn geen modellen beschikbaar.</div></div>');
				
				jQuery('.article-input-subgroup.model').addClass('active');				
				var sReturnModel = '';
				
				jQuery('#model-set-value').html(capitalizeFirstLetterOfString(sReturnModel));				
				
			}			
		}
		
		setLoadingOverlay('fadeout');		
	}
	
	function getModels() {
		
		oSavedBrandSet = sessionStorage.getItem('brand_set') !== null ? sessionStorage['brand_set'] : '';
		
		//oSavedBrandSet = '';
				
		if(oSavedBrandSet != ''){
			
			var oData = $.parseJSON(oSavedBrandSet);
			
			oBrandSet = (oData === false ? false : oData);
			
			/*
			 * Parse articles			 
			 */
			 
			parseModels();
				
		} else {
			
			jQuery('.add-edit-subgroup.model .article-form').html('<div class="notice-container"><div class="notice">Kies eerst een merk om vervolgens een model te selecteren.</div><div class="direct-to brand">Klik hier om een merk te selecteren</div></div>');
			
			setLoadingOverlay('fadeout');
			
		}
	}
	
	function getPhotoLabels() {
		
		setLoadingOverlay('fadein');
				
		oSavedPhotoLabels = sessionStorage.getItem('photolabels_set') !== null ? sessionStorage['photolabels_set'] : '';
				
		if(oSavedPhotoLabels != ''){
			
			var oData = $.parseJSON(oSavedPhotoLabels);
			
			oPhotoLabels = (oData === false ? false : oData);
			
			/*
			 * Parse articles			 
			 */

			parsePhotoLabels();
				
		} else {
		
			$.post(baseHref() + 'catalog', { 

				module: 'getPhotoLabels'
				
			}, function(data) {
				
				sessionStorage['photolabels_set'] = data;
				
				var oData = $.parseJSON(data);				
				
				oPhotoLabels = (oData === false ? false : oData);
				
				sessionStorage['photolabels_set'] = data;
				
				/*
				 * Parse articles			 
				 */

				parsePhotoLabels();

			});
		}		
	}
	
	
	function getVersions() {
		
		if(typeof jQuery('.add-edit-subgroup.version') == 'undefined' || jQuery('.add-edit-subgroup.version').length == 0){
			return;
		}
				
		var articleCategoryFromEdit = articleCategory;
		
		if(articleCategoryFromEdit == ''){
			if(sessionStorage.getItem('current_category') !== null){
				articleCategoryFromEdit = sessionStorage['current_category'];
			}
		}
		
		var articleBrandFromEdit = articleBrand;
		
		if(articleBrandFromEdit == ''){
			if(sessionStorage.getItem('current_brand') !== null){
				articleBrandFromEdit = sessionStorage['current_brand'];
			}
		}
		
		var articleModelFromEdit = articleModel;
		
		if(articleModelFromEdit == ''){
			if(sessionStorage.getItem('current_model') !== null){
				articleModelFromEdit = sessionStorage['current_model'];
			}
		}
		
		oSavedVersionSet = sessionStorage.getItem('version_set') !== null ? sessionStorage['version_set'] : '';
		
		var bValidVersionSet = false;
		
		if(oSavedVersionSet != ''){
			
			var oData = $.parseJSON(oSavedVersionSet);
			
			if(oData.category == articleCategoryFromEdit && oData.brand == articleBrandFromEdit  && oData.model == articleModelFromEdit ){
				bValidVersionSet = true;
			}
			
		}
			
		if(bValidVersionSet === true){
			
			var oData = $.parseJSON(oSavedVersionSet);
			
			oVersionSet = (oData === false ? false : oData);
			
			parseVersions();
				
		} else {
		
			$.post(baseHref() + 'catalog', { 

				module: 'getVersions',
				versionsCategory: articleCategoryFromEdit,
				versionsBrand: articleBrandFromEdit,
				versionsModel: articleModelFromEdit
				
			}, function(data) {
				
				sessionStorage['version_set'] = data;
				
				var oData = $.parseJSON(data),
					iTotalItems,
					sHTML;
											
				oVersionSet = (oData === false ? false : oData);
				
				if(oVersionSet == false){					
					sessionStorage.removeItem('version_set');
				} else {				
					sessionStorage['version_set'] = data;
				}
				
				parseVersions();

			});
		}
	}
	
	function getBrands() {
		
		oSavedBrandSet = sessionStorage.getItem('brand_set') !== null ? sessionStorage['brand_set'] : '';
				
		if(oSavedBrandSet != ''){
			
			var oData = $.parseJSON(oSavedBrandSet);
			
			oBrandSet = (oData === false ? false : oData);
			
			/*
			 * Parse articles			 
			 */

			parseBrands();
				
		} else {
		
			$.post(baseHref() + 'catalog', { 

				module: 'getBrands'
				
			}, function(data) {
				
				sessionStorage['brand_set'] = data;
				
				var oData = $.parseJSON(data),
					iTotalItems,
					sHTML;
				
							
				oBrandSet = (oData === false ? false : oData);
				
				sessionStorage['brand_set'] = data;
				
				/*
				 * Parse articles			 
				 */
				parseBrands();

			});
		}		

	}
	
	function getCategories() {
		
		oSavedCategoriesSet = sessionStorage.getItem('categories_set') !== null ? sessionStorage['categories_set'] : '';
						
		if(oSavedCategoriesSet != ''){
			
			var oData = $.parseJSON(oSavedCategoriesSet);
			
			oCategoriesSet = (oData === false ? false : oData);
			
			/*
			 * Parse articles			 
			 */

			parseCategories();
			parseSubCategories();
				
		} else {
		
			$.post(baseHref() + 'catalog', { 

				module: 'getCategories'
				
			}, function(data) {
				
				sessionStorage['categories_set'] = data;
				
				var oData = $.parseJSON(data),
					iTotalItems,
					sHTML;
				
							
				oCategoriesSet = (oData === false ? false : oData);
				
				sessionStorage['categories_set'] = data;
				
				/*
				 * Parse articles			 
				 */

				parseCategories();
				parseSubCategories();

			});
		}		

	}
	
	function getAccessories() {
		
		oSavedAccessoriesSet = sessionStorage.getItem('accessories_set') !== null ? sessionStorage['accessories_set'] : '';
				
		if(oSavedAccessoriesSet != ''){
			
			var oData = $.parseJSON(oSavedAccessoriesSet);
			
			oAccessoriesSet = (oData === false ? false : oData);
			
			/*
			 * Parse articles			 
			 */

			parseAccessories();
				
		} else {
		
			$.post(baseHref() + 'catalog', { 

				module: 'getAccessories'
				
			}, function(data) {
				
				sessionStorage['accessories_set'] = data;
				
				var oData = $.parseJSON(data),
					iTotalItems,
					sHTML;
				
							
				oAccessoriesSet = (oData === false ? false : oData);
				
				sessionStorage['accessories_set'] = data;
				
				/*
				 * Parse articles			 
				 */

				parseAccessories();

			});
		}		

	}
	
	function getDivisions() {
		
		oSavedDivisionsSet = sessionStorage.getItem('divisions_set') !== null ? sessionStorage['divisions_set'] : '';
				
		if(oSavedDivisionsSet != ''){
			
			var oData = $.parseJSON(oSavedDivisionsSet);
			
			oDivisionsSet = (oData === false ? false : oData);
			
			/*
			 * Parse articles			 
			 */

			parseDivisions();
				
		} else {
		
			$.post(baseHref() + 'catalog', { 

				module: 'getDivisions'
				
			}, function(data) {
				
				sessionStorage['divisions_set'] = data;
				
				var oData = $.parseJSON(data),
					iTotalItems,
					sHTML;
				
							
				oDivisionsSet = (oData === false ? false : oData);
				
				sessionStorage['divisions_set'] = data;
				
				/*
				 * Parse articles			 
				 */

				parseDivisions();

			});
		}
	}	
	
	if(jQuery("#images").length){		
		jQuery( "#images" ).sortable({
			cancel: ".no-sorting",
			delay: 200,
			disabled: true,
			handle: '.sort-image',
			placeholder: "image-sort-placeholder",	

			start: function (e, ui) {
				ui.helper.addClass('highlight');
			},
			beforeStop: function (e, ui) {
				ui.helper.removeClass('highlight');
			},
			
			stop: function(){
				
				jQuery('.no-sorting').remove();
				
				var iImagesSet = jQuery('.image-container').length;
				
				if(iImagesSet < 24){				
					jQuery("#images").append('<div class="image-container no-sorting ui-sortable-handle" id="add-new"><div class="image-content add-picture add-new-image"></div></div>');	
				}				
				
				var aImageArray = '';
					
				if(jQuery('.image-container').length){
					
					jQuery.each(jQuery('.image-container'), $.proxy(function(index, item) {						
						
						if(typeof jQuery(item).data('imgurl') != 'undefined' && jQuery(item).data('imgurl') != ''){
							
							if(aImageArray == ''){								
								aImageArray = [];
							}
							
							var sImageURLToSave = jQuery(item).data('imgurl');
														
							if(sImageURLToSave.substring(0, 12) == '/afbeelding/'){
								aImageRaw = sImageURLToSave.split("?");
					
								aImageRaw = aImageRaw.filter(function (el) {
									return el != null && el != "";
								});									
								
								if(typeof aImageRaw[0] != 'undefined'){
									sImageURLToSave = aImageRaw[0];
								}							
							}
							
							aImageArray.push(sImageURLToSave);
							
						}							
					}, this));
				} 
				
				if(aImageArray == ''){
					sessionStorage.removeItem('current_images');
				} else {
					
					var icountImage = 1;
					
					jQuery.each(aImageArray, $.proxy(function(index, item) {	
					
						jQuery('#picture-'+icountImage).css({'background-image' : 'url(' + item + ')' });
							
						icountImage++;
						
					}, this));					
					
					sessionStorage['current_images'] = JSON.stringify(aImageArray);					
				}
			}
		});
	}
	
	if(jQuery("#set-marktplaats-pricetype").length){
		var marktplaatsPricetypeSelect2 = jQuery('#set-marktplaats-pricetype').select2({
			allowClear: true,
			minimumResultsForSearch: -1,
			width: '100%',
			placeholder: 'Kies prijsstelling',
			language: "nl",
			dropdownParent: jQuery('#marktplaats-pricetype-container')
		});	

		jQuery('#set-marktplaats-pricetype').on('select2:clear', function (e) {
			
			jQuery(this).data('unselecting', true);
			
			jQuery('.marktplaats-container.price').addClass('hidden-price');			
			jQuery('.marktplaats-container.bidprice').addClass('hidden-price');			
			jQuery('.marktplaats-container.minimalbidprice').addClass('hidden-price');

		});	

		jQuery('#set-marktplaats-pricetype').on('select2:opening', function (e) {
			
			 if (jQuery(this).data('unselecting')) {
				jQuery(this).removeData('unselecting');
				e.preventDefault();
			}
		});		
		
	}
	
	if(jQuery(".sleep-container-bed").length){		
		
		jQuery.each(jQuery('.sleep-container-bed'), $.proxy(function(index, item) {	

			var iElementSelector = jQuery(item).data('bedid');
			
			if(typeof iElementSelector != 'undefined' && iElementSelector > 0 ){
			
				jQuery('#set-bed-type-' + iElementSelector).select2({
					allowClear: true,
					minimumResultsForSearch: -1,
					width: '100%',
					placeholder: 'Kies bedtype',
					language: "nl",
					dropdownParent: jQuery('#sale-beds-select-container-' + iElementSelector)
				});
				
				jQuery('#set-bed-type-' + iElementSelector).on('select2:select', function (e) {	
					if(typeof e.params.data.id != 'undefined'  ){
						sessionStorage['current_bed-type-'+iElementSelector] = e.params.data.id;
					}					
				});
				
				jQuery('#set-bed-type-' + iElementSelector).on('select2:clear', function (e) {			
					jQuery(this).data('unselecting', true);
					sessionStorage.removeItem('current_bed-type-'+iElementSelector);
				});	

				jQuery('#set-bed-type-' + iElementSelector).on('select2:opening', function (e) {
					
					 if (jQuery(this).data('unselecting')) {
						jQuery(this).removeData('unselecting');
						e.preventDefault();
					}
				});
			}			
			
		}, this));
	}
	
	if(jQuery("#set-period").length){
		var periodSelect2 = jQuery('#set-period').select2({
			allowClear: true,
			minimumResultsForSearch: -1,
			width: '100%',
			placeholder: 'Kies periode',
			language: "nl",
			dropdownParent: jQuery('#sale-period-container')
		});	
		
		jQuery('#set-period').on('select2:clear', function (e) {			
			jQuery(this).data('unselecting', true);
		});	

		jQuery('#set-period').on('select2:opening', function (e) {
			
			 if (jQuery(this).data('unselecting')) {
				jQuery(this).removeData('unselecting');
				e.preventDefault();
			}
		});
	}
	
	jQuery(document).on("change",".checkboxinput",function(e) {
			
		var sCurrentId = jQuery(this).attr('id');
		var sCurrentName = sCurrentId.replace('set-','');
		
		var sCurrentState = jQuery("#" + sCurrentId).prop('checked');

		var sEditIndicator = jQuery(this).closest('.add-edit-subgroup').data('groupname');
		
		sessionStorage['edit_indicator'] = sEditIndicator;	
				
		if(sCurrentState === true){
			sessionStorage['current_'+sCurrentName] = sCurrentName;	
		} else {
			sessionStorage.removeItem('current_' + sCurrentName);					
		}
	});	
	
	if(jQuery( "input.select-radio" ).length){
		jQuery( "input.select-radio" ).checkboxradio({
		  icon: false
		});
		
		jQuery(document).on("change","input.select-radio",function(e) {
			
			var sReturnField = jQuery(this).closest('.select-radio-container').data('field');
			var sCurrentState = jQuery(this).prop('checked');
						
			if(sCurrentState === true){
				jQuery('input.' + sReturnField + '-radio').prop('checked',false).button( "refresh" );
				jQuery(this).prop('checked',true).button( "refresh" );			
			}
		
			var sReturnValue= jQuery('input[name="set-' + sReturnField + '"]:checked').val();			
			var sReturnValueClean= jQuery('input[name="set-' + sReturnField + '"]:checked').val();
			
			if(sReturnField == 'euro-class'){				
				sReturnValue= 'Klasse ' + sReturnValue;
			} else if(sReturnField == 'seats'){					
				sReturnValue += sReturnValue == '1' ? ' zitplaats' : ' zitplaatsen';
			} else if(sReturnField == 'seatbelts'){					
				sReturnValue += sReturnValue == '1' ? ' gordel' : ' gordels';
			} else if(sReturnField == 'owners'){					
				sReturnValue += sReturnValue == '1' ? ' eigenaar' : ' eigenaren';
			} else if(sReturnField == 'number-of-doors'){					
				sReturnValue += sReturnValue == '1' ? ' deur' : ' deuren';
			} else if(sReturnField == 'axles'){					
				sReturnValue += sReturnValue == '1' ? ' as' : ' assen';
			} else if(sReturnField == 'boattrailer-axles'){					
				sReturnValue += sReturnValue == '1' ? ' as' : ' assen';
			} else if(sReturnField == 'persons-boat'){					
				sReturnValue += sReturnValue == '1' ? ' persoon' : ' personen';
			} else if(sReturnField == 'bedrooms'){					
				sReturnValue += sReturnValue == '1' ? ' slaapkamer' : ' slaapkamers';
			} else if(sReturnField == 'beds-boat'){					
				sReturnValue += sReturnValue == '1' ? ' bed' : ' bedden';
			} else if(sReturnField == 'period'){					
				sReturnValue += sReturnValue == '1' ? ' maand' : ' maanden';
			}
			
			if(sReturnField == 'marktplaats-pricetype'){

				jQuery('.marktplaats-container.price').addClass('hidden-price');			
				jQuery('.marktplaats-container.bidprice').addClass('hidden-price');			
				jQuery('.marktplaats-container.minimalbidprice').addClass('hidden-price');	

				if(sReturnValue == 'bieden'){
					jQuery('.marktplaats-container.bidprice').removeClass('hidden-price');			
					jQuery('.marktplaats-container.minimalbidprice').removeClass('hidden-price');

				} else if(sReturnValue == 'vaste prijs'){			
					jQuery('.marktplaats-container.price').removeClass('hidden-price');
				}
			}			
			
			var defaultLabel = jQuery("#open-sub-" + sReturnField).data('default');		
			var sTitleToSet = 'Kenmerken';		
			jQuery('#title-container').html(sTitleToSet);
			
			jQuery('.status-group').removeClass('hidden');
			
			jQuery('.notice-container').remove();
						
			var sEditIndicator = jQuery(this).closest('.add-edit-subgroup').data('groupname');			
			sessionStorage['edit_indicator'] = sEditIndicator;	
									
			if(typeof sReturnValue != 'undefined' && sReturnValue != ''){		
				jQuery('#open-sub-' + sReturnField).addClass('active');
				jQuery('#open-sub-' + sReturnField).closest('.select-radio-container').addClass('active');
				jQuery('#open-sub-' + sReturnField).html(capitalizeFirstLetterOfString(sReturnValue));
				
				sessionStorage['current_' + sReturnField] = sReturnValueClean;	
			} else {
				jQuery('#open-sub-' + sReturnField).removeClass('active');
				jQuery('#open-sub-' + sReturnField).closest('.select-radio-container').removeClass('active');
				jQuery('#open-sub-' + sReturnField).html(defaultLabel);	

				sessionStorage.removeItem('current_' + sReturnField);	
			}
			
			jQuery('.has-open-sub').removeClass('has-open-sub');		
			jQuery('#sub-' + sReturnField).removeClass('active');	
			jQuery('.active-sub-container').removeClass('active-sub-container');	
			jQuery('body').removeClass('sub-active');
			
			sessionStorage.removeItem('active_sub_sub_group');
			
			if(jQuery("#sale-" + sReturnField + "-container").length){
				jQuery('html, body').scrollTop($("#sale-" + sReturnField + "-container").offset().top-90);	
			} else if(jQuery("#" + sReturnField + "-container").length) {
				jQuery('html, body').scrollTop($("#" + sReturnField + "-container").offset().top-90);	
			}
		});		
	}

	if(jQuery( "input.status-radio" ).length){
		jQuery( "input.status-radio" ).checkboxradio({
			icon: false
		});
		
		jQuery(document).on("change","input.status-radio",function(e) {
			
			var sCurrentState = jQuery(this).prop('checked');
						
			if(sCurrentState === true){
				jQuery('input.status-radio').prop('checked',false).button( "refresh" );
				jQuery(this).prop('checked',true).button( "refresh" );			
			}			
			
			var sReturnFuel= jQuery('input[name="set-status"]:checked').val();
			var defaultLabel = jQuery("#open-sub-status").data('default');		
			
			var sTitleToSet = 'Advertentie aanmaken';
		
			if(articleID != ''){			
				sTitleToSet = 'Advertentie bewerken';
			}		
			
			jQuery('#title-container').html(sTitleToSet);	
			
			jQuery('.notice-container').remove();

			if(typeof sReturnFuel != 'undefined' && sReturnFuel != ''){		
				jQuery('#open-sub-status').addClass('active');
				jQuery('#open-sub-status').closest('.status-container').addClass('active');
				jQuery('#open-sub-status').html(capitalizeFirstLetterOfString(sReturnFuel));
				
				sessionStorage['current_status'] = sReturnFuel;	
			} else {
				jQuery('#open-sub-status').removeClass('active');
				jQuery('#open-sub-status').closest('.status-container').removeClass('active');
				jQuery('#open-sub-status').html(defaultLabel);	
				
				sessionStorage.removeItem('current_status');
			}
			
			jQuery('.has-open-sub').removeClass('has-open-sub');		
			jQuery('#sub-status').removeClass('active');	
			jQuery('.active-sub-container').removeClass('active-sub-container');	
			jQuery('body').removeClass('sub-active');
			
			sessionStorage.removeItem('active_sub_sub_group');

			jQuery('html, body').scrollTop($("#sale-status-container").offset().top-90);
			
		});
	}
	
	jQuery( "input.checkbox-input" ).checkboxradio({
      icon: false
    });
	
	jQuery( "input.online-radio" ).checkboxradio({
      icon: false
    });
	
	
	//jQuery( "input.period-radio" ).checkboxradio({
    //  icon: false
    //});
	
});