$(function() {
	
	var pendingActive = false;
	var pendingRunning = false;
	
	setLoadingOverlay('fadein');
	
	jQuery.initMarktplaats = function () {	

		jQuery.getMarktplaatStatus();
		
	}	
	
	setTimeout(function() {
		
		if(jQuery('#marktplaats-overview').length > 0){
			jQuery.initMarktplaats();			
		}
		
	}, 500);	
		
	jQuery.getPendingItems = function () { 
		
		pendingRunning = true;		
		
		jQuery('.marktplaats-actions.pending').each(function(){
			
			var iArticleID = jQuery(this).data('articleid');
						
			$.post(baseHref() + 'ovismarktplaats', { 

				module: 'getMarktplaatsArticleStatus',
				article: iArticleID			
				
			}, function(data) {
				
				oData = $.parseJSON(data);
				
				if(oData.pendingadd == 0){
					jQuery('#marktplaats-status-' + iArticleID).removeClass('pending');					
				}
				
				if(oData.adactive == 1){
					jQuery('#marktplaats-status-' + iArticleID).addClass('active');					
				}
			});
			
			
			
		}).promise().done(function(){
			if(jQuery('.marktplaats-actions.pending').length == 0){
				pendingActive = false;
			}
			
			pendingRunning = false;
			
		});	
	}	
	
	jQuery.getMarktplaatStatus = function () { 
	
		
		$.post(baseHref() + 'ovismarktplaats', { 

			module: 'getMarktplaatsStatus'
			
		}, function(data) {			
			
			oData = $.parseJSON(data);
			
			if(jQuery('.griditem-container').length > 0){		
				if(oData == 'marktplaats-active'){
					jQuery('.articles-contain').addClass('marktplaats-active');	
					
					function checkPendingItems() {	
						
						if(!pendingRunning){
						
							if(!pendingActive){
								
								if(jQuery('.marktplaats-actions.pending').length > 0){
									pendingActive = true;
								}
							} else {							
								jQuery.getPendingItems();
							}
						
						} else {
							return;
						}
						
					}
					setInterval(checkPendingItems, 10000);
					
				} else {
					jQuery('.articles-contain').removeClass('marktplaats-active');
				}
			} else {
				jQuery('.ovis-marktplaats').removeClass('succes');
				jQuery('.ovis-marktplaats').removeClass('error');
				jQuery('.ovis-marktplaats').html('');
				 
				if(oData == 'marktplaats-active'){
					jQuery('.ovis-marktplaats').html('Uw marktplaats account is <span class="current-status">succesvol</span> gekoppeld').addClass('succes');
				} else {
					jQuery('.ovis-marktplaats').html('Uw marktplaats account is <span class="current-status">niet succesvol</span> gekoppeld.<br>Via de OVIS desktop omgeving kunt u uw account koppelen.').addClass('error');					
				}
					
			}				

		});		
		
		setLoadingOverlay('fadeout');
	}	
	
	jQuery.parseMarktplaatsRemove = function (articleId) { 
			
		$.post(baseHref() + 'ovismarktplaats', { 

			module: 'deleteMarktplaatsAd',
			article: articleId
			
		}, function(data) {
			
			oData = $.parseJSON(data);
					
			if(oData == 'marktplaats-delete-succes'){
				jQuery('#remove-marktplaats-content').addClass('inactive');
				jQuery('#default-marktplaats-content').addClass('inactive');
				
				jQuery('#marktplaats-remove-message').addClass('succes').html('Advertentie succesvol van Marktplaats verwijderd');
				
				jQuery('#remove-marktplaats-result').removeClass('inactive');
				
				jQuery('#marktplaats-status-' + articleId).addClass('pending');	
				
			} else {
				jQuery('#remove-marktplaats-content').addClass('inactive');
				jQuery('#default-marktplaats-content').addClass('inactive');
								
				jQuery('#marktplaats-remove-message').addClass('error').html('Advertentie niet succesvol van Marktplaats verwijderd. Probeer het later nogmaals of neem contact op met OVIS.');
				
				jQuery('#remove-marktplaats-result').removeClass('inactive');
			}		

		});		
		
		setLoadingOverlay('fadeout');
	}	
	
	jQuery.parseMarktplaatsAdd = function (articleId) { 
	
		var bAutoReplace = jQuery('#marktplaats_auto_replace').hasClass('active') ? true : false;
			
		$.post(baseHref() + 'ovismarktplaats', { 

			module: 'addMarktplaatsAd',
			article: articleId,
			autoreplace: bAutoReplace
			
		}, function(data) {
			
			oData = $.parseJSON(data);
					
			if(oData == 'marktplaats-add-succes'){
				
				jQuery('#add-marktplaats-content').addClass('inactive');
				jQuery('#default-marktplaats-content').addClass('inactive');
				
				jQuery('#marktplaats-add-message').addClass('succes').html('Advertentie succesvol op Marktplaats geplaatst');
				
				jQuery('#add-marktplaats-result').removeClass('inactive');
				
				
				jQuery('#marktplaats-status-' + articleId).addClass('pending');					
				
			} else {						
				if(oData == 'marktplaats-add-error-saldo'){
					jQuery('#add-marktplaats-content').addClass('inactive');
					jQuery('#default-marktplaats-content').addClass('inactive');
									
					jQuery('#marktplaats-add-message').addClass('error').html('U heeft onvoldoende saldo om een advertentie op Marktplaats te plaatsen. Vul het saldo aan en probeer het nogmaals.<br>');
					
					jQuery('#add-marktplaats-result').removeClass('inactive');
				} else {
				
					jQuery('#add-marktplaats-content').addClass('inactive');
					jQuery('#default-marktplaats-content').addClass('inactive');
									
					jQuery('#marktplaats-add-message').addClass('error').html('Advertentie niet succesvol op Marktplaats geplaatst. Probeer het later nogmaals of neem contact op met OVIS.');
					
					jQuery('#add-marktplaats-result').removeClass('inactive');
				}
				
			}

		});		
		
		setLoadingOverlay('fadeout');
	}
	
	jQuery.addMarktplaats = function(action){
		if(action == 'init'){
			
			jQuery('#marktplaats_auto_replace').removeClass('active');
			jQuery('#add-marktplaats-content').removeClass('inactive');
			jQuery('#default-marktplaats-content').addClass('inactive');
			jQuery('#add-marktplaats-result').addClass('inactive');
			
		} else if(action == 'confirm'){
			
			
			jQuery('#marktplaats_auto_replace').removeClass('active');
			jQuery('#default-marktplaats-content').removeClass('inactive');
			jQuery('#add-marktplaats-content').addClass('inactive');
			jQuery('#add-marktplaats-result').addClass('inactive');
			
			jQuery('#marktplaats-add-message').removeClass('succes').removeClass('error').html('');
			
			oLightboxMarktplaats.close();
			
		} else if(action == 'close'){			
			
			jQuery('#marktplaats_auto_replace').removeClass('active');
			jQuery('#default-marktplaats-content').removeClass('inactive');
			jQuery('#add-marktplaats-content').addClass('inactive');
			jQuery('#add-marktplaats-result').addClass('inactive');
			
		} else {
			
			jQuery('#default-marktplaats-content').addClass('inactive');
			jQuery('#add-marktplaats-result').addClass('inactive');
			jQuery('#add-marktplaats-content').addClass('processing');
						
			jQuery.parseMarktplaatsAdd(action);			
		}
	}
	
	jQuery.featureMarktplaats = function(action, feature){	
		if(action == 'init'){
			
			jQuery('#feature-marktplaats-content').removeClass('inactive');
			jQuery('#default-marktplaats-content').addClass('inactive');
			jQuery('#feature-marktplaats-result').addClass('inactive');
			
		} else if(action == 'confirm'){			
			
			jQuery('#default-marktplaats-content').removeClass('inactive');
			jQuery('#feature-marktplaats-content').addClass('inactive');
			jQuery('#feature-marktplaats-result').addClass('inactive');
			
			jQuery('#marktplaats-feature-message').removeClass('succes').removeClass('error').html('');
			
			oLightboxMarktplaats.close();
			
		} else if(action == 'close'){			
			
			jQuery('#default-marktplaats-content').removeClass('inactive');
			jQuery('#feature-marktplaats-content').addClass('inactive');
			jQuery('#feature-marktplaats-result').addClass('inactive');
			
		} else {
			
			jQuery('#default-marktplaats-content').addClass('inactive');
			jQuery('#feature-marktplaats-result').addClass('inactive');
			jQuery('#feature-marktplaats-content').addClass('processing');
			
			jQuery.parseMarktplaatsFeature(action, feature);			
		}
	}
	
	jQuery.parseMarktplaatsFeature = function (articleId,sFeature) {	
		
		$.post(baseHref() + 'ovismarktplaats', { 

			module: 'featureMarktplaatsAd',
			article: articleId,
			feature: sFeature
			
		}, function(data) {
			
			oData = $.parseJSON(data);
					
			if(oData == 'marktplaats-feature-succes'){
				
				jQuery('#feature-marktplaats-content').addClass('inactive');
				jQuery('#default-marktplaats-content').addClass('inactive');
				
				jQuery('#marktplaats-feature-message').addClass('succes').html('Advertentie succesvol omhoog geplaatst op Marktplaats.<br>');
				
				jQuery('#feature-marktplaats-result').removeClass('inactive');
				
				jQuery('#marktplaats-status-' + articleId).addClass('pending');	
				
			} else {						
				
				jQuery('#feature-marktplaats-content').addClass('inactive');
				jQuery('#default-marktplaats-content').addClass('inactive');
									
				jQuery('#marktplaats-feature-message').addClass('error').html('Advertentie niet succesvol omhoog geplaatst op Marktplaats. Probeer het later nogmaals of neem contact op met OVIS.<br>');
					
				jQuery('#feature-marktplaats-result').removeClass('inactive');
								
			}

		});		
		
		setLoadingOverlay('fadeout');
	}
	
	jQuery.deleteMarktplaats = function(action){	
		if(action == 'init'){
			
			jQuery('#remove-marktplaats-content').removeClass('inactive');
			jQuery('#default-marktplaats-content').addClass('inactive');
			jQuery('#remove-marktplaats-result').addClass('inactive');
			
		} else if(action == 'confirm'){			
			
			jQuery('#default-marktplaats-content').removeClass('inactive');
			jQuery('#remove-marktplaats-content').addClass('inactive');
			jQuery('#remove-marktplaats-result').addClass('inactive');
			
			jQuery('#marktplaats-remove-message').removeClass('succes').removeClass('error').html('');
			
			oLightboxMarktplaats.close();
			
		} else if(action == 'close'){			
			
			jQuery('#default-marktplaats-content').removeClass('inactive');
			jQuery('#remove-marktplaats-content').addClass('inactive');
			jQuery('#remove-marktplaats-result').addClass('inactive');
			
		} else {
			
			jQuery('#remove-marktplaats-content').addClass('inactive');
			jQuery('#remove-marktplaats-result').addClass('inactive');
			jQuery('#remove-marktplaats-content').addClass('processing');
			
			jQuery.parseMarktplaatsRemove(action);			
		}		
	}

	jQuery(document).on("click","#marktplaats_auto_replace",function(e) {
		
		if(jQuery("#marktplaats_auto_replace").hasClass('active')){
			jQuery("#marktplaats_auto_replace").removeClass('active');
		} else {
			jQuery("#marktplaats_auto_replace").addClass('active');
		}		
	});
	
	jQuery(document).on("click",".marktplaats-actions",function(e) {
		var iArticleID = jQuery(this).data('articleid');
		
		$.post(baseHref() + 'ovismarktplaats', { 

			module: 'getMarktplaatsArticleStatus',
			article: iArticleID			
			
		}, function(data) {
			
			oData = $.parseJSON(data);
			
			if(typeof oData.remoteadid != 'undefined' && oData.remoteadid != ''){
				var popupMarktplaatsContent = '<div class="marktplaats-confirmation" id="marktplaats-confirmation">';
										
					popupMarktplaatsContent += '<div id="default-marktplaats-content" class="marktplaats-content">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats advertentie</h2>';
						popupMarktplaatsContent += 'Uw advertentie is actief op Marktplaats.';					
						
						popupMarktplaatsContent += '<span class="feature-marktplaats up" onclick="jQuery.featureMarktplaats(\'init\');">Omhoog plaatsen</span>';
						
						if(typeof oData.urlpreview != 'undefined'){
							popupMarktplaatsContent += '<br><a href="'+oData.urlpreview+'" target="_blank" class="view-on-marktplaats">Bekijk advertentie</a>';
						}
						
						popupMarktplaatsContent += '<span class="remove-marktplaats" onclick="jQuery.deleteMarktplaats(\'init\');">Verwijder van Marktplaats</span>';
						
					popupMarktplaatsContent += '</div>';
						
					popupMarktplaatsContent += '<div id="remove-marktplaats-content" class="marktplaats-content inactive">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats advertentie verwijderen</h2>';
						popupMarktplaatsContent += 'Weet u zeker dat u deze advertentie wilt verwijderen?';
												
						popupMarktplaatsContent += '<span class="sure" onclick="jQuery.deleteMarktplaats(\''+ oData.adid + '\');"></span>';						
						popupMarktplaatsContent += '<span class="not-sure" onclick="jQuery.deleteMarktplaats(\'close\');"></span>';				
						popupMarktplaatsContent += '<span class="processing">verwerken...</span>';				
					
					popupMarktplaatsContent += '</div>';
						
					popupMarktplaatsContent += '<div id="remove-marktplaats-result" class="marktplaats-content inactive">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats advertentie verwijderen</h2>';
						popupMarktplaatsContent += '<span id="marktplaats-remove-message" class="marktplaats-remove-message"></span>';
												
						popupMarktplaatsContent += '<span class="continue" onclick="jQuery.deleteMarktplaats(\'confirm\');">Ga verder</span>';
					
					popupMarktplaatsContent += '</div>';
					
					popupMarktplaatsContent += '<div id="feature-marktplaats-content" class="marktplaats-content inactive">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats advertentie omhoogplaatsen</h2>';
						popupMarktplaatsContent += 'Weet u zeker dat u deze advertentie omhoog wilt plaatsen? Marktplaats zal hier kosten voor in rekening brengen.';
												
						popupMarktplaatsContent += '<span class="sure" onclick="jQuery.featureMarktplaats(\''+ oData.adid + '\',\'up\');"></span>';						
						popupMarktplaatsContent += '<span class="not-sure" onclick="jQuery.featureMarktplaats(\'close\');"></span>';				
						popupMarktplaatsContent += '<span class="processing">verwerken...</span>';				
					
					popupMarktplaatsContent += '</div>';
						
					popupMarktplaatsContent += '<div id="feature-marktplaats-result" class="marktplaats-content inactive">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats advertentie verwijderen</h2>';
						popupMarktplaatsContent += '<span id="marktplaats-feature-message" class="marktplaats-feature-message"></span>';
												
						popupMarktplaatsContent += '<span class="continue" onclick="jQuery.featureMarktplaats(\'confirm\');">Ga verder</span>';
					
					popupMarktplaatsContent += '</div>';
					
				popupMarktplaatsContent += '</div>';				
			} else {
				var popupMarktplaatsContent = '<div class="marktplaats-confirmation" id="marktplaats-confirmation">';
										
					popupMarktplaatsContent += '<div id="default-marktplaats-content" class="marktplaats-content">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats advertentie</h2>';
						popupMarktplaatsContent += 'Uw advertentie is niet actief op Marktplaats.';					
						
						popupMarktplaatsContent += '<span class="feature-marktplaats add" onclick="jQuery.addMarktplaats(\'init\');">Plaatsen</span>';
						
					popupMarktplaatsContent += '</div>';
					
					popupMarktplaatsContent += '<div id="add-marktplaats-content" class="marktplaats-content inactive">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats plaatsen</h2>';
						
						if(oData.defaultCategory == '' || oData.priceSettings == ''){
														
							popupMarktplaatsContent += 'Er is geen Marktplaats prijs opgegeven voor deze advertentie.<br>';
							
							popupMarktplaatsContent += '<a href="/edit/'+iArticleID+'" class="continue">Advertentie bewerken</a><br>';
							popupMarktplaatsContent += '<span class="agree" onclick="jQuery.deleteMarktplaats(\'confirm\');">Ga verder</span>';
							
						} else {
						
							popupMarktplaatsContent += 'Weet u zeker dat u deze advertentie wilt plaatsen onder de volgende voorwaarden?<br>';
													
							if(typeof oData.defaultCategory != 'undefined' && oData.defaultCategory != ''){
								jQuery.each( oData.defaultCategory, function( key, value ) {
									popupMarktplaatsContent += '<br><span>Marktplaats categorie: <b>' + value + '</b></span>';								
								});
							}
							
							popupMarktplaatsContent += '<br><span>Marktplaats prijs: <b>' + oData.priceSettings + '</b></span>';
							popupMarktplaatsContent += '<br><span class="marktplaats_auto_replace" id="marktplaats_auto_replace">Automatisch herplaatsen</span>';
							
							popupMarktplaatsContent += '<br><br>U betaald &euro; 0.50 uit uw OVIS saldo, overige advertentiekosten brengt Marktplaats u in rekening.<br>';
													
							popupMarktplaatsContent += '<span class="sure" onclick="jQuery.addMarktplaats(\''+ oData.adid + '\');"></span>';						
							popupMarktplaatsContent += '<span class="not-sure" onclick="jQuery.addMarktplaats(\'confirm\');"></span>';				
							popupMarktplaatsContent += '<span class="processing">verwerken...</span>';
						
						}						
					
					popupMarktplaatsContent += '</div>';
					
					popupMarktplaatsContent += '<div id="add-marktplaats-result" class="marktplaats-content inactive">';					
						
						popupMarktplaatsContent += '<h2 id="marktplaats-confirmation-title">Marktplaats plaatsen</h2>';
						popupMarktplaatsContent += '<span id="marktplaats-add-message" class="marktplaats-add-message"></span>';
												
						popupMarktplaatsContent += '<span class="continue" onclick="jQuery.addMarktplaats(\'confirm\');">Ga verder</span>';
					
					popupMarktplaatsContent += '</div>';
					
				popupMarktplaatsContent += '</div>';
			}			

			oLightboxMarktplaats = SimpleLightbox.open({
				closeOnOverlayClick: false,
				closeOnEscapeKey: false,
				content: popupMarktplaatsContent,
				beforeClose: function(){
					setLoadingOverlay('fadeout');						
				}
			});
		});
		
	});		
	
});