$(function() {
	
	var oData = '';
	var oOrderId = '';
	
	setLoadingOverlay('fadein');
	
	jQuery.initSaldo = function () {				
		jQuery.getSaldo();		
		iOrderId = typeof jQuery('#saldo-overview').data('orderid') != 'undefined' ? jQuery('#saldo-overview').data('orderid') : '';
		
	}	
	
	setTimeout(function() {
		jQuery.initSaldo ();
		//do something special
	}, 1000);
	
	
	
	jQuery.parseSaldo = function () { 	
		
		var sHTML = '<div class="ovis-saldo">';			
		
		if(typeof oData.saldoStatus != 'undefined' && oData.saldoStatus == 'sufficient'){
			
			sHTML += 'Uw OVIS saldo bedraagt momenteel<span class="current-saldo">&euro; ' + oData.saldo + '</span>';			
			
		} else if(typeof oData.saldoStatus != 'undefined' && oData.saldoStatus == 'debt'){
			
			sHTML += 'Uw OVIS saldo bedraagt momenteel<span class="current-saldo">&euro; ' + oData.saldo + '</span>';			
			
		} else {
			
			sHTML += 'U heeft momenteel geen OVIS saldo';			
			
		}		
		
		sHTML += '<div class="saldo-form-add" id="saldo-form-add">';
		
			sHTML += '<div class="saldo-add" id="saldo-add">Saldo aanvullen</div>';
		
		sHTML += '</div>';
				
		sHTML += '<div class="saldo-disclaimer">Alle genoemde bedragen zijn exclusief btw.</div>';
		
		sHTML += '</div>';
				
		jQuery('#saldo-overview').append(sHTML);
		
		jQuery.parseOrderStatus();
		
		setLoadingOverlay('fadeout');
	}
	
	jQuery.getSaldo = function () {
		
		$.post(baseHref() + 'ovissaldo', { 

			module: 'getSaldo'
			
		}, function(data) {
			
			oData = $.parseJSON(data);
			
			console.log(oData);
			
			/*
			 * Parse saldo			 
			 */

			jQuery.parseSaldo();

		});			

	}
	
	jQuery.parseOrderStatus = function () {		
		if(iOrderId != false && iOrderId != ''){
			
			var sStatusHTML = '<div id="saldo-order-status" class="saldo-order-status">'+			
				'Status order ' + iOrderId + ': <i>ophalen</i>'+
			'</div>';			
			
			jQuery('#saldo-form-add').append(sStatusHTML);
			
			setTimeout(function() {
			
				$.post(baseHref() + 'ovissaldo', { 

					module: 'getOrderStatus',
					order: iOrderId
					
				}, function(data) {
					
					oData = $.parseJSON(data);
					
					if(typeof oData.status != 'undefined' && oData.status != 'no-order-found'){
						
						jQuery('#saldo-order-status').removeClass('succes').removeClass('pending').removeClass('error').removeClass('canceled').html('');
						
						if(oData.status == 'order-succes'){
							jQuery('#saldo-order-status').addClass('succes').html('Status order ' + iOrderId + ': <i>succesvol</i>');
						} else if(oData.status == 'order-pending'){
							jQuery('#saldo-order-status').addClass('pending').html('Status order ' + iOrderId + ': <i>in behandeling</i>');
						} else if(oData.status == 'order-canceled'){
							jQuery('#saldo-order-status').addClass('canceled').html('Status order ' + iOrderId + ': <i>geannuleerd</i>');
						} else if(oData.status == 'order-genreral-error'){
							jQuery('#saldo-order-status').addClass('error').html('Status order ' + iOrderId + ': <i>error</i>');
						}
						
					} else {
						jQuery('#saldo-order-status').addClass('error').html('Status order ' + iOrderId + ': <i>ongeldige order</i>');
						setTimeout(function() {
							window.location.replace('/saldo/');
							return;
						}, 3000);
					}
				});
			}, 2000);
		}
	}
	
	jQuery.cancelAddSaldo = function () {		
		
		jQuery('body').removeClass('saldo-active');
		jQuery('#new-saldo').remove();
		jQuery('#saldo-add').removeClass("hidden");
	}	
	
	jQuery(document).on("click","#saldo-add",function(e) {
		jQuery('#saldo-add').addClass("hidden");
		jQuery('body').addClass("saldo-active");
		
		jQuery('#new-saldo').remove();
		
		var sSaldoFormAdd = '<div id="new-saldo" class="new-saldo">'+		
		'<div class="new-saldo-title">Uw OVIS saldo opwaarderen</div>'+
		'<div class="new-saldo-subtitle">Kies zelf uw bedrag</div>'+
		'<input type="tel" name="saldo-amount" class="saldo-amount" maxlength="4" id="saldo-amount" placeholder="Minimaal &euro; 10,-">'+
		'<div class="new-saldo-agreement"><input type="checkbox" class="accept-saldo-agreement" name="accept-saldo-agreement" id="accept-saldo-agreement" value="accept"> akkoord <span class="show-saldo-agreement">gebruiksvoorwaarden</span></div>'+
		'<div class="new-saldo-message" id="new-saldo-message"></div>'+
		'<div class="new-saldo-actions"><span id="send-new-saldo" class="send-new-saldo">Opwaarderen</span></div>'+
		'<div class="saldo-disclaimer">Alle genoemde bedragen zijn exclusief btw.</div>'+
		'</div>';
		
		jQuery('#saldo-form-add').append(sSaldoFormAdd);
		
	});
	
	jQuery.acceptAgreement = function(){	
		oLightboxSaldoAgreement.close();
	}
	
	jQuery(document).on("click","#send-new-saldo",function(e) {
				
		var iGivenAmount = jQuery('#saldo-amount').val();
		var iGivenAgreement = jQuery('#accept-saldo-agreement').prop('checked') ? 'accepted' : 'not-accepted';
		
		jQuery('#new-saldo-message').html('').removeClass('error');
		
		if(iGivenAgreement == 'not-accepted'){
			jQuery('#new-saldo-message').html('Accepteer de gebruiksvoorwaarden').addClass('error');
		} else if(iGivenAmount == ''){
			jQuery('#new-saldo-message').html('Geef een bedrag op, minimaal &euro; 10,-').addClass('error');			
		} else if(iGivenAmount < 10 || iGivenAmount > 9999){
			jQuery('#new-saldo-message').html('Geef een in bedrag op dat ligt tussen 10 en 9.999 euro').addClass('error');			
		} else {
			setLoadingOverlay('fadein');
			$.post(baseHref() + 'ovissaldo', { 

				module: 'createPayment',
				amount: iGivenAmount,
				agreement: iGivenAgreement
				
			}, function(data) {
				
				oData = $.parseJSON(data);
				
				if(typeof oData.redirect != 'undefined' && oData.redirect != ''){
					
					window.location.replace(oData.redirect);
					return;
					
				} else {
										
					if(data == 'invalid-amount'){
						jQuery('#new-saldo-message').html('Geef een bedrag in tussen de 10 en 9.999 euro').addClass('error');
					} else {					
						jQuery('#new-saldo-message').html('Uw betaling kon niet worden uitgevoerd').addClass('error');
					}					
				}
				
				setLoadingOverlay('fadeout');

			});
		}
	});
	
	jQuery(document).on("click",".show-saldo-agreement",function(e) {
		var popupSaldoAgreementContent = '<div class="concept-confirmation" id="concept-confirmation">';
			popupSaldoAgreementContent += '<h2 id="concept-confirmation-title">Gebruiksvoorwaarden</h2>';
			popupSaldoAgreementContent += '<span class="title">Het OVIS saldo wordt gebruikt voor het afrekenen van de automatische omschrijvingsteksten (&euro; 1,50 per omschrijving) en de OVIS plaatsingskosten van advertenties op Marktplaats.nl (€ 0,50 per advertentie).';
			popupSaldoAgreementContent += '<br><br>Bedragen zijn exclusief btw.';
			popupSaldoAgreementContent += '<br><br>Uw transacties zijn terug te vinden in het transactieoverzicht.</span>';					
			popupSaldoAgreementContent += '<span class="continue" onclick="jQuery.acceptAgreement();">Begrepen</span>';
		popupSaldoAgreementContent += '</div>"';

		oLightboxSaldoAgreement = SimpleLightbox.open({
			closeOnOverlayClick: false,
			closeOnEscapeKey: false,
			content: popupSaldoAgreementContent,
			beforeClose: function(){
				setLoadingOverlay('fadeout');						
			}
		});	
	});
	
});