<?php

/*
 * Set global breadcrumb for all pages
 *  
 * @return string
 */

function setBreadcrumb($sPageName, $sParentPageName = '') {
	
	/*
	 * Parameters
	 */
	
	$sDelimiter		= '&raquo;';
	$sHome			= 'Home';
	$sParentSlug	= !empty(filter_input(INPUT_GET, 'parent')) ? filter_input(INPUT_GET, 'parent') : '';
	$sPageSlug		= !empty(filter_input(INPUT_GET, 'page')) ? filter_input(INPUT_GET, 'page') : '';
	$sArticleId		= !empty(filter_input(INPUT_GET, 'articleid')) ? filter_input(INPUT_GET, 'articleid') : '';
	$sCategoryId	= !empty(filter_input(INPUT_GET, 'categoryid')) ? filter_input(INPUT_GET, 'categoryid') : '';
	$iOrderId		= !empty(filter_input(INPUT_GET, 'orderid')) ? filter_input(INPUT_GET, 'orderid') : '';
	$sShopId		= !empty(filter_input(INPUT_GET, 'shopid')) ? filter_input(INPUT_GET, 'shopid') : '';
	
	/*
	 * Host
	 */
	
	$sHost = !empty(filter_input(INPUT_SERVER, 'SERVER_NAME', FILTER_SANITIZE_STRING)) ? filter_input(INPUT_SERVER, 'SERVER_NAME', FILTER_SANITIZE_STRING) : gethostname();

	/*
	 * Request
	 */

	$aRequest = explode('/', ltrim(filter_input(INPUT_SERVER, 'REQUEST_URI', FILTER_SANITIZE_STRING), '/'));
		
	/*
	 * Admin
	 */
	
	$bAdmin = false;
	
	if(!empty($aRequest) && $aRequest[0] == 'beheer') {
		
		$bAdmin = true;
		
	}
	
	/*
	 * Shop
	 */
	
	$bShop = false;
	
	if(!empty($aRequest) && $aRequest[0] == 'shop') {
		
		$bShop = true;
		
	}
	
	/*
	 * Subdomain
	 */
	
	$bSubdomain = false;
	
	if(!empty($aRequest) && ($aRequest[0] !== 'shop' && $aRequest[0] !== 'admin')) {
		
		$bSubdomain = true;
		
	}
	
	/*
	 * Don't show the parent page when editing a shop item
	 */
	
	if($sPageSlug == 'artikel-wijzigen') {
		
		$sParentPageName = '';
		
	}

	/*
	 * Build breadcrumb
	 */

	$sBreadcrumb = 
	'<div class="breadcrumb">
		
		<ol id="crumbs" itemscope itemtype="http://schema.org/BreadcrumbList">

			<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">
			
				<a itemprop="item" href="https://' . $sHost . ($bShop == true && !empty($sShopId) ? '/shop/' . $sShopId : ($bAdmin == true ? '/beheer' : '')) . '">
					
					<span itemprop="name">' . $sHome . '</span>
						
				</a>
				
				<meta itemprop="position" content="1" />
				
			</li>';	

			if(!empty($sParentPageName)) {

				$sBreadcrumb .=
				'<li class="delimiter">' . $sDelimiter . '</li>

				<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">';
				
					/*
					 * Build slug
					 */

					$aParentSlugs = [

						'admin'			=> $bAdmin, 
						'shop'			=> $bShop, 
						'parentSlug'	=> $sParentSlug, 
		
					];
				
					$sBreadcrumb .=
					'<a itemprop="item" href="https://' . $sHost . buildSlug($aParentSlugs) . '">
						
						<span itemprop="name">' . ucfirst($sParentPageName) . '</span>
							
					</a>
					
					<meta itemprop="position" content="2" />
							
				</li>';

			}
			
			if(!empty($sPageSlug)) {
				
				$sBreadcrumb .=
				'<li class="delimiter">' . $sDelimiter . '</li>

				<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">';
				
					$aPageSlugs = [

						'admin'			=> $bAdmin, 
						'shop'			=> $bShop, 
						'parentSlug'	=> $sParentSlug, 
						'pageSlug'		=> $sPageSlug, 
						'articleId'		=> $sArticleId, 
						'categoryId'	=> $sCategoryId, 
						'orderId'		=> $iOrderId, 
						'shopId'		=> $sShopId

					];
				
					$sBreadcrumb .=
					'<a itemprop="item" href="https://' . $sHost . buildSlug($aPageSlugs) . '">
						
						<span itemprop="name">' . str_replace('-', ' ', ucfirst($sPageName)) . '</span>
							
					</a>
					
					<meta itemprop="position" content="3" />
							
				</li>';

			}
			
		$sBreadcrumb .=
		'</ol>
		
	</div>';

	return $sBreadcrumb;

}

/*
 * Build slug
 * 
 * @return string
 */

function buildSlug($aSlugs) {	
	
	$sURL = '/';
	$sURL .= ($aSlugs['admin'] == true ? 'beheer/' : '');
	$sURL .= ($aSlugs['shop'] == true && !empty($aSlugs['shopId']) ? 'shop/' . $aSlugs['shopId'] . '/' : '');
	$sURL .= (!empty($aSlugs['parentSlug'])	? $aSlugs['parentSlug'] . '/' : '');
	$sURL .= (!empty($aSlugs['pageSlug'])	? $aSlugs['pageSlug'] . '/' : '');
	$sURL .= (!empty($aSlugs['articleId'])	? $aSlugs['articleId'] . '/' : '');
	$sURL .= (!empty($aSlugs['categoryId'])	? $aSlugs['categoryId'] . '/' : '');
	$sURL .= (!empty($aSlugs['orderId'])	? $aSlugs['orderId'] . '/' : '');
		
	return $sURL;
	
}