<?php

use Mijn\realmapi;

require_once dirname(__FILE__) . '/../../config/inc.config.php'; 

session_unset();

/* 
 * Verify the user that just came from the userportal 
 * and set the session based on the token that was sent
 */

$iUser	= !empty(filter_input(INPUT_GET, 'user')) ? (INT) filter_input(INPUT_GET, 'user') : '';
$sToken	= !empty(filter_input(INPUT_GET, 'token')) ? (string) filter_input(INPUT_GET, 'token') : '';

$oVerifyUser = new realmapi();
$oVerifyUser->setToken($sToken);
$oVerify = $oVerifyUser->verifyUser();

/*
 * If the result is true then we set the same sessions variables 
 * as in the OVIS userportal. So we can use them later on to 
 * keep verifying the user to check if his access is justified
 */

if($oVerify->result == true) {
	
	$_SESSION['adminRouteLoginUserId']	= $oVerify->userId;
	$_SESSION['ssoRouteLoginUserId']	= $oVerify->userId;
	$_SESSION['ssoRouteLoginToken']		= $sToken;
	
	header('Location: /');
	
	exit;
	
}

unset($_SESSION['adminRouteLoginUserId']);
unset($_SESSION['ssoRouteLoginUserId']);
unset($_SESSION['ssoRouteLoginToken']);

/*
 * Redirect if we can not find a valid token
 */

header('Location: https://www.ovis.nl');
	
exit;