<?php 

	use Mijn\realmapi;
	use Mijn\mijnovis;
	
	/*
	 * Config
	 * 
	 */
	 

	require_once dirname(__FILE__) . '/../config/inc.config.php';
	include_once(dirname(__FILE__) . '/include/inc.breadcrumb.php');

	/*
	 * GET variables
	 * 
	 */

	$sPage				= !empty(filter_input(INPUT_GET, 'page')) ? filter_input(INPUT_GET, 'page') : '';
	$sArticleId			= (empty(filter_input(INPUT_GET, 'articleid')) ? '' : filter_input(INPUT_GET, 'articleid'));
			
	if($sPage == 'login'){		
		include_once dirname(__FILE__) .  '/include/inc.verifyuser.php';
		exit;
	}
	$sToken			= !empty($_SESSION['ssoRouteLoginToken'])	? $_SESSION['ssoRouteLoginToken']	: false;
	$iUserId		= !empty($_SESSION['ssoRouteLoginUserId'])	? $_SESSION['ssoRouteLoginUserId']	: false;
	
	$oVerifyUser = new realmapi();
	$oVerifyUser->setToken($sToken);
	
	$oVerify = $oVerifyUser->verifyUser();
	
	if(!empty($oVerify) && $oVerify->result == false && ENVIRONMENT !== 'local') {
		header('Location: https://www.ovis.nl');	
		exit;		
	}
	
	$oMijnOVIS = new mijnovis();
	$oMijnOVIS->getUserData($iUserId);
	$oMijnOVIS->getUserLimits($iUserId);
	$sBaseURL = BASEURL;
	$bFrontPage = false;
	$bSubscription = false;
	$bIsAllowed = true;

	switch($sPage){
		case '':
			$sPageName = 'Uw verkoop voorraad';
			$sPageCatalogType = 'verkoop';
			$bFrontPage = true;
			
			include_once dirname(__FILE__) .  '/pages/page-verkoop.php';
			break;
			
		case 'uitloggen':
			$sPageName = 'Uitloggen';
			
			session_destroy();
			
			include_once dirname(__FILE__) .  '/pages/page-logout.php';
			break;
			
		case 'saldo':
			$sPageName = 'OVIS Saldo';
			
			include_once dirname(__FILE__) .  '/pages/page-saldo.php';
			break;
			
		case 'uitleg':
			$sPageName = 'Uitleg OVIS Mobiel';
			
			include_once dirname(__FILE__) .  '/pages/page-uitleg.php';
			break;
			
		case 'marktplaats':
			$sPageName = 'Marktplaats';
			
			include_once dirname(__FILE__) .  '/pages/page-marktplaats.php';
			break;
			
		case 'add':
			$sPageName = 'Advertentie aanmaken';
			
			include_once dirname(__FILE__) .  '/pages/page-add.php';
			break;
			
		case 'edit':
			$sPageName = 'Advertentie bewerken';
			
			if(empty($sArticleId)){
				
				header('Location: /');
				exit;
				
			} else {
			
				$oMijnOVIS->getDetails($iUserId,$sArticleId);
				
				if(empty($oMijnOVIS->_oDetailsData)){
					
					$oMijnOVIS->_bInvalidArticle = true;
					
					$sPageName = 'Artikel niet gevonden';
				
					include_once dirname(__FILE__) .  '/pages/article-notfound.php';
					
				} else {
				
					include_once dirname(__FILE__) .  '/pages/page-add.php';
					
				}
			}
			
			break;
			
		default:			
			
			$oMijnOVIS->_bInvalidPage = true;
			
			$sPageName = 'Pagina niet gevonden';
				
			include_once dirname(__FILE__) .  '/pages/page-notfound.php';
			
			break;
		
	}
	