<?php
	
	use Mijn\realmapi;
	use Mijn\mijnovis;
	
	require_once dirname(__FILE__) . '/../../config/inc.config.php';
	
	if(empty(filter_input_array(INPUT_POST))) {

		header('Location: /');
		
		exit;

	}
	
	$sToken			= !empty($_SESSION['ssoRouteLoginToken'])	? $_SESSION['ssoRouteLoginToken']	: false;
	$iUserId		= !empty($_SESSION['ssoRouteLoginUserId'])	? $_SESSION['ssoRouteLoginUserId']	: false;
	
	$oVerifyUser = new realmapi();
	$oVerifyUser->setToken($sToken);
	$oVerify = $oVerifyUser->verifyUser();	
	
	if(empty($oVerify) || $oVerify->result == false) {
		
		$oReturn = new stdClass();
		$oReturn->result = 'invalid-login';
		
		if(empty($oVerifyUser->_sToken)) {
			echo json_encode($oReturn);	
			exit;					
		}		
	}
	
	$sSubModule = !empty(filter_input(INPUT_POST, 'module')) ? (string) filter_input(INPUT_POST, 'module') : '';
	
	switch ($sSubModule) {
		case 'startDescriptionGeneration':
			
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseDescriptionGeneration($iUserId,'getDescription');	
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		case 'initDescriptionGeneration':
			
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseDescriptionGeneration($iUserId);	
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		case 'rotateImage':
			
			$sImage = !empty(filter_input(INPUT_POST, 'image')) ? (string) filter_input(INPUT_POST, 'image') : false;
			$sImageUrl = !empty(filter_input(INPUT_POST, 'imageUrl')) ? (string) filter_input(INPUT_POST, 'imageUrl') : false;
			$iArticleId = !empty(filter_input(INPUT_POST, 'articleId')) ? (string) filter_input(INPUT_POST, 'articleId') : false;
			
			if(empty($iArticleId) || substr($sImageUrl,0,12) == '/afbeelding/' ){
				
				$_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/';
				
				$bRotateOriginal = false;
				$bRotateThumb = false;
				
				if(file_exists($_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/thumb_'.$sImage.'.jpg')){
					$fileName = $_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/thumb_'.$sImage.'.jpg';
					$degrees = -90;
					
					$source = imagecreatefromjpeg($fileName);				 
					$rotate = imagerotate($source, $degrees, 0);				
					imagejpeg($rotate, $_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/thumb_'.$sImage.'.jpg',100);				
				
					$bRotateThumb = true;
				}
			
				if(file_exists($_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/original_'.$sImage.'.jpg')){
					$fileName = $_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/original_'.$sImage.'.jpg';
					$degrees = -90;
					
					$source = imagecreatefromjpeg($fileName);				 
					$rotate = imagerotate($source, $degrees, 0);				
					imagejpeg($rotate, $_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/original_'.$sImage.'.jpg',100);				
					
					$bRotateOriginal = true;
				}	

				if(!$bRotateOriginal && !$bRotateThumb){
					$oReturn = new \stdClass();
					$oReturn->result = false;
					$oReturn->errors = 'invalid-image';
				} else {
					$oReturn = new stdClass();
					$oReturn->httpResponseCode = 200;
					$oReturn->result = true;
					$oReturn->errors = false;
					$oReturn->imageID = $sImage;
					$oReturn->image = '/afbeelding/'.$sImage.'?'.date('U');
				}
				
			} else {
				$oMijnOVIS = new mijnovis();
				$oMijnOVIS->parseRotateImage($iUserId,$iArticleId,$sImage,$sImageUrl,date('U'));			
				$oReturn = $oMijnOVIS->_oAPIResult;
			}
						
			echo json_encode($oReturn);
			
			break;
		case 'autofillArticle':
		
			$sCategory = !empty(filter_input(INPUT_POST, 'category')) ? (string) filter_input(INPUT_POST, 'category') : false;
			$sLicense = !empty(filter_input(INPUT_POST, 'license')) ? (string) filter_input(INPUT_POST, 'license') : 'sale';
			
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->parseAutofillArticle($sCategory,$sLicense);
						
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		case 'autofillTemplate':
		
			$iTemplateId = !empty(filter_input(INPUT_POST, 'templateId')) ? (string) filter_input(INPUT_POST, 'templateId') : false;
			
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->parseAutofillTemplate($iTemplateId);
						
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		case 'saveArticle':
			
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseSaveArticle();	
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		default:
			
			break;
	}
?>