<?php
	
	use Mijn\realmapi;
	use Mijn\mijnovis;
	
	require_once dirname(__FILE__) . '/../../config/inc.config.php';
	
	if(empty(filter_input_array(INPUT_POST))) {

		header('Location: /');
		
		exit;

	}
	
	$sToken			= !empty($_SESSION['ssoRouteLoginToken'])	? $_SESSION['ssoRouteLoginToken']	: false;
	$iUserId		= !empty($_SESSION['ssoRouteLoginUserId'])	? $_SESSION['ssoRouteLoginUserId']	: false;
	
	$oVerifyUser = new realmapi();
	$oVerifyUser->setToken($sToken);
	$oVerify = $oVerifyUser->verifyUser();	
	
	if(empty($oVerify) || $oVerify->result == false) {
		
		$oReturn = new stdClass();
		$oReturn->result = 'invalid-login';
		
		if(empty($oVerifyUser->_sToken)) {
			echo json_encode($oReturn);	
			exit;					
		}		
	}
	
	$sSubModule = !empty(filter_input(INPUT_POST, 'module')) ? (string) filter_input(INPUT_POST, 'module') : '';
	$sDepartment = !empty(filter_input(INPUT_POST, 'department')) ? (string) filter_input(INPUT_POST, 'department') : 'sale';
	$sBrand = !empty(filter_input(INPUT_POST, 'brand')) ? (string) filter_input(INPUT_POST, 'brand') : '';
	
	switch ($sSubModule) {
		case 'getVersions':
		
			$sVersionsCategory = !empty(filter_input(INPUT_POST, 'versionsCategory')) ? (string) filter_input(INPUT_POST, 'versionsCategory') : '';
			$sVersionsBrand = !empty(filter_input(INPUT_POST, 'versionsBrand')) ? (string) filter_input(INPUT_POST, 'versionsBrand') : '';
			$sVersionsModel = !empty(filter_input(INPUT_POST, 'versionsModel')) ? (string) filter_input(INPUT_POST, 'versionsModel') : '';
		
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseGetVersions($iUserId,$sDepartment,$sVersionsCategory,$sVersionsBrand,$sVersionsModel);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		
		
			break;
		case 'getPhotoLabels':
		
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseGetPhotoLabels($iUserId,$sDepartment);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		
		case 'getCategories':
		
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseGetCategories($iUserId,$sDepartment);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		
		case 'getBrands':
		
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseGetBrands($iUserId,$sDepartment);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		
		case 'getArticles':
		
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->parseGetArticles($iUserId,$sDepartment);
			
			$oReturn = new stdClass();
			$oReturn->result = empty($oMijnOVIS->_oAPIResult) ? 'no-data' : true;
			$oReturn->articles = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		case 'getAccessories':
		
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseGetAccessories($iUserId,$sDepartment);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		case 'getDivisions':
		
			$oMijnOVIS = new mijnovis();
			$oMijnOVIS->getUserData($iUserId);
			$oMijnOVIS->parseGetDivisions($iUserId,$sDepartment);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		default:
			
			break;
	}
?>