<?php
	
	use Mijn\realmapi;
	use Mijn\mijnovis;
	
	require_once dirname(__FILE__) . '/../../config/inc.config.php';
	
	if(empty(filter_input_array(INPUT_POST))) {

		header('Location: /');
		
		exit;

	}
	
	$sToken			= !empty($_SESSION['ssoRouteLoginToken'])	? $_SESSION['ssoRouteLoginToken']	: false;
	$iUserId		= !empty($_SESSION['ssoRouteLoginUserId'])	? $_SESSION['ssoRouteLoginUserId']	: false;
	
	$oVerifyUser = new realmapi();
	$oVerifyUser->setToken($sToken);
	$oVerify = $oVerifyUser->verifyUser();	
	
	if(empty($oVerify) || $oVerify->result == false) {
		
		$oReturn = new stdClass();
		$oReturn->result = 'invalid-login';
		
		if(empty($oVerifyUser->_sToken)) {
			echo json_encode($oReturn);	
			exit;					
		}		
	}
	
	$sSubModule = !empty(filter_input(INPUT_POST, 'module')) ? (string) filter_input(INPUT_POST, 'module') : '';
	
	switch ($sSubModule) {
		case 'featureMarktplaatsAd':
		
			$iArticle = !empty(filter_input(INPUT_POST, 'article')) ? (int) filter_input(INPUT_POST, 'article') : '';
			$sFeature = !empty(filter_input(INPUT_POST, 'feature')) ? filter_input(INPUT_POST, 'feature') : '';
			
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->featureOVISMarktplaatsArticle($iUserId,$iArticle,$sFeature);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
		
		case 'getMarktplaatsStatus':
			
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->getOVISMarktplaatsStatus($iUserId);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		case 'deleteMarktplaatsAd':
			
			$iArticle = !empty(filter_input(INPUT_POST, 'article')) ? (int) filter_input(INPUT_POST, 'article') : '';
			
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->deleteOVISMarktplaatsArticle($iUserId, $iArticle);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		case 'addMarktplaatsAd':
			
			$iArticle = !empty(filter_input(INPUT_POST, 'article')) ? (int) filter_input(INPUT_POST, 'article') : '';
			$bAutoreplace = !empty(filter_input(INPUT_POST, 'autoreplace')) ? filter_input(INPUT_POST, 'autoreplace') : '';
			
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->addOVISMarktplaatsArticle($iUserId, $iArticle, $bAutoreplace);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		case 'getMarktplaatsArticleStatus':
			
			$iArticle = !empty(filter_input(INPUT_POST, 'article')) ? (int) filter_input(INPUT_POST, 'article') : '';
			
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->getOVISMarktplaatsArticleStatus($iUserId, $iArticle);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		default:
			
			break;
	}