<?php
	
	use Mijn\realmapi;
	use Mijn\mijnovis;
	
	require_once dirname(__FILE__) . '/../../config/inc.config.php';
	
	if(empty(filter_input_array(INPUT_POST))) {

		header('Location: /');
		
		exit;

	}
	
	$sToken			= !empty($_SESSION['ssoRouteLoginToken'])	? $_SESSION['ssoRouteLoginToken']	: false;
	$iUserId		= !empty($_SESSION['ssoRouteLoginUserId'])	? $_SESSION['ssoRouteLoginUserId']	: false;
	
	$oVerifyUser = new realmapi();
	$oVerifyUser->setToken($sToken);
	$oVerify = $oVerifyUser->verifyUser();	
	
	if(empty($oVerify) || $oVerify->result == false) {
		
		$oReturn = new stdClass();
		$oReturn->result = 'invalid-login';
		
		if(empty($oVerifyUser->_sToken)) {
			echo json_encode($oReturn);	
			exit;					
		}		
	}
	
	$sSubModule = !empty(filter_input(INPUT_POST, 'module')) ? (string) filter_input(INPUT_POST, 'module') : '';
	
	switch ($sSubModule) {
		case 'getOrderStatus':
			
			$iOrder = !empty(filter_input(INPUT_POST, 'order')) ? (int) filter_input(INPUT_POST, 'order') : '';
		
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->getOVISSaldoOrderStatus($iUserId,$iOrder);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		case 'getSaldo':
		
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->getOVISSaldo($iUserId);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		case 'createPayment':
			
			$iAmount = !empty(filter_input(INPUT_POST, 'amount')) ? (int) filter_input(INPUT_POST, 'amount') : '';
			$sAgreement = !empty(filter_input(INPUT_POST, 'agreement')) ? (string) filter_input(INPUT_POST, 'agreement') : '';
		
			$oMijnOVIS = new mijnovis();			
			$oMijnOVIS->createPaymentOVISSaldo($iUserId, $iAmount, $sAgreement);
			
			$oReturn = $oMijnOVIS->_oAPIResult;
						
			echo json_encode($oReturn);
			
			break;
			
		default:
			
			break;
	}