<?php
	use Mijn\realmapi;
	use Mijn\mijnovis;
	
	require_once dirname(__FILE__) . '/../../config/inc.config.php';
		
	/*
	 * You're in the wrong neighbourhood
	 */

	if(empty(filter_var_array($_FILES))) {

		header("HTTP/1.1 400 Bad Request");
		
		header('Location: /');
		
		exit;

	}
	
	$sToken			= !empty($_SESSION['ssoRouteLoginToken'])	? $_SESSION['ssoRouteLoginToken']	: false;
	$iUserId		= !empty($_SESSION['ssoRouteLoginUserId'])	? $_SESSION['ssoRouteLoginUserId']	: false;
	
	$oVerifyUser = new realmapi();
	$oVerifyUser->setToken($sToken);
	$oVerify = $oVerifyUser->verifyUser();	
	
	if(empty($oVerify) || $oVerify->result == false) {
		
		$oReturn = new stdClass();
		$oReturn->result = 'invalid-login';
		
		if(empty($oVerifyUser->_sToken)) {
			echo json_encode($oReturn);	
			exit;					
		}		
	}
	
	$files = array();
	$files['files'] = array();

	$sSessionID = session_id();
	$sImageHash = bin2hex(openssl_random_pseudo_bytes(32));
	$aAllowedFileTypes = explode(',','jpg,jpeg,png');
		
	$aFile = $_FILES['file'];
		
	$name = $aFile['name'];
	$type = $aFile['type'];
	$tempName = $aFile['tmp_name'];
	$error = $aFile['error'];
	$size = $aFile['size'];
	$ext = pathinfo($name, PATHINFO_EXTENSION);
	
	$sError = false;
	$sThumbPath = '';

	if($error == '1' || $size == '0'){
		$aFileData = array();
		$aFileData['name'] = ('Upload error');
		$aFileData['size'] = $size;
		$aFileData['errortype'] = 'general';
		$aFileData['error'] = ('Er is iets fout gegaan');
		
		$sError = 'some-thing-went-wrong';

		$files['files'] = $aFileData;
	} elseif(!in_array(strtolower($ext),$aAllowedFileTypes)) {
		$aFileData = array();
		$aFileData['name'] = ('Upload error');
		$aFileData['size'] = $size;
		$aFileData['errortype'] = 'filetype';
		$aFileData['error'] = ('Bestandstype niet toegestaan');
		
		$sError = 'filetype-not-allowed';

		$files['files'] = $aFileData;
	} elseif($size > 20000000){
		$aFileData = array();
		$aFileData['name'] = ('Upload error');
		$aFileData['size'] = $size;
		$aFileData['errortype'] = 'filesize';
		$aFileData['error'] = ('Bestand te groot (max. 5Mb)');
		
		$sError = 'file-to-big';

		$files['files'] = $aFileData;
	} else {
		
		if(!is_dir($_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId)){
			mkdir($_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId, 0777);				
			chmod($_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId, 0777);
		}
		
		$iInsertItemID = 0;
		while($iInsertItemID==0){
			$sGeneratedFileHash = bin2hex(openssl_random_pseudo_bytes(32));

			$sNewFilePath = $_SERVER['DOCUMENT_ROOT'].'/../image_upload/'.$iUserId.'/';
			$sNewFileName = 'uploaded_'.$sSessionID.'_'.$sImageHash.'_'.$sGeneratedFileHash.'.'.$ext;

			$sOriginalDestination = 'original_'.$sSessionID.'_'.$sImageHash.'_'.$sGeneratedFileHash.'.jpg';
			$sThumbPath = $sSessionID.'_'.$sImageHash.'_'.$sGeneratedFileHash;
			$sThumbDestination = 'thumb_'.$sSessionID.'_'.$sImageHash.'_'.$sGeneratedFileHash.'.jpg';

			if(!file_exists($sNewFilePath.$sNewFileName)){
				$iInsertItemID = 1;
			}
		}
		
		move_uploaded_file($tempName, $sNewFilePath.$sNewFileName);			
		chmod($sNewFilePath.$sNewFileName,0777);

		$oMijnOVIS = new mijnovis();
		
		if($oMijnOVIS->createThumb($sNewFileName,$sThumbDestination,$sNewFilePath)){
			if($oMijnOVIS->createImage($sNewFileName,$sOriginalDestination,$sNewFilePath)){				
				unlink($sNewFilePath.$sNewFileName);
			}
		}		

		$sHomeUrl = '';
		$sHomeUrl = str_replace('/cms','', $sHomeUrl);

		$aFileData = array();
		$aFileData['name'] = ('Upload succesvol');
		$aFileData['size'] = $size;
		$aFileData['uniqueImage'] = $sSessionID.'_'.$sImageHash.'_'.$sGeneratedFileHash;
		$aFileData['url'] = $sHomeUrl .'/imginruil_tmp/'.$sThumbDestination;

		$files['files'] = $aFileData;
	}
	
	$oImage = new stdClass();
	if(!empty($sError)){
		$oImage->errors = $sError;
	}
	$oImage->url = $sThumbPath;
	
	header('Content-Type: application/json');
	echo json_encode($oImage,JSON_UNESCAPED_SLASHES);
	exit;
	
	
	
	
	
	
 

?>